<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('servers')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?='blukrypts'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('List of Servers', 'keywords')?></h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <?=
                            Form::open(array(
                                'csrf' => $data['csrf_token'],
                                'class' => 'filterForm',
                                'autocomplete' => 'off',
                                'ng-submit' => 'saveBlukrypt(blukrypt)',
                                'data-parsley-validate' => true
                            ));
                        ?>
                        <div class="form-group col-lg-6">
                            <label for="serverName"><?=Language::show('Server Name', 'keywords');?></label>
                            <input type="text" class="form-control" ng-model="serverName" name="serverName" id="serverName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Server Name', 'keywords');?>" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="ipAddress"><?=Language::show('Server IP Address', 'keywords');?></label>
                            <input type="text" class="form-control" ng-model="ipAddress" name="ipAddress" id="ipAddress" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Server Ip Address', 'keywords');?>" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-12">
                            <select class="form-control serverType" ng-model="serverType"  name="serverType" id="serverType" required="" title='Select the Server Type'>
                                <option value="files">Files Server</option>
                                <option value="database">Database Server</option>
                            </select>
                        </div>
                        <div class="form-group col-lg-12">
                            <select class="scripts" style="width: 100%;" id="scripts" data-parsley-trigger="change" multiple>
                                <option value="turnOfMachine.sh">turnOfMachine.sh</option>
                                <option value="restartMachine.sh">restartMachine.sh</option>
                            </select>
                        </div>
                        <div class="scriptsPrePost col-lg-12">

                        </div>
                        <div class="form-group col-lg-12">
                            <a type="submit" class="submit btn btn-primary pull-right drop-box"
                               ngf-select="uploadScript($files)">
                                <?=Language::show('Upload a Script', 'keywords');?>
                            </a>
                            <button type="submit" style="margin-right: 5px;" class="submit btn btn-success pull-right"><?=Language::show('save', 'keywords');?></button>
                        </div>
                        <?= Form::close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.scripts').select2({
        placeholder: 'Select Scripts'
    });

    $('#prePost').selectpicker('render');
    $('#serverType').selectpicker('render');

    $('.scripts').on('change', function(){
        var scriptsVal = $('.scripts').val();
        if(scriptsVal != null){
            var prePostBloc = '<div class="col-lg-6" style="border: 1px solid #cccccc;">';
            prePostBloc += '<h4>'+scriptsVal[(scriptsVal.length-1)]+'</h4>';
            prePostBloc += '<div class="radio radio-primary">';
            prePostBloc += '<input id="execTypePre'+scriptsVal[(scriptsVal.length-1)]+'" name="execType'+scriptsVal[(scriptsVal.length-1)]+'" type="radio" value="pre">';
            prePostBloc += '<label for="execTypePre'+scriptsVal[(scriptsVal.length-1)]+'"><?=Language::show('Execute Post Backup', 'keywords');?></label>';
            prePostBloc += '<input id="execTypePost'+scriptsVal[(scriptsVal.length-1)]+'" name="execType'+scriptsVal[(scriptsVal.length-1)]+'" type="radio" value="post">';
            prePostBloc += '<label for="execTypePost'+scriptsVal[(scriptsVal.length-1)]+'"><?=Language::show('Execute Pre Backup', 'keywords');?></label>';
            prePostBloc += '</div>';
            prePostBloc += '</div>';
            $('.scriptsPrePost').show();
            $('.scriptsPrePost').append(prePostBloc)
        }else{
            $('.scriptsPrePost').hide();
        }
    });

</script>