<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.5.3
* @date 20/01/2020
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('dashboard')?>"><?='Dashboard'?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
            </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='usersWithoutDevices'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h3><?=$data['crumb1']?></h3>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                              <form ng-submit="usersWithoutDevicesView(search.searchPolicyName)">
                                    <div class="row">
                                        <div class="col-lg-3" id="policy">
                                        <label for='searchPolicyName'>Policy Name</label>
                                        <select class="form-control selectPicker" id="searchPolicyName" name="searchPolicyName[]" id="searchPolicyName" title='Select Backup Policy Name' multiple data-selected-text-format="count>4">
                                            <option value="all" selected="selected">all</option>
                                                            <?php if(!empty($data['backupPolicies'])){ ?>
                                                                <?php foreach($data['backupPolicies'] as $value){
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                                <option value="<?=$value?>"><?=$label?></option>
                                                                <?php } ?>
                                                            <?php } ?>
                                                        </select>
                                        </div>
                                        <div class="col-lg-3">
                                            <label for='productTypeReport'>Product Type</label>
                                            <select class="form-control" name="productTypeReport" id="productTypeReport" title='Select Product Type' >
                                                <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                                                    <option value="backup">Backup</option>
                                                <?php } ?>
                                                <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                                                    <option value="sync">Sync</option>
                                                <?php } ?>
                                                <?php if($_SESSION['exchange_backup_enabled'] == 'true'){?>
                                                    <option value="mail">Mail</option>
                                                <?php } ?>
                                                <?php if($_SESSION['one_drive_backup_enabled'] == 'true'){?>
                                                    <option value="oneDrive">OneDrive</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                        <div class="col-lg-3" style="margin-top:25px;">
                                            <input class="showBlockedDevices" id="showBlockedDevices" type="checkbox" name="showBlockedDevices" checked>
                                            <label for="showBlockedDevices">Include blocked devices</label><br>
                                         </div>
                                        <!--<div class="col-lg-3">
                                            <button style="margin-top: 25px" type="submit" class="btn tbn-default">View</button>
                                            <a ng-click="downloadOverview(search.userName, search.deviceName, search.searchPolicyName)" style="margin-top: 25px" class="btn btn-default">Download</a>
                                        </div>-->
                                        <div class="dropdown col-lg-3">
                                            <button style="margin-top: 25px" type="submit" class="btn tbn-default">View</button>
<a class="btn btn-default" ng-click="downloadUsersWithoutDevicesExcel(search.searchPolicyName)" style="margin-top: 25px">Download Excel</a>
<!--                                            <button style="margin-top: 25px" class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                                <span class="caret"></span>
                                              </button>
                                              <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li><a ng-click="downloadOverview(search.userName, search.deviceName, search.searchPolicyName)">Excel</a></li>
                                                <li><a ng-click="downloadOverviewPdf(search.userName, search.deviceName, search.searchPolicyName)">PDF</a></li>
                                                                                              </ul>-->
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="table-responsive">
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <table class="table table-bordered table-striped usersWithoutDevices col-lg-12" style="display: none;">
                            <div class="h4 nousersWithoutDevices text-center" style="display: none;">No details found</div>
                            <colgroup>
                                    <col class="col-xs-3">
                                    <col class="col-xs-3">
                                    <col class="col-xs-3">
                                </colgroup>
                            <thead>
                            <tr>
<th class="text-left clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left clickAble" ng-click="sortType = 'displayName'; sortReverse = !sortReverse">
                                    <?=Language::show('displayName', 'keywords')?>
                                    <span ng-show="sortType == 'displayName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'displayName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left clickAble" ng-click="sortType = 'emailId'; sortReverse = !sortReverse">
                                    <?=Language::show('email_address', 'keywords')?>
                                    <span ng-show="sortType == 'emailId' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'emailId' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left clickAble" ng-click="sortType = 'timeinmillis'; sortReverse = !sortReverse">
                                    <?=Language::show('Last Modified Time', 'keywords')?>
                                    <span ng-show="sortType == 'timeinmillis' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'timeinmillis' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in usersWithoutDevices | orderBy:overviewSortType:sortReverse">
<td ng-cloak  title="{{value.userName}}">{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                <td ng-cloak ng-if="value.displayName"  title="{{value.displayName}}">{{ value.displayName | limitTo:20}}{{value.displayName.length > 20 ? '...' : ''}}</td>
                                <td ng-cloak ng-if="!value.displayName"  title="{{value.displayName}}"> - </td>
                                <td ng-cloak>{{ value.emailId }}</td>
                                <td ng-cloak>{{ value.time }}</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    </div>
                    <div class="row loadMore" style="display: none;">
                    <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, 'overview')">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
