<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <ol class="breadcrumb">
                    <?php if(\Helpers\Auth::checkUserPermission('admin')){ ?>
                        <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                    <?php }else{ ?>
                        <li><h3><?=$data['title']?></h3></li>
                    <?php } ?>
                    <li><a href="<?=Url::basePath('myAccount/'.$data['currentUser'])?>"><?=$data['crumb1']?></a></li>
                    <li><span>Backup Activity Summary</span></li>
                </ol>
            </div>
            <div class="col-lg-6 hide">
                <?php View::renderTemplate('partials/createButton', $data)?>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="HistoryController">
        <span class="hide token"><?=$data['csrf_token']?></span>
        <span class="hide currentPage"><?='deviceBackupHistory'?></span>
        <span class="hide currentOs"><?=$data['os']?></span>
        <div class="row profile">
            <div class="col-lg-1 col-md-1 col-sm-1">
                <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
            </div>
            <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=Language::show('backup_activity_history', 'keywords')?></h4>
                    </div>
                    <div class="panel-body" style="padding: 0px 10px 10px 10px;">
                        <div class="table-responsive">
                            <!--<hr/>
                            <div>Summary - Total Number of Files : <span class="text-info">{{ summary.totalNoOfFiles }}</span>, Files to be backed up :  <span class="text-danger">{{ summary.noOfFilesToBeUploaded }}</span>, Percentage Completed : <span class="text-success">{{ summary.completedPercentage }}</span></div>
                            <hr/>-->
                            <div class="h4 loading text-center">Loading.....</div>
                            <table class="table table-bordered table-striped deviceHistoryTable" style="display: none;">
                                <!--<colgroup>
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-1">
                                    <col class="col-xs-1">
                                    <col class="col-xs-1">
                                    <col class="col-xs-1">
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                </colgroup>-->
                                <thead>
                                    <tr>
                                        <th class="text-left clickAble" ng-click="sortType = 'startTime'; sortReverse = !sortReverse">
                                            <?=Language::show('start_time', 'keywords')?>
                                            <span ng-show="sortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'endTimeLong'; sortReverse = !sortReverse">
                                            <?=Language::show('end_time', 'keywords')?>
                                            <span ng-show="sortType == 'endTimeLong' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'endTimeLong' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'totalFile'; sortReverse = !sortReverse">
                                            <?=Language::show('attempted', 'keywords')?>
                                            <span ng-show="sortType == 'totalFile' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'totalFile' && sortReverse" class="fa fa-caret-down"></span>
        				                </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'totalNumberOfFiles'; sortReverse = !sortReverse">
                                            <?=Language::show('Total Items', 'keywords')?>
                                            <span ng-show="sortType == 'totalNumberOfFiles' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'totalNumberOfFiles' && sortReverse" class="fa fa-caret-down"></span>
        				                </th>
        				                <th class="text-left clickAble" ng-click="sortType = 'percentage'; sortReverse = !sortReverse">
                                            <?=Language::show('success', 'keywords')?>
                                            <span ng-show="sortType == 'percentage' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'percentage' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
        				                <th class="text-left clickAble" ng-click="sortType = 'failed'; sortReverse = !sortReverse">
                                            <?=Language::show('failed', 'keywords')?> 
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="Click on the number below to view failed files details"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                            <span ng-show="sortType == 'failed' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'failed' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
        				                <th class="text-left clickAble" ng-click="sortType = 'comments'; sortReverse = !sortReverse">
                                            <?=Language::show('comments', 'keywords')?>
                                            <span ng-show="sortType == 'comments' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'comments' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'startTime'; sortReverse = !sortReverse">
                                            <?=Language::show('Detailed Analysis', 'keywords')?>
                                            <span ng-show="sortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                            <span ng-show="sortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in history | orderBy:sortType:sortReverse">
                                    <td ng-cloak>{{ value.startTime }}</td>
                                    <td ng-if="value.status !='HIDE'" ng-cloak>{{ value.endTime }}</td>
                                    <td ng-if="value.status =='HIDE'" ng-cloak>-</td>
                                    <td><span class="text-info" ng-cloak>{{ value.totalFile }}</span></td>
                                    <td><span class="text-info" ng-cloak>{{ value.totalNumberOfFiles }}</span></td>
                                    <!--<td><span class="text-success clickAble" ng-click="showHistoryDetails(value.batchId, 'Uploaded', value.percentage)" ng-cloak>{{ value.percentage }}</span></td>
                                    <td><span class="text-danger clickAble" ng-click="showHistoryDetails(value.batchId, 'Failed', value.failed)" ng-cloak>{{ value.failed }}</span></td>-->
                                    <td><span class="text-success" ng-cloak>{{ value.percentage }}</span></td>
                                    <td ng-show="value.failed != 0" ng-cloak><a class="toolTip" data-toggle="tooltip" data-placement="top" href="" title="Failed files list" ng-click="downloadLogFile('<?=$data['deviceUUID']?>',value.batchId)" class="text-danger" ng-cloak>{{ value.failed }}</a></td>
                                    <td style="color:#EC6621;" ng-show="value.failed == 0" ng-cloak>{{ value.failed }}</td>
                                    <td ng-cloak>{{ value.comments }}</td>
                                    <td ng-show="value.attemptIsThere == true" ><a href="" ng-click="showDetailedAnalysis(value.batchId)" class="text-danger" ng-cloak>Show Details</a></td>
                                    <td ng-show="value.attemptIsThere != true" ng-cloak> - </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="row deviceHistoryTable" style="display: none;">
                            <div class="col-lg-12 text-center">
                                <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                                <a class="btn btn-primary first" ng-click="updateDeviceBackupHistoryNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                                <a class="btn btn-primary previous" ng-click="updateDeviceBackupHistoryNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                                <a class="btn btn-primary next" ng-click="updateDeviceBackupHistoryNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                                <a class="btn btn-primary last" ng-click="updateDeviceBackupHistoryNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade detailedAnalysis" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Detailed Analysis</h4>
                        </div>
                        <div class="modal-body">
                        <!--tableresponsive-->
                            <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>Start Time</th>
                                                <th>End Time</th>
                                                <th>Total No Of Files Uploaded</th>
                                                <th>Uploaded Size</th>
                                                <th>Percentage Completed</th>
                                                <th>Status</th>
                                                <th>Reason</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="value in batchElements">
                                                <td ng-cloak>{{ value.startTime }}</td>
                                                <td ng-cloak>{{ value.endTime }}</td>
                                                <td ng-cloak>{{ value.totalNoOfFiles }}</td>
                                                <td ng-cloak>{{ value.uploadedSize }}</td>
                                                <td ng-cloak>{{ value.uploadedPercentage }}</td>
                                                <td ng-cloak>{{ value.status }}</td>
                                                <td ng-cloak>{{ value.comments }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
        </div>
        <div class="modal fade backupHistoryDetailsModal whiteAndBigModal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Backup History Details</h4>
                    </div>
                    <div class="modal-body">
                        <div class="table-responsive" style="margin-top: -20px;">
                            <hr/>
                            <div class="h4 loading text-center">Loading.....</div>
                            <table class="table table-bordered table-striped deviceHistoryDetailsTable" style="display: none;">
                                <colgroup>
                                    <col class="col-xs-3">
                                    <col class="col-xs-6">
                                    <col class="col-xs-2">
                                    <col class="col-xs-1">
                                </colgroup>
                                <thead>
                                <tr>
                                    <th><?=Language::show('file_name', 'keywords')?></th>
                                    <th><?=Language::show('file_path', 'keywords')?></th>
                                    <th><?=Language::show('file_size', 'keywords')?></th>
                                    <th><?=Language::show('status', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in historyDetails | filterStatusType:historyDetailsType">
                                    <td ng-cloak>{{ value.fileName }}</td>
                                    <td ng-cloak>{{ value.filePath }}</td>
                                    <td><span class="text-info" ng-cloak>{{ value.size }}</span></td>
                                    <td ng-cloak>{{ value.status }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer" style="z-index: 10000000000;">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/HistoryController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
$("[data-toggle=tooltip]").tooltip({
    placement: $(this).data("placement") || 'top'
});
</script>
