<?php

namespace Controllers;

use Core\Language;
use Core\View;
use Core\Controller;
use Helpers\Auth;
use Helpers\Url;
use Models\Settings;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class SettingsController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('settings');
        $this->_model = new Settings();
        //Auth::allowOnly('admin');
    }

    /**
     * Display for my account details
     */
    public function dashboard(){
        $onedriveBkpEnabled = 'false';
        if($this->session->get('onedriveBkpEnabled') == true){
            $onedriveBkpEnabled = 'true';
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('dashboard'),
            'active' => 'settings',
            'onedriveBkpEnabled' => $onedriveBkpEnabled,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'isLdapEnabled' => $this->session->get('isLdapEnabled'),
            'isAADEnabled' => $this->session->get('isAADEnabled')
        );
	    
	if($this->session->get('graphApiEnabled') == 'true' && STORAGE_TYPE == "ONE_DRIVE"){
		$showCC = 'false';
		if(Auth::checkCloudPermission('backup') && !Auth::checkCloudPermission('office365')){
			$showOffice = 'true';
		}
		if(!Auth::checkCloudPermission('backup') && Auth::checkCloudPermission('office365')){
			$showOffice = 'true';
		}
		if(Auth::checkCloudPermission('backup') && Auth::checkCloudPermission('office365')){
			$showOffice = 'true';
		}
	}else{
		$showCC = 'true';
		if(Auth::checkCloudPermission('backup') && !Auth::checkCloudPermission('office365')){
			$showOffice = 'false';
		}
		if(!Auth::checkCloudPermission('backup') && Auth::checkCloudPermission('office365')){
			$showOffice = 'true';
		}
		if(Auth::checkCloudPermission('backup') && Auth::checkCloudPermission('office365')){
			$showOffice = 'true';
		}
	}

	$data['showCC'] = $showCC;
	$data['showOffice'] = $showOffice;

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/dashboard', $data);
        View::renderTemplate('footer', $data);
    }

    /**
     * Display for my account details
     */
    public function email(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('emailConfiguration'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/email', $data);
        View::renderTemplate('footer', $data);
    }

    public function writeToMailConfig(){
        if(!empty($_POST['hostName']) && !empty($_POST['portNumber']) && !empty($_POST['fromName']) && !empty($_POST['emailUsername']) && !empty($_POST['emailPassword'])){
            $values = htmlentities($_POST['hostName']).' '.htmlentities($_POST['portNumber']).' '.htmlentities($_POST['fromName']).' '.htmlentities($_POST['emailUsername']).' '.$_POST['emailPassword'];
            $scriptOutput = shell_exec('sh /var/lib/parablusys/bin/mailoverwrite.sh '.$values);
            $this->log('scriptOutput' . json_encode($scriptOutput), 'info');
            $data = array(
                'result'=>'success',
                'msg' => 'Details has been successfully saved'
            );
            echo json_encode($data);
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }
    
    public function office365Settings(){
        $userDetails = $this->_model->getUserDetails(array('token' => $this->session->get('token')), $this->session->get("userName"));
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token')
        );
        
        $onedriveBkpEnabled = 'false';
        if($this->session->get('onedriveBkpEnabled') == true){
            $onedriveBkpEnabled = 'true';
        }

        $data = array(
            'title' => $this->language->get('indexPageName'),
             'crumb1' => 'Office 365 Settings',
            'active' => 'settings',
            'userDetails' => $userDetails['body'],
            'onedriveBkpEnabled' => $onedriveBkpEnabled,
            'loggedInUser' => $this->session->all(),
            'csrf_token' => $this->setCSRFToken(),
            'storageType' => 'GoogleDrive',
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/office365Settings', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function blukryptSettings(){
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token')
        );
        $result = $this->_model->getBlukryptSettings($headers);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => 'Office 365 Backup Settings',
            'crumb2' => 'Agent Settings',
            'active' => 'settings',
            'proxy' => $result['body']->{'MSAppBluKryptElementList'},
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/blukryptSettings', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function getAllOneDriveControllerSettings(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
        $controllers = [];
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token')
        );
        $result = $this->_model->getBlukryptSettings($headers);
        $this->log($result);
        switch ($result['status']) {
            case (200):
                if(!empty($result['body']->{'MSAppBluKryptElementList'})){
                    foreach($result['body']->{'MSAppBluKryptElementList'} as $value){
                        $controllers = array_merge(array($value), $controllers);
                    }
                }
                $response = array(
                    'result' => 'success',
                    'controllers' => $controllers,
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function saveBlukryptSettings(){
        if (!empty($_POST['host']) && !empty($_POST['port'])) {
        $this->log("inside saveBlukeyptSettings","info");
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token')
            );
            $details = array(
                'name' => "",
                'host' => trim($_POST['host']),
                'port' => trim($_POST['port']),
            );
                        $this->log("POSTtTTTT : ".json_encode($details),"info");
                        $result = $this->_model->saveBlukryptSettings($headers, $details);
            switch ($result['status']) {
                case (200):
                    $data = array(
                        'result' => 'success',
                        'msg' => 'Details has been successfully saved'
                    );
                    echo json_encode($data);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                    'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        } else {
            $data = array(
                "post" => $_POST,
                'result' => 'error',
                'msg' => 'None of the field listed should be empty'
            );
            echo json_encode($data);
        }

    }

    public function saveEditBlukryptSettings(){
        if (!empty($_POST['edithost']) && !empty($_POST['editport'])) {
        $this->log("inside saveBlukeyptSettings","info");
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token')
            );
            $details = array(
                'name' => "",
                'host' => trim($_POST['edithost']),
                'port' => trim($_POST['editport']),
            );
                        $this->log("POSTtTTTT : ".json_encode($details),"info");
            $result = $this->_model->saveBlukryptSettings($headers, $details);
            switch ($result['status']) {
                case (200):
                    $data = array(
                        'result' => 'success',
                        'msg' => 'Details has been successfully saved'
                        );
                    echo json_encode($data);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                $result = array(
                    'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        } else {
            $data = array(
                "post" => $_POST,
                'result' => 'error',
                'msg' => 'None of the field listed should be empty'
            );
            echo json_encode($data);
        }

    }


    public function oneDriveSettings(){
        $userDetails = $this->_model->getUserDetails(array('token' => $this->session->get('token')), $this->session->get("userName"));
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token')
        );

        $result = $this->_model->getOneDriveDetails($headers);
	$this->log("RESULTTTT : ".json_encode($result),"info");
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => 'Office 365 Settings',
            'crumb2' => 'Tenant Settings',
            'active' => 'settings',
            'userDetails' => $userDetails['body'],
            'loggedInUser' => $this->session->all(),
            'csrf_token' => $this->setCSRFToken(),
            'storageType' => 'GoogleDrive',

            'clientID'=> $result["body"]->{"clientId"},
            'clientRedirectURI'=> $result["body"]->{"clientRedirectURI"},
            'portalURL'=> $result["body"]->{"portalURL"},
            'clientSecretKey'=> $result["body"]->{"clientSecretKey"},
            'clientResourceURL'=> $result["body"]->{"clientResourceURL"},
            'clientTokenURL'=> $result["body"]->{"clientTokenURL"},
            'configId'=> $result["body"]->{"configId"},
	    'tenantId'=> $result["body"]->{"tenantId"},
	    'user_principal' => $result["body"]->{"accountId"},
	    'tokenMapped' => $result['header']->{'container'}['tokenMapped'],
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/oneDriveSettings', $data);
        View::renderTemplate('footer', $data);
    }

    public function writeOneDriveSettings(){
     if (!empty($_POST['clientId']) && !empty($_POST['clientSecret']) && !empty($_POST['clientRedirectURI']) && !empty($_POST['clientResourceURL']) && !empty($_POST['tenantId']) && !empty($_POST['portalURL'])) {

            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token')
            );
            $this->log("TENANTID : ".$_POST['tenantId'],"info");
            $odbDetails = array(
                'clientId' => trim($_POST['clientId']),
                'configId' => trim($_POST['configId']),
                'clientSecretKey' => trim($_POST['clientSecret']),
                'clientRedirectURI' => trim($_POST['clientRedirectURI']),
                'clientResourceURL' => trim($_POST['clientResourceURL']),
                'clientTokenURL' => trim($_POST['clientTokenURL']),
                'tenantId' => trim($_POST['tenantId']),
                'portalURL' => trim($_POST['portalURL'])
            );
            $this->log("POSTtTTTT : ".json_encode($odbDetails),"info");
            $result = $this->_model->saveOneDriveDetails($headers, $odbDetails);
            $this->log(json_encode($odbDetails), "info");
            switch ($result['status']) {
                case (200):
                    $data = array(
                        'result' => 'success',
                        'msg' => 'Details has been successfully saved'
                    );
                    echo json_encode($data);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        } else {
            $data = array(
                "post" => $_POST,
                'result' => 'error',
                'msg' => 'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }

    /**
     * Below Method Renders ODB Configuration View
     */
    public function connector(){

        $userDetails = $this->_model->getUserDetails(array('token' => $this->session->get('token')), $this->session->get("userName"));

        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token')
        );

        $result = $this->_model->getOdbDetails($headers);

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('connector'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'userDetails' => $userDetails['body'],
            'loggedInUser' => $this->session->all(),

            'clientID'=> $result["body"][0]->{"clientId"},
            'clientRedirectURI'=> $result["body"][0]->{"clientRedirectURI"},
            'portalURL'=> $result["body"][0]->{"portalURL"},
            'clientSecretKey'=> $result["body"][0]->{"clientSecretKey"},
            'clientResourceURL'=> $result["body"][0]->{"clientResourceURL"},
            'configId'=> $result["body"][0]->{"configId"},

        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/connector', $data);
        View::renderTemplate('footer', $data);
    }

    public function writeODB(){
        if (!empty($_POST['clientId']) && !empty($_POST['clientSecret']) && !empty($_POST['clientRedirectURI']) && !empty($_POST['clientResourceURL']) && !empty($_POST['portalURL'])) {

            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token')
            );

            $odbDetails = array(
                'clientId' => trim($_POST['clientId']),
                'configId' => trim($_POST['configId']),
                'clientSecretKey' => trim($_POST['clientSecret']),
                'clientRedirectURI' => trim($_POST['clientRedirectURI']),
                'clientResourceURL' => trim($_POST['clientResourceURL']),
                'clientTokenURL' => trim($_POST['clientTokenURL']),
                'portalURL' => trim($_POST['portalURL'])
            );
            $result = $this->_model->saveOdbDetails($headers, $odbDetails);
            $this->log(json_encode($odbDetails), "info");
            switch ($result['status']) {
                case (200):

                    $data = array(
                        'result' => 'success',
                        'msg' => 'Details has been successfully saved'
                    );
                    echo json_encode($data);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        } else {
            $data = array(
                "post" => $_POST,
                'result' => 'error',
                'msg' => 'None of the field listed should be empty'
            );
            echo json_encode($data);
        }

    }

    public function writeGoogle(){

if(!empty($_POST['clientId']) && !empty($_POST['clientSecret'])){
         $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token')
            );

file_put_contents('/var/www/portal/app/Core/GoogleConfig.php',"<?php 
define('GOOGLE_CLIENT_ID','".trim($_POST['clientId'])."');
define('GOOGLE_SECRET_KEY','".trim($_POST['clientSecret'])."');
define('GOOGLE_REDIRECT_URI','https://accounts.google.com/o/oauth2/auth');
define('GOOGLE_TOKEN_URL', 'https://accounts.google.com/o/oauth2/token');
define('GOOGLE_USER_INFO_URL', 'https://people.googleapis.com/v1/people/me?personFields=emailAddresses&access_token=');
define('GOOGLE_SCOPE', 'email%20profile%20https://www.googleapis.com/auth/drive.file%20https://www.googleapis.com/auth/plus.me');
define('GOOGLE_RESOURCE_URI', 'googleOAuth');


?>");
            $googleDetails = array(
                'clientId' => trim($_POST['clientId']),
                'configId' => trim($_POST['configId']),
                'clientSecretKey' => trim($_POST['clientSecret'])

            );
            $result = $this->_model->saveGoogleDetails($headers, $googleDetails);
            $this->log(json_encode($googleDetails), "info");
            switch ($result['status']) {
                case (200):
$data = array(
                        'result' => 'success',
                        'msg' => 'Details has been successfully saved'
                    );
                    echo json_encode($data);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
$result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
  }
        }else {
            $data = array(
                "post" => $_POST,
                'result' => 'error',
                'msg' => 'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }


    public function writeODC(){
        if(!empty($_POST['ClientId']) && !empty($_POST['clientSecret']) && !empty($_POST['clientRedirectURI']) && !empty($_POST['clientResourceURL']) && !empty($_POST['portalURL'])){
            $values = htmlentities($_POST['ClientId']).' '.htmlentities($_POST['clientSecret']).' '.htmlentities($_POST['clientRedirectURI']).' '.htmlentities($_POST['clientResourceURL']).' '.$_POST['portalURL'];
            $scriptOutput = shell_exec('sh /var/lib/parablusys/bin/odcoverwrite.sh '.$values);
            $this->log('scriptOutput' . json_encode($scriptOutput), 'info');
            $data = array(
                'result'=>'success',
                'msg' => 'Details has been successfully saved'
            );
            echo json_encode($data);
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }

    /**
     * Below Method Renders proxy Configuration View
     */
    public function proxy(){
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token')
        );
        $result = $this->_model->getProxyDetails($headers);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('proxyConfiguration'),
            'active' => 'settings',
            'proxy' => $result['body']->{'proxyList'},
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/proxy', $data);
        View::renderTemplate('footer', $data);
    }

    public function proxyremove(){
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token'),
            'proxyHost'     => $_POST['proxyHost']
        );
        $result = $this->_model->removeProxyDetails($headers);
        switch ($result['status']) {
            case (200):

                $response = array(
                    'result' => 'success',
                    'msg'    => $this->language->get('removeProxySettings')
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    /**
     *
     */
    public function writeProxySettings(){
        if(!empty($_POST['proxyURL']) && !empty($_POST['proxyUserName']) && !empty($_POST['proxyPassword']) && !empty($_POST['proxyPort'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),

            );


        $password_en = $_POST['proxyPassword'];
        $password_en = str_replace(".","+",$password_en);
        $password_en = str_replace("_","/",$password_en);
        $password_en = str_replace("-","=",$password_en);
$privkey = '-----BEGIN RSA PRIVATE KEY-----
MIICXgIBAAKBgQDJa13jCuhhMNQfcXb6uRJEnKkQBQxpl1Dp5U8EDbo16KrSDT++
OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulqIg8Tca9eg/uVjg2DHs4wIyzN
J7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+xVCPksMvihMgXe2xLdwIDAQAB
AoGBAJgcOlIdSbMkYf3A/Z6JJ6+jM9YCSgZwHM4Wu56PE2Jk7KQnF019d+Di0Zj/
DCD15irXFzyxTk3v0d/3mr17I4Pl1G2E4CjbqoxFXm6AqJ8ETpExJE/cU/gA3Uyz
ROWpP1WYJIz5HPnnkcDF+5oHYDPhNnV4vzJ9FpYOvzjZt7URAkEA8Day1Cp4P77k
jGXaf0aO1iNUuQOqFh7Id4MY2bMnJxXs664ZGqKJ53h12mHSdkCWq1vjR9KI/1vd
l3JvUGNxWQJBANaoAIjDJaRI2mxirzkCcwz0IfFJzmB6nZAqAiekCenhb3FGw+lW
Px7qd3JfU1vf9OfUpuGa/e+S5XTIuFkLuU8CQQCd/Vvg743nX0YykUsEKwQHE3XF
ugNESTrQYAkYJhy6OFF7MSaRvhW1iCT7XRtva0utqOHzeyVfzqwPz9Qmq0EBAkA0
DUEz6L5z/AabScLbvDBR79FbRV56HsGed9FV831D7ZqsiVBwgK2Fva2BWoRIPyKQ
JQzioEb7lU925kVtsl4ZAkEAj6wYWg+Rac7QbbcrW6SxehOehgkaCoTSZ/O9bj0m
WEIoJbkE69ABYKnCadQVbwK5W8fCUpqto0qCvva2l2PWeQ==
-----END RSA PRIVATE KEY-----';
        $encrypted_password = $password_en;
        if(openssl_private_decrypt(base64_decode($encrypted_password), $decrypted, $privkey))
        {
                $proxyPassword = $decrypted;
        }
        $this->log("Resultencrypted_password:".$proxyPassword, "info");
            $data = array(
                'host'     => trim($_POST['proxyURL']),
                'userName'      => trim($_POST['proxyUserName']),
                'password'      => trim($proxyPassword),
                'port'          => trim($_POST['proxyPort'])
            );
            $result = $this->_model->saveProxyDetails($headers,json_encode($data));
            $this->log("Result:".json_encode($result), "info");
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('Details has been successfully saved')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }
    
    public function editProxySettings(){
        if(!empty($_POST['proxyURL'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),

            );
        $password_en = $_POST['proxyPassword'];
        $password_en = str_replace(".","+",$password_en);
        $password_en = str_replace("_","/",$password_en);
        $password_en = str_replace("-","=",$password_en);
$privkey = '-----BEGIN RSA PRIVATE KEY-----
MIICXgIBAAKBgQDJa13jCuhhMNQfcXb6uRJEnKkQBQxpl1Dp5U8EDbo16KrSDT++
OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulqIg8Tca9eg/uVjg2DHs4wIyzN
J7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+xVCPksMvihMgXe2xLdwIDAQAB
AoGBAJgcOlIdSbMkYf3A/Z6JJ6+jM9YCSgZwHM4Wu56PE2Jk7KQnF019d+Di0Zj/
DCD15irXFzyxTk3v0d/3mr17I4Pl1G2E4CjbqoxFXm6AqJ8ETpExJE/cU/gA3Uyz
ROWpP1WYJIz5HPnnkcDF+5oHYDPhNnV4vzJ9FpYOvzjZt7URAkEA8Day1Cp4P77k
jGXaf0aO1iNUuQOqFh7Id4MY2bMnJxXs664ZGqKJ53h12mHSdkCWq1vjR9KI/1vd
l3JvUGNxWQJBANaoAIjDJaRI2mxirzkCcwz0IfFJzmB6nZAqAiekCenhb3FGw+lW
Px7qd3JfU1vf9OfUpuGa/e+S5XTIuFkLuU8CQQCd/Vvg743nX0YykUsEKwQHE3XF
ugNESTrQYAkYJhy6OFF7MSaRvhW1iCT7XRtva0utqOHzeyVfzqwPz9Qmq0EBAkA0
DUEz6L5z/AabScLbvDBR79FbRV56HsGed9FV831D7ZqsiVBwgK2Fva2BWoRIPyKQ
JQzioEb7lU925kVtsl4ZAkEAj6wYWg+Rac7QbbcrW6SxehOehgkaCoTSZ/O9bj0m
WEIoJbkE69ABYKnCadQVbwK5W8fCUpqto0qCvva2l2PWeQ==
-----END RSA PRIVATE KEY-----';

        $encrypted_password = $password_en;
        function decrypt($data, $privkey)
        {
                if (openssl_private_decrypt(base64_decode($data), $decrypted, $privkey))
                    $data = $decrypted;
                else
                    $data = '';

                return $data;
        }
        $proxyPassword = decrypt ($encrypted_password, $privkey);

            $data = array(
                'host'          => trim($_POST['proxyURL']),
                'userName'      => trim($_POST['proxyUserName']),
                'password'      => trim($proxyPassword),
                'port'          => trim($_POST['proxyPort'])
            );
            $this->log("ResultEDIT:".json_encode($data), "info");
            $result = $this->_model->editProxyDetails($headers,json_encode($data));
            $this->log("Result:".json_encode($result), "info");
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('Details has been successfully updated')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }
    

    /**
     * Below Method Renders Domain Host Name Configuration View
     */
    public function domain(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('domain'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/domain', $data);
        View::renderTemplate('footer', $data);
    }

    public function writeDomainHost(){
        if(!empty($_POST['domainName']) && !empty($_POST['hostName'])){
            $data = array(
                'result'=>'success',
                'msg' => 'Details has been successfully saved'
            );
            echo json_encode($data);
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }

    /**
     * Below Method Renders SSL Certificate Upload View
     */
    public function sslAndEncryption(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('sslAndEncryption'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/sslAndEncryption', $data);
        View::renderTemplate('footer', $data);
    }

    public function saveSSLCertificate(){
        $tempFilePath = '/var/lib/parablusys/conf/';
        $flag = true;
        if(!empty($_FILES['mainCRTFile']) && !empty($_FILES['chainCRTFile']) && !empty($_FILES['keyFile'])){
            $tmp_name = $_FILES["mainCRTFile"]["tmp_name"];
            $name = $_FILES["mainCRTFile"]["name"];
            /*$ext1 = substr(strrchr($_FILES['mainCRTFile']['name'], "."), 1);
            if($ext1 != 'crt')
            {
                $flag = false;
            }*/
            move_uploaded_file($tmp_name, $tempFilePath.$name);
            $tmp_name = $_FILES["chainCRTFile"]["tmp_name"];
            $name = $_FILES["chainCRTFile"]["name"];
            /*$ext2 = substr(strrchr($_FILES['chainCRTFile']['name'], "."), 1);
            if($ext2 != 'crt')
            {
                $flag = false;
            }*/
            move_uploaded_file($tmp_name, $tempFilePath.$name);
            $tmp_name = $_FILES["keyFile"]["tmp_name"];
            $name = $_FILES["keyFile"]["name"];
            /*$ext3 = substr(strrchr($_FILES['keyFile']['name'], "."), 1);
            if($ext3 != 'key')
            {
                $flag = false;
            }*/
            move_uploaded_file($tmp_name, $tempFilePath.$name);
            //$values = $_FILES["mainCRTFile"]["name"] . ' '.$_FILES["chainCRTFile"]["name"].' '.$_FILES["keyFile"]["name"].' '.$_POST["serverName"];
            $values = $_FILES["mainCRTFile"]["name"] .' '.$_FILES["keyFile"]["name"].' '.$_POST["serverName"] . ' '.$_FILES["chainCRTFile"]["name"];
            //$scriptOutput = shell_exec('sh /var/lib/parablusys/conf/cert_file.sh '.$values);
            file_put_contents('/var/lib/parablusys/conf/ssh_install.sh', "./cert_file.sh " .$values);
            chmod('/var/lib/parablusys/conf/ssh_install.sh', 0755);
            $this->log('scriptOutput' . json_encode($scriptOutput), 'info');
            //if($flag == 'true'){
            $data = array(
                'result'=>'success',
                'msg' => 'Details has been successfully saved'
            );
            /*}
            else {
             $data = array(
                'result'=>'fail',
                'msg' => 'file not supported, <br> check extension'
            );   
            }*/
            echo json_encode($data);
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }

    /**
     * Below Method Renders Encryption settings page
     */
    public function encryption(){
        $keys = [];
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );

        $result = $this->_model->getEncryption($headers);
        switch ($result['status']) {
            case (200):
                if(!empty($result['body']->{'encryptionKeyElementList'})){
                    foreach($result['body']->{'encryptionKeyElementList'} as $value){
                        date_default_timezone_set('Asia/Calcutta');


                        $a = $value->startTimestamp/1000;
                        //$date = new DateTime("@$a");
                        $value->startTime = date('d.m.Y H:i:s', $a);
                        $keys = array_merge(array($value), $keys);
                    }
                }
                $response = array(
                    'result' => 'success',
                    'keys' => $keys,
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function saveEncryption(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token')
            );

            $body = array(
                'userName'      => $this->session->get('userName'),
                'productType'   => $_POST['productType'],
                'saltKey'       => $_POST['saltKey']
            );
            $result = $this->_model->saveEncryption($headers,$body);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => $this->language->get('encryptionKeySaved')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    /**
     * Below Method Renders Encryption settings page
     */
    public function local(){
        $headers = array(
            'Content-Type' => 'application/json',
            'token' => $this->session->get('token')
        );
        $result = $this->_model->getLocalStorageDetails($headers);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('local'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'localStorage' => $result['body'],
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/local', $data);
        View::renderTemplate('footer', $data);
    }

    public function saveLocal(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'          => $this->session->get('token')
            );
            $data = array(
                'fileServerPath' => $_POST['path'],
                'fileServerUserName' => $_POST['userName'],
                'fileServerPassword' => $_POST['password']
            );
            $result = $this->_model->saveLocalStorageDetails($headers, $data);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('encryptionKeySaved')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    /**
     * Below Method Renders Encryption settings page
     */
    public function adCredentials(){

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('adCredentials'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/adCredentials', $data);
        View::renderTemplate('footer', $data);
    }

    public function getAdCredentials(){
        $adcS = [];
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token')
        );
        if($this->session->get('admin') == "1"){
            $result = $this->_model->getAdCredentials($headers);
        }

$pubkey = '-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJa13jCuhhMNQfcXb6uRJEnKkQ
BQxpl1Dp5U8EDbo16KrSDT++OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulq
Ig8Tca9eg/uVjg2DHs4wIyzNJ7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+x
VCPksMvihMgXe2xLdwIDAQAB
-----END PUBLIC KEY-----';

        if(!empty($result['body']->{'adElementList'})){
            foreach($result['body']->{'adElementList'} as $value){
		if($value->{'adPassword'}){
		$pass = $value->{'adPassword'};
		openssl_public_encrypt($pass, $encrypted, $pubkey);
	        $encrypted = base64_encode($encrypted);
		$encrypted = str_replace(".","+",$encrypted);
                $encrypted = str_replace("_","/",$encrypted);
                $encrypted = str_replace("-","=",$encrypted);
        	$value->{'adPassword'} = $encrypted;
}
                $adcS = array_merge(array($value), $adcS);
            }
        }

        switch ($result['status']) {
            case (200):

                $response = array(
                    'result' => 'success',
                    'adcS'    => $adcS
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function getAdCredential(){
        if(!empty($_POST['id'])){

            $headers = array(
                'Content-Type'      => 'application/json',
                'id'            => $_POST['id'],
                'token'             => $this->session->get('token')
            );

            $result = $this->_model->getAdCredential($headers);
$pubkey = '-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJa13jCuhhMNQfcXb6uRJEnKkQ
BQxpl1Dp5U8EDbo16KrSDT++OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulq
Ig8Tca9eg/uVjg2DHs4wIyzNJ7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+x
VCPksMvihMgXe2xLdwIDAQAB
-----END PUBLIC KEY-----';
		$adPassword = $result['body']->{'adElement'}->{'adPassword'};
		openssl_public_encrypt($adPassword, $encrypted, $pubkey);
	        $encrypted = base64_encode($encrypted);
		$encrypted = str_replace(".","+",$encrypted);
	        $encrypted = str_replace("_","/",$encrypted);
        	$encrypted = str_replace("-","=",$encrypted);
		$result['body']->{'adElement'}->{'adPassword'} = $encrypted;
		$this->log("Password : ".$adPassword,"info");
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'adcS'    => $result['body']->{'adElement'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function saveAdCredentials(){
        if(!empty($_POST['userDn']) && !empty($_POST['adPassword']) && !empty($_POST['adUrl']) && !empty($_POST['adBase'])){
        $adProductType = '';
        switch ($_POST['adProductType']) {
            case 'BluSync':
                $adProductType = "sync";
                break;
            case 'BluVault':
                $adProductType = "backup";
                break;
            case 'O365':
                 $adProductType = "O365";
                 break;
            default:
                $adProductType = $_POST['adProductType'];
            break;
        }

        $this->log("Password : ".$_POST['adPassword'],"info");
        $password_en = $_POST['adPassword'];
        $password_en = str_replace(".","+",$password_en);
        $password_en = str_replace("_","/",$password_en);
        $password_en = str_replace("-","=",$password_en);

$privkey = '-----BEGIN RSA PRIVATE KEY-----
MIICXgIBAAKBgQDJa13jCuhhMNQfcXb6uRJEnKkQBQxpl1Dp5U8EDbo16KrSDT++
OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulqIg8Tca9eg/uVjg2DHs4wIyzN
J7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+xVCPksMvihMgXe2xLdwIDAQAB
AoGBAJgcOlIdSbMkYf3A/Z6JJ6+jM9YCSgZwHM4Wu56PE2Jk7KQnF019d+Di0Zj/
DCD15irXFzyxTk3v0d/3mr17I4Pl1G2E4CjbqoxFXm6AqJ8ETpExJE/cU/gA3Uyz
ROWpP1WYJIz5HPnnkcDF+5oHYDPhNnV4vzJ9FpYOvzjZt7URAkEA8Day1Cp4P77k
jGXaf0aO1iNUuQOqFh7Id4MY2bMnJxXs664ZGqKJ53h12mHSdkCWq1vjR9KI/1vd
l3JvUGNxWQJBANaoAIjDJaRI2mxirzkCcwz0IfFJzmB6nZAqAiekCenhb3FGw+lW
Px7qd3JfU1vf9OfUpuGa/e+S5XTIuFkLuU8CQQCd/Vvg743nX0YykUsEKwQHE3XF
ugNESTrQYAkYJhy6OFF7MSaRvhW1iCT7XRtva0utqOHzeyVfzqwPz9Qmq0EBAkA0
DUEz6L5z/AabScLbvDBR79FbRV56HsGed9FV831D7ZqsiVBwgK2Fva2BWoRIPyKQ
JQzioEb7lU925kVtsl4ZAkEAj6wYWg+Rac7QbbcrW6SxehOehgkaCoTSZ/O9bj0m
WEIoJbkE69ABYKnCadQVbwK5W8fCUpqto0qCvva2l2PWeQ==
-----END RSA PRIVATE KEY-----';
        $encrypted_password = $password_en;
        $this->log("Password changed : ".$password_en,"info");
        function decrypt($data, $privkey)
        {
                if (openssl_private_decrypt(base64_decode($data), $decrypted, $privkey))
                        $data = $decrypted;
                else
                        $data = '';
                return $data;
        }
        $password = decrypt ($encrypted_password, $privkey);
        $this->log("Password changed : ".$password,"info");
        $_POST['adUrl'] = "ldap://".$_POST['adUrl'].":".$_POST['adPort'];
        $data = array(
                'userDn' => trim($_POST['userDn']),
                'adPassword' => $password,
                'adUrl' => trim($_POST['adUrl']),
                'adBase' => trim($_POST['adBase']),
                'adCn' => trim($_POST['newAdCn']),
                'adProductType' => $adProductType,
                'adGroupName' => trim($_POST['adGroupName'])
            );
            $this->log('Data: '. json_encode($data), 'info');
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'          => $this->session->get('token')
            );
            $result = $this->_model->saveAdCredentials($headers, json_encode($data));
            $this->log('Result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('savedAdCredentials')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function editAdCredentials(){
        if(!empty($_POST['userDn']) && !empty($_POST['editAdPassword']) && !empty($_POST['adUrl']) && !empty($_POST['adBase'])){
        $adProductType = '';
        switch ($_POST['editAdProductType']) {
            case 'BluSync':
                $adProductType = "sync";
                break;
            case 'BluVault':
                $adProductType = "backup";
                break;
            case 'O365':
                 $adProductType = "O365";
                 break;
            default:
                $adProductType = $_POST['editAdProductType'];
            break;
        }
        $password_en = $_POST['editAdPassword'];
        $password_en = str_replace(".","+",$password_en);
        $password_en = str_replace("_","/",$password_en);
        $password_en = str_replace("-","=",$password_en);
$privkey = '-----BEGIN RSA PRIVATE KEY-----
MIICXgIBAAKBgQDJa13jCuhhMNQfcXb6uRJEnKkQBQxpl1Dp5U8EDbo16KrSDT++
OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulqIg8Tca9eg/uVjg2DHs4wIyzN
J7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+xVCPksMvihMgXe2xLdwIDAQAB
AoGBAJgcOlIdSbMkYf3A/Z6JJ6+jM9YCSgZwHM4Wu56PE2Jk7KQnF019d+Di0Zj/
DCD15irXFzyxTk3v0d/3mr17I4Pl1G2E4CjbqoxFXm6AqJ8ETpExJE/cU/gA3Uyz
ROWpP1WYJIz5HPnnkcDF+5oHYDPhNnV4vzJ9FpYOvzjZt7URAkEA8Day1Cp4P77k
jGXaf0aO1iNUuQOqFh7Id4MY2bMnJxXs664ZGqKJ53h12mHSdkCWq1vjR9KI/1vd
l3JvUGNxWQJBANaoAIjDJaRI2mxirzkCcwz0IfFJzmB6nZAqAiekCenhb3FGw+lW
Px7qd3JfU1vf9OfUpuGa/e+S5XTIuFkLuU8CQQCd/Vvg743nX0YykUsEKwQHE3XF
ugNESTrQYAkYJhy6OFF7MSaRvhW1iCT7XRtva0utqOHzeyVfzqwPz9Qmq0EBAkA0
DUEz6L5z/AabScLbvDBR79FbRV56HsGed9FV831D7ZqsiVBwgK2Fva2BWoRIPyKQ
JQzioEb7lU925kVtsl4ZAkEAj6wYWg+Rac7QbbcrW6SxehOehgkaCoTSZ/O9bj0m
WEIoJbkE69ABYKnCadQVbwK5W8fCUpqto0qCvva2l2PWeQ==
-----END RSA PRIVATE KEY-----';

        $encrypted_password = $password_en;
        function decrypt($data, $privkey)
            {
                if (openssl_private_decrypt(base64_decode($data), $decrypted, $privkey))
                    $data = $decrypted;
                else
                    $data = '';

                return $data;
            }
            $password = decrypt ($encrypted_password, $privkey);
            $_POST['adUrl'] = "ldap://".$_POST['adUrl'].":".$_POST['adPort'];
            $data = array(
                'id' => $_POST['id'],
                'userDn' => trim($_POST['userDn']),
                'adPassword' => $password,
                'adUrl' => trim($_POST['adUrl']),
                'adBase' => trim($_POST['adBase']),
                'adCn' => trim($_POST['newAdCn']),
                'adProductType' => $adProductType,
                'adGroupName' => trim($_POST['adGroupName'])
            );
            $this->log('Data: '. json_encode($data), 'info');
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'          => $this->session->get('token')
            );
            $result = $this->_model->editAdCredentials($headers, json_encode($data));
            $this->log('Result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('savedAdCredentials')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function removeAdCredentials(){
        if(!empty($_POST['userDn'])){
            $headers = array(
                'Content-Type'      => 'application/json',
                'userDn'            => $_POST['userDn'],
                'token'             => $this->session->get('token')
            );
            $result = $this->_model->removeAdCredentials($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('removeAdCredentials')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function smtp(){

        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );

        $result = $this->_model->getSmtp($headers);

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('smtp'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),

            "smtpHost" => !empty($result['body']->{'smtpElement'}->{'smtpHost'}) ? $result['body']->{'smtpElement'}->{'smtpHost'} : 'smtp.office365.com',
            "sslPort" => !empty($result['body']->{'smtpElement'}->{'sslPort'}) ? $result['body']->{'smtpElement'}->{'sslPort'} : '465',
            "sslFactoryClass" => !empty($result['body']->{'smtpElement'}->{'sslFactoryClass'}) ? $result['body']->{'smtpElement'}->{'sslFactoryClass'} : "javax.net.ssl.SSLSocketFactory",
            "smtpPort" => !empty($result['body']->{'smtpElement'}->{'smtpPort'}) ? $result['body']->{'smtpElement'}->{'smtpPort'} : 465,
            "smtpAuth" => ($result['body']->{'smtpElement'}->{'smtpAuth'}) ? true : false,
            "smtpStarttlsEnable" => ($result['body']->{'smtpElement'}->{'smtpStarttlsEnable'}) ? true : false,
            "smtpSSLEnable" => ($result['body']->{'smtpElement'}->{'smtpSSLEnable'}) ? true : false,
            "smtpUserName" => !empty($result['body']->{'smtpElement'}->{'smtpUserName'}) ? $result['body']->{'smtpElement'}->{'smtpUserName'} : 'noreply@parablu.com',
            "smtpPwd" => !empty($result['body']->{'smtpElement'}->{'smtpPwd'}) ? $result['body']->{'smtpElement'}->{'smtpPwd'} : 'P@rablu123',
            "fromEmail" => !empty($result['body']->{'smtpElement'}->{'fromEmail'}) ? $result['body']->{'smtpElement'}->{'fromEmail'} : 'noreply@parablu.com',
            "enableEmail" => ($result['body']->{'smtpElement'}->{'enableEmail'}) ? true : false
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/smtp', $data);
        View::renderTemplate('footer', $data);
    }

    public function saveSmtp(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'             => $this->session->get('token')
            );


        $password_en = $_POST['smtpPwd'];
        $password_en = str_replace(".","+",$password_en);
        $password_en = str_replace("_","/",$password_en);
        $password_en = str_replace("-","=",$password_en);

$privkey = '-----BEGIN RSA PRIVATE KEY-----
MIICXgIBAAKBgQDJa13jCuhhMNQfcXb6uRJEnKkQBQxpl1Dp5U8EDbo16KrSDT++
OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulqIg8Tca9eg/uVjg2DHs4wIyzN
J7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+xVCPksMvihMgXe2xLdwIDAQAB
AoGBAJgcOlIdSbMkYf3A/Z6JJ6+jM9YCSgZwHM4Wu56PE2Jk7KQnF019d+Di0Zj/
DCD15irXFzyxTk3v0d/3mr17I4Pl1G2E4CjbqoxFXm6AqJ8ETpExJE/cU/gA3Uyz
ROWpP1WYJIz5HPnnkcDF+5oHYDPhNnV4vzJ9FpYOvzjZt7URAkEA8Day1Cp4P77k
jGXaf0aO1iNUuQOqFh7Id4MY2bMnJxXs664ZGqKJ53h12mHSdkCWq1vjR9KI/1vd
l3JvUGNxWQJBANaoAIjDJaRI2mxirzkCcwz0IfFJzmB6nZAqAiekCenhb3FGw+lW
Px7qd3JfU1vf9OfUpuGa/e+S5XTIuFkLuU8CQQCd/Vvg743nX0YykUsEKwQHE3XF
ugNESTrQYAkYJhy6OFF7MSaRvhW1iCT7XRtva0utqOHzeyVfzqwPz9Qmq0EBAkA0
DUEz6L5z/AabScLbvDBR79FbRV56HsGed9FV831D7ZqsiVBwgK2Fva2BWoRIPyKQ
JQzioEb7lU925kVtsl4ZAkEAj6wYWg+Rac7QbbcrW6SxehOehgkaCoTSZ/O9bj0m
WEIoJbkE69ABYKnCadQVbwK5W8fCUpqto0qCvva2l2PWeQ==
-----END RSA PRIVATE KEY-----';

        $encrypted_password = $password_en;
        
        function decrypt($data, $privkey) {
                if (openssl_private_decrypt(base64_decode($data), $decrypted, $privkey))
                    $data = $decrypted;
                else
                    $data = '';
                return $data;
            }
        $password = decrypt ($encrypted_password, $privkey);
        $smtpDetails = array(
                "smtpHost" => trim($_POST["smtpHost"]),
                "sslPort" => trim($_POST["sslPort"]),
                "sslFactoryClass" => $_POST["factoryClass"],
                "smtpPort" => trim($_POST["smtpPort"]),
                "smtpAuth" => $_POST["smtpAuth"],
                "smtpStarttlsEnable" => $_POST["smtpStarttlsEnable"],
                "smtpSSLEnable" => $_POST["smtpSSLEnable"],
                "smtpUserName" => $_POST["smtpUname"],
                "smtpPwd" => $password,
                "fromEmail" => $_POST["email"],
                "enableEmail" => $_POST["enableMail"],
            );

            $result = $this->_model->saveSmtp($headers, $smtpDetails);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('saveSmtp')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function testMail(){
        $headers = array(
                'Content-Type'      => 'application/json',
                "clientType"        => "PORTAL"
            );
        $recipents = array(
                "userName"      =>  "test",
                "email"         => $_POST['email']
            );
        $reci = [];
        array_push($reci,$recipents);
        $data = array(
                "bodyData"      =>      "This is an automated test email from the Parablu Systems",
                "subjectData"   =>      "Parablu",
                "recipents"     =>      $reci
            );

            $result = $this->_model->testMail($headers,$data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('testMail')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function cloudProperties(){
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );

        $result = $this->_model->getCloudProperties($headers);
        $backupPoliciesResult= $this->_model->getAllPolicies($this->session->get('token'));
        $syncPoliciesResult= $this->_model->getAllSyncPolicies($this->session->get('token'));
        $odbPolicyResult1 = $this->_model->getAllOneDrivePolicies(array('token'=>$this->session->get('token')));
         if(empty((array)$backupPoliciesResult['body']->{'backupPolicyElementList'}) && $this->auth->checkCloudPermission('backup')){
             header('Location: '.Url::basePath('pms/policy/create'));
             exit;
         }
         if(empty((array)$syncPoliciesResult['body']->{'syncPolicyElementList'}) && $this->auth->checkCloudPermission('sync')){
             header('Location: '.Url::basePath('pms/sync/policy/create'));
             exit;
         }
 
         $backupPolicies = [];
         foreach((array)$backupPoliciesResult['body']->{'backupPolicyElementList'} as $value){
             $policy = array('name' => $value->{'policygroupName'});
             $backupPolicies = array_merge(array($policy), $backupPolicies);
         }
         
         $syncPolicies = [];
         foreach((array)$syncPoliciesResult['body']->{'syncPolicyElementList'} as $value){
             $policy = array('name' => $value->{'policygroupName'});
             $syncPolicies = array_merge(array($policy), $syncPolicies);
         }
         
        $backupResult1 = $this->_model->getAllBackupPolicyName(array('token'=>$this->session->get('token')));
        $syncResult1 = $this->_model->getAllSyncPolicyName(array('token'=>$this->session->get('token')));
        $backupPolicies1 = [];
        foreach((array)$backupResult1['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies1 = array_merge(array($policy), $backupPolicies1);
        }

        $syncPolicies1 = [];
        foreach((array)$syncResult1['body']->{'stringList'} as $value){
            $policy = $value;
            $syncPolicies1 = array_merge(array($policy), $syncPolicies1);
        }
        
        $odbPolicies1 = [];
        foreach((array)$odbPolicyResult1['body']->{'officeBackupPolicyElementList'} as $value){
            $policy = array('name' => $value->{'policygroupName'});
            $odbPolicies1 = array_merge(array($policy), $odbPolicies1);
        }
        
        natcasesort($backupPolicies1);
        natcasesort($syncPolicies1);
        natcasesort($odbPolicies1);
        
        $onedriveBkpEnabled = 'false';
        if($this->session->get('onedriveBkpEnabled') == true){
            $onedriveBkpEnabled = 'true';
        }

        $data = array(
            'title' 			=> $this->language->get('indexPageName'),
            'crumb1' 			=> $this->language->get('cloudProperties'),
            'active' 			=> 'settings',
            'csrf_token' 		=> $this->setCSRFToken(),
            'loggedInUser' 		=> $this->session->all(),
            "onedriveBkpEnabled" 	=> $onedriveBkpEnabled,
            "backupPolicies"            => $backupPolicies,
            "syncPolicies"              => $syncPolicies,
            "backupPolicies1"           => $backupPolicies1,
            "syncPolicies1"             => $syncPolicies1,
            "odbPolicies1"              => $odbPolicies1,
            "muxedEnabled"              => ($result['body']->{'cloudPropertyElement'}->{'muxedEnabled'}) ? true : false,
            "blusyncDownloadPath"       => !empty($result['body']->{'cloudPropertyElement'}->{'blusyncDownloadPath'}) ? $result['body']->{'cloudPropertyElement'}->{'blusyncDownloadPath'} : '/var/lib/parablusys/upgrade/',
            "mntParacloudPath"          => !empty($result['body']->{'cloudPropertyElement'}->{'mntParacloudPath'}) ? $result['body']->{'cloudPropertyElement'}->{'mntParacloudPath'} : '/mnt/',
            "cloudScriptsFolder"        => !empty($result['body']->{'cloudPropertyElement'}->{'cloudScriptsFolder'}) ? $result['body']->{'cloudPropertyElement'}->{'cloudScriptsFolder'} : '/var/lib/parablusys/bin/',
            "scriptsBinDir"             => !empty($result['body']->{'cloudPropertyElement'}->{'scriptsBinDir'}) ? $result['body']->{'cloudPropertyElement'}->{'scriptsBinDir'} : '/var/lib/parablusys/bin/',
            "scriptsVideoThumbnail"     => !empty($result['body']->{'cloudPropertyElement'}->{'scriptsVideoThumbnail'}) ? $result['body']->{'cloudPropertyElement'}->{'scriptsVideoThumbnail'} : 'generateVideoThumbnails.sh',
            "scriptsGeneralThumbnail"   => !empty($result['body']->{'cloudPropertyElement'}->{'scriptsGeneralThumbnail'}) ? $result['body']->{'cloudPropertyElement'}->{'scriptsGeneralThumbnail'} : 'generateThumbnails.sh',
            "cloudFileName"             => !empty($result['body']->{'cloudPropertyElement'}->{'cloudFileName'}) ? $result['body']->{'cloudPropertyElement'}->{'cloudFileName'} : 'cloudName',
            "cloudType"                 => !empty($result['body']->{'cloudPropertyElement'}->{'cloudType'}) ? $result['body']->{'cloudPropertyElement'}->{'cloudType'} : 'enterprise',
            "solrUrl"                   => !empty($result['body']->{'cloudPropertyElement'}->{'solrUrl'}) ? $result['body']->{'cloudPropertyElement'}->{'solrUrl'} : 'http://192.168.7.57/ParacloudSearch/search/',
            "supportMail"               => !empty($result['body']->{'cloudPropertyElement'}->{'supportMail'}) ? $result['body']->{'cloudPropertyElement'}->{'supportMail'} : 'praveen.anandaraju@parablu.com',
            "sslAuthEnabled"            => ($result['body']->{'cloudPropertyElement'}->{'sslAuthEnabled'}) ? true : false,
            "azureVM"                   => ($result['body']->{'cloudPropertyElement'}->{'azureVM'}) ? true : false,
            "localAD"                   => ($result['body']->{'cloudPropertyElement'}->{'localAD'}) ? true : false,
            "reportRows"                => !empty($result['body']->{'cloudPropertyElement'}->{'reportRows'}) ? $result['body']->{'cloudPropertyElement'}->{'reportRows'} : '50',
            "maxCrawlHit"               => $result['body']->{'cloudPropertyElement'}->{'maxCrawlHit'},
            "defaultBkpPolicyName"      => !empty($result['body']->{'cloudPropertyElement'}->{'defaultBkpPolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultBkpPolicyName'} : 'STATISTICS_COLLECTOR',
            "defaultSyncPolicyName"     => !empty($result['body']->{'cloudPropertyElement'}->{'defaultSyncPolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultSyncPolicyName'} : 'STATISTICS_SYNC_COLLECTOR',
            "defaultGuestSyncPolicyName"=> !empty($result['body']->{'cloudPropertyElement'}->{'defaultGuestSyncPolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultGuestSyncPolicyName'} : 'STATISTICS_SYNC_COLLECTOR',
            "defaultGuestBkpPolicyName" => !empty($result['body']->{'cloudPropertyElement'}->{'defaultGuestBkpPolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultGuestBkpPolicyName'} : 'STATISTICS_COLLECTOR',
            "daysToWaitForNextBackup"   => !empty($result['body']->{'cloudPropertyElement'}->{'daysToWaitForNextBackup'}) ? $result['body']->{'cloudPropertyElement'}->{'daysToWaitForNextBackup'} : 0,
            "defaultO365PolicyName"     => !empty($result['body']->{'cloudPropertyElement'}->{'defaultO365PolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultO365PolicyName'} : 'STATISTICS_ODB_POLICY',
            "mongoReadPreference"       => ($result['body']->{'cloudPropertyElement'}->{'mongoReadPreference'}) ? true : false,
            "writeConcernLimit"         => !empty($result['body']->{'cloudPropertyElement'}->{'writeConcernLimit'}) ? $result['body']->{'cloudPropertyElement'}->{'writeConcernLimit'} : 1000,
            "ebmsWriteDelayLimit"       => !empty($result['body']->{'cloudPropertyElement'}->{'ebmsWriteDelayLimit'}) ? $result['body']->{'cloudPropertyElement'}->{'ebmsWriteDelayLimit'} : 10,
            "noOfMultiADConfig"         => !empty($result['body']->{'cloudPropertyElement'}->{'noOfMultiADConfig'}) ? $result['body']->{'cloudPropertyElement'}->{'noOfMultiADConfig'} : 1,
            "isCrawlEnabled"            => ($result['body']->{'cloudPropertyElement'}->{'isCrawlEnabled'}) ? true : false,
            "emailBkpGroupName"         => !empty($result['body']->{'cloudPropertyElement'}->{'emailBkpGroupName'}) ? $result['body']->{'cloudPropertyElement'}->{'emailBkpGroupName'} : '',
            "emailSyncGroupName"        => !empty($result['body']->{'cloudPropertyElement'}->{'emailSyncGroupName'}) ? $result['body']->{'cloudPropertyElement'}->{'emailSyncGroupName'} : '',
            "bkpGroupEmail"             => !empty($result['body']->{'cloudPropertyElement'}->{'bkpGroupEmail'}) ? $result['body']->{'cloudPropertyElement'}->{'bkpGroupEmail'} : 'MySecureBackup',
            "syncGroupEmail"            => !empty($result['body']->{'cloudPropertyElement'}->{'syncGroupEmail'}) ? $result['body']->{'cloudPropertyElement'}->{'syncGroupEmail'} : 'MySecureSync',
            "chunkUpdateMaxRetry"       => !empty($result['body']->{'cloudPropertyElement'}->{'chunkUpdateMaxRetry'}) ? $result['body']->{'cloudPropertyElement'}->{'chunkUpdateMaxRetry'} : 3,
            "isDomainCheckEnabled"      => ($result['body']->{'cloudPropertyElement'}->{'isDomainCheckEnabled'}) ? true : false,
            "canAdminRestoreAll"        => ($result['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'}) ? true : false,
            "clientMailName"            => !empty($result['body']->{'cloudPropertyElement'}->{'clientMailName'}) ? $result['body']->{'cloudPropertyElement'}->{'clientMailName'} : 'Parablu',
            "clientSupportMailName"     => !empty($result['body']->{'cloudPropertyElement'}->{'clientSupportMailName'}) ? $result['body']->{'cloudPropertyElement'}->{'clientSupportMailName'} : 'support@parablu.com',
            "isShareFileNameEnabled"    => ($result['body']->{'cloudPropertyElement'}->{'isShareFileNameEnabled'}) ? true : false,
            "adfsUrl"                   => !empty($result['body']->{'cloudPropertyElement'}->{'adfsUrl'}) ? $result['body']->{'cloudPropertyElement'}->{'adfsUrl'} : 'https:443//testv20-1.parablu.com/springsam/saml/login',
            "adGroupName"               => !empty($result['body']->{'cloudPropertyElement'}->{'adGroupName'}) ? $result['body']->{'cloudPropertyElement'}->{'adGroupName'} : '',
            "bulkEmailDelay"            => ($result['body']->{'cloudPropertyElement'}->{'bulkEmailDelay'}) ? $result['body']->{'cloudPropertyElement'}->{'bulkEmailDelay'} : "NO DELAY",
            "canUserChangePassword"     => ($result['body']->{'cloudPropertyElement'}->{'canUserChangePassword'}),
            "canAdminChangeUserPassword"=> ($result['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'}),
            "passwordChangeEnforce"     => ($result['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'}) ? true : false,
            "supportParacloudUrl" 	=> ($result['body']->{'cloudPropertyElement'}->{'supportParacloudUrl'}),
            "hideStorageSizeInCloud" 	=> ($result['body']->{'cloudPropertyElement'}->{'hideStorageSizeInCloud'}) ? true : false,
            "isAdminDeleteBackupFile"   => ($result['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'}) ? true : false,
            "showLatestBkpInfo"        	=> ($result['body']->{'cloudPropertyElement'}->{'showLatestBkpInfo'}) ? true : false,
            "hideCompressedSize"        => ($result['body']->{'cloudPropertyElement'}->{'hideCompressedSize'}) ? true : false,
            "portalSSOEnable"           => $result['body']->{'cloudPropertyElement'}->{'portalSSOEnable'},
	    "portalSSOutEnable"         => $result['body']->{'cloudPropertyElement'}->{'portalSSOutEnable'},
            "dnsUserName"               => !empty($result['body']->{'cloudPropertyElement'}->{'dnsUserName'}) ? $result['body']->{'cloudPropertyElement'}->{'dnsUserName'} : 'rsuresh',
            "dnsPassword"               => !empty($result['body']->{'cloudPropertyElement'}->{'dnsPassword'}) ? $result['body']->{'cloudPropertyElement'}->{'dnsPassword'} : 'suresh',
            "dbBackupPassword"          => !empty($result['body']->{'cloudPropertyElement'}->{'dbBackupPassword'}) ? $result['body']->{'cloudPropertyElement'}->{'dbBackupPassword'} : '',
            "adEmailConfig"             => !empty($result['body']->{'cloudPropertyElement'}->{'adEmailConfig'}) ? $result['body']->{'cloudPropertyElement'}->{'adEmailConfig'} : 'mail',
            "solrServerUrl"             => $result['body']->{'cloudPropertyElement'}->{'solrServerUrl'},
            "searchEnabled"             => $result['body']->{'cloudPropertyElement'}->{'searchEnabled'},
            "storageLimitInKb"          => $result['body']->{'cloudPropertyElement'}->{'storageLimitInKb'},
            "showBackupOverview"        => $result['body']->{'cloudPropertyElement'}->{'showBackupOverview'},
            "showBackupHistory"         => $result['body']->{'cloudPropertyElement'}->{'showBackupHistory'},
            "showFailedBackupHistory"   => $result['body']->{'cloudPropertyElement'}->{'showFailedBackupHistory'},
            "showSystemsWithoutBackups" => $result['body']->{'cloudPropertyElement'}->{'showSystemsWithoutBackups'},
            "showRestoreHistory"        => $result['body']->{'cloudPropertyElement'}->{'showRestoreHistory'},
            "showStorageUtilizationReport" => $result['body']->{'cloudPropertyElement'}->{'showStorageUtilizationReport'},
            "showDeviceHeartbeatReport" => $result['body']->{'cloudPropertyElement'}->{'showDeviceHeartbeatReport'},
            "showUserBackupSummary"     => $result['body']->{'cloudPropertyElement'}->{'showUserBackupSummary'},
	    "enableRecaptcha"           => $result['body']->{'cloudPropertyElement'}->{'enableRecaptcha'},
	    "googleAuthenticator"       => $result['body']->{'cloudPropertyElement'}->{'googleAuthenticator'},
	    "eyeOption"           	=> $result['body']->{'cloudPropertyElement'}->{'eyeOption'},
	    "complexPassword"           => $result['body']->{'cloudPropertyElement'}->{'complexPassword'},
            "flipTotalCompletedBackups" => ($result['body']->{'cloudPropertyElement'}->{'flipTotalCompletedBackups'}) ? true : false,
            "flipTotalActualStorageUtilized" => ($result['body']->{'cloudPropertyElement'}->{'flipTotalActualStorageUtilized'}) ? true : false,
            "totalCompletedBackups"     => ($result['body']->{'cloudPropertyElement'}->{'totalCompletedBackups'}) ? true : false,
            "totalActualStorageUtilized"=> ($result['body']->{'cloudPropertyElement'}->{'totalActualStorageUtilized'}) ? true : false,
            "hideDashboard"         	=> ($result['body']->{'cloudPropertyElement'}->{'hideDashboard'}) ? true : false,
            "extensionsToPdfView"       => $result['body']->{'cloudPropertyElement'}->{'extensionsToPdfView'},
            "stopPauseAccess"         	=> ($result['body']->{'cloudPropertyElement'}->{'stopPauseAccess'}) ? true : false,
            "winDeviceDisplayNameUpdate"=> ($result['body']->{'cloudPropertyElement'}->{'winDeviceDisplayNameUpdate'}) ? true : false,
            "macDeviceDisplayNameUpdate"=> ($result['body']->{'cloudPropertyElement'}->{'macDeviceDisplayNameUpdate'}) ? true : false,
	    "brevityLogging"		=> ($result['body']->{'cloudPropertyElement'}->{'brevityLogging'}) ? true : false,
            "globalCheckForLocalStorage"=> ($result['body']->{'cloudPropertyElement'}->{'globalCheckForLocalStorage'}) ? true : false,
	    "policyEdit" => ($result['body']->{'cloudPropertyElement'}->{'policyEdit'}) ? true : false,
	    "gatewayNameChanged"           => $result['body']->{'cloudPropertyElement'}->{'gatewayNameChanged'},
	    "showCurrentlyRunningReports" => ($result['body']->{'cloudPropertyElement'}->{'showCurrentlyRunningReports'}) ? true : false,
            "showSupportPage" => ($result['body']->{'cloudPropertyElement'}->{'showSupportPage'}) ? true : false,
            "useLocalPackage" => ($result['body']->{'cloudPropertyElement'}->{'useLocalPackage'}) ? true : false,
	    "showAuditHistory"            => ($result['body']->{'cloudPropertyElement'}->{'showAuditHistory'}) ? true : false,
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/cloudProperties', $data);
        View::renderTemplate('footer', $data);
    }

    public function saveCloudProperties(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'             => $this->session->get('token')
            );

	    if(empty($_POST['bulkEmailDelay']) || $_POST['bulkEmailDelay'] == 'NO DELAY'){
                $_POST['bulkEmailDelay'] = 0;
            }
        
        if (!preg_match('/https/', $_POST["supportParacloudUrl"])) {
            $_POST["supportParacloudUrl"] = "https://".$_POST["supportParacloudUrl"]."/";
        }
        
        $flipTotalCompletedBackups = false;
        if($_POST['tile4flip']=='on'){
            $flipTotalCompletedBackups = true;
        }

        $flipTotalActualStorageUtilized = false;
        if($_POST['tile5flip']=='on'){
            $flipTotalActualStorageUtilized = true;
        }

        $totalCompletedBackups = false;
        if($_POST['tile4'] == 'true'){
                $totalCompletedBackups = true;
        }

        $totalActualStorageUtilized = false;
        if($_POST['tile5'] == 'true'){
                $totalActualStorageUtilized = true;
        }

        $cloudDetails = array(
                "blusyncDownloadPath" => $_POST["blusyncDownloadPath"],
                "mntParacloudPath" => $_POST["mntParacloudPath"],
                "cloudScriptsFolder" => $_POST["cloudScriptsFolder"],
                "scriptsBinDir" => $_POST["scriptsBinDir"],
                "scriptsVideoThumbnail" => $_POST["scriptsVideoThumbnail"],
                "scriptsGeneralThumbnail" => $_POST["scriptsGeneralThumbnail"],
                "cloudFileName" => $_POST["cloudFileName"],
                "cloudType" => $_POST["cloudType"],
                "solrUrl" => $_POST["solrUrl"],
                "supportMail" => $_POST["supportMailNew"],
                "sslAuthEnabled" => $_POST["sslAuthEnabled"],
                "azureVM" => $_POST["azureVM"],
                "localAD" => $_POST["localAD"],
                "reportRows" => $_POST["reportRows"],
                "maxCrawlHit" => $_POST["maxCrawlHit"],
                "defaultBkpPolicyName" => $_POST["defaultBkpPolicyName"],
                "defaultSyncPolicyName" => $_POST["defaultSyncPolicyName"],
                "defaultGuestSyncPolicyName" => $_POST["defaultGuestSyncPolicyName"],
                "defaultGuestBkpPolicyName" => $_POST["defaultGuestBkpPolicyName"],
                "daysToWaitForNextBackup" => $_POST["daysToWaitForNextBackup"],
                "defaultO365PolicyName" => $_POST["defaultO365PolicyName"],
                "mongoReadPreference" => $_POST["mongoReadPreference"],
                "writeConcernLimit" => $_POST["writeConcernLimit"],
                "ebmsWriteDelayLimit" => $_POST["ebmsWriteDelayLimit"],
                "noOfMultiADConfig" => $_POST["noOfMultiADConfig"],
                "isCrawlEnabled" => $_POST["isCrawlEnabled"],
                "emailBkpGroupName" => $_POST["emailBkpGroupName"],
                "emailSyncGroupName" => $_POST["emailSyncGroupName"],
                "bkpGroupEmail" => $_POST["bkpGroupEmail"],
                "syncGroupEmail" => $_POST["syncGroupEmail"],
                "chunkUpdateMaxRetry" => $_POST["chunkUpdateMaxRetry"],
                "isDomainCheckEnabled" => $_POST["isDomainCheckEnabled"],
                "canAdminRestoreAll" => $_POST["canAdminRestoreAll"],
                "clientMailName" => $_POST["clientMailName"],
                "clientSupportMailName" => $_POST["clientSupportMailName"],
                "isShareFileNameEnabled" => $_POST["isShareFileNameEnabled"],
                "adfsUrl" => $_POST["adfsUrl"],
                "adGroupName" => $_POST["adGroupName"],
        	"bulkEmailDelay" => $_POST["bulkEmailDelay"],
                "canUserChangePassword"    => $_POST["canUser"],
                "canAdminChangeUserPassword"  => $_POST["canAdmin"],
                "passwordChangeEnforce"  => $_POST["passwordChangeEnforce"],
                "supportParacloudUrl" => $_POST["supportParacloudUrl"],
                "hideStorageSizeInCloud" => $_POST["hideStorageSizeInCloud"],
                "isAdminDeleteBackupFile" => $_POST["isAdminDeleteBackupFile"],
                "showLatestBkpInfo" => $_POST["showLatestBkpInfo"],
                "hideCompressedSize" => $_POST["hideCompressedSize"],
                "portalSSOEnable" => $_POST["portalSSOEnable"],
		"portalSSOutEnable" => $_POST['portalSSOutEnable'],
                "dnsUserName" => $_POST["dnsUserName"],
                "dnsPassword" => $_POST["dnsPassword"],
                "dbBackupPassword" => $_POST["dbBackupPassword"],
                "adEmailConfig" => $_POST["adEmailConfig"],
                "solrServerUrl" => $_POST['solrServerUrl'],
                "searchEnabled" => $_POST['searchEnabled'],
                "storageLimitInKb" => $_POST['storageLimitInKb'],
                "muxedEnabled"    => $_POST["muxedEnabled"],
                "eyeOption"=> $_POST["eyeOption"],
                "enableRecaptcha"=> $_POST["enableRecaptcha"],
                "googleAuthenticator"=> $_POST["googleAuthenticator"],
		"complexPassword"=> $_POST["complexPassword"],
                "totalCompletedBackups"=> $totalCompletedBackups,
                "totalActualStorageUtilized"=> $totalActualStorageUtilized,
		"flipTotalCompletedBackups"=> $flipTotalCompletedBackups,
                "flipTotalActualStorageUtilized"=> $flipTotalActualStorageUtilized,
                "complexPassword"=> $_POST["complexPassword"],
                "showBackupOverview" => $_POST["showBackupOverview"],
                "showBackupHistory" => $_POST["showBackupHistory"],
                "showFailedBackupHistory" => $_POST["showFailedBackupHistory"],
                "showSystemsWithoutBackups" => $_POST["showSystemsWithoutBackups"],
                "showRestoreHistory" => $_POST["showRestoreHistory"],
                "showStorageUtilizationReport" => $_POST["showStorageUtilizationReport"],
                "showDeviceHeartbeatReport" => $_POST["showDeviceHeartbeatReport"],
                "showUserBackupSummary" => $_POST["showUserBackupSummary"],
                "hideDashboard"         => $_POST['hideDashboard'],
                "extensionsToPdfView" => $_POST['extensionsToPdfView'],
                "stopPauseAccess" => $_POST['stopPauseAccess'],
                "winDeviceDisplayNameUpdate" => $_POST['winDeviceDisplayNameUpdate'],
                "macDeviceDisplayNameUpdate" => $_POST['macDeviceDisplayNameUpdate'],
		"brevityLogging" => $_POST['brevityLogging'],
                "globalCheckForLocalStorage" => $_POST['globalCheckForLocalStorage'],
		"policyEdit" => $_POST['policyEdit'],
		"gatewayNameChanged" => $_POST["gatewayNameChanged"],
		"showCurrentlyRunningReports" => $_POST['showCurrentlyRunningReports'],
                "showSupportPage" => $_POST['showSupportPage'],
                "useLocalPackage" => $_POST['useLocalPackage'],
		"showAuditHistory"         => $_POST['showAuditHistory'],
            );

            $result = $this->_model->saveCloudProperties($headers, $cloudDetails);
            $this->log(json_encode($cloudDetails), "info");
            switch ($result['status']) {
                case (200):
			if($cloudDetails['showSupportPage'] == 'true'){
			    	$this->session->put('showSupportPage','true');
			}else{
				$this->session->put('showSupportPage','false');
			}
                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('savedCloudProperties')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function globalSettings(){
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );

        $result = $this->_model->getCloudProperties($headers);
        $backupPoliciesResult= $this->_model->getAllPolicies($this->session->get('token'));
        $syncPoliciesResult= $this->_model->getAllSyncPolicies($this->session->get('token'));
        $odbPolicyResult1 = $this->_model->getAllOneDrivePolicies(array('token'=>$this->session->get('token')));
         if(empty((array)$backupPoliciesResult['body']->{'backupPolicyElementList'}) && $this->auth->checkCloudPermission('backup')){
             header('Location: '.Url::basePath('pms/policy/create'));
             exit;
         }
         if(empty((array)$syncPoliciesResult['body']->{'syncPolicyElementList'}) && $this->auth->checkCloudPermission('sync')){
             header('Location: '.Url::basePath('pms/sync/policy/create'));
             exit;
         }
 
         $backupPolicies = [];
         foreach((array)$backupPoliciesResult['body']->{'backupPolicyElementList'} as $value){
             $policy = array('name' => $value->{'policygroupName'});
             $backupPolicies = array_merge(array($policy), $backupPolicies);
         }
         
         $syncPolicies = [];
         foreach((array)$syncPoliciesResult['body']->{'syncPolicyElementList'} as $value){
             $policy = array('name' => $value->{'policygroupName'});
             $syncPolicies = array_merge(array($policy), $syncPolicies);
         }
         
        $backupResult1 = $this->_model->getAllBackupPolicyName(array('token'=>$this->session->get('token')));
        $syncResult1 = $this->_model->getAllSyncPolicyName(array('token'=>$this->session->get('token')));
        $backupPolicies1 = [];
        foreach((array)$backupResult1['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies1 = array_merge(array($policy), $backupPolicies1);
        }

        $syncPolicies1 = [];
        foreach((array)$syncResult1['body']->{'stringList'} as $value){
            $policy = $value;
            $syncPolicies1 = array_merge(array($policy), $syncPolicies1);
        }
        
        $odbPolicies1 = [];
        foreach((array)$odbPolicyResult1['body']->{'officeBackupPolicyElementList'} as $value){
            $policy = array('name' => $value->{'policygroupName'});
            $odbPolicies1 = array_merge(array($policy), $odbPolicies1);
        }
        
        natcasesort($backupPolicies1);
        natcasesort($syncPolicies1);
        natcasesort($odbPolicies1);
        
        $onedriveBkpEnabled = 'false';
        if($this->session->get('onedriveBkpEnabled') == true){
            $onedriveBkpEnabled = 'true';
        }

        $data = array(
            'title' 			=> $this->language->get('indexPageName'),
            'crumb1' 			=> $this->language->get('cloudProperties'),
            'active' 			=> 'settings',
            'csrf_token' 		=> $this->setCSRFToken(),
            'loggedInUser' 		=> $this->session->all(),
            "onedriveBkpEnabled" 	=> $onedriveBkpEnabled,
            "backupPolicies"            => $backupPolicies,
            "syncPolicies"              => $syncPolicies,
            "backupPolicies1"           => $backupPolicies1,
            "syncPolicies1"             => $syncPolicies1,
            "odbPolicies1"              => $odbPolicies1,
            "muxedEnabled"              => ($result['body']->{'cloudPropertyElement'}->{'muxedEnabled'}) ? true : false,
            "blusyncDownloadPath"       => !empty($result['body']->{'cloudPropertyElement'}->{'blusyncDownloadPath'}) ? $result['body']->{'cloudPropertyElement'}->{'blusyncDownloadPath'} : '/var/lib/parablusys/upgrade/',
            "mntParacloudPath"          => !empty($result['body']->{'cloudPropertyElement'}->{'mntParacloudPath'}) ? $result['body']->{'cloudPropertyElement'}->{'mntParacloudPath'} : '/mnt/',
            "cloudScriptsFolder"        => !empty($result['body']->{'cloudPropertyElement'}->{'cloudScriptsFolder'}) ? $result['body']->{'cloudPropertyElement'}->{'cloudScriptsFolder'} : '/var/lib/parablusys/bin/',
            "scriptsBinDir"             => !empty($result['body']->{'cloudPropertyElement'}->{'scriptsBinDir'}) ? $result['body']->{'cloudPropertyElement'}->{'scriptsBinDir'} : '/var/lib/parablusys/bin/',
            "scriptsVideoThumbnail"     => !empty($result['body']->{'cloudPropertyElement'}->{'scriptsVideoThumbnail'}) ? $result['body']->{'cloudPropertyElement'}->{'scriptsVideoThumbnail'} : 'generateVideoThumbnails.sh',
            "scriptsGeneralThumbnail"   => !empty($result['body']->{'cloudPropertyElement'}->{'scriptsGeneralThumbnail'}) ? $result['body']->{'cloudPropertyElement'}->{'scriptsGeneralThumbnail'} : 'generateThumbnails.sh',
            "cloudFileName"             => !empty($result['body']->{'cloudPropertyElement'}->{'cloudFileName'}) ? $result['body']->{'cloudPropertyElement'}->{'cloudFileName'} : 'cloudName',
            "cloudType"                 => !empty($result['body']->{'cloudPropertyElement'}->{'cloudType'}) ? $result['body']->{'cloudPropertyElement'}->{'cloudType'} : 'enterprise',
            "solrUrl"                   => !empty($result['body']->{'cloudPropertyElement'}->{'solrUrl'}) ? $result['body']->{'cloudPropertyElement'}->{'solrUrl'} : 'http://192.168.7.57/ParacloudSearch/search/',
            "supportMail"               => !empty($result['body']->{'cloudPropertyElement'}->{'supportMail'}) ? $result['body']->{'cloudPropertyElement'}->{'supportMail'} : 'praveen.anandaraju@parablu.com',
            "sslAuthEnabled"            => ($result['body']->{'cloudPropertyElement'}->{'sslAuthEnabled'}) ? true : false,
            "azureVM"                   => ($result['body']->{'cloudPropertyElement'}->{'azureVM'}) ? true : false,
            "localAD"                   => ($result['body']->{'cloudPropertyElement'}->{'localAD'}) ? true : false,
            "reportRows"                => !empty($result['body']->{'cloudPropertyElement'}->{'reportRows'}) ? $result['body']->{'cloudPropertyElement'}->{'reportRows'} : '50',
            "maxCrawlHit"               => $result['body']->{'cloudPropertyElement'}->{'maxCrawlHit'},
            "defaultBkpPolicyName"      => !empty($result['body']->{'cloudPropertyElement'}->{'defaultBkpPolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultBkpPolicyName'} : 'STATISTICS_COLLECTOR',
            "defaultSyncPolicyName"     => !empty($result['body']->{'cloudPropertyElement'}->{'defaultSyncPolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultSyncPolicyName'} : 'STATISTICS_SYNC_COLLECTOR',
            "defaultGuestSyncPolicyName"=> !empty($result['body']->{'cloudPropertyElement'}->{'defaultGuestSyncPolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultGuestSyncPolicyName'} : 'STATISTICS_SYNC_COLLECTOR',
            "defaultGuestBkpPolicyName" => !empty($result['body']->{'cloudPropertyElement'}->{'defaultGuestBkpPolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultGuestBkpPolicyName'} : 'STATISTICS_COLLECTOR',
            "daysToWaitForNextBackup"   => !empty($result['body']->{'cloudPropertyElement'}->{'daysToWaitForNextBackup'}) ? $result['body']->{'cloudPropertyElement'}->{'daysToWaitForNextBackup'} : 0,
            "defaultO365PolicyName"     => !empty($result['body']->{'cloudPropertyElement'}->{'defaultO365PolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultO365PolicyName'} : 'STATISTICS_ODB_POLICY',
            "mongoReadPreference"       => ($result['body']->{'cloudPropertyElement'}->{'mongoReadPreference'}) ? true : false,
            "writeConcernLimit"         => !empty($result['body']->{'cloudPropertyElement'}->{'writeConcernLimit'}) ? $result['body']->{'cloudPropertyElement'}->{'writeConcernLimit'} : 1000,
            "ebmsWriteDelayLimit"       => !empty($result['body']->{'cloudPropertyElement'}->{'ebmsWriteDelayLimit'}) ? $result['body']->{'cloudPropertyElement'}->{'ebmsWriteDelayLimit'} : 10,
            "noOfMultiADConfig"         => !empty($result['body']->{'cloudPropertyElement'}->{'noOfMultiADConfig'}) ? $result['body']->{'cloudPropertyElement'}->{'noOfMultiADConfig'} : 1,
            "isCrawlEnabled"            => ($result['body']->{'cloudPropertyElement'}->{'isCrawlEnabled'}) ? true : false,
            "emailBkpGroupName"         => !empty($result['body']->{'cloudPropertyElement'}->{'emailBkpGroupName'}) ? $result['body']->{'cloudPropertyElement'}->{'emailBkpGroupName'} : '',
            "emailSyncGroupName"        => !empty($result['body']->{'cloudPropertyElement'}->{'emailSyncGroupName'}) ? $result['body']->{'cloudPropertyElement'}->{'emailSyncGroupName'} : '',
            "bkpGroupEmail"             => !empty($result['body']->{'cloudPropertyElement'}->{'bkpGroupEmail'}) ? $result['body']->{'cloudPropertyElement'}->{'bkpGroupEmail'} : 'MySecureBackup',
            "syncGroupEmail"            => !empty($result['body']->{'cloudPropertyElement'}->{'syncGroupEmail'}) ? $result['body']->{'cloudPropertyElement'}->{'syncGroupEmail'} : 'MySecureSync',
            "chunkUpdateMaxRetry"       => !empty($result['body']->{'cloudPropertyElement'}->{'chunkUpdateMaxRetry'}) ? $result['body']->{'cloudPropertyElement'}->{'chunkUpdateMaxRetry'} : 3,
            "isDomainCheckEnabled"      => ($result['body']->{'cloudPropertyElement'}->{'isDomainCheckEnabled'}) ? true : false,
            "canAdminRestoreAll"        => ($result['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'}) ? true : false,
            "clientMailName"            => !empty($result['body']->{'cloudPropertyElement'}->{'clientMailName'}) ? $result['body']->{'cloudPropertyElement'}->{'clientMailName'} : 'Parablu',
            "clientSupportMailName"     => !empty($result['body']->{'cloudPropertyElement'}->{'clientSupportMailName'}) ? $result['body']->{'cloudPropertyElement'}->{'clientSupportMailName'} : 'support@parablu.com',
            "isShareFileNameEnabled"    => ($result['body']->{'cloudPropertyElement'}->{'isShareFileNameEnabled'}) ? true : false,
            "adfsUrl"                   => !empty($result['body']->{'cloudPropertyElement'}->{'adfsUrl'}) ? $result['body']->{'cloudPropertyElement'}->{'adfsUrl'} : 'https:443//testv20-1.parablu.com/springsam/saml/login',
            "adGroupName"               => !empty($result['body']->{'cloudPropertyElement'}->{'adGroupName'}) ? $result['body']->{'cloudPropertyElement'}->{'adGroupName'} : '',
            "bulkEmailDelay"            => ($result['body']->{'cloudPropertyElement'}->{'bulkEmailDelay'}) ? $result['body']->{'cloudPropertyElement'}->{'bulkEmailDelay'} : "NO DELAY",
            "canUserChangePassword"     => ($result['body']->{'cloudPropertyElement'}->{'canUserChangePassword'}),
            "canAdminChangeUserPassword"=> ($result['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'}),
            "passwordChangeEnforce"     => ($result['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'}) ? true : false,
            "supportParacloudUrl" 	=> ($result['body']->{'cloudPropertyElement'}->{'supportParacloudUrl'}),
            "hideStorageSizeInCloud" 	=> ($result['body']->{'cloudPropertyElement'}->{'hideStorageSizeInCloud'}) ? true : false,
            "isAdminDeleteBackupFile"   => ($result['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'}) ? true : false,
            "showLatestBkpInfo"        	=> ($result['body']->{'cloudPropertyElement'}->{'showLatestBkpInfo'}) ? true : false,
            "hideCompressedSize"        => ($result['body']->{'cloudPropertyElement'}->{'hideCompressedSize'}) ? true : false,
            "portalSSOEnable"           => $result['body']->{'cloudPropertyElement'}->{'portalSSOEnable'},
	    "portalSSOutEnable"         => $result['body']->{'cloudPropertyElement'}->{'portalSSOutEnable'},
            "dnsUserName"               => !empty($result['body']->{'cloudPropertyElement'}->{'dnsUserName'}) ? $result['body']->{'cloudPropertyElement'}->{'dnsUserName'} : 'rsuresh',
            "dnsPassword"               => !empty($result['body']->{'cloudPropertyElement'}->{'dnsPassword'}) ? $result['body']->{'cloudPropertyElement'}->{'dnsPassword'} : 'suresh',
            "dbBackupPassword"          => !empty($result['body']->{'cloudPropertyElement'}->{'dbBackupPassword'}) ? $result['body']->{'cloudPropertyElement'}->{'dbBackupPassword'} : '',
            "adEmailConfig"             => !empty($result['body']->{'cloudPropertyElement'}->{'adEmailConfig'}) ? $result['body']->{'cloudPropertyElement'}->{'adEmailConfig'} : 'mail',
            "solrServerUrl"             => $result['body']->{'cloudPropertyElement'}->{'solrServerUrl'},
            "searchEnabled"             => $result['body']->{'cloudPropertyElement'}->{'searchEnabled'},
            "storageLimitInKb"          => $result['body']->{'cloudPropertyElement'}->{'storageLimitInKb'},
            "showBackupOverview"        => $result['body']->{'cloudPropertyElement'}->{'showBackupOverview'},
            "showBackupHistory"         => $result['body']->{'cloudPropertyElement'}->{'showBackupHistory'},
            "showFailedBackupHistory"   => $result['body']->{'cloudPropertyElement'}->{'showFailedBackupHistory'},
            "showSystemsWithoutBackups" => $result['body']->{'cloudPropertyElement'}->{'showSystemsWithoutBackups'},
            "showRestoreHistory"        => $result['body']->{'cloudPropertyElement'}->{'showRestoreHistory'},
            "showStorageUtilizationReport" => $result['body']->{'cloudPropertyElement'}->{'showStorageUtilizationReport'},
            "showDeviceHeartbeatReport" => $result['body']->{'cloudPropertyElement'}->{'showDeviceHeartbeatReport'},
            "showUserBackupSummary"     => $result['body']->{'cloudPropertyElement'}->{'showUserBackupSummary'},
	    "enableRecaptcha"           => $result['body']->{'cloudPropertyElement'}->{'enableRecaptcha'},
	    "googleAuthenticator"       => $result['body']->{'cloudPropertyElement'}->{'googleAuthenticator'},
	    "eyeOption"           	=> $result['body']->{'cloudPropertyElement'}->{'eyeOption'},
	    "complexPassword"           => $result['body']->{'cloudPropertyElement'}->{'complexPassword'},
            "flipTotalCompletedBackups" => ($result['body']->{'cloudPropertyElement'}->{'flipTotalCompletedBackups'}) ? true : false,
            "flipTotalActualStorageUtilized" => ($result['body']->{'cloudPropertyElement'}->{'flipTotalActualStorageUtilized'}) ? true : false,
            "totalCompletedBackups"     => ($result['body']->{'cloudPropertyElement'}->{'totalCompletedBackups'}) ? true : false,
            "totalActualStorageUtilized"=> ($result['body']->{'cloudPropertyElement'}->{'totalActualStorageUtilized'}) ? true : false,
            "hideDashboard"         	=> ($result['body']->{'cloudPropertyElement'}->{'hideDashboard'}) ? true : false,
            "extensionsToPdfView"       => $result['body']->{'cloudPropertyElement'}->{'extensionsToPdfView'},
            "stopPauseAccess"         	=> ($result['body']->{'cloudPropertyElement'}->{'stopPauseAccess'}) ? true : false,
            "winDeviceDisplayNameUpdate"=> ($result['body']->{'cloudPropertyElement'}->{'winDeviceDisplayNameUpdate'}) ? true : false,
            "macDeviceDisplayNameUpdate"=> ($result['body']->{'cloudPropertyElement'}->{'macDeviceDisplayNameUpdate'}) ? true : false,
	    "brevityLogging"		=> ($result['body']->{'cloudPropertyElement'}->{'brevityLogging'}) ? true : false,
            "globalCheckForLocalStorage"=> ($result['body']->{'cloudPropertyElement'}->{'globalCheckForLocalStorage'}) ? true : false,
	    "policyEdit" => ($result['body']->{'cloudPropertyElement'}->{'policyEdit'}) ? true : false,
	    "gatewayNameChanged"           => $result['body']->{'cloudPropertyElement'}->{'gatewayNameChanged'},
	    "showCurrentlyRunningReports" => ($result['body']->{'cloudPropertyElement'}->{'showCurrentlyRunningReports'}) ? true : false,
            "showSupportPage" => ($result['body']->{'cloudPropertyElement'}->{'showSupportPage'}) ? true : false,
            "useLocalPackage" => ($result['body']->{'cloudPropertyElement'}->{'useLocalPackage'}) ? true : false,
	    "showAuditHistory"            => ($result['body']->{'cloudPropertyElement'}->{'showAuditHistory'}) ? true : false,
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/globalSettings', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function portalProperties(){
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token'),
            'componentName' => PARACLOUD_IP
        );

        $result = $this->_model->getPortalProperties($headers);
$this->log("-------> ".json_encode($result['body']->{'portalProperties'}->{'componentsProperties'}),"info");
$this->log("-------> ".json_encode($result['body']->{'portalProperties'}->{'componentsProperties'}->{'PORTAL_LIGHT_VERSION'}),"info");
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('Portal Properties'),
            'active' => 'settings',
            'portal' => $result['body']->{'portalProperties'}->{'componentsProperties'},
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/portalProperties', $data);
        View::renderTemplate('footer', $data);
}

    public function writePortalProperties(){
            $headers = array(
                'Content-Type'  => 'application/json',
                'Accept'        => 'application/json',
                'token'         => $this->session->get('token'),
            );
            $data = array(
                "componentName" => PARACLOUD_IP,
                "componentsProperties" => array(
                "WINDOWS_CLIENT_FILENAME" => $_POST["WindowsClientFilename"],
                "MAC_CLIENT_FILENAME"=> $_POST["MacClientFilename"],
                "MAX_ENABLE_PARTIAL_FILE_TRANSFER"=> $_POST["MaximumEnablePartialFileTransfer"],
                "MAX_PARTIAL_FILE_TRANSFER_CHUNK_SIZE"=> $_POST["MaximumPartialFileTransferChunkSize"],
                "STORAGE_TYPE"=> $_POST["StorageType"],
                "PROXY_URL"=> $_POST["ProxyURL"],
                "PROXY_USERNAME"=> $_POST["ProxyUsername"],
                "PROXY_PASSWORD"=> $_POST["ProxyPassword"],
                "COPYRIGHT_NAME"=> $_POST["CopyrightName"],
                "NEIL_IMG_NAME"=> $_POST["LoginPageImage"],
                "HEADER_NAME"=> $_POST["HeaderImage"],
                "ENABLE_IDEAL_TIMEOUT"=> filter_var($_POST["EnableIdealTimeout"], FILTER_VALIDATE_BOOLEAN),
                "IDEAL_TIMEOUT"=> $_POST["IdealTimeout"],
                "COMPLEX_PASSWORD"=> filter_var($_POST["ComplexPassword"], FILTER_VALIDATE_BOOLEAN),
                "SHARE_WITHIN_ORG"=> filter_var($_POST["ShareWithinOrg"], FILTER_VALIDATE_BOOLEAN),
                "DISK_SPACE_DETAILS"=> filter_var($_POST["DiskSpaceDetails"], FILTER_VALIDATE_BOOLEAN),
                "EULA_ENABLED"=> filter_var($_POST["EULAEnabled"], FILTER_VALIDATE_BOOLEAN),
                "PORTAL_LIGHT_VERSION"=> filter_var($_POST["PortalLightVersion"], FILTER_VALIDATE_BOOLEAN),
                "REQ_RES_LOGS"=> filter_var($_POST["RequestResponseLogs"], FILTER_VALIDATE_BOOLEAN),
                "ENABLE_EYE"=> filter_var($_POST["EnableEye"], FILTER_VALIDATE_BOOLEAN),
                "DISABLE_VIEW"=> filter_var($_POST["DisableView"], FILTER_VALIDATE_BOOLEAN),
                "DISABLE_DOWNLOAD"=> filter_var($_POST["DisableDownload"], FILTER_VALIDATE_BOOLEAN),
                "BLUDRIVE_MODE"=> filter_var($_POST["BluDriveMode"], FILTER_VALIDATE_BOOLEAN),
                "RELAXED_CHECK"=> filter_var($_POST["RelaxedCheck"], FILTER_VALIDATE_BOOLEAN),
                "TOTAL_COMPLETED_BACKUPS"=> filter_var($_POST["ShowTotalCompletedBackups"], FILTER_VALIDATE_BOOLEAN),
                "TOTAL_ACTUAL_STORAGE_UTILIZED"=> filter_var($_POST["ShowTotalActualStorageUtilized"], FILTER_VALIDATE_BOOLEAN),
                "ENABLE_EPA"=> filter_var($_POST["EnableEPA"], FILTER_VALIDATE_BOOLEAN),
                "WINDOWS_EPA"=> filter_var($_POST["WindowsEPA"], FILTER_VALIDATE_BOOLEAN),
                "MAC_EPA"=> filter_var($_POST["MacEPA"], FILTER_VALIDATE_BOOLEAN),
                "ENABLE_MOBILE_APPS"=> filter_var($_POST["EnableMobileApps"], FILTER_VALIDATE_BOOLEAN),
                "ENABLE_ANDROID_APP"=> filter_var($_POST["EnableAndroidApp"], FILTER_VALIDATE_BOOLEAN),
                "ENABLE_WINDOWS_PHONE_APP"=> filter_var($_POST["EnableWindowsPhoneApp"], FILTER_VALIDATE_BOOLEAN),
                "ENABLE_IOS_APP"=> filter_var($_POST["EnableIosApp"], FILTER_VALIDATE_BOOLEAN),
                "DISCLAIMER"=> filter_var($_POST["Disclaimer"], FILTER_VALIDATE_BOOLEAN),
                "HEADER_LOGO"=> filter_var($_POST["EnableHeaderLogo"], FILTER_VALIDATE_BOOLEAN),
                "FLIP_TOTAL_COMPLETED_BACKUPS"=> filter_var($_POST["FLIP_TOTAL_COMPLETED_BACKUPS"], FILTER_VALIDATE_BOOLEAN),
                "FLIP_TOTAL_ACTUAL_STORAGE_UTILIZED"=> filter_var($_POST["FLIP_TOTAL_ACTUAL_STORAGE_UTILIZED"], FILTER_VALIDATE_BOOLEAN),
                "RECAPTCHA"=> filter_var($_POST["RECAPTCHA"], FILTER_VALIDATE_BOOLEAN),
                "GOOGLE_AUTHENTICATOR"=> filter_var($_POST["GOOGLE_AUTHENTICATOR"], FILTER_VALIDATE_BOOLEAN)
                )
            );
            $result = $this->_model->savePortalProperties($headers,json_encode($data));
            $this->log("Result:".json_encode($result), "info");
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('Details have been successfully saved')
                        );
                        echo json_encode($response);
                    exit;
                case (202):
                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('Details have been successfully saved')
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    /**
     * Below Method Renders Encryption settings page
     */
    public function cloudCredentials(){
        $userDetails = $this->_model->getUserDetails(array('token' => $this->session->get('token')), $this->session->get("userName"));
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token')
        );

        $result = $this->_model->getOdbDetails($headers);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('cloudCredentials'),
            'active' => 'settings',
            'userDetails' => $userDetails['body'],
            'loggedInUser' => $this->session->all(),
            'csrf_token' => $this->setCSRFToken(),

            'clientID'=> $result["body"]->{"clientId"},
            'clientRedirectURI'=> $result["body"]->{"clientRedirectURI"},
            'portalURL'=> $result["body"]->{"portalURL"},
            'clientSecretKey'=> $result["body"]->{"clientSecretKey"},
            'clientResourceURL'=> $result["body"]->{"clientResourceURL"},
            'clientTokenURL'=> $result["body"]->{"clientTokenURL"},
	    'user_principal' => $result["body"]->{"accountId"},
            'configId'=> $result["body"]->{"configId"},
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/cloudCredentials', $data);
        View::renderTemplate('footer', $data);
    }

    public function getAllCcS(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
        $ccS = [];
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token')
        );
        $result = $this->_model->getCloudCredentials($headers);
        $this->log($result);
        switch ($result['status']) {
            case (200):
                if(!empty($result['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
                    foreach($result['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $value){
                        switch($value->cloudName){
                            case 'azureBlob':
                                $value->cloudNameInCaps = 'Azure Blob';
                                break;
                            case 'b2':
                                $value->cloudNameInCaps = 'Backblaze';
                                break;
                            case 'ibmCloud':
                                $value->cloudNameInCaps = 'IBM Cloud - Swift';
                                break;
                            case 's3':
				$value->cloudNameInCaps = 'S3 Compatibles';
                                //$value->cloudNameInCaps = 'IBM Cloud - S3';
                                break;
                            case 'amazon':				
                                $value->cloudNameInCaps = 'Amazon S3 Buckets';
                                break;
                            case 'localStorage':
                                $value->cloudNameInCaps = 'Local Storage';
                                break;
                            default:
                                $value->cloudNameInCaps = '';
                                break;
                        }

                        $ccS = array_merge(array($value), $ccS);
                    }
                }
                $response = array(
                    'result' => 'success',
                    'ccS' => $ccS,
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function saveCloudCredentials(){
        if(!empty($_POST['cloudType'])){
            $data = array(
                'cloudName' => trim($_POST['cloudType']),
                'identity' => ($_POST['cloudType'] == "localStorage") ? "local" : $_POST['identity'],
                'credential' => trim($_POST['accessKey']),
                'containerName' => !empty($_POST['containerName']) ? $_POST['containerName'] : '',
                'endPointUrl' => ($_POST['cloudType'] == "localStorage") ? $_POST['localStorage'] : $_POST['epaUrl'],
            );
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'          => $this->session->get('token')
            );
            $result = $this->_model->saveCloudCredentials($headers, $data);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('savedCloudCredentials')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
        }
    }

    public function removeCloudCredentials(){
        if(!empty($_POST['identity'])){
            $headers = array(
                'Content-Type'      => 'application/json',
                'identity'          => $_POST['identity'],
                'token'             => $this->session->get('token')
            );
            $result = $this->_model->removeCloudCredentials($headers);
            $this->log("headers: ". json_encode($headers), 'info');
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('removeCloudCredentials')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function aadCredentials(){
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token'),
            'Accept'        => 'application/json',
                'Accept-Charset'=> 'utf-8',
        );
        $result = $this->_model->getAadDetails($headers);
        $this->log("ggggggggggg : ".$result['body']->{'data'}->{'clientId'},"info");
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('aadCredentials'),
            'active' => 'settings',
            'data' => $result['body']->{'AADCredentialsElement'},
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        $this->log("ggggggggggg : ".$data['data']->{'clientId'},"info");

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/aadCredentials', $data);
        View::renderTemplate('footer', $data);
    }

    public function getAadCredentials(){
            $headers = array(
                'Content-Type'      => 'application/json',
                'Accept'        => 'application/json',
                'token'             => $this->session->get('token')
            );

            $result = $this->_model->getAadDetails($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'aad'    => $result['body']->{'AADCredentialsElement'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (404):
                    $result = array(
                        'result' => 'fail',
                        'msg' => "No AAD Credentials found"
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function writeAddAadSettings(){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),

            );
            $combine = array_combine($_POST['aadGroupNameadd'], $_POST['aadProductTypeadd']);
            $groupConfig = array('groupConfig' => $combine );


            $this->log("Result:".json_encode($groupConfig), "info");
            $data = array(
                'clientIdForLogin'  => trim($_POST['clientIdForLoginadd']),
                'clientId'          => trim($_POST['clientIdadd']),
                'secretKey'         => trim($_POST['secretKeyadd']),
                'tenentId'          => trim($_POST['tenentIdadd']),
                'redirectURI'       => trim($_POST['redirectURIadd']),
                'endpointRedirectURI'       => trim($_POST['endpointRedirectURIadd']),
                'portalRedirectURI' => trim($_POST['portalRedirectURIaad']),
		'loginMode' => $_POST['loginMode2'],
                'groupConfig'       => $combine,
            );
            $this->log("DATA :".json_encode($data), "info");
            $result = $this->_model->saveAadDetails($headers,json_encode($data));
            $this->log("Result:".json_encode($result), "info");


            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('Details has been successfully saved')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function writeAadSettings(){
        if(!empty($_POST['aadProductType'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),

            );
            $combine = array_combine($_POST['aadGroupName'], $_POST['aadProductType']);
            $groupConfig = array('groupConfig' => $combine );


            $this->log("Result:".json_encode($groupConfig), "info");
            $data = array(
                'clientIdForLogin'  => trim($_POST['clientIdForLogin']),
                'clientId'          => trim($_POST['clientId']),
                'secretKey'         => trim($_POST['secretKey']),
                'tenentId'          => trim($_POST['tenentId']),
                'redirectURI'       => trim($_POST['redirectURI']),
                'endpointRedirectURI'       => trim($_POST['endpointRedirectURI']),
                'portalRedirectURI' => trim($_POST['portalRedirectURI']),
		'loginMode' => $_POST['loginMode1'],
                'groupConfig'       => $combine,
            );
            $this->log("DATA :".json_encode($data), "info");
            $result = $this->_model->saveAadDetails($headers,json_encode($data));
            $this->log("Result:".json_encode($result), "info");


            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('Details has been successfully saved')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => 'Please specify at least on Product type'
                )
            );
        }
    }
    
    public function sharepoint(){
        Auth::allowOnly('admin');
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token')
        );

        $result = $this->_model->getOdbDetails($headers);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('sharepoint'),
            'active' => 'settings',
            'clientID'=> $result["body"]->{"clientId"},
            'clientRedirectURI'=> $result["body"]->{"clientRedirectURI"},
            'portalURL'=> $result["body"]->{"portalURL"},
            'clientSecretKey'=> $result["body"]->{"clientSecretKey"},
            'clientResourceURL'=> $result["body"]->{"clientResourceURL"},
            'configId'=> $result["body"]->{"configId"},
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/sharepoint', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function saveSharepointConfiguration(){

        if(!empty($_POST['clientId']) && !empty($_POST['clientSecret'])){
        file_put_contents('/var/www/PHPAppForSharePointMaster/PHP/config.php',"<?php 
        \$client_id = '".$_POST['clientId']."';
        \$client_secret = '".$_POST['clientSecret']."';
        \$redirectURL = '".$_POST['redirectURL']."';
        ?>");
        $clientId = $_POST['clientId'];
        $redirectURL = $_POST['redirectURL'];
        $this->log("inside createPackage","info");
        shell_exec("mkdir /var/www/portal/app/templates/default/new && chown -R www-data:www-data /var/www/portal/app/templates/default/new && chmod -R 755 /var/www/portal/app/templates/default/new");
        shell_exec("unzip /var/www/PHPAppForSharePointMaster/AppPackage.app -d /var/www/portal/app/templates/default/new");
        $xmlString = '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
            <App xmlns="http://schemas.microsoft.com/sharepoint/2012/app/manifest" Name="PHP2" ProductID="{7944BC76-82CF-4807-8906-6205BB85E2FE}" SharePointMinVersion="15.0.0.0" Version="1.0.0.1"><Properties><Title>PHP App for SharePoint</Title><StartPage>'.$redirectURL.'/PHPAppForSharePointMaster/PHP/index.php?{StandardTokens}</StartPage></Properties><AppPrincipal><RemoteWebApplication ClientId="'.$clientId.'"/></AppPrincipal>
            <AppPermissionRequests>
            <AppPermissionRequest Scope="http://sharepoint/content/sitecollection/web" Right="Write" />
            <AppPermissionRequest Scope="http://sharepoint/content/sitecollection" Right="Write" />    
            <AppPermissionRequest Scope="http://sharepoint/content/tenant" Right="Write" />
            </AppPermissionRequests>
         </App>';
        file_put_contents('/var/www/portal/app/templates/default/new/AppManifest.xml',$xmlString);
        shell_exec("cd /var/www/portal/app/templates/default/new && zip -r AppPackage.zip *");
        $this->log("after zipping","info");
        shell_exec("cp /var/www/portal/app/templates/default/new/AppPackage.zip /var/www/portal/app/templates/default/documents/");
        shell_exec("rm -rf /var/www/portal/app/templates/default/new");
        shell_exec("mv /var/www/portal/app/templates/default/documents/AppPackage.zip /var/www/portal/app/templates/default/documents/AppPackage.app");
                    $headers = array(
                        'Content-Type'  => 'application/json',
                        'token'         => $this->session->get('token')
                    );
                    $odbDetails = array(
                        'clientId' => trim($_POST['clientId']),
                        'configId' => "",//trim($_POST['configId']),
                        'clientSecretKey' => trim($_POST['clientSecret']),
                        'clientRedirectURI' => trim($_POST['redirectURL']),
                        'clientResourceURL' => trim($_POST['clientResourceURL']),
                        'clientTokenURL' => " ",//trim($_POST['clientTokenURL']),
                        'portalURL' => " "//trim($_POST['portalURL'])
                    );
        	        $result = $this->_model->saveOdbDetails($headers, $odbDetails);
                    $this->log(json_encode($odbDetails), "info");
                    switch ($result['status']) {
                        case (200):
        
                            $data = array(
                                'result' => 'success',
                                'msg' => 'Details has been successfully saved'
                            );
                            echo json_encode($data);
                            exit;
        
                        case (421):
                            $result = array(
        			            'result' => 'fail',
                                'msg' => $this->language->get('421')
                            );
                            echo json_encode($result);
                            exit();
                        case (500):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('500')
                            );
                            echo json_encode($result);
                            exit();
                        case (0):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('0')
                            );
                            echo json_encode($result);
        		    exit();
                        default:
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('default')
                            );
                            echo json_encode($result);
                            exit();
                    }
                }else {
                    $data = array(
                        "post" => $_POST,
                        'result' => 'error',
                        'msg' => 'None of the field listed should be empty'
                    );
                    echo json_encode($data);
                }
    }


    public function downloadIt(){
        $filePath = "/var/www/portal/app/templates/default/documents/AppPackage.app";
            if(file_exists($filePath)){
                $this->log("file present----->","info");
                $this->log("inside download ","info");
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename=AppPackage.app');
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);}
        }

    public function createPackage(){
        $clientId = "76ad67cf-115f-4b10-ba6e-5333f974a6e2";
        $redirectURL = "https://naveen.devenv.parablu.com";
        $this->log("inside createPackage","info");
        shell_exec("mkdir /var/www/portal/app/templates/default/new && chown -R www-data:www-data /var/www/portal/app/templates/default/new && chmod -R 755 /var/www/portal/app/templates/default/new");
        shell_exec("unzip /var/www/PHPAppForSharePointMaster/AppPackage.app -d /var/www/portal/app/templates/default/new");
        $xmlString = '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
            <App xmlns="http://schemas.microsoft.com/sharepoint/2012/app/manifest" Name="PHP2" ProductID="{7944BC76-82CF-4807-8906-6205BB85E2FE}" SharePointMinVersion="15.0.0.0" Version="1.0.0.1"><Properties><Title>PHP App for SharePoint</Title><StartPage>'.$redirectURL.'/index.php?{StandardTokens}</StartPage></Properties><AppPrincipal><RemoteWebApplication ClientId="'.$clientId.'"/></AppPrincipal>
            <AppPermissionRequests>
            <AppPermissionRequest Scope="http://sharepoint/content/sitecollection/web" Right="Write" />
            <AppPermissionRequest Scope="http://sharepoint/content/sitecollection" Right="Write" />    
            <AppPermissionRequest Scope="http://sharepoint/content/tenant" Right="Write" />
            </AppPermissionRequests>
         </App>';
        $this->log("aftre xml","info");
        file_put_contents('/var/www/portal/app/templates/default/new/AppManifest.xml',$xmlString);
        $this->log("after xml writing","info");
        shell_exec("cd /var/www/portal/app/templates/default/new && zip -r AppPackage.zip *");
        $this->log("after zipping","info");
        shell_exec("cp /var/www/portal/app/templates/default/new/AppPackage.zip /var/www/portal/app/templates/default/documents/");
        shell_exec("rm -rf /var/www/portal/app/templates/default/new");
        shell_exec("mv /var/www/portal/app/templates/default/documents/AppPackage.zip /var/www/portal/app/templates/default/documents/AppPackage.app");
    }
    
    public function epaManager(){

        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('smtp'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/epaManager', $data);
        View::renderTemplate('footer', $data);
    }


    public function getEPAWindows(){
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token')
        );
        
        $result = $this->_model->getEPAWindows($headers);
        
        $macDetails = [];
        $winDetails = [];
        if($result['body']->{'productElementList'}){
            foreach($result['body']->{'productElementList'} as $value){
                if($value->{'productMinorGroup'} == 'mac'){
                    $macDetails = array(
                                        'productMinorGroup' => (string)$value->{'productMinorGroup'},
                                        'productVersion' => (string)$value->{'productVersion'},
                                        'updateAgent' => $value->{'updateAgent'},
                                        'downloadAgent' => $value->{'downloadAgent'}
                                    );
                    }
    
                if($value->{'productMinorGroup'} == 'service'){
                    $winDetails = array(
                                        'productMinorGroup' => (string)$value->{'productMinorGroup'},
                                        'productVersion' => (string)$value->{'productVersion'},
                                        'updateAgent' => $value->{'updateAgent'},
                                        'downloadAgent' => $value->{'downloadAgent'} 
                                    );
                    }
            }
        }

		switch ($result['status']) {
            case (200):
                $response = array(
                    'result' => 'success',
                    'macDetails'    => $macDetails,
                    'winDetails' => $winDetails
                );
                echo json_encode($response);
                exit;
            case (204):
                $result = array(
                    'result' => 'success',
                    'macDetails'    => $macDetails,
                    'winDetails' => $winDetails
                );
                echo json_encode($result);    
                exit();
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);    
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function saveEPAWindows(){
    	$this->log("Called saveEPAWIndows ","info");
    	//start
    	if (isset($_FILES['updateFileName'])) {
    			$path = "/parablu/updates/";
    			if (!is_dir($path)) {
                    $result = array(
                                'result' => 'fail',
                                'msg' => 'No Directory Found'
                    );
                    die(json_encode($result));
                }
    	        //$all_files = count($_FILES['updateFileName']['tmp_name']);
    			//$this->log("inside all_files: ".$all_files,"info");
    	            $file_name = $_FILES['updateFileName']['name'];
    	            $file_tmp = $_FILES['updateFileName']['tmp_name'];
    	            $file_type = $_FILES['updateFileName']['type'];
    	            $file_size = $_FILES['updateFileName']['size'];
    	            $file_ext = strtolower(end(explode('.', $_FILES['updateFileName']['name'])));
    
    	            $file = $path . $file_name;
    	            $this->log("file :  ".$file,"info");
    	                if ($errors) {
    	                        $this->log("ERRORS WHILE UPLOADING".json_encode($errors),"info");
    	                        $result = array(
    	                            'result' => 'fail',
    	                            'msg'    => 'Failed to upload agent'
    	                        );
    	                        die(json_encode($result));
    	                }
    	                
    		            if (empty($errors)) {
    		                $this->log("success ","info");
    		                move_uploaded_file($file_tmp, $file);
    		                chmod($file, 0777);
    						$response = array(
    		                        'result' => 'success',
    		                        'msg'    => 'Agent uploaded succesfully'
    		                    );
    		                    echo json_encode($response);
    		                    exit;
    					}else{
    						$response = array(
    	                        'result' => 'fail',
    	                        'msg'    => 'Failed to upload agent'
    	                    );
    	                    echo json_encode($response);
    	                    exit;
    					}
    	}else{
    		saveEPAWindowsOne();
    	}
    	//end
    }
    
    public function saveEPAWindowsOne(){
    	$this->log("Called saveEPAWIndowsOne ","info");
    	if(empty($_POST['autoUpdate']) || $_POST['autoUpdate'] != 'enabled'){
    		$_POST['autoUpdate'] = 'false';
    	}else{
    	    $_POST['autoUpdate'] = 'true';
    	}
    	if(empty($_POST['downloadAgent']) || $_POST['downloadAgent'] != 'enabled'){
    	    $_POST['downloadAgent'] = 'false';
    	}else{
    	    $_POST['downloadAgent'] = 'true';
    	}
    	            $headers = array(
    	                'Content-Type'  => 'application/json',
    	                'token'         => $this->session->get('token'),
    					'autoUpdate' =>$_POST['autoUpdate'],
    					'downloadAgent' =>$_POST['downloadAgent'],
    					'updateFileName' =>$_FILES["updateFileName"]["name"],
    					//'autoUpdateEnabled' =>$_POST['allowUpdate'], 
    					'link' => trim($_POST['link']),
    					'productType' => 'windows'
    	            );
    	$this->log("jjjjjjjjjjjjjjjj : ".json_encode($headers),"info");
    
    	$this->log("jjjjjjjjjjjjjjjj : ".json_encode($_FILES['updateFileName']),"info");
    	$result = $this->_model->saveEPAWindows($headers);
    	            switch ($result['status']) {
    	                case (200):
    	                    $response = array(
    	                        'result' => 'success',
    	                        'response' => $result,
    	                        'msg'    => 'Details saved successfully.'
    	                    );
    	                    echo json_encode($response);
    	                    exit;
    	                case (421):
    	                    $result = array(
    	                        'result' => 'fail',
    	                        'msg' => $this->language->get('421')
    	                    );
    	                    echo json_encode($result);
    	                    exit();
    	                case (412):
                                $result = array(
                                    'result' => 'fail',
                                    'msg' => 'Selected file should have proper naming convention'
                                );
                                echo json_encode($result);
                                exit();
                        case (507):
                                $result = array(
                                    'result' => 'fail',
                                    'msg' => 'Failed to download file from DNS'
                                );
                                echo json_encode($result);
                                exit();
    	                case (500):
    	                    $result = array(
    	                        'result' => 'fail',
    	                        'msg' => $this->language->get('500')
    	                    );
    	                    echo json_encode($result);
    	                	exit();
    	                case (0):
    	                    $result = array(
    	                        'result' => 'fail',
    	                        'msg' => $this->language->get('0')
    	                    );
    	                    echo json_encode($result);
    	                    exit();
    	                default:
    	                    $result = array(
    	                        'result' => 'fail',
    	                        'response' => $result,
    	                        'msg' => $this->language->get('default')
    	                    );
    	                    echo json_encode($result);
    	                    exit();
    				}
    
    }
    
    // for Macccccccccccccccccc start
    public function saveEPAMac(){
    	$this->log("Called saveEPAMAC ","info");
    	//start
    	if (isset($_FILES['updateFileNameMac'])) {
    			$path = "/parablu/updates/";
    			if (!is_dir($path)) {
                $result = array(
                            'result' => 'fail',
                            'msg' => 'No Directory Found'
                );
                die(json_encode($result));
                }
    	        //$all_files = count($_FILES['updateFileNameMac']['tmp_name']);
    			//$this->log("inside all_files: ".$all_files,"info");
    	            $file_name = $_FILES['updateFileNameMac']['name'];
    	            $file_tmp = $_FILES['updateFileNameMac']['tmp_name'];
    	            $file_type = $_FILES['updateFileNameMac']['type'];
    	            $file_size = $_FILES['updateFileNameMac']['size'];
    	            $file_ext = strtolower(end(explode('.', $_FILES['updateFileNameMac']['name'])));
    
    	            $file = $path . $file_name;
    	            $this->log("file :  ".$file,"info");
    
    	
    
    	                if ($errors) {
    	                        $this->log("ERRORS WHILE UPLOADING".json_encode($errors),"info");
    	                        $result = array(
    	                            'result' => 'fail',
    	                            'msg'    => 'Failed to upload agent'
    	                        );
    	                        die(json_encode($result));
    	                }
    	                
    		            if (empty($errors)) {
    		                $this->log("success ","info");
    		                move_uploaded_file($file_tmp, $file);
    		                chmod($file, 0777);
    						$response = array(
    		                        'result' => 'success',
    		                        'msg'    => 'Agent uploaded succesfully'
    		                    );
    		                    echo json_encode($response);
    		                    exit;
    					}else{
    						$response = array(
    	                        'result' => 'fail',
    	                        'msg'    => 'Failed to upload agent'
    	                    );
    	                    echo json_encode($response);
    	                    exit;
    					}
    	}else{
    		saveEPAMacOne();
    	}
    	//end
    }

    public function saveEPAMacOne(){
    	$this->log("Called saveEPAMacOne ","info");
    	if(empty($_POST['autoUpdateMac']) || $_POST['autoUpdateMac'] != 'enabled'){
    		$_POST['autoUpdateMac'] = 'false';
    	}else{
    	    $_POST['autoUpdateMac'] = 'true';
    	}
    	if(empty($_POST['downloadAgentMac']) || $_POST['downloadAgentMac'] != 'enabled'){
    	    $_POST['downloadAgentMac'] = 'false';
    	}else{
    	    $_POST['downloadAgentMac'] = 'true';
    	}
    	            $headers = array(
    	                'Content-Type'  => 'application/json',
    	                'token'         => $this->session->get('token'),
    					//'autoUpdate' =>$_POST['autoUpdateMac'],
    					'downloadAgent' =>$_POST['downloadAgentMac'],
    					'updateFileName' =>$_FILES["updateFileNameMac"]["name"],
    					//'autoUpdateEnabled' =>$_POST['allowUpdateMac'], 
    					'link' => trim($_POST['linkMac']),
    					'productType' => 'mac'
    	            );
    	$this->log("jjjjjjjjjjjjjjjj : ".json_encode($headers),"info");
    
    	$this->log("jjjjjjjjjjjjjjjj : ".json_encode($_FILES['updateFileNameMac']),"info");
    	$result = $this->_model->saveEPAWindows($headers);
    	            switch ($result['status']) {
    	                case (200):
    	                    $response = array(
    	                        'result' => 'success',
    	                        'response' => $result,
    	                        'msg'    => 'Details saved successfully.'
    	                    );
    	                    echo json_encode($response);
    	                    exit;
    	                case (421):
    	                    $result = array(
    	                        'result' => 'fail',
    	                        'msg' => $this->language->get('421')
    	                    );
    	                    echo json_encode($result);
    	                    exit();
    	                case (412):
                                $result = array(
                                    'result' => 'fail',
                                    'msg' => 'Selected file should have proper naming convention'
                                );
                                echo json_encode($result);
                                exit();
                        case (507):
                                $result = array(
                                    'result' => 'fail',
                                    'msg' => 'Failed to download file from DNS'
                                );
                                echo json_encode($result);
                                exit();
    	                case (500):
    	                    $result = array(
    	                        'result' => 'fail',
    	                        'msg' => $this->language->get('500')
    	                    );
    	                    echo json_encode($result);
    	                	exit();
    	                case (0):
    	                    $result = array(
    	                        'result' => 'fail',
    	                        'msg' => $this->language->get('0')
    	                    );
    	                    echo json_encode($result);
    	                    exit();
    	                default:
    	                    $result = array(
    	                        'result' => 'fail',
    	                        'response' => $result,
    	                        'msg' => $this->language->get('default')
    	                    );
    	                    echo json_encode($result);
    	                    exit();
    				}

    }
    // for Macccccccccccccccccc end
    
    public function mongoProperties(){
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );
        
        $result = $this->_model->getMongoProperties($headers);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('Mongo Properties'),
            'active' => 'settings',
            'proxy' => $result['body']->{'mongoPropertiesElementList'},
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/mongoProperties', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function saveMongoProperties(){
        if(!empty($_POST['proxyHost']) && !empty($_POST['proxyUserName']) && !empty($_POST['proxyPassword']) && !empty($_POST['proxyPort'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),

            );
        $password_en = $_POST['proxyPassword'];
        $password_en = str_replace(".","+",$password_en);
        $password_en = str_replace("_","/",$password_en);
        $password_en = str_replace("-","=",$password_en);
        $privkey = '-----BEGIN RSA PRIVATE KEY-----
MIICXgIBAAKBgQDJa13jCuhhMNQfcXb6uRJEnKkQBQxpl1Dp5U8EDbo16KrSDT++
OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulqIg8Tca9eg/uVjg2DHs4wIyzN
J7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+xVCPksMvihMgXe2xLdwIDAQAB
AoGBAJgcOlIdSbMkYf3A/Z6JJ6+jM9YCSgZwHM4Wu56PE2Jk7KQnF019d+Di0Zj/
DCD15irXFzyxTk3v0d/3mr17I4Pl1G2E4CjbqoxFXm6AqJ8ETpExJE/cU/gA3Uyz
ROWpP1WYJIz5HPnnkcDF+5oHYDPhNnV4vzJ9FpYOvzjZt7URAkEA8Day1Cp4P77k
jGXaf0aO1iNUuQOqFh7Id4MY2bMnJxXs664ZGqKJ53h12mHSdkCWq1vjR9KI/1vd
l3JvUGNxWQJBANaoAIjDJaRI2mxirzkCcwz0IfFJzmB6nZAqAiekCenhb3FGw+lW
Px7qd3JfU1vf9OfUpuGa/e+S5XTIuFkLuU8CQQCd/Vvg743nX0YykUsEKwQHE3XF
ugNESTrQYAkYJhy6OFF7MSaRvhW1iCT7XRtva0utqOHzeyVfzqwPz9Qmq0EBAkA0
DUEz6L5z/AabScLbvDBR79FbRV56HsGed9FV831D7ZqsiVBwgK2Fva2BWoRIPyKQ
JQzioEb7lU925kVtsl4ZAkEAj6wYWg+Rac7QbbcrW6SxehOehgkaCoTSZ/O9bj0m
WEIoJbkE69ABYKnCadQVbwK5W8fCUpqto0qCvva2l2PWeQ==
-----END RSA PRIVATE KEY-----';
        $encrypted_password = $password_en;
        if(openssl_private_decrypt(base64_decode($encrypted_password), $decrypted, $privkey))
        {
                $proxyPassword = $decrypted;
        }
        $this->log("Resultencrypted_password:".$proxyPassword, "info");
            $data = array(
                'id'                 => $_POST['id'],
                'mongoIp'            => trim($_POST['mongoIp']),
                'proxyHost'          => trim($_POST['proxyHost']),
                'proxyUserName'      => trim($_POST['proxyUserName']),
                'proxyPassword'      => trim($proxyPassword),
                'proxyPort'          => trim($_POST['proxyPort']),
		'backupdir'          => $_POST['backupdir'],
                'archivedir'         => $_POST['archivedir'],
                'backblaze_id'       => $_POST['backblazeid'],
                'application_key'    => $_POST['applicationkey'],
                'backblaze_bucket'   => $_POST['backblazebucket'],
                'customer_name'      => $_POST['customername'],
                'backblaze_backup'   => $_POST['backblazebackup'],
                'encrypt_backup'     => $_POST['encryptbackup'],
            );
            $result = $this->_model->saveMongoProperties($headers,json_encode($data));
            $this->log("Result:".json_encode($result), "info");
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('Details have been successfully saved')
                        );
                    echo json_encode($response);
                    exit;
                case (202):
                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('Details have been successfully saved')
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }
    
    public function dataMigration(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('dataMigration'),
            'active' => 'settings',
            'loggedInUser' => $this->session->all(),
            'csrf_token' => $this->setCSRFToken(),
        );
	$data['graphApiEnabled'] = 'false';
	if($this->session->get('graphApiEnabled') == 'true'){
		$data['graphApiEnabled'] = 'true';	
	}

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/dataMigration', $data);
        View::renderTemplate('footer', $data);
    }

public function usersDataMigration(){
            $headers = array(
                'Content-Type'      => 'application/json',
                'Accept'        => 'application/json',
                'token'             => $this->session->get('token')
            );

            $result = $this->_model->usersDataMigration($headers);
            $this->log("usersDataMigration : ".json_encode($result['body']->{'userElementResponse'}->{'users'}),"info");
	    $users = [];
	    if(!empty($result['body']->{'userElementResponse'}->{'users'})){
                foreach($result['body']->{'userElementResponse'}->{'users'} as $value){
			if($value->{'active'} == false && $value->{'migrationStatus'} != 'COMPLETED'){
                    		$user = $value->{'userName'};
                    		$users = array_merge(array($user), $users);
			}
                }
            }
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'users'    => $users
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (404):
                    $result = array(
                        'result' => 'fail',
                        'msg' => "No AAD Credentials found"
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function startDataMigration(){
        $this->log("Called startDataMigration ","info");
        $_POST['users'] = implode(',', $_POST['users']);
        $headers = array(
            'Content-Type'  => 'application/json',
            'Accept'  => 'application/json',
            'token'         => $this->session->get('token'),
            'users' => $_POST['users'],
            'destOdbId' => $_POST['bucketName'],
        );
        $this->log("jjjjjjjjjjjjjjjj : ".json_encode($headers),"info");
        $result = $this->_model->startDataMigration($headers);
                    switch ($result['status']) {
                        case (200):
                            $response = array(
                                'result' => 'success',
                                'response' => $result,
                                'msg'    => 'Migration process started.'
                            );
                            echo json_encode($response);
                            exit;
                        case (421):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('421')
                            );
                            echo json_encode($result);
                            exit();
                        case (500):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('500')
                            );
                            echo json_encode($result);
                            exit();
                        case (0):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('0')
                            );
                            echo json_encode($result);
                            exit();
                        default:
                            $result = array(
                                'result' => 'fail',
                                'response' => $result,
                                'msg' => $this->language->get('default')
                            );
                            echo json_encode($result);
                            exit();
                    }

    }
	
    public function browse(){
            $headers = array(
                    'token'     => $this->session->get('token'),
                    'Accept' => 'application/json',
                    'folderpath' => $_POST['folderpath']
            );
            $result = $this->_model->browse($headers, $_POST['deviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'stringList'  => $result['body']->{'stringList'}
                    );
                    echo json_encode($response);
                    exit;
		case (406):
                    $result = array(
                        'result' => 'fail',
                        'msg' => "Please select a destination device"
                    );
                    echo json_encode($result);
                    exit();
                case (204):
                    $result = array(
                        'result' => 'fail',
                        'msg' => "No Restore in Queue"
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
		case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }


    public function browseOnedrive(){
            $headers = array(
                    'token'     => $this->session->get('token'),
                    'Accept' => 'application/json',
                    'folderpath' => $_POST['folderpath']
            );
            $result = $this->_model->browseOnedrive($headers, $_POST['deviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'stringList'  => $result['body']->{'stringList'}
                    );
                    echo json_encode($response);
                    exit;
		case (406):
                    $result = array(
                        'result' => 'fail',
                        'msg' => "Please select a destination device"
                    );
                    echo json_encode($result);
                    exit();
                case (204):
		    $result = array(
                        'result' => 'fail',
                        'msg' => "No Restore in Queue"
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
		    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
    public function curlCall(){
	$scriptOutput = shell_exec('bash /var/www/portal/app/curl.sh >> naveen.log');
	//$scriptOutput = shell_exec('bash /parablu-scripts/Installable/scripts/curl.sh');
	$this->log("CURLCALL RESPONSE : ".json_encode($scriptOutput),"info");
	$response = array(
                    'result' => 'success'
                );
                echo json_encode($response);
                exit;
    }
	
    public function brandingUpload(){
	$valid_extensions = array('jpeg', 'jpg', 'png', 'gif', 'bmp' , 'pdf' , 'doc' , 'ppt', 'txt', 'xml'); // valid extensions
	$path = '/var/www/portal/app/templates/default/collateral/'; // upload directory
	$loginimg = $_FILES['loginlogo']['name'];
	$logintmp = $_FILES['loginlogo']['tmp_name'];

	$headerimg = $_FILES['headerlogo']['name'];
	$headertmp = $_FILES['headerlogo']['tmp_name'];

	$disclaimerFile = $_FILES['disclaimer']['name'];
	$disclaimertmp = $_FILES['disclaimer']['tmp_name'];

	$customemailFile = $_FILES['customemail']['name'];
	$customemailtmp = $_FILES['customemail']['tmp_name'];

	$extLogin = strtolower(pathinfo($loginimg, PATHINFO_EXTENSION));
	$extHeader = strtolower(pathinfo($headerimg, PATHINFO_EXTENSION));
	$extDisclaimer = strtolower(pathinfo($disclaimerFile, PATHINFO_EXTENSION));
	$extCustomemail = strtolower(pathinfo($customemailFile, PATHINFO_EXTENSION));
	if(in_array($extLogin, $valid_extensions) || in_array($extHeader, $valid_extensions) || in_array($extDisclaimer, $valid_extensions) || in_array($extCustomemail, $valid_extensions)){
	$pathLogin = $path.'login_logo.png';
	$pathHeader = $path.'header_logo.png';
	$pathDisclaimer = $path.'disclaimer.txt';
	$pathCustomemail = $path.'emails.xml';
	//if(move_uploaded_file($logintmp,$pathLogin) && move_uploaded_file($headertmp,$pathHeader) && move_uploaded_file($disclaimertmp,$pathDisclaimer) && move_uploaded_file($customemailtmp,$pathCustomemail)){
	move_uploaded_file($logintmp,$pathLogin);
	move_uploaded_file($headertmp,$pathHeader);
	move_uploaded_file($disclaimertmp,$pathDisclaimer);
	move_uploaded_file($customemailtmp,$pathCustomemail);		
	$scriptOutput = shell_exec('bash /var/www/portal/app/branding.sh');
	$branding = [];

	$data1 = array(
			    "fileName" => 'login_logo.png',
			    "filePath" => '/var/www/portal/app/templates/default/collateral/'
		);
	$data2 = array(
			    "fileName" => 'header_logo.png',
			    "filePath" => '/var/www/portal/app/templates/default/collateral/'
		    );
	$data3 = array(
			    "fileName" => 'disclaimer.txt',
			    "filePath" => '/var/www/portal/app/templates/default/collateral/'
		    );
	$data4 = array(
			    "fileName" => 'emails.xml',
			    "filePath" => '/var/www/portal/app/templates/default/collateral/'
		    );

	array_push($branding,$data1);
	array_push($branding,$data2);
	array_push($branding,$data3);
	array_push($branding,$data4);
	$final = array("brandingItems" => $branding);
	$headers = array(
		    'Content-Type'         => 'application/json',
		    'token'         => $this->session->get('token')
		);
	$this->log("BRANDING DATA : ".json_encode($final),"info");
	$result = $this->_model->saveBranding($headers, json_encode($final));
	$this->log("BRANDING : ".json_encode($result),"info");

			$response = array(
			    'result' => 'success',
			);
			echo json_encode($response);
			exit;
	//	}
	}else{
			$response = array(
			    'result' => 'invalid',
			    'msg' => 'File extension is not supported'
			);
			echo json_encode($response);
			exit;
	}
		if($errorimg > 0){
			$response = array(
			    'result' => ' An error occurred while uploading the file'
			);
			echo json_encode($response);
			exit;
		}

    }
	
      public function licenseKey(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
             'crumb1' => 'License Key Management',
            'active' => 'settings',
            'loggedInUser' => $this->session->all(),
            'csrf_token' => $this->setCSRFToken(),
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/licenseKey', $data);
        View::renderTemplate('footer', $data);
    }

public function uploadLicenseKey(){
        $this->log("Called uploadlicensekey from portal ","info");
        //start
        $path = "/parablu/LicenseKey/encryptedFiles/";
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token'),
            'fileName' => $_FILES['licenseKeyFileName']['name']
        );
                if (!is_dir($path)) {
                    $result = array(
                                'result' => 'fail',
                                'msg' => 'No Directory Found'
                    );
                    die(json_encode($result));
                }
                    $file_name = $_FILES['licenseKeyFileName']['name'];
                    $file_tmp = $_FILES['licenseKeyFileName']['tmp_name'];
                    $file_type = $_FILES['licenseKeyFileName']['type'];
                    $file_size = $_FILES['licenseKeyFileName']['size'];
                    $file_ext = strtolower(end(explode('.', $_FILES['licenseKeyFileName']['name'])));
                    $file = $path . $file_name;
                    $this->log("file :  ".$file,"info");
                    if(file_exists($file)){
                            $this->log("License key with same name already exists.","info");
                                $result = array(
                                    'result' => 'exists',
                                    'msg'    => 'License key with same name already exists.'
                                );
                            die(json_encode($result));
                            exit();
                    }
                        if ($errors) {
                                $this->log("ERRORS WHILE UPLOADING".json_encode($errors),"info");
                                $result = array(
                                    'result' => 'fail',
				    'msg'    => 'Failed to upload license key'
                                );
                                die(json_encode($result));
                        }

                        if (empty($errors)) {
                            $this->log("success ","info");
                            move_uploaded_file($file_tmp, $file);
                            chmod($file, 0777);
                            $result = $this->_model->saveLicenseKey($headers);
            switch ($result['status']) {
            case (200):
                $response = array(
                    'result' => 'success',
                    'msg'    => 'License key uploaded succesfully'
            );
                unlink($file);
                echo json_encode($response);
                exit;
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => 'Failed to upload license key'
            );
                unlink($file);
                echo json_encode($result);
                exit();
                            }
                            }else{
                            $response = array(
                                'result' => 'fail',
                                'msg'    => 'Failed to upload license key'
);
                            unlink($file);
                            echo json_encode($response);
                            exit;
                            }
}

public function uploadLicenseKeyForce(){
        $this->log("Called force uploadlicensekey from portal ","info");
        //start
        $path = "/parablu/LicenseKey/encryptedFiles/";
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token'),
            'fileName' => $_FILES['licenseKeyFileName']['name']
        );
                if (!is_dir($path)) {
                    $result = array(
                                'result' => 'fail',
                                'msg' => 'No Directory Found'
		    );
                    die(json_encode($result));
                }
                    $file_name = $_FILES['licenseKeyFileName']['name'];
                    $file_tmp = $_FILES['licenseKeyFileName']['tmp_name'];
                    $file_type = $_FILES['licenseKeyFileName']['type'];
                    $file_size = $_FILES['licenseKeyFileName']['size'];
                    $file_ext = strtolower(end(explode('.', $_FILES['licenseKeyFileName']['name'])));

                    $file = $path . $file_name;
                    $this->log("file :  ".$file,"info");
                        if ($errors) {
                                $this->log("ERRORS WHILE UPLOADING".json_encode($errors),"info");
                                $result = array(
                                    'result' => 'fail',
                                    'msg'    => 'Failed to upload license key'
                                );
                                die(json_encode($result));
                                }

                        if (empty($errors)) {
                                $this->log("success ".$file,"info");
//                                unlink($file);
                            move_uploaded_file($file_tmp, $file);
                                chmod($file, 0777);
                                $result = $this->_model->saveLicenseKey($headers);
            switch ($result['status']) {
            case (200):
                $response = array(
                    'result' => 'success',
                    'msg'    => 'License key uploaded succesfully'
            );
                unlink($file);
                echo json_encode($response);
                exit;
            default:
		$result = array(
                    'result' => 'fail',
                    'msg' => 'Failed to upload license key'
                );
                unlink($file);
                echo json_encode($result);
                exit();
                                }
                            }else{
                            $response = array(
                                'result' => 'fail',
                                'msg'    => 'Failed to upload license key'
                        );
                            unlink($file);
                            echo json_encode($response);
                            exit;
                            }
	//end                         
}
public function getLicenseKeyList(){
        $licenseKeyList = [];
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token')
            );
        if($this->session->get('admin') == "1"){
            $result = $this->_model->getLicenseKeyList($headers);
        }

        if(!empty($result['body']->{'licenseKeyFileElementList'})){
                foreach($result['body']->{'licenseKeyFileElementList'} as $value){
                        $value->{'lastModifiedTimeMillis'} = $value->{'lastModifiedTime'};
                        $value->{'lastModifiedTime'} = date('d-M-Y H:i:s', (((int)$value->{'lastModifiedTime'}) / 1000));
                $licenseKeyList = array_merge(array($value), $licenseKeyList);
            }
        }

        switch ($result['status']) {
            case (200):
                $response = array(
                    'result' => 'success',
                    'licenseKeyList'    => $licenseKeyList
                );
                echo json_encode($response);
                exit;
	    case (507):
                $result = array(
                    'result' => 'fail',
                    'msg' => 'No License Key found'
                );
                echo json_encode($result);
                exit();
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
}



public function licenseKeyAction(){
        /*view start*/
if($_POST['action'] == 'view'){
        $headers = array(
                'Content-Type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
//            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token'),
            'fileName'          => $_POST['fileName'],
            'operation'         => $_POST['action'],
	    'cloudName'         => $this->session->get('cloudName')
    );
    $_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
                    $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
                    $t=time();
                    $_POST['fileName'] = $t.$_POST['fileName'];
                    $fileArray = explode('.', $_POST['fileName']);
                    list($extension) = array_reverse($fileArray);
                    $extension = strtolower($extension);
                    $fullPath = PARAVIEW_TMP_PATH;
                    $this->cleanUpTempDirectory($fullPath);

                    $result = $this->_model->viewLicenseKey($headers);

/*                    if($result['status'] != 200){
                        echo json_encode(array(
                            'result' => 'fail',
                            'msg' => 'Was not able to get file contents, error code - ' . $result['status']
                        ));
                        exit;
                    }

                    $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
                    $myFile = fopen($fileFullPath, "w");
                    if(!$myFile){
                        die("Unable to open file!");
                    }
                    $txt = $result['body'];
                    fwrite($myFile, $txt);
                    fclose($myFile);
                    $this->$extension();*/
                    switch($result['status']){
                    case (200);
                        $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
                    $myFile = fopen($fileFullPath, "w");
                    if(!$myFile){
                        die("Unable to open file!");
                        }
                    $txt = $result['body'];
                    fwrite($myFile, $txt);
                    fclose($myFile);
                    $this->$extension();
                case (507):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('507')
                );
                echo json_encode($result);
                exit();
                case (508):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('508')
                );
                echo json_encode($result);
                exit();
                case (509):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('509')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
}
/*view end*/
if($_POST['action'] == 'apply'){
$headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token'),
            'fileName'          => $_POST['fileName'],
            'operation'         => $_POST['action'],
	    'cloudName'         => $this->session->get('cloudName')
        );

$result = $this->_model->applyLicenseKey($headers);
switch ($result['status']) {
            case (200):

                $response = array(
                    'result' => 'success',
                    'msg'    => "License key configuration applied successfully.</b>"
                );
                echo json_encode($response);
                exit;
                case (507):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('507')
                );
                echo json_encode($result);
                exit();
                case (508):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('508')
                    );
                echo json_encode($result);
                exit();
                case (509):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('509')
                );
                echo json_encode($result);
                exit();
            case (510):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('510')
                );
                echo json_encode($result);
                exit();
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }


}
    }



public function pblic(){
        $fileName = $_POST['fileName'];
        $this->log("kkkkkk: ".$fileName,"info");
        if(!empty($fileName)) {
            if(file_exists(PARAVIEW_TMP_PATH.$fileName)) {
                $data = array(
                    'html' => file_get_contents(PARAVIEW_TMP_PATH.$fileName),
                    'type' => 'text'
                );
                $jsonDoc = json_encode($data);
                $lines = explode("\n", $data['html']);

foreach($lines as $word) {
//      $this->log("word : ".$word,"info");
if (strpos($word, 'cloudName =') !== FALSE) {
                $cloudName = str_replace("cloudName =","",$word);
        }


if (strpos($word, 'noOfUsersAllowed =') !== FALSE) {
                $noOfUsersAllowed = str_replace("noOfUsersAllowed =","",$word);
        }

if (strpos($word, 'noOfBackupUsersAllowed =') !== FALSE) {
                $noOfBackupUsersAllowed = str_replace("noOfBackupUsersAllowed =","",$word);
        }

if (strpos($word, 'noOfSyncUsersAllowed =') !== FALSE) {
                $noOfSyncUsersAllowed = str_replace("noOfSyncUsersAllowed =","",$word);
        }

if (strpos($word, 'validityPeriod =') !== FALSE) {
                $validityPeriod = str_replace("validityPeriod =","",$word);
        }

if (strpos($word, 'contentSearchEnabled =') !== FALSE) {
                $contentSearchEnabled = str_replace("contentSearchEnabled =","",$word);
        }

if (strpos($word, 'versioningEnabled =') !== FALSE) {
                $versioningEnabled = str_replace("versioningEnabled =","",$word);
        }

if (strpos($word, 'noOfMiniCloudsAllowed =') !== FALSE) {
                $noOfMiniCloudsAllowed = str_replace("noOfMiniCloudsAllowed =","",$word);
        }

if (strpos($word, 'noOfOdbBackupUsersAllowed =') !== FALSE) {
                $noOfOdbBackupUsersAllowed = str_replace("noOfOdbBackupUsersAllowed =","",$word);
        }

if (strpos($word, 'cloudSizeAllowed =') !== FALSE) {
                $cloudSizeAllowed = str_replace("cloudSizeAllowed =","",$word);
        }

if (strpos($word, 'noOfDevicesAllowed =') !== FALSE) {
                $noOfDevicesAllowed = str_replace("noOfDevicesAllowed =","",$word);
        }
        }
$data['cloudName'] = $cloudName;
$data['noOfUsersAllowed'] = $noOfUsersAllowed;
$data['noOfBackupUsersAllowed'] = $noOfBackupUsersAllowed;
$data['noOfSyncUsersAllowed'] = $noOfSyncUsersAllowed;
$validityPeriod = date('d-M-Y H:i:s', (((int)$validityPeriod) / 1000));
$data['validityPeriod'] = $validityPeriod;
$data['contentSearchEnabled'] = $contentSearchEnabled;
$data['versioningEnabled'] = $versioningEnabled;
$data['noOfMiniCloudsAllowed'] = $noOfMiniCloudsAllowed;
$data['noOfOdbBackupUsersAllowed'] = $noOfOdbBackupUsersAllowed;
$data['cloudSizeAllowed'] = $cloudSizeAllowed;
$data['noOfDevicesAllowed'] = $noOfDevicesAllowed;
$jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
        exit;
}

public function cleanUpTempDirectory($fullPath){
        $files = glob($fullPath.DS.'{,.}*', GLOB_BRACE);
        foreach($files as $file){
            if(is_file($file)){
                unlink($file);
            }
        }
    }	

}
