<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><span><?=$data['subTitle']?></span></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <span class="currentPage hide"><?='users'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11" block-ui="myBlockUI">
            <div class="panel">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('list_of_users', 'keywords');?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <a class="btn btn-success btn-small pull-right" href="<?=Url::basePath('user/create')?>">Create User</a>
                            <?php } ?>
                            <a ng-click="exportUsersToExcel()" class="btn btn-small pull-right" style="margin-right: 10px;">Export Users</a>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == true || \Helpers\Auth::checkCloudPermission('sync') == true){ ?>
                                <a class="btn btn-success btn-small pull-right hide"  href="<?=Url::basePath('userGroup')?>">Manage User Group</a>
                            <?php } ?>
                        <?php if(block == false){ ?>
                        <a class="btn btn-danger btn-small pull-right" disabled style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('users/usersBulkBlockDelete')?>"><i class="fa fa-plus"></i> Create / <i class="fa fa-user-times"></i> Block / <i class="fa fa-user-plus"></i> Unblock / <i class="fa fa-trash"></i> Delete Users in bulk</a>
                        <?php } else {?>
                        <a class="btn btn-danger btn-small pull-right" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('users/usersBulkBlockDelete')?>"><i class="fa fa-plus"></i> Create / <i class="fa fa-user-times"></i> Block / <i class="fa fa-user-plus"></i> Unblock / <i class="fa fa-trash"></i> Delete Users in bulk</a>
                        <?php } ?>
                        
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <form ng-submit="searchUser(search.userName)">
                                <input name="searchUsername"
                                       type="text"
                                       class="pull-right form-control"
                                       ng-model="search.userName"
                                       placeholder="Enter a 'UserId' or 'Display Name' or 'Email id' or 'all (for all users)' and hit enter to search"
                                       data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                       data-content="Entered UserId or Display Name or Email Id was not found!!! "
                                />
                            </form>
                        </div>
                    </div>
                    <br/>
                    <div class="table-responsive">
                        <div class="h4 loading text-center">Loading.....</div>
                        <table class="table table-bordered table-striped userListTable" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-left clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left clickAble" ng-click="sortType = 'displayName'; sortReverse = !sortReverse">
                                    <?=Language::show('displayName', 'keywords')?>
                                    <span ng-show="sortType == 'displayName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'displayName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left clickAble" ng-click="sortType = 'emailId'; sortReverse = !sortReverse">
                                    <?=Language::show('email_address', 'keywords')?>
                                    <span ng-show="sortType == 'emailId' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'emailId' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left clickAble" ng-click="sortType = 'time'; sortReverse = !sortReverse">
                                    <?=Language::show('Last Modified Time', 'keywords')?>
                                    <span ng-show="sortType == 'time' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'time' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                                    <th class="text-center"><?=Language::show('groupName', 'keywords')?></th>
                                <?php }?>
                                <th class="text-center"><?=Language::show('status', 'keywords')?></th>
                                <th class="text-left"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in users  | orderBy:sortType:sortReverse track by $index">
                                <td ng-cloak  title="{{value.userName}}">{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}
                                    <span class="label label-info" ng-if="value.isAdmin == true"><?=Language::show('admin', 'keywords')?></span>
                                    <span class="label label-info" ng-if="value.isReadonlyAdmin == true "><?=Language::show('read_only_admin', 'keywords')?></span>
                                </td>
                                <td ng-cloak ng-if="value.displayName"  title="{{value.displayName}}">{{ value.displayName | limitTo:20}}{{value.displayName.length > 20 ? '...' : ''}}</td>
                                <td ng-cloak ng-if="!value.displayName"  title="{{value.displayName}}"> - </td>
                                <td ng-cloak>{{ value.emailId }}</td>
                                <td ng-cloak>{{ value.time | timeAgo:'medium' }}</td>
                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                                    <td ng-cloak>{{ value.userGroup }}</td>
                                <?php }?>
                                <td ng-cloak class="text-center">
                                    <h5><label class="label label-success" ng-show="value.isActive"><?=Language::show('enabled', 'keywords')?></label></h5>
                                    <h5><label class="label label-danger" ng-hide="value.isActive"><?=Language::show('disabled', 'keywords')?></label></h5>
                                </td>
                                <td ng-cloak>
                                    <a class="btn btn-default btn-small" href="<?=Url::basePath('user/settings/{{ value.userName }}')?>"><i class="fa fa-edit"></i> <?=Language::show('edit_profile', 'keywords');?></a>
                                    <a ng-show="value.isActive" class="btn btn-danger btn-small"
                                       ng-bootbox-confirm="<h4><?=Language::show('blockConfirm', 'keywords')?></h4>"
                                       ng-bootbox-confirm-action="blockUserProfile(value.userName, 'true')"
                                       ng-bootbox-confirm-action-cancel=""
                                       href="javascript:;"><i class="fa fa-user-times"></i> <?=Language::show('block', 'keywords');?></a>
                                    <a ng-hide="value.isActive" class="btn btn-success btn-small"
                                       ng-bootbox-confirm="<h4><?=Language::show('unBlockConfirm', 'keywords')?></h4>"
                                       ng-bootbox-confirm-action="unBlockUserProfile(value.userName, 'true')"
                                       ng-bootbox-confirm-action-cancel=""
                                       href="javascript:;"><i class="fa fa-user-plus"></i> <?=Language::show('unblock', 'keywords');?></a>
                                    <a ng-hide="value.isActive" class="btn btn-danger btn-small"
                                       ng-bootbox-confirm="<h4><?=Language::show('deleteConfirm', 'keywords')?></h4>"
                                       ng-bootbox-confirm-action="deleteUserProfile(value.userName, 'true')"
                                       ng-bootbox-confirm-action-cancel="" href="javascript:;"><i class="fa fa-trash"></i> <?=Language::show('delete', 'keywords');?></a>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMoreUsers(skipValue)">Load More ...</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/directives/fileUpload.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $(function() {
    $('.tooltip-wrapper').tooltip({position: "bottom"});
});
</script>
<style>
.tooltip-wrapper.disabled {
  cursor: not-allowed;
}
</style>
