<?php
use \Core\View;
use Helpers\Auth;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <?php if(\Helpers\Auth::checkUserPermission('admin')){ ?>
                    <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                <?php }else{ ?>
                    <li><h3><?=$data['title']?></h3></li>
                <?php } ?>
                <li><a href="<?=Url::basePath('myAccount/'.$data['userDetails']->{'user-name'})?>"><?=Language::show('user_account', 'keywords')?></a></li>
                <li><?=Language::show('edit_profile', 'keywords')?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <?php if($_SESSION['storageResult'] == 'error'){ ?>
        <span class="resultError" style="display: none"><?=$_SESSION['storageMessage']?></span>
    <?php }elseif($_SESSION['storageResult'] == 'success'){ ?>
        <span class="resultSuccess" style="display: none"><?=$_SESSION['storageMessage']?></span>
    <?php } ?>
    <?php $_SESSION['storageResult'] = ''; ?>
    <?php $_SESSION['storageMessage'] = ''; ?>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="row">
                    <span class="solutionType" style="display: none;">
                        <?php
                        if((string)$data['userDetails']->{'is-admin'} == 'true'){
                            echo 'Admin';
                        }elseif((string)$data['userDetails']->{'is-readonly-admin'} == 'true'){
                            echo 'Read Only Admin';
                        }else{
                            echo 'User';
                        }
                        ?>
                    </span>
                <div class="col-lg-3">
                    <div class="sidebar">
                        <div class="side-menu">
                            <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                <div class="<?php if(D_PROFILE_PIC == false){echo 'hide';}?>" align="center">
                                    <br/>
                                    <img class="profileImg drop-box"
                                         ngf-select ngf-drop
                                         ng-model="file"
                                         ngf-drag-over-class="dragover"
                                         ngf-multiple="false"
                                         ngf-allow-dir="true"
                                         ngf-keep="false"
                                         ngf-pattern="'.jpg'"
                                         ngf-src="file"
                                         ngf-default-src="'<?=Url::profilePic($data['userDetails']->{'user-name'})?>'"
                                         accept="image/*" ngf-accept="'image/*'">
                                    <div ngf-no-file-drop><?=Language::show('drag_drop_not_supported', 'keywords');?></div>
                                </div>
                            <?php }else{ ?>
                                <div class="<?php if(D_PROFILE_PIC == false){echo 'hide';}?>" align="center">
                                    <br/>
                                    <img class="profileImg" src="<?=Url::profilePic($data['userDetails']->{'user-name'})?>" />
                                </div>
                            <?php } ?>
                            <br/>
                            <div align="center">
                                <ul class="nav wordwrap">
                                    <li><p><?=Language::show('name', 'keywords');?>: <span class="userName"><?=$data['userDetails']->{'user-name'};?></span></p></li>
                                    <li><p><?=Language::show('email', 'keywords');?>: <?=$data['userDetails']->{'email-id'};?></p></li>
                                    <li>
                                        <p>
                                            <?=Language::show('account_type', 'keywords');?>:
                                            <?php
                                            if((string)$data['userDetails']->{'is-admin'} == 'true'){
                                                echo 'Admin';
                                            }elseif((string)$data['userDetails']->{'is-readonly-admin'} == 'true'){
                                                echo 'Read Only Admin';
                                            }else{
                                                echo 'User';
                                            }
                                            ?>
                                        </p>
                                    </li>
                                    <li><p class="toolTip" data-placement="bottom" data-toggle="tooltip" title="<?php if(!empty(((int)$data['userDetails']->{'last-modified-timestamp'}/1000))){echo date('d-M-Y h:i:s', ((int)$data['userDetails']->{'last-modified-timestamp'}/1000));}else{echo 'NotUpdated';}?>"><?=Language::show('last_modified_time', 'keywords');?>: <?php if(!empty(((int)$data['userDetails']->{'last-modified-timestamp'}/1000))){echo date('d-M-Y', ((int)$data['userDetails']->{'last-modified-timestamp'}/1000));}else{echo 'NotUpdated';}?></p></li>
                                    <?php if($data['lastLoggedInTime']){ ?>
				                    <li><p class="toolTip" data-placement="bottom" data-toggle="tooltip" title="<?php if(!empty(((int)$data['lastLoggedInTime']/1000))){echo date('d-M-y H:i:s', ((int)$data['lastLoggedInTime']/1000));}else{echo '-';}?>"><?=Language::show('last_loggedin_time', 'keywords');?>: <?php if(!empty(((int)$data['lastLoggedInTime']/1000))){echo date('d-M-y H:i:s', ((int)$data['lastLoggedInTime']/1000));}else{echo '-';}?></p></li>
				                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="panel">
                        <div class="panel-heading">
                            <h4><?=Language::show('edit_profile', 'keywords')?></h4>
                        </div>
                        <div class="panel-body">
                            <div class="error col-lg-12" style="display: none; color: #f55753; margin-bottom: 10px;"></div>
                            <?= Form::open(array(
                                'method' => 'post',
                                'ng-submit' => 'saveUserDetails()',
                                'class' => 'userSettingsForm',
                                'csrf' => $data['csrf_token'],
                                'autocomplete' => 'off',
                                'data-parsley-validate' => true
                            )); ?>

<div class="row" style="margin-left:10px;">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Basic Information', 'keywords')?></legend>

                            <div class="form-group col-lg-6 hide">
                                <label for="user_name"><?=Language::show('username', 'keywords');?></label>
                                <input type="text" class="form-control" name="user_name" id="user_name" value="<?=$data['userDetails']->{'user-name'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('username', 'keywords');?>" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 hide">
                                <label for="password_hash"><?=Language::show('password_hash', 'keywords');?></label>
                                <input type="text" class="form-control" name="password_hash" id="password_hash" value="<?=$data['userDetails']->{'password-hash'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password_hash', 'keywords');?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 hide">
                                <label for="is_guest"><?=Language::show('Is Guest', 'keywords');?></label>
                                <input type="text" class="form-control" name="is_guest" id="is_guest" value="<?=$data['userDetails']->{'is-guest'};?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 hide">
                                <label for="local_user"><?=Language::show('local_user', 'keywords');?></label>
                                <input type="text" class="form-control" name="local_user" id="local_user" value="<?=$data['userDetails']->{'localUser'};?>" autocomplete="off">
                            </div>
			                <div class="form-group col-lg-6 hide">
                                <label for="lastLoginTime"><?=Language::show('lastLoginTime', 'keywords');?></label>
                                <input type="text" class="form-control" name="lastLoginTime" id="lastLoginTime" value="<?=$data['lastLoggedInTime'];?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 hide">
                                <label for="userNameLowerCase"><?=Language::show('userNameLowerCase', 'keywords');?></label>
                                <input type="text" class="form-control" name="userNameLowerCase" id="userNameLowerCase" value="<?=$data['userDetails']->{'user-name-lower-case'};?>" autocomplete="off">
                            </div>

                            <div class="form-group col-lg-6 hide">
                                <label for="recovery_key"><?=Language::show('recovery_key', 'keywords');?></label>
                                <input type="text" class="form-control" name="recovery_key" id="recovery_key" value="<?=$data['userDetails']->{'recovery-key'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('recovery_key', 'keywords');?>" required autocomplete="off">
                            </div>
                            <?php if($data['activateEdit'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                <div class="form-group col-lg-6 hide">
                                    <label for="is_first_login"><?=Language::show('is_first_login', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="is_first_login" id="is_first_login" required="">
                                        <option value="true" <?php if($data['userDetails']->{'is-first-login'} == 'true'){ ?>selected<?php } ?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'is-first-login'} == 'false'){ ?>selected<?php } ?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 hide">
                                    <label for="is_first_login"><?=Language::show('is_first_login', 'keywords');?></label>
                                    <input type="text" class="form-control" name="is_first_login" id="is_first_login" value="<?php if($data['userDetails']->{'is-first-login'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('is_first_login', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            <?php //if($data['activateEdit'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                <!--<div class="form-group col-lg-6">
                                    <label for="account_status"><?=Language::show('account_status', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="account_status" id="account_status" required="" disabled>
                                        <option value="true" <?php if($data['userDetails']->{'is-active'} == 'true'){ ?>selected<?php } ?>><?=Language::show('activate', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'is-active'} == 'false'){ ?>selected<?php } ?>><?=Language::show('de_activate', 'keywords')?></option>
                                    </select>
                                </div>-->
                            <?php // }else{ ?>
                                <div class="form-group col-lg-6">
                                    <label for="account_status"><?=Language::show('account_status', 'keywords');?></label>
                                    <input type="text" class="form-control" name="account_status" id="account_status" value="<?php if($data['userDetails']->{'is-active'} == 'true'){ echo Language::show('activate', 'keywords'); }else{ echo Language::show('de_activate', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('account_status', 'keywords');?>" required autocomplete="off" readonly>
                                </div>

			                <div class="form-group col-lg-6">
                                <label for="displayName"><?=Language::show('displayName', 'keywords');?></label>
                                <input type="text" class="form-control" name="displayName" id="displayName" value="<?=$data['userDetails']->{'display-name'};?>" autocomplete="off" minlength="3" maxlength="104" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @ and. Any other special characters are not allowed.">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="location"><?=Language::show('location', 'keywords');?></label>
                                <input type="text" class="form-control" name="location" id="location" value="<?=$data['userDetails']->{'location'};?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="department"><?=Language::show('department', 'keywords');?></label>
                                <input type="text" class="form-control" name="department" id="department" value="<?=$data['userDetails']->{'department'};?>" autocomplete="off">
                            </div>
                            <?php // } ?>
                            <?php if($data['activateEdit'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                <div class="form-group col-lg-6 account_type <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'hide';}?>">
                                    <label for="account_type" style="margin-bottom:0px;"><?=Language::show('account_type', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="account_type" id="account_type" required="">
                                        <option value="admin" <?php if($data['userDetails']->{'is-admin'} == 'true'){ echo 'selected';}?>><?=Language::show('admin', 'keywords')?></option>
                                        <option value="read_only_admin" <?php if($data['userDetails']->{'is-readonly-admin'} == 'true'){ echo 'selected';}?>><?=Language::show('read_only_admin', 'keywords')?></option>
                                        <option value="user" <?php if($data['userDetails']->{'is-admin'} != 'true' && $data['userDetails']->{'is-readonly-admin'} != 'true'){ echo 'selected';}?>><?=Language::show('user', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 account_type <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'hide';}?>">
                                    <label for="account_type" style="margin-bottom:0px;"><?=Language::show('account_type', 'keywords');?></label>
                                    <input type="text" class="form-control" name="account_type" id="account_type" value="<?php if($data['userDetails']->{'is-admin'} == 'true'){ echo 'Admin';}elseif($data['userDetails']->{'is-readonly-admin'} == 'true'){ echo Language::show('read_only_admin','keywords');}elseif($data['userDetails']->{'is-guest'} == 'true'){ echo Language::show('Guest','keywords');}else{ echo Language::show('user','keywords');}?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('account_type', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>

                            <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 hide share_enabled <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'hide';}?>">
                                    <label for="share_enabled"><?=Language::show('share_enabled', 'keywords')?></label>
                                    <select class="form-control" name="share_enabled" id="share_enabled" required="">
                                        <option value="true" <?php if($data['userDetails']->{'share-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'share-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 hide share_enabled <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'hide';}?>">
                                    <label for="share_enabled"><?=Language::show('share_enabled', 'keywords')?></label>
                                    <input type="text" class="form-control" name="share_enabled" id="share_enabled" value="<?php if($data['userDetails']->{'share-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            <div class="form-group col-lg-6">
                                <label for="email_address"><?=Language::show('email_address', 'keywords');?></label>
                                <input type="email" class="form-control" name="email_address" id="email_address" value="<?=$data['userDetails']->{'email-id'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('email_address', 'keywords');?>" required autocomplete="off" <?php if($data['activateEdit'] == false){ echo 'readonly';}?>>
                            </div>
                            <?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                <div class="form-group col-lg-6">
                                    <label for="odb_login_Id"><?=Language::show('Onedrive for Business Login Id', 'keywords');?></label>
                                    <input type="email" class="form-control" name="odb_login_Id" id="odb_login_Id" value="<?=$data['userDetails']->{'odb-loginId'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('Onedrive for Business Login Id', 'keywords');?>" autocomplete="off">
                                </div>
                            <?php } ?>

</div>

<div class="row <?php if(DISABLE_BLUVAULT == true || Auth::checkCloudPermission('backup') == false) { echo 'hide'; } ?>" style="margin-left:10px;">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Backup Information', 'keywords')?></legend>
<?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 backup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('backup') == false){echo 'hide';}?> <?php if(DISABLE_BLUVAULT == true) { echo 'hide'; } ?>" >
                                    <label for="backup" style="margin-bottom:0px;"><?=Language::show('backup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="backup" id="backup" <?php if(Auth::checkCloudPermission('backup') == true) { echo 'required';} ?>>
                                        <option value="true" <?php if($data['userDetails']->{'backup-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'backup-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 backup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('backup') == false){echo 'hide';}?> <?php if(DISABLE_BLUVAULT == true) { echo 'hide'; } ?>">
                                    <label for="backup"><?=Language::show('backup', 'keywords');?></label>
                                    <input type="text" class="form-control" name="backup" id="backup" value="<?php if($data['userDetails']->{'backup-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('backup', 'keywords');?>" <?php if(Auth::checkCloudPermission('backup') == true) { echo 'required';} ?> autocomplete="off" readonly>
                                </div>
                            <?php } ?>
<?php if(Auth::checkCloudPermission('backup') == true) { ?>
                            <?php if($data['activateEdit'] == true){ ?>
                            <div class="form-group col-lg-6 backup backupPolicyName <?php if(Auth::checkCloudPermission('backup') == false || DISABLE_BLUVAULT == true) { echo 'hide'; } ?>">
                                    <label for="policyName"><?=Language::show('backupPolicyName', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="policyName" id="policyName" <?php if(Auth::checkCloudPermission('backup') == true) { echo 'required';} ?>>
                                        <?php if(!empty($data['backupPolicies1'])){ ?>
                                            <?php foreach($data['backupPolicies1'] as $key => $value){ 
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value?>" <?php if($data['userDetails']->{'policy-name'} == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            <?php } else { ?>
                            <div class="form-group col-lg-6 hide">
                                <label for="policy_name"><?=Language::show('policy_name', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policy_name" value="<?=$data['userDetails']->{'policy-name'};?>" autocomplete="off">
                            </div>
                            <?php } ?>
<?php } ?>
<div class="row">
    <div class="col-lg-6" style="margin-left: 16px;">
<?php
            $backupPoliciesAdmin = [];
            if(!empty((array)$data['userDetails']->{'backupPoliciesAdmin'}->{'backupPolicyAdmin'})){
               foreach($data['userDetails']->{'backupPoliciesAdmin'}->{'backupPolicyAdmin'} as $key => $value){
                    //$policy = array('name' => (string)$value);
                    //$backupPoliciesAdmin = array_merge(array($policy),$backupPoliciesAdmin);
                    $backupPoliciesAdmin = array_merge($backupPoliciesAdmin, array((string)$value));
               }
            }
        ?>
        <div class="form-group backupPoliciesAdmin <?php if($data['userDetails']->{'is-readonly-admin'} != 'true'){ echo 'hide';}?>">
            <label for="backupPoliciesAdmin">Manage Backup Policies</label>
                <select name="backupPoliciesAdmin[]" id="backupPoliciesAdmin" class="form-control selectPicker" title="Select Backup Policies Name" multiple <?php if(Auth::checkCloudPermission('backup') == true && $data['userDetails']->{'is-readonly-admin'} == 'true') { echo 'required';} ?>>
                            <?php if(!empty($data['backupPolicies1'])){ ?> 
                                <?php foreach($data['backupPolicies1'] as $key => $value){ 
                                $label = $value;
                                if( strlen( $label ) > 25 ) {
                                   $label = substr( $label, 0, 25 ) . '...';
                                }
                                ?>
                                    <option value="<?=$value?>"<?php if(in_array($value,$backupPoliciesAdmin)){ echo 'selected';}?>><?=$label?></option>
                                <?php } ?>
                            <?php } ?>
                </select>
        </div>
	</div>
    </div>
</div>
<div class="row <?php if(DISABLE_BLUSYNC == true || Auth::checkCloudPermission('sync') == false) { echo 'hide'; } ?> " style="margin-left:10px;">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Sync Information', 'keywords')?></legend>

<?php
                            $miniClouds = [];
                            if(!empty((array)$data['userDetails']->{'mini-clouds'}->{'mini-cloud'})){
                                foreach($data['userDetails']->{'mini-clouds'}->{'mini-cloud'} as $key => $value){
                                    $miniClouds = array_merge($miniClouds, array((string)$value->{'mini-cloud-name'}));
                                }
                            }
                            ?>
                            <?php if($data['activateEdit'] == true){ ?>
                                <?php if(!empty($data['miniClouds']->{'mini-cloud'})){ ?>
                                    <div class="form-group col-lg-6 miniCloudName <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'hide';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'hide'; } ?>">
                                        <label for="miniCloudName"><?=Language::show('miniCloudName', 'keywords')?></label>
                                        <select class="form-control selectPicker" name="miniCloudName[]" id="miniCloudName" multiple title='Select Mini Clouds'>
                                            <?php foreach($data['miniClouds']->{'mini-cloud'} as $key => $value){ ?>
                                                <option value="<?=$value->{'mini-cloud-name'}?>" <?php if(in_array($value->{'mini-cloud-name'}, $miniClouds)){ echo 'selected';}?>><?=$value->{'mini-cloud-name'}?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                <?php } ?>
                            <?php }else{ ?>
                                <?php if(!empty($miniClouds)){ ?>
                                    <div class="form-group col-lg-6 miniCloudName <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'hide';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'hide'; } ?>">
                                        <label for="miniCloudName"><?=Language::show('miniCloudName', 'keywords');?></label>
                                        <input type="text" class="form-control" name="miniCloudName" id="miniCloudName" value="<?=implode(',', $miniClouds);?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('miniCloud', 'keywords');?>" autocomplete="off" readonly>
                                    </div>
                                <?php } ?>
                            <?php } ?>

                            <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 sync_access <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'hide';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'hide'; } ?>">
                                    <label for="sync_access"><?=Language::show('sync_access', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="sync_access" id="sync_access" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?>>
                                        <option value="false" <?php if($data['userDetails']->{'sync-enabled'} =='false'){echo 'selected';}?>><?=Language::show('web_access', 'keywords')?></option>
                                        <?php if(BLUDRIVE_MODE == false) {?> <option value="true" <?php if($data['userDetails']->{'sync-enabled'} =='true'){echo 'selected';}?>><?=Language::show('epa_web_access', 'keywords')?></option> <?php } ?>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 sync_access <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'hide';}?> <?php if(DISABLE_BLUSYNC == true) { echo 'hide'; } ?>">
                                    <label for="sync_access"><?=Language::show('sync_access', 'keywords');?></label>
                                    <input type="text" class="form-control" name="sync_access" id="sync_access" value="<?php if($data['userDetails']->{'sync-enabled'} == 'true'){ echo Language::show('epa_web_access', 'keywords'); }else{ echo Language::show('web_access', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('sync_access', 'keywords');?>" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?> autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            
<?php if(Auth::checkCloudPermission('sync') == true) { ?>
                            <?php if($data['activateEdit'] == true){ ?>
                            <div class="form-group col-lg-6 sync <?php if(Auth::checkCloudPermission('sync') == false || DISABLE_BLUSYNC == true) { echo 'hide'; } ?>">
                                    <label for="syncPolicyName"><?=Language::show('syncPolicyName', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="syncPolicyName" id="syncPolicyName" <?php if(Auth::checkCloudPermission('sync') == true) { echo 'required';} ?>>
                                        <?php if(!empty($data['syncPolicies1'])){ ?>
                                            <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value?>" <?php if($data['userDetails']->{'sync-policy-name'} == $value){echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            <?php } else { ?>
                            <div class="form-group col-lg-6 hide">
                                <label for="sync_policy_name"><?=Language::show('sync_policy_name', 'keywords');?></label>
                                <input type="text" class="form-control" name="syncPolicyName" id="sync_policy_name" value="<?=$data['userDetails']->{'sync-policy-name'};?>" autocomplete="off">
                            </div>
                            <?php } ?>
<?php } ?>
                            <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 serverBackup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('serverBackup') == false){echo 'hide';}?>">
                                    <label for="serverBackup"><?=Language::show('serverBackup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="serverBackup" id="serverBackup" required="">
                                        <option value="true" <?php if($data['userDetails']->{'server-backup-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'server-backup-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 serverBackup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('serverBackup') == false){echo 'hide';}?>">
                                    <label for="serverBackup"><?=Language::show('serverBackup', 'keywords');?></label>
                                    <input type="text" class="form-control" name="serverBackup" id="serverBackup" value="<?php if($data['userDetails']->{'server-backup-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('serverBackup', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
			   <?php
                                $syncPoliciesAdmin = [];
                                if(!empty((array)$data['userDetails']->{'syncPoliciesAdmin'}->{'syncPolicyAdmin'})){
                                   foreach($data['userDetails']->{'syncPoliciesAdmin'}->{'syncPolicyAdmin'} as $key => $value){
                                        //$policy = array('name' => (string)$value);
                                        //$backupPoliciesAdmin = array_merge(array($policy),$backupPoliciesAdmin);
                                        $syncPoliciesAdmin = array_merge($syncPoliciesAdmin, array((string)$value));
                                   }
                                }
                            ?>
                            <div class="form-group col-lg-6 syncPoliciesAdmin <?php if($data['userDetails']->{'is-readonly-admin'} != 'true'){ echo 'hide'; } ?>">
                                    <label for="syncPoliciesAdmin">Manage Sync Policies</label> 
                                    <select name="syncPoliciesAdmin[]" id="syncPoliciesAdmin" class="form-control selectPicker" title="Select Sync Policies Name" multiple <?php if(Auth::checkCloudPermission('sync') == true && $data['userDetails']->{'is-readonly-admin'} == 'true') { echo 'required';} ?>>
                                        <?php if(!empty($data['syncPolicies1'])){ ?> 
                                             <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                             $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                             ?>
                                                <option value="<?=$value?>"<?php if(in_array($value,$syncPoliciesAdmin)){ echo 'selected';}?>><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                            </div> 
                     </div>       
                            <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                <?php if($data['userDetails']->{'backup-enabled'} == "true" || $data['userDetails']->{'sync-enabled'} == "true"){?>
                                    <?php if($data['userDetails']->{'externalstorage-authorized'}=="true") { ?>
                                        <div class="form-group col-lg-12 hide">
                                            <div class="well well-lg">
                                                <h4 style="margin-top: -5px;">Select Storage Space</h4>
                                                <hr/>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default"><i class="fa fa-database"></i> Local Storage</a>
                                                    - Your cloud does not support this feature
                                                </p>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default"><i class="fa fa-cloud"></i> Parablu Hosted Storage</a>
                                                    - Parablu Cloud Storage is your default selected storage space. Please select other storage space.
                                                </p>
                                                <?php
                                                $GDUrl = GOOGLE_REDIRECT_URI."?scope=".GOOGLE_SCOPE."&state=".$data['loggedInUser']['userName']."&redirect_uri=".\Helpers\Url::basePath(GOOGLE_RESOURCE_URI.'/')."&response_type=code&client_id=".GOOGLE_CLIENT_ID."&approval_prompt=force&access_type=offline";
                                                ?>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$GDUrl;?>')"><i class="fa fa-google"></i> Google Drive</a>
                                                    - Google Drive Storage space
                                                </p>
                                                <?php
                                                $MODCUrl = ODFC_REDIRECT_URI."?client_id=".ODFC_CLIENT_ID."&response_type=code&redirect_uri=".\Helpers\Url::basePath(ODFC_RESOURCE_URI.'/')."&state=".$data['loggedInUser']['userName'];
                                                ?>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODCUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive</a>
                                                    - Microsoft OneDrive Consumer Storage Space
                                                </p>
                                                <?php
                                                $params = "?resource=".ODFB_RESOURCE_URI."&client_id=".ODFB_CLIENT_ID."&response_type=code&redirect_uri=".ODFB_REDIRECT_URI."&state=".$data['loggedInUser']['userName'];
                                                $MODBUrl = API_APP_URL.$params."&user=".$data['loggedInUser']['userName']."&sourceURI=".\Helpers\Url::basePath();
                                                ?>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODBUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive for Business</a>
                                                    - Microsoft OneDrive for business Storage Space
                                                </p>
                                            </div>
                                        </div>
                                    <?php } ?>
                                <?php } ?>
                            <?php } ?>

                                <?php if($data['activateEdit'] == true && STORAGE_TYPE == "ONE_DRIVE"){ ?>
<div class="col-lg-12">
                                   <button type="submit" class="UserSave btn btn-primary pull-right"><?=Language::show('save', 'keywords')?></button>
                               </div>
<?php }?>
<?php  if($data['activateEdit'] == true && STORAGE_TYPE !== "ONE_DRIVE"){ ?>
<div class="col-lg-12">
                                   <button type="submit" class="UserSave btn btn-primary pull-right"><?=Language::show('save', 'keywords')?></button>
                               </div>
<?php }?>
<?php  if($data['activateEdit'] == false && STORAGE_TYPE == "ONE_DRIVE"){ ?>
<div class="col-lg-12">
                                   <button type="submit" class="UserSave btn btn-primary pull-right"><?=Language::show('save', 'keywords')?></button>
                               </div>
<?php }?>
<?php  if($data['activateEdit'] == false && STORAGE_TYPE != "ONE_DRIVE"){ ?>
<div class="col-lg-12 hide">
                                   <button type="submit" class="UserSave btn btn-primary pull-right"><?=Language::show('save', 'keywords')?></button>
                               </div>
<?php }?>

                            <?= Form::close(); ?>
                        </div>
                    </div>
                </div>
<?php if(STORAGE_TYPE == "GOOGLE_DRIVE"){ ?>
                 <div class="col-lg-9 <?php if($data['userDetails']->{'externalstorage-authorized'}=='false') { echo 'hide';}?>">
                        <div class="panel">
                                <div class="panel-heading">
                                        <h4 style="margin-top: -5px;">Configure Google Drive</h4>
                                </div>
                                <div class="panel-body">
                                        <?php
$GDUrl = GOOGLE_REDIRECT_URI."?scope=".GOOGLE_SCOPE."&state=".$data['loggedInUser']['userName']."&redirect_uri=".\Helpers\Url::basePath(GOOGLE_RESOURCE_URI.'/')."&response_type=code&client_id=".GOOGLE_CLIENT_ID."&approval_prompt=force&access_type=offline";
 ?>
                                        <p>

<a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$GDUrl;?>')"><i class="fa fa-google"></i> Google Drive</a>
                                        </p>
                                </div>
                        </div>
                </div>
                <?php } ?>

<?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                 <div class="col-lg-9 <?php if($data['userDetails']->{'externalstorage-authorized'}=='false') { echo 'hide';}?>">
                        <div class="panel">
                                <div class="panel-heading">
                                        <h4 style="margin-top: -5px;">Configure OneDrive</h4>
                                </div>
                                <div class="panel-body">
                                        <?php
$serviceAccount = "true";
$params = "?resource=".$data["clientResourceURL"]."&client_id=".$data["clientID"]."&response_type=code&redirect_uri=".$data["clientRedirectURI"]."&state=".$data['loggedInUser']['userName'];
                                                $MODBUrl = API_APP_URL.$params."&user=".$data['loggedInUser']['userName']."&sourceURI=".\Helpers\Url::basePath();
                                                ?>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODBUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive for Business</a>
                                                    - Microsoft OneDrive for business Storage Space
                                                </p>
</div>
                        </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/directives/fileUpload.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $("#account_type").on('change',function(){
        if($("#account_type").val() == 'read_only_admin'){
            if($(".backupPoliciesAdmin").hasClass('hide')){
                $(".backupPoliciesAdmin").removeClass('hide');
                $(".syncPoliciesAdmin").removeClass('hide');
            }
	     <?php if(Auth::checkCloudPermission('backup') == true) {?>
		    if(!$("#backupPoliciesAdmin").prop('required')){
			console.log("backup policy");
			$("#backupPoliciesAdmin").attr('required','required');
		    }
	    <?php } ?>
            <?php if(Auth::checkCloudPermission('sync') == true) {?>
		    if(!$("#syncPoliciesAdmin").prop('required')){
		        console.log("sync policy");
		        $("#syncPoliciesAdmin").attr('required','required');
		    }
	    <?php } ?>

            $("#backupPoliciesAdmin").selectpicker('refresh');
            $("#syncPoliciesAdmin").selectpicker('refresh');
        }
        else{
            $(".backupPoliciesAdmin").addClass('hide');
            $(".syncPoliciesAdmin").addClass('hide');
            if($("#backupPoliciesAdmin").prop('required')){
                $("#backupPoliciesAdmin").removeAttr('required');
            }
	    if($("#syncPoliciesAdmin").prop('required')){
                $("#syncPoliciesAdmin").removeAttr('required');
            }
            $("#backupPoliciesAdmin").selectpicker('refresh');
            $("#syncPoliciesAdmin").selectpicker('refresh');
        }
    });
</script>
