<?php use \Core\View;
use Helpers\Form;
use Helpers\Auth;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['subTitle']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="row">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4>
                            <?=Language::show('createUser', 'keywords');?>
                        </h4>
                    </div>
                    <div class="panel-body">
                        <?=
                        Form::open(array(
                            'ng-submit' => 'saveNewUserDetails()',
                            'method' => 'post',
                            'class' => 'userCreationFrom',
                            'csrf' => $data['csrf_token'],
                            'autocomplete' => 'off',
                            'data-parsley-validate' => true
                        ));
                        ?>
                        <div class="row" style="margin-left:10px;">
                            <legend class="h4" style="color: #585f69;"><?=Language::show('Basic Information', 'keywords')?></legend>
                            <div class="form-group col-lg-6">
                                <label for="username"><?=Language::show('username', 'keywords');?></label>
                                <input type="text" class="form-control" name="username" id="username" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('username', 'keywords');?>" required autocomplete="off" minlength="3" maxlength="104" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @ and. Any other special characters are not allowed.">
                            </div>
			    <div class="form-group col-lg-6">
                                <label for="email"><?=Language::show('email', 'keywords');?></label>
                                <input type="text" class="form-control" name="email" id="email" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('email', 'keywords');?>" required autocomplete="off" data-parsley-type="email">
                            </div>
			    <div class="form-group col-lg-6">
                                <label for="password"><?=Language::show('password', 'keywords');?></label>
				                <?php if(COMPLEX_PASSWORD == true) { ?>
                                <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
				                <?php } else { ?>
                                <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-required data-parsley-minlength="6">
                                <?php } ?>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="rePassword"><?=Language::show('rePassword', 'keywords');?></label>
                                <input type="password" class="form-control" name="rePassword" id="rePassword" placeholder="<?=Language::show('rePassword', 'keywords');?>" required autocomplete="off" data-parsley-required data-parsley-equalto="#password" data-parsley-trigger="change">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="displayName"><?=Language::show('displayName', 'keywords');?></label>
                                <input type="text" class="form-control" name="displayName" id="displayName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('displayName', 'keywords');?>" autocomplete="off" minlength="3" maxlength="104" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @ and. Any other special characters are not allowed.">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="location"><?=Language::show('location', 'keywords');?></label>
                                <input type="text" class="form-control" name="location" id="location" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('location', 'keywords');?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="department"><?=Language::show('department', 'keywords');?></label>
                                <input type="text" class="form-control" name="department" id="department" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('department', 'keywords');?>" autocomplete="off">
                            </div>
                            
                            <div class="form-group col-lg-6 account_type" style="margin-bottom:20px;">
                                <label for="account_type"><?=Language::show('account_type', 'keywords')?></label>
                                <select class="form-control selectPicker" name="account_type" id="account_type" required="">
                                    <option value="user"><?=Language::show('user', 'keywords')?></option>
                                    <option value="admin"><?=Language::show('admin', 'keywords')?></option>
                                    <option value="read_only_admin"><?=Language::show('read_only_admin', 'keywords')?></option>
                                </select>
                            </div>
			    <?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                <div class="form-group col-lg-6">
                                    <label for="odb_login_Id"><?=Language::show('One drive for Business Login Id', 'keywords');?></label>
                                    <input type="email" class="form-control" name="odb_login_Id" id="odb_login_Id" value="<?=$data['userDetails']->{'odb-loginId'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('One drive for Business Login Id', 'keywords');?>" autocomplete="off">
                                </div>
                            <?php } ?>
</div>

<div class="row <?php if(DISABLE_BLUVAULT == true || Auth::checkCloudPermission('backup') == false) { echo 'hide'; } ?>" style="margin-left:10px;">
                            <legend class="h4" style="color: #585f69;"><?=Language::show('Backup Information', 'keywords')?></legend>
<?php if($data['loggedInUser']['backupEnabled'] == true){ ?>
                                <div class="form-group col-lg-6 backup <?php if(DISABLE_BLUVAULT == true) { echo 'hide'; } ?>">
                                    <label for="backup"><?=Language::show('backup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="backup" id="backup" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6 backup backupPolicyName <?php if(DISABLE_BLUVAULT == true) { echo 'hide'; } ?>">
                                    <label for="policyName"><?=Language::show('backupPolicyName', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="policyName" id="policyName" required="">
                                        <?php if(!empty($data['backupPolicies1'])){ ?>
                                            <?php foreach($data['backupPolicies1'] as $key => $value){ 
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value?>"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            <?php } ?>
                            <?php if($data['loggedInUser']['serverBackupEnabled'] == true){ ?>
                                <div class="form-group col-lg-6 serverBackup">
                                    <label for="serverBackup"><?=Language::show('serverBackup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="serverBackup" id="serverBackup" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php } ?>
			    <div class="form-group col-lg-6 backupPoliciesAdmin">
                                <label for="backupPoliciesAdmin">Manage Backup Policies</label>
                                    <select name="backupPoliciesAdmin[]" id="backupPoliciesAdmin" class="form-control selectPicker" title="Select Backup Policies Name" multiple <?php if(Auth::checkCloudPermission('backup') == true && $data['userDetails']->{'is-readonly-admin'} == 'true' ) { echo "required";} ?>>
                                                <?php if(!empty($data['backupPolicies1'])){ ?>
                                                    <?php foreach($data['backupPolicies1'] as $key => $value){ 
                                                    $label = $value;
                                                    if( strlen( $label ) > 25 ) {
                                                       $label = substr( $label, 0, 25 ) . '...';
                                                    }
                                                    ?>
                                                        <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                    </select>
                            </div>
</div>

<div class="row <?php if(DISABLE_BLUSYNC == true || Auth::checkCloudPermission('sync') == false) { echo 'hide'; } ?> " style="margin-left:10px;">
                            <legend class="h4" style="color: #585f69;"><?=Language::show('Sync Information', 'keywords')?></legend>


                            <?php if($data['loggedInUser']['syncWebAccessEnabled'] == true || $data['loggedInUser']['syncEnabled'] == true){ ?>
                                <?php if(!empty($data['miniClouds']->{'mini-cloud'})){ ?>
                                    <div class="form-group col-lg-6 miniCloudName <?php if(DISABLE_BLUSYNC == true) { echo 'hide'; } ?>">
                                        <label for="miniCloudName"><?=Language::show('miniCloudName', 'keywords')?></label>
                                        <select class="form-control selectPicker" name="miniCloudName[]" id="miniCloudName" multiple title='Select Mini Clouds'>
                                            <?php foreach($data['miniClouds']->{'mini-cloud'} as $key => $value){ ?>
                                                <option><?=$value->{'mini-cloud-name'}?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                <?php } ?>
                            <?php } ?>
                        <?php if($data['loggedInUser']['syncWebAccessEnabled'] == true || $data['loggedInUser']['syncEnabled'] == true){ ?>
                                <div class="form-group col-lg-6 sync_access <?php if(DISABLE_BLUSYNC == true) { echo 'hide'; } ?>">
                                    <label for="sync_access"><?=Language::show('sync_access', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="sync_access" id="sync_access" required="">
                                        <option value="false"><?=Language::show('web_access', 'keywords')?></option>
                                        <?php if(BLUDRIVE_MODE == false) {?> <option value="true"><?=Language::show('epa_web_access', 'keywords')?></option> <?php } ?>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6 sync <?php if(DISABLE_BLUSYNC == true) { echo 'hide'; } ?>">
                                    <label for="syncPolicyName"><?=Language::show('syncPolicyName', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="syncPolicyName" id="syncPolicyName" required="">
                                        <?php if(!empty($data['syncPolicies1'])){ ?>
                                            <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value?>"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>

                                <div class="form-group col-lg-6 share_enabled hide">
                                    <label for="share_enabled"><?=Language::show('share_enabled', 'keywords')?></label>
                                    <select class="form-control" name="share_enabled" id="share_enabled" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
				<div class="form-group col-lg-6 syncPoliciesAdmin">
                                    <label for="syncPoliciesAdmin">Manage Sync Policies</label>
                                    <select name="syncPoliciesAdmin[]" id="syncPoliciesAdmin" class="form-control selectPicker" title="Select Sync Policies Name" multiple  <?php if(Auth::checkCloudPermission('sync') == true && $data['userDetails']->{'is-readonly-admin'} == 'true') { echo 'required';} ?>>
                                        <?php if(!empty($data['syncPolicies1'])){ ?>
                                             <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                             $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                             ?>
                                                <option value="<?=$value?>"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                        <?php } ?>
                            </div>
                            
                        
                        <div class="form-group col-lg-12">
                            <button type="submit" class="userSave btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        </div>
                        <?=
                        Form::close();
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.selectPolicyPicker').selectpicker('render');
    $('#backup').on('change', function(){
        if($('#backup').val() == 'true'){
            $('.backupPolicyName').show()
            $('#policyName').attr('required', 'required');
            $('#policyName').selectpicker('refresh');
        }else{
            $('.backupPolicyName').hide()
            $('#policyName').removeAttr('required', 'required');
            $('#policyName').selectpicker('refresh');
        }
    });
    $(".backupPoliciesAdmin").hide();
    $(".syncPoliciesAdmin").hide();
    $("#backupPoliciesAdmin").removeAttr('required');
    $("#syncPoliciesAdmin").removeAttr('required');
    $("#account_type").on('change',function(){
        if($("#account_type").val() == 'read_only_admin'){
            $(".backupPoliciesAdmin").show();
            $(".syncPoliciesAdmin").show();
            $("#backupPoliciesAdmin").attr("required", "true");
            $("#syncPoliciesAdmin").attr("required", "true");
            $("#backupPoliciesAdmin").selectpicker('refresh');
            $("#syncPoliciesAdmin").selectpicker('refresh');
        }
        else{
            $(".backupPoliciesAdmin").hide();
            $(".syncPoliciesAdmin").hide();
            $("#backupPoliciesAdmin").removeAttr('required');
            $("#syncPoliciesAdmin").removeAttr('required');
            $("#backupPoliciesAdmin").selectpicker('refresh');
            $("#syncPoliciesAdmin").selectpicker('refresh');
        }
    });
    /*
$(document).ready(function (){
	$('#username').on('click', function (e) {
            $('[name="username"]').popover('hide');
            $('[name="username"]').popover('destroy');
    });
});*/
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
