<?php

use \Core\View;
use \Helpers\Url;
use Core\Language;
use Helpers\Form;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;"><?=$data['crumb1']?></h4>
                    </div>

                    <div class="panel-body">
                        <form class="cloudConfiguration" ng-submit="saveCloudConfiguration()" data-parsley-validate>
                            <!-- Nav tabs -->
                            <ul class="nav nav-tabs" role="tablist">
                                <li role="presentation" class="active"><a href="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                                <li role="presentation"><a href="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                            </ul>

                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div role="tabpanel" class="tab-pane active" id="general">
                                    </br>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="blusyncDownloadPath">BluSync Download Path</label>
                                        <input type="text" class="form-control" name="blusyncDownloadPath" id="blusyncDownloadPath" value="<?=$data['blusyncDownloadPath']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="mntParacloudPath">Mnt Paracloud Path</label>
                                        <input type="text" class="form-control" name="mntParacloudPath" id="mntParacloudPath" value="<?=$data['mntParacloudPath']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="cloudScriptsFolder">Parablu Installation Script Folder</label>
                                        <input type="text" class="form-control" name="cloudScriptsFolder" id="cloudScriptsFolder" value="<?=$data['cloudScriptsFolder']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="scriptsBinDir">Scripts Bin Directory</label>
                                        <input type="text" class="form-control" name="scriptsBinDir" id="scriptsBinDir" value="<?=$data['scriptsBinDir']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="scriptsVideoThumbnail">Scripts Video Thumbnail</label>
                                        <input type="text" class="form-control" name="scriptsVideoThumbnail" id="scriptsVideoThumbnail" value="<?=$data['scriptsVideoThumbnail']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="scriptsGeneralThumbnail">Scripts General Thumbnail</label>
                                        <input type="text" class="form-control" name="scriptsGeneralThumbnail" id="scriptsGeneralThumbnail" value="<?=$data['scriptsGeneralThumbnail']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="cloudFileName">Parablu Installation File Name</label>
                                        <input type="text" class="form-control" name="cloudFileName" id="cloudFileName" value="<?=$data['cloudFileName']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="cloudType">Parablu Installation Type</label>
                                        <input type="text" class="form-control" name="cloudType" id="cloudType" value="<?=$data['cloudType']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="solrUrl">Solr URL</label>
                                        <input type="text" class="form-control" name="solrUrl" id="solrUrl" value="<?=$data['solrUrl']?>" placeholder="Enter Solr URL" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="supportMail">Support Mail</label>
                                        <input type="email" class="form-control" name="supportMail" id="supportMail" value="<?=$data['supportMail']?>" placeholder="Enter Email ID" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="emailToAdminOnly">Emails To Admin Only</label>
                                        <select class="form-control emailToAdminOnly selectpicker" name="emailToAdminOnly" id="emailToAdminOnly" >
                                            <option value="true" <?php if($data["emailToAdminOnly"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["emailToAdminOnly"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="canAdminRestoreAll">Can Admin Restore Other Users' Data</label>
                                        <select class="form-control canAdminRestoreAll selectpicker" name="canAdminRestoreAll" id="canAdminRestoreAll" >
                                             <option value="true" <?php if($data["canAdminRestoreAll"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                             <option value="false" <?php if($data["canAdminRestoreAll"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <div class="form-group col-lg-6">
                                            <label for="defaultBkpPolicyName">Default Backup Policy Name</label>
                                            <select class="form-control selectPolicyPicker" name="defaultBkpPolicyName" id="defaultBkpPolicyName" placeholder="" required >
                                                 <?php if(!empty($data['backupPolicies'])){ ?>
                                                    <?php foreach($data['backupPolicies'] as $key => $value){ 
                                                    $label = $value['name'];
                                                    if( strlen( $label ) > 25 ) {
                                                       $label = substr( $label, 0, 25 ) . '...';
                                                    }?>
                                                         <option value="<?=$value['name']?>" <?php if($data['defaultBkpPolicyName'] == $value['name']){echo 'selected';}?>><?=$label?></option>
                                                         </option>
                                                     <?php } ?>
                                                 <?php } ?>
                                             </select>
                                        </div>
                                    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                        <div class="form-group col-lg-6">
                                            <label for="defaultSyncPolicyName">Default Sync Policy Name</label>
                                            <select class="form-control selectPolicyPicker" name="defaultSyncPolicyName" id="defaultSyncPolicyName" placeholder="" required >
                                                 <?php if(!empty($data['syncPolicies'])){ ?>
                                                    <?php foreach($data['syncPolicies'] as $key => $value){
                                                        $label = $value['name'];
                                                        if( strlen( $label ) > 25 ) {
                                                           $label = substr( $label, 0, 25 ) . '...';
                                                        }?>
                                                         <option value="<?=$value['name']?>" <?php if($data['defaultSyncPolicyName'] == $value['name']){echo 'selected';}?>><?=$label?></option>
                                                         </option>
                                                     <?php } ?>
                                                 <?php } ?>
                                             </select>
                                        </div>
                                    
                                    <div class="form-group col-lg-6">
                                            <label for="defaultGuestSyncPolicyName">Default Guest Sync Policy Name</label>
                                            <select class="form-control selectPolicyPicker" name="defaultGuestSyncPolicyName" id="defaultGuestSyncPolicyName" placeholder="" required >
                                                 <?php if(!empty($data['syncPolicies'])){ ?>
                                                     <?php foreach($data['syncPolicies'] as $key => $value){ 
                                                        $label = $value['name'];
                                                        if( strlen( $label ) > 25 ) {
                                                           $label = substr( $label, 0, 25 ) . '...';
                                                        }?>
                                                         <option value="<?=$value['name']?>" <?php if($data['defaultGuestSyncPolicyName'] == $value['name']){echo 'selected';}?>><?=$label?></option>
                                                         </option>
                                                     <?php } ?>
                                                 <?php } ?>
                                             </select>
                                    </div>
                                    <?php } ?>
                                </div>
                                <div role="tabpanel" class="tab-pane" id="advanced">
                                    </br>
                                    <div class="form-group col-lg-6">
                                        <label for="azureVM">Azure VM</label>
                                        <select class="form-control azureVM selectpicker" name="azureVM" id="azureVM" >
                                            <option value="false" <?php if($data["azureVM"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["azureVM"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="localAD">Local AD</label>
                                        <select class="form-control localAD selectpicker" name="localAD" id="localAD" >
                                            <option value="true" <?php if($data["localAD"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["localAD"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="sslAuthEnabled">SSl Auth Enabled</label>
                                        <select class="form-control sslAuthEnabled selectpicker" name="sslAuthEnabled" id="sslAuthEnabled" >
                                            <option value="false" <?php if($data["sslAuthEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["sslAuthEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="reportRows">Report Rows</label>
                                        <input type="number" class="form-control" name="reportRows" id="reportRows" value="<?=$data['reportRows']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="isCrawlEnabled">Is Crawl Enabled</label>
                                        <select class="form-control isCrawlEnabled selectpicker" name="isCrawlEnabled" id="isCrawlEnabled" >
                                            <option value="false" <?php if($data["isCrawlEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["isCrawlEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="isShareFileNameEnabled">Is Share File Name Enabled</label>
                                        <select class="form-control isShareFileNameEnabled selectpicker" name="isShareFileNameEnabled" id="isShareFileNameEnabled" >
                                            <option value="true" <?php if($data["isShareFileNameEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["isShareFileNameEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="maxCrawlHit">Maximum Crawl Hit</label>
                                        <input type="number" class="form-control" name="maxCrawlHit" id="maxCrawlHit" value="<?=$data['maxCrawlHit']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="noOfMultiADConfig">No. Of Multi AD Configuration</label>
                                        <input type="number" class="form-control" name="noOfMultiADConfig" id="noOfMultiADConfig" value="<?=$data['noOfMultiADConfig']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6" style="margin-bottom:20px;">
                                        <label for="mongoReadPreference">Mongo Read Preference</label>
                                        <select class="form-control mongoReadPreference selectpicker" name="mongoReadPreference" id="mongoReadPreference" >
                                            <option value="false" <?php if($data["mongoReadPreference"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["mongoReadPreference"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="writeConcernLimit">Write Concern Limit</label>
                                        <input type="number" class="form-control" name="writeConcernLimit" id="writeConcernLimit" value="<?=$data['writeConcernLimit']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="ebmsWriteDelayLimit">EBMS Write Delay Limit</label>
                                        <input type="number" class="form-control" name="ebmsWriteDelayLimit" id="ebmsWriteDelayLimit" value="<?=$data['ebmsWriteDelayLimit']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="emailBkpGroupName">Email Backup Group Name</label>
                                        <input type="text" class="form-control" name="emailBkpGroupName" id="emailBkpGroupName" value="<?=$data['emailBkpGroupName']?>" placeholder="Enter Email Backup Group Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="emailSyncGroupName">Email Sync Group Name</label>
                                        <input type="text" class="form-control" name="emailSyncGroupName" id="emailSyncGroupName" value="<?=$data['emailSyncGroupName']?>" placeholder="Enter Email Sync Group Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="bkpGroupEmail">Backup Group Email</label>
                                        <input type="email" class="form-control" name="bkpGroupEmail" id="bkpGroupEmail" value="<?=$data['bkpGroupEmail']?>" placeholder="Enter Backup group Email ID" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="syncGroupEmail">Sync Group Email</label>
                                        <input type="email" class="form-control" name="syncGroupEmail" id="syncGroupEmail" value="<?=$data['syncGroupEmail']?>" placeholder="Enter Sync group Email ID" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="chunkUpdateMaxRetry">Maximum Retry for Chunk Update</label>
                                        <input type="number" class="form-control" name="chunkUpdateMaxRetry" id="chunkUpdateMaxRetry" value="<?=$data['chunkUpdateMaxRetry']?>" placeholder="Enter value" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientMailName">Client Mail Name</label>
                                        <input type="text" class="form-control" name="clientMailName" id="clientMailName" value="<?=$data['clientMailName']?>" placeholder="Enter client Mail Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientSupportMailName">Client Support Mail Name</label>
                                        <input type="email" class="form-control" name="clientSupportMailName" id="clientSupportMailName" value="<?=$data['clientSupportMailName']?>" placeholder="Enter client Support Mail Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="adGroupName">Enter AD Group Name</label>
                                        <input type="text" class="form-control" name="adGroupName" id="adGroupName" value="<?=$data['adGroupName']?>" placeholder="Enter AD Group Name" autocomplete="off">
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label for="adfsUrl">ADFS URL</label>
                                        <input type="text" class="form-control" name="adfsUrl" id="adfsUrl" value="<?=$data['adfsUrl']?>" placeholder="Enter ADFS URL" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="isDomainCheckEnabled">Is Domain Check Enabled</label>
                                        <select class="form-control isDomainCheckEnabled selectpicker" name="isDomainCheckEnabled" id="isDomainCheckEnabled" >
                                            <option value="true" <?php if($data["isDomainCheckEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["isDomainCheckEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
 				                    <div class="form-group col-lg-6">
                                        <label for="bulkEmailDelay">Bulk Email Delay (In Seconds)</label>
                                        <input type="text" class="form-control" name="bulkEmailDelay" id="bulkEmailDelay" value="<?=$data['bulkEmailDelay']?>" onfocusout="myFunctionEmailDelay();" placeholder="Enter Bulk Email Delay" required autocomplete="off">
                                        <span id="delayerror" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
				                    <div class="form-group col-lg-6">
                                        <label for="notifyForRestores">Notify Through Email For Restores</label>
                                        <select class="form-control notifyForRestores selectpicker" name="notifyForRestores" id="notifyForRestores" >
                                            <option value="true" <?php if($data["notifyForRestores"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["notifyForRestores"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="notifyForBackup">Notify Through Email For First Backup Completion</label>
                                        <select class="form-control notifyForBackup selectpicker" name="notifyForBackup" id="notifyForBackup" >
                                            <option value="true" <?php if($data["notifyForBackup"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["notifyForBackup"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div style="padding-left:3%;" class="form-group col-lg-6 row">
                                        <span style="color:#93a3b5;"><p>Fairness Algorithm</p></span>
                                        <div class="col-lg-4" style="padding-left:0%;">
                                        <label class="switch">
                                        <input id="switchFairnessAlgorithm" type="checkbox" <?php if($data['daysToWaitForNextBackup'] > 0 ){echo 'checked';}?>>
                                        <div class="slider round"></div>
                                        </label>
                                        </div>
                                        <div class="col-lg-8">
                                        <input type="number" class="form-control" min="0" name="daysToWaitForNextBackup" id="daysToWaitForNextBackup"  autocomptocomplete="off" value="<?=$data['daysToWaitForNextBackup']?>" <?php if($data['daysToWaitForNextBackup'] <= 0 ){echo 'disabled';}?>/>
                                            <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>


                                </div>
                                <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Environment Level Password Enforcement', 'keywords')?></legend>
                                    <!-- Default checked -->
<div class="form-group col-lg-12">
  <input type="checkbox" class="custom-control-input hide" id="controller">
  <label class="hide" for="controller">Enforce Rules</label>
  <span style="color:#93a3b5;"><p>Enforce Rules</p></span>
  <div class="col-lg-4" style="padding-left:0%;">
                                        <label class="switch">
                                        <input id="controller1" type="checkbox" name="passwordChangeEnforce" value="true" <?php if($data["passwordChangeEnforce"] == true){echo "checked";}?>>
                                        <div class="slider round"></div>
                                        </label>
                                        </div>
                                        
</div>

<div class="form-group col-lg-6 canUserChangePassword1">
                                                <label for="canUserChangePassword1">Can User Change Password</label>
                                                <select class="form-control canUserChangePassword1" name="canUserChangePassword1" required="" title='Select <?=Language::show('canUserChangePassword1', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == false){echo "disabled";}?>>
                                                    <option value="true" <?php if($data["canUserChangePassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false" <?php if($data["canUserChangePassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
<div class="form-group col-lg-6 canAdminChangeUserPassword1">
                                                <label for="canAdminChangeUserPassword1">Can Admin Change User Password</label>
                                                <select class="form-control canAdminChangeUserPassword1" name="canAdminChangeUserPassword1" <?php if($data["passwordChangeEnforce"] == false){echo "disabled";}?>>
                                                    <option value="true" <?php if($data["canAdminChangeUserPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false" <?php if($data["canAdminChangeUserPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
<div class="hide">
  <input type="checkbox" class="custom-control-input canUserChangePassword">
  <label class="custom-control-label" for="canUserChangePassword">Can User Change Password</label>
</div>
<div class="hide">
  <input type="checkbox" class="custom-control-input canAdminChangeUserPassword">
  <label class="custom-control-label" for="canAdminChangeUserPassword">Can Admin Change User Password</label>
</div>
                                </div>
                            </div>
                        </div>
                            </div>


                            <br/>
                            <div class="form-group col-lg-12">
                                <button type="submit" class="btn btn-success pull-left saveCloudProperties">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script type="text/javascript">
    
    function myFunctionEmailDelay(){
        document.getElementById("delayerror").innerHTML = "";
        if(isNaN($('#bulkEmailDelay').val()))
        {
        if (  $('#bulkEmailDelay').val() !='NO DELAY')  {
                document.getElementById("delayerror").innerHTML = "Input can be either 'NO DELAY' or any integer";
                //alert('Invalid Input');
            }
        }
        else{
            document.getElementById("delayerror").innerHTML = "";
        }
    }
    
    $("#switchFairnessAlgorithm").click(function(){
         if ($(this).is(':checked')) {
             $('#daysToWaitForNextBackup').removeAttr('disabled');
         } else {
             $('#daysToWaitForNextBackup').val('0');
             $('#daysToWaitForNextBackup').attr('disabled', true); 
         }
     });


    $('#controller1').click(function(){
        if ($(this).is(':checked')) {
            console.log("checked");
            $('.canUserChangePassword1').attr("disabled", false);
            $('.canAdminChangeUserPassword1').attr("disabled", false);      
            $('.canUserChangePassword1').find('option[value="true"]').prop("selected",true);     
         } else {
            console.log("unchecked");
            $('.canUserChangePassword1').find('option[value="true"]').prop("selected",true);  
            $('.canAdminChangeUserPassword1').find('option[value="false"]').prop("selected",true);  
            $('.canUserChangePassword1').attr('disabled', true); 
            $('.canAdminChangeUserPassword1').attr('disabled', true); 
             
         }

    });
</script>
<style>
 .switch {
   position: relative;
   display: inline-block;
   width: 60px;
   height: 34px;
 }
 
 .switch input {display:none;}
 
 .slider {
   position: absolute;
   cursor: pointer;
   top: 0;
   left: 0;
   right: 0;
   bottom: 0;
   background-color: #ccc;
   -webkit-transition: .4s;
   transition: .4s;
 }
 
 .slider:before {
   position: absolute;
   content: "";
   height: 26px;
   width: 26px;
   left: 4px;
   bottom: 4px;
   background-color: white;
   -webkit-transition: .4s;
   transition: .4s;
 }
 
 input:checked + .slider {
   background-color: #2196F3;
 }
 
 input:focus + .slider {
   box-shadow: 0 0 1px #2196F3;
 }
 
 input:checked + .slider:before {
   -webkit-transform: translateX(26px);
   -ms-transform: translateX(26px);
   transform: translateX(26px);
 }
 /* Rounded sliders */
 .slider.round {
   border-radius: 34px;
 }
 
 .slider.round:before {
   border-radius: 50%;
 }
 </style>