<?php

use \Core\View;
use Helpers\Form;
use \Helpers\Url;
use Helpers\Auth;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.4
* @date 18/09/18
* @time 12:43 PM
*
*/
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='aadCredentials'?></span>
            <div class="row">
                <div class="panel noAadCredentialsPanel">
                    <div class="panel-heading">
                        <h4><span class="pull-right"><button id="addAAD"style="margin-top: 5px;" class="btn btn-success btn-small" data-toggle="modal" data-target="#addAad">Add Credentials</button></span></h4>
                    </div>
                    <div>
                        <h2 align="center">There are no AAD Credentials Saved</h2>
                    </div>
                </div>
                <div class="panel aadCredentialsPanel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;"><?=Language::show('azureActiveDirectoryCredentials', 'keywords')?><span class="pull-right"><a id="editAAD" style="margin-top: 5px;" class="btn btn-success btn-small" ng-click="editAadCredentials()">Edit Credentials</a></span></h4>
                    </div>
                    <div class="panel-body">
                        <form class="aadConfiguration" ng-submit="saveAadConfiguration()" data-parsley-validate>
                                <div class="form-group col-lg-6">
                                    <label for="clientIdForLogin"><?=Language::show('clientIdForLogin', 'keywords')?></label>
                                    <input type="text" class="form-control" name="clientIdForLogin" id="clientIdForLogin" value="" placeholder="Enter your clientIdForLogin" required autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 hide">
                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                    <input type="text" class="form-control" name="clientId" id="clientId" value="" placeholder="Enter your clientId" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 hide">
                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                    <input type="text" class="form-control" name="secretKey" id="secretKey" value="" placeholder="Enter your Azure Active Directory secretKey" autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6 tenentId hide">
                                        <label for="tenentId"><?=Language::show('tenentId', 'keywords')?></label>
                                        <input type="text" class="form-control" name="tenentId" id="tenentId" value="" placeholder="Enter your Azure Active Directory tenentId" autocomplete="off" readonly>
                                    </div>
                                <div class="form-group col-lg-6 redirectURI hide">
                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                    <input type="text" class="form-control" name="redirectURI" id="redirectURI" value="" placeholder="Enter your Azure Active Directory redirectURI" autocomplete="off" readonly>
                                </div>
                                <div class="col-lg-6">
                                    <label for="groupConfigurations"><?=Language::show('groupConfigurations', 'keywords')?></label></br>
                                    <table id="myTableShow" class="myTable table table-bordered">
                                        <colgroup>
                                            <col class="col-lg-4">
                                            <col class="col-lg-4">
                                        </colgroup>
                                        <thead>
                                            <tr>
                                                <th>Group Name</th>
                                                <th>Product Type</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="(key,value) in aad">
                                                <td ng-if="key != '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="aadGpName[]" id="aadGpName{{$index}}" value="{{key}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>
                                                <td ng-if="key == '_empty_'" ng-cloak>
                                                    <input type="text" class="form-control" name="aadGpName[]" id="aadGpName{{$index}}" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off" readonly>
                                                </td>
                                                <td ng-cloak style="white-space:unset !important;">
                                                    <select class="form-control" name="aadPtType[]" id="aadPtType{{$index}}" disabled>
                                                        <option value="BACKUP" ng-selected="valye == 'BACKUP'">Backup</option>
                                                        <option value="SYNC" ng-selected="value == 'SYNC'">Sync</option>
                                                        <option value="BOTH" ng-selected="value == 'BOTH'">Both</option>                       
                                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>                                
                                <!--<button style="margin-right: 5px;" type="submit" class="btn btn-success pull-right aadSave">Save</button>-->
                                <!--<div>
                                    <a href="javascript:;" class="btn btn-default" ng-click="gotTo('/settings/importUsersAAD')"><i class="fa fa-user-plus"> Import Users from AAD</i></a>
                                </div>-->
                        </form>
                    </div>
                </div>
                <!--start add-->
                <div class="modal fade" id="addAad" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content mediumModal">
                            <?= Form::open(array(
                                        'ng-submit' => 'saveAadConfiguration()',
                                        'class' => 'aadAadCredentials',
                                        'csrf' => $data['csrf_token'],
                                        'autocomplete' => 'off'
                                        )); ?>
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            <h4 class="modal-title"><?=Language::show('addYourAzureActiveDirectoryCredentials', 'keywords')?></h4>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="clientIdForLogin"><?=Language::show('clientIdForLogin', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientIdForLoginadd" id="clientIdForLogin2" value="" placeholder="Enter your clientIdForLogin" required autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 hide">
                                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientIdadd" id="clientId2" value="" placeholder="Enter your clientId" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 hide">
                                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="secretKeyadd" id="secretKey2" value="" placeholder="Enter your Azure Active Directory secretKey" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 tenentId hide">
                                                    <label for="tenentId"><?=Language::show('tenentId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="tenentIdadd" id="tenentId2" value="" placeholder="Enter your Azure Active Directory tenentId" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 redirectURI hide">
                                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="redirectURIadd" id="redirectURI2" value="" placeholder="Enter your Azure Active Directory redirectURI" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="panel-heading">
                                                <h4><?=Language::show('groupConfigurations', 'keywords')?><span class="pull-right"><a onclick="addDynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span></h4>
                                            </div>
                                                <div class="panel-body">
                                                <table id="myTableAdd" class="myTableAdd table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
                                                            <th>Product Type</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="first1">
                                                            <td ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupNameadd[]" id="aadGroupNamee1" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control" name="aadProductTypeadd[]" id="aadProductTypee1" required>
                                                                    <option value="BACKUP">Backup</option>
                                                                    <option value="SYNC">Sync</option>
                                                                    <option value="BOTH">Both</option>                       
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <a onclick="RemoveAdd(this)" class="btn btn-small btn-danger clickAble"><i class="fa fa-times"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success addCredentialsBtn"><?=Language::show('save', 'keywords')?></button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('close', 'keywords')?></button>

                                        </div>
                            <?= Form::close(); ?>
                        </div>
                    </div>
                </div>
                <!--end add -->
                <!--start-->
                <div class="modal fade" id="editAad" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content mediumModal">
                            <?= Form::open(array(
                                        'ng-submit' => 'saveAadConfiguration1()',
                                        'class' => 'editAadCredentials',
                                        'csrf' => $data['csrf_token'],
                                        'autocomplete' => 'off'
                                        )); ?>
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            <h4 class="modal-title"><?=Language::show('editYourAzureActiveDirectoryCredentials', 'keywords')?></h4>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="clientIdForLogin"><?=Language::show('clientIdForLogin', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientIdForLogin" id="clientIdForLogin1" value="" placeholder="Enter your clientIdForLogin" required autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 hide">
                                                    <label for="clientId"><?=Language::show('clientId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="clientId" id="clientId1" value="" placeholder="Enter your clientId" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 hide">
                                                    <label for="secretKey"><?=Language::show('secretKey', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="secretKey" id="secretKey1" value="" placeholder="Enter your Azure Active Directory secretKey" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 tenentId hide">
                                                    <label for="tenentId"><?=Language::show('tenentId', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="tenentId" id="tenentId1" value="" placeholder="Enter your Azure Active Directory tenentId" autocomplete="off">
                                                </div>
                                                <div class="form-group col-lg-6 redirectURI hide">
                                                    <label for="redirectURI"><?=Language::show('redirectURI', 'keywords')?></label>
                                                    <input type="text" class="form-control" name="redirectURI" id="redirectURI1" value="" placeholder="Enter your Azure Active Directory redirectURI" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="panel-heading">
                                                <h4><?=Language::show('groupConfigurations', 'keywords')?><span class="pull-right"><a onclick="dynamicAdd()" class="btn btn-small btn-success clickAble"><i class="fa fa-plus"></i>Add Group</a></span></h4>
                                            </div>
                                                <div class="panel-body">
                                                <table id="myTable" class="myTable table table-bordered">
                                                    <colgroup>
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-4">
                                                        <col class="col-lg-2">
                                                    </colgroup>
                                                    <thead>
                                                        <tr>
                                                            <th>Group Name</th>
                                                            <th>Product Type</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr ng-repeat="(key,value) in aad" class="first">
                                                            <td ng-if="key != '_empty_'" ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupName[]" id="aadGroupName{{$index}}" value="{{key}}" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-if="key == '_empty_'" ng-cloak>
                                                                <input type="text" class="form-control" name="aadGroupName[]" id="aadGroupName{{$index}}" value="" placeholder="Enter your Azure Active Directory group name" autocomplete="off">
                                                            </td>
                                                            <td ng-cloak style="white-space:unset !important;">
                                                                <select class="form-control" name="aadProductType[]" id="aadProductType{{$index}}" required>
                                                                    <option value="BACKUP" ng-selected="value == 'BACKUP'">Backup</option>
                                                                    <option value="SYNC" ng-selected="value == 'SYNC'">Sync</option>
                                                                    <option value="BOTH" ng-selected="value == 'BOTH'">Both</option>                       
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <a onclick="Remove(this)" class="btn btn-small btn-danger clickAble"><i class="fa fa-times"></i></a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success editCredentialsBtn"><?=Language::show('save', 'keywords')?></button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('close', 'keywords')?></button>

                                        </div>
                            <?= Form::close(); ?>
                        </div>
                    </div>
                </div>
                <!--end-->
            </div>
            <div class="row storageMappingButton">
                <?php if($data['data']->{'authRequired'} != false) {?>
                <div class="panel">
                    <div class="panel-heading"><h4>Azure Active Directory Mapping</h4>
                    </div>
                    <div class="panel-body">
                        <div class="form-group col-lg-12">
                            <div class="well well-lg">
                                <?php
                                $tenentId = $data['data']->{'tenentId'};
                                $clientId = $data['data']->{'clientId'};
                                $redirectURI = $data['data']->{'redirectURI'};
                                    $params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectURI;

                                    $ADUrl = API_APP_URL1.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
                                ?>
                                <p>
                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$ADUrl;?>')"><i class="fa fa-windows"></i> Map Azure Active Directory</a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>

<script>

function dynamicAdd(){
    var trlength= $('#myTable tbody tr').length;
    var i = trlength;
    var lasttr=$('#myTable tbody tr:last').clone();
    lasttr.find('select').attr('id', 'aadProductType' + trlength);
    lasttr.find('select').attr('name', 'aadProductType[]');
    lasttr.find('input').attr('id', 'aadGroupName' + trlength);
    lasttr.find('input').attr('name', 'aadGroupName[]');
    lasttr.find('input').attr('value', '');
    lasttr.find('a').attr('id', 'remove' + trlength); 
    lasttr.find('a').attr("onclick", "Remove(this);");               
    i++;    
    $('#myTable tbody').append(lasttr);
}

function Remove(button) {
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTable");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    //}
};

function addDynamicAdd(){
    var trlength= $('#myTableAdd tbody tr').length;
    var i = trlength;
    var lasttr=$('#myTableAdd tbody tr:last').clone();
    lasttr.find('select').attr('id', 'aadProductType' + trlength);
    lasttr.find('select').attr('name', 'aadProductTypeadd[]');
    lasttr.find('input').attr('id', 'aadGroupName' + trlength);
    lasttr.find('input').attr('name', 'aadGroupNameadd[]');
    lasttr.find('input').attr('value', '');
    lasttr.find('a').attr('id', 'removeAdd' + trlength); 
    lasttr.find('a').attr("onclick", "RemoveAdd(this);");               
    i++;    
    $('#myTableAdd tbody').append(lasttr);
}

function RemoveAdd(button) {
    //Determine the reference of the Row using the Button.
    var row = button.parentNode.parentNode;
    var name = row.getElementsByTagName("TD")[0].innerHTML;
    //if (confirm("Do you want to delete: " + name)) {
    //Get the reference of the Table.
    var table = document.getElementById("myTableAdd");
    //Delete the Table row using it's Index.
    table.deleteRow(row.rowIndex);
    //}
};

</script>