<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
	  <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('dashboard')?>"><?="Dashboard"?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='noBackup'?></span>
<div class="row">
                <div class="panel">
                    <div class="panel-heading"><h3><?=$data['crumb1']?></div>
                    <div class="panel-body"><div class="row">
                            <div class="col-lg-12">
                                <form class="form-inline" ng-submit="updateAgentNotHeard(search.noOfDays,search.searchPolicyName)" data-parsley-validate>
                                    <div class="row">
<div class="col-lg-4">       
<label for="searchPolicyName">Policy Name</label>
<select name="searchPolicyName[]" id="searchPolicyName" multiple class="form-control selectPicker searchPolicyName"  title='Select Backup Policy Name'>
<option value="all" selected>all</option>
                                                <?php if(!empty($data['backupPolicies'])){ ?> 
                                                    <?php foreach($data['backupPolicies'] as $value){ 
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                    <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                        </div>
                                        <div class="col-lg-3">
                                            <label for="noOfDays">Number of Days</label>
                                            <input type="number" class="form-control" id="noOfDays" ng-model="search.noOfDays" min="1" placeholder="Number Of Days" data-parsley-trigger="change">
                                        </div>                                           
                                        <div class="col-lg-2">
                                            <button type="submit" class="btn btn-default" style="margin-top:25px;">View</button>
                                             <a ng-click="downloadAgentNotHeardReport(search.noOfDays,search.searchPolicyName)" class="btn btn-default" style="margin-top:25px;">Download</a>     
                                        </div>
                                        
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
<br/>
                        <table id="NoBackup" class="table table-bordered noBackup" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                                        <?=Language::show('Server', 'keywords')?>
                                    <?php }else{ ?>
                                        <?=Language::show('deviceName', 'keywords')?>
                                    <?php } ?>
                                    <span ng-show="lastAgentServerSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="lastAgentServerSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="lastAgentServerSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="lastAgentServerSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="lastAgentServerSortType = 'formatedTime'; sortReverse = !sortReverse">
                                    <?=Language::show('last_server_connection_time', 'keywords')?>
                                    <span ng-show="lastAgentServerSortType == 'formatedTime' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="lastAgentServerSortType == 'formatedTime' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in noBackup | orderBy:lastAgentServerSortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <td ng-cloak>{{ value.userName }}</td>
                                <td ng-cloak>{{ value.formatedTime }}</td>
                            </tr>
                            </tbody>
                        </table>
                        <div class="h4 noBackupError text-center" style="display: none">No details found</div>
                    </div>
                    <div class="row loadMore" style="display: none;">
<div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, 'longBackup')">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<style>
@media (min-width: 1200px)
.col-lg-4 {
    width: 30.333333% !important;
}
</style>
