<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('report/dashboard')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
                <li><?=$data['crumb2']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='alertHistory'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading"><h3><?=$data['crumb2']?></h3></div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <form class="form-inline" ng-submit="updateAlertHistory(search.userName, '', '', '')" data-parsley-validate>
                                    <div class="form-group">
                                        <select class="searchUsername" id="userName" ng-model="search.userName" data-parsley-trigger="change" required></select>
                                        <button type="submit" class="btn btn-default">Generate Report</button>
                                        <a ng-click="exportToExcel('#alertHistoryByUser', 'Alert History by Device', alertHistory)" class="btn btn-default">Export To excel</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <table id="alertHistoryByUser" class="table table-bordered alertHistory" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?=Language::show('device', 'keywords')?>
                                    <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('user', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'action'; sortReverse = !sortReverse">
                                    <?=Language::show('details', 'keywords')?>
                                    <span ng-show="sortType == 'action' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'action' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in alertHistory | orderBy:sortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <td ng-cloak>{{ value.userName }}</td>
                                <td ng-cloak>{{ value.action }}</td>
                            </tr>
                            </tbody>
                        </table>
                        <div class="h4 alertHistoryError text-center" style="display: none">No details found for the provided username</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>


    $('.searchUsername').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserName",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select user'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>