<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><a href="<?=Url::basePath('pms')?>"><h3><?=$data['title']?></h3></a></li>
                <li><span><?=$data['crumb1']?></span></li>
                <li><span><?=$data['crumb2']?></span></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SyncPmsController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11" block-ui="myBlockUI">
            <span class="hide csrf_token"><?=$data['csrf_token']?></span>
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=$data['crumb2']?></h4>
                </div>
                <div class="panel-body">
                    <div class="form-group">
                        <label for="policy"><?=Language::show('policyName', 'keywords');?></label><br/>
                        <select class="form-control selectPolicyPicker" name="multiplePolicyName" id="policy" required="" title='Select Policy'>
                            <?php if(!empty($data['policies'])){ ?>
                                <?php foreach($data['policies'] as $key => $value){ ?>
                                    <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                <?php } ?>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                            <label for="userNames"><?=Language::show('Server Names', 'keywords');?></label><br/>
                        <?php }else{ ?>
                            <label for="userNames"><?=Language::show('User Names', 'keywords');?></label><br/>
                        <?php } ?>
                        <input type="text" data-role="tagsinput" value="" class="form-control" name="userNames[]" id="userNames" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('userNames', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <a ng-click="changeMultiplePolicy()" class="btn btn-success pmsSavePolicyBtn"><i class="fa fa-save"></i> Save</a>
                        <a class="btn btn-danger" href="<?=Url::basePath('pms')?>"><i class="fa fa-times"></i> Cancel</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.selectPolicyPicker').selectpicker('render');
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/SyncPmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
//    $(".assignUsers").select2({
//        ajax: {
//            url: "<?//=DIR?>//"+"user/searchUserName",
//            dataType: 'json',
//            delay: 250,
//            data: function (params) {
//                return {
//                    q: params.term, // search term
//                    page: params.page
//                };
//            },
//            processResults: function (data, params) {
//                params.page = params.page || 1;
//                if(data.users.length > 0){
//                    $('.assignSaveBtn').removeAttr('disabled');
//                }
//                return {
//                    results: $.map(data.users, function (o) {
//                        return { id: o.userName, text: o.userName, img: o.profilePic };
//                    }),
//                    pagination: {
//                        more: (params.page * 30) < data.total_count
//                    }
//                };
//            },
//            cache: true
//        },
//        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
//        minimumInputLength: 0,
//        templateResult: selectTemplateResult,
//        templateSelection: selectTemplateSelection,
//        placeholder: 'Select user names/server names'
//    });
//
//    function selectTemplateResult(users){
//        if(users.text != undefined){
//            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
//            if(users.img){
//                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
//            }
//            template += users.text + "</div></div>";
//            return template;
//        }else{
//            return "<div class='select2-user-result'>Fetching...</div>";
//        }
//    }
//
//    function selectTemplateSelection(users){
//        return users.text;
//    }
</script>