    <?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SyncPmsController">
    <span class="hide currentPage"><?='policy'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=$data['crumb1']?><span class="pull-right"><a class="btn btn-success btn-small" href="<?=Url::basePath('pms/sync/policy/create')?>"><?=Language::show('create_new_policy', 'keywords');?></a></span></h4>
                </div>
                <div class="panel-body">
                    <div class="bs-example syncPolicyTable" style="display: none;" data-example-id="simple-responsive-table">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <colgroup>
                                    <col class="col-xs-3">
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-4">
                                </colgroup>
                                <thead>
                                <tr>
                                   <th class="text-left clickAble" ng-click="sortType = 'policygroupName'; sortReverse = !sortReverse">
                                    <?=Language::show('policyName', 'keywords')?>
                                    <span ng-show="sortType == 'policygroupName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'policygroupName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-left clickAble" ng-click="sortType = 'maxVersionsForSort'; sortReverse = !sortReverse">
                                    <?=Language::show('maxVersions', 'keywords')?>
                                    <span ng-show="sortType == 'maxVersionsForSort' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'maxVersionsForSort' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-left clickAble" ng-click="sortType = 'userSizeAllowed'; sortReverse = !sortReverse">
                                    <?=Language::show('userStorageQuota', 'keywords')?>
                                    <span ng-show="sortType == 'userSizeAllowed' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userSizeAllowed' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                   <th class="text-left"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in policies | orderBy:sortType:sortReverse">
                                    <td ng-cloak>{{ value.policygroupName | limitTo:25}}{{value.policygroupName.length > 25 ? '...' : ''}}</td>
                                    <td ng-cloak ng-if="value.maxVersions > 0">{{ value.maxVersions }}</td>
                                    <td ng-cloak ng-if="value.maxVersions < 0">UNLIMITED</td>
                                    <td ng-cloak ng-show="value.userSizeAllowed < 102400">{{ value.userSizeAllowed }}</td>
                                    <td ng-cloak ng-show="value.userSizeAllowed >= 102400">UNLIMITED</td>
                                    <td>
                                    <a href="" class="btn btn-default btn-small btn-success" ng-click="viewPolicy(value.policygroupName)"><i class="fa fa-eye"></i> <?=Language::show('view', 'keywords')?></a>
                                    <a href="<?=Url::basePath('pms/sync/policy/edit/{{value.policygroupName}}')?>" class="btn btn-default btn-small btn-success"><i class="fa fa-edit"></i> <?=Language::show('edit', 'keywords')?></a>
                                    <a href="<?=Url::basePath('pms/sync/policy/clone/{{value.policygroupName}}')?>" class="btn btn-default btn-small btn-success"><i class="fa fa-copy"></i> <?=Language::show('clone', 'keywords')?></a>
                   </td>
                                </tr>
                                </tbody>
                            </table>
                        </div><!-- /.table-responsive -->
                    </div>
                    <div class="syncPolicyTableEmpty" style="display: none;">
                        <h2 class="-align-center">No policy has been created yet</h2>
                    </div>
                </div>
            </div>
        </div>
    
        <div class="modal fade viewPolicy">
                <div class="modal-dialog">
                    <div class="modal-content mediumModal">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">View Policy</h4>
                        </div>
                        <div class="modal-body">
                            <!-- start -->
                            <div class="panel-body" style="padding: 0px 30px 30px 30px;" block-ui="myBlockUI">
                    <span class="hide currentPage"><?='editPolicy'?></span>
                    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group hide">
                                <div class="checkbox check-primary">
                                    <input id="legalHold" name="legalHold" type="checkbox" value="enabled">
                                    <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>
                                    <span class="systemFolders" style="display: none;">
                                    <input id="systemFolders" name="systemFolders" type="checkbox" value="enabled">
                                    <label for="systemFolders"><?=Language::show('systemFolders', 'keywords');?></label>
                                </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policyName" value="{{ selectedPolicy.policygroupName }}" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" required autocomplete="off" readonly>
                            </div>
                        </div>
                    </div>
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li role="presentation"><a data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">
                            <div class="row">
                                <div class="col-lg-12">
                                    <br/>
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('sync_information', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group syncEnableAutomatic <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                                        <label for="syncEnableAutomatic"><?=Language::show('syncEnableAutomatic', 'keywords');?></label>
                                        <select class="form-control syncEnableAutomatic" name="syncEnableAutomatic" id="syncEnableAutomatic" required="" title='Select <?=Language::show('syncEnableAutomatic', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="syncInterval"><?=Language::show('syncInterval', 'keywords');?> (In Minutes)</label>
                                        <input type="text" class="form-control" name="syncInterval" id="syncInterval" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('syncInterval', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.syncInterval }}" disabled/>
                                    </div>
                                    <div class="form-group contentIndexEnabled hide">
                                        <label for="contentIndexEnabled"><?=Language::show('contentIndexEnabled', 'keywords');?></label>
                                        <select class="form-control contentIndexEnabled" name="contentIndexEnabled" id="contentIndexEnabled" required="" title='Select <?=Language::show('contentIndexEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group deDuplicationEnabled hide">
                                        <label for="deDuplicationEnabled"><?=Language::show('deDuplicationEnabled', 'keywords');?></label>
                                        <select class="form-control deDuplicationEnabled" name="deDuplicationEnabled" id="deDuplicationEnabled" required="" title='Select <?=Language::show('deDuplicationEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switchver" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVer();" disabled/>
                                            <span id="vererror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxFileSize"><?=Language::show('maxFileSize', 'keywords');?> (In MB)</label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switchsize" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="maxFileSize" id="maxFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxFileSize', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionMPS();" disabled/>
                                        <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="userSizeAllowed"><?=Language::show('Device Storage Quota', 'keywords');?> (In GB)</label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switchlimit" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="userSizeAllowed" id="userSizeAllowed" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('userSizeAllowed', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionUBS();" disabled/>
                                        <span id="limiterror" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
                                </div>
                </div>
                            </div>
                            <div class="row hide">
                                <div class="col-lg-6">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                                    <div class="form-group hide">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker" name="osType" id="osType" title='Select OS Type'>
                                            <option value="windows">Windows</option>
                                            <option value="mac">Mac</option>
                                        </select>
                                    </div>
                                    <div class="form-group hide">
                                        <label for="memoryUtilization"><?=Language::show('memoryUtilization', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="memoryUtilization" id="memoryUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.memoryUtilization }}" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="cpuUtilization"><?=Language::show('cpuUtilization', 'keywords');?> (In Percentage)</label>
                                        <input type="text" class="form-control" name="cpuUtilization" id="cpuUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.cpuUtilization }}" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="cacheUsedData"><?=Language::show('cacheUsedData', 'keywords');?></label>
                                        <select class="form-control cacheUsedData" name="cacheUsedData" id="cacheUsedData" required="" title='Select <?=Language::show('cacheUsedData', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble" ng-click="addNewFilter()">Create New Filter</a></label>
                                        <input type="text" class="form-control" name="filters" id="filters" readonly/>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row allFilters" ng-if="defaultFilter != undefined">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <?=Language::show('filterName', 'keywords');?>: {{ defaultFilter.filterName }}
                                                    <br/>
                                                    <?=Language::show('Filter Type', 'keywords');?>: {{ defaultFilter.filterType }}
                                                    <br/>
                                                    <?=Language::show('filters', 'keywords');?>: <b style="word-wrap: break-word">{{ defaultFilter.filters }}</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                    <div class="col-lg-7 hide">
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('cloudCredentials', 'keywords');?></legend>
                                            <div class="form-group">
                                                <label for="ccS"><?=Language::show('cloudCredentials', 'keywords');?> - <a class="clickAble" ng-click="addNewCcS()">Create New <?=Language::show('cloudCredentials', 'keywords');?></a></label>
                                                 <input type="text" class="form-control" name="ccS" id="ccS" readonly/>
                                            </div>
                                    </div>
                                    <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultCloud != undefined">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-cloud"></i> Clouds</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <h5><?=Language::show('cloudName', 'settings');?>: {{ defaultCloud.cloudCredentialName }}</h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'azureBlob'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('azureBlob', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'ibmCloud'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('ibmSoftlayer', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'oneDrive'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('microsoft', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'googleDrive'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('googleDrive', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'amazon'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('amazonS3', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'localStorage'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('localStorage', 'settings');?></h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                            </div>
                        <div role="tabpanel" class="tab-pane" id="advanced">
                            
                              <div class="row">
                                    <div class="col-lg-7">
                                        <br/>
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('partialFileAttributes', 'keywords')?></legend>
                                        <div class="form-group">
                                            <label for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                            <select class="form-control incrementalFileTransfer" name="incrementalFileTransfer" id="incrementalFileTransfer" required="" title='Select <?=Language::show('incrementalFileTransfer', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        </br>
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('networkThrottlingAttributes', 'keywords')?></legend>
                                        <!--<div class="form-group">
                                        <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In MBPS)</label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="nwFromClientToPG" id="nwFromClientToPG" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromClientToPG', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunction();" disabled/>
                                        </div><span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>-->
					<div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                            <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In Mbps)</label>
                                            <div class="col-lg-8">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                              <div class="col-lg-6">
                                              <input type="text" class="form-control" name="nwFromClientToPGMB" id="nwFromClientToPGMB" placeholder="" required autocomplete="off" value="UNLIMITED" data-parsley-min="1" data-parsley-max="1024" onfocusout="myFunctionMB();" disabled/>
                                              <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                              </div>
                                              <div class="col-lg-6">
                                                <select class="form-control" name="networkThrottlingUnit" id="networkThrottlingUnit" required="" title='Select <?=Language::show('networkThrottlingUnit', 'keywords')?>' disabled>
                                                    <option value="kbps"><?=Language::show('kbps', 'keywords')?></option>
                                                    <option value="mbps" selected><?=Language::show('mbps', 'keywords')?></option>
                                                    <option value="gbps"><?=Language::show('gbps', 'keywords')?></option>
                                                </select>
                                              </div>
                                        </fieldset>
                                    </div>
                                        <div class="form-group hide">
                                            <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                            <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.nwFromPGToCloud }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                        </div>
                                        <div class="form-group hide">
                                            <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                            <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-5">
                                        </br></br>
                                        <div class="row partialfileattributerow">
                                            <div class="col-lg-12">
                                                 <div class="panel panel-default">
                                                    <div class="panel-body">
                                                        <div class="form-group">
                                                            <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                                            <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.pftSize }}" data-parsley-type="integer" data-parsley-min="1" readonly/>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                                            <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.fileChunkableSize }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" readonly/>
                                                        </div>
                                                    </div>
                                                 </div>
                                            </div>
                                        </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('options', 'keywords')?></legend>
                                    <div class="form-group dedup">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <input type="text" class="form-control" name="dedup" id="dedup" readonly/>
                                        </div>
                                   
                                   <div class="form-group">
                                        <label for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                        <select class="form-control compEnabled" name="compEnabled" id="compEnabled" required="" title='Select <?=Language::show('compEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group hide">
                                        <label for="dcmEnabled"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                        <select class="form-control dcmEnabled" name="dcmEnabled" id="dcmEnabled" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group searchAlgoForPg">
                                        <label for="searchAlgoForPg"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                        <input type="text" class="form-control" name="searchAlgoForPg" id="searchAlgoForPg" readonly/>
                                    </div>
                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <input type="text" class="form-control" name="Blukryptipaddress" id="Blukryptipaddress" readonly/>
                                    </div>
                                    <div class="form-group <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                                        <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                        <input type="number" class="form-control input-small" id="policyRefresh" name="policyRefresh" min="0" max="23" required="" readonly>
                                    </div>
                                </div>                        
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('Environment Level Password Enforcement', 'keywords')?></legend>
                                    <?php if($data["passwordChangeEnforce"] == true){?>
                                    <div class="form-group">
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePasswordNE" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canUserChangePassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>

                                            <option value="false" <?php if($data["canUserChangePassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPasswordNE" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == true){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canAdminChangeUserPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canAdminChangeUserPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } else {?>
                                    <div class="form-group">
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePassword" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPassword" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } ?>

                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('Share Details', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('share', 'keywords');?></label>
                                        <select class="form-control shareEnabled" name="shareEnabled" id="shareEnabled" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				                    <div class="form-group twoWayShareEnabled <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                                        <label for="twoWayShareEnabled"><?=Language::show('twoWayShareEnabled', 'keywords');?></label>
                                        <select class="form-control twoWayShareEnabled" name="twoWayShareEnabled" id="twoWayShareEnabled" <?php if(BLUDRIVE_MODE == false){?> required="" <?php } ?> title='Select <?=Language::show('twoWayShareEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group highSecureShareEnabled">
                                        <label for="highSecureShareEnabled"><?=Language::show('highSecureShareEnabled', 'keywords');?></label>
                                        <select class="form-control highSecureShareEnabled" name="highSecureShareEnabled" id="highSecureShareEnabled" required="" title='Select <?=Language::show('highSecureShareEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="row highSecuredShareOptions">
                                        <div class="col-lg-1 subimage" style="margin-top: 35px;text-align: center;"><i class="fa fa-caret-square-o-right"></i></div>
                                        <div class="col-lg-11">
                                            <div class="form-group complexPasswordRequired">
                                                <label for="complexPasswordRequired"><?=Language::show('complexPasswordRequired', 'keywords');?></label>
                                                <select class="form-control complexPasswordRequired" name="complexPasswordRequired" id="complexPasswordRequired" required="" title='Select <?=Language::show('complexPasswordRequired', 'keywords')?>'>
                                                    <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-1 subimage" style="margin-top: 35px;text-align: center;"><i class="fa fa-caret-square-o-right"></i></div>
                                        <div class="col-lg-11">
                                            <div class="form-group preventDownloadEnabled">
                                                <label for="preventDownloadEnabled"><?=Language::show('preventDownloadEnabled', 'keywords');?></label>
                                                <select class="form-control preventDownloadEnabled" name="preventDownloadEnabled" id="preventDownloadEnabled" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>'>
                                                    <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-1 subimage" style="margin-top: 35px;text-align: center;"><i class="fa fa-caret-square-o-right"></i></div>
                                        <div class="col-lg-11">
                                            <div class="form-group expiredDate">
                                                <label for="expiredDate"><?=Language::show('expiredDate', 'keywords');?></label>
                                                <select class="form-control expiredDate" name="expiredDate" id="expiredDate" required="" title='Select <?=Language::show('expiredDate', 'keywords')?>'>
                                                    <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('uISettingsForAgent', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-6 <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('EXIT', 'keywords');?></label>
                                        <select class="form-control exitt" name="exitt" id="exitt" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('DECOUPLE', 'keywords');?></label>
                                        <select class="form-control decouple" name="decouple" id="decouple" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('SUPPORT', 'keywords');?></label>
                                        <select class="form-control support" name="support" id="support" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('INITIATE_SYNC', 'keywords');?></label>
                                        <select class="form-control initiatesync" name="initiatesync" id="initiatesync" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('SYNC_SETTINGS', 'keywords');?></label>
                                        <select class="form-control syncsettings" name="syncsettings" id="syncsettings" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>">
                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('SYNC_FILES', 'keywords');?></label>
                                        <select class="form-control syncfiles" name="syncfiles" id="syncfiles" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('REFRESH_SYNC_POLICY', 'keywords');?></label>
                                        <select class="form-control refreshsyncpolicy" name="refreshsyncpolicy" id="refreshsyncpolicy" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('SEARCH', 'keywords');?></label>
                                        <select class="form-control search" name="search" id="search" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('OPEN_SYNC_FOLDER', 'keywords');?></label>
                                        <select class="form-control opensyncfolder" name="opensyncfolder" id="opensyncfolder" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				   <?php if(DISABLE_BLOCK_NOTIFICATIONS==false){?>
                                    <div class="form-group">
                                        <label for="blockNotifications"><?=Language::show('BLOCK_NOTIFICATIONS', 'keywords');?></label>
                                        <select class="form-control blockNotifications" name="blockNotifications" id="blockNotifications" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" ><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                   <?php }?>	
                                </div>
                            </div>   
                            </div>
                        </div>
                            <!-- end -->
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('close', 'keywords')?></button>
                        </div>
                    </div>
                </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
<script src="<?=Url::templatePath()?>js/angular/controllers/SyncPmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
