<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=Language::show('downloadAgent', 'keywords')?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <?php if(ENABLE_EPA == true){ ?>
                <div class="row">
                    <div class="panel">
                        <div class="panel-heading">
                            <h4 style="padding: 0px 0px 0px 15px;">For Desktops & Laptops</h4>
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                <?php if(WINDOWS_EPA == true){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble <?php if(WINDOWSPC_APP == false){echo 'building';} ?>" <?php if(WINDOWSPC_APP == true){echo 'ng-click="download(\'EPAForWindows\')"';} ?>>
                                            <div class="background">
                                                <i class="fa fa-windows"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-windows"> For Windows</i><br>
                                                <a>End Point Agent for Windows</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if(MAC_EPA == true){ ?>
                                    <div class="col-lg-4 toolTip" <?php  if(PORTAL_LIGHT_VERSION == true){ ?>data-toggle="tooltip" data-placement="right" title="Mac Agent is not available in Lite Version"<?php }?>>
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble"<?php  if(PORTAL_LIGHT_VERSION == true){ ?>style="cursor: not-allowed;" <?php }?> <?php  if(PORTAL_LIGHT_VERSION == false){ ?> <?php if(MAC_APP == false){echo 'building';} ?>" <?php if(MAC_APP == true){echo ' ng-click="download(\'EPAForMac\')"';} ?> <?php } ?>>
                                            <div class="background">
                                                <i class="fa fa-apple"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-apple"> For Mac</i><br>
                                                <a>End Point Agent for Mac</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
            <?php if(ENABLE_MOBILE_APPS == true){ ?>
                <div class="row">
                    <div class="panel">
                        <div class="panel-heading">
                            <h4 style="padding: 0px 0px 0px 15px;">For Tablets & Smart phones</h4>
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                <?php if(ENABLE_ANDROID_APP == true){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble <?php if(ANDROID_APP == false){echo 'building';} ?>" <?php if(ANDROID_APP == true){echo 'ng-click="download(\'AppForAndroid\')"';} ?>>
                                            <div class="background">
                                                <i class="fa fa-android"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-android"> For Android</i><br>
                                                <a>App for Android</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if(ENABLE_WINDOWS_PHONE_APP == true){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble <?php if(WINDOWS_APP == false){echo 'building';} ?>" <?php if(WINDOWS_APP == true){echo 'ng-click="download(\'AppForWindows\')';} ?>>
                                            <div class="background">
                                                <i class="fa fa-windows"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-windows"> For Windows Phone</i><br>
                                                <a>App for Windows Phone</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if(ENABLE_IOS_APP == true){ ?>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble  <?php if(IOS_APP == false){echo 'building';} ?>" <?php if(IOS_APP == true){echo 'ng-click="download(\'AppForMac\')';} ?>>
                                            <div class="background">
                                                <i class="fa fa-apple"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-apple"> For iOS</i><br>
                                                <a>App for iOS</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.building').popover({
        trigger : 'click',
        placement : 'bottom',
        title : function(){
            var t = $(this).attr("id");
            return 'Client Download';
        },
        content : 'Product is not publicly available. If you need this, please contact your relationship manager.'
    });
</script>