<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
    <div class="container">
        <div class="row">
            <div class="col-lg-12" style="margin-bottom:20px;">
<!--                <ol class="breadcrumb">
                    <li><h3><?=Language::show('sync_dashboard', 'keywords')?></h3></li>
                </ol>-->
<h3><?=Language::show('sync_dashboard', 'keywords')?><span style="float:right;font-size: 12px;"><?php if ($data['time']) {?>Last Login Time : <?php echo $data['time']; } ?></span></h3>
            </div>
            <div class="col-lg-6 hide">
                <?php View::renderTemplate('partials/createButton', $data)?>
            </div>
        </div>
    </div>
    <div class="main">
        <div class="row profile">
            <div class="col-lg-1 col-md-1 col-sm-1">
                <?php View::renderTemplate('partials/sideBar', $data); ?>
            </div>
            <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
                <?php
                $percent = $data['cloudDetails']->{'space-used'}/$data['cloudDetails']->{'license'}->{'max-storage'};
                $percent_friendly = number_format( $percent * 100, 2 );
                if($percent_friendly > 25 && $percent_friendly <= 50) {
                    $color = '#10cfbd';
                    $class = 'success';
                }elseif($percent_friendly > 50 && $percent_friendly <= 75) {
                    $color = '#f8d053';
                    $class = 'warning';
                }elseif($percent_friendly > 75 && $percent_friendly <= 100) {
                    $color = '#6d5cae';
                    $class = 'danger';
                }else{
                    $color = '#2095f2';
                    $class = 'primary';
                }
                ?>
                <div class="row">
                    <!-- start -->
                        <div class="<?php if(BLUDRIVE_MODE == true){echo 'col-lg-12';} else { echo 'col-lg-6';}?>" block-ui="myBlockUI" onclick="redirect('users')" style="cursor:pointer;">
                            <div class="panel panel-default no-box-shadow widget-success">
                                <div class="background">
                                    <i class="fa fa-users"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Active Users</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-users"></i>
                                    <a class="pull-right" style="font-size: 40px;"><span ng-cloak><?=$data['cloudDetails']->{'users-connected'}?></span><span style="font-size: 20px;"> active out of </span><span style="font-size: 40px;"><?=$data['cloudDetails']->{'license'}->{'max-users'}?>
                                                </span></a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 hide" block-ui="myBlockUI">
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-desktop"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Active Devices</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-desktop"></i>
                                    <a class="pull-right" style="font-size: 40px;margin-top: -20px;"><?=$data['cloudDetails']->{'devices-connected'}?></a>
                                </div>
                            </div>
                        </div>
                    <div class="col-lg-6 <?php if(BLUDRIVE_MODE == true){echo 'hide';}?>" block-ui="myBlockUI" onclick="redirect('miniClouds')" style="cursor:pointer;">
                        <div class="panel panel-default no-box-shadow widget-danger">
                            <div class="background">
                                <i class="fa fa-cloud"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>MiniClouds</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-cloud"></i>
                                <a class="pull-right"><span ng-cloak style="font-size: 40px;"><?=$data['cloudDetails']->{'myclouds-connected'}?></span><span style="font-size: 20px;"> used out of </span><span style="font-size: 40px;"><?=$data['cloudDetails']->{'license'}->{'max-mc'}?>
                                            </span></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">            
                    <!-- end -->
                    <div class="col-lg-6" block-ui="myBlockUI" onclick="redirect('syncCLoudUsage')" style="cursor:pointer;">
                        <div class="panel panel-default no-box-shadow widget-warning">
                            <div class="background">
                                <i class="fa fa-hdd-o"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Storage Details</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-hdd-o"></i>
                                <a class="pull-right" style="font-size: 40px;"><span ng-cloak><?=$data['cloudDetails']->{'space-used'}?> <?=$data['unit']?></span></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6" block-ui="myBlockUI">
                        <div class="panel panel-default no-box-shadow widget-purple">
                            <div class="background">
                                <i class="fa fa-clock-o"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Parablu Installation valid Until</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-clock-o"></i>
                                <a class="pull-right" style="font-size: 40px;margin-top: -20px;"><?=date('d-M-Y', (((int)$data['cloudDetails']->{'license'}->{'valid-until'}) / 1000))?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6 hide">
                        <div class="panel">
                            <div class="panel-heading">
                                <h5 style="padding: 0px 0px 0px 15px;"><?=$data['crumb1']?>, (Parablu Installation Name: <?=$data['cloudDetails']->{'cloud-name'}?>)</h5>
                            </div>
                            <div class="panel-body">
                                <div class="row" style="padding-right: 15px; padding-left: 15px;">
                                    <table class="table table-bordered text-center hide">
                                        <tbody>
                                        <tr>
                                            <td></td>
                                            <td><b>Allowed</b></td>
                                            <td><b>Consumed</b></td>
                                            <td><b>Remaining</b></td>
                                        </tr>
                                        <tr>
                                            <td>Storage Details</td>
                                            <td><?=$data['cloudDetails']->{'license'}->{'max-storage'}?> GB</td>
                                            <td><?=$data['cloudDetails']->{'space-used'}?> GB</td>
                                            <td><?=($data['cloudDetails']->{'license'}->{'max-storage'}-$data['cloudDetails']->{'space-used'})?> GB</td>
                                        </tr>
                                        <tr>
                                            <td>MiniClouds</td>
                                            <td><?=$data['cloudDetails']->{'license'}->{'max-mc'}?></td>
                                            <td><?=$data['cloudDetails']->{'myclouds-connected'}?></td>
                                            <td><?=($data['cloudDetails']->{'license'}->{'max-mc'}-$data['cloudDetails']->{'myclouds-connected'})?></td>
                                        </tr>
                                        <tr>
                                            <td>Users</td>
                                            <td><?=$data['cloudDetails']->{'license'}->{'max-users'}?></td>
                                            <td><?=$data['cloudDetails']->{'users-connected'}?></td>
                                            <td><?=($data['cloudDetails']->{'license'}->{'max-users'}-$data['cloudDetails']->{'users-connected'})?></td>
                                        </tr>
                                        <?php if($data['cloudDetails']->{'license'}->{'backup-enabled'} == true){ ?>
                                            <!--<tr>
                                                <td>Backup Users</td>
                                                <td><?=$data['cloudDetails']->{'license'}->{'max-backup-users'}?></td>
                                                <td><?=$data['cloudDetails']->{'backup-users-connected'}?></td>
                                                <td><?=($data['cloudDetails']->{'license'}->{'max-backup-users'}-$data['cloudDetails']->{'backup-users-connected'})?></td>
                                            </tr>-->
                                        <?php } ?>
                                        <?php if($data['cloudDetails']->{'license'}->{'sync-enabled'} == true){ ?>
                                            <tr>
                                                <td>Sync Users</td>
                                                <td><?=$data['cloudDetails']->{'license'}->{'max-sync-users'}?></td>
                                                <td><?=$data['cloudDetails']->{'sync-users-connected'}?></td>
                                                <td><?=($data['cloudDetails']->{'license'}->{'max-sync-users'}-$data['cloudDetails']->{'sync-users-connected'})?></td>
                                            </tr>
                                        <?php } ?>
                                        </tbody>
                                    </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h3 class="panel-title"> Reports </h3>
                                </div>
                                <hr/>
                                <div class="panel-body">
                                    <p><a href="<?=Url::basePath('report/syncCLoudUsage')?>"> Sync Overview Summary</a></p>
                                    <!--<p><a href="<?=Url::basePath('report/download/syncOverviewReport')?>"> Sync User Activity History in Excel format</a></p>-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
function redirect(type){
switch (type) {
    case 'users':
        window.location.href = "<?=Url::basePath('users')?>";
        break;
    case 'miniClouds':
        window.location.href = "<?=Url::basePath('miniClouds')?>";
        break;
    case 'syncCLoudUsage':
        window.location.href = "<?=Url::basePath('report/syncCLoudUsage')?>";
        break;
        }
}
</script>
