<?php
use Core\Language;
use Helpers\Assets;
use Helpers\Url;
use Helpers\Form; ?>
<?php
    $dCloudName = htmlentities($_GET['c']);
    $cloudName = !empty($dCloudName) ? $dCloudName : CLOUD_NAME;
?>
<div class="container">
    <div class="row">

    </div>
    <br/>
    <div class="row">
        <div class="col-lg-6 col-lg-offset-3">
            <div class="panel panel-default no-box-shadow">
                <div class="panel-heading" style="padding: 30px 30px 10px 30px;">
                    <a><b class="h3"><?=$data['title'];?></b> - <?=$data['indexPage_message']?></a>
                </div>
                <div class="panel-body">
                    <div class="error" style="display: none; color: #f55753; margin-bottom: 10px;"></div>
                    <?=
                        Form::open(array(
                            'action' => Url::basePath('login'),
                            'method' => 'post',
                            'class' => 'login-form',
                            'csrf' => $data['csrf_token'],
                            'data-parsley-validate' => true
                        ));
                    ?>
                        <input type="text" hidden="hidden" name="cloudName" id="cloudName" placeholder="Enter your cloud name" value="<?=$cloudName?>" required>
                        <div align="center">
                            <img class="profileImg" src="<?=Url::profilePic($data['userName'])?>" title="web">
                        </div>
                        <div align="center">
                            <h4><?=$data['userName']?></h4>
                        </div>
                        <div class="form-group hide">
                            <label for="username"><?=Language::show('username', 'keywords');?></label>
                            <input type="text" class="form-control" name="username" id="username" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('username', 'keywords');?>" required readonly value="<?=$data['userName'];?>">
                        </div>
                        <div class="form-group">
                            <label for="password"><?=Language::show('password', 'keywords');?></label>
                            <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="new-password">
                        </div>
                        <a class="btn btn-danger pull-right" style="margin-left: 20px;" href="<?=Url::basePath('logout')?>"><?=Language::show('logout', 'keywords');?></a>
                        <button type="submit" class="login btn btn-success pull-right"><?=Language::show('unlock', 'keywords');?></button>
                    <?=
                        Form::close();
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
