<?php

use \Core\View;
use \Helpers\Url;

 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <!--<li><?=$data['subPageName']?></li>-->
		<li>Server Statistics</li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='serverBackup'?></span>
            <div class="row dashboard">
                <div class="col-lg-6" block-ui="myBlockUI">
                    <div ng-click="redirectTo('<?=Url::basePath('servers')?>')" class="clickAble panel panel-default no-box-shadow widget-purple">
                        <div class="background">
                            <i class="fa fa-server"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Active Servers</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-server"></i>
                            <a class="pull-right hide"><span ng-cloak>{{ statistics.devicesConnected }}</span></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-warning">
                        <div class="background">
                            <i class="fa fa-hdd-o"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Total size of Data Backed up</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-hdd-o"></i>
                            <a class="pull-right hide" ng-cloak>{{ statistics.totalStorageUtilized }}</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-primary">
                        <div class="background">
                            <i class="fa fa-database"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Completed Backups</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-database"></i>
                            <a class="pull-right hide"><span ng-cloak>{{ statistics.backupsDone }}</span></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-primary">
                        <div class="background">
                            <i class="fa fa-recycle"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Completed Restores</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-recycle"></i>
                            <a class="pull-right hide"><span ng-cloak>{{ statistics.restoresDone }}</span></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="panel panel-default no-box-shadow">
                        <div class="panel-heading"><a>Server Related Details</a></div>
                        <div class="panel-body">
                            <div class="form-group">
                                <select class="searchDeviceName col-lg-12" id="deviceName" ng-model="search.deviceName" data-parsley-trigger="change" required></select>
                            </div>
                            <div class="row deviceDetails" style="display: none;">
                                <div class="col-lg-12">
                                    <div class="panel panel-default no-box-shadow widget-purple">
                                        <div class="background">
                                            <i id="osIconBG" class="fa fa-linux"></i>
                                        </div>
                                        <div class="panel-heading widget-header">
                                            <a class="ng-binding selectedDeviceName">Prashanth-PC</a>
                                        </div>
                                        <div class="panel-body widget widget-body">
                                            <i id="osIcon" class="fa fa-linux"></i>
                                            <a style="font-size: 35px;margin-top: -10px;" class="storageUsedByUser pull-right">13.23 TB</a>
                                            <div class="row expandDetails0" style="font-size: 14px; color: rgb(255, 255, 255);">
                                                <div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
                                                    <p>Operating System: <b class="pull-right osType">Ubuntu 12.02</b></p>
                                                    <p>End Point Agent Version: <b class="pull-right endPointVersion">1.1512.4</b></p>
                                                </div>
                                                <div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
                                                    <p>Storage Media: <b class="pull-right storageMedia">Azure Blob</b></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--<div class="col-lg-6">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title"> Reports </h3>
                    </div>
                    <hr/>
                    <div class="panel-body">
                        <p><a href="<?=Url::basePath('report/overview')?>"> User overview </a></p>
                        <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                            <p><a href="<?=Url::basePath('report/userBackupHistory')?>"> Backup history </a></p>
                        <?php } ?>
                        <p><a href="<?=Url::basePath('report/failedBackup')?>"> Failed Backup by date range</a></p>
                        <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                            <p><a href="<?=Url::basePath('report/noBackup')?>"> Systems without backups (7 Days)</a></p>
                        <?php }else{ ?>
                            <p><a href="<?=Url::basePath('report/noBackup')?>"> Servers without backups (7 Days)</a></p>
                        <?php } ?>
                        <p><a href="<?=Url::basePath('report/restoreByDate')?>"> Restore History</a></p>
                        <p><a href="<?=Url::basePath('report/dailyUserBackupOverview')?>"> Daily User Backup Overview</a></p>
                    </div>
                </div>
            </div>-->
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<!--<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>-->
<script src="<?=Url::templatePath()?>js/angular/controllers/HistoryController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>

<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"device/searchDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o, key) {
                        return { id: o.deviceUUID, text: o.deviceName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select Server'
    }).on("change", function (e) {
        var deviceUUID = $(".searchDeviceName").val();
        updateDeviceDetails(deviceUUID);
    });

    function updateDeviceDetails(deviceUUID){
        $.ajax({
            url: '<?=DIR?>'+'user/device/deviceDetails',
            data: {deviceUUID: deviceUUID, csrf_token: $('[name="csrf_token"]').val()},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            console.log(jData);
            if(jData.result == 'success'){
                $('.deviceDetails').show();
                $('#osIcon').removeClass();
                $('#osIcon').addClass('fa fa-'+jData.deviceDetails.icon);
                $('#osIconBG').removeClass();
                $('#osIconBG').addClass('fa fa-'+jData.deviceDetails.icon);
                $('.storageUsedByUser').text(jData.deviceDetails.storageUsedByDevice);
                $('.selectedDeviceName').text(jData.deviceDetails.deviceName);
                $('.lastSuccessfulBackup').text(jData.deviceDetails.lastSuccessBackup);
                $('.nextScheduledBackup').text(jData.deviceDetails.nextScheduledBackup);
                $('.policyRefreshFrequency').text(jData.deviceDetails.nextPolicyRefresh);
                $('.osType').text(jData.deviceDetails.osType);
                $('.endPointVersion').text(jData.deviceDetails.productVersion);
                if(jData.deviceDetails.storageMedia == null){
                    $('.storageMedia').text('Local Storage');
                }else{
                    $('.storageMedia').text(jData.deviceDetails.storageMedia);
                }
            }else{
                $('.deviceDetails').hide()
            }
        });
    }

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>
