<?php

use Core\Language;
use \Core\View;
use \Helpers\Url;

 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-12" style="margin-bottom:20px;"> 
<!--            <ol class="breadcrumb">
                <li><h3><?=Language::show('backup_dashboard', 'keywords')?></h3></li>
            </ol>-->
<h3><?=Language::show('backup_dashboard', 'keywords')?><span style="float:right;font-size: 12px;"><?php if ($data['time']) {?>Last Login Time : <?php echo $data['time']; } ?></span></h3>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <?php if($data['isAdmin'] == 'true') { ?>
            <div class="row dashboard">   
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('users')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-success">
                            <div class="background">
                                <i class="fa fa-users"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Active Users</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-users"></i>
                                <a class="pull-right hide" style="font-size: 20px;margin-top: -20px;"><span ng-cloak>{{ statistics.activeBackupUsers }}</span><span style="font-size: 20px;"> out of </span><span style="font-size: 23px;">{{ statistics.noOfBackupUsersAllowed }}</span></a>
                            </div>
                        </div>
                    </div>    
                    <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('devices')" style="cursor:pointer;" <?php } ?>>
                        <div class="panel panel-default no-box-shadow widget-purple">
                            <div class="background">
                                <i class="fa fa-desktop"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Active Devices</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-desktop"></i>
                                <a class="pull-right hide" style="font-size: 30px;margin-top: -20px;"><span ng-cloak>{{ statistics.devicesConnected }}</span></a>
                            </div>
                        </div>
                    </div>
                <div class="col-lg-3" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-danger">
                        <div class="background">
                            <i class="fa fa-refresh"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Average restores per user</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-refresh"></i>
                            <a class="pull-right hide" style="font-size: 30px;margin-top: -20px;"><span ng-cloak>{{ statistics.avgRestorePerUser }}</span></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?>  ondblclick="redirect('userBackupHistory')" style="cursor:pointer;" <?php } ?>>
                    <div class="card">
                        <div class="cardFace front" onclick="flip()" >
                            <div class="panel panel-default no-box-shadow widget-primary">
                                <div class="background">
                                    <i class="fa fa-database"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>Total Completed Backups</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                        <i class="fa fa-database"></i>
                                        <a class="pull-right hide" style="font-size: 30px;margin-top: -20px;"><span ng-cloak>{{ statistics.backupsDone }}</span></a>
                                </div>
                            </div>
                        </div>
                        <div class="cardFace back" onclick="flipback()" >
                            <div class="panel panel-default no-box-shadow widget-success">
                                <div class="background">
                                    <i class="fa fa-database"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <a>First Time Full Backups Completed</a>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-database"></i>
                                    <a class="pull-right hide" style="font-size: 30px;margin-top: -20px;"><span ng-cloak>{{ statistics.fullBackupsDone }}</span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('dailyUserBackupOverview')" style="cursor:pointer;" <?php } ?>>
                    <div class="panel panel-default no-box-shadow widget-warning">
                        <div class="background">
                            <i class="fa fa-hdd-o"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Total size of Data Backed up</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-hdd-o"></i>
                            <a class="pull-right hide" style="font-size: 30px;margin-top: -20px;"><span id="totalStorageUtilized" ng-cloak>{{ statistics.totalStorageUtilized }}</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3" block-ui="myBlockUI" <?php if($data['isAdmin'] == 'true') { ?> onclick="redirect('restoreByDate')" style="cursor:pointer;" <?php } ?>>
                    <div class="panel panel-default no-box-shadow widget-primary">
                        <div class="background">
                            <i class="fa fa-recycle"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Completed Restores</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-recycle"></i>
                            <a class="pull-right hide" style="font-size: 30px;margin-top: -20px;"><span ng-cloak>{{ statistics.restoresDone }}</span></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-success">
                        <div class="background">
                            <i class="fa fa-inbox"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Average Storage Utilized per user</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-inbox"></i>
                            <a class="pull-right hide" style="font-size: 30px;margin-top: -20px;"><span id="storage" ng-cloak>{{ statistics.avgStoragePerUser }}</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3" block-ui="myBlockUI">
                        <div class="panel panel-default no-box-shadow widget-purple">
                            <div class="background">
                                <i class="fa fa-clock-o"></i>
                            </div>
                            <div class="panel-heading widget-header">
                                <a>Parablu Installation valid Until</a>
                            </div>
                            <div class="panel-body widget widget-body">
                                <i class="fa fa-clock-o"></i>
                                <a class="pull-right" style="font-size: 23px;margin-top: -20px;"><span ng-cloak>{{ statistics.cloudValidityUntil }}</a>
                            </div>
                        </div>
                </div>           
            </div>
            <div class="row">
                <div class="col-lg-8">
                <div class="panel-group">
                    <div class="panel panel-default">
                      <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="acc" style="color:black; text-decoration: none;" data-toggle="collapse" data-target="#collapse1">
                                <h3 class="panel-title">Currently Running Backups 
                                    <span style="float:right;cursor: pointer;">
                                        <i ng-click="updateCurrentBackup(0)" class="aa glyphicon glyphicon-menu-down"></i>
                                        <i class="bb hide glyphicon glyphicon-remove"></i>
                                    </span>
                                </h3>
                            </a>
                        </h4>
                
                      </div>
                      <hr/>
                      <p class="currentBackupText" style="margin-left: 10px;">Expand to view currently running backups</p>
                      <div id="collapse1" class="panel-collapse collapse">
                        <table id="CurrentBackup" class="table table-bordered currentBackup" style="display: none;">
                                <thead>
                                <tr>
                                  <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('deviceName', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                 <th class="text-center clickAble" ng-click="currentBackupSortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="currentBackupSortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="currentBackupSortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center"><?=Language::show('progress', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentBackup | orderBy:currentBackupSortType:sortReverse" class="text-center">
                                    <td ng-cloak>{{ value.userName }}</td>
                                    <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
<td ng-cloak>{{ value.startTime }}</td>
                                    <td>
                                        <div class="progress">
 						<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="content:calc(({{value.noOfFiles}}% / {{value.totalFiles}})*100);width:calc(({{value.noOfFiles}}% / {{value.totalFiles}})*100);">{{value.uploadPercent | number:0}}%</div>
                                        </div>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
				<div class="h4 currentBackupError text-center" style="display: none">No details found for Current Backup</div>
        <div class="panel-footer"></div>
      </div>
    </div>
  </div>
                </div>
                <div class="col-lg-4">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title"> Reports </h3>
                        </div>
                        <hr/>
                        <div class="panel-body">
                            <p><a href="<?=Url::basePath('report/overview')?>"> Backup Overview </a></p>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/userBackupHistory')?>"> Backup History </a></p>
                            <?php } ?>
                            <p><a href="<?=Url::basePath('report/failedBackup')?>"> Failed Backup History</a></p>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/noBackup')?>"> Systems without backups</a></p>
                            <?php }else{ ?>
                                <p><a href="<?=Url::basePath('report/noBackup')?>"> Servers without backups</a></p>
                            <?php } ?>
                            <p><a href="<?=Url::basePath('report/restoreByDate')?>"> Restore History</a></p>
                            <p><a href="<?=Url::basePath('report/dailyUserBackupOverview')?>"> Storage Utilization Report</a></p>
                            <p><a href="<?=Url::basePath('report/lastAgentServerConnectionDetails')?>"> Last Agent Server Connection Details</a></p>
                        </div>
                    </div>
                </div>
            </div>
            <?php } else { ?>
            <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title"> Reports </h3>
                        </div>
                        <hr/>
                        <div class="panel-body">
                            <p><a href="<?=Url::basePath('report/overview')?>"> Backup Overview </a></p>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/userBackupHistory')?>"> Backup History </a></p>
                            <?php } ?>
                            <p><a href="<?=Url::basePath('report/failedBackup')?>"> Failed Backup History</a></p>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/noBackup')?>"> Systems without backups</a></p>
                            <?php }else{ ?>
                                <p><a href="<?=Url::basePath('report/noBackup')?>"> Servers without backups</a></p>
                            <?php } ?>
                            <p><a href="<?=Url::basePath('report/restoreByDate')?>"> Restore History</a></p>
                            <p><a href="<?=Url::basePath('report/dailyUserBackupOverview')?>"> Storage Utilization Report</a></p>
                            <p><a href="<?=Url::basePath('report/lastAgentServerConnectionDetails')?>"> Last Agent Server Connection Details</a></p>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/controllers/HistoryController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
$(".acc").click(function(){
    $(".aa").toggleClass("hide");
$(".bb").toggleClass("show");
$('.currentBackupText').toggleClass('hide');
});

function redirect(type){
switch (type) {
    case 'users':
        window.location.href = "<?=Url::basePath('users')?>";
        break;
    case 'devices':
        window.location.href = "<?=Url::basePath('devices')?>";
        break;
    case 'userBackupHistory':
        window.location.href = "<?=Url::basePath('report/userBackupHistory')?>";
        break;
    case 'dailyUserBackupOverview':
        window.location.href = "<?=Url::basePath('report/dailyUserBackupOverview')?>";
        break;
    case 'restoreByDate':
        window.location.href = "<?=Url::basePath('report/restoreByDate')?>";
        break;
}

}
</script>
<style>

.cardWrapper{
/*  width:200px;*/
  height:135px;
  position:relative;
  /*background-color:#333;*/
  float:left;
/*  margin-right:10px;*/
  cursor:pointer;
  -webkit-font-smoothing:antialiased;
}

.cardFace{
  position:absolute;
/*  width:200px;
  height:200px;*/
width:100%;
  overflow:hidden;
}
/*
.front{
  background-color:#10cfbd; 
}

.back{
  background-color:#10cfbd; 
}*/


/*
.cardFace h1{
  margin:0px;
  font-size:30px;
  padding:10px 0px 10px 10px;
  border-bottom:solid 6px #aaa;
  border-top:solid 6px #aaa;
  background-color:black;
  color:white;
}


.cardFace.back h1{
 border-color:#91e600;
}
*/
.moreInfo{
  padding:10px;
  color:white;
  line-height:24px;
  
}
</style>

<script type="text/javascript">
    //IE doesn't transform-style:preserve-3d.
// for IE try https://codepen.io/rhernando/pen/vjGxH


//using TweenLite.set() takes care of all vendor-prefixes
TweenLite.set(".cardWrapper", {perspective:800});
TweenLite.set(".card", {transformStyle:"preserve-3d"});
TweenLite.set(".back", {rotationY:-180});
TweenLite.set([".back", ".front"], {backfaceVisibility:"hidden"});

$(".cardWrapper").hover(
  function() {
    TweenLite.to($(this).find(".card"), 1.2, {rotationY:180, ease:Back.easeOut});
  },
  function() {
    TweenLite.to($(this).find(".card"), 1.2, {rotationY:0, ease:Back.easeOut});  
  }
);

//a nice little intro;)
TweenMax.staggerTo($(".card"), 1, {rotationY:-180, repeat:1, yoyo:true}, 0.1);

/* learn more about GSAP JS:
https://www.greensock.com/gsap-js/

more codepen samples:
https://codepen.io/collection/jmHAn

basics:
https://codepen.io/collection/ifybJ

*/

function flip() {
    $('.front').addClass('hide');
    $('.back').removeClass('hide');
    $(".back").css("transform","");
    $(".back").css("backface-visibility","");
}

function flipback() {
    $('.back').addClass('hide');
    $('.front').removeClass('hide');
    $(".front").css("transform","");
    $(".front").css("backface-visibility","");
}
</script>