<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="DeviceController">
    <span class="hide currentPage"><?='devices'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
<div class="col-lg-11 col-md-11 col-sm-11 ng-cloak" >
            
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10 ng-cloak" >
            <div class="panel nodevice1" ng-if="devices.length ==0">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('list_of_devices', 'keywords');?>
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <h2 align="center"><?=Language::show('noDevices', 'keywords');?></h2>
                        </div>
                    </div>
                </div>
            </div>
			<div class="panel" ng-if="devices.length >0">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('list_of_devices', 'keywords');?>
                        <?php if(block == false){ ?>
                        <a class="btn btn-danger btn-small pull-right" disabled style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>"><i class="fa fa-minus-circle"></i> Block / <i class="fa fa-plus-circle"></i> Unblock /<i class="fa fa-trash"></i> Delete Devices in bulk</a>
						<?php } else {?>
						<a class="btn btn-danger btn-small pull-right" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>"><i class="fa fa-minus-circle"></i> Block / <i class="fa fa-plus-circle"></i> Unblock /<i class="fa fa-trash"></i> Delete Devices in bulk</a>
						<?php } ?>
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <form ng-submit="searchDevice(search.deviceName)">
                                <input name="deviceName"
                                       type="text"
                                       class="pull-right form-control"
                                       ng-model="search.deviceName"
                                       placeholder="Enter a 'Device Name' or 'all (for all devices)' and hit enter to search"
                                       data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                       data-content="Entered Device Name was not found!!! "
                                />
                            </form>
                        </div>
                    </div>
                    <br/>
                    <div class="table-responsive">
                        <div class="h4 loading text-center">Loading.....</div>
                        <div class="h4 nodevice text-center" style="display: none;">No device matched</div>
                        <table class="table table-bordered table-striped deviceListTable" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center"><?=Language::show('osType', 'keywords')?></th>
                                <th class="clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?=Language::show('deviceName', 'keywords')?>
                                    <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                               <th class="text-center"><?=Language::show('status', 'keywords')?></th>
                                <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in devices | orderBy:sortType:sortReverse">
                                <td class="text-center" ng-cloak><i class="fa fa-{{ value.icon }}"></i></td>
                                <td ng-cloak>{{ value.deviceName }}</td>
                                <td ng-cloak>{{ value.userName }}</td>
                                <td ng-cloak class="text-center">
                                    <h5><label class="label label-success" ng-if="value.blocked == 'false'"><?=Language::show('Active', 'keywords')?></label></h5>
                                    <h5><label class="label label-danger" ng-if="value.blocked == 'true'"><?=Language::show('De-Activated', 'keywords')?></label></h5>
                                </td>
                                <td>
                                    <a ng-click="properties(value.deviceUUID)" class="btn btn-small btn-default">Properties</a>
				                    <a ng-click="logAction(value.deviceUUID)" class="btn btn-small btn-default">Actions</a>
                                    <a ng-bootbox-confirm="<h4><?=Language::show('unBlockConfirmDevice', 'keywords')?></h4>"
                                       ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, false)"
                                       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-success" ng-if="value.blocked == 'true'"><i class="fa fa-plus-circle"></i> <?=Language::show('unblock', 'keywords');?></a>
                                    <a ng-bootbox-confirm="<h4><?=Language::show('deleteConfirmDevice', 'keywords')?></h4>"
                                       ng-bootbox-confirm-action="deleteDevice(value.deviceUUID)"
                                       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger" ng-if="value.blocked == 'true'"><i class="fa fa-minus-circle"></i> <?=Language::show('Delete', 'keywords');?></a>
                                    <a ng-bootbox-confirm="<h4><?=Language::show('blockConfirmDevice', 'keywords')?></h4>"
                                       ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, true)"
                                       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger" ng-if="value.blocked == 'false'"><i class="fa fa-minus-circle"></i> <?=Language::show('block', 'keywords');?></a>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <?php if(RESTORE_FROM_PORTAL){ ?>
                                            <a ng-click="initiateRestoreBackup(value.deviceUUID, value.deviceName, $index)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Restore Entire Device</a>
                                            <a ng-click="sendMeTo('<?=Url::basePath("backup/files/restore")?>/'+value.deviceId+'/'+value.deviceName+'/'+value.deviceUUID)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Restore Selected Files</a>
                                        <?php } ?>
                                    <?php } ?>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMoreDevices(skipValue)">Load More ...</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade restoreBucket">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Restore Bucket</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12">
                                        <label for="searchDeviceName">Select a Device to restore on:</label>
                                        <select class="searchDeviceName" style="width: 100%;" id="deviceName" ng-model="restoreBucket.deviceName" data-parsley-trigger="change"></select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="restoreAllVersions">Do you want to restore all versions</label>
                                        <select class="form-control selectPicker" name="restoreAllVersions" id="restoreAllVersions" required="">
                                            <option value="true"><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="destinationPath">Enter a Destination Path(optional)</label>
                                        <input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPath" id="destinationPath" placeholder="Enter Destination Path" />
                                        <span class="help-block">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="sendFilesForRestore(restoreBucket.deviceName, restoreBucket.destinationPath)"  class="btn btn-default">Initiate Restore</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade deviceDetails">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Device Details</h4>
                </div>
                <div class="modal-body">
                    <p><b>Created At</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.createdTimeStamp }}</span></p>
                    <p><b>Name</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.deviceName }}</span></p>
                    <p><b>Os Type</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.osType }}</span></p>
                    <p ng-if="selectedDevice.decoupled == 'true'" ng-cloak><b>Has Device De-Coupled</b>: <span class="pull-right">Yes</span></p>
                    <p ng-if="selectedDevice.decoupled == 'false'" ng-cloak><b>Has Device De-Coupled</b>: <span class="pull-right">No</span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade deviceLogs">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Device Logs</h4>
                </div>
                <div class="modal-body">
					<?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'eventHubForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'saveEventHub()',
                        'data-parsley-validate' => true
                    ));
                    ?>
					
					<span class="hide" id="actionToUserName"></span>
					<span class="hide" id="actionToDeviceUUID"></span>
					<div class="col-lg-12 hide" style="margin-bottom: 10px;">
						<div class="col-lg-6">
							<p><b>Start Backup</b>:</p>
						</div>
						<div class="col-lg-6">
							<input id="startBackup" name="startBackup" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
						</div>
					</div></br>
					<div class="col-lg-12 hide" style="margin-bottom: 10px;">
						<div class="col-lg-6">
							<p><b>Stop Backup</b>:</p>
						</div>
						<div class="col-lg-6">
							<input id="stopBackup" name="stopBackup" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
						</div>
					</div>
					<div class="col-lg-12 hide" style="margin-bottom: 10px;">
						<div class="col-lg-6">
							<p><b>Backup Policy Refresh</b>:</p>
						</div>
						<div class="col-lg-6">
							<input id="backupPolicyRefresh" name="backupPolicyRefresh" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
						</div>
					</div></br>
					<div class="col-lg-12" style="margin-bottom: 10px;">
						<div class="col-lg-6">
							<p><b>Pull Agent Logs</b>:</p>
						</div>
						<div class="col-lg-6">
							<input id="agentLogs" name="agentLogs" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
						</div>
					</div>
					<p>Note: Actions will be performed on next refresh.</p>
					<?= Form::close(); ?>
                </div>
                <div class="modal-footer">
					<!--<button type="submit" class="btn btn-primary">Save changes</button>-->
					<a class="btn btn-success" data-dismiss="modal" ng-click="saveEventHub()">Save</a>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/DeviceController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"backup/getAllUnblockedDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        if(o.deviceName != 'All'){
                            return { id: o.deviceName, text: o.deviceName, img: o.profilePic };
                        }else{
                            return { id: 'default', text: 'On to the same device', img: o.profilePic };
                        }
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'On to the same device'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>
