<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><a href="<?=Url::basePath('devices')?>"><?=$data['crumb1']?></a></li>
                <li><span><?=$data['crumb2']?></span></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="BackupController">
    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
        <?php if(RESTORE_FROM_PORTAL){ ?>
            <span class="hide restoreFromPortal">enable</span>
        <?php }else{ ?>
            <span class="hide restoreFromPortal">disable</span>
        <?php } ?>
    <?php }else{ ?>
        <span class="hide restoreFromPortal">disable</span>
    <?php } ?>
    <span class="hide deviceName"><?=$data['crumb2']?></span>
    <span class="hide redirectTo">devices</span>
    <span class="hide currentPage"><?='files'?></span>
    <span class="hide ngTracker"><?='backup'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 filePanel">
            <div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body">
                    <ul class="nav navbar-nav nav-breadcrumb" id="breadCrumb">
                        <li><a href="javascript:;" ng-click="updateFileList('root','root')"><i class="fa fa-home"></i> root</a></li>
                        <li ng-repeat="value in crumb track by $index"><a href="javascript:;" ng-click="updateFileListFromBreadCrumb(value, $index)" class="toolTip" data-toggle="tooltip" data-placement="top" data-original-title="{{ value }}">{{ value }}</a></li>
                    </ul>
                    <ul class="nav navbar-nav pull-right nav-actions">
                        <li><a ng-click="deleteConfirmation()" class="toolTip deleteBtn" data-toggle="tooltip" data-placement="top" title="Delete" href="javascript:;"><i class="fa fa-trash"></i></a></li></li>
                        <li><a ng-click="getVersions()" class="toolTip versionsBtn" style="display: none" data-toggle="tooltip" data-placement="top" title="Versions" href="javascript:;"><i class="fa fa-clock-o"></i></a></li>
                        <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                            <?php if(RESTORE_FROM_PORTAL){ ?>
                                <li><a ng-click="initiateRestoreBackupforFiles('')" class="toolTip initiateRestoreBtn" ng-if="selectedFileForRestoreList.length > 0 || selectedFilesForRestoreFromVersions.length > 0" data-toggle="tooltip" data-placement="top" title="Initiate Restore" href="javascript:;"><i class="fa fa-recycle"></i></a></li>
                            <?php } ?>
                        <?php } ?>
                    </ul>
                </div>
            </div>
            <div class="panel panel-default files-panel no-box-shadow backupFilesTable" style="display:none">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <colgroup>
                            <col class="col-xs-5">
                            <col class="col-xs-2">
                            <col class="col-xs-3">
                            <col class="col-xs-2">
                        </colgroup>
                        <thead>
                        <tr>
                            <th class="clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Name
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'type'; sortReverse = !sortReverse">
                                Type
                                <span ng-show="sortType == 'type' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'type' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'serverModifiedTime'; sortReverse = !sortReverse">
                                Last modified
                                <span ng-show="sortType == 'serverModifiedTime' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'serverModifiedTime' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'rawSize'; sortReverse = !sortReverse">
                                Size
                                <span ng-show="sortType == 'rawSize' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'rawSize' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody id="selectable"
                               selectable="tr"
                               selectable-list="items"
                               selectable-out="selected"
                               selectable-options="{filter:'tr', cancel: 'a.folder,.cancel'}"
                               selectable-events="{start:'selectionStart($selected)', stop:'selectionStop($selected)'}"
                               block-ui="myBlockUI"
                               context-menu="menuOptions">
                        <tr ng-repeat="value in items | orderBy:sortType:sortReverse">
                            <td data-name="{{value.name}}" ng-if="value.type == 'Folder'"><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileList(crumbString+value.name, value.name, true)" style="cursor: pointer; color: #585f69;"><span ng-cloak ng-bind-html="value.name | charLimit"></span></a></td>
                            <td data-name="{{value.name}}" ng-if="value.type == 'File'"><i class="fa fa-{{ value.icon }} fa-1x"></i> <a style="cursor: pointer; color: #585f69;"><span ng-bind-html="value.name | charLimit"></span></a></td>
                            <td> {{ value.type }} </td>
                            <td> {{ value.serverModifiedTime }} </td>
                            <td ng-if="value.type == 'Folder'"> - </td>
                            <td ng-if="value.type == 'File'">
                                {{ value.size }}
                                <span ng-if="value.storagePlace == 'PG'" class="text-warning"> <span class="text-warning"><i class="fa fa-warning"></i></span></span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <div class="panel-footer" ng-if="items.length > 0">
                    <p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-warning"></i></span> means that the particular file has not yet been moved to Cloud.</p>
                </div>
            </div>
            <div class="modal fade whiteAndBigModal backupFileVersions">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">
                                File Versions list - File Name: <span>{{ selected[0].name }}</span>
                            </h4>
                        </div>
                        <div class="modal-body">
                            <div class="table-responsive" style="margin-top: -20px;">
                                <hr/>
                                <div class="h4 loading text-center">Loading.....</div>
                                <table class="table table-bordered table-striped deviceHistoryDetailsTable" style="display: none;">
                                    <thead>
                                    <tr>
                                        <th><?=Language::show('version', 'keywords')?></th>
                                        <th><?=Language::show('time', 'keywords')?></th>
                                        <th><?=Language::show('file_size', 'keywords')?></th>
                                        <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                            <?php if(RESTORE_FROM_PORTAL){ ?>
                                                <th><?=Language::show('action', 'keywords')?></th>
                                            <?php }?>
                                        <?php }?>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr ng-repeat="value in fileVersions track by $index">
                                        <td ng-if="value.status == 'ADDED'" ng-cloak>{{ value.version + (fileVersions.length-$index)}} <span ng-if="value.storagePlace.length <= 0 || value.storagePlace == undefined" class="text-warning"><i class="fa fa-warning"></i></span></td>
                                        <td ng-if="value.status == 'MODIFIED'" ng-cloak>{{ value.version + (fileVersions.length-$index)}} <span ng-if="value.storagePlace.length <= 0 || value.storagePlace == undefined" class="text-warning"><i class="fa fa-warning"></i></span></td>
                                        <td ng-if="value.status == 'DELETED'" ng-cloak><span style="text-decoration: line-through;">{{ value.version + (fileVersions.length-$index)}} <span ng-if="value.storagePlace.length <= 0 || value.storagePlace == undefined" class="text-warning"><i class="fa fa-warning"></i></span></span></td>
                                        <td ng-cloak>{{ value.serverModifiedTime }}</td>
                                        <td ng-cloak><span class="text-info">{{ value.size }}</span></td>
                                        <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                            <?php if(RESTORE_FROM_PORTAL){ ?>
                                                <td ng-cloak ng-if="value.status != 'DELETED'"><a class="btn btn-primary btn-small" ng-click="addToRestoreBackupFromRevisions($index, (fileVersions.length-$index))">Add to Restore</a></td>
                                                <td ng-cloak ng-if="value.status == 'DELETED'">-</td>
                                            <?php } ?>
                                        <?php } ?>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-warning"></i></span> means that the particular file has not yet been moved to Cloud.</p>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade whiteAndBigModal chunks">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Files Chunk Details</h4>
                        </div>
                        <div class="modal-body">
                            <hr/>
                            <div class="content" ng-if="chunks.length <= 0">
                                <h3 class="text-center">No Chunk files were found</h3>
                            </div>
                            <div class="content" ng-if="chunks.length >= 1">
                                <h4 class="modal-title">File Name: <span>{{ selected[0].name }}</span></h4>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <colgroup>
                                            <col class="col-xs-3">
                                            <col class="col-xs-4">
                                            <col class="col-xs-3">
                                        </colgroup>
                                        <thead>
                                        <tr>
                                            <th>Chunk Path On Storage</th>
                                            <th>Chunk Modified On</th>
                                            <th>Chunk Size</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr ng-repeat="value in chunks track by $index">
                                            <td ng-if="value.cloudStoragePath.length >= 1">{{ value.cloudStoragePath }}</td>
                                            <td ng-if="value.cloudStoragePath.length < 1">-</td>
                                            <td>{{ value.uploadedTimeStamp }}</td>
                                            <td>{{ value.size }}</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade whiteAndBigModal restoreBucket">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Restore Bucket</h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <form class="form-inline" ng-submit="sendFilesForRestore(restoreBucket.deviceName, restoreBucket.destinationPath)" data-parsley-validate>
                                        <div class="">
                                            <br/>
                                            <div class="form-group col-lg-12">
                                                <label for="searchDeviceName">Select a Device to restore on:</label>
                                                <select class="searchDeviceName" style="width: 100%;" id="deviceName" ng-model="restoreBucket.deviceName" data-parsley-trigger="change"></select>
                                            </div>
                                            <div class="form-group col-lg-12">
                                                <br/>
                                                <label for="destinationPath">Enter a Destination Path(optional)</label>
                                                <input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPath" id="destinationPath" placeholder="Enter Destination Path" />
                                                <span class="help-block">
                                                    Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backed up from and the backed up drive does not exists then the files will be downloaded to a downloads folder.
                                                    <br/>
                                                    Restore Operation could take many hours depending on the number of files. Please ensure that system doesn't get nto a hibernate mode. For Faster response, try restoring smaller set of files at a time.
                                                </span>
                                            </div>
                                            <button ng-if="selectedFileForRestoreList.length > 0 || selectedFilesForRestoreFromVersions.length > 0" type="submit" class="btn btn-default restoreBtnForFiles">Initiate Restore</button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <hr/>
                            <div class="content" ng-if="selectedFileForRestoreList.length <= 0 && selectedFilesForRestoreFromVersions.length <= 0 ">
                                <h3 class="text-center">No Files has yet been added to restore.</h3>
                            </div>
                            <div class="content" ng-if="selectedFileForRestoreList.length >= 1">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Type</th>
                                            <th>Last modified</th>
                                            <th>Size</th>
                                            <th>Restore Type</th>
                                            <th>Actions</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr ng-repeat="value in selectedFileForRestoreList track by $index">
                                            <td>{{ value.name }}</td>
                                            <td>{{ value.type }}</td>
                                            <td ng-if="value.serverModifiedTime.length > 0">{{ value.serverModifiedTime }}</td>
                                            <td ng-if="value.size.length > 0">{{ value.size }}</td>
                                            <td ng-if="value.size.length <= 0">-</td>
                                            <td ng-if="value.restoreAllVersions == true">All Versions</td>
                                            <td ng-if="value.restoreAllVersions == false">Current Version</td>
                                            <td>
                                                <a ng-click="removeFromFileRestoreList($index)" class="btn btn-danger btn-small">Remove</a>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="content" ng-if="selectedFilesForRestoreFromVersions.length >= 1">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Type</th>
                                            <th>Last modified</th>
                                            <th>Size</th>
                                            <th>Actions</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr ng-repeat="value in selectedFilesForRestoreFromVersions track by $index">
                                            <td>{{ value.name }}</td>
                                            <td>File</td>
                                            <td ng-if="value.serverModifiedTime.length > 0">{{ value.serverModifiedTime }}</td>
                                            <td ng-if="value.size.length > 0">{{ value.size }}</td>
                                            <td ng-if="value.size.length <= 0">-</td>
                                            <td>
                                                <a ng-click="removeFromFileVersionsRestoreList($index)" class="btn btn-danger btn-small">Remove</a>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade deleteConfirmation">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Delete Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <p>
                                <span ng-if="selected.length == 1">Do you want to permanently delete the below selected file or a folder?</span>
                                <span ng-if="selected.length > 1">Do you want to permanently delete the below selected files and folders?</span>
                            </p>
                            <p>
                                <span ng-repeat="value in selected track by $index">
                                    <span ng-if="$index == (selected.length - 1)">{{ value.name }}</span>
                                    <span ng-if="$index < (selected.length - 1)">{{ value.name+', ' }}</span>
                                </span>
                            </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" ng-click="deleteFile()" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
            </div>
            <ul class="list-group contextMenu" style="display: none;">
                <li ng-click="deleteConfirmation()" class="list-group-item deleteBtn"><i class="fa fa-trash"></i> &nbsp;&nbsp;Delete</li>
                <li ng-click="getVersions()" class="list-group-item versionsBtn"><i class="fa fa-clock-o"></i> &nbsp;&nbsp;Versions</li>
            </ul>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/BackupController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"backup/getAllUnblockedDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        if(o.deviceName != 'All'){
                            return { id: o.deviceName, text: o.deviceName, img: o.profilePic };
                        }else{
                            return { id: 'default', text: 'On to the same device', img: o.profilePic };
                        }
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'On to the same device'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>