<?php
use \Helpers\Url;
use \Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* search.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 8/6/15
* @time 3:00 PM
* 
*/
?>
<?php
    $searchEnabled = 'none';
    if(Auth::checkCloudPermission('sync')){
        if(Auth::checkUserPermission('admin')){
            $searchEnabled = 'all';
        }else{
            $searchEnabled = 'files';
        }
    }else{
        if(Auth::checkUserPermission('admin')){
            $searchEnabled = 'usersDevices';
        }else{
            $searchEnabled = 'none';
        }
    }
?>

<div class="morphSearchText hide"><?=$searchEnabled;?></div>
<div class="searchEnabled hide"><?php
        if(!empty($_SESSION['search']) && $_SESSION['search'] == 'enabled'){
            echo 'enabled';
        }else{
            echo 'disabled';
        }
        $_SESSION['search'] = '';
    ?></div>
<?php if($searchEnabled != 'none'){ ?>
    <?php if(Auth::checkCloudPermission('serverBackup') == false){ ?>
    
    <div id="morphsearch" class="morphsearch desktop-only col-lg-6">
        <form class="morphsearch-form" ng-submit="searchThisText(search.text)">
            <?php if(enableheaderSearch == true){ ?>
        <?php if(Auth::checkCloudPermission('sync') == '1' || Auth::checkCloudPermission('backup') == '0' )  { ?>
            <div id="input_container col-lg-6" style="border:1px solid white;border-radius:10px;width:50%;"><span id="input_img" class="fa fa-search fa-x" style="color:white;"></span><input id="morphsearch-input" ng-modal="search.text" class="morphsearch-input" style="padding: 10px;margin-left: 14px;line-height: 25px;" type="search" placeholder="<?=SYNC_SEARCH_MESSAGE?>"/></div>
        <?php } else { ?>
            <div id="input_container col-lg-6" style="border:1px solid white;border-radius:10px;width:50%;"><span id="input_img" class="fa fa-search fa-x" style="color:white;"></span><input id="morphsearch-input" ng-modal="search.text" class="morphsearch-input" style="padding: 10px;margin-left: 14px;line-height: 25px;" type="search" placeholder="<?=BACKUP_SEARCH_MESSAGE?>"/></div>
        <?php } ?>
        <?php } elseif(enableheaderSearch == false) {?>
<div data-toggle="tooltip" data-placement="bottom" title="Search is Disabled in Lite Version" class="toolTip" id="input_container col-lg-6" style="border:1px solid #aa9184;;border-radius:10px;width:50%;" disabled="true"><span id="input_img" class="fa fa-search fa-x" style="color:#aa9184;"></span><input id="morphsearch-input" ng-modal="search.text" class="form-control" style="padding: 10px;margin-left: 14px;line-height: 25px; background: none;border: 0px; width: 96%;" type="search" placeholder="<?=SYNC_SEARCH_MESSAGE?>" disabled/></div>

<?php }?>
            <button class="morphsearch-submit" type="submit">Search</button>
        </form>
        
        <div class="morphsearch-content">
            <div class="dummy-column">
                <a class="status-text">Let me know what do you want me to search for?</a>
                <a class="h4 status-error" style="display: none;"></a>
                <div class="search-results row">
                    <div class="col-lg-12 col-md-6 col-sm-3">
                        <section class="dummy-media-object" style="cursor: auto; padding: 15px;" ng-repeat="value in foundFiles track by $index">
                            <a class="h4">{{ value.fileName }} <span class="h6">, File Path - {{ value.filePath }}</span></a>
                            <a ng-click="searchDownload(value.filePath, value.fileName, value.fileRevisionID)" class="btn btn-success btn-small pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Download"><i class="fa fa-download"></i> </a>
                            <a ng-click="searchOpenFolderOption(value.filePath, value.fileName)" class="btn btn-primary btn-small pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Open File Location"" style="margin-right: 10px"><i class="fa fa-folder-open"></i> </a>
                            <p><span ng-bind-html="getHtmlContent(value.content)"></span></p>
                        </section>
                    </div>
                    <div class="col-lg-6" ng-repeat="value in foundUsers track by $index">
                        <a class="dummy-media-object" href="<?=\Helpers\Url::basePath()?>myAccount/{{ value.userName }}">
                            <img class="round" src="<?=Url::basePath('app/templates/default/images/default_profile.jpg')?>" alt="{{ value.userName }}"/>
                            <h3>{{ value.userName }}</h3>
                        </a>
                    </div>
                    <div class="col-lg-6" ng-repeat="value in foundDevices track by $index">
                        <a class="dummy-media-object" href="<?=\Helpers\Url::basePath()?>myAccount/{{ value.userName }}">
                            <img class="round" src="<?=Url::basePath('app/templates/default/images/default_profile.jpg')?>" alt="{{ value.devicename }}"/>
                            <h3>
                                <i class="fa fa-desktop"></i> {{ value.deviceName }} of user "{{ value.userName }}"
                            </h3>
                        </a>
                    </div>
                </div>
            </div>
        </div><!-- /morphsearch-content -->
        
        <span class="morphsearch-close"></span>
    </div><!-- /morphsearch -->
    <?php } ?>
<?php } ?>
<style>
    #input_container {
    position:relative;
    padding:0 0 0 20px;
    margin:0 20px;
    border-radius: 10px !important;
    width: 50%;
    border: 1px solid white !important;
    
    }
    #input_img {
    position:absolute;
    left:9px;
    top:9px;
    }
    
#custom-search-input{
    
    border: solid 1px #E4E4E4;
    border-radius: 6px;
    background-color: #fff;
}

#custom-search-input input{
    border: 0;
    box-shadow: none;
}

#custom-search-input button{
    margin: 2px 0 0 0;
    background: none;
    box-shadow: none;
    border: 0;
    color: #666666;
    padding: 0 8px 0 10px;
    border-left: solid 1px #f27331;
}

#custom-search-input button:hover{
    border: 0;
    box-shadow: none;
    border-left: solid 1px #f27331;
}

#custom-search-input .glyphicon-search{
    font-size: 23px;
}

@-moz-document url-prefix() {
  #input_img {
     padding-top: 10px;
  }
  #morphsearch-input {
    margin-left: 25px;
  }
}
</style>
