/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('ShareWithController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'Upload', '$timeout', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER, Upload, $timeout) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();

    $scope.sortReverse = true;
    $scope.sortType = 'type';

    $scope.items = [];

    $scope.selected = [];

    $scope.updateFileList = function(filePath, currentPath, update, refreshed){
        if(filePath == $scope.crumbString){
            return false;
        }
        if(refreshed != true){
            refreshed = false;
        }
        filePath = filePath.replace(/\/$/, '');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $scope.selected = [];
        if(filePath == 'root'){
            $scope.crumb = [];
            $scope.crumbString = '';
            $scope.currentCrumb = '';
        }
        $('.status').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/share/filesSharedWithMe',
            type: 'POST',
            data: {csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            $('#selectable tr').removeClass('ui-selected');
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success') {
                disableButtons();
                $('.filePanel').show();
                $scope.items = jData.items;
                $scope.$apply();
                if($scope.items.length <= 0){
                    $('.status').show();
                }
            }else{
                toastr.error('There are no <b>Files</b> nor <b>Folders</b> inside, Redirecting you back', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.selectionStart = function(selected){
        $scope.selected = [];
    };

    $scope.selectionStop = function(selected){
        disableButtons();
        $scope.selected = selected;
        if(selected.length == 1){
            enableButtons();
        }
    };

    function disableButtons(){
        $('.viewAction').hide();
        $('.downloadAction').hide();
    }

    function enableButtons(){
        $('.viewAction').show();
        $('.downloadAction').show();
    }

    $scope.menuOptions = [
        ['View', function ($itemScope) {
            $scope.view();
        }, function(){
            if($scope.selected.length == 1){
                return true;
            }
        }],
        ['Download', function ($itemScope) {
            $scope.download();
        }, function(){
            if($scope.selected.length == 1){
                return true;
            }
        }],
        ['Nothing Selected', function () {

        }, function(){
            if($scope.selected.length < 1){
                return true;
            }
        }],
        ['Cannot Download Multiple Files', function () {

        }, function(){
            if($scope.selected.length > 1){
                return true;
            }
        }]
    ];

    $scope.download = function(){
        var data = {
            type : 'download',
            fileName : $scope.selected[0].fileName,
            filePath : $scope.selected[0].devicePath
        };
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/isShareCheck',
            type: 'POST',
            data: data
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == true){
                if($scope.selected[0].gatewayName.length > 0){
                    window.open($('.protocol').html()+$scope.selected[0].gatewayName+$('.blukryptURL').html()+$('.cloudNameConstant').html()+'/sync/portal/download/file/?fileName='+encodeURIComponent($scope.selected[0].fileName)+'&filePath='+$scope.selected[0].devicePath+'&token='+$('.uploadToken').html()+'&userName='+$scope.selected[0].userName+'&syncRevisionId='+$scope.selected[0].syncRevisionID+'&path='+encodeURIComponent($scope.crumbString)+encodeURIComponent($scope.selected[0].fileName), '_blank');
                }else{
                    window.open($('.protocol').html()+$('.blukryptIP').html()+$('.blukryptURL').html()+$('.cloudNameConstant').html()+'/sync/portal/download/file/?fileName='+encodeURIComponent($scope.selected[0].fileName)+'&filePath='+$scope.selected[0].devicePath+'&token='+$('.uploadToken').html()+'&userName='+$scope.selected[0].userName+'&syncRevisionId='+$scope.selected[0].syncRevisionID+'&path='+encodeURIComponent($scope.crumbString)+encodeURIComponent($scope.selected[0].fileName), '_blank');
                }
            }else{
                toastr.error('File has been un-shared or something went wrong while retrieving the file', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.view = function(){
        var data = {
            type : 'view',
            fileName : $scope.selected[0].fileName,
            filePath : $scope.selected[0].devicePath
        };
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/isShareCheck',
            type: 'POST',
            data: data
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == true){
                $('#paraviewContainer .modal-title').html('Loading ...');
                $('.content').html('');
                $('.content').hide();
                $('.pageContainer').hide();
                $('.excelContainer').hide();
                $('.pdfContainer').hide();
                $('.imageViewer').hide();
                $('.paraviewLoading').show();

                $('#paraviewContainer').modal('show');
                $.ajax({
                    url: $scope.BASE_FOLDER+'/share/view',
                    data: {path: $scope.selected[0].devicePath, fileName:$scope.selected[0].fileName, syncRevisionId: $scope.selected[0].syncRevisionID, userName:$scope.selected[0].userName, password:'shareWith'},
                    type: 'POST'
                }).done(function(data){
                    var jData = JSON.parse(data);

                    if(jData.result == 'fail'){
                        $('#paraviewContainer').modal('hide');
                        toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
                    } else{
                        if(jData.type == 'image') {

                            $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                            $('.imageViewer').html(jData.html);
                            $('.imageViewer').show();
                            $('.paraviewLoading').hide();

                        }else if(jData.type == 'pdf') {

                            $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                            $('.paraviewLoading').hide();
                            $('.pdfContainer').html(jData.html);
                            $('.pdfContainer').show();

                        }else if(jData.type == 'odt') {

                            $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                            $('.pageContainer').show();
                            $('.paraviewLoading').hide();
                            viewDoc(jData, 300, 100);

                        }else if(jData.type == 'text') {

                            $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                            $('.content').html(jData.html);
                            $('.paraviewLoading').hide();
                            $('.content').show();

                        }else if(jData.type == 'excel') {

                            $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                            $('.excelContainer').show();
                            $('.paraviewLoading').hide();
                            viewExcel(jData);

                        }else{

                            $('#paraviewContainer .modal-title').html($scope.selected[0].fileName);
                            $('.pageContainer').show();
                            $('.paraviewLoading').hide();
                            viewDoc(jData, 400, 100);

                        }
                    }

                }).error(function(data){
                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                    if(data.status == 424){
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/sleep';
                        }, 3000);
                    }else if(data.status == 503){
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                        }, 3000);
                    }
                });
            }else{
                toastr.error('File has been un-shared or something went wrong while retrieving the file', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $('#paraviewContainer').on('hidden.bs.modal', function () {
        $('.page').remove();
        $('.pageContent').remove();
        $('.pageContainer').html('');
    });

    function addAPage(jsonData, pageNumber){
        pageNumber = pageNumber+1;
        $('.pageContainer').append('<div id="page'+pageNumber+'" class="page"></div>');
        $('.page').css(jsonData.pageStyle);
        $('#page'+pageNumber).append('<div class="pageContent"><div class="pageNumber"> Page '+pageNumber+'<br/></div></div>');
        $('.pageContent').css(jsonData.contentStyle);
        return pageNumber;
    }
    function checkHeight(contentHeight, pageNumber) {
        var div = '#page'+pageNumber+' .pageContent';
        var element = document.querySelector(div);
        var _hasScrollBar = false;
        if( (parseInt($(div).outerHeight(true) ) < parseInt(contentHeight))){
            _hasScrollBar = true;
        }
        return _hasScrollBar;
    }

    function viewDoc(jsonData, defaultHeight, minusDefaultSize){
        var pageNumber = 0;
        var pageHeight = parseInt(jsonData.pageStyle.height.replace("px", ""));
        var contentBottom = parseInt(jsonData.contentStyle.bottom.replace("px", ""));
        jsonData.html.forEach(function(row){
            var contentHeight = pageHeight - (contentBottom+defaultHeight);
            if ($('.page').length <= 0 ) {
                pageNumber = addAPage(jsonData, pageNumber);
            }
            if(checkHeight(contentHeight, pageNumber) == false) {
                pageNumber = addAPage(jsonData, pageNumber);
                defaultHeight = defaultHeight - minusDefaultSize;
            }
            $('#page'+pageNumber+' .pageContent').append(row);
        })

    }

    function viewExcel(jsonData){
        var html = '';
        var links = '';
        var htmlData = '';
        jsonData.html.forEach(function(row, key){
            var active = '';
            if(key == 0){
                active = 'active';
            }
            links += '<li role="presentation" class="'+active+'"><a href="#'+row.id+'" id="home-tab" role="tab" data-toggle="tab" aria-controls="home" aria-expanded="true">'+row.sheetName+'</a></li>';
            htmlData += '<div role="tabpanel" class="tab-pane fade '+active+' in" id="'+row.id+'" aria-labelledby="home-tab">'+row.html+'</div>';
        });
        html += '<div class="panel" style="background-color: #fff; padding: 20px 20px; overflow: auto; height: 550px">'+
            '<div class="bs-example bs-example-tabs" role="tabpanel" data-example-id="togglable-tabs">'+
            '<ul id="myTab" class="nav nav-tabs" role="tablist">'+links+'</ul>'+
            '<div id="myTabContent" class="tab-content">'
            +htmlData+
            '</div>'+
            '</div>'+
            '</div>';
        $('.excelContainer').html(html);
    }

    $scope.changePasswordForGuest = function(){

        var passwordGuest = $('#passwordGuest').val();
        var rePasswordGuest = $('#rePasswordGuest').val();
        console.log("passwordGuest : "+passwordGuest)

        var html = $('#changePasswordBtnGuest').html();
        $('#changePasswordBtnGuest').attr('disabled','disabled');
        $('#changePasswordBtnGuest').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();

        if ( $('#changePasswordFormGuest').parsley().isValid() && passwordGuest == rePasswordGuest) {
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/changePasswordForGuest',
                data: $('#changePasswordFormGuest').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('#changePasswordForGuest').modal('hide');
                    $('#changePasswordBtnGuest').html('Saved <i class="fa fa-check"></i>').animate();
                    setTimeout(function(){
                        toastr.success('Password Successfully changed', 'Success!!!');
                        $('#changePasswordBtnGuest').html(html);
                        $('#changePasswordBtnGuest').removeAttr('disabled');
                    }, 1000);
                    $('#passwordGuest').val("");
                    $('#rePasswordGuest').val("");
                    // location.reload();
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/logout';
                    }, 3000);
                }else{
                    $('#changePasswordBtnGuest').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        toastr.error('old & new password cannot be same', 'Fail!!!');
                        $('#passwordGuest').val("");
                        $('#rePasswordGuest').val("");
                        $('#changePasswordBtnGuest').html(html);
                        $('#changePasswordBtnGuest').removeAttr('disabled');
                    }, 1000);
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'trash'){
            blockUI.start();
            $scope.updateFileList('root', 'root', true, true);
        }

    });

}]);
