/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('BackupController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER) {

    $scope.sortReverse = true;
    $scope.sortType = 'name';

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();
    $scope.selectedUser = $('.selectedUser').html();
    $scope.restoreFromPortal = $('.restoreFromPortal').html();
    $scope.devices = [];
    $scope.items = [];
    $scope.restoreBucket = {};
    $scope.listOFBlukrypts = [];
    $scope.bestBlukrypt = '';

    $scope.selected = [];
    $scope.crumb = [];
    $scope.fileVersions = [];
    $scope.chunks = [];
    $scope.crumbString = '';
    $scope.currentCrumb = '';
    $scope.selectedFileForRestoreList = [];
    $scope.selectedFilesForRestore = [];
    $scope.selectedFilesForRestoreFromVersions = [];
    $scope.currentSelectedDeviceName = '';

    $scope.updateFileList = function(filePath, currentPath, update, refreshed){

        if(filePath == $scope.crumbString){
            return false;
        }
        if(refreshed != true){
            refreshed = false;
        }
        filePath = filePath.replace(/\/$/, '');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $scope.selected = [];
        if(filePath == 'root'){
            $scope.crumb = [];
            $scope.crumbString = '';
            $scope.currentCrumb = '';
        }
        $('.status').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/backup/files',
            type: 'POST',
            data: {csrf_token: $('.csrf_token').html(), filePath: htmlspecialchars_decode(filePath), refresh: refreshed}
        }).done(function(data){
            $('#selectable tr').removeClass('ui-selected');
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success') {
                $('.versionsBtn').hide();
                $('.deleteBtn').hide();
                if (jData.items.length > 0) {
                    checkBreadCrumb();
                    $('.filePanel').show();
                    if (filePath != 'root') {
                        $scope.currentCrumb = currentPath;
                        if (update == true) {
                            $scope.crumb.push(currentPath);
                        }
                        $scope.crumbString = filePath + '/';
                    } else {
                        if (refreshed == true) {
                            if (jData.crumb && jData.crumbString) {
                                $scope.crumb = jData.crumb;
                                $scope.crumbString = jData.crumbString + '/';
                                $scope.$apply();
                            }
                        }
                    }
                    $scope.items = jData.items.sort(compare);
                    $scope.$apply();
                } else {
                    if (filePath == 'root') {
                        $scope.$apply();
                        toastr.error('There are no <b>Files</b> nor <b>Folders</b> inside, Redirecting you back', 'Fail!!!', {allowHtml: true});
                        setTimeout(function () {
                            if($('.redirectTo').html() == undefined){
                                window.location.href = $scope.BASE_FOLDER+'/backup/devices';
                            }else{
                                window.location.href = $scope.BASE_FOLDER+'/devices';
                            }

                        }, 3000)
                    } else {
                        $scope.$apply();
                        toastr.error('There are no <b>Files</b> nor <b>Folders</b> inside!!!', 'Fail!!!', {allowHtml: true});
                    }
                }
            }else{
                toastr.error('There are no <b>Files</b> nor <b>Folders</b> inside, Redirecting you back', 'Fail!!!', {allowHtml: true});
                setTimeout(function () {
                    if($('.redirectTo').html() == undefined){
                        window.location.href = $scope.BASE_FOLDER+'/backup/devices';
                    }else{
                        window.location.href = $scope.BASE_FOLDER+'/devices';
                    }
                }, 3000)
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateFileListFromBreadCrumb = function(currentPath, key){
        var filePath = '';
        var crumb = [];
        for(var i = 0; i <= key; i++){
            filePath = filePath+$scope.crumb[i]+'/';
            crumb.push($scope.crumb[i]);
        }
        if(filePath != ''){
            $scope.crumb = crumb;
            $scope.updateFileList(filePath, currentPath, false);
        }else{
            $scope.updateFileList('root', 'root', true);
        }
    };

    function compare(a,b) {
        if (a.type > b.type)
            return -1;
        if (a.type < b.type)
            return 1;
        return 0;
    }

    function getKey(arr,val) {
        for (var i=0; i<arr.length; i++)
            if (arr[i] === val)
                return i;
        return 0;
    }

    function checkBreadCrumb(){
        var element = document.getElementById('breadCrumb');
        var lis = $("ul.nav-breadcrumb li");
        var i = 0;
        if (element.offsetWidth > 700) {
            for(i = 0; i < lis.length; i++){
                if(i > 1){
                    lis[i].childNodes[0].innerHTML = '...';
                }
            }
        }else{
            for(i = 0; i < lis.length; i++){
                if(i > 1){
                    if(lis[i].childNodes[0].innerHTML == '...'){
                        if($scope.crumb[i] != undefined){
                            lis[i].childNodes[0].innerHTML = $scope.crumb[i];
                        }else{
                            lis[i].remove();
                        }
                    }
                }
            }
        }
    }

    $scope.download = function(index, revisionCheck){
        window.open($('.protocol').html()+$scope.bestBlukrypt+$('.blukryptURL').html()+$('.cloudNameConstant').html()+'/portal/download/files/?fileName='+Base64.encode(encodeURIComponent($scope.selected[0].name))+'&filePath='+Base64.encode(encodeURIComponent($scope.selected[0].filePath))+'&token='+$('.uploadToken').html()+'&userName='+$scope.selected[0].user+'&isSync=false'+'&deviceUUID='+'&backupID='+$scope.selected[0].backupId, '_self');
    };

    $scope.downloadVersion = function(index){
        window.open($('.protocol').html()+$scope.bestBlukrypt+$('.blukryptURL').html()+$('.cloudNameConstant').html()+'/portal/download/files/?fileName='+encodeURIComponent($scope.selected[0].name)+'&filePath='+encodeURIComponent($scope.selected[0].filePath)+'&token='+$('.uploadToken').html()+'&userName='+$scope.selected[0].user+'&isSync=false'+'&deviceUUID='+'&backupID='+$scope.fileVersions[index].backupId, '_self');
    };

    $scope.updateUserDevices = function(username){
        $('.loading').html('Loading ...');
        if(username){
            $.ajax({
                url: $scope.BASE_FOLDER+'/backup/devices',
                data: {csrf_token: $('.csrf_token').html(), userName: username},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(jData.devices.length > 0){
                        $('.status').hide();
                        $('.devicesList').show();
                        $scope.devices = jData.devices;
                        $scope.$apply();
                        if($scope.restoreFromPortal == 'enable') {
                            $scope.enableRestore();
                        }
                    }else{
                        $('.listOfDevices').html('<a style="color: #585f69;">You have not configured any devices yet to be backed up!!!</a>');
                        toastr.info('You have not configured any devices yet to be backed up!!!', 'Information!!!', {allowHtml: true});
                    }
                }else{
                    $('.devicesList').hide();
                    $('.status').show();
                    $('.status').html('<h4>No Devices has been configured yet</h4>');
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.openFilesPage = function(deviceId, deviceName, deviceUUID){
        window.location.href = $scope.BASE_FOLDER+'/backup/files/'+deviceId+'/'+deviceName+'/'+deviceUUID;
    };

    $scope.selectionStart = function(selected){
        $('.contextMenu').hide();
    };

    $scope.selectionStop = function(selected){
        $scope.selected = selected;
        if(selected.length == 1){
            selected.forEach(function(value, key){
                if(value.type === 'Folder'){
                    $('.versionsBtn').hide();
                    $('.downloadAction').hide();
                    $('.viewAction').hide();
                    $('.shareAction').hide();
                }else{
                    $('.versionsBtn').show();
                    $('.downloadAction').show();
                    $('.viewAction').show();
                    $('.shareAction').show();
                }
            });
        }else{
            $('.versionsBtn').hide();
            $('.downloadAction').hide();
            $('.viewAction').hide();
            $('.shareAction').hide();
        }
    };

    $scope.menuOptions = [
        ['Open', function ($itemScope) {
            $scope.updateFileList($scope.crumbString+$scope.selected[0].name, $scope.selected[0].name, true);
        }, function(){
            if($scope.selected.length == 1){
                if($scope.selected[0].type === 'Folder'){
                    return true;
                }
            }
        }],
        ['Versions', function () {
            $scope.getVersions();
        }, function(){
            if($scope.selected.length == 1){
                if($scope.selected[0].type === 'File'){
                    return true;
                }
            }
        }],
        ['Download', function () {
            $scope.download();
        }, function(){
            if($scope.selected.length == 1){
                if($scope.selected[0].type === 'File'){
                    return true;
                }
            }
        }],
        ['View', function () {
            $scope.view();
        }, function(){
            if($scope.selected.length == 1){
                if($scope.selected[0].type === 'File'){
                    return true;
                }
            }
        }],
        ['Share', function () {
            $scope.share();
        }, function(){
            if($scope.selected.length == 1){
                if($scope.selected[0].type === 'File'){
                    if($('.shareEnabled').html() == 'enabled'){
                        return true;
                    }
                }
            }
        }],
        ['Add To restore', function () {
            $scope.addToRestoreBackup(false);
        }, function(){
            if($scope.restoreFromPortal == 'enable'){
                if($scope.selected.length >= 1){
                    return true;
                }
            }
        }],
        ['Add all versions to restore', function () {
            if($scope.addVersionsToRestore()){
                $scope.addToRestoreBackup(true);
            }
        }, function(){
            if($scope.restoreFromPortal == 'enable'){
                if($scope.selected.length >= 1){
                    return true;
                }
            }
        }],
        ['Initiate restore', function () {
            $scope.initiateRestoreBackupforFiles('');
        }, function(){
            if($scope.restoreFromPortal == 'enable') {
                if ($scope.selectedFileForRestoreList.length > 0) {
                    return true;
                }
            }
        }],
        //['Show Chunks', function () {
        //    $scope.showChunks();
        //}, function(){
        //    if($scope.selected.length == 1){
        //        if($scope.selected.length >= 1){
        //            if($scope.selected[0].type === 'File') {
        //                return true;
        //            }
        //        }
        //    }
        //}],
        ['Nothing Selected', function () {

        }, function(){
            if($scope.selected.length < 1){
                if($scope.selectedFileForRestoreList.length <= 0) {
                    return true;
                }else if($scope.restoreFromPortal == 'disable'){
                    return true;
                }
            }
        }],
        ['No Actions Available', function () {

        }, function(){
            if($scope.selected.length > 1){
                if($scope.restoreFromPortal == 'disable'){
                    return true;
                }
            }
        }]
    ];

    $scope.share = function(){
        $('#share').modal('show');
        $('.shareLoading').show();
        $('.shareBody').hide();
        $('.shareLinkBlock').hide();
        $('.shareBtn').hide();
        $('.unShareBtn').hide();
        $('.updateShareDetails').hide();
        var enableView = document.querySelector('.enableView');
        var enableDownload = document.querySelector('.enableDownload');
        var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');

        var data = {
            fileName : $scope.selected[0].name,
            filePath : $scope.selected[0].filePath,
            backupID : $scope.selected[0].backupId,
            csrf_token : $('.csrf_token').html(),
            productType : "backup"
        };
        console.log(data);
        $.ajax({
            url: $scope.BASE_FOLDER+'/backup/files/isShareCheck',
            type: 'POST',
            data: data
        }).done(function(data){
            console.log(data);
            $('.shareLoading').hide();
            $('.shareBody').show();
            var jData = JSON.parse(data);
            $scope.sharedFileDetails = jData.data;
            $('#emails').val('');
            $('.sendEmailShareForm').addClass('hide');
            if(jData.result == true){
                if(jData.data.passwordProtected == true){
                    if(sharePasswordSwitch.checked == false){
                        $('.sharePasswordSwitch').click();
                    }
                }else{
                    if(sharePasswordSwitch.checked == true){
                        $('.sharePasswordSwitch').click();
                    }
                }

                if(jData.data.download == true){
                    if(enableDownload.checked == false){
                        $('.enableDownload').click()
                    }
                }else{
                    if(enableDownload.checked == true){
                        $('.enableDownload').click()
                    }
                }

                if(jData.data.view == true){
                    if(enableView.checked == false){
                        $('.enableView').click()
                    }
                }else{
                    if(enableView.checked == true){
                        $('.enableView').click()
                    }
                }

                if(jData.data.validUntil != null){
                    $('.removeValidUntil').show();
                    $('#till').val(jData.data.validUntil);
                }else{
                    $('.removeValidUntil').hide();
                }

                $('.shareLinkBlock').show();
                $('.shareLink').html(jData.link);
                $('.shareBtn').hide();
                $('.unShareBtn').show();
                $('.updateShareDetails').show();
            }else{
                $('.shareLoading').hide();
                $('.shareBody').show();
                $('.shareLinkBlock').hide();
                $('.shareBtn').show();
                $('.unShareBtn').hide();
                $('.updateShareDetails').hide();
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getUserPolicy = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/user/policy',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            console.log(jData)
            if(jData.result == 'success'){
                $scope.userAssignedPolicy = jData.policy;
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
    if(sharePasswordSwitch){
        sharePasswordSwitch.onchange = function() {
            if(sharePasswordSwitch.checked == true){
                $('.sharePasswordBlock').show();
            }else{
                $('#sharePassword').val('');
                $('#reSharePassword').val('');
                $('.sharePasswordBlock').hide();
            }
        };
    }

    $scope.saveShare = function(){
        var enableView = document.querySelector('.enableView');
        var enableDownload = document.querySelector('.enableDownload');
        var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
        if(sharePasswordSwitch.checked == true){
            if($('#sharePassword').val().length <= 0){
                toastr.error('You need to specify a password to share a file', 'Fail!!!', {allowHtml: true});
                return;
            }
            if($('#reSharePassword').val().length <= 0){
                toastr.error('You have not re-typed your password', 'Fail!!!', {allowHtml: true});
                return;
            }
        }
        if ( $('#fileShareForm').parsley().isValid() && (enableDownload.checked == true || enableView.checked == true)) {
            var download = enableDownload.checked;
            var view = enableView.checked;
            var validTill = $('#till').val();
            var isPasswordProtected = sharePasswordSwitch.checked;
            var password = '';
            if(isPasswordProtected == true){
                password = $('#sharePassword').val();
            }
            var data = {
                csrf_token : $('.csrf_token').html(),
                fileName : $scope.selected[0].name,
                filePath : $scope.selected[0].filePath,
                backupId : $scope.selected[0].backupId,
                download : download,
                view : view,
                validTill : validTill,
                isPasswordProtected : isPasswordProtected,
                password : password
            };
            console.log(data);
            $.ajax({
                url: $scope.BASE_FOLDER+'/backup/files/share',
                type: 'POST',
                data: data
            }).done(function(data){
                var jData = JSON.parse(data);
                console.log(jData)
                $scope.sharedFileDetails = jData.data;
                if(jData.result = 'success'){
                    $('.shareLinkBlock').show();
                    $('.shareLink').html(jData.link);
                    $('.shareBtn').hide();
                    $('.unShareBtn').show();
                    $('.updateShareDetails').show();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });

        }else{
            if($('#fileShareForm').parsley().isValid()){
                toastr.error('Either Download or View should be enabled to share a file.', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.sendEmailShareLink = function(){
        $('.sendEmailShareForm').toggleClass('hide');
    };

    $scope.copyToClipboard = function(){
        toastr.success('Copied to Clipboard');
    };

    $scope.sendShareEmail = function(emails){
        if(emails != undefined && emails.length > 0){
            $('.loading').show();
            var html = $('.shareEmailLinkSendBtn').html();
            $('.shareEmailLinkSendBtn').attr('disabled','disabled');
            $('.shareEmailLinkSendBtn').html('Sending... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/sendShareEmail',
                data: {emails: emails, url: $('.shareLink').html(), fileName: $scope.selected[0].name, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                $('.shareEmailLinkSendBtn').removeAttr('disabled');
                $('.shareEmailLinkSendBtn').html(html);
                if(jData.result == 'success'){
                    console.log(data);
                    $('.sendEmailShareForm').addClass('hide');
                    $('[name="emails"]').val = '';
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('Please enter a <b>email address</b>', 'Fail!!!', {allowHtml: true});
        }
    };

    $scope.updateSharePolicy = function(){
        var enableView = document.querySelector('.enableView');
        var enableDownload = document.querySelector('.enableDownload');
        var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');

        if(sharePasswordSwitch.checked == true){
            if($('#sharePassword').val().length <= 0){
                toastr.error('Once Password protected is selected you need to specify a password to share a file', 'Fail!!!', {allowHtml: true});
                return;
            }
        }

        //if($('#till').val().length <= 0) {
          //  toastr.error('Select validity date',{allowHtml: true});
            //return;
        //}

        if ( $('#fileShareForm').parsley().isValid() && (enableDownload.checked == true || enableView.checked == true)) {
            var html = $('.updateShareDetails').html();
            $('.updateShareDetails').attr('disabled','disabled');
            $('.updateShareDetails').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            var download = enableDownload.checked;
            var view = enableView.checked;
            var validTill = $('#till').val();
            var isPasswordProtected = sharePasswordSwitch.checked;
            var password = '';
            if(isPasswordProtected == true){
                password = $('#sharePassword').val();
            }
            var data = {
                fileName : $scope.selected[0].name,
                filePath : $scope.selected[0].filePath,
                download : download,
                backupId : $scope.selected[0].backupId,
                view : view,
                validTill : validTill,
                csrf_token : $(".csrf_token").html(),
                isPasswordProtected : isPasswordProtected,
                key: $scope.sharedFileDetails.key12+'+'+$scope.sharedFileDetails.key14+'+'+$scope.sharedFileDetails.key18+'+'+$scope.sharedFileDetails.key20,
                password : password
            };
            console.log(data);
            $.ajax({
                url: $scope.BASE_FOLDER+'/backup/files/updateSharePolicy',
                type: 'POST',
                data: data
            }).done(function(data){
                var jData = JSON.parse(data);
                console.log(jData);
                if(jData.result = 'success'){
                    $('.shareLinkBlock').show();
                    $('.shareLink').html(jData.link);
                    $('.shareBtn').hide();
                    $('.unShareBtn').show();
                    $('.updateShareDetails').show();
                    $('.updateShareDetails').html('Saved <i class="fa fa-check"></i>').animate();
                    setTimeout(function(){
                        $('.updateShareDetails').html(html);
                        $('.updateShareDetails').removeAttr('disabled');
                    }, 1000);
                }else{
                    $('.updateShareDetails').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        $('.updateShareDetails').html(html);
                        $('.updateShareDetails').removeAttr('disabled');
                    }, 1000);
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });


        }else{
            if($('#fileShareForm').parsley().isValid()){
                toastr.error('Download should be enabled to share a file.', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.unShare = function(){
        console.log($scope.selected[0]);
        var data = {
            fileName : $scope.selected[0].name,
            filePath : $scope.selected[0].filePath,
            backupID : $scope.selected[0].backupId,
            csrf_token : $(".csrf_token").html()
        };
        $.ajax({
            url: $scope.BASE_FOLDER+'/backup/files/unShare',
            type: 'POST',
            data: data
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result = 'success'){
                $('.shareWithBody').show();
                $('.shareWithBodyStatus').hide();
                $('.updateShareWithDetails').hide();
                $('.shareLoading').hide();
                $('.shareBody').show();
                $('.till').val('');
                $('.shareWithValidTill').val('');
                $('.listOfUsers').val('');
                $('.shareWithSubject').val('');
                $('.shareWithMessage').val('');
                $('.removeValidUntil').hide();
                $('.shareWithRemoveValidUntil').hide();
                $('.shareLinkBlock').hide();
                $('.shareLink').html('');
                $('.shareBtn').show();
                $('.unShareBtn').hide();
                $('.updateShareDetails').hide();
                $('#emails').val('');
                $('.sendEmailShareForm').addClass('hide');
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.view = function(){
        $('#paraviewContainer .modal-title').html('Loading ...');
        $('.content').html('');
        $('.content').hide();
        $('.pageContainer').hide();
        $('.excelContainer').hide();
        $('.pdfContainer').hide();
        $('.imageViewer').hide();
        $('.paraviewLoading').show();

        $('#paraviewContainer').modal('show');
        $.ajax({
            url: $scope.BASE_FOLDER+'/backup/view',
            data: {userName: $scope.selected[0].user, backupId: $scope.selected[0].backupId, fileName: $scope.selected[0].name, filePath: $scope.selected[0].filePath, csrf_token: $('.csrf_token').html(), isSync: false},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
            if(jData.result == 'fail'){
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                $('#paraviewContainer').modal('hide');
                return;
            }

            if(jData.type == 'image') {

                $('#paraviewContainer .modal-title').html($scope.selected[0].name);
                $('.imageViewer').html(jData.html);
                $('.imageViewer').show();
                $('.paraviewLoading').hide();

            }else if(jData.type == 'pdf') {

                $('#paraviewContainer .modal-title').html($scope.selected[0].name);
                $('.paraviewLoading').hide();
                $('.pdfContainer').html(jData.html);
                $('.pdfContainer').show();

            }else if(jData.type == 'odt') {

                $('#paraviewContainer .modal-title').html($scope.selected[0].name);
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                viewDoc(jData, 300, 100);

            }else if(jData.type == 'text') {

                $('#paraviewContainer .modal-title').html($scope.selected[0].name);
                $('.content').html(jData.html);
                $('.paraviewLoading').hide();
                $('.content').show();

            }else if(jData.type == 'excel') {

                $('#paraviewContainer .modal-title').html($scope.selected[0].name);
                $('.excelContainer').show();
                $('.paraviewLoading').hide();
                viewExcel(jData);

            }else{

                $('#paraviewContainer .modal-title').html($scope.selected[0].name);
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                viewDoc(jData, 400, 100);

            }

        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $('#paraviewContainer').on('hidden.bs.modal', function () {
        $('.page').remove();
        $('.pageContent').remove();
        $('.pageContainer').html('');
    });function addAPage(jsonData, pageNumber){
        pageNumber = pageNumber+1;
        $('.pageContainer').append('<div id="page'+pageNumber+'" class="page"></div>');
        $('.page').css(jsonData.pageStyle);
        $('#page'+pageNumber).append('<div class="pageContent"><div class="pageNumber"> Page '+pageNumber+'<br/></div></div>');
        $('.pageContent').css(jsonData.contentStyle);
        return pageNumber;
    }
    function checkHeight(contentHeight, pageNumber) {
        var div = '#page'+pageNumber+' .pageContent';
        var element = document.querySelector(div);
        var _hasScrollBar = false;
        if( (parseInt($(div).outerHeight(true) ) < parseInt(contentHeight))){
            _hasScrollBar = true;
        }
        return _hasScrollBar;
    }

    function viewDoc(jsonData, defaultHeight, minusDefaultSize){
        var pageNumber = 0;
        var pageHeight = parseInt(jsonData.pageStyle.height.replace("px", ""));
        var contentBottom = parseInt(jsonData.contentStyle.bottom.replace("px", ""));
        jsonData.html.forEach(function(row){
            var contentHeight = pageHeight - (contentBottom+defaultHeight);
            if ($('.page').length <= 0 ) {
                pageNumber = addAPage(jsonData, pageNumber);
            }
            if(checkHeight(contentHeight, pageNumber) == false) {
                pageNumber = addAPage(jsonData, pageNumber);
                defaultHeight = defaultHeight - minusDefaultSize;
            }
            $('#page'+pageNumber+' .pageContent').append(row);
        })

    }

    function viewExcel(jsonData){
        var html = '';
        var links = '';
        var htmlData = '';
        jsonData.html.forEach(function(row, key){
            var active = '';
            if(key == 0){
                active = 'active';
            }
            links += '<li role="presentation" class="'+active+'"><a href="#'+row.id+'" id="home-tab" role="tab" data-toggle="tab" aria-controls="home" aria-expanded="true">'+row.sheetName+'</a></li>';
            htmlData += '<div role="tabpanel" class="tab-pane fade '+active+' in" id="'+row.id+'" aria-labelledby="home-tab">'+row.html+'</div>';
        });
        html += '<div class="panel" style="background-color: #fff; padding: 20px 20px; overflow: auto; height: 550px">'+
            '<div class="bs-example bs-example-tabs" role="tabpanel" data-example-id="togglable-tabs">'+
            '<ul id="myTab" class="nav nav-tabs" role="tablist">'+links+'</ul>'+
            '<div id="myTabContent" class="tab-content">'
            +htmlData+
            '</div>'+
            '</div>'+
            '</div>';
        $('.excelContainer').html(html);
    }

    $scope.addToRestoreBackupFromRevisions = function(key, version){
        var fileElement = {
            name: $scope.selected[0].name,
            fullPath: $scope.selected[0].fullPath,
            size: $scope.fileVersions[key].size,
            serverModifiedTime:$scope.fileVersions[key].serverModifiedTime,
            backupId: $scope.fileVersions[key].backupId,
            user: $scope.fileVersions[key].fileUser,
            version: version
        };
        $scope.selectedFileForRestoreList = $scope.selectedFileForRestoreList
            .filter(function (el) {
                return el.name !== $scope.selected[0].name;
            });

        if($scope.selectedFilesForRestoreFromVersions.length <= 0){
            $scope.selectedFilesForRestoreFromVersions.push(fileElement);
            toastr.info(fileElement.name+', has been added to restore bucket, to initiate the restore click on Initiate Restore');
        }else{
            if(checkIfExistsOrNot(fileElement) == false){
                $scope.selectedFilesForRestoreFromVersions.push(fileElement);
                toastr.info(fileElement.name+', has been added to restore bucket, to initiate the restore click on Initiate Restore');
            }else{
                toastr.error('Selected file, '+fileElement.name+' has already been added to restore');
            }
        }
    };

    function checkIfExistsOrNot(fileElement){
        var result = false;
        $scope.selectedFilesForRestoreFromVersions.forEach(function(value, key){
            if(fileElement.backupId == value.backupId){
                result = true;
            }
        });
        return result;
    }

    $scope.addVersionsToRestore = function(){
        $scope.selectedFilesForRestoreFromVersions = $scope.selectedFilesForRestoreFromVersions
            .filter(function (el) {
                return el.name !== $scope.selected[0].name;
            });
        toastr.info('Selected file, '+$scope.selected[0].name+' has been added to restore bucket, to initiate the restore click on Initiate Restore');
        return true;
    };

    $scope.addToRestoreBackup = function(restoreAllVersions){
        if($scope.selected.length >= 1){
            $scope.selected.forEach(function(value, key){
                if($scope.selectedFileForRestoreList.length < 1){
                    value.restoreAllVersions = restoreAllVersions;
                    $scope.selectedFileForRestoreList.push(value);
                    if(restoreAllVersions == false){
                        toastr.info('Selected item, '+value.name+' has been added to restore bucket, to initiate the restore click on Initiate Restore');
                    }
                }else{
                    var checkResult = checkIfExists(value, $scope.selectedFileForRestoreList);
                    if(checkResult == false){
                        value.restoreAllVersions = restoreAllVersions;
                        $scope.selectedFileForRestoreList.push(value);
                        if(restoreAllVersions == false) {
                            toastr.info('Selected item, ' + value.name + ' has been added to restore bucket, to initiate the restore click on Initiate Restore');
                        }
                    }else if(checkResult == 'parent'){
                        if(restoreAllVersions == false) {
                            toastr.error('Selected item, ' + value.name + '\'s parent folder has already been added to restore');
                        }
                    }else if(checkResult == 'added') {
                        value.restoreAllVersions = restoreAllVersions;
                        $scope.selectedFileForRestoreList = $scope.selectedFilesForRestore;
                        $scope.selectedFileForRestoreList.push(value);
                        if(restoreAllVersions == false) {
                            toastr.info('Items which were selected to restore have been removed as the parent folder, ' + value.name + ' has been added to restore');
                        }
                    }else{
                        if(restoreAllVersions == false) {
                            toastr.error('Selected item, ' + value.name + ' has already been added to restore');
                        }
                    }
                }
            });
        }else{
            toastr.error('No files Selected to restore');
        }
    };

    function checkIfExists(value, values){
        var exists = false;
        values.forEach(function(existingValue, existingKey){
            if(value.backupId == existingValue.backupId){
                exists = true;
            }else{
                var existingValueArray = existingValue.fullPath.split('/');
                var valueArr = value.fullPath.split('/');
                if(existingValue.fullPath.indexOf(valueArr[0]) == 0){
                    if(valueArr.length == 1){
                        removeChildren(valueArr[0]);
                        exists = 'added';
                    }else if(existingValueArray.length == (valueArr.length+1)){
                        if(existingValueArray[1] == valueArr[1]){
                            removeChildren(valueArr[0]);
                            exists = 'added';
                        }
                    }else if(existingValueArray.length == 1){
                        exists = 'parent';
                    }else if((existingValueArray.length+1) == valueArr.length){
                        var i = 0;
                        var result = true;
                        var valueString = '';
                        var existingValueString = '';
                        while (i < existingValueArray.length) {
                            valueString += valueArr[i];
                            existingValueString += existingValueArray[i];
                            if(valueString != existingValueString){
                                result = false;
                                i = valueArr.length
                            }else{
                                i++;
                            }
                        }
                        if(result){
                            exists = 'parent';
                        }
                    }
                }

            }
        });
        return exists;
    }

    function removeChildren(basePath){
        var filesList = [];
        $scope.selectedFileForRestoreList.forEach(function(file, key){
            if(file.fullPath.indexOf(basePath) != 0){
                filesList.push(file);
            }
        });
        $scope.selectedFilesForRestore = filesList;
    }

    $scope.initiateRestoreBackupforFiles = function(){
        $('.restoreBucket').modal('show');
    };

    $scope.initiateRestoreBackup = function(uuid, deviceName, key){
        $('.restoreBucket').modal('show');
        $scope.currentSelectedDeviceUUID = uuid;
        $scope.currentSelectedDeviceName = deviceName;
    };

    $scope.enableRestoreForFiles = function(){
        var deviceName = $('.deviceName').html();
        var selectedBTN = $('.restoreBtnForFiles');

        var html = selectedBTN.html();
        selectedBTN.attr('disabled','disabled');
        selectedBTN.html('Verifying... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            url: $scope.BASE_FOLDER+'/backup/files/checkRestoreProgress',
            data: {csrf_token: $('.csrf_token').html(),deviceName: deviceName},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                selectedBTN.removeAttr('disabled');
                selectedBTN.html('Initiate Restore');
            }else{
                if(jData.type == 'restore'){
                    selectedBTN.html('Restore In Progress... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
                }else if(jData.type == 'busy'){
                    selectedBTN.html('Agent is busy... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
                }else{
                    selectedBTN.removeAttr('disabled');
                    selectedBTN.html(html);
                }
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.enableRestore = function(){
        $scope.devices.forEach(function(value, key){
            var selectedBTN = $('.initiateRestoreBtn'+key);

            var html = selectedBTN.html();
            selectedBTN.attr('disabled','disabled');
            selectedBTN.html('Verifying... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/backup/files/checkRestoreProgress',
                data: {csrf_token: $('.csrf_token').html(),deviceName: value.name},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    selectedBTN.removeAttr('disabled');
                    selectedBTN.html('Initiate Restore');
                }else{
                    if(jData.type == 'restore'){
                        selectedBTN.html('Restore In Progress... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
                    }else if(jData.type == 'busy'){
                        selectedBTN.html('Agent is busy... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
                    }else{
                        selectedBTN.removeAttr('disabled');
                        selectedBTN.html(html);
                    }
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        });
    };

    $scope.sendFilesForRestore = function(deviceName, destinationPath){
        deviceName = (deviceName != "default" && deviceName != undefined) ? deviceName : $scope.currentSelectedDeviceName;
        deviceName = (deviceName.length > 0) ? deviceName : $('.deviceName').html();
        var deviceLevelRestore;
        var restoreAllVersions;
        var selectedBTN = $('.restoreBtnForFiles');
        selectedBTN.attr('disabled','disabled');
        selectedBTN.html('Initiating... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        var paths = getFilePaths($scope.selectedFileForRestoreList, $scope.selectedFilesForRestoreFromVersions);

        if(paths.length > 0){
            deviceLevelRestore = 'false';
            restoreAllVersions = 'false';
        }else{
            deviceLevelRestore = 'true';
            restoreAllVersions = $('[name="restoreAllVersions"]').val();
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/backup/files/sendFilesForRestore',
            data: {csrf_token: $('.csrf_token').html(),deviceLevelRestore: deviceLevelRestore, paths: paths, deviceName:deviceName, path: destinationPath, restoreAllVersions: restoreAllVersions, deviceUUID: $scope.currentSelectedDeviceUUID},
            type: 'POST'
        }).done(function(data){
            selectedBTN.removeAttr('disabled');
            selectedBTN.html('Initiate Restore');
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                setTimeout(function(){
                    window.location.reload(true);
                }, 3000);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function getFilePaths(files, fileVersions){
        var paths = [];
        files.forEach(function(file, key){
            var filePath;
            if(file.filePath){
                filePath = file.filePath+'/'+file.name
            }else{
                filePath = $scope.crumbString+file.name
            }
            var path = {
                name: file.name,
                path: filePath,
                isFolder: file.type == 'Folder',
                userName: file.user,
                isRestoreAllVersions: file.restoreAllVersions,
                backupId: '',
                version: 0
            };
            paths.push(path);
        });
        fileVersions.forEach(function(filev, keyv){
            var path = {
                name: filev.name,
                path: filev.fullPath,
                isFolder: filev.type == 'Folder',
                userName: filev.user,
                isRestoreAllVersions: 'false',
                backupId: filev.backupId,
                version: filev.version
            };
            paths.push(path);
        });
        return paths;
    }

    $scope.removeFromFileRestoreList = function(key){
        toastr.success($scope.selectedFileForRestoreList[key].name+', has been removed from restore bucket', 'Successful!!!', {allowHtml: true});
        $scope.selectedFileForRestoreList.splice(key, 1);
    };

    $scope.removeFromFileVersionsRestoreList = function(key){
        toastr.success($scope.selectedFilesForRestoreFromVersions[key].name+', has been removed from restore bucket', 'Successful!!!', {allowHtml: true});
        $scope.selectedFilesForRestoreFromVersions.splice(key, 1);
    };

    $scope.showChunks = function(){
        $('.loading').html('Loading ...');
        if($scope.selected.length == 1){
            $.ajax({
                url: $scope.BASE_FOLDER+'/backup/files/fileChunks',
                data: {csrf_token: $('.csrf_token').html(), backupId: $scope.selected[0].backupId, userName: $scope.selected[0].user},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(jData.chunks.length > 0){
                        $scope.chunks = jData.chunks;
                        $scope.$apply();
                        $('.chunks').modal('show');
                        $('.loading').hide();
                    }else{
                        $scope.$apply();
                        toastr.error('There is <b>no chunks</b> that has been created for the selected file', 'Fail!!!', {allowHtml: true});
                    }
                }else{
                    $scope.$apply();
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.getVersions = function(){
        $('.loading').html('Loading ...');
        if($scope.selected.length == 1){
            $.ajax({
                url: $scope.BASE_FOLDER+'/backup/files/fileVersions',
                data: {csrf_token: $('.csrf_token').html(), fileName: $scope.selected[0].name, filePath: cleanUrl($scope.crumbString)},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(jData.fileVersions.length > 0){
                        $scope.fileVersions = jData.fileVersions;
                        $scope.$apply();
                        $('.backupFileVersions').modal('show');
                        $('.loading').hide();
                        $('.deviceHistoryDetailsTable').show();
                    }else{
                        $scope.$apply();
                        toastr.error('There is <b>no versions</b> that has been saved for the selected file', 'Fail!!!', {allowHtml: true});
                    }
                }else{
                    $scope.$apply();
                    toastr.error('There is <b>no versions</b> that has been saved for the selected file', 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.deleteConfirmation = function(){
        if($scope.selected.length > 0){
            $('.deleteConfirmation').modal('show');
        }else{
            toastr.info('Please select a file or a folder to delete', 'Info!!!', {allowHtml: true});
        }
    };

    $scope.deleteFile = function(){
        $('.loading').html('Loading ...');
        if($scope.selected.length >= 1){
            $scope.selected.forEach(function(value, key){
                $.ajax({
                    url: $scope.BASE_FOLDER+'/backup/file/delete',
                    data: {csrf_token: $('.csrf_token').html(), fileName: value.name, filePath: cleanUrl($scope.crumbString), isFolder: value.type == 'Folder' },
                    type: 'POST'
                }).done(function(data){
                    blockUI.stop();
                    $('.deleteConfirmation').modal('hide');
                    var jData = JSON.parse(data);
                    if(jData.result == 'success'){
                        toastr.success('Selected item has been <b>delete successfully!!!</b>', 'Successful!!!', {allowHtml: true});
                    }else if(jData.result == 'fail'){
                        toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                    }else{
                        toastr.error('Could <b>not delete</b> the selected file, please try again after some time', 'Fail!!!', {allowHtml: true});
                    }
                }).error(function(data){
                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                    if(data.status == 424){
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/sleep';
                        }, 3000);
                    }else if(data.status == 503){
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                        }, 3000);
                    }
                });
            });
        }
    };

    function cleanUrl(str) {
        if(str.substr(-1) === '/') {
            return str.substr(0, str.length - 1);
        }
        return str;
    }

    $scope.getBlukrypts = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/getAllBlukrypts',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.blukrypts != null){
                    $scope.listOFBlukrypts = jData.blukrypts;
                    $scope.$apply();
                    //$scope.listOFBlukrypts.forEach(function(value, key){
                        $.ajax({
                            url: $scope.BASE_FOLDER+'/getBestBlukrypt',
                            data: {blukrypts: jData.blukrypts, csrf_token: $('.csrf_token').html()},
                            type: 'POST'
                        }).done(function(data){
                            console.log(data);
                            var jData = JSON.parse(data);
                            if(jData.result = 'fail'){
                                $scope.bestBlukrypt = jData.bestBlukrypt;
                                $scope.$apply()
                            }else{
                                toastr.error('Due to some technical issues not able to open the file location please, manually navigate to the file', 'Fail!!!', {allowHtml: true});
                            }
                        }).error(function(data){
                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                            if(data.status == 424){
                                setTimeout(function(){
                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                                }, 3000);
                            }else if(data.status == 503){
                                setTimeout(function(){
                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                                }, 3000);
                            }
                        });
                //    });
                }else{
                    $scope.bestBlukrypt = $('.blukryptIP').html();
                    $scope.$apply();
                }
            }else{
                $scope.bestBlukrypt = $('.blukryptIP').html();
                $scope.$apply();
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    angular.element(document).ready(function(){
        $scope.getBlukrypts();
        $('.loading').html('Loading ...');

        if($scope.currentPage == 'files'){
            $('.backupFilesTable').show();
            blockUI.start();
            $scope.getUserPolicy();
            $scope.updateFileList('root', 'root', true, true);
            if($scope.restoreFromPortal == 'enable') {
	            setInterval(function(){
	                $scope.enableRestoreForFiles();
	            }, 60000);
	        }
        }

        if($scope.selectedUser && $scope.currentPage == 'devices') {
            blockUI.start();
            $scope.updateUserDevices($scope.selectedUser);
            if($scope.restoreFromPortal == 'enable') {
	            setInterval(function(){
	                $scope.enableRestore();
	            }, 60000);
	        }
        }

        var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
        if(sharePasswordSwitch){ var init = new Switchery(sharePasswordSwitch, { color: '#4CAF50', size: 'large'}); }

        var enableDownload = document.querySelector('.enableDownload');
        if(enableDownload){ var init = new Switchery(enableDownload, { color: '#4CAF50'}); }

        if($scope.restoreFromPortal == 'enable') {
	        $scope.enableRestoreForFiles();
	    }

        $('body').click(function() {
            $('.contextMenu').hide();
        });

        $('.contextMenu').click(function() {
            $('.contextMenu').hide();
        });

    });
    
    var Base64 = {


    _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",


    encode: function(input) {
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;

        input = Base64._utf8_encode(input);

        while (i < input.length) {

            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
chr3 = input.charCodeAt(i++);

            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;

            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            } else if (isNaN(chr3)) {
                enc4 = 64;
            }

            output = output + this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) + this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);

        }

        return output;
},


    decode: function(input) {
        var output = "";
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0;

        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

        while (i < input.length) {

            enc1 = this._keyStr.indexOf(input.charAt(i++));
            enc2 = this._keyStr.indexOf(input.charAt(i++));
            enc3 = this._keyStr.indexOf(input.charAt(i++));
            enc4 = this._keyStr.indexOf(input.charAt(i++));
            chr1 = (enc1 << 2) | (enc2 >> 4);
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
            chr3 = ((enc3 & 3) << 6) | enc4;

            output = output + String.fromCharCode(chr1);

            if (enc3 != 64) {
                output = output + String.fromCharCode(chr2);
            }
            if (enc4 != 64) {
                output = output + String.fromCharCode(chr3);
            }

        }

        output = Base64._utf8_decode(output);

        return output;
    },

    _utf8_encode: function(string) {
        string = string.replace(/\r\n/g, "\n");
        var utftext = "";

        for (var n = 0; n < string.length; n++) {

            var c = string.charCodeAt(n);

            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }

        }

        return utftext;
    },

    _utf8_decode: function(utftext) {
        var string = "";
        var i = 0;
        var c = c1 = c2 = 0;

        while (i < utftext.length) {
        c = utftext.charCodeAt(i);

            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if ((c > 191) && (c < 224)) {
                c2 = utftext.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = utftext.charCodeAt(i + 1);
                c3 = utftext.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }

        return string;
    }

}

    function htmlspecialchars_decode(string, quote_style) {
        var optTemp = 0,
            i = 0,
            noquotes = false;
        if (typeof quote_style === 'undefined') {
            quote_style = 2;
        }
        string = string.toString()
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>');
        var OPTS = {
            'ENT_NOQUOTES': 0,
            'ENT_HTML_QUOTE_SINGLE': 1,
            'ENT_HTML_QUOTE_DOUBLE': 2,
            'ENT_COMPAT': 2,
            'ENT_QUOTES': 3,
            'ENT_IGNORE': 4
        };
        if (quote_style === 0) {
            noquotes = true;
        }
        if (typeof quote_style !== 'number') { // Allow for a single string or an array of string flags
            quote_style = [].concat(quote_style);
            for (i = 0; i < quote_style.length; i++) {
                // Resolve string input to bitwise e.g. 'PATHINFO_EXTENSION' becomes 4
                if (OPTS[quote_style[i]] === 0) {
                    noquotes = true;
                } else if (OPTS[quote_style[i]]) {
                    optTemp = optTemp | OPTS[quote_style[i]];
                }
            }
            quote_style = optTemp;
        }
        if (quote_style & OPTS.ENT_HTML_QUOTE_SINGLE) {
            string = string.replace(/&#0*39;/g, "'"); // PHP doesn't currently escape if more than one 0, but it should
            // string = string.replace(/&apos;|&#x0*27;/g, "'"); // This would also be useful here, but not a part of PHP
        }
        if (!noquotes) {
            string = string.replace(/&quot;/g, '"');
        }
        // Put this in last place to avoid escape being double-decoded
        string = string.replace(/&amp;/g, '&');

        return string;
    }

}]);
