<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Share extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Support Model was called', 'info');
    }

    /**
     * Below Method gets a shared file Details
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSharedFileDetails($headers){
        $url = PARA_URL.'files'.DS.'share'.DS.'info';
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Access Headers'. json_encode($this->curl->request_headers), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets a shared file Details
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSharedFileDetails2($headers){
        $url = PARA_URL.'files'.DS.'share'.DS.'info';
        $ch 	= curl_init();

        $headers[] = 'Content-type: application/xml';
        $headers[] = 'Accept: application/xml';
        $headers[] = 'Accept-Charset: utf-8';
        $headers[] = 'key12: '.$headers['key12'];
        $headers[] = 'key14: '.$headers['key14'];
        $headers[] = 'key18: '.$headers['key18'];
        $headers[] = 'key20: '.$headers['key20'];
        $headers[] = 'isBackup: '.$headers['isBackup'];
        $headers[] = 'ip: '.$headers['ip'];
        $headers[] = 'accessType: '.$headers['accessType'];
        $headers[] = 'browser: '.$headers['browser'];
        $headers[] = 'osType: '.$headers['osType'];
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        KLogger::req($url,$headers,$data);
        $result = curl_exec($ch);
        $intReturnCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $result = array(
            'status' => ($intReturnCode == 201) ? 200 : $intReturnCode,
            'body' => $result
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Downloads a file
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function download($headers){
        $url = $this->api->getUrl('download');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

}