<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Settings extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Settings Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveEncryption($headers,$data){
        $url = $this->api->getVersionUrl('saveEncryption');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getEncryption($headers){
        $url = $this->api->getVersionUrl('getEncryption');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveLocalStorageDetails($headers, $data){
        $url = $this->api->getUrl('saveLocalStorageDetails');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveCloudCredentials($headers, $data){
        $url = $this->api->getUrl('saveCloudCredentials');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function removeCloudCredentials($headers){
        $url = $this->api->getUrl('removeCloudCredentials');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $username
     * @return array
     */
    public function getUserDetails($headers, $username){
        $url = $this->api->getUrl('userDetails');
        KLogger::req($url,$headers,$username);
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.str_replace(' ', '%20', $username).DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log($url.DS.str_replace(' ', '%20', $username).DS, 'info');
        $this->log('headers: '.json_encode($headers), 'info');
        $this->log(json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getCloudCredentials($headers){
        $url = $this->api->getUrl('getCloudCredentials');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveAdCredentials($headers, $data){
        $url = $this->api->getUrl('saveAdCredentials');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function editAdCredentials($headers, $data){
        $url = $this->api->getUrl('editAdCredentials');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function removeAdCredentials($headers){
        $url = $this->api->getUrl('removeAdCredentials');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveSmtp($headers, $smtpDetails){
        $url = $this->api->getUrl('saveSmtp');
        KLogger::req($url,$headers,$smtpDetails);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $smtpDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSmtp($headers){
        $url = $this->api->getUrl('getSmtp');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $cloudDetails
     * @return array
     */
    public function saveCloudProperties($headers, $cloudDetails){
        $url = $this->api->getVersionUrl('saveCloudProperties');
        KLogger::req($url,$headers,$cloudDetails);
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $cloudDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getCloudProperties($headers){
        $url = $this->api->getVersionUrl('getCloudProperties');
        KLogger::req($url,$headers,$cloudDetails);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAdCredentials($headers){
        $url = $this->api->getUrl('getAdCredentials');
        KLogger::req($url,$headers,$cloudDetails);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAdCredential($headers){
        $url = $this->api->getUrl('getAdCredential');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAadDetails($headers){
        $url = $this->api->getParacloudUrl('getAadDetails');
        $this->log("URL : ".$url,"info");
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    
    public function saveAadDetails($headers,$data){
        $url = $this->api->getParacloudUrl('saveAadDetails');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getLocalStorageDetails($headers){
        $url = $this->api->getUrl('getLocalStorageDetails');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getProxyDetails($headers){
        $url = $this->api->getVersionUrl('proxy');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function removeProxyDetails($headers){
        $url = $this->api->getVersionUrl('proxy');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveProxyDetails($headers,$data){
        $url = $this->api->getVersionUrl('proxy');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function editProxyDetails($headers,$data){
        $url = $this->api->getVersionUrl('proxy');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->put($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $odbDetails
     * @return array
     */
    public function saveOdbDetails($headers, $odbDetails){
        $url = $this->api->getUrl('saveOdbDetails');
        KLogger::req($url,$headers,$odbDetails);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $odbDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $googleDetails
     * @return array
     */
    public function saveGoogleDetails($headers, $googleDetails){
        $url = $this->api->getUrl('saveOdbDetails');
        KLogger::req($url,$headers,$googleDetails);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $googleDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */


    public function getOdbDetails($headers){
        $url = $this->api->getUrl('getOdbDetails');
        KLogger::req($url,$headers,$googleDetails);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    /**
      * Below Method gets all backup policies
      *
      * token should be sent in header
      * @param $headers
      * @return array
      */
    
    public function getAllPolicies($headers){
         $url = $this->api->getUrl('getAllPolices');
         KLogger::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
 
     /**
      * Below Method gets all sync policies
      *
      * token should be sent in header
      * @param $headers
      * @return array
      */
     public function getAllSyncPolicies($headers){
         $url = $this->api->getUrl('getAllSyncPolices');
         KLogger::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }

}
