<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Report extends Model{

    public function __construct(){
        parent::__construct();
        $this->log('Report Model was called', 'info');
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getStatistics($headers){
        $url = $this->api->getUrl('getStatistics');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getServerBackupStatistics($headers){
        $url = $this->api->getUrl('getServerBackupStatistics');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
  public function getOverview($headers,$data){
        $url = $this->api->getUrl('getOverviewNew');
        KLogger::req($url,$headers,$data);
        $this->log("usrl". $url, "info");
        $this->log("headers". $headers, "info");
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getSyncCLoudUsage($headers){
        $url = $this->api->getUrl('syncCLoudUsage');
        KLogger::req($url,$headers,$data);
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getOverviewAll($headers){
        $url = $this->api->getUrl('getOverviewAll');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getRestoreHistory($headers,$data){
        $url = $this->api->getUrl('getRestoreHistory');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function updateSyncCloudUsageDetails($headers){
        $url = $this->api->getUrl('updateSyncCloudUsageDetails');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getLongBackupDetails($headers){
        $url = $this->api->getUrl('longBackup');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getCurrentBackupDetails($headers){
        $url = $this->api->getUrl('currentBackup');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getNoBackupDetails($headers,$data){
        $url = $this->api->getUrl('noBackup');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAgentNotHeardDetails($headers, $data){
        $url = $this->api->getParacloudUrl('agentNotHeard');
        //$url = $url."?noOfDays=".$days;
        $this->curl->setHeaders($headers);
        $this->log('Header: '.json_encode($headers),'info');
        $this->log('data: '.json_encode($data),'info');
        
        $this->curl->post($url,$data);
        $this->log("URL : ".json_encode($url),"info");
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    public function downloadAgentNotHeardReport($headers, $data){
        $url = $this->api->getParacloudUrl('agentNotHeardExcel');
//	$url = $url."?noOfDays=".$days;
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getStorageUtilized($headers){
        $url = $this->api->getUrl('storageUtilized');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getStorageUtilizedByPG($headers){
        $url = $this->api->getUrl('storageUtilizedByPG');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getFailedBackup($headers,$data){
        $url = $this->api->getUrl('failedBackup');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $startDate
     * @param $toDate
     * @return array
     */
    function getStorageTrend($startDate, $toDate){
        $url = $this->api->getUrl('storageTrend');
        $headers[] 	= 'Content-Type: application/json';
        $headers[] 	= 'startDate: '.$startDate;
        $headers[] 	= 'endDate: '.$toDate;
        $ch 		= curl_init();
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        KLogger::req($url,$headers,$data);
        $result 		= curl_exec($ch);
        $intReturnCode 	= curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $this->log('statusCode : '. $intReturnCode, 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        if($intReturnCode == 200 ) {
            return $result;
        }
        else{
            return null;
        }
    }

    /**
     * Get Report Statistics
     *
     * @param $startDate
     * @param $toDate
     * @return array
     */
    function getBlobTrend($startDate, $toDate){
        $url = $this->api->getUrl('blobTrend');
        $headers[] 	= 'Content-Type: application/json';
        $headers[] 	= 'startDate: '.$startDate;
        $headers[] 	= 'endDate: '.$toDate;
        $ch 		= curl_init();
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        KLogger::req($url,$headers,$data);
        $result 		= curl_exec($ch);
        $intReturnCode 	= curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $this->log('statusCode : '. $intReturnCode, 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        if($intReturnCode == 200 ) {
            return $result;
        }
        else{
            return null;
        }
    }

    /**
     * Get Report Statistics
     *
     * @param $startDate
     * @param $toDate
     * @return array
     */
    function getBackupTrend($startDate, $toDate){
        $url = $this->api->getUrl('backupTrend');
        $headers[] 	= 'Content-Type: application/json';
        $headers[] 	= 'startDate: '.$startDate;
        $headers[] 	= 'endDate: '.$toDate;
        $ch 		= curl_init();
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        KLogger::req($url,$headers,$data);
        $result 		= curl_exec($ch);
        $intReturnCode 	= curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $this->log('statusCode : '. $intReturnCode, 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        if($intReturnCode == 200 ) {
            return $result;
        }
        else{
            return null;
        }
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getUserDeviceHistory($headers){
        $url = $this->api->getUrl('userDeviceHistory');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getUserBackupHistory($headers,$data){
        $url = $this->api->getUrl('userBackupHistory');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log("Header :".json_encode($headers),'info');
         $this->log("data :".json_encode($data),'info');
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getDailyUserBackupOverview($headers,$data){
        $url = $this->api->getUrl('dailyUserBackupOverview');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function downloadDailyUserBackupOverview($headers,$data){
        $url = $this->api->getUrl('downloadDailyUserBackupOverview');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getDeviceBackupHistory($headers){
        $url = $this->api->getUrl('deviceBackup');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getDeviceUserHistory($headers){
        $url = $this->api->getUrl('deviceUserHistory');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getLastBackupDetails($headers){
        $url = $this->api->getUrl('lastBackupDetails');
        KLogger::req($url,$headers,$data);
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getAlertHistory($headers){
        $url = $this->api->getUrl('alertHistory');
        KLogger::req($url,$headers,$data);
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getUserMigration($headers){
        $url = $this->api->getUrl('userMigration');
        KLogger::req($url,$headers,$data);
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function downloadOverViewReport($headers,$data){
        $url = $this->api->getUrl('overviewReport');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function downloadSyncOverViewReport($headers){
        $url = $this->api->getUrl('syncOverviewReportDownload');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function downloadOverViewReportSync($headers){
        $url = $this->api->getUrl('overViewReportSync');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAllPolicyName($headers){
//      $url = $this->api->getUrl('getAllPolices');
	    $url = $this->api->getUrl('newBackup');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
     }

}