<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/**
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Class User
 * @package Models
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Device extends Model{

    /**
     * Constructing the parent
     */
    public function __construct(){
        parent::__construct();
        $this->log('Device Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function userDevicePolicyInfo($headers){
        $url = $this->api->getUrl('userDevicePolicyInfo');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $folder
     * @return array
     */
    public function addInclusionFolder($headers, $folder){
        $url = $this->api->getUrl('addInclusionFolder');
        KLogger::req($url,$headers,$folder);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $folder);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function removeInclusionFolder($headers){
        $url = $this->api->getUrl('removeInclusionFolder');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $folder
     * @return array
     */
    public function addExclusionFolder($headers, $folder){
        $url = $this->api->getUrl('addExclusionFolder');
        KLogger::req($url,$headers,$folder);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $folder);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function removeExclusionFolder($headers){
        $url = $this->api->getUrl('removeExclusionFolder');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllDevices($headers){
        $url = $this->api->getUrl('listOfDevices');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function searchInDevices($headers){
        $url = $this->api->getUrl('searchDevices');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $device
     * @param $userName
     * @return array
     */
    public function blockUnBlockDevice($headers, $deviceUUID, $action){
        $this->log('XMl Data:' . $action, 'info');
        $url = $this->api->getParacloudUrl('blockUnBlockDevice', array('deviceUUID' => $deviceUUID, 'toBlock' => $action));
        //KLogger::req($url,$headers,$device);
        $this->log("URL : ".$url,"info");
        $this->curl->setHeaders($headers);
        $this->curl->put($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function blockDevices($headers, $data){
        $url = $this->api->getParacloudUrl('blockDevices');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('URL: '. $url, 'info');
        $this->log('DATA: '. $data, 'info');
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Resultfffff: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $device
     * @param $userName
     * @return array
     */
    public function deleteDevice($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('deleteDevice', array('deviceUUID' => $deviceUUID));
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $userName
     * @return array
     */
    public function blockUnBlockMultipleDevice($headers, $data){
        $url = $this->api->getParacloudUrl('blockUnBlockDevices');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->put($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $userName
     * @return array
     */
    public function deleteMultipleDevices($headers, $data){
        $url = $this->api->getParacloudUrl('deleteDevices');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->put($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getEventHub($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('getEventHub', array('deviceUUID' => $deviceUUID));
        KLogger::req($url,$headers,$deviceUUID);
        $this->log('Result_url'.json_encode($url), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function saveEventHub($headers, $data){
        $url = $this->api->getParacloudUrl('saveEventHub');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('Result_headers'.json_encode($headers), 'info');
        $this->log('Result_data'.json_encode($data), 'info');
        $this->log('Result_url'.json_encode($url), 'info');
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
}
