<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Backup extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Backup Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFiles($headers){
        $url = $this->api->getUrl('backupFiles');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $userName
     * @return array
     */
    public function getDevices($headers, $userName){
        $url = $this->api->getUrl('backupDevices', array('userName' => $userName));
        KLogger::req($url,$headers,userName);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('url: '.$url, 'info');
        $this->log('result: '.json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFileVersions($headers){
        $url = $this->api->getUrl('backupFileVersions');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFileChunks($headers){
        $url = $this->api->getUrl('fileChunks');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $dataString
     * @return array
     */
    public function backupFileDelete($headers, $dataString){
        $url = $this->api->getUrl('backupFileDelete');
        KLogger::req($url,$headers,$dataString);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url, $dataString);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function download($headers)
    {
        $pms = new Pms();
        $blukrypts = $pms->getAllBlukrypts(array('Content-Type' => 'application/json', 'token' => $_SESSION['token']));
        if(!empty($headers['blukryptIp'])){
            $blukryptIP = $headers['blukryptIp'];
        }else if(!empty($blukrypts['body']->{'privacyGatewayElementList'})){
            $blukryptIP = $blukrypts['body']->{'privacyGatewayElementList'}[0]->{"gatewayName"};
        }else{
            $blukryptIP = BLUKRYPT_IP;
        }
        $url = PROTOCOL.$blukryptIP.BLUKRPT_URL_WITHOUT_IP.$_SESSION['cloudName'].DS.'portal'.DS.'download'.DS.'files'.DS;
        $url = $url.$this->getStringForGetFromArray($headers);
        KLogger::req($url,$headers,$data);
        $this->log("url: ".$url, "info");
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function searchInDevices($headers){
        $url = $this->api->getUrl('searchDevices');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllDevices($headers){
        $url = $this->api->getUrl('listOfDevices');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $elements
     * @return array
     */
    public function shareFile($headers, $elements){
        $url = $this->api->getUrl('syncFileShare');
        KLogger::req($url,$headers,$elements);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $elements);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 302) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $elements
     * @return array
     */
    public function updateSharePolicy($headers, $elements){
        $url = $this->api->getUrl('updateSharePolicy');
        KLogger::req($url,$headers,$elements);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $elements);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 302) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @param $policyName
     * @return array
     */
    public function getPolicy($headers, $policyName){
        $url = $this->api->getUrl('getPolicy', array('policyName' => $policyName));
        KLogger::req($url,$headers,$policyName);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function isSharedOrNot($headers){
        $url = $this->api->getUrl('isSharedOrNot');
        KLogger::req($url,$headers,$policyName);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $xml
     * @return array
     */
    public function unShare($headers, $xml){
        $url = $this->api->getUrl('unShare');
        KLogger::req($url,$headers,$policyName);
        $this->curl->setHeaders($headers);
        $this->log(json_encode($headers), 'info');
        $this->curl->post($url, $xml);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

}