<?php

namespace Core;

use Core\View;
use Core\Language;
use \Helpers\PhpMailer\Mail;
use \Helpers\Session;
use \Helpers\Csrf;
use \Helpers\Auth;
use Helpers\Validator;
use Core\Logger;

/**
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 * Class Controller - Base Controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.2
 * @date July 27, 2015
 * @date updated August 17 2015
 * @package Core
 *
 */

abstract class Controller
{
    /**
     * view variable to use the view class
     * @var string
     */
    public $view;

    /**
     * @var \Core\Language
     */
    public $language;

    /**
     * @var Mail
     */
    public $mail;

    /**
     * @var Session
     */
    public $session;

    /**
     * @var Auth
     */
    public $auth;

    /**
     * @var Validator
     */
    public $valid;

    /**
     * @var CSRF Token
     */
    public $csrfToken;

    /**
     * Creates all that you want :p
     */
    public function __construct()
    {
        $this->view     = new View();
        $this->language = new Language();
        $this->mail     = new Mail();
        $this->session  = new Session();
        $this->auth     = new Auth();
        $this->valid    = new Validator();
    }

    /**
     * Below method Verifies the CSRF Token
     */
    public function verifyAndCleanItUp(){
        if(!empty($_POST)){
            if(!empty($_POST['csrf_token']) && $_POST['csrf_token'] == $this->session->get('csrf_token')){
                $_POST = $this->valid->sanitize($_POST);
            }else{
                $result = array(
                    'result' => 'fail',
                    'msg' => 'Token has been expired please try submitting the form again'
                );
                echo json_encode($result);
                exit;
            }
        }
    }

    /**
     * Below method sets csrf token
     * @return string
     */
    public function setCSRFToken(){
        return Csrf::makeToken();
    }

    /**
     * Clears the CSRF Token that has been set
     */
    public function clearCsrfToken(){
        $this->session->put('csrf_token', '');
        $this->session->put('csrf_token_time', '');
    }

    /**
     * Below method is used to log things
     *
     * @param $log
     * @param $type
     */
    public function log($log, $type = 'ERROR'){
        $type = strtoupper($type);
        Logger::$type($log);
    }

    /**
     * Below Method is used to check if an obj
     * exists in a array of objs
     *
     * @param $key
     * @param $keys
     * @return bool
     */
    public function checkIfExists($key, $keys){
        if(!empty($keys)){
            foreach($keys as $value){
                if($value->{'gatewayName'} == $key){
                    return true;
                }
            }
            return false;
        }else{
            return false;
        }
    }

}
