<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Auth;
use Helpers\Url;
use Models\Sync;
use Models\User;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class SyncController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('sync');
        $this->_model = new Sync();

    }

    public function files(){
        $this->session->put('selectedPaths', null);
        if(!empty(CUSTOM_SYNC_NAME)){
            $title = CUSTOM_SYNC_NAME;
        }else{
            $title = $this->language->get('indexPageName');
        }
        $policy = $this->getUserSyncPolicy();
        $data = array(
            'title' => $title,
            'csrf_token' => $this->setCSRFToken(),
            'crumb1' => $this->language->get('files'),
            'active' => 'sync',
            'policy' => $policy,
            'loggedInUser' => $this->session->all()
        );
        
        if($this->session->get('readOnlyAdmin') == "1" || $this->session->get('admin') == "1"){
            $lastLoginTime = "nil";
            $data['lastLoginTime'] = $lastLoginTime;
        }else{
            if($this->session->get('lastLoggedInTime') != ""){
                $lastLoginTime = date('d-M-y H:i:s', ((int)$this->session->get('lastLoggedInTime')/1000));
                $data['lastLoginTime'] = $lastLoginTime;
        }
}

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('sync/files', $data);
        View::renderTemplate('footer', $data);
    }

    public function getAllFiles(){
        if(empty($_POST) && empty($_POST['filePath'])) {
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            exit;
        }
        $_POST['filePath'] = rtrim($_POST['filePath'], '/');
        if($_POST['refresh'] == 'true'){
            $filePath = (!empty($this->session->get('syncFilePath'))) ? $this->session->get('syncFilePath') : 'ParaBlu';
        }else{
            $filePath = ($_POST['filePath'] == 'root') ? 'ParaBlu' : $_POST['filePath'];
        }
        $headers = array(
            'Content-Type'  => 'application/json',
            'path'          => htmlspecialchars_decode($filePath),
            'skipValue'     => 0,
            'token'         => $this->session->get('token')
        );
        $result = $this->_model->getFiles($headers);
        switch ($result['status']) {
            case (200):
                $items = array();
                if(!empty($result['body']->{'file'})){
                    foreach($result['body']->{'file'} as $value){

                        if($value->{'is-minicloud'} == 'true'){
                            $selectable = (string)$value->{'file-user'} == $this->session->get('userName') ? 'yes': 'no';
                            $clouds = array(
                                'exists' => (string)$value->{'exists'},
                                'filePath' => (string)$value->{'file-path'},
                                'fileName' => (string)$value->{'file-name'},
                                'fileRevisionId' => (string)$value->{'file-revision-id'},
                                'fileUser' => (string)$value->{'file-user'},
                                'gatewayName' => (string)$value->{'gatewayName'},
                                'type' => 'Mini Cloud',
                                'icon' => 'cloud',
                                'selectable' => $selectable,
                                //'modifiedTime' => (!empty($value->{'modified-timestamp'}) && $value->{'modified-timestamp'} !== '0') ? date('d-M-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)) : '',
                                'modifiedTime' => (int)$value->{'modified-timestamp'},
                                'size' => (string)$value->{'size'},
                                'isMinicloud' => (string)$value->{'is-minicloud'},
                                'storagePlace' => (string)$value->{'storagePlace'}
                            );
                            $items = array_merge(array($clouds), $items);
                        }elseif($value->{'folder'} == 'true'){
                            $folder = array(
                                'exists' => (string)$value->{'exists'},
                                'filePath' => (string)$value->{'file-path'},
                                'fileName' => (string)$value->{'file-name'},
                                'fileRevisionId' => (string)$value->{'file-revision-id'},
                                'fileUser' => (string)$value->{'file-user'},
                                'gatewayName' => (string)$value->{'gatewayName'},
                                'type' => 'Folder',
                                'icon' => 'folder',
                                'selectable' => 'yes',
                                //'modifiedTime' => (!empty($value->{'modified-timestamp'}) && $value->{'modified-timestamp'} !== '0') ? date('d-M-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)) : '',
                                'modifiedTime' => (int)$value->{'modified-timestamp'},
                                'size' => (string)$value->{'size'},
                                'isMinicloud' => (string)$value->{'is-minicloud'},
                                'storagePlace' => (string)$value->{'storagePlace'}
                            );
                            $items = array_merge(array($folder), $items);
                        }else{
                            $selectable = 'yes';
                            $fileExt = explode('.', (string)$value->{'file-name'});
                            $file = array(
                                'exists' => (string)$value->{'exists'},
                                'filePath' => (string)$value->{'file-path'},
                                'fileName' => (string)$value->{'file-name'},
                                'fileRevisionId' => (string)$value->{'file-revision-id'},
                                'fileUser' => (string)$value->{'file-user'},
                                'gatewayName' => (string)$value->{'gatewayName'},
                                'type' => 'File',
                                'selectable' => $selectable,
                                'icon' => $this->getFileIcon(end($fileExt)),
                                //'modifiedTime' => (!empty($value->{'modified-timestamp'}) && $value->{'modified-timestamp'} !== '0') ? date('d-M-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)) : '',
                                'modifiedTime' =>(int) $value->{'modified-timestamp'},
                                'rawSize' => (int)$value->{'size'},
                                'size' => $this->getFileSize((string)$value->{'size'}),
                                'isMinicloud' => (string)$value->{'is-minicloud'},
                                'storagePlace' => (string)$value->{'storagePlace'}
                            );
                            $items = array_merge(array($file), $items);
                        }
                    }
                }
                $this->session->put('syncFilePath', $filePath);
                $response = array(
                    'result' => 'success',
                    'items' => $items
                );
                if($_POST['refresh'] == 'true' && !empty($filePath)){
                    $response['crumb'] = explode('/', $filePath);
                    $response['crumbString'] = $filePath;
                }
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (445):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('445')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function upload(){

        if(!empty($_POST['path']) && !empty($_FILES)){

            $headers = array(
                'token'                 => $this->session->get('token'),
                'userName'              => $this->session->get('userName'),
                'Content-type'          => 'application/octet-stream',
                'Content-disposition'   => 'inline;filename='.basename($_FILES['file']['name']),
                'is-exists'             => 'false',
                'file-path'             => htmlspecialchars_decode(rtrim($_POST['path'], '/')),
                'file-name'             => basename($_FILES['file']['name']),
                'file-size'             => basename($_FILES['file']['size']),
                'is-folder'             => 'false',
                'is-base-folder'        => 'false',
                'fileMD5'               => md5_file($_FILES['file']['tmp_name']),
                'modified'              => time()
            );

            $file = @fopen($_FILES['file']['tmp_name'],"rb");
            $fileContent = @fread($file, $_FILES['file']['size']);
            ob_flush();
            flush();
            if (connection_status()!=0){
                @fclose($file);
                http_response_code(404);
                return;
            }

            $result = $this->_model->upload($headers, $fileContent);

            switch ($result['status']) {
                case (200):

                    $fileExt = explode('.', (string)$result['body']->{'bluKryptElement'}->{'fileName'});
                    $file = array(
                        'exists' => 'true',
                        'filePath' => (string)$result['body']->{'bluKryptElement'}->{'filePath'},
                        'fileName' => (string)$result['body']->{'bluKryptElement'}->{'fileName'},
                        'fileRevisionId' => (string)$result['header']->{'container'}->{'syncRevisionId'},
                        'fileUser' => $this->session->get('userName'),
                        'type' => 'File',
                        'icon' => $this->getFileIcon(end($fileExt)),
                        'modifiedTime' => date('d-M-Y h:i:s'),
                        'size' => $this->getFileSize(((int)$result['body']->{'bluKryptElement'}->{'fileSize'}/1024)),
                        'isMinicloud' => 'false',
                        'storagePlace' => ''
                    );

                    $response = array(
                        'result' => 'success',
                        'file' => $file
                    );

                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();

                case (406):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('406')
                    );
                    echo json_encode($result);
                    exit();

                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (0 || 503):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'post' => $_POST,
                    'msg' => $this->language->get('noData')
                )
            );
        }
    }

    public function createFolder(){
        if(!empty($_POST['folderName']) && !empty($_POST['path'])){
            $headers = array(
                'Content-Type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'token' => $this->session->get('token'),
                'path' => htmlspecialchars_decode($_POST['path'].$_POST['folderName'])
            );

            $result = $this->_model->getFileInfo($headers);
            $this->log(json_encode($result), "info");
            if($result['status'] == 404){
                $headers = array(
                    'Content-Type' => 'application/xml',
                    'Accept' => 'application/xml',
                    'Accept-Charset' => 'utf-8',
                    'isCreateFolder' => 'true',
                    'token' => $this->session->get('token'),
                    'userName' => $this->session->get('userName')
                );

                $miniCloudXml = '<file><exists>true</exists><file-path><![CDATA['.htmlspecialchars_decode(rtrim($_POST['path'], '/')).']]></file-path><file-name><![CDATA['.htmlspecialchars_decode($_POST['folderName']).']]></file-name><folder>true</folder></file>';

                $result = $this->_model->createFolder($headers, $miniCloudXml);

                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('folderCreated')
                        );
                        echo json_encode($response);
                        exit;
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (423):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('423')
                        );
                        echo json_encode($result);
                        exit();
                    case (403):

                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('403')
                        );
                        echo json_encode($result);
                        exit();
                    case (445):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('445')
                        );
                        echo json_encode($result);
                        exit();
                        case (411):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('411')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('403')
                );
                echo json_encode($result);
                exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData'),
                    'details' => $_POST,
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getFileVersions(){
        if(!empty($_POST['fileName']) && !empty($_POST['filePath'])){
            $headers = array(
                'token'         => $this->session->get('token'),
                'filePath'      => htmlspecialchars_decode(rtrim($_POST['filePath'], '/')),
                'fileName'      => $_POST['fileName']
            );
            $result = $this->_model->getFileVersions($headers);
            switch ($result['status']) {
                case (200):

                    $fileVersions = [];

                    if($result['body']->{'file'}){
                        foreach($result['body']->{'file'} as $value){
                            $fileVersion = array(
                                'filePath'              => (string)$value->{'file-path'},
                                'fileDevice'            => (string)$value->{'file-device'},
                                'fileName'              => (string)$value->{'file-name'},
                                'fileUser'              => (string)$value->{'file-user'},
                                'folder'                => (string)$value->{'folder'},
                                'modifiedTime'          => (!empty($value->{'modified-timestamp'}) && $value->{'modified-timestamp'} !== '0') ? date('d-M-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)) : '',
                                'checksum'              => (string)$value->{'checksum'},
                                'exists'                => (string)$value->{'exists'},
                                'gatewayName'           => (string)$value->{'gatewayName'},
                                'size'                  => $this->getFileSize((string)$value->{'size'}),
                                'version'               => 'Version ',
                                'revisionId'            => (string)$value->{'file-revision-id'},
                                'comment'               => (string)$value->{'comment'},
                                'status'                => (string)$value->{'status'},
                                'fsPath'                => (string)$value->{'fs-path'}
                            );
                            $fileVersions = array_merge(array($fileVersion), $fileVersions);
                        }
                    }

                    $response = array(
                        'result' => 'success',
                        'fileVersions' => array_reverse($fileVersions)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'post' => $_POST,
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getUserSyncPolicy(){
        $headers = array(
            'token' => $this->session->get('token'),
            'userName' => $this->session->get('userName')
        );
        $result = $this->_model->getUserSyncPolicy($headers);
        $this->log('result'.json_encode($result), 'info');
        $value = $result['body']->{'syncPolicyElement'};
        $policy = [];
        if(!empty($value)) {
            $policy = array(
                'policygroupName' => (string)$value->{'policygroupName'},
                'osType' => (string)$value->{'osType'},
                'policyRefresh' => (string)$value->{'policyRefresh'},
                //'cloudCredential'       => (string)$value->{'cloudCredential'},
                'maxFileSize' => (string)$value->{'maxFileSize'},
                'pftSize' => (string)$value->{'pftSize'},
                'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                'compressionEnabled' => (string)$value->{'compressionEnabled'},
                'crawlLimit' => (string)$value->{'crawlLimit'},
                'maxVersions' => (string)$value->{'maxVersions'},
                'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
                'vssEnabled' => (string)$value->{'vssEnabled'},
                'cpuUtilization' => (string)$value->{'cpuUtilization'},
                'memoryUtilization' => (string)$value->{'memoryUtilization'},
                'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
                'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                'filterInclusionName' => (string)$value->{'filterInclusionName'},
                'syncInterval' => (string)$value->{'syncInterval'},
                'expiredDate' => (string)$value->{'expiredDate'},
                'shareEnabled' => (string)$value->{'shareEnabled'},
                'syncEnableAutomatic' => (string)$value->{'syncEnableAutomatic'},
                'twoWayShareEnabled' => (string)$value->{'twoWayShareEnabled'},
                'complexPasswordRequired' => (string)$value->{'complexPasswordRequired'},
                'preventDownloadEnabled' => (string)$value->{'preventDownloadEnabled'},
                'highSecureShareEnabled' => (string)$value->{'highSecureShareEnabled'},
                'contentIndexEnabled' => (string)$value->{'contentIndexEnabled'},
                'deDuplicationEnabled' => (string)$value->{'deDuplicationEnabled'},
                'dcmEnabled' => (string)$value->{'dcmEnabled'},
                'pftEnabled' => (string)$value->{'pftEnabled'},
                'inclusionFilterElement' => (array)$value->{'inclusionFilterElement'},
                'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
                'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
            );
        }
        return $policy;
    }

    public function getFileChunks(){
        if(!empty($_POST['fileName']) && !empty($_POST['filePath'])){
            $headers = array(
                'token'         => $this->session->get('token'),
                'backupId'      => $_POST['backupId'],
                'userName'      => $_POST['userName']
            );
            $result = $this->_model->getFileChunks($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'fileVersions' => $result
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'post' => $_POST,
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function saveFileRevisionComments(){
        if(!empty($_POST['revisionId']) && !empty($_POST['comments'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),
                'revisonId'     => $_POST['revisionId'],
                'comment'       => $_POST['comments']
            );
            $result = $this->_model->saveFileRevisionComments($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('commentsSaved')
                    );
                    echo json_encode($response);
                    exit;
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function saveRename(){
        if(!empty($_POST['path']) && !empty($_POST['changedName'])){
            $headers = array(
                'Content-Type'      => 'application/xml',
                'Accept'            => 'application/xml',
                'Accept-Charset'    => 'utf-8',
                'token'             => $this->session->get('token'),
                'path'              => htmlspecialchars_decode($_POST['path'].$_POST['fileName']),
                'newFileName'       => $_POST['changedName']
            );

            $result = $this->_model->saveRename($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('nameSaved')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (411):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('411')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function download(){
        if(!empty($_GET['path'])){
            $headers = array(
                'Content-Type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'token' => $this->session->get('token'),
                'path' => htmlspecialchars_decode($_GET['path'].$_GET['fileName'])
            );

            $result = $this->_model->getFileInfo($headers);

            switch ($result['status']) {
                case (200):

                    $headers['file-name'] = (string)$result['body']->{'file-name'};
                    $headers['file-path'] = (string)$result['body']->{'file-path'};
                    $headers['userName'] = $this->session->get('userName');
                    $headers['syncRevisionId'] = !empty($_GET['syncRevisionId']) ? $_GET['syncRevisionId'] : (string)$result['body']->{'file-revision-id'};
                    $downloadResult = $this->_model->download($headers);

                    if($downloadResult['code'] != 449){

                        header("Pragma: public");
                        header("Expires: 0");
                        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                        header("Cache-Control: private",false);
                        header("Content-Type: application/octet-stream");
                        header('Content-Disposition: attachment; filename="'.(string)$result['body']->{'file-name'}.'"');
                        header("Content-Transfer-Encoding: binary");
                        header('Content-Length: '.$downloadResult['header']['file-size']);

                        ob_clean();
                        print $downloadResult['body'];
                        exit;
                    }else{
                        header('Location: '.Url::basePath('sync/files'));
                    }
                    break;
                case (421):
                    header('Location: '.Url::basePath('sleep'));
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500 || 0):
                    header('Location: '.Url::basePath('serviceDown'));
                    exit();
                default:
                    header('Location: '.Url::basePath('404'));
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'post' => $_POST,
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function deleteFilesFolders(){
        if(!empty($_POST['pathsToDelete'])){
            $headers = array(
                'Content-Type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName'),
                'selectedPaths'     => implode('|', $_POST['pathsToDelete'])
            );

            $result = $this->_model->deleteFilesFolders($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => !empty($_POST['type'] == 'files') ? $this->language->get('filesDeleted') : $this->language->get('foldersDeleted')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function shareFile(){

        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'forceShare'        => 'true',
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName')
            );
            $fileParam 	= explode('/', $_POST['filePath']);
            $miniCloudResult = $this->_model->checkForMiniCloud($headers, $fileParam[1]);
            if($miniCloudResult == 200){
                $miniCloudName = $fileParam[1];
            }else{
                $miniCloudName = '';
            }

            $shareElements = array(
                'userName' => $this->session->get('userName'),
                'cloudName' => $this->session->get('cloudName'),
                'miniCloudName' => $miniCloudName,
                'devicePath' => $_POST['filePath'],
                'fileName' => $_POST['fileName'],
                'passwordProtected' => (string)$_POST['isPasswordProtected'],
                'passwordHash' => !empty($_POST['isPasswordProtected'] == true) ? md5($_POST['password']) : '',
                'validUntil' =>  !empty($_POST['validTill']) ? (strtotime($_POST['validTill']." +1 day")*1000) : (strtotime("now"." +36500 days")*1000),
                'download' => (string)$_POST['download'],
                'view' => (string)$_POST['view']
            );

            $result = $this->_model->shareFile($headers, $shareElements);

            switch ($result['status']) {
                case (200):
                    $shared = $result['body']->{'sharedFileImageElement'};
                    if($shared->{'passwordProtected'} == true){
                        $type = md5('protected');
                    }else{
                        $type = md5('read');
                    }
                    $link = SHARE_PATH.$type.DS.$shared->{'key12'}.DS.$shared->{'key14'}.DS.$shared->{'key18'}.DS.$shared->{'key20'};

                    $response = array(
                        'result' => 'success',
                        'link' => $link,
                        'data' => $result['body']->{'sharedFileImageElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function shareFileWith(){
        if(!empty($_POST)){
            $type = md5('read');
            if($_POST['allowAllUsers'] == 'true'){
                $allowAllUsers = 'true';
            }
            else{
                $allowAllUsers = 'false';
            }
            $headers = array(
                'Content-Type'      => 'application/json',
                'forceShare'        => 'true',
                'fileName'          => $_POST['fileName'],
                'downloadLink'      => Url::basePath('share/filesSharedWithMe'),
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName'),
                'shareWithLink'     => SHARE_PATH.$type.DS,
                'allowAllUsers'     => $allowAllUsers

            );
            $fileParam 	= explode('/', $_POST['filePath']);
            $miniCloudResult = $this->_model->checkForMiniCloud($headers, $fileParam[1]);
            if($miniCloudResult == 200){
                $miniCloudName = $fileParam[1];
            }else{
                $miniCloudName = '';
            }

            $shareElements = array(
                'userName' => $this->session->get('userName'),
                'cloudName' => $this->session->get('cloudName'),
                'miniCloudName' => $miniCloudName,
                'devicePath' => $_POST['filePath'],
                'fileName' => $_POST['fileName'],
                'emailMessage' => $_POST['message'],
                'emailSubject' => $_POST['subject'],
                'userShareList' => $_POST['userShareList'],
                'passwordProtected' => 'false',
                'passwordHash' => !empty($_POST['password'] == true) ? base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_128, md5('a9985ebcae81'), $_POST['password'], MCRYPT_MODE_CFB, '26ac50996c66634c')) : '',
                'validUntil' =>  !empty($_POST['validTill']) ? (strtotime($_POST['validTill']." +1 day")*1000) : (strtotime($_POST['validTill']." +36500 days")*1000),
                'download' => (string)$_POST['download'],
                'twoWayShareEnabled' => (string)$_POST['twoWayShareEnabled'],
                'view' => (string)$_POST['view']
            );
            $this->log('PASSWORD: '. $_POST['password'], 'info');
            $result = $this->_model->shareFileWith($headers, $shareElements);

            $this->log('SaveShareWithResult: '. json_encode($result), 'info');

            switch ($result['status']) {
                case (200):
                    $shared = $result['body']->{'sharedFileImageElement'};
                    if($shared->{'passwordProtected'} == true){
                        $type = md5('protected');
                    }else{
                        $type = md5('read');
                    }
                    $link = SHARE_PATH.$type.DS.$shared->{'key12'}.DS.$shared->{'key14'}.DS.$shared->{'key18'}.DS.$shared->{'key20'};

                    $response = array(
                        'result' => 'success',
                        'link' => $link,
                        'unAssignedUsers' => $result['header'],
                        'data' => $result['body']->{'sharedFileImageElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (409):
                    $result = array(
                        'result' => 'fail',
                        'unAssignedUsers' => $result['header'],
                        'msg' => 'File sharing was unsuccessful'
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    public function updateSharePolicy(){

        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'forceShare'        => 'true',
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName')
            );
            $fileParam 	= explode('/', $_POST['filePath']);
            $miniCloudResult = $this->_model->checkForMiniCloud($headers, $fileParam[1]);
            if($miniCloudResult == 200){
                $miniCloudName = $fileParam[1];
            }else{
                $miniCloudName = '';
            }
            list($key12, $key14, $key18, $key20) = explode('+', $_POST['key']);
            $shareElements		= array(
                'userName' => $this->session->get('userName'),
                'cloudName' => $this->session->get('cloudName'),
                'miniCloudName' => $miniCloudName,
                'devicePath' => htmlspecialchars_decode($_POST['filePath']),
                'fileName' => $_POST['fileName'],
                'passwordProtected' => (string)$_POST['isPasswordProtected'],
                'passwordHash' => !empty($_POST['isPasswordProtected'] == true) ? md5($_POST['password']) : '',
                'validUntil' =>  (strtotime($_POST['validTill']." +1 day")*1000),
                'download' => (string)$_POST['download'],
                'key12' => $key12,
                'key14' => $key14,
                'key18' => $key18,
                'key20' => $key20,
                'view' => (string)$_POST['view']
            );

            $result = $this->_model->updateSharePolicy($headers, $shareElements);

            switch ($result['status']) {
                case (200):
                    $shared = $result['body']->{'sharedFileImageElement'};
                    if($shared->{'passwordProtected'} == true){
                        $type = md5('protected');
                    }else{
                        $type = md5('read');
                    }
                    $link = SHARE_PATH.$type.DS.$shared->{'key12'}.DS.$shared->{'key14'}.DS.$shared->{'key18'}.DS.$shared->{'key20'};

                    $response = array(
                        'result' => 'success',
                        'link' => $link,
                        'data' => $result['body']->{'sharedFileImageElement'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function isShareCheck(){

        if(!empty($_POST)){
            $stat = $this->collectStats();
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'             => $this->session->get('token')
            );
            if($_POST['type']){
                $headers['osType']  = $this->getOS($_SERVER['HTTP_USER_AGENT']);
                $headers['browser'] = $_SERVER['SERVER_NAME'];
                $headers['ip']      = $stat['remoteAdd'];
                $headers['accessType']    = $_POST['type'];
            }
            $fileParam 	= explode('/', $_POST['filePath']);

            $miniCloudResult = $this->_model->checkForMiniCloud($headers, $fileParam[1]);
            if($miniCloudResult == 200){
                $miniCloudName = $fileParam[1];
            }else{
                $miniCloudName = '';
            }

            $headers['miniCloudName'] = $miniCloudName;
            $headers['devicePath'] = htmlspecialchars_decode($_POST['filePath']);
            $headers['fileName'] = $_POST['fileName'];

            $result = $this->_model->isSharedOrNot($headers);
            if($result['status'] == 302){
                $shared = $result['body']->{'sharedFileImageElement'};
                if($shared->{'passwordProtected'} == true){
                    $type = md5('protected');
                }else{
                    $type = md5('read');
                }
                $link = SHARE_PATH.$type.DS.$shared->{'key12'}.DS.$shared->{'key14'}.DS.$shared->{'key18'}.DS.$shared->{'key20'};
                $isShared = true;
                $shared->{'validUntil'} = !(empty($shared->{'validUntil'})) ? date('m/d/Y', strtotime(date('m/d/y', (((int)$shared->{'validUntil'}) / 1000)) . ' -1 day')) : null;
            }else{
                $shared = array();
                $link = '';
                $isShared = false;
            }

            $response = array(
                'data' => $shared,
                'result' => $isShared,
                'link' => $link
            );
            echo json_encode($response);
            exit;

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function unShare(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName')
            );
            $fileParam 	= explode('/', $_POST['filePath']);
            $miniCloudResult = $this->_model->checkForMiniCloud($headers, $fileParam[1]);
            if($miniCloudResult == 200){
                $miniCloudName = $fileParam[1];
            }else{
                $miniCloudName = '';
            }

            $xml ='<share-info>
				<shared-time><![CDATA['.time().']]></shared-time>
				<user-name><![CDATA['.$this->session->get('userName').']]></user-name>
				<cloud-name><![CDATA['.$this->session->get('cloudName').']]></cloud-name>
				<mini-cloud-name><![CDATA['.$miniCloudName.']]></mini-cloud-name>
				<device-path><![CDATA['.htmlspecialchars_decode($_POST['filePath']).']]></device-path>
				<file-name><![CDATA['.$_POST['fileName'].']]></file-name>
				<is-password-protected>false</is-password-protected>
				<password-hash></password-hash>
			</share-info>';


            $result = $this->_model->unShare($headers, $xml);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('fileUnshared'),
                        'data' => $result
                    );
                    echo json_encode($response);
                    exit;

                case (204):

                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('fileWasNotShared')
                    );
                    echo json_encode($result);
                    exit();

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function cut(){
        if(!empty($_POST['pathsToCut']) && !empty($_POST['currentPath'])){
            $this->session->put('selectedPaths', $_POST['pathsToCut']);
            $this->session->put('fromPath', $_POST['currentPath']);
            $this->session->put('action', 'cut');
            $filesMarkedForCut = $this->session->get('selectedPaths');
            if(!empty($filesMarkedForCut)){
                echo json_encode(array(
                        'result' => 'success',
                        'msg' => $this->language->get('CutSuccess')
                    )
                );
            }else{
                echo json_encode(array(
                        'result' => 'failed',
                        'msg' => $this->language->get('cannotCut')
                    )
                );
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
        }
    }

    public function copy(){
        if(!empty($_POST['pathsToCopy']) && !empty($_POST['currentPath'])){
            $this->session->put('selectedPaths', $_POST['pathsToCopy']);
            $filesMarkedForCopy = $this->session->get('selectedPaths');
            $this->session->put('fromPath', $_POST['currentPath']);
            $this->session->put('action', 'copy');
            if(!empty($filesMarkedForCopy)){
                echo json_encode(array(
                        'result' => 'success',
                        'msg' => $this->language->get('CopySuccess')
                    )
                );
            }else{
                echo json_encode(array(
                        'result' => 'failed',
                        'msg' => $this->language->get('cannotCopy')
                    )
                );
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
        }
    }

    public function paste(){
        if(!empty($_POST['destination'])){
            if($_POST['destination'] == $this->session->get('fromPath')){
                echo json_encode(array('result' => 'fail', 'msg' => 'Cannot '.$this->session->get('action').' and paste in the same folder'));
                exit;
            }
            $headers = array(
                'selectedPaths'     => implode('|', $this->session->get('selectedPaths')),
                'destinationPath'   => htmlspecialchars_decode(rtrim($_POST['destination'], '/')),
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName')
            );

            $this->log("Headers ".json_encode($headers), "info");
            $this->log("selectedPaths ".$this->session->get('selectedPaths'), "info");
            $result = $this->_model->cutCopy($headers, $this->session->get('selectedPaths'), $this->session->get('action'));

            switch ($result['status']) {
                case (200):
                    $this->session->put('selectedPaths', null);
                    $response = array(
                        'result' => 'success',
                        'action' => $this->session->get('action'),
                        'msg' => $this->language->get('pasteSuccess')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();

                case (411):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('411')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function checkForFilesCopiedOrCut(){
        $selectedFiles = $this->session->get('selectedPaths');
        if(!empty($selectedFiles)){
            $data = array(
                'action' => $this->session->get('action'),
                'files' => $selectedFiles,
                'fromPath' => $this->session->get('fromPath'),
                'result' => 'success'
            );
        }else{
            $data = array(
                'result' => 'fail'
            );
        }
        echo json_encode($data);
        exit;
    }

    public function trash(){
        if(!empty(CUSTOM_SYNC_NAME)){
            $title = CUSTOM_SYNC_NAME;
        }else{
            $title = $this->language->get('indexPageName');
        }
        $data = array(
            'title' => $title,
            'csrf_token' => $this->setCSRFToken(),
            'crumb1' => $this->language->get('trash'),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('sync/trash', $data);
        View::renderTemplate('footer', $data);
    }

    public function getDeletedFiles(){
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            exit;
        }

        $headers = array(
            'Content-Type'      => 'application/xml',
            'Accept'            => 'application/xml',
            'Accept-Charset'    => 'utf-8',
            'pageNumber'        => 0,
            'rows'              => 1000,
            'token'             => $this->session->get('token')
        );
        if($this->session->get('admin') == 'true'){
            $headers['userName'] = $this->session->get('userName');
        }
        $result = $this->_model->getDeletedFiles($headers);

        switch ($result['status']) {
            case (200):
                $items = array();
                if(!empty($result['body']->{'file'})){
                    foreach($result['body']->{'file'} as $value){
                        if($value->{'is-minicloud'} == 'true'){
                            $clouds = array(
                                'exists' => (string)$value->{'exists'},
                                'filePath' => (string)$value->{'file-path'},
                                'fileName' => (string)$value->{'file-name'},
                                'fileRevisionId' => (string)$value->{'file-revision-id'},
                                'fileUser' => (string)$value->{'file-user'},
                                'type' => 'Mini Cloud',
                                'icon' => 'cloud',
                                'modifiedTime' => (!empty($value->{'modified-timestamp'}) && $value->{'modified-timestamp'} !== '0') ? date('d-M-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)) : '',
                                'size' => (string)$value->{'size'},
                                'isMinicloud' => (string)$value->{'is-minicloud'},
                                'storagePlace' => (string)$value->{'storagePlace'}
                            );
                            $items = array_merge(array($clouds), $items);
                        }elseif($value->{'folder'} == 'true'){
                            $folder = array(
                                'exists' => (string)$value->{'exists'},
                                'filePath' => (string)$value->{'file-path'},
                                'fileName' => (string)$value->{'file-name'},
                                'fileRevisionId' => (string)$value->{'file-revision-id'},
                                'fileUser' => (string)$value->{'file-user'},
                                'type' => 'Folder',
                                'icon' => 'folder',
                                'modifiedTime' => (!empty($value->{'modified-timestamp'}) && $value->{'modified-timestamp'} !== '0') ? date('d-M-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)) : '',
                                'size' => (string)$value->{'size'},
                                'isMinicloud' => (string)$value->{'is-minicloud'},
                                'storagePlace' => (string)$value->{'storagePlace'}
                            );
                            $items = array_merge(array($folder), $items);
                        }else{
                            $fileExt = explode('.', (string)$value->{'file-name'});
                            $file = array(
                                'exists' => (string)$value->{'exists'},
                                'filePath' => (string)$value->{'file-path'},
                                'fileName' => (string)$value->{'file-name'},
                                'fileRevisionId' => (string)$value->{'file-revision-id'},
                                'fileUser' => (string)$value->{'file-user'},
                                'type' => 'File',
                                'icon' => $this->getFileIcon(end($fileExt)),
                                'modifiedTime' => (!empty($value->{'modified-timestamp'}) && $value->{'modified-timestamp'} !== '0') ? date('d-M-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)) : '',
                                'size' => $this->getFileSize((string)$value->{'size'}),
                                'isMinicloud' => (string)$value->{'is-minicloud'},
                                'storagePlace' => (string)$value->{'storagePlace'}
                            );
                            $items = array_merge(array($file), $items);
                        }
                    }
                }
                $response = array(
                    'result' => 'success',
                    'items' => $items
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (445):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('445')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function purgeFile(){
        if(!empty($_POST['pathsToDelete'])){
            $headers = array(
                'Content-Type'      => 'application/xml',
                'Accept'            => 'application/xml',
                'Accept-Charset'    => 'utf-8',
                'selectedPaths'     => implode(',', $_POST['pathsToDelete']),
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName')
            );

            $result = $this->_model->purgeFile($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('filePurged')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function restoreFile(){
        if(!empty($_POST['pathsToDelete'])){
            $headers = array(
                'Content-Type'      => 'application/xml',
                'Accept'            => 'application/xml',
                'Accept-Charset'    => 'utf-8',
                'selectedPaths'     => implode(',', $_POST['pathsToDelete']),
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName')
            );

            $result = $this->_model->restoreFile($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('fileRestored')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function purgeAll(){

        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/xml',
                'Accept'            => 'application/xml',
                'Accept-Charset'    => 'utf-8',
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName')
            );

            $result = $this->_model->purgeAll($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('filesPurged')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function restoreAll(){

        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/xml',
                'Accept'            => 'application/xml',
                'Accept-Charset'    => 'utf-8',
                'selectedPaths'     => '',
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName')
            );
            $result = $this->_model->restoreAll($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('filesRestored')
                    );
                    echo json_encode($response);
                    exit;
                case (425):

                    $response = array(
                        'result' => 'notNow',
                        'msg' => $this->language->get('filesRestoreBack')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function myShares(){
        $data = array(
            'title' => $this->language->get('My Shares'),
            'csrf_token' => $this->setCSRFToken(),
            'crumb1' => $this->language->get('myShares'),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('sync/myShare', $data);
        View::renderTemplate('footer', $data);
    }

    public function getSharedFiles(){
        if(!empty($_POST)){

            $headers = array(
                'Content-Type'      => 'application/xml',
                'Accept'            => 'application/xml',
                'Accept-Charset'    => 'utf-8',
                'userName'          => $this->session->get('userName'),
                'token'             => $this->session->get('token')
            );
            if($this->session->get('admin') == 'true'){
                $headers['userName'] = $this->session->get('userName');
            }
            $result = $this->_model->getSharedFiles($headers);
            $this->log(json_encode($result), "info");
            switch ($result['status']) {
                case (200):
                    $items = array();
                    if(!empty($result['body']->{'share-info'})){
                        foreach($result['body']->{'share-info'} as $value){
                            $fileExt = explode('.', (string)$value->{'file-name'});
                            $file = array(
                                'icon' => $this->getFileIcon(end($fileExt)),
                                'isBackup' => (string)$value->{'is-backup'},
                                'cloudName' => (string)$value->{'cloud-name'},
                                'devicePath' => (string)$value->{'device-path'},
                                'isDownload' => (string)$value->{'is-download'},
                                'backupID' => (string)$value->{'backup-id'},
                                'deviceUUID' => (string)$value->{'device-uuid'},
                                'deviceID' => (string)$value->{'device-id'},
                                'deviceName' => (string)$value->{'device-name'},
                                'fileName' => (string)$value->{'file-name'},
                                'fileSysPath' => (string)$value->{'file-sys-path'},
                                'fileId' => (string)$value->{'file-id'},
                                'isSharedForDownload' => (string)$value->{'is-shared-for-download'},
                                'isPasswordProtected' => (string)$value->{'is-password-protected'},
                                'miniCloudName' => (string)$value->{'mini-cloud-name'},
                                'sharedTimeDate' => (string)$value->{'shared-time-date'},
                                'validUntil' => (string)$value->{'valid-until'},
                                'isView' => (string)$value->{'is-view'},
                                'sharedTime' => (!empty($value->{'shared-time'}) && $value->{'shared-time'} !== '0') ? date('d-M-Y h:i:s', (((int)$value->{'shared-time'}) / 1000)) : ''
                            );
                            $items = array_merge(array($file), $items);
                        }
                    }
                    $response = array(
                        'result' => 'success',
                        'items' => $items
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function filesSharedWithMe(){
        if(!empty(CUSTOM_SYNC_NAME)){
            $title = CUSTOM_SYNC_NAME;
        }else{
            $title = $this->language->get('indexPageName');
        }
        $data = array(
            'title' => $title,
            'csrf_token' => $this->setCSRFToken(),
            'crumb1' => $this->language->get('filesSharedWithMe'),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('sync/sharedWithMe', $data);
        View::renderTemplate('footer', $data);
    }

    public function getFilesSharedWithMe(){
        if(!empty($_POST)){

            $headers = array(
                'Content-Type'      => 'application/xml',
                'Accept'            => 'application/xml',
                'Accept-Charset'    => 'utf-8',
                'userName'          => $this->session->get('userName'),
                'token'             => $this->session->get('token')
            );
            if($this->session->get('admin') == 'true'){
                $headers['userName'] = $this->session->get('userName');
            }
            $result = $this->_model->getFilesSharedWithMe($headers);
            $this->log('resultSharedWithMeFiles: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $items = array();
                    if(!empty($result['body']->{'share-info'})){
                        foreach($result['body']->{'share-info'} as $value){
                            $fileExt = explode('.', (string)$value->{'file-name'});
                            $file = array(
                                'icon' => $this->getFileIcon(end($fileExt)),
                                'isBackup' => (string)$value->{'is-backup'},
                                'cloudName' => (string)$value->{'cloud-name'},
                                'devicePath' => (string)$value->{'device-path'},
                                'isDownload' => (string)$value->{'is-download'},
                                'gatewayName' => (string)$value->{'gatewayName'},
                                'fileName' => (string)$value->{'file-name'},
                                'userName' => (string)$value->{'user-name'},
                                'sharedBy' => (string)$value->{'sharedBy'},
                                'fileSysPath' => (string)$value->{'file-sys-path'},
                                'fileId' => (string)$value->{'file-id'},
                                'syncRevisionID' => (string)$value->{'sync-revision-id'},
                                'isSharedForDownload' => (string)$value->{'is-shared-for-download'},
                                'isPasswordProtected' => (string)$value->{'is-password-protected'},
                                'miniCloudName' => (string)$value->{'mini-cloud-name'},
                                'sharedTimeDate' => (string)$value->{'shared-time-date'},
                                'validUntil' => ((string)$value->{'valid-until'} == 0) ? '-' : date('m/d/Y', strtotime(date('m/d/y', (((int)$value->{'valid-until'}) / 1000)) . ' -1 day')),
                                'isView' => (string)$value->{'is-view'},
                                'sharedTime' => (!empty($value->{'shared-time'}) && $value->{'shared-time'} !== '0') ? date('d-M-Y h:i:s', (((int)$value->{'shared-time'}) / 1000)) : ''
                            );
                            $items = array_merge(array($file), $items);
                        }
                    }
                    $response = array(
                        'result' => 'success',
                        'asdasd' => $result,
                        'items' => $items
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function sendShareEmail(){
        if(!empty($_POST)){

            $headers = array(
                'Content-Type'      => 'application/json',
                'token'             => $this->session->get('token'),
                'toEmailList'       => $_POST['emails'],
                'downloadLink'      => $_POST['url'],
                'fileName'          => $_POST['fileName'],
            );
            $result = $this->_model->sendShareEmail($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => 'Mail has been sent Successfully'
                    );
                    echo json_encode($response);
                    exit;
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getSearchResults(){
        if(Auth::checkCloudPermission('sync') == false){
            echo json_encode(array('result' => 'noData','message' => $this->language->get('noData')));
            exit;
        }
        if(!empty($_POST)){

            $headers = array(
                'token'     => $this->session->get('token'),
                'file-name' => $_POST['text'],
                'start' => 0,
                'rows' => 500,
                'file-path' => !(empty($_POST['filePath'])) ? $_POST['filePath'] : 'ParaBlu'
            );

            $result = $this->_model->getSearchResults($headers, 'searchFiles');
            $this->log('result'. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $files = array();

                    $resultFiles = new \SimpleXMLElement($result['body']);

                    foreach($resultFiles as $value){
                        $file = array(
                            'exists' => (string)$value->{'exists'},
                            'fileName' => (string)$value->{'file-name'},
                            'filePath' => (string)$value->{'file-path'},
                            'folder' => (string)$value->{'folder'},
                            'fileRevisionID' => (string)$value->{'file-revision-id'},
                            'content' => (string)$value->{'meta-data'},
                            'modifiedTimestamp' => (int)$value->{'modified-timestamp'},
                            'size' => (int)$value->{'size'},
                        );

                        $files = array_merge(array($file), $files);

                    }

                    $response = array(
                        'result' => 'success',
                        'files'  => $files
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','message' => $this->language->get('noData')));
        }
    }

    public function goToPath(){
        if(!empty($_POST)){
            if(!empty($_POST['filePath'])){
                $this->session->put('syncFilePath', $_POST['filePath']);
                echo json_encode(array('result' => 'success'));
            }else{
                echo json_encode(array('result' => 'error','message' => $this->language->get('noData')));
            }
        }else{
            echo json_encode(array('result' => 'error','message' => $this->language->get('noData')));
        }
    }

    public function openFileLocation(){
        if($_GET['filePath']){
            $this->session->put('syncFilePath', htmlentities($_GET['filePath']));
            Url::redirect('sync/files');
        }else{
            Url::redirect('404');
        }
    }

    public function createMiniCloud(){
        if(!empty($_POST['miniCloudName'])){
            $headers = array(
                'Content-Type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'token' => $this->session->get('token'),
                'userName' => $this->session->get('userName')
            );

            $miniCloudXml = '<mini-cloud><mini-cloud-name>'.htmlentities($_POST['miniCloudName']).'</mini-cloud-name></mini-cloud>';

            $result = $this->_model->createMiniCloud($headers, $miniCloudXml);

            switch ($result['status']) {
                case (200):

                    $miniCloud = array(
                        'exists' => 'true',
                        'filePath' => 'ParaBlu',
                        'fileName' => htmlentities($_POST['miniCloudName']),
                        'fileRevisionId' => '',
                        'fileUser' => $this->session->get('userName'),
                        'type' => 'Mini Cloud',
                        'icon' => 'cloud',
                        'modifiedTime' => date('d-M-Y h:i:s'),
                        'size' => '-',
                        'isMinicloud' => 'true',
                        'storagePlace' => ''
                    );

                    $userData = $this->_model->getUserData(array('token' => $this->session->get('token')), $this->session->get('userName'));

                    $xml 	= new \SimpleXMLElement($userData['body']);
                    $mcs    = $xml->{'mini-clouds'}[0];
                    $mcs->addChild('mini-cloud')->addChild('mini-cloud-name', $_POST['miniCloudName']);
                    $userDetails 	= $xml->asXML();

                    $user = new User();
                    $userUpdateResult = $user->updateUserDetails(
                        array('Content-type' => 'application/xml','token' => $this->session->get('token')),
                        $userDetails, $this->session->get('userName')
                    );

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('cloudCreated'),
                        'userUpdate' => $userUpdateResult['status'],
                        'cloud' => $miniCloud
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (423):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('423')
                    );
                    echo json_encode($result);
                    exit();
                case (403):

                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('403')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function miniClouds(){
        $headers = array(
            'Content-type'  => 'application/xml',
            'Accept'  => 'application/xml',
            'Accept-Charset'=> 'utf-8',
            'token' => $this->session->get('token')
        );
        $miniClouds = [];
        $result = $this->_model->getAllMiniClouds($headers);

        if($result['status'] == 200){
            if($this->session->get('admin') == true){
                $miniClouds = $result['body'];
            }else{

                foreach($result['body'] as $value){
                    if($this->session->get('userName') == $value->{'owner'}){
                        $miniClouds = array_merge(array($value), $miniClouds);
                    }
                }
            }
        }
        if(!empty(CUSTOM_SYNC_NAME)){
            $title = CUSTOM_SYNC_NAME;
        }else{
            $title = $this->language->get('indexPageName');
        }
        $data = array(
            'title' => $title,
            'csrf_token' => $this->setCSRFToken(),
            'crumb1' => $this->language->get('files'),
            'active' => 'sss',
            'miniClouds' => $miniClouds,
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('sync/miniClouds', $data);
        View::renderTemplate('footer', $data);
    }

    public function deleteMiniCloud(){
        if(!empty($_POST['miniCloudName'])){
            $headers = array(
                'Content-Type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName')
            );

            $xml = '<mini-cloud><mini-cloud-name>'.htmlspecialchars_decode($_POST['miniCloudName']).'</mini-cloud-name></mini-cloud>';

            $result = $this->_model->deleteMiniCloud($headers, $xml);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('miniCloudDeleted')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'asd' => $result,
                        'xml' => $xml,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function changeOwner(){
        if(!empty($_POST['miniCloudName']) && !empty($_POST['owner'])){
            $headers = array(
                'Accept'            => 'application/json',
                'token'             => $this->session->get('token'),
                'userName'          => $_POST['owner'],
                'miniCloudName'         => $_POST['miniCloudName']
            );

            $result = $this->_model->changeOwner($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('changeOwner')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getSyncRevisionId(){
        if(!empty($_POST['searchID'])){
            $headers = array(
                'Accept'     => 'application/json',
                'token'      => $this->session->get('token'),
                'consId'     => $_POST['searchID']
            );

            $result = $this->_model->getSyncRevisionId($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'revisionId' => $result['header']->container
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function assignUsers(){

        if(!empty($_POST['miniCloudName'])){
            $headers = array(
                'Accept'            => 'application/json',
                'token'             => $this->session->get('token'),
                'userNames'         => !(empty($_POST['userNames'])) ? implode(',', $_POST['userNames']) : '',
                'miniCloudName'     => $_POST['miniCloudName']
            );
            $this->log('userList'. json_encode($headers), 'info');
            $result = $this->_model->assignUsers($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('assignUsers')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
        }
    }

    public function getFileSize($sizeInKB){
        $bytes = ($sizeInKB*1024);
        if ($bytes >= 1073741824){
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        }elseif ($bytes >= 1048576){
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        }elseif ($bytes >= 1024){
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        }elseif ($bytes > 1){
            $bytes = $bytes . ' bytes';
        }elseif ($bytes == 1){
            $bytes = $bytes . ' byte';
        }else{
            $bytes = '0 bytes';
        }
        return $bytes;
    }

    public function getFileIcon($ext){
        switch ($ext) {
            case ('zip'):
                $icon = 'file-archive-o';
                break;
            case ('mp3' || 'mp4'):
                $icon = 'file-audio-o';
                break;
            case ('png' || 'jpeg' || 'jpg' || 'gif'):
                $icon = 'file-photo-o';
                break;
            case ('pdf'):
                $icon = 'file-pdf-o';
                break;
            case ('xlsx' || 'xls'):
                $icon = 'file-excel-o';
                break;
            case ('doc' || 'docx'):
                $icon = 'file-word-o';
                break;
            default:
                $icon = 'file';
                break;
        }
        return $icon;
    }

    public function uploadTest(){
        if(isset($_FILES)) {
            $target_dir = 'app/templates/default/uploads/test';
            $target_file = $target_dir . basename($_FILES["file"]["name"]);
            $this->log('Files Array'. json_encode($_FILES), 'info');
            foreach ($_FILES as $value) {
                move_uploaded_file($value["tmp_name"], $target_file);
                $this->log('File Details'. json_encode($value), 'info' );
            }
            echo json_encode($_FILES);
        }else{
            echo 'No file was sent';
        }
    }

    public function collectStats(){

        $browser = array(
            'version'   => '0.0.0',
            'majorver'  => 0,
            'minorver'  => 0,
            'build'     => 0,
            'name'      => 'unknown',
            'useragent' => ''
        );

        $browsers = array(
            'firefox', 'msie', 'opera', 'chrome', 'safari', 'mozilla', 'seamonkey', 'konqueror', 'netscape',
            'gecko', 'navigator', 'mosaic', 'lynx', 'amaya', 'omniweb', 'avant', 'camino', 'flock', 'aol'
        );

        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $browser['useragent'] = $_SERVER['HTTP_USER_AGENT'];
            $user_agent = strtolower($browser['useragent']);
            foreach($browsers as $_browser) {
                if (preg_match("/($_browser)[\/ ]?([0-9.]*)/", $user_agent, $match)) {
                    $browser['name'] = $match[1];
                    $browser['version'] = $match[2];
                    @list($browser['majorver'], $browser['minorver'], $browser['build']) = explode('.', $browser['version']);
                    break;
                }
            }
        }
        $browserName = $browser['name'] .' - '. $browser['version'];
        if (getenv('HTTP_CLIENT_IP')){
            $ipAddress = getenv('HTTP_CLIENT_IP');
        }
        else if(getenv('HTTP_X_FORWARDED_FOR')) {
            $ipAddress = getenv('HTTP_X_FORWARDED_FOR');
        }
        else if(getenv('HTTP_X_FORWARDED')){
            $ipAddress = getenv('HTTP_X_FORWARDED');
        }
        else if(getenv('HTTP_FORWARDED_FOR')){
            $ipAddress = getenv('HTTP_FORWARDED_FOR');
        }
        else if(getenv('HTTP_FORWARDED')){
            $ipAddress = getenv('HTTP_FORWARDED');
        }
        else{
            $ipAddress = 'UNKNOWN';
        }
        $remote 	= $_SERVER['REMOTE_ADDR'] ;
        $language 	= $_SERVER['HTTP_ACCEPT_LANGUAGE'];
        return array("ip" => $ipAddress,"remoteAdd" => $remote,
            "browser" => $browserName,"language" => $language);
    }

    public function getOS($user_agent) {

        $os_platform    =   "Unknown OS Platform";
        $os_array       =   array(
            '/windows nt 10/i'     =>  'Windows 10',
            '/windows nt 6.3/i'     =>  'Windows 8.1',
            '/windows nt 6.2/i'     =>  'Windows 8',
            '/windows nt 6.1/i'     =>  'Windows 7',
            '/windows nt 6.0/i'     =>  'Windows Vista',
            '/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
            '/windows nt 5.1/i'     =>  'Windows XP',
            '/windows xp/i'         =>  'Windows XP',
            '/windows nt 5.0/i'     =>  'Windows 2000',
            '/windows me/i'         =>  'Windows ME',
            '/win98/i'              =>  'Windows 98',
            '/win95/i'              =>  'Windows 95',
            '/win16/i'              =>  'Windows 3.11',
            '/macintosh|mac os x/i' =>  'Mac OS X',
            '/mac_powerpc/i'        =>  'Mac OS 9',
            '/linux/i'              =>  'Linux',
            '/ubuntu/i'             =>  'Ubuntu',
            '/iphone/i'             =>  'iPhone',
            '/ipod/i'               =>  'iPod',
            '/ipad/i'               =>  'iPad',
            '/android/i'            =>  'Android',
            '/blackberry/i'         =>  'BlackBerry',
            '/webos/i'              =>  'Mobile'
        );
        foreach ($os_array as $regex => $value) {
            if (preg_match($regex, $user_agent)) {
                $os_platform    =   $value;
            }
        }
        return $os_platform;
    }
	public function upload12(){
// 5 minutes execution time
@set_time_limit(5 * 60);
// Uncomment this one to fake upload time
// usleep(5000);
// Settings
//$targetDir = ini_get("upload_tmp_dir") . DIRECTORY_SEPARATOR . "plupload";
$d = date(dmy);
$cloudName = $this->session->get('cloudName');
$name = $this->session->get('userName');
$targetDir = "/parablu/".$cloudName."/sync-upload/Portal/".$d;
$targetDir1 = "/parablu/".$cloudName."/sync-upload/Portal/".$d."/".$name."/";
$cleanupTargetDir = true; // Remove old files
$maxFileAge = 5*3600; // Temp file age in seconds
//$this->log('ResulTemp'.$_FILES["file"]["size"], 'info');
// Create target dir
if (!is_dir($targetDir1)) {
@mkdir($targetDir1,0777,true);
}
// Get a file name
if (isset($_REQUEST["name"])) {
$fileName = $_REQUEST["name"];
} elseif (!empty($_FILES)) {
$fileName = $_FILES["file"]["name"];
} else {
$fileName = uniqid("file_");
}
$filePath = $targetDir1 . DIRECTORY_SEPARATOR . $fileName;
$filePath1 = $targetDir . DIRECTORY_SEPARATOR . $fileName;
// Chunking might be enabled
$chunk = isset($_REQUEST["chunk"]) ? intval($_REQUEST["chunk"]) : 0;
$chunks = isset($_REQUEST["chunks"]) ? intval($_REQUEST["chunks"]) : 0;
// Remove old temp files
if ($cleanupTargetDir) {
if (!is_dir($targetDir1) || !$dir = opendir($targetDir1)) {
die('{"jsonrpc" : "2.0", "error" : {"code": 100, "message": "Failed to open temp directory."}, "id" : "id"}');
}
// Remove old temp files
if ($cleanupTargetDir && is_dir($targetDir) && ($dir = opendir($targetDir))) {
while (($file = readdir($dir)) !== false) {
$tmpfilePath = $targetDir1 . DIRECTORY_SEPARATOR . $file;
// Remove temp file if it is older than the max age and is not the current file
if (preg_match('/\.part$/', $file) && (filemtime($tmpfilePath) < time() - $maxFileAge) && ($tmpfilePath != "{$filePath}.part")) {
@unlink($tmpfilePath);
}
}}
closedir($dir);
}
// Open temp file
if (!$out = @fopen("{$filePath}.part", $chunk ? "ab" : "w")) {
die('{"jsonrpc" : "2.0", "error" : {"code": 102, "message": "Failed to open output stream."}, "id" : "id"}');
}
if (!empty($_FILES)) {
if ($_FILES["file"]["error"] || !is_uploaded_file($_FILES["file"]["tmp_name"])) {
die('{"jsonrpc" : "2.0", "error" : {"code": 103, "message": "Failed to move uploaded file."}, "id" : "id"}');
}
// Read binary input stream and append it to temp file
if (!$in = @fopen($_FILES["file"]["tmp_name"], "rb")) {
die('{"jsonrpc" : "2.0", "error" : {"code": 101, "message": "Failed to open input stream."}, "id" : "id"}');
}
} else {
if (!$in = @fopen("php://input", "rb")) {
die('{"jsonrpc" : "2.0", "error" : {"code": 101, "message": "Failed to open input stream."}, "id" : "id"}');
}
}
while ($buff = fread($in, 4096)) {
fwrite($out, $buff);
}
@fclose($out);
@fclose($in);
// Check if file has been uploaded
if (!$chunks || $chunk == $chunks - 1) {
// Strip the temp .part suffix off
rename("{$filePath}.part", $filePath);
chmod($filePath, 0777);
rename($filePath, $filePath1);
}
die('{"jsonrpc" : "2.0", "result" : "Upload successful"}');
//die('{"OK": 1, "info": "Upload successful."}');
}

	public function delete12(){
	$path = $_POST['path'];
$return_text = 0;
// Check file exist or not
if( file_exists($path) ){
// Remove file
unlink($path);
// Set status
$return_text = 1;
}else{
// Set status
$return_text = 0;
}

//echo $path;
// Return status
echo $return_text;
}

}
