<?php

namespace Controllers;

use Core\Language;
use Core\View;
use Core\Controller;
use Helpers\Auth;
use Helpers\Url;
use Models\Settings;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class SettingsController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('settings');
        $this->_model = new Settings();
        Auth::allowOnly('admin');
    }

    /**
     * Display for my account details
     */
    public function dashboard(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('dashboard'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/dashboard', $data);
        View::renderTemplate('footer', $data);
    }

    /**
     * Display for my account details
     */
    public function email(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('emailConfiguration'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/email', $data);
        View::renderTemplate('footer', $data);
    }

    public function writeToMailConfig(){
        if(!empty($_POST['hostName']) && !empty($_POST['portNumber']) && !empty($_POST['fromName']) && !empty($_POST['emailUsername']) && !empty($_POST['emailPassword'])){
            $values = htmlentities($_POST['hostName']).' '.htmlentities($_POST['portNumber']).' '.htmlentities($_POST['fromName']).' '.htmlentities($_POST['emailUsername']).' '.$_POST['emailPassword'];
            $scriptOutput = shell_exec('sh /var/lib/parablusys/bin/mailoverwrite.sh '.$values);
            $this->log('scriptOutput' . json_encode($scriptOutput), 'info');
            $data = array(
                'result'=>'success',
                'msg' => 'Details has been successfully saved'
            );
            echo json_encode($data);
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }

    /**
     * Below Method Renders ODB Configuration View
     */
    public function connector(){

        $userDetails = $this->_model->getUserDetails(array('token' => $this->session->get('token')), $this->session->get("userName"));

        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token')
        );

        $result = $this->_model->getOdbDetails($headers);

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('connector'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'userDetails' => $userDetails['body'],
            'loggedInUser' => $this->session->all(),

            'clientID'=> $result["body"][0]->{"clientId"},
            'clientRedirectURI'=> $result["body"][0]->{"clientRedirectURI"},
            'portalURL'=> $result["body"][0]->{"portalURL"},
            'clientSecretKey'=> $result["body"][0]->{"clientSecretKey"},
            'clientResourceURL'=> $result["body"][0]->{"clientResourceURL"},
            'configId'=> $result["body"][0]->{"configId"},

        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/connector', $data);
        View::renderTemplate('footer', $data);
    }

    public function writeODB(){
        if (!empty($_POST['clientId']) && !empty($_POST['clientSecret']) && !empty($_POST['clientRedirectURI']) && !empty($_POST['clientResourceURL']) && !empty($_POST['portalURL'])) {

            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token')
            );

            $odbDetails = array(
                'clientId' => trim($_POST['clientId']),
                'configId' => trim($_POST['configId']),
                'clientSecretKey' => trim($_POST['clientSecret']),
                'clientRedirectURI' => trim($_POST['clientRedirectURI']),
                'clientResourceURL' => trim($_POST['clientResourceURL']),
                'clientTokenURL' => trim($_POST['clientTokenURL']),
                'portalURL' => trim($_POST['portalURL'])
            );
            $result = $this->_model->saveOdbDetails($headers, $odbDetails);
            $this->log(json_encode($odbDetails), "info");
            switch ($result['status']) {
                case (200):

                    $data = array(
                        'result' => 'success',
                        'msg' => 'Details has been successfully saved'
                    );
                    echo json_encode($data);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        } else {
            $data = array(
                "post" => $_POST,
                'result' => 'error',
                'msg' => 'None of the field listed should be empty'
            );
            echo json_encode($data);
        }

    }

    public function writeGoogle(){

if(!empty($_POST['clientId']) && !empty($_POST['clientSecret'])){
         $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token')
            );

file_put_contents('/var/www/portal/app/Core/GoogleConfig.php',"<?php 
define('GOOGLE_CLIENT_ID','".trim($_POST['clientId'])."');
define('GOOGLE_SECRET_KEY','".trim($_POST['clientSecret'])."');
define('GOOGLE_REDIRECT_URI','https://accounts.google.com/o/oauth2/auth');
define('GOOGLE_TOKEN_URL', 'https://accounts.google.com/o/oauth2/token');
define('GOOGLE_USER_INFO_URL', 'https://www.googleapis.com/plus/v1/people/me?access_token=');
define('GOOGLE_SCOPE', 'email%20profile%20https://www.googleapis.com/auth/drive.file%20https://www.googleapis.com/auth/plus.me');
define('GOOGLE_RESOURCE_URI', 'googleOAuth');


?>");
            $googleDetails = array(
                'clientId' => trim($_POST['clientId']),
                'configId' => trim($_POST['configId']),
                'clientSecretKey' => trim($_POST['clientSecret'])

            );
            $result = $this->_model->saveGoogleDetails($headers, $googleDetails);
            $this->log(json_encode($googleDetails), "info");
            switch ($result['status']) {
                case (200):
$data = array(
                        'result' => 'success',
                        'msg' => 'Details has been successfully saved'
                    );
                    echo json_encode($data);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
$result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
  }
        }else {
            $data = array(
                "post" => $_POST,
                'result' => 'error',
                'msg' => 'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }


    public function writeODC(){
        if(!empty($_POST['ClientId']) && !empty($_POST['clientSecret']) && !empty($_POST['clientRedirectURI']) && !empty($_POST['clientResourceURL']) && !empty($_POST['portalURL'])){
            $values = htmlentities($_POST['ClientId']).' '.htmlentities($_POST['clientSecret']).' '.htmlentities($_POST['clientRedirectURI']).' '.htmlentities($_POST['clientResourceURL']).' '.$_POST['portalURL'];
            $scriptOutput = shell_exec('sh /var/lib/parablusys/bin/odcoverwrite.sh '.$values);
            $this->log('scriptOutput' . json_encode($scriptOutput), 'info');
            $data = array(
                'result'=>'success',
                'msg' => 'Details has been successfully saved'
            );
            echo json_encode($data);
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }

    /**
     * Below Method Renders proxy Configuration View
     */
    public function proxy(){
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token')
        );
        $result = $this->_model->getProxyDetails($headers);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('proxyConfiguration'),
            'active' => 'settings',
            'proxy' => $result['body']->{'proxyList'},
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/proxy', $data);
        View::renderTemplate('footer', $data);
    }

    public function proxyremove(){
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token'),
            'proxyHost'     => $_POST['proxyHost']
        );
        $result = $this->_model->removeProxyDetails($headers);
        switch ($result['status']) {
            case (200):

                $response = array(
                    'result' => 'success',
                    'msg'    => $this->language->get('removeProxySettings')
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    /**
     *
     */
    public function writeProxySettings(){
        if(!empty($_POST['proxyURL']) && !empty($_POST['proxyUserName']) && !empty($_POST['proxyPassword']) && !empty($_POST['proxyPort'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),

            );


        $password_en = $_POST['proxyPassword'];
        $password_en = str_replace(".","+",$password_en);
        $password_en = str_replace("_","/",$password_en);
        $password_en = str_replace("-","=",$password_en);
$privkey = '-----BEGIN RSA PRIVATE KEY-----
MIICXgIBAAKBgQDJa13jCuhhMNQfcXb6uRJEnKkQBQxpl1Dp5U8EDbo16KrSDT++
OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulqIg8Tca9eg/uVjg2DHs4wIyzN
J7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+xVCPksMvihMgXe2xLdwIDAQAB
AoGBAJgcOlIdSbMkYf3A/Z6JJ6+jM9YCSgZwHM4Wu56PE2Jk7KQnF019d+Di0Zj/
DCD15irXFzyxTk3v0d/3mr17I4Pl1G2E4CjbqoxFXm6AqJ8ETpExJE/cU/gA3Uyz
ROWpP1WYJIz5HPnnkcDF+5oHYDPhNnV4vzJ9FpYOvzjZt7URAkEA8Day1Cp4P77k
jGXaf0aO1iNUuQOqFh7Id4MY2bMnJxXs664ZGqKJ53h12mHSdkCWq1vjR9KI/1vd
l3JvUGNxWQJBANaoAIjDJaRI2mxirzkCcwz0IfFJzmB6nZAqAiekCenhb3FGw+lW
Px7qd3JfU1vf9OfUpuGa/e+S5XTIuFkLuU8CQQCd/Vvg743nX0YykUsEKwQHE3XF
ugNESTrQYAkYJhy6OFF7MSaRvhW1iCT7XRtva0utqOHzeyVfzqwPz9Qmq0EBAkA0
DUEz6L5z/AabScLbvDBR79FbRV56HsGed9FV831D7ZqsiVBwgK2Fva2BWoRIPyKQ
JQzioEb7lU925kVtsl4ZAkEAj6wYWg+Rac7QbbcrW6SxehOehgkaCoTSZ/O9bj0m
WEIoJbkE69ABYKnCadQVbwK5W8fCUpqto0qCvva2l2PWeQ==
-----END RSA PRIVATE KEY-----';
        $encrypted_password = $password_en;
        if(openssl_private_decrypt(base64_decode($encrypted_password), $decrypted, $privkey))
        {
                $proxyPassword = $decrypted;
        }
        $this->log("Resultencrypted_password:".$proxyPassword, "info");
            $data = array(
                'host'     => $_POST['proxyURL'],
                'userName'      => $_POST['proxyUserName'],
                'password'      => $proxyPassword,
                'port'          => $_POST['proxyPort']
            );
            $result = $this->_model->saveProxyDetails($headers,json_encode($data));
            $this->log("Result:".json_encode($result), "info");
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('Details has been successfully saved')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }
    
    public function editProxySettings(){
        if(!empty($_POST['proxyURL'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),

            );
        $password_en = $_POST['proxyPassword'];
        $password_en = str_replace(".","+",$password_en);
        $password_en = str_replace("_","/",$password_en);
        $password_en = str_replace("-","=",$password_en);
$privkey = '-----BEGIN RSA PRIVATE KEY-----
MIICXgIBAAKBgQDJa13jCuhhMNQfcXb6uRJEnKkQBQxpl1Dp5U8EDbo16KrSDT++
OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulqIg8Tca9eg/uVjg2DHs4wIyzN
J7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+xVCPksMvihMgXe2xLdwIDAQAB
AoGBAJgcOlIdSbMkYf3A/Z6JJ6+jM9YCSgZwHM4Wu56PE2Jk7KQnF019d+Di0Zj/
DCD15irXFzyxTk3v0d/3mr17I4Pl1G2E4CjbqoxFXm6AqJ8ETpExJE/cU/gA3Uyz
ROWpP1WYJIz5HPnnkcDF+5oHYDPhNnV4vzJ9FpYOvzjZt7URAkEA8Day1Cp4P77k
jGXaf0aO1iNUuQOqFh7Id4MY2bMnJxXs664ZGqKJ53h12mHSdkCWq1vjR9KI/1vd
l3JvUGNxWQJBANaoAIjDJaRI2mxirzkCcwz0IfFJzmB6nZAqAiekCenhb3FGw+lW
Px7qd3JfU1vf9OfUpuGa/e+S5XTIuFkLuU8CQQCd/Vvg743nX0YykUsEKwQHE3XF
ugNESTrQYAkYJhy6OFF7MSaRvhW1iCT7XRtva0utqOHzeyVfzqwPz9Qmq0EBAkA0
DUEz6L5z/AabScLbvDBR79FbRV56HsGed9FV831D7ZqsiVBwgK2Fva2BWoRIPyKQ
JQzioEb7lU925kVtsl4ZAkEAj6wYWg+Rac7QbbcrW6SxehOehgkaCoTSZ/O9bj0m
WEIoJbkE69ABYKnCadQVbwK5W8fCUpqto0qCvva2l2PWeQ==
-----END RSA PRIVATE KEY-----';

        $encrypted_password = $password_en;
        function decrypt($data, $privkey)
        {
                if (openssl_private_decrypt(base64_decode($data), $decrypted, $privkey))
                    $data = $decrypted;
                else
                    $data = '';

                return $data;
        }
        $proxyPassword = decrypt ($encrypted_password, $privkey);

            $data = array(
                'host'          => $_POST['proxyURL'],
                'userName'      => $_POST['proxyUserName'],
                'password'      => $proxyPassword,
                'port'          => $_POST['proxyPort']
            );
            $this->log("ResultEDIT:".json_encode($data), "info");
            $result = $this->_model->editProxyDetails($headers,json_encode($data));
            $this->log("Result:".json_encode($result), "info");
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('Details has been successfully updated')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }
    

    /**
     * Below Method Renders Domain Host Name Configuration View
     */
    public function domain(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('domain'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/domain', $data);
        View::renderTemplate('footer', $data);
    }

    public function writeDomainHost(){
        if(!empty($_POST['domainName']) && !empty($_POST['hostName'])){
            $data = array(
                'result'=>'success',
                'msg' => 'Details has been successfully saved'
            );
            echo json_encode($data);
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }

    /**
     * Below Method Renders SSL Certificate Upload View
     */
    public function sslAndEncryption(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('sslAndEncryption'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/sslAndEncryption', $data);
        View::renderTemplate('footer', $data);
    }

    public function saveSSLCertificate(){
        $tempFilePath = '/var/lib/parablusys/conf/';
        $flag = true;
        if(!empty($_FILES['mainCRTFile']) && !empty($_FILES['chainCRTFile']) && !empty($_FILES['keyFile'])){
            $tmp_name = $_FILES["mainCRTFile"]["tmp_name"];
            $name = $_FILES["mainCRTFile"]["name"];
            $ext1 = substr(strrchr($_FILES['mainCRTFile']['name'], "."), 1);
            if($ext1 != 'crt')
            {
                $flag = false;
            }
            move_uploaded_file($tmp_name, $tempFilePath.$name);
            $tmp_name = $_FILES["chainCRTFile"]["tmp_name"];
            $name = $_FILES["chainCRTFile"]["name"];
            $ext2 = substr(strrchr($_FILES['chainCRTFile']['name'], "."), 1);
            if($ext2 != 'crt')
            {
                $flag = false;
            }
            move_uploaded_file($tmp_name, $tempFilePath.$name);
            $tmp_name = $_FILES["keyFile"]["tmp_name"];
            $name = $_FILES["keyFile"]["name"];
            $ext3 = substr(strrchr($_FILES['keyFile']['name'], "."), 1);
            if($ext3 != 'key')
            {
                $flag = false;
            }
            move_uploaded_file($tmp_name, $tempFilePath.$name);
            $values = $_FILES["mainCRTFile"]["name"] . ' '.$_FILES["chainCRTFile"]["name"].' '.$_FILES["keyFile"]["name"].' '.$_POST["serverName"];
            $scriptOutput = shell_exec('sh /var/lib/parablusys/conf/cert_file.sh '.$values);
            $this->log('scriptOutput' . json_encode($scriptOutput), 'info');
            if($flag == 'true'){
            $data = array(
                'result'=>'success',
                'msg' => 'Details has been successfully saved'
            );
            }
            else {
             $data = array(
                'result'=>'fail',
                'msg' => 'file not supported, <br> check extension'
            );   
            }
            echo json_encode($data);
        }else{
            $data = array(
                'result' => 'error',
                'msg'=>'None of the field listed should be empty'
            );
            echo json_encode($data);
        }
    }

    /**
     * Below Method Renders Encryption settings page
     */
    public function encryption(){
        $keys = [];
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );

        $result = $this->_model->getEncryption($headers);
        switch ($result['status']) {
            case (200):
                if(!empty($result['body']->{'encryptionKeyElementList'})){
                    foreach($result['body']->{'encryptionKeyElementList'} as $value){
                        date_default_timezone_set('Asia/Calcutta');


                        $a = $value->startTimestamp/1000;
                        //$date = new DateTime("@$a");
                        $value->startTime = date('d.m.Y H:i:s', $a);
                        $keys = array_merge(array($value), $keys);
                    }
                }
                $response = array(
                    'result' => 'success',
                    'keys' => $keys,
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function saveEncryption(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token')
            );

            $body = array(
                'userName'      => $this->session->get('userName'),
                'productType'   => $_POST['productType'],
                'saltKey'       => $_POST['saltKey']
            );
            $result = $this->_model->saveEncryption($headers,$body);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => $this->language->get('encryptionKeySaved')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    /**
     * Below Method Renders Encryption settings page
     */
    public function local(){
        $headers = array(
            'Content-Type' => 'application/json',
            'token' => $this->session->get('token')
        );
        $result = $this->_model->getLocalStorageDetails($headers);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('local'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'localStorage' => $result['body'],
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/local', $data);
        View::renderTemplate('footer', $data);
    }

    public function saveLocal(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'          => $this->session->get('token')
            );
            $data = array(
                'fileServerPath' => $_POST['path'],
                'fileServerUserName' => $_POST['userName'],
                'fileServerPassword' => $_POST['password']
            );
            $result = $this->_model->saveLocalStorageDetails($headers, $data);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('encryptionKeySaved')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    /**
     * Below Method Renders Encryption settings page
     */
    public function adCredentials(){

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('adCredentials'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/adCredentials', $data);
        View::renderTemplate('footer', $data);
    }

    public function getAdCredentials(){
        $adcS = [];
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token')
        );
        if($this->session->get('admin') == "1"){
            $result = $this->_model->getAdCredentials($headers);
        }

$pubkey = '-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJa13jCuhhMNQfcXb6uRJEnKkQ
BQxpl1Dp5U8EDbo16KrSDT++OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulq
Ig8Tca9eg/uVjg2DHs4wIyzNJ7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+x
VCPksMvihMgXe2xLdwIDAQAB
-----END PUBLIC KEY-----';

        if(!empty($result['body']->{'adElementList'})){
            foreach($result['body']->{'adElementList'} as $value){
		if($value->{'adPassword'}){
		$pass = $value->{'adPassword'};
		openssl_public_encrypt($pass, $encrypted, $pubkey);
	        $encrypted = base64_encode($encrypted);
		$encrypted = str_replace(".","+",$encrypted);
                $encrypted = str_replace("_","/",$encrypted);
                $encrypted = str_replace("-","=",$encrypted);
        	$value->{'adPassword'} = $encrypted;
}
                $adcS = array_merge(array($value), $adcS);
            }
        }

        switch ($result['status']) {
            case (200):

                $response = array(
                    'result' => 'success',
                    'adcS'    => $adcS
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function getAdCredential(){
        if(!empty($_POST['id'])){

            $headers = array(
                'Content-Type'      => 'application/json',
                'id'            => $_POST['id'],
                'token'             => $this->session->get('token')
            );

            $result = $this->_model->getAdCredential($headers);
$pubkey = '-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJa13jCuhhMNQfcXb6uRJEnKkQ
BQxpl1Dp5U8EDbo16KrSDT++OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulq
Ig8Tca9eg/uVjg2DHs4wIyzNJ7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+x
VCPksMvihMgXe2xLdwIDAQAB
-----END PUBLIC KEY-----';
		$adPassword = $result['body']->{'adElement'}->{'adPassword'};
		openssl_public_encrypt($adPassword, $encrypted, $pubkey);
	        $encrypted = base64_encode($encrypted);
		$encrypted = str_replace(".","+",$encrypted);
	        $encrypted = str_replace("_","/",$encrypted);
        	$encrypted = str_replace("-","=",$encrypted);
		$result['body']->{'adElement'}->{'adPassword'} = $encrypted;
		$this->log("Password : ".$adPassword,"info");
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'adcS'    => $result['body']->{'adElement'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function saveAdCredentials(){
        if(!empty($_POST['userDn']) && !empty($_POST['adPassword']) && !empty($_POST['adCn']) && !empty($_POST['adUrl']) && !empty($_POST['adBase'])){
        $adProductType = '';
        switch ($_POST['adProductType']) {
            case 'BluSync':
                $adProductType = "sync";
                break;
            case 'BluVault':
                $adProductType = "backup";
                break;
            default:
                $adProductType = $_POST['adProductType'];
            break;
        }

        $this->log("Password : ".$_POST['adPassword'],"info");
        $password_en = $_POST['adPassword'];
        $password_en = str_replace(".","+",$password_en);
        $password_en = str_replace("_","/",$password_en);
        $password_en = str_replace("-","=",$password_en);

$privkey = '-----BEGIN RSA PRIVATE KEY-----
MIICXgIBAAKBgQDJa13jCuhhMNQfcXb6uRJEnKkQBQxpl1Dp5U8EDbo16KrSDT++
OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulqIg8Tca9eg/uVjg2DHs4wIyzN
J7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+xVCPksMvihMgXe2xLdwIDAQAB
AoGBAJgcOlIdSbMkYf3A/Z6JJ6+jM9YCSgZwHM4Wu56PE2Jk7KQnF019d+Di0Zj/
DCD15irXFzyxTk3v0d/3mr17I4Pl1G2E4CjbqoxFXm6AqJ8ETpExJE/cU/gA3Uyz
ROWpP1WYJIz5HPnnkcDF+5oHYDPhNnV4vzJ9FpYOvzjZt7URAkEA8Day1Cp4P77k
jGXaf0aO1iNUuQOqFh7Id4MY2bMnJxXs664ZGqKJ53h12mHSdkCWq1vjR9KI/1vd
l3JvUGNxWQJBANaoAIjDJaRI2mxirzkCcwz0IfFJzmB6nZAqAiekCenhb3FGw+lW
Px7qd3JfU1vf9OfUpuGa/e+S5XTIuFkLuU8CQQCd/Vvg743nX0YykUsEKwQHE3XF
ugNESTrQYAkYJhy6OFF7MSaRvhW1iCT7XRtva0utqOHzeyVfzqwPz9Qmq0EBAkA0
DUEz6L5z/AabScLbvDBR79FbRV56HsGed9FV831D7ZqsiVBwgK2Fva2BWoRIPyKQ
JQzioEb7lU925kVtsl4ZAkEAj6wYWg+Rac7QbbcrW6SxehOehgkaCoTSZ/O9bj0m
WEIoJbkE69ABYKnCadQVbwK5W8fCUpqto0qCvva2l2PWeQ==
-----END RSA PRIVATE KEY-----';
        $encrypted_password = $password_en;
        $this->log("Password changed : ".$password_en,"info");
        function decrypt($data, $privkey)
        {
                if (openssl_private_decrypt(base64_decode($data), $decrypted, $privkey))
                        $data = $decrypted;
                else
                        $data = '';
                return $data;
        }
        $password = decrypt ($encrypted_password, $privkey);
        $this->log("Password changed : ".$password,"info");
        $data = array(
                'userDn' => trim($_POST['userDn']),
                'adPassword' => $password,
                'adUrl' => trim($_POST['adUrl']),
                'adBase' => trim($_POST['adBase']),
                'adCn' => trim($_POST['adCn']),
                'adProductType' => $adProductType,
                'adGroupName' => trim($_POST['adGroupName'])
            );
            $this->log('Data: '. json_encode($data), 'info');
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'          => $this->session->get('token')
            );
            $result = $this->_model->saveAdCredentials($headers, json_encode($data));
            $this->log('Result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('savedAdCredentials')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function editAdCredentials(){
        if(!empty($_POST['userDn']) && !empty($_POST['editAdPassword']) && !empty($_POST['adCn']) && !empty($_POST['adUrl']) && !empty($_POST['adBase'])){
        $adProductType = '';
        switch ($_POST['editAdProductType']) {
            case 'BluSync':
                $adProductType = "sync";
                break;
            case 'BluVault':
                $adProductType = "backup";
                break;
            default:
                $adProductType = $_POST['editAdProductType'];
            break;
        }
        $password_en = $_POST['editAdPassword'];
        $password_en = str_replace(".","+",$password_en);
        $password_en = str_replace("_","/",$password_en);
        $password_en = str_replace("-","=",$password_en);
$privkey = '-----BEGIN RSA PRIVATE KEY-----
MIICXgIBAAKBgQDJa13jCuhhMNQfcXb6uRJEnKkQBQxpl1Dp5U8EDbo16KrSDT++
OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulqIg8Tca9eg/uVjg2DHs4wIyzN
J7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+xVCPksMvihMgXe2xLdwIDAQAB
AoGBAJgcOlIdSbMkYf3A/Z6JJ6+jM9YCSgZwHM4Wu56PE2Jk7KQnF019d+Di0Zj/
DCD15irXFzyxTk3v0d/3mr17I4Pl1G2E4CjbqoxFXm6AqJ8ETpExJE/cU/gA3Uyz
ROWpP1WYJIz5HPnnkcDF+5oHYDPhNnV4vzJ9FpYOvzjZt7URAkEA8Day1Cp4P77k
jGXaf0aO1iNUuQOqFh7Id4MY2bMnJxXs664ZGqKJ53h12mHSdkCWq1vjR9KI/1vd
l3JvUGNxWQJBANaoAIjDJaRI2mxirzkCcwz0IfFJzmB6nZAqAiekCenhb3FGw+lW
Px7qd3JfU1vf9OfUpuGa/e+S5XTIuFkLuU8CQQCd/Vvg743nX0YykUsEKwQHE3XF
ugNESTrQYAkYJhy6OFF7MSaRvhW1iCT7XRtva0utqOHzeyVfzqwPz9Qmq0EBAkA0
DUEz6L5z/AabScLbvDBR79FbRV56HsGed9FV831D7ZqsiVBwgK2Fva2BWoRIPyKQ
JQzioEb7lU925kVtsl4ZAkEAj6wYWg+Rac7QbbcrW6SxehOehgkaCoTSZ/O9bj0m
WEIoJbkE69ABYKnCadQVbwK5W8fCUpqto0qCvva2l2PWeQ==
-----END RSA PRIVATE KEY-----';

        $encrypted_password = $password_en;
        function decrypt($data, $privkey)
            {
                if (openssl_private_decrypt(base64_decode($data), $decrypted, $privkey))
                    $data = $decrypted;
                else
                    $data = '';

                return $data;
            }
            $password = decrypt ($encrypted_password, $privkey);

            $data = array(
                'id' => $_POST['id'],
                'userDn' => trim($_POST['userDn']),
                'adPassword' => $password,
                'adUrl' => trim($_POST['adUrl']),
                'adBase' => trim($_POST['adBase']),
                'adCn' => trim($_POST['adCn']),
                'adProductType' => $adProductType,
                'adGroupName' => trim($_POST['adGroupName'])
            );
            $this->log('Data: '. json_encode($data), 'info');
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'          => $this->session->get('token')
            );
            $result = $this->_model->editAdCredentials($headers, json_encode($data));
            $this->log('Result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('savedAdCredentials')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function removeAdCredentials(){
        if(!empty($_POST['userDn'])){
            $headers = array(
                'Content-Type'      => 'application/json',
                'userDn'            => $_POST['userDn'],
                'token'             => $this->session->get('token')
            );
            $result = $this->_model->removeAdCredentials($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('removeAdCredentials')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function smtp(){

        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );

        $result = $this->_model->getSmtp($headers);

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('smtp'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),

            "smtpHost" => !empty($result['body']->{'smtpElement'}->{'smtpHost'}) ? $result['body']->{'smtpElement'}->{'smtpHost'} : 'smtp.office365.com',
            "sslPort" => !empty($result['body']->{'smtpElement'}->{'sslPort'}) ? $result['body']->{'smtpElement'}->{'sslPort'} : '465',
            "sslFactoryClass" => !empty($result['body']->{'smtpElement'}->{'sslFactoryClass'}) ? $result['body']->{'smtpElement'}->{'sslFactoryClass'} : "javax.net.ssl.SSLSocketFactory",
            "smtpPort" => !empty($result['body']->{'smtpElement'}->{'smtpPort'}) ? $result['body']->{'smtpElement'}->{'smtpPort'} : 465,
            "smtpAuth" => ($result['body']->{'smtpElement'}->{'smtpAuth'}) ? true : false,
            "smtpStarttlsEnable" => ($result['body']->{'smtpElement'}->{'smtpStarttlsEnable'}) ? true : false,
            "smtpSSLEnable" => ($result['body']->{'smtpElement'}->{'smtpSSLEnable'}) ? true : false,
            "smtpUserName" => !empty($result['body']->{'smtpElement'}->{'smtpUserName'}) ? $result['body']->{'smtpElement'}->{'smtpUserName'} : 'noreply@parablu.com',
            "smtpPwd" => !empty($result['body']->{'smtpElement'}->{'smtpPwd'}) ? $result['body']->{'smtpElement'}->{'smtpPwd'} : 'P@rablu123',
            "fromEmail" => !empty($result['body']->{'smtpElement'}->{'fromEmail'}) ? $result['body']->{'smtpElement'}->{'fromEmail'} : 'noreply@parablu.com',
            "enableEmail" => ($result['body']->{'smtpElement'}->{'enableEmail'}) ? true : false
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/smtp', $data);
        View::renderTemplate('footer', $data);
    }

    public function saveSmtp(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'             => $this->session->get('token')
            );


        $password_en = $_POST['smtpPwd'];
        $password_en = str_replace(".","+",$password_en);
        $password_en = str_replace("_","/",$password_en);
        $password_en = str_replace("-","=",$password_en);

$privkey = '-----BEGIN RSA PRIVATE KEY-----
MIICXgIBAAKBgQDJa13jCuhhMNQfcXb6uRJEnKkQBQxpl1Dp5U8EDbo16KrSDT++
OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulqIg8Tca9eg/uVjg2DHs4wIyzN
J7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+xVCPksMvihMgXe2xLdwIDAQAB
AoGBAJgcOlIdSbMkYf3A/Z6JJ6+jM9YCSgZwHM4Wu56PE2Jk7KQnF019d+Di0Zj/
DCD15irXFzyxTk3v0d/3mr17I4Pl1G2E4CjbqoxFXm6AqJ8ETpExJE/cU/gA3Uyz
ROWpP1WYJIz5HPnnkcDF+5oHYDPhNnV4vzJ9FpYOvzjZt7URAkEA8Day1Cp4P77k
jGXaf0aO1iNUuQOqFh7Id4MY2bMnJxXs664ZGqKJ53h12mHSdkCWq1vjR9KI/1vd
l3JvUGNxWQJBANaoAIjDJaRI2mxirzkCcwz0IfFJzmB6nZAqAiekCenhb3FGw+lW
Px7qd3JfU1vf9OfUpuGa/e+S5XTIuFkLuU8CQQCd/Vvg743nX0YykUsEKwQHE3XF
ugNESTrQYAkYJhy6OFF7MSaRvhW1iCT7XRtva0utqOHzeyVfzqwPz9Qmq0EBAkA0
DUEz6L5z/AabScLbvDBR79FbRV56HsGed9FV831D7ZqsiVBwgK2Fva2BWoRIPyKQ
JQzioEb7lU925kVtsl4ZAkEAj6wYWg+Rac7QbbcrW6SxehOehgkaCoTSZ/O9bj0m
WEIoJbkE69ABYKnCadQVbwK5W8fCUpqto0qCvva2l2PWeQ==
-----END RSA PRIVATE KEY-----';

        $encrypted_password = $password_en;
        
        function decrypt($data, $privkey) {
                if (openssl_private_decrypt(base64_decode($data), $decrypted, $privkey))
                    $data = $decrypted;
                else
                    $data = '';
                return $data;
            }
        $password = decrypt ($encrypted_password, $privkey);
        $smtpDetails = array(
                "smtpHost" => $_POST["smtpHost"],
                "sslPort" => $_POST["sslPort"],
                "sslFactoryClass" => $_POST["factoryClass"],
                "smtpPort" => $_POST["smtpPort"],
                "smtpAuth" => $_POST["smtpAuth"],
                "smtpStarttlsEnable" => $_POST["smtpStarttlsEnable"],
                "smtpSSLEnable" => $_POST["smtpSSLEnable"],
                "smtpUserName" => $_POST["smtpUname"],
                "smtpPwd" => $password,
                "fromEmail" => $_POST["email"],
                "enableEmail" => $_POST["enableMail"],
            );

            $result = $this->_model->saveSmtp($headers, $smtpDetails);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('saveSmtp')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function cloudProperties(){
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );

        $result = $this->_model->getCloudProperties($headers);
        $backupPoliciesResult= $this->_model->getAllPolicies($this->session->get('token'));
        $syncPoliciesResult= $this->_model->getAllSyncPolicies($this->session->get('token'));
         if(empty((array)$backupPoliciesResult['body']->{'backupPolicyElementList'}) && $this->auth->checkCloudPermission('backup')){
             header('Location: '.Url::basePath('pms/policy/create'));
             exit;
         }
         if(empty((array)$syncPoliciesResult['body']->{'syncPolicyElementList'}) && $this->auth->checkCloudPermission('sync')){
             header('Location: '.Url::basePath('pms/sync/policy/create'));
             exit;
         }
 
         $backupPolicies = [];
         foreach((array)$backupPoliciesResult['body']->{'backupPolicyElementList'} as $value){
             $policy = array('name' => $value->{'policygroupName'});
             $backupPolicies = array_merge(array($policy), $backupPolicies);
         }
         
         $syncPolicies = [];
         foreach((array)$syncPoliciesResult['body']->{'syncPolicyElementList'} as $value){
             $policy = array('name' => $value->{'policygroupName'});
             $syncPolicies = array_merge(array($policy), $syncPolicies);
         }

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('cloudProperties'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            "backupPolicies"            =>$backupPolicies,
            "syncPolicies"              =>$syncPolicies,

            "blusyncDownloadPath"       => !empty($result['body']->{'cloudPropertyElement'}->{'blusyncDownloadPath'}) ? $result['body']->{'cloudPropertyElement'}->{'blusyncDownloadPath'} : '/var/lib/parablusys/upgrade/',
            "mntParacloudPath"          => !empty($result['body']->{'cloudPropertyElement'}->{'mntParacloudPath'}) ? $result['body']->{'cloudPropertyElement'}->{'mntParacloudPath'} : '/mnt/',
            "cloudScriptsFolder"        => !empty($result['body']->{'cloudPropertyElement'}->{'cloudScriptsFolder'}) ? $result['body']->{'cloudPropertyElement'}->{'cloudScriptsFolder'} : '/var/lib/parablusys/bin/',
            "scriptsBinDir"             => !empty($result['body']->{'cloudPropertyElement'}->{'scriptsBinDir'}) ? $result['body']->{'cloudPropertyElement'}->{'scriptsBinDir'} : '/var/lib/parablusys/bin/',
            "scriptsVideoThumbnail"     => !empty($result['body']->{'cloudPropertyElement'}->{'scriptsVideoThumbnail'}) ? $result['body']->{'cloudPropertyElement'}->{'scriptsVideoThumbnail'} : 'generateVideoThumbnails.sh',
            "scriptsGeneralThumbnail"   => !empty($result['body']->{'cloudPropertyElement'}->{'scriptsGeneralThumbnail'}) ? $result['body']->{'cloudPropertyElement'}->{'scriptsGeneralThumbnail'} : 'generateThumbnails.sh',
            "cloudFileName"             => !empty($result['body']->{'cloudPropertyElement'}->{'cloudFileName'}) ? $result['body']->{'cloudPropertyElement'}->{'cloudFileName'} : 'cloudName',
            "cloudType"                 => !empty($result['body']->{'cloudPropertyElement'}->{'cloudType'}) ? $result['body']->{'cloudPropertyElement'}->{'cloudType'} : 'enterprise',
            "solrUrl"                   => !empty($result['body']->{'cloudPropertyElement'}->{'solrUrl'}) ? $result['body']->{'cloudPropertyElement'}->{'solrUrl'} : 'http://192.168.7.57/ParacloudSearch/search/',
            "supportMail"               => !empty($result['body']->{'cloudPropertyElement'}->{'supportMail'}) ? $result['body']->{'cloudPropertyElement'}->{'supportMail'} : 'praveen.anandaraju@parablu.com',
            "sslAuthEnabled"            => ($result['body']->{'cloudPropertyElement'}->{'sslAuthEnabled'}) ? true : false,
            "azureVM"                   => ($result['body']->{'cloudPropertyElement'}->{'azureVM'}) ? true : false,
            "localAD"                   => ($result['body']->{'cloudPropertyElement'}->{'localAD'}) ? true : false,
            "reportRows"                => !empty($result['body']->{'cloudPropertyElement'}->{'reportRows'}) ? $result['body']->{'cloudPropertyElement'}->{'reportRows'} : '50',
            "emailToAdminOnly"          => ($result['body']->{'cloudPropertyElement'}->{'emailToAdminOnly'}) ? true : false,
            "maxCrawlHit"               => $result['body']->{'cloudPropertyElement'}->{'maxCrawlHit'},
            "defaultBkpPolicyName"      => !empty($result['body']->{'cloudPropertyElement'}->{'defaultBkpPolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultBkpPolicyName'} : 'STATISTICS_COLLECTOR',
            "defaultSyncPolicyName"     => !empty($result['body']->{'cloudPropertyElement'}->{'defaultSyncPolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultSyncPolicyName'} : 'STATISTICS_SYNC_COLLECTOR',
            "defaultGuestSyncPolicyName"     => !empty($result['body']->{'cloudPropertyElement'}->{'defaultGuestSyncPolicyName'}) ? $result['body']->{'cloudPropertyElement'}->{'defaultGuestSyncPolicyName'} : 'STATISTICS_SYNC_COLLECTOR',
            "mongoReadPreference"       => ($result['body']->{'cloudPropertyElement'}->{'mongoReadPreference'}) ? true : false,
            "writeConcernLimit"         => !empty($result['body']->{'cloudPropertyElement'}->{'writeConcernLimit'}) ? $result['body']->{'cloudPropertyElement'}->{'writeConcernLimit'} : 1000,
            "ebmsWriteDelayLimit"       => !empty($result['body']->{'cloudPropertyElement'}->{'ebmsWriteDelayLimit'}) ? $result['body']->{'cloudPropertyElement'}->{'ebmsWriteDelayLimit'} : 10,
            "noOfMultiADConfig"         => !empty($result['body']->{'cloudPropertyElement'}->{'noOfMultiADConfig'}) ? $result['body']->{'cloudPropertyElement'}->{'noOfMultiADConfig'} : 1,
            "isCrawlEnabled"            => ($result['body']->{'cloudPropertyElement'}->{'isCrawlEnabled'}) ? true : false,
            "emailBkpGroupName"         => !empty($result['body']->{'cloudPropertyElement'}->{'emailBkpGroupName'}) ? $result['body']->{'cloudPropertyElement'}->{'emailBkpGroupName'} : '',
            "emailSyncGroupName"        => !empty($result['body']->{'cloudPropertyElement'}->{'emailSyncGroupName'}) ? $result['body']->{'cloudPropertyElement'}->{'emailSyncGroupName'} : '',
            "bkpGroupEmail"             => !empty($result['body']->{'cloudPropertyElement'}->{'bkpGroupEmail'}) ? $result['body']->{'cloudPropertyElement'}->{'bkpGroupEmail'} : 'MySecureBackup',
            "syncGroupEmail"            => !empty($result['body']->{'cloudPropertyElement'}->{'syncGroupEmail'}) ? $result['body']->{'cloudPropertyElement'}->{'syncGroupEmail'} : 'MySecureSync',
            "chunkUpdateMaxRetry"       => !empty($result['body']->{'cloudPropertyElement'}->{'chunkUpdateMaxRetry'}) ? $result['body']->{'cloudPropertyElement'}->{'chunkUpdateMaxRetry'} : 3,
            "isDomainCheckEnabled"      => ($result['body']->{'cloudPropertyElement'}->{'isDomainCheckEnabled'}) ? true : false,
            "canAdminRestoreAll"        => ($result['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'}) ? true : false,
            "clientMailName"            => !empty($result['body']->{'cloudPropertyElement'}->{'clientMailName'}) ? $result['body']->{'cloudPropertyElement'}->{'clientMailName'} : 'Parablu',
            "clientSupportMailName"     => !empty($result['body']->{'cloudPropertyElement'}->{'clientSupportMailName'}) ? $result['body']->{'cloudPropertyElement'}->{'clientSupportMailName'} : 'support@parablu.com',
            "isShareFileNameEnabled"    => ($result['body']->{'cloudPropertyElement'}->{'isShareFileNameEnabled'}) ? true : false,
            "adfsUrl"                   => !empty($result['body']->{'cloudPropertyElement'}->{'adfsUrl'}) ? $result['body']->{'cloudPropertyElement'}->{'adfsUrl'} : 'https:443//testv20-1.parablu.com/springsam/saml/login',
            "adGroupName"               => !empty($result['body']->{'cloudPropertyElement'}->{'adGroupName'}) ? $result['body']->{'cloudPropertyElement'}->{'adGroupName'} : '',
            "bulkEmailDelay"            => ($result['body']->{'cloudPropertyElement'}->{'bulkEmailDelay'}) ? $result['body']->{'cloudPropertyElement'}->{'bulkEmailDelay'} : "NO DELAY",
	        "notifyForRestores"         => ($result['body']->{'cloudPropertyElement'}->{'isEmailNotifierForRestoreEnabled'}) ? true : false,
            "notifyForBackup"           => ($result['body']->{'cloudPropertyElement'}->{'isEmailNotifierEnabledForFirstBackupCompletion'}) ? true : false,
            "daysToWaitForNextBackup"        => !empty($result['body']->{'cloudPropertyElement'}->{'daysToWaitForNextBackup'}) ? $result['body']->{'cloudPropertyElement'}->{'daysToWaitForNextBackup'} : 0,
            "canUserChangePassword"         => ($result['body']->{'cloudPropertyElement'}->{'canUserChangePassword'}),
            "canAdminChangeUserPassword"           => ($result['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'}),
            "passwordChangeEnforce"           => ($result['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'}) ? true : false,
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/cloudProperties', $data);
        View::renderTemplate('footer', $data);
    }

    public function saveCloudProperties(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'             => $this->session->get('token')
            );

	    if(empty($_POST['bulkEmailDelay']) || $_POST['bulkEmailDelay'] == 'NO DELAY'){
                $_POST['bulkEmailDelay'] = 0;
            }

            $cloudDetails = array(
                "blusyncDownloadPath" => $_POST["blusyncDownloadPath"],
                "mntParacloudPath" => $_POST["mntParacloudPath"],
                "cloudScriptsFolder" => $_POST["cloudScriptsFolder"],
                "scriptsBinDir" => $_POST["scriptsBinDir"],
                "scriptsVideoThumbnail" => $_POST["scriptsVideoThumbnail"],
                "scriptsGeneralThumbnail" => $_POST["scriptsGeneralThumbnail"],
                "cloudFileName" => $_POST["cloudFileName"],
                "cloudType" => $_POST["cloudType"],
                "solrUrl" => $_POST["solrUrl"],
                "supportMail" => $_POST["supportMail"],
                "sslAuthEnabled" => $_POST["sslAuthEnabled"],
                "azureVM" => $_POST["azureVM"],
                "localAD" => $_POST["localAD"],
                "reportRows" => $_POST["reportRows"],
                "emailToAdminOnly" => $_POST["emailToAdminOnly"],
                "maxCrawlHit" => $_POST["maxCrawlHit"],
                "defaultBkpPolicyName" => $_POST["defaultBkpPolicyName"],
                "defaultSyncPolicyName" => $_POST["defaultSyncPolicyName"],
                "defaultGuestSyncPolicyName" => $_POST["defaultGuestSyncPolicyName"],
                "mongoReadPreference" => $_POST["mongoReadPreference"],
                "writeConcernLimit" => $_POST["writeConcernLimit"],
                "ebmsWriteDelayLimit" => $_POST["ebmsWriteDelayLimit"],
                "noOfMultiADConfig" => $_POST["noOfMultiADConfig"],
                "isCrawlEnabled" => $_POST["isCrawlEnabled"],
                "emailBkpGroupName" => $_POST["emailBkpGroupName"],
                "emailSyncGroupName" => $_POST["emailSyncGroupName"],
                "bkpGroupEmail" => $_POST["bkpGroupEmail"],
                "syncGroupEmail" => $_POST["syncGroupEmail"],
                "chunkUpdateMaxRetry" => $_POST["chunkUpdateMaxRetry"],
                "isDomainCheckEnabled" => $_POST["isDomainCheckEnabled"],
                "canAdminRestoreAll" => $_POST["canAdminRestoreAll"],
                "clientMailName" => $_POST["clientMailName"],
                "clientSupportMailName" => $_POST["clientSupportMailName"],
                "isShareFileNameEnabled" => $_POST["isShareFileNameEnabled"],
                "adfsUrl" => $_POST["adfsUrl"],
                "adGroupName" => $_POST["adGroupName"],
        		"bulkEmailDelay" => $_POST["bulkEmailDelay"],
        		"isEmailNotifierForRestoreEnabled" => $_POST["notifyForRestores"],
                "isEmailNotifierEnabledForFirstBackupCompletion" => $_POST["notifyForBackup"],
                "canUserChangePassword"    => $_POST["canUser"],
                "canAdminChangeUserPassword"  => $_POST["canAdmin"],
                "passwordChangeEnforce"  => $_POST["passwordChangeEnforce"],
                "daysToWaitForNextBackup" =>$_POST["daysToWaitForNextBackup"],
            );

            $result = $this->_model->saveCloudProperties($headers, $cloudDetails);
            $this->log(json_encode($cloudDetails), "info");
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('savedCloudProperties')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    /**
     * Below Method Renders Encryption settings page
     */
    public function cloudCredentials(){
        $userDetails = $this->_model->getUserDetails(array('token' => $this->session->get('token')), $this->session->get("userName"));
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token')
        );

        $result = $this->_model->getOdbDetails($headers);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('cloudCredentials'),
            'active' => 'settings',
            'userDetails' => $userDetails['body'],
            'loggedInUser' => $this->session->all(),
            'csrf_token' => $this->setCSRFToken(),

            'clientID'=> $result["body"]->{"clientId"},
            'clientRedirectURI'=> $result["body"]->{"clientRedirectURI"},
            'portalURL'=> $result["body"]->{"portalURL"},
            'clientSecretKey'=> $result["body"]->{"clientSecretKey"},
            'clientResourceURL'=> $result["body"]->{"clientResourceURL"},
            'clientTokenURL'=> $result["body"]->{"clientTokenURL"},
            'configId'=> $result["body"]->{"configId"},
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/cloudCredentials', $data);
        View::renderTemplate('footer', $data);
    }

    public function getAllCcS(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
        $ccS = [];
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token')
        );
        $result = $this->_model->getCloudCredentials($headers);
        $this->log($result);
        switch ($result['status']) {
            case (200):
                if(!empty($result['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
                    foreach($result['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $value){
                        switch($value->cloudName){
                            case 'azureBlob':
                                $value->cloudNameInCaps = 'Azure Blob';
                                break;
                            case 'ibmCloud':
                                $value->cloudNameInCaps = 'IBM Cloud';
                                break;
                            case 'amazon':
                                $value->cloudNameInCaps = 'Amazon s3 Services';
                                break;
                            case 'localStorage':
                                $value->cloudNameInCaps = 'Local Storage';
                                break;
                            default:
                                $value->cloudNameInCaps = '';
                                break;
                        }

                        $ccS = array_merge(array($value), $ccS);
                    }
                }
                $response = array(
                    'result' => 'success',
                    'ccS' => $ccS,
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function saveCloudCredentials(){
        if(!empty($_POST['cloudType'])){
            $data = array(
                'cloudName' => $_POST['cloudType'],
                'identity' => ($_POST['cloudType'] == "localStorage") ? "local" : $_POST['identity'],
                'credential' => $_POST['accessKey'],
                'containerName' => !empty($_POST['containerName']) ? $_POST['containerName'] : '',
                'endPointUrl' => ($_POST['cloudType'] == "localStorage") ? $_POST['localStorage'] : $_POST['epaUrl'],
            );
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'          => $this->session->get('token')
            );
            $result = $this->_model->saveCloudCredentials($headers, $data);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('savedCloudCredentials')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
        }
    }

    public function removeCloudCredentials(){
        if(!empty($_POST['identity'])){
            $headers = array(
                'Content-Type'      => 'application/json',
                'identity'          => $_POST['identity'],
                'token'             => $this->session->get('token')
            );
            $result = $this->_model->removeCloudCredentials($headers);
            $this->log("headers: ". json_encode($headers), 'info');
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('removeCloudCredentials')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function aadCredentials(){
        $headers = array(
            'Content-Type'  => 'application/json',
            'token'         => $this->session->get('token'),
            'Accept'        => 'application/json',
                'Accept-Charset'=> 'utf-8',
        );
        $result = $this->_model->getAadDetails($headers);
        $this->log("ggggggggggg : ".$result['body']->{'data'}->{'clientId'},"info");
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('aadCredentials'),
            'active' => 'settings',
            'data' => $result['body']->{'AADCredentialsElement'},
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        $this->log("ggggggggggg : ".$data['data']->{'clientId'},"info");

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('settings/aadCredentials', $data);
        View::renderTemplate('footer', $data);
    }

    public function getAadCredentials(){
            $headers = array(
                'Content-Type'      => 'application/json',
                'Accept'        => 'application/json',
                'token'             => $this->session->get('token')
            );

            $result = $this->_model->getAadDetails($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'aad'    => $result['body']->{'AADCredentialsElement'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (404):
                    $result = array(
                        'result' => 'fail',
                        'msg' => "No AAD Credentials found"
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function writeAddAadSettings(){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),

            );
            $combine = array_combine($_POST['aadGroupNameadd'], $_POST['aadProductTypeadd']);
            $groupConfig = array('groupConfig' => $combine );


            $this->log("Result:".json_encode($groupConfig), "info");
            $data = array(
                'clientIdForLogin'  => $_POST['clientIdForLoginadd'],
                'clientId'          => $_POST['clientIdadd'],
                'secretKey'         => $_POST['secretKeyadd'],
                'tenentId'          => $_POST['tenentIdadd'],
                'redirectURI'       => $_POST['redirectURIadd'],
                'groupConfig'       => $combine,
            );
            $this->log("DATA :".json_encode($data), "info");
            $result = $this->_model->saveAadDetails($headers,json_encode($data));
            $this->log("Result:".json_encode($result), "info");


            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('Details has been successfully saved')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function writeAadSettings(){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),

            );
            $combine = array_combine($_POST['aadGroupName'], $_POST['aadProductType']);
            $groupConfig = array('groupConfig' => $combine );


            $this->log("Result:".json_encode($groupConfig), "info");
            $data = array(
                'clientIdForLogin'  => $_POST['clientIdForLogin'],
                'clientId'          => $_POST['clientId'],
                'secretKey'         => $_POST['secretKey'],
                'tenentId'          => $_POST['tenentId'],
                'redirectURI'       => $_POST['redirectURI'],
                'groupConfig'       => $combine,
            );
            $this->log("DATA :".json_encode($data), "info");
            $result = $this->_model->saveAadDetails($headers,json_encode($data));
            $this->log("Result:".json_encode($result), "info");


            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('Details has been successfully saved')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

}
