<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Url;
use Models\Device;
use Models\Login;
use Models\User;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class LoginController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->language->load('login');
        $this->_model = new Login();
        $this->verifyAndCleanItUp();
        if(AMAZON_CHECK == true){
            $this->isFirstCustomer();
        }
    }

    public function isFirstCustomer(){
        $cloudName = $this->_model->isFirstCustomer();
        if($cloudName == 'true'){
            Url::redirect('amazon/create');
        }else{
            $this->session->put('cloudName', $cloudName);
        }
    }

    /**
     * Below method will load login template
     */
    public function index(){
        $this->auth->loggedOutCheck();

        $data['title'] = $this->language->get('indexPageName');
        $data['indexPage_message'] = $this->language->get('indexPage_message');
        $data['csrf_token'] = $this->setCSRFToken();
        $data['cloudName'] = $this->session->get('cloudName');

        View::renderTemplate('LoginHeader', $data);
        View::render('login/login', $data);
        View::renderTemplate('LoginFooter', $data);
    }

    public function sleep(){
        $this->auth->loginCheck();

        $this->session->put('token', null);
        $data['title'] = $this->language->get('sleep');
        $data['indexPage_message'] = $this->language->get('sleep_message');
        $data['csrf_token'] = $this->setCSRFToken();
        $data['userName'] = $this->session->get('userName');

        View::renderTemplate('LoginHeader', $data);
        View::render('login/sleep', $data);
        View::renderTemplate('LoginFooter', $data);
    }

    /**
     * Retrieves the rules from Helpers/Rules
     * Retrieves the filters from Helpers/Rules
     */
    public function authenticate(){
        if(!empty($_POST)){
            $rules = array(
                'username'    => 'required|max_len,100|min_len,3',
                'password'    => 'required'
            );
            $filters = array(
                'username' 	  => 'trim|sanitize_string',
                'password'	  => 'trim|base64_encode',
                'email'    	  => 'trim|sanitize_email'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);
            if($validate === true){

                $options = array(
                    'userName'       => htmlspecialchars_decode($_POST['username'],ENT_QUOTES),
                    'password'       => $this->getEncryptPassword($_POST['password']),
		            'clientType'     => 'PORTAL'
                );
                $result = $this->_model->authenticate($options);
                $this->log(json_encode($options), 'info');
                switch ($result['status']) {
                    case (200):
                        if($result['body']->userElement->{'serverBackupEnabled'} == false && $result['body']->userElement->{'syncWebAccessEnabled'} == false && $result['body']->userElement->{'syncEnabled'} == false && $result['body']->userElement->{'backupEnabled'} == false){
                            $result = array(
                                'result' => 'fail',
                                'asdasd' => $result,
                                'msg' => 'Both Sync and Backup has been disabled for this account please contact your administrator'
                            );
                            echo json_encode($result);
                            exit();
                        }
                        $this->session->refresh();
                        $this->session->put('token', $result['headers']->container['token']);
                        $this->session->put('firstLogin1', $result['headers']->container['firstLogin']);
                        $this->session->put('cloudName', $result['headers']->container['cloudName']);
                        $this->session->put('connectedClients', $result['headers']->container['connectedClients']);
                        foreach($result['body']->userElement as $key => $value){
                            $this->session->put($key, $value);
                            $this->log('details: '.$key.' - '.$value, 'info');
                        }
                        if($result['body']->userElement->{'syncWebAccessEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == false){
                            $this->session->put('syncEnabled', true);
                        }
//                        $this->session->put('syncEnabled', false);
//                        $this->session->put('backupEnabled', false);
//                        $this->session->put('serverBackupEnabled', true);
                        $redirectUrl = DIR;
      /*if(LOGIN_REDIRECT_FILES_PAGE == true && $result['body']->userElement->{'syncEnabled'} == true || $result['body']->userElement->{'syncWebAccessEnabled'} == true){
                            $redirectUrl = 'sync/files';
                        }*/
/*                        if($result['body']->userElement->{'syncEnabled'} == true && $result['body']->userElement->{'backupEnabled'} == true ||
$result['body']->userElement->{'backupEnabled'} == true){
                            $redirectUrl = DIR;
                        }
                        elseif($result['body']->userElement->{'syncEnabled'} == true){
if($result['body']->userElement->{'admin'} == false && $result['body']->userElement->{'readOnlyAdmin'} == false){
$redirectUrl = 'myAccount';
}else {
                            $redirectUrl = 'cloudInfo';
}
                        }
*/

			if($result['body']->userElement->{'admin'} == true || $result['body']->userElement->{'readOnlyAdmin'} == true){
				if(($result['body']->userElement->{'backupEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == true) || ($result['body']->userElement->{'backupEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == false)){
					$redirectUrl = DIR;
				}
				else{
					$redirectUrl = 'cloudInfo';
				}

			}

			else{
				if(($result['body']->userElement->{'backupEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == true) || ($result['body']->userElement->{'backupEnabled'} == true && $result['body']->userElement->{'syncEnabled'} == false)){
					$redirectUrl = 'backup/devices';
				}
				else{
				$redirectUrl = 'sync/files';
				}

			}

                        $this->session->put('loggedIn', true);
                        $this->clearCsrfToken();
if(DISABLE_BLUVAULT == true){
if($result['body']->userElement->{'admin'} == true || $result['body']->userElement->{'readOnlyAdmin'} == true){
$re = 'cloudInfo';
}else if($result['body']->userElement->{'admin'} == false && $result['body']->userElement->{'readOnlyAdmin'} == false){
$re = 'myAccount';
}
$result = array(
                            'result' => 'success',
                            'asdadsasd' => $result['body'],
                            'redirectUrl' => $re
                        );
 } else {
if($result['body']->userElement->{'guest'} == '1'){
$redirectUrl = 'share/filesSharedWithMe';
}

                        $result = array(
                            'result' => 'success',
                            'asdadsasd' => $result['body'],
                            'redirectUrl' => !empty($this->session->get('redirectUrl')) ? $this->session->get('redirectUrl') : $redirectUrl
                        );
}
                        echo json_encode($result);
                        exit();
                    case (401):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('401')
                        );
                        echo json_encode($result);
                        exit();
                    case (416):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('416')
                        );
                        echo json_encode($result);
                        exit();
                    case (403):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('403')
                        );
                        echo json_encode($result);
                        exit();
                    case (424):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('424')
                        );
                        echo json_encode($result);
                        exit();
                    case (400):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('400')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result['status'],
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            $result = array(
                'result' => 'fail',
                'msg' => $this->language->get('noData')
            );
            echo json_encode($result);
        }
    }

    public function authFromAgent(){
        $this->cleanSession();
        $userName 		= urldecode($_GET['u']);
        $cloudName 		= htmlentities($_GET['c']);
        $token 			= htmlentities($_GET['t']);
        $urlRedirect 	= htmlentities($_GET['url']);
        $id 			= htmlentities($_GET['id']);

        if(!empty($userName) && !empty($cloudName) && !empty($token)){
            $data['title'] = $this->language->get('Logging in user '.$userName);
            $data['message'] = $this->language->get('from Agent');

            View::renderTemplate('LoginHeader', $data);
            View::render('login/agentLogin', $data);
            View::renderTemplate('LoginFooter', $data);

            $result = $this->authenticateFromAgent($userName, $token, $cloudName);

            switch ($result['status']) {
                case (200):

                    if($urlRedirect == 'mydevices'){
                        Url::redirect('backup/devices');
                        exit();
                    }elseif($urlRedirect == 'mybackup'){
                        $headers = array(
                            'Content-Type' => 'application/json',
                            'token'     => $this->session->get('token'),
                            'deviceUUID' => $id
                        );
                        $result = $this->_model->getDeviceDetails($headers);
                        $this->log('loginDetails '. json_encode($result), 'info');
                        if (strpos(strtolower((string)$result['body']->{'BSDeviceInfoElement'}->{'osType'}), 'windows') === false) {
                            $osType = 'mac';
                        }else{
                            $osType = 'windows';
                        }
                        $deviceName = (string)$result['body']->{'BSDeviceInfoElement'}->{'deviceName'};
                        Url::redirect('user/device/policyInfo/'.$userName.'/'.$id.'/'.$osType.'?deviceName='.$deviceName);
                        exit();
                    }elseif($urlRedirect == 'files'){
                        if(!empty($_GET['param'])){
                            $this->session->put('syncFilePath', $_GET['param']);
                        }else{
                            $this->session->put('syncFilePath', null);
                        }
                        Url::redirect('sync/files');
                        exit();
                    }elseif($urlRedirect == 'search'){
                        $_SESSION['search'] = 'enabled';
                        Url::redirect('dashboard');
                        exit();
                    }elseif($urlRedirect == 'settings'){
                        $_SESSION['search'] = 'enabled';
                        Url::redirect('user/settings/'.$userName);
                        exit();
                    }elseif($urlRedirect == 'filesrevision'){
                        $paths = explode('/', $_GET['param']);
                        array_pop($paths);
                        $path = implode('/', $paths);
                        $this->session->put('syncFilePath', $path);
                        $_SESSION['openFileRevision'] = $_GET['param'];
                        Url::redirect('sync/files');
                        exit();
                    }else{
                        Url::redirect('dashboard');
                        exit();
                    }
                    break;
                case (421):
                    header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");

                    $data['error'] = "Oops! Error While processing..";
                    $data['message'] = $this->language->get('401');

                    View::renderTemplate('header', $data);
                    View::render('error/404', $data);
                    View::renderTemplate('footer', $data);
                    exit;

                case (401):
                    header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");

                    $data['error'] = "Oops! Error While processing..";
                    $data['message'] = $this->language->get('401U');

                    View::renderTemplate('header', $data);
                    View::render('error/404', $data);
                    View::renderTemplate('footer', $data);
                    exit;
                case (416):

                    header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");

                    $data['error'] = "Oops! Error While processing..";
                    $data['message'] = $this->language->get('416');

                    View::renderTemplate('header', $data);
                    View::render('error/404', $data);
                    View::renderTemplate('footer', $data);
                    exit;
                default:
                    header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");

                    $data['error'] = "Oops! Error While processing..";
                    $data['message'] = $this->language->get('default');

                    View::renderTemplate('header', $data);
                    View::render('error/404', $data);
                    View::renderTemplate('footer', $data);
                    exit;
            }

        }else{
            header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");

            $data['title'] = '404';
            $data['error'] = "Oops! Page not found..";
            $data['message'] = "Some Parameters passed from your agent was missing, please trying connecting again if you are still facing issues, contact your administrator. Alternatively use your credentials to login through portal directly.";

            View::renderTemplate('header', $data);
            View::render('error/404', $data);
            View::renderTemplate('footer', $data);
        }

    }

    public function authenticateFromAgent($userName, $token, $cloudName){

        $headers = array(
            'userName' => $userName,
            'token' => $token
        );

        $result = $this->_model->authFromAgent($headers);

        if($result['status'] == 200 || $result['status'] == 202){
            $userHeaders = array(
                'token' => $result['headers']->{'container'}['token']
            );

            $user = new User();
            $userResult = $user->getUserDetails($userHeaders, $userName);
            $this->log('USer Details: '. json_encode($userResult), 'info');
            if($userResult['status'] == 200){
                $userDetails = array(
                    'token' => $result['headers']->{'container'}['token'],
                    'firstLogin' => (string)$userResult['body']->{'is-first-login'},
                    'cloudName' => $cloudName,
                    'connectedClients' => '',
                    'userId' => (string)$userResult['body']->{'user-id'},
                    'userName' => (string)$userResult['body']->{'user-name'},
                    'passwdHash' => (string)$userResult['body']->{'password-hash'},
                    'emailId' => (string)$userResult['body']->{'email-id'},
                    'securityRecoveryKey' => (string)$userResult['body']->{'recovery-key'},
                    'active' => (string)$userResult['body']->{'is-active'},
                    'admin' => (string)$userResult['body']->{'is-admin'},
                    'readOnlyAdmin' => (string)$userResult['body']->{'is-readonly-admin'},
                    'lastModifiedTimestamp' => (string)$userResult['body']->{'last-modified-timestamp'},
                    'miniCloudElementList' => (string)$userResult['body']->{'mini-clouds'},
                    'syncEnabled' => (string)$userResult['body']->{'sync-enabled'},
                    'backupEnabled' => (string)$userResult['body']->{'backup-enabled'},
                    'serverBackupEnabled' => (string)$userResult['body']->{'server-backup-enabled'},
                    'storageSelected' => (string)$userResult['body']->{'storage-selected'},
                    'externalStorageAuthorized' => (string)$userResult['body']->{'externalstorage-authorized'},
                    'shareEnabled' => (string)$userResult['body']->{'share-enabled'},
                    'policyName' => (string)$userResult['body']->{'policy-name'},
                    'migrationToolEnabled' => (string)$userResult['body']->{'migrationtool-enabled'},
                    'supportEnabled' => (string)$userResult['body']->{'support-enabled'},
                    'pmsEnabled' => (string)$userResult['body']->{'pms-enabled'},
                    'reportEnabled' => (string)$userResult['body']->{'report-enabled'},
                    'azureBlobEnabled' => (string)$userResult['body']->{'is-azureblob-enabled'},
                    'deleted' => (string)$userResult['body']->{'is-deleted'},
                    'ldapEnabled' => (string)$userResult['body']->{'ldap-enabled'}
                );

                $this->session->refresh();

                foreach($userDetails as $key => $value){
                    if($value == 'true'){
                        $value = true;
                    }elseif($value == 'false'){
                        $value = false;
                    }
                    $this->session->put($key, $value);
                }

                $this->session->put('loggedIn', true);
                $this->clearCsrfToken();

                return $userResult;

            }else{
                return $userResult;
            }
        }else{
            return $result;
        }


    }

    /**
     * Define Password Rest title and load template files
     */
    public function passwordReset(){
        $this->auth->loggedOutCheck();

        $data['title'] = $this->language->get('passwordResetPageName');
        $data['passwordReset_message'] = $this->language->get('passwordReset_message');
        $data['csrf_token'] = $this->setCSRFToken();

        View::renderTemplate('LoginHeader', $data);
        View::render('login/passwordReset', $data);
        View::renderTemplate('LoginFooter', $data);
    }

    public function passwordRest(){
        if(!empty($_POST)){

            $headers = array(
                'Content-type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'userName' => $_POST['userName']
            );

            $result = $this->_model->passwordRest($headers);
            $userName = $result['headers']->{'container'}['userName'];

            switch ($result['status']) {
                case (200):
                    $emailProps = array(
                        'actionOn' => 'User',
                        'action' => 'password-reset',
                        'toAdmins' => 'false',
                        'actionBy' => $userName,
                        'cloudName' => $_POST['cloudName'],
                        'downloadLink' => Url::basePath('restPassword?tok='.$result['headers']->{'container'}['reset-password-key'].'&user='.$userName.'&cloudname='.$_POST['cloudName']),
                        'recipents' => array(
                            array(
                                'userName' => $userName,
                                'email' => $result['headers']->{'container'}['email']
                            )
                        )
                    );

                    $emailResult = $this->sendMail($emailProps);

                    $result = array(
                        'result' => 'success',
                        'location' => Url::basePath('login'),
                        '$emailProps' => json_encode($emailProps),
                        'emailResult' => json_encode($emailResult),
                        'link' => Url::basePath('restPassword?tok='.$result['headers']->{'container'}['reset-password-key'].'&user='.$_POST['userName'].'&cloudname='.$_POST['cloudName']),
                        'msg' => 'An Email has been sent to your email address please follow the directions to reset your password'
                    );
                    unset($result['$emailProps']);
                    unset($result['emailResult']);
                    unset($result['link']);
                    echo json_encode($result);
                    exit();

                case (400):
                    if($result['headers']->{'container'}['ldapuser'] == 'true'){
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'You are not allowed to change your password'
                        );
                    }else if($result['headers']->{'container'}['changepassword'] == 'false'){
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'You are not allowed to reset your password'
                        );
                    }else {
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('400')
                        );
                    }
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result['status'],
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            $result = array(
                'result' => 'fail',
                'msg' => $this->language->get('noData')
            );
            echo json_encode($result);
        }
    }

    /**
     * Define Password Rest title and load template files
     */
    public function restPassword(){
        $this->auth->loggedOutCheck();
        if(!empty($_GET['tok']) && !empty($_GET['user']) && !empty($_GET['cloudname'])){

            $this->session->put('token', $_GET['tok']);
            $this->session->put('user', $_GET['user']);
            $this->session->put('restCloudName', $_GET['cloudname']);

	if(!empty($_GET['setpassword']))
	{
	    $this->session->put('setpassword', $_GET['setpassword']);
	}

            $headers = array(
                'userName' => $_GET['user'],
                'reset-password-key' => $_GET['tok']
            );
            $url = PARACLOUD_URL.urlencode($_GET['cloudname']).DS.'verify'.DS.'password'.DS.'key';
            $result = $this->_model->verifyPasswordRest($headers, $url);
            $data['showForm'] = ($result['status'] == 200) ? true : false;

            $data['title'] = $this->language->get('passwordResetPageName');
            $data['passwordReset_message'] = $this->language->get('Setting a new <b>Password</b>');
            $data['csrf_token'] = $this->setCSRFToken();

            View::renderTemplate('LoginHeader', $data);
            View::render('login/restPassword', $data);
            View::renderTemplate('LoginFooter', $data);
        }else{
            Url::redirect('404');
        }
    }

    public function updatePassword(){
        if(!empty($_POST['password'])){
            
	  if($this->session->get('setpassword') == "true"){
            $headers = array(
                'Content-type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'reset-password-key' => $this->session->get('token'),
                'username' => $this->session->get('user'),
                'password' => hash('sha512', $_POST['password']),
		'setpassword' => $this->session->get('setpassword')
            );
	 }else {
	   $headers = array(
                'Content-type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'reset-password-key' => $this->session->get('token'),
                'username' => $this->session->get('user'),
                'password' => hash('sha512', $_POST['password'])
                );
	 }
            $url = PARACLOUD_URL.$this->session->get('restCloudName').DS.'user/update/password';
            $result = $this->_model->updatePassword($headers, $url);

            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'location' => Url::basePath('login'),
                        'msg'  => $this->language->get('passwordChanged')
                    );
                    echo json_encode($response);
                    exit;

                case (400):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('400')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result['status'],
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            $result = array(
                'result' => 'fail',
                'msg' => $this->language->get('noData')
            );
            echo json_encode($result);
        }
    }


    public function logout(){
        $this->session->forget();
        Url::redirect('login');
    }

    public function getEncryptPassword($password){
         $cipher = 'aes-128-cbc';
         $key = md5('a9985ebcae81', $raw_output=true);
 	     $iv_length = openssl_cipher_iv_length($cipher);
 	     $iv = openssl_random_pseudo_bytes($iv_length);
 	     $ciphertext = openssl_encrypt($password, $cipher, $key, OPENSSL_RAW_DATA, $iv);
         $composed = $iv.$ciphertext;
         $composed_encoded = base64_encode($composed);	
         return $composed_encoded;
    }

    public function cleanSession(){
        $this->session->put('token', '');
        $this->session->put('firstLogin', '');
        $this->session->put('firstLogin1', '');
        $this->session->put('cloudName', '');
        $this->session->put('connectedClients', '');
        $this->session->put('userId', '');
        $this->session->put('userName', '');
        $this->session->put('passwdHash', '');
        $this->session->put('emailId', '');
        $this->session->put('securityRecoveryKey', '');
        $this->session->put('active', '');
        $this->session->put('admin', '');
        $this->session->put('readOnlyAdmin', '');
	$this->session->put('isGuest', '');
        $this->session->put('lastModifiedTimestamp', '');
        $this->session->put('miniCloudElementList', '');
        $this->session->put('syncEnabled', '');
        $this->session->put('backupEnabled', '');
        $this->session->put('storageSelected', '');
        $this->session->put('externalStorageAuthorized', '');
        $this->session->put('shareEnabled', '');
        $this->session->put('policyName', '');
        $this->session->put('migrationToolEnabled', '');
        $this->session->put('supportEnabled', '');
        $this->session->put('pmsEnabled', '');
        $this->session->put('reportEnabled', '');
        $this->session->put('azureBlobEnabled', '');
        $this->session->put('deleted', '');
        $this->session->put('ldapEnabled', '');
    }



    public function sendMail($emailProps){

        $headers = array(
            'Content-Type' => 'application/json',
            'token' => $this->session->get('token')
        );

        return $this->_model->sendMail($headers, $emailProps);

    }

}
