<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use DOMDocument;
use Helpers\Url;
use Models\Index;
use Helpers\Auth;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class IndexController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->auth->tokenCheck();
        $this->language->load('index');
        $this->_model = new Index();
        if(Auth::checkUserPermission('readOnlyAdmin') == false){
            Url::redirect('myAccount');
        }
    }

    /**
     * Define Index page title and load template files
     */
    public function index() {
        if(Auth::checkCloudPermission('sync') == false && (Auth::checkCloudPermission('backup') == false && Auth::checkCloudPermission('serverBackup') == true)){
            Url::redirect('server/dashboard');
        }elseif(Auth::checkCloudPermission('sync') == true && (Auth::checkCloudPermission('backup') == false && Auth::checkCloudPermission('serverBackup') == false)){
            Url::redirect('sync/files');
        }
        $data = array(
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        $data['title'] = $this->language->get('indexPageName');
        $data['subPageName'] = $this->language->get('indexPage_message');
        $data['active'] = 'home';
        if($this->session->get('lastLoggedInTime') != ""){
	    $data['time'] = date('d-M-y H:i:s', ((int)$this->session->get('lastLoggedInTime')/1000));
        }
        if($this->session->get('admin') == true){
        $data['isAdmin'] = 'true';
        }

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('index/index', $data);
        View::renderTemplate('footer', $data);
    }

    /**
     * Define Index page title and load template files
     */
    public function serverBackup() {
        $data = array(
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        $data['title'] = $this->language->get('indexPageName');
        $data['subPageName'] = $this->language->get('indexPage_message');
        $data['active'] = 'home';

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('index/serverBackup', $data);
        View::renderTemplate('footer', $data);
    }
}
