<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<span ng-controller="SyncController" xmlns="http://www.w3.org/1999/html">
<div class="container">
    <?php if(WORKFLOW_IMAGE == true){ ?>
        <div class="row text-center" style="margin-top: 5%">
            <img src="<?=Url::templatePath()?>images/wiproFilesWorkfloChange.png" />
        </div>
    <?php } ?>
    <div class="row">
	<?php if($data['lastLoginTime'] != "nil"){ ?>
	<div class="col-lg-6" style="float:right;margin-top: 5px;">
		<span style="font-size: 12px;float:right;"><?php if($data['lastLoginTime']) { ?>Last Login Time : <?php echo $data['lastLoginTime']; } ?></span>
	</div>
	<?php } ?>
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>

        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main">
    <span class="hide shareType"><?php if(SHARE_WITHIN_ORG == true){echo 'shareWith';}else{echo 'share';}?></span>
    <span class="hide currentPage"><?='files'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <span class="hide openFileRevision"><?php if(!empty($_SESSION['openFileRevision'])){echo htmlspecialchars($_SESSION['openFileRevision']);}else{echo 'none';}$_SESSION['openFileRevision'] = null;?></span>
    <span class="hide shareDefault7Days"><?php if(SHARE_DEFAULT_7_DAYS == true){echo 'true';}else{echo 'false';}?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>
        <div id="drop-target" class="col-lg-11 col-md-11 col-sm-11 filePanel">
            <div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body">
                    <ul class="nav navbar-nav nav-breadcrumb" id="breadCrumb">
                        <li ng-repeat="value in crumb track by $index"><a href="javascript:;" ng-click="updateFileListFromBreadCrumb(value, $index)" class="toolTip" data-toggle="tooltip" data-placement="top" data-original-title="{{ stripAddr(value) }}" ng-cloak>{{ stripAddr(value) }}</a></li>
                    </ul>
		    <span class="hide" id="cru"></span>
                    <span class="hide" id="filesListing"></span>
                    <ul class="nav navbar-nav pull-right nav-actions">
                        <li><a class="viewAction toolTip" ng-click="view()" data-toggle="tooltip" data-placement="top" title="View" style="display: none" href="javascript:;"><i class="fa fa-eye"></i></a></li>
                        <li><a class="versionsAction toolTip" ng-click="versions()" data-toggle="tooltip" data-placement="top" title="Versions" style="display: none" href="javascript:;"><i class="fa fa-clock-o"></i></a></li>
                        <?php if($data['policy']['shareEnabled'] == "1"){ ?>
                            <?php if(SHARE_WITHIN_ORG == false){?>
                                <li><a class="shareAction toolTip" ng-click="share()" data-toggle="tooltip" data-placement="top" title="Share" style="display: none" href="javascript:;"><i class="fa fa-share"></i></a></li>
                            <?php }else{ ?>
                                <li><a class="shareAction toolTip" ng-click="shareWith()" data-toggle="tooltip" data-placement="top" title="Share" style="display: none" href="javascript:;"><i class="fa fa-share"></i></a></li>
                            <?php } ?>
                        <?php } ?>
                        <li><a class="downloadAction toolTip" ng-click="download('')" data-toggle="tooltip" data-placement="top" title="Download" style="display: none" href="javascript:;"><i class="fa fa-download"></i></a></li>
                        <li><a class="deleteAction toolTip" ng-click="delete()" data-toggle="tooltip" data-placement="top" title="Delete" style="display: none" href="javascript:;"><i class="fa fa-trash"></i></a></li>
                        <li><a class="renameAction toolTip" ng-click="rename()" data-toggle="tooltip" data-placement="top" title="Rename" style="display: none" href="javascript:;"><i class="fa fa-edit"></i></a></li>
                        <li><a class="cutAction toolTip" ng-click="cut()" data-toggle="tooltip" data-placement="top" title="Cut" style="display: none" href="javascript:;"><i class="fa fa-cut"></i></a></li>
                        <li><a class="copyAction toolTip" ng-click="copy()" data-toggle="tooltip" data-placement="top" title="Copy" style="display: none" href="javascript:;"><i class="fa fa-copy"></i></a></li>
                        <li ng-if="selectedFilesForCopyCut.length > 0 && currentCrumb != selectedFilesForCopyCutFromPath"><a class="pasteAction toolTip" ng-click="paste()" data-toggle="tooltip" data-placement="top" title="Paste" href="javascript:;"><i class="fa fa-clipboard"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="panel panel-default files-panel no-box-shadow" ng-if="items.length > 0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <thead>
                        <tr>
                            <th class="clickAble" ng-click="sortType = 'fileName'; sortReverse = !sortReverse">
                                Name
                                <span ng-show="sortType == 'fileName' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'fileName' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'type'; sortReverse = !sortReverse">
                                Type
                                <span ng-show="sortType == 'type' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'type' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'modifiedTime'; sortReverse = !sortReverse">
                                Last modified
                                <span ng-show="sortType == 'modifiedTime' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'modifiedTime' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'rawSize'; sortReverse = !sortReverse">
                                Size
                                <span ng-show="sortType == 'rawSize' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'rawSize' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody id="selectable"
                               selectable="tr"
                               selectable-list="items"
                               selectable-out="selected"
                               selectable-options="{filter:'.selectable', cancel: 'a.folder,.cancel'}"
                               selectable-events="{start:'selectionStart($selected)', stop:'selectionStop($selected)'}"
                               block-ui="myBlockUI"
                               context-menu="menuOptions">
                        <tr ng-repeat="value in items | orderBy:sortType:sortReverse" ng-class="{'selectable': value.selectable == 'yes'}">
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'Mini Cloud'" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileList(crumbString+value.fileName, value.fileName, true)" style="cursor: pointer; color: #585f69;"><span ng-bind-html="value.fileName | charLimit"></span></a></td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'Folder'" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileList(crumbString+value.fileName, value.fileName, true)" style="cursor: pointer; color: #585f69;"><span ng-bind-html="value.fileName | charLimit"></span></a></td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'File'" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a style="cursor: pointer; color: #585f69;"><span ng-bind-html="value.fileName | charLimit"></span> <span class="text-warning" ng-if="value.storagePlace.length <= 0"><i class="fa fa-arrow-up faa-float animated"></i></span></a></td>
                            <td ng-cloak> {{ value.type }} </td>
                            <td ng-cloak> {{ value.modifiedTime | timeAgo: 'medium' }} </td>
                            <td ng-if="value.type == 'Mini Cloud'" ng-cloak> - </td>
                            <td ng-if="value.type == 'Folder'" ng-cloak> - </td>
                            <td ng-if="value.type == 'File'" ng-cloak>
                                {{ value.size }}
                                <!--                                    <span ng-if="value.storagePlace.length <= 0" class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span>-->
                            </td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'Mini Cloud'" ng-cloak>-</td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'Folder'" ng-cloak>-</td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'File'" ng-cloak>
                                <a class="folder toolTip" data-toggle="tooltip" data-placement="top" title="View"  style="cursor: pointer; color: #585f69;" ng-click="selectFileForView(value.fileName)"><i class="fa fa-eye"></i></a>
                                &nbsp;&nbsp;
                                <a class="folder toolTip" data-toggle="tooltip" data-placement="top" title="Download"  style="cursor: pointer; color: #585f69;" ng-click="selectFileForDownload(value.fileName)"><i class="fa fa-download"></i></a>
                                &nbsp;&nbsp;
                                <?php if($data['policy']['shareEnabled'] == "1"){ ?>
                                    <?php if(SHARE_WITHIN_ORG == false){?>
                                        <a class="folder toolTip" data-toggle="tooltip" data-placement="top" title="Share"  style="cursor: pointer; color: #585f69;" ng-click="selectFileForShare(value.fileName, 'share')"><i class="fa fa-share"></i></a>
                                    <?php }else{ ?>
                                        <a class="folder toolTip" data-toggle="tooltip" data-placement="top" title="Share With"  style="cursor: pointer; color: #585f69;" ng-click="selectFileForShare(value.fileName, 'shareWith')"><i class="fa fa-share"></i></a>
                                    <?php } ?>
                                <?php } ?>
                                &nbsp;&nbsp;
                                <a class="folder toolTip" data-toggle="tooltip" data-placement="top" title="Delete"  style="cursor: pointer; color: #585f69;" ng-click="selectFileForDelete(value.fileName)"><i class="fa fa-trash"></i></a>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <?php if(DISABLE_SHOW_PG_ICON){ ?>
                <div class="panel-footer" ng-if="items.length > 0">
                    <p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span> means that the particular file is still on the Parablu Server.</p>
                </div>
                <?php } ?>
                <div class="panel-footer">
                    <center><p style="margin: 0 0 0px;"> Drag files here to upload</p></center>
                </div>
            </div>
            <div class="text-center status" style="display: none;">
                <h3>There are no files or folders</h3>
            </div>
            <div class="modal fade deleteConfirmation">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Delete Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <p>
                                <span ng-if="selected.length == 1">Do you want to permanently delete the below selected file or a folder?</span>
                                <span ng-if="selected.length > 1">Do you want to permanently delete the below selected files and folders?</span>
                            </p>
                            <p>
                                <span ng-repeat="value in selected track by $index">
                                    <span ng-if="$index == (selected.length - 1)">{{ value.name }}</span>
                                    <span ng-if="$index < (selected.length - 1)">{{ value.name+', ' }}</span>
                                </span>
                            </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" ng-click="deleteFile()" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal" id="paraviewContainer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h5 class="modal-title">Loading ...</h5>
                        </div>
                        <br/><br/>
                        <div class="modal-body">
                            <div class="pageContainer" style="display: none;"></div>
                            <div class="pdfContainer" style="display: none;"></div>
                            <div class="excelContainer" style="display: none;"></div>
                            <div class="content" style="display: none;"></div>
                            <div class="imageViewer" style="display: none;"></div>
                            <div class="paraviewLoading" style="margin-top: 15%">
                                <img width="5%" src="<?=Url::templatePath('default/images/gears.gif');?>" />
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade whiteAndBigModal syncFileVersions">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">File Versions list - File Name: <span>{{ selectedFiles[0].fileName }}</span></h4>
                        </div>
                        <div class="modal-body">
                            <div class="table-responsive" style="margin-top: -20px;">
                                <hr/>
                                <div class="h4 loading text-center">Loading.....</div>
                                <table class="table table-striped fileVersionsTable" style="display: none;">
                                    <tbody>
                                    <tr ng-repeat="value in fileVersions track by $index">
                                        <td ng-if="$index != 0" ng-cloak>{{ value.version + (fileVersions.length-$index)}}</td>
                                        <td ng-if="$index == 0" ng-cloak>{{ value.version + (fileVersions.length-$index)}} (Current Version)</td>
                                        <td class="text-success" ng-if="value.status == 'ADDED'" ng-cloak>{{ value.status }}</td>
                                        <td class="text-info" ng-if="value.status == 'MODIFIED'" ng-cloak>{{ value.status}}</td>
                                        <td class="text-info" ng-if="value.status == 'RESTORED'" ng-cloak>{{ value.status}}</td>
                                        <td class="text-danger" ng-if="value.status == 'DELETED'" ng-cloak>{{ value.status}}</td>
                                        <td ng-cloak>by {{ value.fileUser }}</td>
                                        <td ng-if="value.fileDevice.length > 0" ng-cloak>from {{ value.fileDevice }}</td>
                                        <td ng-if="value.fileDevice.length <= 0" ng-cloak>from Portal</td>
                                        <td ng-cloak>on {{ value.modifiedTime }}</td>
                                        <td ng-cloak>{{ value.size }}</td>
                                        <td>
                                            <a class="btn btn-small btn-primary" ng-click="revisionCommentBox($index)"><i class="fa fa-comment"></i></a>
                                            <a ng-hide="value.status == 'DELETED'" class="btn btn-small btn-info" ng-click="download($index, true)"><i class="fa fa-download"></i></a>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="commentsModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="saveComment(fileRevisionComments)">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Save File version comments</h4>
                            </div>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label for="fileRevisionComments">Comments</label>
                                    <textarea class="form-control" id="fileRevisionComments" required></textarea>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveComments btn btn-success">Save Comments</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="modal fade" id="rename" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="saveRename(changedName)">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Rename the selected file or folder</h4>
                            </div>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label for="changedName">Name</label>
                                    <input type="text" class="form-control" id="changedName" required />
                                </div>
                                <span class="renameError"></span>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="modal fade" id="shareWith" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                    <div style="margin: 15px;">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                
                    </div>
                    <ul class="nav nav-tabs">
                      <li id="shareWithHome"  class="active"><a data-toggle="tab" href data-target="#home">Share</a></li>
                      
                      <li id="twoWay" ><a data-toggle="tab" href data-target="#shareWithSimple">Share</a></li>
                    </ul>
                    <div class="tab-content">
                      <div id="home" class="tab-pane fade in active">
                        <form id="fileShareForm" data-parsley-validate ng-submit="saveShareWith('simple')">
                            <div class="modal-body shareLoading">
                                <span>Loading ...</span>
                            </div>
                            <div style="display: none;" class="modal-body shareWithBodyStatus">File has already been shared</div>
                            <div class="modal-body shareBody shareWithBody">
                                <div class="form-group">
                                    <div class="">
                                        <div class="mt-md mb-md">
                                            <div class="form-group <?php if(SHARE_DEFAULT_7_DAYS == true){echo 'hide';} ?>">
                                                <label for="till">Valid Till <span class="shareWithRemoveValidUntil text-danger clickable" style="display: none;">(Remove Validity)</span></label>
                                                <input type="text" class="shareWithValidTill form-control" id="till" placeholder="Valid Till" data-parsley-trigger="change" readonly>
                                            </div>
                                            <div class="form-group">
                                                <label for="listOfUsers">Email Address: </label>
                                                <input type="text" class="listOfUsers form-control" name="userNames" id="listOfUsers" placeholder="Enter Email address" />
                                            </div>
                                            <div class="form-group">
                                                <label for="shareWithSubject">Subject: </label>
                                                <input type="text" style="width:100%" class="shareWithSubject" name="shareWithSubject" id="shareWithMessage" placeholder="Enter your Subject" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="256" />
                                            </div>
                                            <div class="form-group">
                                                <label for="message">Message: </label>
                                                <textarea style="width:100%" class="shareWithMessage" name="shareWithMessage" id="shareWithMessage" placeholder="Enter your message" data-parsley-trigger="change" data-parsley-minlength="2" data-parsley-maxlength="512"></textarea>
                                            </div>
                                            <div class="granular hide">
                                                <?php if($data['policy']['preventDownloadEnabled'] != "1"){ ?>
                                                    <div class="hide">
                                                        <label for="shareWithEnableDownload">Enable Download (with View): </label>
                                                        <input type="checkbox" id="shareWithEnableDownload" class="shareWithEnableDownload" />
                                                    </div>
                                                <?php } else{ ?>
                                                    <label for="shareWithEnableDownload">Enable Download (with View): </label>
                                                    <input type="checkbox" id="shareWithEnableDownload" class="shareWithEnableDownload" checked />
                                                <?php } ?>
                                                <div class="hide">
                                                    <label for="shareWithEnableView">Allow View: </label>
                                                    <input type="checkbox" id="shareWithEnableView" class="shareWithEnableView" checked />
                                                </div>
                                                <span>Note:- Files will be shared with a default validity of 7 days.</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                
                                <button type="submit" class="shareBtn btn btn-success">Share</button>
                                <a ng-click="updateSharePolicy()" style="display: none;" class="updateShareWithDetails btn btn-danger">OK</a>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <a ng-click="unShare()" style="display: none;" class="unShareBtn btn btn-danger">Un-Share</a>
                            </div>
                        </form>
                        </div>
                      
                      <div id="shareWithSimple" class="tab-pane fade">
                        <form id="fileShareForm" data-parsley-validate ng-submit="saveShareWith('two')">
                            <div class="modal-body shareLoading">
                                <span>Loading ...</span>
                            </div>
                            <div style="display: none;" class="modal-body shareWithBodyStatus">File has already been shared</div>
                            <div class="modal-body shareBody shareWithBody">
                                <div class="form-group">
                                    <div class="">
                                        <div class="mt-md mb-md">
                                            <p>Two-way Sharing: <span><input type="checkbox" id="twoWayShareWithSwitch" class="twoWayShareWithSwitch"/></span></p>
                                            <span class="twoWayShareWithPasswordBlock" style="display:none;">
                                                <div class="form-group">
                                                    <label for="password">Password</label>
                                                    <input type="password" class="form-control" id="sharePasswordWith" placeholder="Enter a Password" data-parsley-minlength="6" <?php if($data['policy']['complexPasswordRequired'] == "1"){ ?>data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')"<?php } ?> data-parsley-trigger="change" <?php if($data['policy']['complexPasswordRequired'] == "1"){echo " required"; }?>>
                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
                                                    <input type="password" class="form-control" id="reSharePasswordWith" placeholder="Re-Type the password" data-parsley-minlength="6" data-parsley-equalto="#sharePasswordWith" data-parsley-trigger="change">
                                                </div>
                                            </span>
                                            <div class="form-group <?php if(SHARE_DEFAULT_7_DAYS == true){echo 'hide';} ?>">
                                                <label for="till">Valid Till <span class="shareWithRemoveValidUntil text-danger clickable" style="display: none;">(Remove Validity)</span></label>
                                                <input type="text" class="shareWithValidTill form-control" id="till" placeholder="Valid Till" data-parsley-trigger="change" readonly>
                                            </div>
                                            <div class="form-group">
                                                <label for="listOfUsers">Email Address: </label>
                                                <input type="text" class="listOfUsersTwo form-control" name="userNames" id="listOfUsersTwo" placeholder="Enter Email address" />
                                            </div>
                                            <div class="form-group">
                                                <label for="shareWithSubjectTwo">Subject: </label>
                                                <input type="text" style="width:100%" class="shareWithSubjectTwo" name="shareWithSubjectTwo" id="shareWithSubjectTwo" placeholder="Enter your Subject" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="256" />
                                            </div>
                                            <div class="form-group">
                                                <label for="message">Message: </label>
                                                <textarea style="width:100%" class="shareWithMessageTwo" name="shareWithMessageTwo" id="shareWithMessageTwo" placeholder="Enter your message" data-parsley-trigger="change" data-parsley-minlength="2" data-parsley-maxlength="512"></textarea>
                                            </div>
                                            <div class="granular hide">
                                                <?php if($data['policy']['preventDownloadEnabled'] != "1"){ ?>
                                                    <div class="hide">
                                                        <label for="shareWithEnableDownload">Enable Download (with View): </label>
                                                        <input type="checkbox" id="shareWithEnableDownload" class="shareWithEnableDownload" />
                                                    </div>
                                                <?php } else{ ?>
                                                    <label for="shareWithEnableDownload">Enable Download (with View): </label>
                                                    <input type="checkbox" id="shareWithEnableDownload" class="shareWithEnableDownload" checked />
                                                <?php } ?>
                                                <div class="hide">
                                                    <label for="shareWithEnableView">Allow View: </label>
                                                    <input type="checkbox" id="shareWithEnableView" class="shareWithEnableView" checked />
                                                </div>
                                                <span>Note:- Files will be shared with a default validity of 7 days.</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                
                                <button type="submit" class="shareBtn btn btn-success">Share</button>
                                <a ng-click="updateSharePolicy()" style="display: none;" class="updateShareWithDetails btn btn-danger">OK</a>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <a ng-click="unShare()" style="display: none;" class="unShareBtn btn btn-danger">Un-Share</a>
                            </div>
                        </form>
                      </div>
                    </div>
                        
                    </div>
                </div>
            </div>
            <div class="modal fade" id="share" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                    <ul class="nav nav-tabs">
                      <li class="active" id="shareHome" ><a data-toggle="tab" href data-target="#home1">Share</a></li>
                      <li id="twoWayNormal"><a data-toggle="tab" href data-target="#shareWithNormal">Share</a></li>
                    </ul>

                    <div class="tab-content">
                      <div id="home1" class="tab-pane fade in active">
                        <form id="fileShareForm" data-parsley-validate ng-submit="saveShare()">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Share Details</h4>
                            </div>
                            <div class="modal-body shareLoading">
                                <span>Loading ...</span>
                            </div>
                            <div class="modal-body shareBody">
                                <div class="form-group">
                                    <div class="">
                                        <div class="mt-md mb-md">
                                            <h4>Password Protected:
                                                <span><input type="checkbox" class="sharePasswordSwitch" <?php if($data['policy']['complexPasswordRequired'] == "1"){echo "checked='checked'"; echo "disabled ='true'";}?>/></span>
                                            </h4>
                                            <span class="sharePasswordBlock" <?php if($data['policy']['complexPasswordRequired'] == "1"){ ?>style="display: block;" <?php }else { ?> style="display:none;"<?php } ?>>
                                                <div class="form-group">
                                                    <label for="password">Password</label>
                                                    <input type="password" class="form-control" id="sharePassword" placeholder="Enter a Password" data-parsley-minlength="6" <?php if($data['policy']['complexPasswordRequired'] == "1"){ ?>data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')"<?php } ?> data-parsley-trigger="change" <?php if($data['policy']['complexPasswordRequired'] == "1"){echo " required"; }?>>
                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
                                                    <input type="password" class="form-control" id="reSharePassword" placeholder="Re-Type the password" data-parsley-minlength="6" data-parsley-equalto="#sharePassword" data-parsley-trigger="change">
                                                </div>
                                            </span>
                                            <div class="form-group">
                                                <label for="till">Valid Till <span class="removeValidUntil text-danger clickable" style="display: none;">(Remove Validity)</span></label>
                                                <input type="text" class="form-control till" id="till" placeholder="Valid Till" data-parsley-trigger="change" readonly <?php if($data['policy']['expiredDate'] == "1"){ echo " required"; }?>>
                                            </div>
                                            <div class="granular">
                                                <?php if($data['policy']['preventDownloadEnabled'] != "1"){ ?>
                                                    <div class="hide">
                                                        <label for="enableDownload">Enable Download (with View): </label>
                                                        <input type="checkbox" id="enableDownload" class="enableDownload" />
                                                    </div>
                                                <?php } else { ?>
                                                    <label for="enableDownload">Enable Download (with View): </label>
                                                    <input type="checkbox" id="enableDownload" class="enableDownload" checked />
                                                <?php } ?>
                                                <div class="hide">
                                                    <label for="enableView">Allow View: </label>
                                                    <input type="checkbox" id="enableView" class="enableView" checked />
                                                </div>
                                            </div>
                                            <div class="shareLinkBlock" style="display: none;">
                                                <h4>
                                                    Share the below link to share the file:
                                                    
                                                    <a ng-click="sendEmailShareLink()" title="Email" class="clickAble pull-right sendEmailShareLink"><i class="fa fa-envelope"></i></a>
                                                </h4>
                                                <textarea class="js-copytextarea shareLink" style="width:100%;word-wrap: break-word;" rows="5" readonly></textarea>
                                                <h4><a class="js-textareacopybtn clickAble pull-right" title="Copy Share Link" style="margin-left: 5px;" ng-click="copyToClipboard()"><i class="fa fa-clipboard" aria-hidden="true"></i></a></h4>
                                                <!--<h5 id="copyTarget" class="shareLink" style="word-wrap: break-word;"></h5>-->
                                                <br>
                                            </div>
                                            <div class="form-group sendEmailShareForm hide">
                                                <label for="emails">Emails</label>
                                                <textarea name="emails" ng-model="emails" class="form-control" id="emails"> </textarea>
                                                <a ng-click="sendShareEmail(emails)" class="btn btn-small btn-default shareEmailLinkSendBtn"> Send</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                
                                <button type="submit" class="shareBtn btn btn-success">Share</button>
                                <a ng-click="updateSharePolicy()" style="display: none;" class="updateShareDetails btn btn-danger">OK</a>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <a ng-click="unShare()" style="display: none;" class="unShareBtn btn btn-danger">Un-Share</a>
                            </div>
                        </form>
                      </div>
                      <div id="shareWithNormal" class="tab-pane fade">
                        <form id="fileShareForm" data-parsley-validate ng-submit="saveShareWith('normal')">
                        <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Share Details</h4>
                            </div>
                            <div class="modal-body shareLoading">
                                <span>Loading ...</span>
                            </div>
                            <div style="display: none;" class="modal-body shareWithBodyStatus">File has already been shared</div>
                            <div class="modal-body shareBody shareWithBody">
                                <div class="form-group">
                                    <div class="">
                                        <div class="mt-md mb-md">
                                            <p>Two-way Sharing: <span><input type="checkbox" id="twoWayShareSwitch" class="twoWayShareSwitch"/></span></p>
                                            <span class="twoWaySharePasswordBlock" style="display:none;">
                                                <div class="form-group">
                                                    <label for="password">Password</label>
                                                    <input type="password" class="form-control" id="twoWayNormalSharePassword" placeholder="Enter a Password" data-parsley-minlength="6" <?php if($data['policy']['complexPasswordRequired'] == "1"){ ?>data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')"<?php } ?> data-parsley-trigger="change" <?php if($data['policy']['complexPasswordRequired'] == "1"){echo " required"; }?>>
                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
                                                    <input type="password" class="form-control" id="reTwoWayNormalSharePassword" placeholder="Re-Type the password" data-parsley-minlength="6" data-parsley-equalto="#twoWayNormalSharePassword" data-parsley-trigger="change">
                                                </div>
                                            </span>
                                            <div class="form-group <?php if(SHARE_DEFAULT_7_DAYS == true){echo 'hide';} ?>">
                                                <label for="till">Valid Till <span class="shareWithRemoveValidUntil text-danger clickable" style="display: none;">(Remove Validity)</span></label>
                                                <input type="text" class="shareWithValidTill form-control" id="till" placeholder="Valid Till" data-parsley-trigger="change" readonly>
                                            </div>
                                            <div class="form-group">
                                                <label for="listOfUsers">Email Address: </label>
                                                <input type="text" class="listOfUsersNormal form-control" name="userNames" id="listOfUsersNormal" placeholder="Enter Email address" />
                                            </div>
                                            <div class="form-group">
                                                <label for="shareWithMessageNormal">Subject: </label>
                                                <input type="text" style="width:100%" class="shareWithSubjectNormal" name="shareWithSubjectNormal" id="shareWithSubjectNormal" placeholder="Enter your Subject" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="256" />
                                            </div>
                                            <div class="form-group">
                                                <label for="message">Message: </label>
                                                <textarea style="width:100%" class="shareWithMessageNormal" name="shareWithMessageNormal" id="shareWithMessageNormal" placeholder="Enter your message" data-parsley-trigger="change" data-parsley-minlength="2" data-parsley-maxlength="512"></textarea>
                                            </div>
                                            <div class="granular hide">
                                                <?php if($data['policy']['preventDownloadEnabled'] != "1"){ ?>
                                                    <div class="hide">
                                                        <label for="shareWithEnableDownload">Enable Download (with View): </label>
                                                        <input type="checkbox" id="shareWithEnableDownload" class="shareWithEnableDownload" />
                                                    </div>
                                                <?php } else{ ?>
                                                    <label for="shareWithEnableDownload">Enable Download (with View): </label>
                                                    <input type="checkbox" id="shareWithEnableDownload" class="shareWithEnableDownload" checked />
                                                <?php } ?>
                                                <div class="hide">
                                                    <label for="shareWithEnableView">Allow View: </label>
                                                    <input type="checkbox" id="shareWithEnableView" class="shareWithEnableView" checked />
                                                </div>
                                                <span>Note:- Files will be shared with a default validity of 7 days.</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                
                                <button type="submit" class="shareBtn btn btn-success">Share</button>
                                <a ng-click="updateSharePolicy()" style="display: none;" class="updateShareWithDetails btn btn-danger">OK</a>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <a ng-click="unShare()" style="display: none;" class="unShareBtn btn btn-danger">Un-Share</a>
                            </div>
                        </form>
                      </div>
                    </div>
                        
                    </div>
                </div>
            </div>
            <div class="modal fade" id="deleteConfirm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" id="myModalLabel">Delete Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <p class="deleteConfirmMessage"></p>
                            <br/><br/>
                            <a type="button" class="pull-right btn btn-default" style="margin-top: -30px" data-dismiss="modal">Cancel</a>
                            <a type="button" ng-click="deletedConfirmed()" style="margin-top: -30px; margin-right: 5px;" class="pull-right btn btn-danger">Delete</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<div id="UploadAl" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">File Uploaded Already</h4>
            </div>
            <div class="modal-body">
                <div>
                    <div align="center">
                        Click ok to Upload New Files...!
                    </div>
                    <span class="pull-right">
                        <button type="button" id="UploadAlready" class="btn btn-default">Ok</button>
                    </span>
                    <br/><br/>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="networkFailure" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Network Failure.... !</h4>
            </div>
            <div class="modal-body">
                <div>
                    <div align="center">
                        Files are not uploaded successfully....!!
                    </div>
                    <span class="pull-right">
                        <button type="button" id="netFail" class="btn btn-default">Ok</button>
                    </span>
                    <br/><br/>
                </div>
            </div>
        </div>
    </div>
</div>
   <pre id="log" style="height: 300px; overflow: auto;display:none;"></pre>
<?php View::renderTemplate('partials/search', $data); ?>

</div><!-- /.container -->
</span>
<?php View::renderTemplate('partials/scripts')?>
<script>
    <?php if(SHARE_WITHIN_ORG == false){?>
    $('.till').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+1y',
        todayHighlight: true
    }).on('changeDate', function(){
        if($('.till').val() != ''){
            $('.removeValidUntil').show();
        }
    });

    $('.removeValidUntil').on('click', function(){
        $('.till').val('');
        $('.removeValidUntil').hide();
    });
    <?php }else{ ?>
    $('.shareWithValidTill').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+1y',
        todayHighlight: true
    }).on('changeDate', function(){
        if($('.shareWithValidTill').val() != ''){
            $('.shareWithRemoveValidUntil').show();
        }
    });

    $('.shareWithRemoveValidUntil').on('click', function(){
        $('.shareWithValidTill').val('');
        $('.shareWithRemoveValidUntil').hide();
    });
    <?php } ?>
    jQuery(document).bind("keyup keydown", function(e){
        if(e.ctrlKey && e.keyCode == 80){
            return false;
        }
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/SyncController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    //    var assignUsers = $(".assignUsers").select2({
    //        ajax: {
    //            url: "<?//=DIR?>//"+"userGroups/getAllUnBlockedUsersWithGroups",
    //            dataType: 'json',
    //            delay: 250,
    //            data: function (params) {
    //                return {
    //                    q: params.term,
    //                    page: params.page
    //                };
    //            },
    //            processResults: function (data, params) {
    //                params.page = params.page || 1;
    //                if(data.users.length > 0){
    //                    $('.assignSaveBtn').removeAttr('disabled');
    //                }
    //                return {
    //                    results: $.map(data.users, function (o) {
    //                        return { id: o.userName, text: o.emailId, img: o.profilePic };
    //                    }),
    //                    pagination: {
    //                        more: (params.page * 30) < data.total_count
    //                    }
    //                };
    //            },
    //            cache: true
    //        },
    //        escapeMarkup: function (markup) { return markup; },
    //        templateResult: selectTemplateResult,
    //        templateSelection: selectTemplateSelection,
    //        placeholder: 'Select users'
    //    });
    //
    //    function selectTemplateResult(users){
    //        if(users.text != undefined){
    //            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
    //            if(users.img){
    //                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
    //            }
    //            template += users.text + "</div></div>";
    //            return template;
    //        }else{
    //            return "<div class='select2-user-result'>Fetching...</div>";
    //        }
    //    }
    //
    //    function selectTemplateSelection(users){
    //        return users.text;
    //    }
    //
    //    $('#assignUsers').on('hidden.bs.modal', function () {
    //        window.location.reload(true);
    //    })
</script>
<script>
    var copyTextareaBtn = document.querySelector('.js-textareacopybtn');

copyTextareaBtn.addEventListener('click', function(event) {
  var copyTextarea = document.querySelector('.js-copytextarea');
  copyTextarea.select();

  try {
    var successful = document.execCommand('copy');
    var msg = successful ? 'successful' : 'unsuccessful';
    //console.log('Copying text command was ' + msg);
  } catch (err) {
    //console.log('Oops, unable to copy');
  }
});
</script>
<script>
  var cloudName = $('.cloudNameConstant').html();    
var i = 0;
var rrr = $('.filesListing').html();
/*var ext = "*";
if($('.fileIncludeExtensions').html().length > 0){
ext = $('.fileIncludeExtensions').html();
}*/

//console.log("GGGG  "+rrr);
      var uploader = new plupload.Uploader({
//        runtimes : 'html5,flash,silverlight,html4',
runtimes : 'html5,flash,gears,browserplus,silverlight,html4',
        drop_element : 'drop-target',
        browse_button : 'pickfiles',
        max_file_size : '100gb',
        autostart: true,
        prevent_duplicates: true,
        url : "<?=DIR?>"+"up",
        chunk_size : '2mb',
        filters : [
          /*  {title : "Image files", extensions : "jpg,gif,png,jpeg"},
            {title : "Text files", extensions : "txt"},
            {title : "Video files", extensions :"mp4"},
            {title : "Zip files", extensions : "zip" },
            {title : "Excel Files", extensions: "xls,xslx,csv"},
            {title :"Custom files", extensions:"xlsx,pdf,docx,png,xls,gif,doc,tar,exe,jar,crt,ods,odt"}*/
	    //{title :"Custom files", extensions:ext}
        ],
//      retry_interval: 1,
max_retries: 10,
        multi_selection: true,
      });

        uploader.bind('Init', function(up, params) {
                if (uploader.features.dragdrop) {
                document.getElementById('debug').innerHTML = "";
                var target = $("drop-target");
                target.ondragover = function(event) {
                event.dataTransfer.dropEffect = "copy";
                };

                target.ondragenter = function() {
                this.className = "dragover";
                };
                target.ondragleave = function() {
                this.className = "";
                };
target.ondrop = function() {
                this.className = "";
                };
                }
                });

        uploader.bind('PostInit',function() {
                        document.getElementById('filelist').innerHTML = '';
                });

/*uploader.bind('UploadFile', function(up, file) {
var allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
var name = file.name;
var extension = name.substring(name.lastIndexOf('.')+1);
if(allowedFileAttributes.indexOf(extension)>=0){
return true;
}
else {
up.splice(0);
}

});


uploader.bind('BeforeUpload', function(up, file) {
var allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
var extension = file.name.substring(file.name.lastIndexOf('.')+1);
if(allowedFileAttributes.indexOf(extension)>=0){
return true;
}
else {
return false;
}

});*/

        uploader.bind('FilesAdded', function(up, files) {
if(!$('#uploadFilesNew').hasClass('in')){
                //Do something here
                $('#uploadFilesNew').modal('show');
                }

        var ddd = $('#filesListing').html();
var fileUploadLimitSize = $('.file-limit-size').html();
var allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
var notAllowedFileAttributes = $('.fileExcludeExtensions').html().replace(' ', '').split(',');
//console.log("LIMITSIZE : "+fileUploadLimitSize);
//console.log("ALLOWED : "+allowedFileAttributes);
//console.log("NOT ALLOWED : "+notAllowedFileAttributes);
//      console.log("VVVVVVV : "+ddd);
                plupload.each(files, function(file) {
var filename = file.name;
                        if(filename.length > 25)
                        {
                            filename = filename.substring(0,25)+"...";      
                        }
angular.element(document.getElementById('cru')).scope().check(file);  //new
var extension = file.name.substring(file.name.lastIndexOf('.')+1);
if(!document.getElementById("filelist"))
{
var g = document.createElement('div');
g.setAttribute("id","filelist");
}

if($('.fileIncludeExtensions').html().length == 0 && $('.fileIncludeExtensions').html().length == 0){
//console.log("inside == 0");
if(fileUploadLimitSize.length > 0)
		{console.log("inside uploadsize");
		if(file.size <= (fileUploadLimitSize*1000*1000))
			{//console.log("above bar");
document.getElementById('filelist').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:80%;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file-photo-o fa-1x ng-binding" style="float:left;"> ' + filename + '  (' + plupload.formatSize(file.size) + ') </i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-danger" onclick="deleteThisFile(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
}}

if($('.fileIncludeExtensions').html().length > 0){
if(fileUploadLimitSize.length > 0)
		{
		if(file.size <= (fileUploadLimitSize*1000*1000))
			{
if(allowedFileAttributes.indexOf(extension)>=0)
{
document.getElementById('filelist').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:80%;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file-photo-o fa-1x ng-binding" style="float:left;"> ' + filename + '  (' + plupload.formatSize(file.size) + ') </i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-danger" onclick="deleteThisFile(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
}
}}

if($('.fileExcludeExtensions').html().length > 0){
if(notAllowedFileAttributes.indexOf(extension)>=0)
{
//alert("Not Allowed");
setTimeout(function(){ location.reload(); }, 1000);
}else{
if(fileUploadLimitSize.length > 0)
                {
                if(file.size <= (fileUploadLimitSize*1000*1000))
                        {

document.getElementById('filelist').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:80%;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file-photo-o fa-1x ng-binding" style="float:left;"> ' + filename + ' (' + plupload.formatSize(file.size) + ')</i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-danger" onclick="deleteThisFile(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
else{
setTimeout(function(){ location.reload(); }, 1000);
}
}
}}

//angular.element(document.getElementById('cru')).scope().check(file);
/*if(ddd.indexOf(file.name)>=0)
                                {
uploader.stop();
if(document.getElementById('filesQueue'+file.id) !== null){
var elem = document.getElementById('filesQueue'+file.id);
elem.remove();
}

//$('#UploadAl').modal('show');
angular.element(document.getElementById('cru')).scope().alreadyExists(file.name);
}

else{
if(!$('#uploadFilesNew').hasClass('in')){
                //Do something here
                $('#uploadFilesNew').modal('show');
                }
//                setTimeout(function () { uploader.start(); }, 100);
}
*/
i++;
});
setTimeout(function () { uploader.start(); }, 3000);

                });

function deleteThisFile(item) {
var id = $(item).attr("id");
var x = id.replace('cancel', '');
var name = $(item).attr("name");
//console.log("File Id : "+x);
//var x = i.replace('dele', '');
uploader.removeFile(uploader.getFile(x));
$('#filesQueue'+x).remove();
angular.element(document.getElementById('cru')).scope().cancelFile(name);
//delete file start
console.log("inside delete for: "+name);
//start foldername
var d = new Date();         //get the date
                var month = d.getMonth();   //get the month
                var day = d.getDate().toString();   //get the day and convert to string
                var year = d.getFullYear(); //get the year
                year = year.toString().substr(-2);  //pull the last two digits of the year
month = (month + 1).toString();     //increment month by 1 since it is 0 indexed and converts month to a string
                if (month.length === 1)     //if month is 1-9 pad right with a 0 for two digits
                {
                month = "0" + month;
                }
                if (day.length === 1)       //if day is between 1-9 pad right with a 0 for two digits
                {
                day = "0" + day;
                }
                //return the string "MMddyy"
//              console.log(day+month+year);        //return the string "ddMMyy"
                var folderName = day+month+year;
//end foldername
$.ajax({
   url: "<?=DIR?>"+"del",
   type: 'post',
   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+folderName+"/"+name+".part"},
   success: function(response){
// Changing image source when remove
    if(response == 1){
//alert("file deleted successfully");
    }
   }
  });
//delete file end
}

        uploader.bind('UploadComplete', function(up, files) {
                $('#pickfiles').show();
//                document.getElementById('filesQueue').remove();
                $('#uploadFilesNew').modal('hide');
//setTimeout(function () { location.reload(); }, 5000);
var list = document.getElementById("filelist");
var inner = document.getElementById("fileQueue");
while (list.hasChildNodes()) {   

    list.removeChild(list.firstChild);
}

                });
var attempts = 0;
uploader.bind('Error', function(up, args) {
//angular.element(document.getElementById('cru')).scope().errorNetwork();
/*console.log( "Error during upload." );
console.log("Errors code"+args.code);
console.log("Errors msg : "+args.message);
console.log("attempts" +attempts);
log('[Error] ', args);*/
attempts++;
});

uploader.bind('FilesRemoved', function(up, files) {
                // Called when files are removed from queue
  //              log('[FilesRemoved]');
  
                plupload.each(files, function(file) {
//                    log('  File:', file);
                });
            });

        uploader.bind('UploadProgress', function(up, file) {
//console.log("File Id: "+file.id);
if(document.getElementById('per'+file.id) !== null){
                document.getElementById('per'+file.id).innerHTML = file.percent+" %";
                document.getElementById('myBar'+file.id).style.position = "absolute";
		document.getElementById('myBar'+file.id).style.width = file.percent+"%";
                document.getElementById('myBar'+file.id).style.height = "100%";
		document.getElementById('uploadStatusText'+file.id).innerHTML = "Upload in progress...";
                $("#myBar"+file.id).attr("aria-valuenow", file.percent);
}
                });

        uploader.bind('ChunkUploaded', function(up, file, info) {
var isOffline;	
    console.log( "Chunk uploaded....!!" );

window.addEventListener('offline', offlineIndi);
function offlineIndi() {
    isOffline = setTimeout(function(){  $('#networkFailure').modal('show'); }, 120000);
}

window.addEventListener('online', onlineIndi);
function onlineIndi() {
    clearTimeout(isOffline);
}

//console.log("Info : " +info.status+ " Response : "+info.response);
                });

        uploader.bind('FileUploaded' , function(up, file, info) {
		document.getElementById('uploadStatusText'+file.id).innerHTML = "Working on your file. Please wait until the process is completed....";
                var obj = JSON.parse(info.response);
                //start
                var d = new Date();         //get the date
                var month = d.getMonth();   //get the month
                var day = d.getDate().toString();   //get the day and convert to string
                var year = d.getFullYear(); //get the year
                year = year.toString().substr(-2);  //pull the last two digits of the year
month = (month + 1).toString();     //increment month by 1 since it is 0 indexed and converts month to a string
                if (month.length === 1)     //if month is 1-9 pad right with a 0 for two digits
                {
                month = "0" + month;
                }
                if (day.length === 1)       //if day is between 1-9 pad right with a 0 for two digits
                {
                day = "0" + day;
                }
                //return the string "MMddyy"
//              console.log(day+month+year);        //return the string "ddMMyy"
                var folderName = day+month+year;
                var filePath = $('#cru').html();
                //var cloudName = $('.cloudNameConstant').html();
                var headers = {
                        'token'          : $('.uploadToken').html(),
                        'userName'       : $('.uploadUserName').html(),
                        'is-exists'      : 'false',
			'file-path'      : filePath.slice(0,-1),
                        'file-name'      : file.name,
                        'file-size'      : file.size,
                        'is-folder'      : 'false',
                        'is-base-folder' : 'false',
                        'gatewayName'    : $('.blukryptIP').html(),
                        'modified'       : '11/13/2014 10:05:21',
                        'fileTmpPath'    : "/parablu/"+cloudName+"/sync-upload/Portal/"+folderName+"/"+file.name,
                };

                $.ajax({
url: $('.blukryptIPAddress').html()+$('.cloudNameConstant').html()+'/sync/portal/new/upload/file/',
headers: headers,
method: 'POST'
}).done(function(data,textStatus,xhr){
//var jData = JSON.parse(data);
//console.log("DATA : "+jData.status);
//console.log("String : "+JSON.stringify(data));
//console.log("String2 : "+JSON.stringify(textStatus));
//console.log("Try1 : "+xhr.status);
if(xhr.status == '200') {
$("#filesQueue"+file.id).remove();
angular.element(document.getElementById('cru')).scope().updateFileList('root', 'root', true, true);
angular.element(document.getElementById('cru')).scope().uploadSuccess(file.name);
//delete file start
$.ajax({
   url: "<?=DIR?>"+"del",
   type: 'post',
   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+folderName+"/"+file.name},
   success: function(response){
// Changing image source when remove
    if(response == 1){
//alert("file deleted successfully");
    }
   }
  });
//delete file end
}
        }).error(function(data){
//              alert("Error"+file.name);
angular.element(document.getElementById('cru')).scope().uploadFailed(file.name);
                });
});

uploader.init();
/*function deleteFile(i) {
console.log("File Id : "+i);
//var x = i.replace('dele', '');
uploader.removeFile(uploader.getFile(i));
    }
*/
function log() {
        var str = "";
 
        plupload.each(arguments, function(arg) {
            var row = "";
if (typeof(arg) != "string") {
                plupload.each(arg, function(value, key) {
                    // Convert items in File objects to human readable form
                    if (arg instanceof plupload.File) {
                        // Convert status to human readable
                        switch (value) {
                            case plupload.QUEUED:
                                value = 'QUEUED';
                                break;
 
                            case plupload.UPLOADING:
                                value = 'UPLOADING';
                                break;
 
                            case plupload.FAILED:
                                value = 'FAILED';
                                break;
case plupload.DONE:
                                value = 'DONE';
                                break;
                        }
                    }
 
                    if (typeof(value) != "function") {
                        row += (row ? ', ' : '') + key + '=' + value;
                    }
                });
 
                str += row + " ";
            } else {
                str += arg + " ";
            }
        });
var log = $('#log');
        log.append(str + "\n");
        log.scrollTop(log[0].scrollHeight);
    }

</script>
<style>
#myProgress {
    position: relative;
    height: 10px;
    background-color: grey;
}
#drop-target2 {
        border: 1px dashed #999;
        color: #999;
        cursor: pointer;
 }

      #drop-target1 {
        border: 10px dashed #999;
        text-align: center;
        color: #999;
        font-size: 20px;
        width: 600px;
        height: 300px;
        line-height: 300px;
        cursor: pointer;
      }

      #drop-target.dragover {
        background: rgba(255, 255, 255, 0.4);
        border-color: green;
      }
</style>
<script>
function disableF5(e) { if ((e.which || e.keyCode) == 116) e.preventDefault(); };
$(document).on("keydown", disableF5);
</script>
<script>
$("#closeNewUpload").click(function() {
uploader.stop();
$('#pickfiles').show();
var list = document.getElementById("filelist");
var inner = document.getElementById("fileQueue");
while (list.hasChildNodes()) {   

console.log(list.firstChild.id);
    list.removeChild(list.firstChild);
}
$('#uploadFilesNew').modal('hide');
location.reload();

});
</script>
<script>
$("#UploadAlready").click(function() {
$('#UploadAl').modal('hide');
$('#uploadFilesNew').modal('hide');
location.reload();
});
</script>
<script>
$("#netFail").click(function() {
$('#networkFailure').modal('hide');
$('#uploadFilesNew').modal('hide');
location.reload();
});
</script>

<script>
window.addEventListener("dragover",function(e){
  e = e || event;
//  console.log(e);
  if (e.target.tagName != "drop-target") { // check wich element is our target
    e.preventDefault();
  }
},false);
window.addEventListener("drop",function(e){
  e = e || event;
//  console.log(e);
  if (e.target.tagName != "drop-target") {  // check wich element is our target
    e.preventDefault();
    document.getElementById('drop-target').style.border = "none";
  }  
},false);
document.getElementById('drop-target').addEventListener("dragenter", function(event) {
        document.getElementById('drop-target').style.border = "3px dashed #f27331";
});
</script>
<script>
	var twoWaySwitchWith = document.getElementById('twoWayShareWithSwitch');
    if(twoWaySwitchWith){
        twoWaySwitchWith.onchange = function() {
            if(twoWaySwitchWith.checked == true){
                $('.twoWayShareWithPasswordBlock').show();
                $('#sharePasswordWith').attr('required', 'required');
                $('#sharePasswordWith').attr('required', 'required');
            }else{
                $('.twoWayShareWithPasswordBlock').hide();
                $('#sharePasswordWith').removeAttr('required', 'required');
                $('#sharePasswordWith').removeAttr('required', 'required');
            }
        };
    }

    var twoWaySwitch = document.getElementById('twoWayShareSwitch');
    if(twoWaySwitch){
        twoWaySwitch.onchange = function() {
            if(twoWaySwitch.checked == true){
                $('.twoWaySharePasswordBlock').show();
                $('#twoWayNormalSharePassword').attr('required', 'required');
                $('#twoWayNormalSharePassword').attr('required', 'required');
            }else{
                $('.twoWaySharePasswordBlock').hide();
                $('#twoWayNormalSharePassword').removeAttr('required', 'required');
                $('#twoWayNormalSharePassword').removeAttr('required', 'required');
            }
        };
    }
</script>
