<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('report/dashboard')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='storageUtilizedByPG'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading"><h3><?=$data['crumb1']?></div>
                    <div class="panel-body">
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <a ng-click="exportToExcel('#storageUtilizedByPG', 'Storage Utilized by PG', storageUtilizedByPG)" class="btn btn-default">Export To excel</a>
                        <br/><br/>
                        <table id="storageUtilizedByPG" class="table table-bordered storageUtilizedByPG" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="sortType = 'gatewayName'; sortReverse = !sortReverse">
                                    <?=Language::show('gatewayName', 'keywords')?>
                                    <span ng-show="sortType == 'gatewayName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'gatewayName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'sizeInMB'; sortReverse = !sortReverse">
                                    <?=Language::show('storageUsed', 'keywords')?>
                                    <span ng-show="sortType == 'sizeInMB' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'sizeInMB' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in storageUtilizedByPG | orderBy:sortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.gatewayName }}</td>
                                <td ng-cloak>{{ value.sizeInMB }} MB</td>
                            </tr>
                            </tbody>
                        </table>
                        <div class="h4 storageUtilizedByPGError text-center" style="display: none">There was not details found for Storage utilized by PG</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('#from').datepicker({
        format: 'dd/mm/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+2y',
        todayHighlight: true
    });
    $('#from').datepicker('update', '01/01/2015');
    $('#to').datepicker({
        format: 'dd/mm/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+2y',
        todayHighlight: true
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>