<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('dashboard')?>"><?='Dashboard'?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='failedBackupByDate'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading"><h3><?=$data['crumb1']?></div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <form ng-submit="updateFailedBackupByDate(search.from, search.to, 0)" data-parsley-validate>
                                    <div class="row">
                                        <div class="col-lg-2">
                                            <label for="searchUsername">User Id</label>
                                            <select name="searchUsername"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsername"
                                                    ng-model="search.userName"
                                                    id="searchUsername"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                                <option value="all" selected>all</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-2">
                                            <label for="searchDeviceName">Device Name</label>
                                            <select class="searchDeviceName form-control" id="searchDeviceName" readonly>
                                                <option value="all">all</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-2">
                                            <div class="form-group">
                                                <label for="from">From Date</label>
                                                <input type="text" class="form-control" id="from" ng-model="search.from" placeholder="From Date" data-parsley-trigger="change" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-2">
                                            <div class="form-group">
                                                <label for="to">To Date</label>
                                                <input type="text" class="form-control" id="to" ng-model="search.to" placeholder="To Date" data-parsley-trigger="change" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <button type="submit" style="margin-top: 25px" class="btn btn-default">View</button>
                                            <a style="margin-top: 25px" ng-click="exportToExcel('#FailedBackup', 'Failed Backup', failedBackup)" class="btn btn-default">Download</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <table id="FailedBackup" class="table table-bordered failedBackup" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?=Language::show('deviceName', 'keywords')?>
                                    <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'startTime'; sortReverse = !sortReverse">
                                    <?=Language::show('startTime', 'keywords')?>
                                    <span ng-show="sortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'whenFailed'; sortReverse = !sortReverse">
                                    <?=Language::show('endTime', 'keywords')?>
                                    <span ng-show="sortType == 'whenFailed' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'whenFailed' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'failedReason'; sortReverse = !sortReverse">
                                    <?=Language::show('reason', 'keywords')?>
                                    <span ng-show="sortType == 'failedReason' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'failedReason' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in failedBackup | orderBy:sortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.userName }}</td>
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <td class="text-center" ng-cloak>{{ value.startTime }}</td>
                                <td class="text-center" ng-cloak>{{ value.whenFailed }}</td>
                                <td class="text-center" ng-cloak>{{ value.failedReason }}</td>
                            </tr>
                            </tbody>
                        </table>
                        <div class="h4 failedBackupError text-center" style="display: none">There was not details found for Failed Backup</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('#from').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+0d',
        todayHighlight: true
    });
    $('#to').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        endDate: '+0d',
        todayHighlight: true
    });
    var currentDate = new Date();
    $('#to').datepicker('update', currentDate);
    currentDate.setDate(currentDate.getDate() - 31);
    $('#from').datepicker('update', currentDate);
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchUsername').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDevice",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select user'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        if(users.devices != undefined) {
            if (users.devices.length > 0){
                $('.searchDeviceName').removeAttr("readonly", "readonly");
                var options = "";
                users.devices.forEach(function (device) {
                    options += '<option value="' + device + '">' + device + '</option>'
                });
                $('.searchDeviceName').html(options);
            }else {
                $('.searchDeviceName').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceName').attr("readonly", "readonly");
            }
        }else{
            if(users.text == "all"){
                $('.searchDeviceName').html("<option selected>all</option>");
                $('.searchDeviceName').attr("readonly", "readonly");
            }
        }
        return users.text;
    }
</script>
<script>
    $('.select2-container').css({'margin-top': '-5px'});
</script>
