<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <ol class="breadcrumb">
                    <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                    <li><a href="<?=Url::basePath('pms/schedules')?>"><?=$data['crumb1']?></a></li>
                    <li><span><?=$data['crumb2']?></span></li>
                </ol>
            </div>
            <div class="col-lg-6 hide">
                <?php View::renderTemplate('partials/createButton', $data)?>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="PmsController">
        <div class="row profile">
            <div class="col-lg-1 col-md-1 col-sm-1">
                <?php View::renderTemplate('partials/sideBar', $data); ?>
            </div>
            <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=Language::show('create_new_schedule', 'keywords')?></h4>
                    </div>
                    <div class="panel-body" style="padding: 0px 30px 30px 30px;">
                        <?=
                        Form::open(array(
                            'csrf' => $data['csrf_token'],
                            'class' => 'scheduleForm',
                            'autocomplete' => 'off',
                            'ng-submit' => 'scheduleCreate(false)',
                            'data-parsley-validate' => true
                        ));
                        ?>
                        <div class="form-group">
                            <label for="scheduleName"><?=Language::show('scheduleName', 'keywords');?></label>
                            <input type="text" class="form-control" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off">
                        </div>
                        <div class="form-group hide">
                            <label for="scheduleTimeZone"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
                            <input type="text" class="form-control" name="scheduleTimeZone" id="scheduleTimeZone" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
                        </div>
                        <div class="form-group">
                            <label for="scheduleStartTime"><?=Language::show('scheduleStartTime', 'keywords');?></label>
                            <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime" required>
                        </div>
                        <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                            <div class="form-group backupTypeForm">
                                <label for="backupType"><?=Language::show('Backup Type', 'keywords');?></label>
                                <select class="form-control backupType" name="backupType" id="backupType" required>
                                    <option value="f">Full</option>
                                    <option value="i">Incremental</option>
                                </select>
                            </div>
                        <?php } ?>
                        <div class="form-group">
                            <label for="days"><?=Language::show('days', 'keywords');?></label> -
                            <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
                            <select class="form-control selectPicker" name="days[]" id="days" required="" multiple title='Select days'>
                                <option value="1"><?=Language::show('sunday', 'keywords')?></option>
                                <option value="2"><?=Language::show('monday', 'keywords')?></option>
                                <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
                                <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
                                <option value="5"><?=Language::show('thursday', 'keywords')?></option>
                                <option value="6"><?=Language::show('friday', 'keywords')?></option>
                                <option value="7"><?=Language::show('saturday', 'keywords')?></option>
                            </select>
                        </div>
                        
                        <div>
                            <p>Note:- The above schedule will be honored in the time zone under which the Parablu endpoint agent is operating.</p>
                        </div>
                        <button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        <?=
                            Form::close();
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.backupType').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
