<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header("Cache-Control: no-cache, must-revalidate"); //HTTP 1.1
header("Pragma: no-cache"); //HTTP 1.0
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><a href="<?=Url::basePath('pms/policies')?>"><?=$data['crumb1']?></a></li>
                <li><span><?=$data['crumb2']?></span></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('create_new_policy', 'keywords')?></h4>
                </div>
                <div class="panel-body" style="padding: 0px 30px 30px 30px;" block-ui="myBlockUI">
                    <span class="hide currentPage"><?='createPolicy'?></span>
                    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'policyForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'policyCreate()',
                        'data-parsley-validate' => true
                    ));
                    ?>

                    <div class="row">
                        <div class="col-lg-7">
                            <div class="form-group">
                                <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policyName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" required autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a href="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li role="presentation"><a href="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">
                            <div class="row">
                                <div class="col-lg-7">
                                    <br/>
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('backup_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="schedules"><?=Language::show('schedules', 'keywords');?> - <a class="clickAble" ng-click="addNewSchedule()">Create New Schedule</a></label>
                                        <select class="form-control selectSchedulePicker" ng-model="schedules"  name="schedules[]" id="schedules" required="" multiple title='Select Schedules'>
                                            <?php if(!empty($data['schedules'])){ ?>
                                                <?php foreach($data['schedules'] as $key => $value){ ?>
                                                    <option value="<?=$value['scheduleName']?>"><?=$value['scheduleName']?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchver" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVer();" disabled/>
                                            <span id="vererror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxPermissibleFileSize"><?=Language::show('maxPermissibleFileSize', 'keywords');?> (In MB)</label>
					<div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchsize" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="maxPermissibleFileSize" id="maxPermissibleFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxPermissibleFileSize', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionMPS();" disabled/>
                                        <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
				    </div>
                                    <div class="form-group <?php if($_SESSION['serverBackupEnabled'] == 'true'){ ?>hide<?php } ?>">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="perUserBackupStorageLimit"><?=Language::show('perUserBackupStorageLimit', 'keywords');?> (In GB)</label>
					<div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchlimit" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="perUserBackupStorageLimit" id="perUserBackupStorageLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('perUserBackupStorageLimit', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionUBS();" disabled/>
                                        <span id="limiterror" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
				</div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row" ng-if="defaultSchedules.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:45px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-clock-o"></i> Schedule Details</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <table class="table table-bordered table-responsive">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSchedules">
                                                            <td>{{ value.scheduleName }}</td>
                                                            <td>{{ value.time }} hrs</td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker" ng-model="osType" name="osType" id="osType" required="" title='Select OS Type'>
                                            <option value="windows">Windows</option>
                                            <option value="mac">Mac</option>
                                            <option value="universal">Universal</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="defaultFoldersBackup"><?=Language::show('defaultFoldersBackup', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="defaultFoldersBackup" name="defaultFoldersBackup" id="defaultFoldersBackup" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('defaultFoldersBackup', 'keywords');?>" autocomplete="off"
                                                   data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                   data-content="<?=Language::show('inclusionError', 'keywords')?>"
                                            />
                                            <span class="input-group-btn">
                                        <button ng-click="addDefaultFolder(defaultFoldersBackup)" class="btn btn-default defaultFoldersBackupBtn" style="padding-bottom: 10px;" type="button">Add</button>
                                    </span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="exclusionFolderName"><?=Language::show('exclusion_folder_name', 'keywords')?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="exclusionFolderName" name="exclusionFolderName" id="exclusionFolderName" placeholder="Enter the full path of the folder" autocomplete="off"
                                                data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                data-content="<?=Language::show('exclusionError', 'keywords')?>"
                                            />
                                            <span class="input-group-btn">
                                                <button type="button" ng-click="addExclusionFolder(exclusionFolderName)" class="btn btn-default exclusionFoldersBtn"><i class="fa fa-minus-circle"></i> <?=Language::show('exclude', 'keywords')?></button>
                                            </span>
                                        </div >
                                    </div>
                                    <div class="form-group hide">
                                        <label for="memoryUtilization"><?=Language::show('memoryUtilization', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="memoryUtilization" id="memoryUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="128" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="cpuUtilization"><?=Language::show('cpuUtilization', 'keywords');?> (In Percentage)</label>
                                        <input type="text" class="form-control" name="cpuUtilization" id="cpuUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="80" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="dcmEnabled"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                        <select class="form-control dcmEnabled" name="dcmEnabled" id="dcmEnabled" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>

                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row" ng-if="osType != undefined">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Default Folders</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div  ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-if="defaultWinFolders.length >= 1">
                                                            <li ng-repeat="value in defaultWinFolders track by $index" class="list-group-item">{{ value }} <a class="pull-right clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultWinFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div  ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-if="defaultMacFolders.length >= 1">
                                                            <li ng-repeat="value in defaultMacFolders track by $index" class="list-group-item">{{ value }} <a class="pull-right clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultMacFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div  ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-if="defaultUniversalFolders.length >= 1">
                                                            <li ng-repeat="value in defaultUniversalFolders track by $index" class="list-group-item">{{ value }} <a class="pull-right clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultUniversalFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                </div>
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Excluded Folders</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersWindows.length">
                                                            <li class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersWindows track by $index">{{ value }} <a class="pull-right cliakAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersWindows.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    <div ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersMac.length">
                                                            <li class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersMac track by $index">{{ value }} <a class="pull-right cliakAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersMac.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    <div ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersUniversal.length">
                                                            <li class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersUniversal track by $index">{{ value }} <a class="pull-right cliakAble" ng-click="removeExclusionFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersUniversal.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>  
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble" ng-click="addNewFilter()">Create New Filter</a></label>
                                        <select class="form-control selectFilterPicker" ng-model="filter" name="filters" id="filters" required title='Select Filters'>
                                            <?php if(!empty($data['filters'])){ ?>
                                                <?php foreach($data['filters'] as $key => $value){ ?>
                                                    <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultFilter != undefined">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <?=Language::show('filterName', 'keywords');?>: {{ defaultFilter.filterName }}
                                                    <br/>
                                                    <?=Language::show('Filter Type', 'keywords');?>: {{ defaultFilter.filterType }}
                                                    <br/>
                                                    <?=Language::show('filters', 'keywords');?>: <b style="word-wrap: break-word">{{ defaultFilter.filters }}</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <div role="tabpanel" class="tab-pane" id="advanced">
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('partialFileAttributes', 'keywords')?></legend>
                                    <div class="form-group partial">
                                        <label for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                        <select class="form-control incrementalFileTransfer" name="incrementalFileTransfer" id="incrementalFileTransfer" required="" title='Select <?=Language::show('incrementalFileTransfer', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    </br>
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('networkThrottlingAttributes', 'keywords')?></legend>
                                    <!--<div class="form-group">
                                        <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In Mbps)</label>
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="nwFromClientToPG" id="nwFromClientToPG" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromClientToPG', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunction();" disabled/>
                                            <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>-->
				    <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                            <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In Mbps)</label>
                                            <div class="col-lg-8">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                              <div class="col-lg-6">
                                              <input type="text" class="form-control" name="nwFromClientToPGMB" id="nwFromClientToPGMB" placeholder="" required autocomplete="off" value="UNLIMITED" min="1" max="1024" onfocusout="myFunctionMB();" disabled/>
                                              <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                              </div>
                                              <div class="col-lg-6">
                                                <select class="form-control" name="networkThrottlingUnit" id="networkThrottlingUnit" required="" title='Select <?=Language::show('networkThrottlingUnit', 'keywords')?>' disabled>
                                                    <option value="kbps"><?=Language::show('kbps', 'keywords')?></option>
                                                    <option value="mbps" selected><?=Language::show('mbps', 'keywords')?></option>
                                                    <option value="gbps"><?=Language::show('gbps', 'keywords')?></option>
                                                </select>
                                              </div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group hide">
                                        <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                        <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="4" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="filesCrawlLimit"><?=Language::show('filesCrawlLimit', 'keywords');?></label>
                                        <input type="text" class="form-control" name="filesCrawlLimit" id="filesCrawlLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filesCrawlLimit', 'keywords');?>" required autocomplete="off" value="500" data-parsley-type="integer" data-parsley-min="1" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                        <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                
                                </div>
                                <div class="col-lg-5">
                                    </br></br>
                                    <div class="row partialfileattributerow">
                                        <div class="col-lg-12">
                                             <div class="panel panel-default" style="margin-top:30px;">
                                                
                                                <div class="panel-body">
                                            <div class="form-group">
                                        <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" value="5" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_ENABLE_PARTIAL_FILE_TRANSFER?>"/>
                                    </div>
                                    <div class="form-group">
                                        <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" value="4" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="<?=MAX_PARTIAL_FILE_TRANSFER_CHUNK_SIZE?>"/>
                                    </div>
                                        </div>
                                             </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                
                                
                            </div>
                            
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('options', 'keywords')?></legend>
                                    <div class="form-group">
                                        <div class="checkbox check-primary">
                                            <input id="legalHold" name="legalHold" type="checkbox" value="enabled">
                                            <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>
                                            <span class="systemFolders" style="display: none;">
                                                <input id="systemFolders" name="systemFolders" type="checkbox" value="enabled">
                                                <label for="systemFolders"><?=Language::show('systemFolders', 'keywords');?></label>
                                            </span>
                                        </div>
                                    </div>
                                    <?php if(STORAGE_TYPE == "GOOGLE_DRIVE" || STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                        <div class="form-group">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup" required="" title='Select <?=Language::show('dedup', 'keywords')?>'>
                                                <option value="Disabled"><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User" selected><?=Language::show('user', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <?php } else { ?>
                                        <div class="form-group">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup" required="" title='Select <?=Language::show('dedup', 'keywords')?>'>
                                                <option value="Disabled" ><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User"><?=Language::show('user', 'keywords')?></option>
                                                <option value="Global" selected><?=Language::show('global', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <?php } ?>
                                    <div class="form-group">
                                        <label for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                        <select class="form-control compEnabled" name="compEnabled" id="compEnabled" required="" title='Select <?=Language::show('compEnabled', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group vssContainer" style="display: none;">
                                        <label for="vssEnabled"><?=Language::show('vss', 'keywords');?></label>
                                        <select class="form-control vssEnabled" name="vssEnabled" id="vssEnabled" required="" title='Select <?=Language::show('vss', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group searchAlgoForPg">
                                        <label for="searchAlgoForPg"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                        <select class="form-control searchAlgoForPg" name="searchAlgoForPg" id="sortAlgoForPg" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>'>
                                            <option value="NEAREST"><?=Language::show('nearest', 'keywords')?></option>
                                            <option value="PRIORITY"><?=Language::show('priority', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                            <?php if(!empty($data['pgs'])){ ?>
                                                    <select class="blukryptIPAdress" multiple name="Blukryptipaddress[]" id="Blukryptipaddress" style="width: 100%">
                                                        <?php foreach($data['pgs'] as $key => $value){ ?>
                                                            <option  value="<?=$value['gatewayName']?>"><?=$value['gatewayName']?></option>
                                                        <?php } ?>
                                                    </select>
                                                    
                                            <?php } ?>
                                    </div>
                                    <div class="form-group hide">
                                        <label for="ccS"><?=Language::show('ccS', 'keywords');?> - <a class="clickAble" ng-click="addNewCcS()">Add Cloud Credentials</a></label>
                                        <select class="form-control selectCcSPicker" ng-model="ccSs"  name="ccS" id="ccS" title='Select <?=Language::show('ccS', 'keywords')?>'>
                                            <?php if(!empty($data['ccS'])){ ?>
                                                <?php foreach($data['ccS'] as $key => $value){ ?>
                                                    <option value="<?=$value->{'identity'}?>"><?=$value->{'identity'}?></option>
                                                <?php } ?>
                                            <?php }else{ ?>
                                                <option selected disabled>Please Add A Cloud Credential</option>
                                            <?php } ?>
                                        </select>
                                    </div>                        
                                    <div class="form-group">
                                        <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                        <input type="number" class="form-control input-small" id="policyRefresh" name="policyRefresh" value="4" min="0" max="23" required="">
                                    </div>
                                    <div class="form-group hide">
                                        <label for="fullBackupEnabled"><?=Language::show('fullBackupEnabled', 'keywords');?></label>
                                        <select class="form-control fullBackupEnabled" name="fullBackupEnabled" id="fullBackupEnabled" required="" title='Select <?=Language::show('fullBackupEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>

                                        </select>
                                    </div>
                                    <div class="form-group backupDate" style="display: none;">
                                        <label for="fullBackupStartDate"><?=Language::show('fullBackupStartDate', 'keywords');?></label>
                                        <input type="text" class="form-control backupDatePicker input-small" id="fullBackupStartDate" name="fullBackupStartDate" placeholder="Select date for full backup" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('Share Details', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('share', 'keywords');?></label>
                                        <select class="form-control shareEnabled" name="shareEnabled" id="shareEnabled" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group highSecureShareEnabled">
                                        <label for="highSecureShareEnabled"><?=Language::show('highSecureShareEnabled', 'keywords');?></label>
                                        <select class="form-control highSecureShareEnabled" name="highSecureShareEnabled" id="highSecureShareEnabled" required="" title='Select <?=Language::show('highSecureShareEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="row highSecuredShareOptions">
                                        <div class="col-lg-1" style="margin-top: 35px;text-align: center;"><i class="fa fa-caret-square-o-right"></i></div>
                                        <div class="col-lg-11">
                                            <div class="form-group complexPasswordRequired">
                                                <label for="complexPasswordRequired"><?=Language::show('complexPasswordRequired', 'keywords');?></label>
                                                <select class="form-control complexPasswordRequired" name="complexPasswordRequired" id="complexPasswordRequired" required="" title='Select <?=Language::show('complexPasswordRequired', 'keywords')?>'>
                                                    <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-1" style="margin-top: 35px;text-align: center;"><i class="fa fa-caret-square-o-right"></i></div>
                                        <div class="col-lg-11">
                                            <div class="form-group preventDownloadEnabled">
                                                <label for="preventDownloadEnabled"><?=Language::show('preventDownloadEnabled', 'keywords');?></label>
                                                <select class="form-control preventDownloadEnabled" name="preventDownloadEnabled" id="preventDownloadEnabled" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>'>
                                                    <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-1" style="margin-top: 35px;text-align: center;"><i class="fa fa-caret-square-o-right"></i></div>
                                        <div class="col-lg-11">
                                            <div class="form-group expiredDate">
                                                <label for="expiredDate"><?=Language::show('expiredDate', 'keywords');?></label>
                                                <select class="form-control expiredDate" name="expiredDate" id="expiredDate" required="" title='Select <?=Language::show('expiredDate', 'keywords')?>'>
                                                    <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
			    <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('uISettingsForAgent', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('EXIT', 'keywords');?></label>
                                        <select class="form-control exitt" name="exitt" id="exitt" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('DECOUPLE', 'keywords');?></label>
                                        <select class="form-control decouple" name="decouple" id="decouple" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('SUPPORT', 'keywords');?></label>
                                        <select class="form-control support" name="support" id="support" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('INTIATE_BACKUP', 'keywords');?></label>
                                        <select class="form-control initiatebackup" name="initiatebackup" id="initiatebackup" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('RESTORE', 'keywords');?></label>
                                        <select class="form-control restore" name="restore" id="restore" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('STOP_BACKUP', 'keywords');?></label>
                                        <select class="form-control stopbackup" name="stopbackup" id="stopbackup" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('BACKUP_SETTINGS', 'keywords');?></label>
                                        <select class="form-control bkpsettings" name="bkpsettings" id="bkpsettings" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('BACKUP_FILES', 'keywords');?></label>
                                        <select class="form-control bkpfiles" name="bkpfiles" id="bkpfiles" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('REFRESH_BACKUP_POLICY', 'keywords');?></label>
                                        <select class="form-control refbkppolicy" name="refbkppolicy" id="refbkppolicy" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br/>
                    <div class="row">
                        <div class="col-lg-7">
                            <button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                            <a class="btn btn-default pull-right" ng-click="sendMeTo('/pms/policies')" style="margin-right: 10px;">Cancel</a>
                        </div>
                    </div>
                    <?=
                    Form::close();
                    ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade createSchedule">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'scheduleForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'scheduleCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Create Schedule</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="scheduleName"><?=Language::show('scheduleName', 'keywords');?></label>
                        <input type="text" class="form-control" value="" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group hide">
                        <label for="scheduleTimeZone"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
                        <input type="text" class="form-control" name="scheduleTimeZone" id="scheduleTimeZone" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
                    </div>
                    <div class="form-group">
                        <label for="scheduleStartTime"><?=Language::show('scheduleStartTime', 'keywords');?></label>
                        <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime">
                    </div>
                    <div class="form-group">
                        <label for="days"><?=Language::show('days', 'keywords');?></label>
                        <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
                        <select class="form-control selectPicker" name="days[]" id="days" required="" multiple title='Select days'>
                            <option value="1"><?=Language::show('sunday', 'keywords')?></option>
                            <option value="2"><?=Language::show('monday', 'keywords')?></option>
                            <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
                            <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
                            <option value="5"><?=Language::show('thursday', 'keywords')?></option>
                            <option value="6"><?=Language::show('friday', 'keywords')?></option>
                            <option value="7"><?=Language::show('saturday', 'keywords')?></option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <div class="modal fade createCcS">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <?= Form::open(array(
                    'ng-submit' => 'saveCloudCredentials(true)',
                    'class' => 'cloudCredentials',
                    'csrf' => $data['csrf_token'],
                    'autocomplete' => 'off',
                    'data-parsley-validate' => true
                )); ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Create a new CcS</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="form-group col-lg-12">
                            <label for="cloudType">Cloud Type</label>
                            <select class="form-control" name="cloudType" id="cloudType">
                                <option value="azureBlob">Azure Blob</option>
                                <option value="ibmCloud">IBM Cloud</option>
                                <option value="amazon">Amazon s3 Services</option>
                            </select>
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="identity">Identity</label>
                            <input type="text" class="form-control" name="identity" id="identity" value="" placeholder="Enter your cloud identity" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="accessKey">Access key</label>
                            <input type="text" class="form-control" name="accessKey" id="accessKey" value="" placeholder="Enter your access key" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-12 epaUrl" style="display: none;">
                            <label for="epaUrl">End Point Url</label>
                            <input type="text" class="form-control" name="epaUrl" id="epaUrl" value="" placeholder="Enter your End Point Agent URL" autocomplete="off">
                        </div>
                        <div class="form-group col-lg-12 containerName" style="display: none;">
                            <label for="containerName">Amazon Container Name</label>
                            <input type="text" class="form-control" name="containerName" id="containerName" value="" placeholder="Enter your Amazon Container Name" autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <div class="modal fade createFilter">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'filterForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'filterCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Create Filter</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="filterName"><?=Language::show('filterName', 'keywords');?></label>
                        <input type="text" class="form-control" name="filterName" id="filterName" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <label for="filterType"><?=Language::show('filterType', 'keywords')?></label>
                        <select class="form-control filterType" name="filterType" id="filterType" required>
                            <option value="inclusion">Inclusion Filter</option>
                            <option value="exclusion">Exclusion Filter</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filters"><?=Language::show('filters', 'keywords');?></label><br/>
                        <input type="text" data-role="tagsinput" value="doc,docx,ppt,pptx,txt,pdf,jpg,png" class="form-control editFilters" name="filters[]" id="editFilters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
</div>
<?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('#fullBackupStartDate').prop("readonly", true);
    $('.filterType').selectpicker('render');
    $('.compEnabled').selectpicker('render');
    $('.selectCcSPicker').selectpicker('render');
    $('.selectSchedulePicker').selectpicker('render');
    $('.vssEnabled').selectpicker('render');
    $('.selectOsTypePicker').selectpicker('render').on('change', function(){
        if($('.selectOsTypePicker').val() == 'windows'){
            $('.vssContainer').show();
        }else if($('.selectOsTypePicker').val() == 'universal'){
                $('.vssContainer').show();
        }
        else{
            $('.vssContainer').hide();
        }
    });
    $('.dedup').selectpicker('render');
    $('.fullBackupEnabled').selectpicker('render');
    $('.selectOsTypePicker').selectpicker('render');
    $('.incrementalFileTransfer').selectpicker('render')
        .on("change", function(event){
            if($('.incrementalFileTransfer').val() == 'false'){
                $('.partialfileattributerow').addClass('hide');
                $('#partialFileSize').attr('disabled', 'disabled')
                $('#fileChunkableSize').attr('disabled', 'disabled')
            }else{
                $('.partialfileattributerow').removeClass('hide');
                $('#partialFileSize').removeAttr('disabled', 'disabled')
                $('#fileChunkableSize').removeAttr('disabled', 'disabled')
            }
        });
    $('.networkThrottling').selectpicker('render');
    $('.selectFilterPicker').selectpicker('render');
    $('.dcmEnabled').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
    $('.backupDatePicker').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+0d',
        todayHighlight: true
    });
    $('#fullBackupEnabled').on('change', function(){
        var option = $('#fullBackupEnabled').val();
        if(option == 'true'){
            $('.backupDate').show();
            $('[name="fullBackupStartDate"').attr('required', 'required');
        }else{
            $('.backupDate').hide();
        }
    });
    $('#sortAlgoForPg').on('change', function(){
        var option = $('#sortAlgoForPg').val();
        if(option == 'PRIORITY'){
            $('#Blukryptipaddress').attr('required', 'required');
        }else{
            $('#Blukryptipaddress').removeAttr('required', 'required');
        }
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('#cloudType').selectpicker();
    $('#cloudType').on('change', function(){
        var type = $('#cloudType').val();
        if(type == 'amazon'){
            $('.containerName').show();
            $('[name="containerName"').attr('required', 'required');
        }else if(type == 'ibmCloud'){
            $('.epaUrl').show();
            $('[name="epaUrl"').attr('required', 'required');
            $('.containerName').hide();
            $('[name="containerName"').removeAttr('required', 'required');
        }else{
            $('.epaUrl').hide();
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('.containerName').hide();
            $('[name="containerName"').removeAttr('required', 'required');
        }
    });
    $('.shareEnabled').selectpicker('render').on('change', function(){
        if($('#shareEnabled').val() == 'true'){
            $('.highSecuredShareOptions').show();
            $('.highSecureShareEnabled').show();
        }else{
            $('.highSecuredShareOptions').hide();
            $('.highSecureShareEnabled').hide();
        }
    });
    $('.highSecureShareEnabled').selectpicker('render').on('change', function(){
        if($('#highSecureShareEnabled').val() == 'true'){
            $('.complexPasswordRequired').attr("disabled", true);
            $('.preventDownloadEnabled').attr("disabled", true);
            $('.expiredDate').attr("disabled", true);

            $('.expiredDate').find('option[value="true"]').prop("selected",true);
            $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
            $('.preventDownloadEnabled').find('option[value="false"]').prop("selected",true);

            $('.complexPasswordRequired').selectpicker('refresh');
            $('.preventDownloadEnabled').selectpicker('refresh');
            $('.expiredDate').selectpicker('refresh');
        }else{
            $('.complexPasswordRequired').attr("disabled", false);
            $('.preventDownloadEnabled').attr("disabled", false);
            $('.expiredDate').attr("disabled", false);

            $('.expiredDate').find('option[value="false"]').prop("selected",true);
            $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
            $('.preventDownloadEnabled').find('option[value="true"]').prop("selected",true);

            $('.complexPasswordRequired').selectpicker('refresh');
            $('.preventDownloadEnabled').selectpicker('refresh');
            $('.expiredDate').selectpicker('refresh');
        }
    });

</script>

<script type="text/javascript">
    $(".blukryptIPAdress").select2();

    $(".blukryptIPAdress").on("select2:select", function (evt) {
        var element = evt.params.data.element;
        var $element = $(element);

        $element.detach();
        $(this).append($element);
        $(this).trigger("change");
        //$('#sortAlgoForPg').find('option[value="PRIORITY"]').prop("selected",true);
    });
</script>
<script>
    $('.timePicker').timepicker({
        showMeridian: false
    });
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
<script>
    /*$("#switch").click(function(){
        document.getElementById("switcherror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#nwFromClientToPG').removeAttr('disabled'); //enable input
        $('#nwFromClientToPG').val('');
        
    } else {
        
        $('#nwFromClientToPG').attr('disabled', true); //disable input
        $('#nwFromClientToPG').val('UNLIMITED');
    }
        });*/

    $("#switchsize").click(function(){
        document.getElementById("sizeerror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#maxPermissibleFileSize').removeAttr('disabled'); //enable input
        $('#maxPermissibleFileSize').val('');
        
    } else {
        
        $('#maxPermissibleFileSize').attr('disabled', true); //disable input
        $('#maxPermissibleFileSize').val('UNLIMITED');
    }
        });
    
    $("#switchlimit").click(function(){
        document.getElementById("limiterror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#perUserBackupStorageLimit').removeAttr('disabled'); //enable input
        $('#perUserBackupStorageLimit').val('');
        
    } else {
        
        $('#perUserBackupStorageLimit').attr('disabled', true); //disable input
        $('#perUserBackupStorageLimit').val('UNLIMITED');
    }
        });

    $("#switchver").click(function(){
        document.getElementById("vererror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#maxVersions').removeAttr('disabled'); //enable input
        $('#maxVersions').val('3');
        
    } else {
        
        $('#maxVersions').attr('disabled', true); //disable input
        $('#maxVersions').val('UNLIMITED');
    }
        });
</script>

<script>
    /*function myFunction(){
        document.getElementById("switcherror").innerHTML = "";
        if(isNaN($('#nwFromClientToPG').val()))
        {
        if (  $('#nwFromClientToPG').val() !='UNLIMITED')  {
            document.getElementById("switcherror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
        else if(!isNaN($('#nwFromClientToPG').val()) && $('#nwFromClientToPG').val() > 9999){
             document.getElementById("switcherror").innerHTML = "Network Throttle Setting from Client to BluKrypt Allowed is 9999";
         }
         else if($('#nwFromClientToPG').val().indexOf(".")!=-1){
            document.getElementById("switcherror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("switcherror").innerHTML = "";
        }
    }*/
    
    function myFunctionMPS(){
        document.getElementById("sizeerror").innerHTML = "";
        if(isNaN($('#maxPermissibleFileSize').val()))
        {
        if (  $('#maxPermissibleFileSize').val() !='UNLIMITED')  {
            document.getElementById("sizeerror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
         else if(!isNaN($('#maxPermissibleFileSize').val()) && $('#maxPermissibleFileSize').val() > 999999){
             document.getElementById("sizeerror").innerHTML = "Maximum Permissible File Size Allowed is 999999";
         }
         else if($('#maxPermissibleFileSize').val().indexOf(".")!=-1){
            document.getElementById("sizeerror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("sizeerror").innerHTML = "";
        }
    }
    
    function myFunctionUBS(){
        document.getElementById("limiterror").innerHTML = "";
        if(isNaN($('#perUserBackupStorageLimit').val()))
        {
        if (  $('#perUserBackupStorageLimit').val() !='UNLIMITED')  {
            document.getElementById("limiterror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
        else if(!isNaN($('#perUserBackupStorageLimit').val()) && $('#perUserBackupStorageLimit').val() > 99999){
             document.getElementById("limiterror").innerHTML = "Maximum Per User Backup Storage Limit Allowed is 99999";
         }
         else if($('#perUserBackupStorageLimit').val().indexOf(".")!=-1){
            document.getElementById("limiterror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("limiterror").innerHTML = "";
        }
    }

    function myFunctionVer(){
        document.getElementById("vererror").innerHTML = "";
        if(isNaN($('#maxVersions').val()))
        {
            if (  $('#maxVersions').val() !='UNLIMITED')  {
                document.getElementById("vererror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
                //alert('Invalid Input');
            }
        }
        else if(!isNaN($('#maxVersions').val()) && $('#maxVersions').val() < 1){
            document.getElementById("vererror").innerHTML = "Minimum number of Versions Allowed is 1";
        }
        else if(!isNaN($('#maxVersions').val()) && $('#maxVersions').val() > 10000000){
            document.getElementById("vererror").innerHTML = "Maximum number of Versions Allowed is 1 Crore";
        }
        else{
            document.getElementById("vererror").innerHTML = "";
        }
    }

    function myFunctionMB(){
        document.getElementById("switcherror").innerHTML = "";
        if(isNaN($('#nwFromClientToPGMB').val()))
        {
        if (  $('#nwFromClientToPGMB').val() !='UNLIMITED')  {
            document.getElementById("switcherror").innerHTML = "Input can be any integer";
            //alert('Invalid Input');
        }
        
        }
        else if(!isNaN($('#nwFromClientToPGMB').val()) && $('#nwFromClientToPG').val() > 9999){
             document.getElementById("switcherror").innerHTML = "Network Throttle Setting from Client to BluKrypt Allowed is 9999";
         }
         else if($('#nwFromClientToPGMB').val().indexOf(".")!=-1){
            document.getElementById("switcherror").innerHTML = "Please enter a integral value";
        }
        else{
        document.getElementById("switcherror").innerHTML = "";
        }
    }
    
    $(".liteVersion").addClass("disabledbutton");
    $("[data-toggle=tooltip]").tooltip({
    placement: $(this).data("placement") || 'right'
});
    
    $("#switch").click(function(){
        if ($(this).is(':checked')) {
        
        $('#nwFromClientToPGMB').removeAttr('disabled','disabled'); //enable input
        $('#nwFromClientToPGMB').val('4');
        $('#networkThrottlingUnit').removeAttr("disabled","disabled");
        
    } else {
        
        $('#nwFromClientToPGMB').attr('disabled', true); //disable input
        $('#nwFromClientToPGMB').val('UNLIMITED');
        $('#networkThrottlingUnit').attr("disabled","disabled");
        $('.networkThrottlingUnit').find('option[value="mbps"]').prop("selected",true);
    }
        });
    
</script>
