<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?=''?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Policy Settings</h4>
                    </div>
                    <div class="panel-body">
                        <div class="col-lg-4">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/policies')">
                                <div class="background">
                                    <i class="fa fa-file-powerpoint-o"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-file-powerpoint-o"> Backup Policies</i><br/>
                                    <a>Create, Edit, View Policies</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/schedules')">
                                <div class="background">
                                    <i class="fa fa-clock-o"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-clock-o"> Schedules</i><br/>
                                    <a>Create, Edit, View Schedules</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/filters')">
                                <div class="background">
                                    <i class="fa fa-filter"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-filter"> File Filters</i><br/>
                                    <a>Create, Edit, View Filters</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/policyMapping/single')">
                                <div class="background">
                                    <i class="fa fa-user"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-user"> Policy Mapping</i><br/>
                                    <a>Change User Policy</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/policyMapping/multiple')">
                                <div class="background">
                                    <i class="fa fa-users"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-users"> Policy Mapping</i><br/>
                                    <a>Assign Policy for users in bulk</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;"></h4>
                    </div>
                    <div class="panel-body">
                        <div class="col-lg-4">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/bluvault')">
                                <div class="background">
                                    <i class="fa fa-cubes"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-cubes"> Paraclouds</i><br/>
                                    <a>Paracloud Settings</a>
                                </div>
                            </div>
                        </div>
                        <?php if(BLUKRYPT_PAGE == true){ ?>
                        <div class="col-lg-4">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/blukrypt')">
                                <div class="background">
                                    <i class="fa fa-key"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-key"> Blukrypt</i><br/>
                                    <a>Blukrypt Settings</a>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                        <div class="col-lg-4">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/networkThrottling')">
                                <div class="background">
                                    <i class="fa fa-crop"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-crop"> Network Throttling</i><br/>
                                    <a>Network Throttling Settings</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>