<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?="Settings"?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?='paracloudblukrypt'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <ul class="nav nav-tabs" role="tablist">
                    <li role="presentation" class="active"><a data-target="#paracloud" aria-controls="paracloud" role="tab" data-toggle="tab">Paracloud</a></li>
                    <li role="presentation"><a data-target="#blukrypt" aria-controls="blukrypt" role="tab" data-toggle="tab">BluKrypt</a></li>
                </ul>
            <!-- Tab panes -->
                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane active" id="paracloud">
                        <div class="panel">
                            <div class="panel-heading">
                                <?php if(maxParacloud == false){ ?>
                                <h4><?=Language::show('listOfBluvaults', 'keywords')?><span class="pull-right toolTip" data-toggle="tooltip" data-placement="top" title="This feature is disabled in Lite Version" style="cursor: not-allowed";><a class="btn btn-success btn-small" disabled href="" data-toggle="modal" data-target="#addParacloud"><?=Language::show('add_paracloud', 'keywords');?></a></span></h4>
                                <?php } else {?>
                                <h4><?=Language::show('listOfBluvaults', 'keywords')?><span class="pull-right"><a class="btn btn-success btn-small" href="" data-toggle="modal" data-target="#addParacloud"><?=Language::show('add_paracloud', 'keywords');?></a></span></h4>
                                <?php } ?>
                            </div>
                            <div class="panel-body">
                                <div class="row col-lg-12">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Paracloud Name</th>
                                                <th><?=Language::show('action', 'keywords')?></th>
                                            </tr>
                                        </thead>
                                        <tbody class="bluvaultListTable">
                                            <tr ng-repeat="value in bluvaults track by $index">
                                                <td><span ng-cloak>{{ value.bluVaultName }}</span></td>
                                                <td class="text-left" style="white-space:unset !important;"><a ng-class="{false:'disabled'}[bluvaults.length > 1]"  class="btn btn-danger btn-small"
                                                    ng-bootbox-confirm="<div><h4 class='modal-title' id='myModalLabel'>Confirm Delete Paracloud</h4><hr></div><?=Language::show('confirmDelete', 'keywords')?> {{value.bluVaultName}} <?=Language::show('paracloud', 'keywords')?> ?"
                                                    ng-bootbox-confirm-action="removeBluvault(value.id, value.bluVaultName, $index)"
                                                    ng-bootbox-confirm-action-cancel=""
                                                    href="javascript:;"><i class="fa fa-trash"></i> <?=Language::show('delete', 'keywords')?></a>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="row hide">
                                    <div class="col-lg-12">
                                        <?=
                                            Form::open(array(
                                                'csrf' => $data['csrf_token'],
                                                'class' => 'filterForm',
                                                'autocomplete' => 'off',
                                                'ng-submit' => 'saveBluvault(bluvault)',
                                                'data-parsley-validate' => true
                                            ));
                                        ?>
                                        <div class="form-group">
                                            <label for="bluvault"><?=Language::show('paracloudIPs', 'keywords');?></label>
                                            <input type="text" class="form-control" ng-model="bluvault" name="bluvault" id="bluvault" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('bluvault', 'keywords');?>" required autocomplete="off" autofocus>
                                        </div>
                                        <button type="submit" class="submitBluvault btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                                        <?=
                                            Form::close();
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div role="tabpanel" class="tab-pane" id="blukrypt">
                        <?php if(BLUKRYPT_PAGE == true){ ?>
                            <div class="panel">
                                <div class="panel-heading">
                                    <?php if(maxBlukrypt == false){ ?>
                                    <h4><?=Language::show('listOfBlukrypts', 'keywords')?><span class="pull-right toolTip" data-toggle="tooltip" data-placement="top" title="This feature is disabled in Lite Version" style="cursor: not-allowed";><a class="btn btn-success btn-small disabled" href="" data-toggle="modal" data-target="#addBlukrypt"><?=Language::show('add_blukrypt', 'keywords');?></a></span></h4>
                                    <?php } else {?>
                                    <h4><?=Language::show('listOfBlukrypts', 'keywords')?><span class="pull-right"><a class="btn btn-success btn-small" href="" data-toggle="modal" data-target="#addBlukrypt"><?=Language::show('add_blukrypt', 'keywords');?></a></span></h4>
                                    <?php } ?>
                                </div>
                                <div class="panel-body">
                                    <div class="row col-lg-12">
                                        <table class="table table-bordered">
                                            <thead>
                                            <tr>
                                                <th>BluKrypt Name</th>
                                                <th><?=Language::show('action', 'keywords')?></th>
                                            </tr>
                                            </thead>
                                            <tbody class="blukryptltListTable">
                                            <!--<tr ng-if="blukrypts.length == 1" ng-repeat="value in blukrypts track by $index">
                                                <td><span class="text-center" ng-cloak>{{ value.gatewayName }}</span></td>
                                            </tr>
                                            <tr ng-if="blukrypts.length > 1" ng-repeat="value in blukrypts">
                                                <td>
                                                    <span class="text-center" ng-cloak>{{ value.gatewayName+' ('+value.type+')' }}</span>
                                                    <button ng-click="removeBluKrypt(value.gatewayName, $index)" class="btn btn-small btn-danger pull-right">remove</button>
                                                </td>
                                            </tr>-->
                                            <tr ng-repeat="value in blukrypts track by $index">
                                                <td><span ng-cloak>{{ value.gatewayName+' ('+value.type+')' }}</span></td>
                                                <td class="text-left" style="white-space:unset !important;"><a ng-class="{false:'disabled'}[blukrypts.length > 1]"  class="btn btn-danger btn-small"
                                                    ng-bootbox-confirm="<div><h4 class='modal-title' id='myModalLabel'>Delete Blukrypt</h4><hr></div><?=Language::show('confirmDelete', 'keywords')?> {{value.gatewayName}} <?=Language::show('blukrypt', 'keywords')?> ?"
                                                    ng-bootbox-confirm-action="removeBluKrypt(value.gatewayName, $index)"
                                                    ng-bootbox-confirm-action-cancel=""
                                                    href="javascript:;"><i class="fa fa-trash"></i> <?=Language::show('delete', 'keywords')?></a>
                                                    <a class="btn btn-default btn-small" ng-click="editBlukrypts($index)">Edit</a>
                                        
                                            </td>
                                                
                                                
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
        </div>
    </div>
    <div id="addParacloud" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content mediumModal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Add Paracloud</h4>
            </div>
            <div class="modal-body">
                        <?=
                            Form::open(array(
                                        'csrf' => $data['csrf_token'],
                                        'class' => 'filterForm',
                                        'autocomplete' => 'off',
                                        'ng-submit' => 'saveBluvault(bluvault)',
                                        'data-parsley-validate' => true
                                        ));
                        ?>
                        <div class="modal-title">
                            <div class="form-group">
                                            <label for="bluvault"><?=Language::show('paracloud_IpAddress', 'keywords');?></label>
                                            <input type="text" class="form-control" ng-model="bluvault" name="bluvault" id="bluvault" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('bluvault', 'keywords');?>" required autocomplete="off" autofocus>
                            </div>
                        </div>
           
                        <div class="modal-footer ">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <!--<button type="submit" class="btn btn-default btn-primary" >Create</button>-->
                        <button type="submit" class="submitBluvault btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        </div>
                        <?=
                            Form::close();
                        ?>      
                    </div>
            </div>
        </div>
    </div>
    
    <div id="addBlukrypt" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content mediumModal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 id="add_title" class="modal-title">Add Blukrypt</h4>
                <h4 id="edit_title" class="modal-title" style="display: none;">Edit Blukrypt</h4>
            </div>
            <div class="modal-body">
                        <?=
                            Form::open(array(
                            'csrf' => $data['csrf_token'],
                            'class' => 'filterForm',
                            'autocomplete' => 'off',
                            'ng-submit' => 'saveBlukrypt()',
                            'data-parsley-validate' => true
                            ));
                        ?>
                        <div class="modal-title">
                            <div class="form-group">
                                <label for="blukryptIP"><?=Language::show('blukrypt_IpAddress', 'keywords');?></label>
                                <input type="text" class="form-control" ng-model="blukrypt" name="blukryptIP" id="blukryptIP" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('blukrypt', 'keywords');?>" required autocomplete="off" autofocus>
                            </div>
                            <div class="form-group">
                                <label for="blukryptEdit"><?=Language::show('blukryptType', 'keywords');?></label>
                                    <select class="form-control" name="blukryptEdit" id="blukryptEdit" required>
                                        <option value="full">Full</option>
                                        <option value="incremental">Incremental</option>
                                        <option value="both">Both</option>
                                    </select>
                            </div>
                            <?php if($data['loggedInUser']['backupEnabled'] == true){ ?>
                                           <div class="form-group hide">
                                                <?php } else { ?>
                                                    <div class="form-group">
                                                <?php } ?>
                                                <label for="productEdit">Product Type</label>
                                                <select class="form-control" name="productEdit" id="productEdit" required>
                                                    <option value="blusync" >BluSync</option>
                                                    <option value="bluvault">BluVault</option>
                                                    <option selected value="both">Both</option>
                                                </select>
                                            </div>
                        </div>
           
                        <div class="modal-footer ">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <!--<button type="submit" class="btn btn-default btn-primary" >Create</button>-->
                        <button type="submit" class="submitBlukrypt btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        </div>
                        <?=
                            Form::close();
                        ?>      
                    </div>
            </div>
        </div>
    </div>
<!--</div>-->

<!-- modal confirm starts -->
<div id="addBlukryptConfirm" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content smallModal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Confirm Add Blukrypt</h4>
            </div>
            <div class="modal-body">
                                <p>Are you sure you want to add ?</p>
                                <input type="text" class="form-control hide" ng-model="confblukrypt" name="confblukrypt" id="confblukrypt">
                                <input type="text" class="form-control hide" name="confblukryptEdit" id="confblukryptEdit">
                                <input type="text" class="form-control hide" name="confproductEdit" id="confproductEdit">
                        </div>

                        <div class="modal-footer ">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <a ng-click="ConfirmAddBlukrypt()" class="btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></a>
                        </div>

                    </div>
            </div>
        </div>
<!-- modal confirm ends -->

<!-- modal confirm starts -->
<div id="addParacloudConfirm" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content smallModal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Confirm Add Paracloud</h4>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to add ?</p>
                <input type="text" class="form-control hide" ng-model="confbluvault" name="confbluvault" id="confbluvault" />
            </div>
            <div class="modal-footer ">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a ng-click="ConfirmAdd(bluvault)" class="btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></a>
            </div>
        </div>
    </div>
</div>
    </div>
<!-- modal confirm ends -->
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('#blukryptType').selectpicker('render');
</script>
<script>
    $(function() {
        $('#addParacloud').on('hidden.bs.modal', function(){
            $('input').val('');
            $('input').removeClass("parsley-error");
            $('.parsley-errors-list').remove();
        });
    });
    $(function() {
        $('#addBlukrypt').on('hidden.bs.modal', function(){
            $('input').val('');
            $('input').removeClass("parsley-error");
            $('.parsley-errors-list').remove();
        });
    });
    $(function() {
    $('.tooltip-wrapper').tooltip({position: "bottom"});
});
</script>
