<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?='filter'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=$data['crumb1']?><span class="pull-right"><a class="btn btn-success btn-small" href="<?=Url::basePath('pms/filter/create')?>"><?=Language::show('create_new_filter', 'keywords');?></a></span></h4>
                </div>
                <div class="panel-body">
                    <div class="bs-example" data-example-id="simple-responsive-table">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <colgroup>
                                    <col class="col-xs-6">
                                    <col class="col-xs-2">
                                    <col class="col-xs-1">
                                </colgroup>
                                <thead>
                                    <tr>
                                    <th><?=Language::show('filterName', 'keywords')?></th>
                                        <th><?=Language::show('filter', 'keywords')?></th>
                                        <th><?=Language::show('Filter Type', 'keywords')?></th>
                                        <th><?=Language::show('action', 'keywords')?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="value in filters track by $index">
                                        <td ng-cloak>{{ value.filterName }}</td>
                                        <td ng-cloak style="word-break: break-word;">{{ value.filters }}</td>
                                        <td ng-cloak>{{ value.filterType }}</td>
                                        <td ng-cloak><a class="btn btn-default btn-small" ng-click="filterEdit($index)">Edit</a></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div><!-- /.table-responsive -->
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade editFilter">
            <div class="modal-dialog">
                <div class="modal-content mediumModal">
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'filterForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'filterSave()',
                        'data-parsley-validate' => true
                    ));
                    ?>
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Edit Filter</h4>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filterName"><?=Language::show('filterName', 'keywords');?></label>
                            <input type="text" class="form-control" name="filterName" id="filterName" value="{{ filters[filterIndex].filterName }}" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off" readonly>
                        </div>
                        <div class="form-group">
                            <label for="filterType"><?=Language::show('filterType', 'keywords')?></label>
                            <select class="form-control filterType" name="filterType" id="filterType" required>
                                <option value="inclusion">Inclusion Filter</option>
                                <option value="exclusion">Exclusion Filter</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="filters"><?=Language::show('filters', 'keywords');?></label><br/>
                            <input type="text" data-role="tagsinput" value="{{ filters[filterIndex].filters }}" class="form-control editFilters" name="filters[]" id="editFilters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                    <?= Form::close(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.filterType').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
