<?php
use \Core\View;
use Helpers\Url;
use Core\Language;

 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('migration')?>"><?=Language::show('userMigration', 'report')?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="MigrationController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='importUsers'?></span>
            <div class="row">
                <div class="panel panel-default">
                    <div class="panel-heading"><h3>Import Users From AD</h3></div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>
                                        Enter comma separated list of user names.
                                        <br/>Username's will be matched with Active Directory for verification.
                                        <br/>This is to be used by ParaBlu team only. Handle with care as this can corrupt the entire system.
                                        <br/>Excel Upload : Excel sheet should contain a column called usernames and all the users should be mentioned only in the column.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <a href="javascript:;" class="btn btn-default"
                                   ngf-select="readUserNamesFromExcel($files)">
                                    <i class="share-icon fa fa-upload"> Import UserNames from Excel</i>
                                </a>
                            </div>
                        </div>
                        <br/>
                        <div class="">
                            <div class="form-group">
                                <div class="check-primary">
<?php if(DISABLE_BLUSYNC == false){ ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                        <label class="radio-inline">
                                            <input type="radio" value="sync" name="migrationType" <?php if(\Helpers\Auth::checkCloudPermission('sync') == true && \Helpers\Auth::checkCloudPermission('backup') == false){ echo 'checked';}?>>
                                            Sync
                                        </label>
                                    <?php } ?>
<?php } ?>
<?php if(DISABLE_BLUVAULT == false){ ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <label class="radio-inline">
                                            <input type="radio" value="backup" name="migrationType" <?php if(\Helpers\Auth::checkCloudPermission('sync') == false && \Helpers\Auth::checkCloudPermission('backup') == true){ echo 'checked';}?>>
                                            Backup
                                        </label>
                                    <?php } ?>
<?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                                        <label class="radio-inline">
                                            <input type="radio" value="backup" name="migrationType" checked>
                                            Server Backup
                                        </label>
                                    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup') && \Helpers\Auth::checkCloudPermission('sync')){ ?>
                                        <label class="radio-inline <?php if(DISABLE_BLUVAULT == true || DISABLE_BLUSYNC == true){ echo 'hide'; }?>">
                                            <input type="radio" value="both" name="migrationType" checked>
                                            Both
                                        </label>
                                    <?php } ?>
                                </div>
                            </div>
<?php if(DISABLE_BLUVAULT == false){ ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                            <div class="form-group">
                                <label for="policy"><?=Language::show('backupPolicyName', 'keywords');?></label><br/>
                                <select class="form-control selectPolicyPicker" ng-model="policy" name="policy" id="policy" required="" title='Select a Policy for Backup'>
                                    <?php if(!empty($data['policies'])){ ?>
                                        <?php foreach($data['policies'] as $key => $value){ ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
<?php } ?>
<?php if(DISABLE_BLUSYNC == false){ ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                            <div class="form-group">
                                <label for="syncPolicy"><?=Language::show('syncPolicyName', 'keywords');?></label><br/>
                                <select class="form-control selectSyncPolicyPicker" ng-model="syncPolicy" name="syncPolicy" id="syncPolicy" required="" title='Select a Policy for sync'>
                                    <?php if(!empty($data['syncPolicies'])){ ?>
                                        <?php foreach($data['syncPolicies'] as $key => $value){ ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
<?php } ?>
                            <div class="form-group">
                                <label for="userNames"><?=Language::show('userNames', 'keywords');?></label><br/>
                                <input type="text" data-role="tagsinput" value="" class="form-control" name="userNames[]" id="userNames" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('userNames', 'keywords');?>" required autocomplete="off">
                            </div>
                            <div class="form-group">
                                <a ng-click="getUsers(policy, syncPolicy)" class="btn btn-success"><i class="fa fa-save"></i> Import</a>
                                <a class="btn btn-danger" href="<?=Url::basePath('migration')?>"><i class="fa fa-times"></i> Cancel</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row migrationDetails" style="display: none;">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3>
                            User Migration Details - {{ userList.length+' users' }}
                            <a ng-click="startMigrating()" class="btn btn-success btn-small pull-right">Start Migrating Users</a>
                        </h3>
                    </div>
                    <div class="panel-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>First Name</th>
                                    <th>Email Address</th>
                                    <th>OU</th>
<?php if(DISABLE_BLUVAULT == false){ ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <th>Backup Policy</th>
                                    <?php } ?>
<?php } ?>
<?php if(DISABLE_BLUSYNC == false){ ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                        <th>Sync Policy</th>
                                    <?php } ?>
<?php } ?>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="value in userList track by $index">
                                    <td ng-cloak>{{ value.userName }}</td>
                                    <td ng-cloak>{{ value.emailId }}</td>
                                    <td ng-cloak>{{ value.organizationUnit }}</td>
<?php if(DISABLE_BLUVAULT == false){ ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                    <td class="policy">
                                        <span ng-if="value.defaultPolicy !=''" class="selectedPolicySpan{{$index}}" ng-cloak>{{ value.defaultPolicy }}</span>
                                        <span ng-if="value.defaultPolicy ==''" class="selectedPolicySpan{{$index}}" ng-cloak>NA</span>
                                        <div class="form-group selectPolicyPicker{{$index}}" style="display: none;">
                                            <select class="form-control" name="selectedPolicy{{$index}}" required>
                                                <?php if(!empty($data['policies'])){ ?>
                                                    <?php foreach($data['policies'] as $key => $value){ ?>
                                                        <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </td>
                                    <?php } ?>
<?php } ?>
<?php if(DISABLE_BLUSYNC == false){ ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                    <td class="syncPolicy">
                                        <span ng-if="value.defaultSyncPolicy !=''" class="selectedSyncPolicySpan{{$index}}" ng-cloak>{{ value.defaultSyncPolicy }}</span>
                                        <span ng-if="value.defaultSyncPolicy ==''" class="selectedPolicySpan{{$index}}" ng-cloak>NA</span>
                                        <div class="form-group selectSyncPolicyPicker{{$index}}" style="display: none;">
                                            <select class="form-control" name="selectedSyncPolicy{{$index}}" required>
                                                <?php if(!empty($data['syncPolicies'])){ ?>
                                                    <?php foreach($data['syncPolicies'] as $key => $value){ ?>
                                                        <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </td>
                                    <?php } ?>
<?php } ?>
                                    <td>
<?php if(DISABLE_BLUVAULT == false){ ?>
                                        <span ng-show="value.defaultPolicy == ''">NA</span>
                                        <span ng-hide="value.defaultPolicy == ''">
                                            <a ng-click="changePolicy(value.defaultPolicy, $index)" class="btn btn-default btn-small changePolicyBtn{{$index}}">Change Backup Policy</a>
                                            <a ng-click="savePolicy($index)" class="btn btn-success btn-small savePolicyBtn{{$index}}" style="display: none;">Save Backup Policy</a>
                                        </span>
<?php } ?>
<?php if(DISABLE_BLUSYNC == false){ ?>
                                        <span ng-show="value.defaultSyncPolicy == ''">NA</span>
                                        <span ng-hide="value.defaultSyncPolicy == ''">
                                            <a ng-click="changeSyncPolicy(value.defaultSyncPolicy, $index)" class="btn btn-default btn-small changeSyncPolicyBtn{{$index}}">Change Sync Policy</a>
                                            <a ng-click="saveSyncPolicy($index)" class="btn btn-success btn-small saveSyncPolicyBtn{{$index}}" style="display: none;">Save Sync Policy</a>
                                        </span>
<?php } ?>
                                        <span>
                                            <a ng-click="removeRow($index)" class="btn btn-small btn-danger clickAble"><i class="fa fa-times"></i></a>
                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.selectPolicyPicker').selectpicker('render');
    $('.selectPolicyPickerEdit').selectpicker('render');
    $('.selectSyncPolicyPicker').selectpicker('render');
    $('.selectSyncPolicyPickerEdit').selectpicker('render');
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/MigrationController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('[name="migrationType"]').on('click', function(){
        var migrationType = $('input[name="migrationType"]:checked').val();
        if(migrationType == 'sync'){
            $('.selectPolicyPicker').prop('disabled', true);
            $('.selectPolicyPicker').selectpicker('refresh');
            $('.selectSyncPolicyPicker').prop('disabled', false);
            $('.selectSyncPolicyPicker').selectpicker('refresh');
        }else if(migrationType == 'backup'){
            $('.selectPolicyPicker').prop('disabled', false);
            $('.selectPolicyPicker').selectpicker('refresh');
            $('.selectSyncPolicyPicker').prop('disabled', true);
            $('.selectSyncPolicyPicker').selectpicker('refresh');
        }else{
            $('.selectPolicyPicker').prop('disabled', false);
            $('.selectPolicyPicker').selectpicker('refresh');
            $('.selectSyncPolicyPicker').prop('disabled', false);
            $('.selectSyncPolicyPicker').selectpicker('refresh');
            $('#syncPolicy').attr('required', 'required');
            $('#policy').attr('required', 'required');
        }
    });
</script>
<script>
$('#userNames').tagsinput({
  trimValue: true
});
</script>
