<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <ol class="breadcrumb">
                    <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                    <li><a href="<?=Url::basePath('myAccount/'.$data['currentUser'])?>"><?=$data['crumb1']?></a></li>
                    <li><span><?=$data['crumb2']?></span></li>
                    <?php if(!empty($data['deviceName'])){ ?>
                        <li><span><?=$data['deviceName']?></span></li>
                    <?php } ?>
                </ol>
            </div>
            <div class="col-lg-6 hide">
                <?php View::renderTemplate('partials/createButton', $data)?>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="UserController">
        <span class="hide currentPage"><?='policyInfo'?></span>
        <span class="hide currentOs"><?=$data['os']?></span>
        <div class="row profile">
            <div class="col-lg-1 col-md-1 col-sm-1">
                <?php View::renderTemplate('partials/sideBar', $data); ?>
            </div>
            <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=Language::show('policy_information', 'keywords')?></h4>
                    </div>
                    <div class="panel-body" style="padding: 0px 30px 30px 30px;">
                        <div class="row">
                            <div class="row">
                                <div class="col-lg-6">
                                    <h5>Default Folders that will be backed up automatically:</h5>
                                    <div class="col-lg-12">
                                        <h4>
                                            <span class="label label-success"
                                                  ng-repeat="value in currentUser.defaultFolders track by $index" ng-cloak>
                                                {{ value }}
                                            </span>
                                        </h4>
                                    </div>
                                </div>
                                <div class="col-lg-6" ng-if="currentUser.maxSizeAllowed > 0">
                                    <h5 ng-if="currentUser.filterType == 'exclusion'">File Types that will be excluded:</h5>
                                    <h5 ng-if="currentUser.filterType == 'inclusion'">File Types that will be included:</h5>
                                    <div class="col-lg-12" style="overflow: auto">
                                        <h4>
                                            <span class="label label-success" ng-cloak>
                                                {{ currentUser.fileTypes }}
                                            </span>
                                        </h4>
                                    </div>
                                </div>
                            </div>
                            <hr ng-if="currentUser.maxSizeAllowed > 0" />
                            <div class="row" ng-if="currentUser.maxSizeAllowed > 0">
                                <div class="col-lg-6">
                                    <h4><?=Language::show('user_inclusion_folders', 'keywords')?></h4>
                                    <div class="row userInclusionFolders">
                                        <div class="col-lg-11" style="margin-left: 15px;">
                                            <ul class="list-group">
                                                <li class="list-group-item" ng-repeat="value in currentUser.userDefinedFolders track by $index">
                                                    <span ng-cloak>{{ value }}</span>
                                                    <span class="pull-right">
                                                        <a
                                                            ng-bootbox-confirm="<?=Language::show('inclusionFolderDelete', 'keywords')?>"
                                                            ng-bootbox-confirm-action="removeInclusionFolder($index, 'true')"
                                                            ng-bootbox-confirm-action-cancel=""
                                                            href="javascript:;">
                                                            <i class="fa fa-times-circle-o"></i>
                                                        </a>
                                                    </span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="userInclusionFoldersForm">
                                        <?=\Helpers\Form::open(array(
                                            'class' => 'inclusionPolicyForm',
                                            'csrf' => $data['csrf_token'],
                                            'autocomplete' => 'off',
                                            'ng-submit' => 'addInclusionFolder(current.inclusionFolderName)'
                                        ));?>
                                        <div class="col-lg-12">
                                            <label for="inclusionFolderName"><?=Language::show('inclusion_folder_name', 'keywords')?></label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                       ng-model="current.inclusionFolderName" name="inclusionFolderName" id="inclusionFolderName"
                                                       value="" placeholder="Enter the full path of the folder" autocomplete="off"
                                                       data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                       data-content="<?=Language::show('inclusionError', 'keywords')?>"
                                                    />
                                                <div class="input-group-btn">
                                                    <button type="submit" class="btn btn-default"><i class="fa fa-plus-circle"></i> <?=Language::show('include', 'keywords')?></button>
                                                </div>
                                            </div>
                                        </div>
                                        <?=\Helpers\Form::close()?>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <h4><?=Language::show('user_exclusion_folders', 'keywords')?></h4>
                                    <div class="row userExclusionFolders">
                                        <div class="col-lg-11" style="margin-left: 15px;">
                                            <ul class="list-group">
                                                <li class="list-group-item" ng-repeat="value in currentUser.userExcludedFolders track by $index">
                                                    <span ng-cloak>{{ value }}</span>
                                                    <span class="pull-right">
                                                        <a
                                                            ng-bootbox-confirm="<?=Language::show('exclusionFolderDelete', 'keywords')?>"
                                                            ng-bootbox-confirm-action="removeExclusionFolder($index, 'true')"
                                                            ng-bootbox-confirm-action-cancel=""
                                                            href="javascript:;">
                                                            <i class="fa fa-times-circle-o"></i>
                                                        </a>
                                                    </span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="userExclusionFoldersForm">
                                        <?=\Helpers\Form::open(array(
                                            'class' => 'exclusionPolicyForm',
                                            'csrf' => $data['csrf_token'],
                                            'autocomplete' => 'off',
                                            'ng-submit' => 'addExclusionFolder(current.exclusionFolderName)'
                                        ));?>
                                        <div class="col-lg-12">
                                            <label for="exclusionFolderName"><?=Language::show('exclusion_folder_name', 'keywords')?></label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                       ng-model="current.exclusionFolderName" name="exclusionFolderName" id="exclusionFolderName"
                                                       value="" placeholder="Enter the full path of the folder" autocomplete="off"
                                                       data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                       data-content="<?=Language::show('exclusionError', 'keywords')?>"
                                                    />
                                                <div class="input-group-btn">
                                                    <button type="submit" class="btn btn-default"><i class="fa fa-minus-circle"></i> <?=Language::show('exclude', 'keywords')?></button>
                                                </div>
                                            </div>
                                        </div>
                                        <?=\Helpers\Form::close()?>
                                    </div>
                                </div>
                            </div>
                            <hr />
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="bs-callout bs-callout-primary" id="callout-formgroup-inputgroup">
                                        <h4>Maximum File Size allowed :<span ng-if="currentUser.maxSizeAllowed == 1024"> Unlimited</span></h4>
                                        <p ng-if="currentUser.maxSizeAllowed < 1024">Any file more than <span ng-cloak>{{ currentUser.maxSizeAllowed }}</span> GB will not be backed up</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/directives/fileUpload.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
