/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('SyncPmsController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER) {

    $scope.sortReverse = false;
    $scope.sortType = 'policygroupName';
    $scope.sortTypeMapping = 'userName';
    $scope.sortTypeFilter = 'filterName';
    $scope.sortTypeSchedule = 'scheduleName';

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();
    $scope.selectedUser = $('.selectedUser').html();
    $scope.schedules = [];
    $scope.filters = [];
    $scope.policies = [];
    $scope.scheduleIndex = '';
    $scope.filterIndex = '';
    $scope.selectedPolicy = {};

    $scope.defaultWinFolders = ['c:\\', 'd:\\'];
    $scope.defaultMacFolders = ['/users/', '/home/'];

    $scope.currentDefaultWinFolders = ['c:\\', 'd:\\'];
    $scope.currentDefaultMacFolders = ['/users/', '/home/'];

    $scope.defaultSchedules = [];
    $scope.userPolicyMappingPolicies = [];
    $scope.userPolicyMappingUsers = [];

    $scope.bluvaults = [];
    $scope.blukrypts = [];

    $scope.preBackup = [];
    $scope.postBackup = [];
    $scope.preRestore = [];
    $scope.postRestore = [];

    $scope.ccS = [];

    $scope.toggleSelectPickerAll = function(){
        if($('.selectPicker').selectpicker('val') != null){
            if($('.selectPicker').selectpicker('val').length == 7){
                $('.scheduleDaily').html('Daily');
                $('.selectPicker').selectpicker('deselectAll');
            }else{
                $('.scheduleDaily').html('De Select All');
                $('.selectPicker').selectpicker('selectAll');
            }
        }else{
            $('.scheduleDaily').html('De Select All');
            $('.selectPicker').selectpicker('selectAll');
        }
    };

    $('.selectPicker').on('change', function(){
        toggleSelectPicker();
    });

    function toggleSelectPicker(){
        if($('.selectPicker').selectpicker('val') != null){
            if($('.selectPicker').selectpicker('val').length == 7){
                $('.scheduleDaily').html('De Select All');
            }else{
                $('.scheduleDaily').html('Daily');
            }
        }else{
            $('.scheduleDaily').html('Daily');
        }
    }

    $scope.scheduleCreate = function(remove){
        if($('.scheduleForm').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/schedule/save',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    if(remove == true){
                        $('.createSchedule').modal('hide');
                        $('#schedules').append($('<option>', {
                            value: $('[name="scheduleName"]').val(),
                            text: $('[name="scheduleName"]').val()
                        }));
                        $('.selectSchedulePicker').selectpicker('refresh');
                        var scheduleNames = $('.selectSchedulePicker').val();
                        if(scheduleNames != null){
                            scheduleNames.push($('[name="scheduleName"]').val());
                            $('.selectSchedulePicker').selectpicker('val', scheduleNames);
                        }else{
                            $('.selectSchedulePicker').selectpicker('val', $('[name="scheduleName"]').val());
                        }
                        $scope.updateSelectedScheduleNames($('.selectSchedulePicker').val());
                    }else{
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/pms/schedules';
                        }, 3000);
                    }
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.getSchedules = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/schedules',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.schedules = jData.schedules;
                $scope.$apply();
            }else{
                toastr.error('No Schedules has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.scheduleEdit = function(index){
        $scope.scheduleIndex = index;
        $('.scheduleEditTime').timepicker('setTime', $scope.schedules[$scope.scheduleIndex].time);
        $('.selectPicker').selectpicker('val', $scope.schedules[$scope.scheduleIndex].daysArray);
        $('.editSchedule').modal('show');
        if($scope.schedules[$scope.scheduleIndex].backupType == 'i'){
            $('.backupType').find('option[value="i"]').prop("selected",true);
        }else{
            $('.backupType').find('option[value="f"]').prop("selected",true);
        }
        $('.backupType').selectpicker('render');
        toggleSelectPicker();
    };

    $scope.scheduleSave = function(){
        if($('.scheduleForm').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/schedule/save',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    $scope.schedules[$scope.scheduleIndex].daysArray = $('.selectPicker').selectpicker('val');
                    $scope.schedules[$scope.scheduleIndex].time = $('[name="scheduleStartTime"]').val();
                    $scope.schedules[$scope.scheduleIndex].days = getDayNames($('.selectPicker').selectpicker('val').join(','));
                    $scope.schedules[$scope.scheduleIndex].backupType = $('.backupType').val();
                    $scope.$apply();
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
            $('.editSchedule').modal('hide');
        }
    };

    $scope.sendMeTo = function(url){
        window.location.href = $scope.BASE_FOLDER+url;
    };

    function getDayNames(numString){
        numString = numString.replace('1', 'Sunday');
        numString = numString.replace('2', 'Monday');
        numString = numString.replace('3', 'Tuesday');
        numString = numString.replace('4', 'Wednesday');
        numString = numString.replace('5', 'Thursday');
        numString = numString.replace('6', 'Friday');
        numString = numString.replace('7', 'Saturday');
        return numString;
    }

    $scope.getFilters = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/filters',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.filters = jData.filters;
                $scope.$apply();
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.filterCreate = function(remove){
        if($('.filterForm').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/filter/save',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    if(remove == true){
                        $('.createFilter').modal('hide');
                        $('#filters').append($('<option>', {
                            value: $('[name="filterName"]').val(),
                            text: $('[name="filterName"]').val()
                        }));
                        $('.selectFilterPicker').selectpicker('refresh');
                        $('.selectFilterPicker').selectpicker('val', $('[name="filterName"]').val());
                        $scope.updateSelectedFilters($('[name="filterName"]').val());
                    }else{
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/pms/filters';
                        },2000);
                    }
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
            $('.editSchedule').modal('hide');
        }
    };

    $scope.filterSave = function(){
        if($('.filterForm').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/filter/save',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    $('.editFilter').modal('hide');
                    $scope.filters[$scope.filterIndex].filters = $('.editFilters').tagsinput('items').join(',');
                    $scope.filters[$scope.filterIndex].filterType = $('.filterType').val();
                    $scope.$apply();
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
            $('.editSchedule').modal('hide');
        }
    };

    $scope.filterEdit = function(index){
        $scope.filterIndex = index;
        $('.editFilters').tagsinput('removeAll');
        $('.editFilters').tagsinput('add', $scope.filters[$scope.filterIndex].filters);
        if($scope.filters[$scope.filterIndex].filterType == "exclusion"){
            $('.filterType').find('option[value="exclusion"]').prop("selected",true);
        }else{
            $('.filterType').find('option[value="inclusion"]').prop("selected",true);
        }
        $('.filterType').selectpicker('refresh');
        $('.editFilter').modal('show');
    };

    $scope.getPolices = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policies',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success') {
                if (jData.policies.length > 0) {
                    $('.syncPolicyTable').show();
                    $('.syncPolicyTableEmpty').hide();
                    $scope.policies = jData.policies;
                    $scope.$apply();
                }else{
                    $('.syncPolicyTable').hide();
                    $('.syncPolicyTableEmpty').show();
                }
            }else{
                toastr.error('No Policy was found', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.addNewSchedule = function(){
        $('.createSchedule').modal('show');
    };

    $('.selectSchedulePicker').on('change', function(){
        $scope.updateSelectedScheduleNames($('.selectSchedulePicker').val());
    });

    $scope.updateSelectedScheduleNames = function(names){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/schedule',
            data: {csrf_token: $('.csrf_token').html(), scheduleNames: names},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.defaultSchedules = jData.schedules;
                $scope.$apply();
            }else{
                toastr.error('No Schedules were found', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.addNewFilter = function(){
        $('.createFilter').modal('show');
    };

    $scope.addNewCcS = function(){
        $('.createCcS').modal('show');
    };

    $('.selectFilterPicker').on('change', function(){
        $scope.updateSelectedFilters($('.selectFilterPicker').val());
    });

    $scope.updateSelectedFilters = function(filters){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/filter',
            data: {csrf_token: $('.csrf_token').html(), filterName: filters},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.defaultFilter = jData.filters;
                $scope.$apply();
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    if($('[name="defaultFoldersBackup"]')[0]){
        $('[name="defaultFoldersBackup"]')[0].addEventListener( 'keydown', function( ev ) {
            if(ev.keyCode == 13){
                ev.preventDefault();
            }
        });
    }

    $scope.addDefaultFolder = function($value){
        var osType = $('[name="osType"]').val();
        if((osType.toLowerCase()).indexOf('windows') > -1){
            osType = 'windows';
        }else{
            osType = 'mac';
        }
        if($value != '' && $value != null && $value != undefined){
            if(osType == 'windows'){
                $value = sanitizeValues(osType, $value, $scope.defaultWinFolders);
                if($value === false || $value == 'exist'){
                    $('[name="defaultFoldersBackup"]').popover('show');
                    return;
                }else{
                    $('[name="defaultFoldersBackup"]').popover('hide');
                    $('[name="defaultFoldersBackup"]').val('');
                    $scope.defaultWinFolders.push($value);
                    toastr.success('Selected Folder has been added successfully', 'Success!!!', {allowHtml: true});
                }
            }else if(osType == 'mac'){
                $value = sanitizeValues(osType, $value, $scope.defaultMacFolders);
                if($value === false || $value == 'exist'){
                    $('[name="defaultFoldersBackup"]').popover('show');
                    return;
                }else{
                    $('[name="defaultFoldersBackup"]').val('');
                    $('[name="defaultFoldersBackup"]').popover('hide');
                    $scope.defaultMacFolders.push($value);
                    toastr.success('Selected Folder has been added successfully', 'Success!!!', {allowHtml: true});
                }
            }else{
                toastr.info('Please select a Operating System type before adding a Folder Path', 'Information!!!', {allowHtml: true});
            }
        }else{
            $('[name="defaultFoldersBackup"]').popover('show');
            return;
        }
    };

    $scope.removeDefaultFolder = function($key){
        var osType = $('[name="osType"]').val();
        if((osType.toLowerCase()).indexOf('windows') > -1){
            $scope.defaultWinFolders.splice($key, 1);
            toastr.success('Selected Folder has been deleted successfully', 'Success!!!', {allowHtml: true});
        }else if((osType.toLowerCase()).indexOf('mac') > -1){
            toastr.success('Selected Folder has been deleted successfully', 'Success!!!', {allowHtml: true});
            $scope.defaultMacFolders.splice($key, 1);
        }else{
            toastr.info('Please select a Operating System type before deleting', 'Success!!!', {allowHtml: true});
        }
    };

    function sanitizeValues(osType, folder, $folders){
        var pattern = new RegExp(':');
        var result = '';
        if(osType == 'windows') {
            if(folder == '' || folder == null){
                return false;
            }else{
                if(pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length == 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\\');
                        folder = folder.replace(/\//g, '\\');
                        folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
                        return false;
                    }
                }else{
                    if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                    }else{
                        return false;
                    }
                }
            }
        }else{
            if(folder == '' || folder == null){
                return false;
            }else{
                if(!pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length != 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\/');
                        folder = folder.replace(/\\/g, "/");
                        folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
                        return false;
                    }
                }else{
                    if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                    }else{
                        return false;
                    }
                }
            }
        }
    }

    $('ul.sortable').sortable({ items: "> li", disableSelection: true });

    $scope.policyCreate = function(){
        var pgList = $('ul.sortable').sortable('toArray');
        var osType = $('[name="osType"]').val();
    if($('span#sizeerror').text() != "")
        {
            toastr.error('Please check the value for Maximum File Size  ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if($('span#limiterror').text() != "")
        {
            toastr.error('Please check the value for User Storage Quota ', 'Fail!!!', {allowHtml: true});
            return;
        }
    if($('span#switcherror').text() != "")
        {
            toastr.error('Please check the value for Network Throttle Setting from Client to BluKrypt ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if(parseInt($('[name="fileChunkableSize"]').val()) > parseInt($('[name="partialFileSize"]').val())){
            toastr.error('Partial File Size should be greater than File Chunkable Size', 'Fail!!!', {allowHtml: true});
            return;
        }
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policy/save',
            data: $('.policyForm').serialize()+'&osTyped='+osType+'&pgList=',
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.defaultFilter = jData.filters;
                $scope.$apply();
                toastr.success(jData.msg, 'Success!!!', {allowHtml: true});
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/pms/sync/policies';
                }, 3000);
            }else{
                myBlockUI.stop();
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            myBlockUI.stop();
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getPolicy = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policy',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.policy.privacyGatewayMappingElement.privacyGatewayNames != null)
                        {
                jData.policy.privacyGatewayMappingElement.privacyGatewayNames.forEach(function(value){
                    var $element = $(".blukryptIPAdress").find('option[value="'+value+'"]');
                    $element.detach();
                    $(".blukryptIPAdress").append($element);
                    $(".blukryptIPAdress").trigger("change");
                });
            }
        $('.exitt').find('option[value="false"]').prop("selected",true);
                $('.decouple').find('option[value="false"]').prop("selected",true);
                $('.support').find('option[value="false"]').prop("selected",true);
        $('.initiatesync').find('option[value="false"]').prop("selected",true);
                $('.syncsettings').find('option[value="false"]').prop("selected",true);
                $('.syncfiles').find('option[value="false"]').prop("selected",true);
                $('.refreshsyncpolicy').find('option[value="false"]').prop("selected",true);
                $('.search').find('option[value="false"]').prop("selected",true);
                $('.opensyncfolder').find('option[value="false"]').prop("selected",true);
                
                jData.policy.endpointUiPreferences.forEach(function(value){
        if(value === "EXIT"){
                    $('.exitt').find('option[value="true"]').prop("selected",true);
                }
                if(value === "DECOUPLE"){
                    $('.decouple').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SUPPORT"){
                    $('.support').find('option[value="true"]').prop("selected",true);
                }
                if(value === "INITIATE_SYNC"){
                    $('.initiatesync').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SYNC_SETTINGS"){
                    $('.syncsettings').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SYNC_FILES"){
                    $('.syncfiles').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SEARCH"){
                    $('.search').find('option[value="true"]').prop("selected",true);
                }
                if(value === "REFRESH_SYNC_POLICY"){
                    $('.refreshsyncpolicy').find('option[value="true"]').prop("selected",true);
                }
                if(value === "OPEN_SYNC_FOLDER"){
                    $('.opensyncfolder').find('option[value="true"]').prop("selected",true);
                }
                
                });
                $(".blukryptIPAdress").val("");
                $(".blukryptIPAdress").trigger('change');
                $(".blukryptIPAdress").val(jData.policy.privacyGatewayMappingElement.privacyGatewayNames);
                $(".blukryptIPAdress").trigger('change');
        $('#policyRefresh').val(jData.policy.policyRefresh);
                if((jData.policy.osType.toLowerCase()).indexOf('windows') > -1){
                    $('.selectOsTypePicker').find('option[value="windows"]').prop("selected",true);
                    if(jData.policy.vssEnabled == '1'){
                        $('.vssEnabled').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('.vssEnabled').find('option[value="false"]').prop("selected",true);
                    }
                }else{
                    $('.vssContainer').hide();
                    $('.selectOsTypePicker').find('option[value="mac"]').prop("selected",true);
                }
                if(jData.policy.pftEnabled == '1'){
                    $('.incrementalFileTransfer').find('option[value="true"]').prop("selected",true);
                    $('.incrementalFileTransfer').find('option[value="true"]').prop("selected",true);
                    $('.partialfileattributerow').removeClass('hide');
                    $('#partialFileSize').removeAttr('disabled', 'disabled');
                    $('#fileChunkableSize').removeAttr('disabled', 'disabled');
                }else{
                    $('.incrementalFileTransfer').find('option[value="false"]').prop("selected",true);
                    $('.incrementalFileTransfer').find('option[value="false"]').prop("selected",true);
                    $('.partialfileattributerow').addClass('hide');
                    $('#partialFileSize').attr('disabled', 'disabled');
                    $('#fileChunkableSize').attr('disabled', 'disabled');
                }
                if(jData.policy.syncEnableAutomatic == '1'){
                    $('.syncEnableAutomatic').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.syncEnableAutomatic').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.cacheUsedData == '1'){
                    $('.cacheUsedData').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.cacheUsedData').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.expiredDate == '1'){
                    $('.expiredDate').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.expiredDate').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.contentIndexEnabled == '1'){
                    $('.contentIndexEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.contentIndexEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.deDuplicationEnabled == '1'){
                    $('.deDuplicationEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.deDuplicationEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.shareEnabled == '1'){
                    $('.shareEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.shareEnabled').find('option[value="false"]').prop("selected",true);
                    $('.highSecureShareEnabled').hide();
                    $('.highSecuredShareOptions').hide();
                }
		if(jData.policy.twoWayShareEnabled == '1'){
                    $('.twoWayShareEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.twoWayShareEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.complexPasswordRequired == '1'){
                    $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.complexPasswordRequired').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.highSecureShareEnabled == '1'){
                    $('.highSecureShareEnabled').find('option[value="true"]').prop("selected",true);
                    $('.complexPasswordRequired').attr("disabled", true);
                    $('.preventDownloadEnabled').attr("disabled", true);
                    $('.expiredDate').attr("disabled", true);
                
                    $('.expiredDate').find('option[value="true"]').prop("selected",true);
                    $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
                    $('.preventDownloadEnabled').find('option[value="false"]').prop("selected",true);

                    $('.complexPasswordRequired').selectpicker('refresh');
                    $('.preventDownloadEnabled').selectpicker('refresh');
                    $('.expiredDate').selectpicker('refresh');
                }else{
                    $('.highSecureShareEnabled').find('option[value="false"]').prop("selected",true);
                    $('.complexPasswordRequired').attr("disabled", false);
                    $('.preventDownloadEnabled').attr("disabled", false);
                    $('.expiredDate').attr("disabled", false);
                    
                    $('.expiredDate').find('option[value="false"]').prop("selected",true);
                    $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
                    $('.preventDownloadEnabled').find('option[value="true"]').prop("selected",true);

                    $('.complexPasswordRequired').selectpicker('refresh');
                    $('.preventDownloadEnabled').selectpicker('refresh');
                    $('.expiredDate').selectpicker('refresh');
                }

                if(jData.policy.preventDownloadEnabled == '1'){
                    $('.preventDownloadEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.preventDownloadEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.networkThrottlingNames.length > 0){
                    $('.networkThrottling').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.networkThrottling').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.dcmEnabled == '1'){
                    $('.dcmEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.dcmEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.compressionEnabled == '1'){
                    $('.compEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.compEnabled').find('option[value="false"]').prop("selected",true);
                }
        $('.dedup').find('option[value="Disabled"]').prop("selected",true);
                if(jData.policy.dedup == 'User'){
                    $('.dedup').find('option[value="User"]').prop("selected",true);
                }else if(jData.policy.dedup == 'Global'){
                    $('.dedup').find('option[value="Global"]').prop("selected",true);
                }
                $('#sortAlgoForPg').find('option[value="NEAREST"]').prop("selected",true);
                if(jData.policy.searchAlgoForPg == 'PRIORITY'){
                    $('#sortAlgoForPg').find('option[value="PRIORITY"]').prop("selected",true);
                }

                //$scope.maxVersions = jData.policy.maxVersions;
                $('#maxVersions').val(jData.policy.maxVersions);
        document.getElementById('switchver').checked=true;
        $('#maxVersions').removeAttr('disabled');
                if(jData.policy.maxVersions == "-1"){
            document.getElementById('switchver').checked = false;
                    $('#maxVersions').val('UNLIMITED');
            $('#maxVersions').attr('disabled', 'disabled');
                }
                //$scope.maxPermissibleFileSize = jData.policy.maxFileSize;
                $('#maxFileSize').val(jData.policy.maxFileSize);
        document.getElementById('switchsize').checked=true;
                $('#maxFileSize').removeAttr('disabled');
                if(jData.policy.maxFileSize == "1048576"){
            document.getElementById('switchsize').checked = false;
                    $('#maxFileSize').val('UNLIMITED');
            $('#maxFileSize').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                //$scope.perUserBackupStorageLimit = jData.policy.userSizeAllowed;
                $('#userSizeAllowed').val(jData.policy.userSizeAllowed);
        document.getElementById('switchlimit').checked=true;
                $('#userSizeAllowed').removeAttr('disabled');
                if(jData.policy.userSizeAllowed == "102400"){
            document.getElementById('switchlimit').checked = false;
                    $('#userSizeAllowed').val('UNLIMITED');
            $('#userSizeAllowed').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                $('#nwFromClientToPG').val(jData.policy.nwFromClientToPG);
                document.getElementById('switch').checked=true;
                $('#nwFromClientToPG').removeAttr('disabled');
                if(jData.policy.nwFromClientToPG == "10000"){
                    document.getElementById('switch').checked = false;
                    $('#nwFromClientToPG').val('UNLIMITED');
                    $('#nwFromClientToPG').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }

		$('#nwFromClientToPGMB').val(jData.policy.nwFromClientToPGMB);
                $('#networkThrottlingUnit').find('option[value="mbps"]').prop("selected",true);
                 document.getElementById('switch').checked=true;
                $('#nwFromClientToPGMB').removeAttr('disabled');
                $('#networkThrottlingUnit').removeAttr("disabled","disabled");
                if(jData.policy.unit == "kbps"){
                    $('#networkThrottlingUnit').find('option[value="kbps"]').prop("selected",true);
                }
                else if(jData.policy.unit == "gbps"){
                    $('#networkThrottlingUnit').find('option[value="gbps"]').prop("selected",true);
                }
                
                if(jData.policy.nwFromClientToPGMB == "UNLIMITED"){
                    document.getElementById('switch').checked = false;
                    $('#nwFromClientToPGMB').val('UNLIMITED');
                    $('#nwFromClientToPGMB').attr('disabled', 'disabled');
                    $('#networkThrottlingUnit').attr("disabled","disabled");
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }

                $scope.cpuUtilization = jData.policy.cpuUtilization;
                $scope.memoryUtilization = jData.policy.memoryUtilization;

                $scope.osType = jData.policy.osType;
                $('.selectFilterPicker option[value="'+jData.policy.filterInclusionName+'"]').prop('selected', true);
                if(jData.policy.cloudCredential != undefined){
                    $('.selectCcSPicker  option[value="'+jData.policy.cloudCredential+'"]').prop("selected",true);
                }
                $('.syncEnableAutomatic').selectpicker('render');
                $('.expiredDate').selectpicker('render');
                $('.cacheUsedData').selectpicker('render');
                $('.contentIndexEnabled').selectpicker('render');
                $('.deDuplicationEnabled').selectpicker('render');
                $('.shareEnabled').selectpicker('render');
                $('.complexPasswordRequired').selectpicker('render');
                $('.highSecureShareEnabled').selectpicker('render');
                $('.preventDownloadEnabled').selectpicker('render');
                $('.compEnabled').selectpicker('render');
                $('.selectSchedulePicker').selectpicker('render');
                $('.selectOsTypePicker').selectpicker('render');
                $('.incrementalFileTransfer').selectpicker('render');
        $('.dedup').selectpicker('render');
                $('.networkThrottling').selectpicker('render');
                $('.dcmEnabled').selectpicker('render');
                $('.vssEnabled').selectpicker('render');
                $('.selectFilterPicker').selectpicker('render');
                $('#fullBackupPeriod').selectpicker('render');
                $('#fullBackupDay').selectpicker('render');
                $('.selectCcSPicker').selectpicker('render');
                $scope.updateSelectedFilters(jData.policy.filterInclusionName);
                $scope.selectedPolicy = jData.policy;
                $scope.$apply();
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.viewPolicy = function(policyName){
        var policyName = policyName;
        $('.viewPolicy').modal('show');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/viewpolicy',
            data: {csrf_token: $('.csrf_token').html(), secret: '',policyName: policyName},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.policy.privacyGatewayMappingElement.privacyGatewayNames != null)
                        {
                jData.policy.privacyGatewayMappingElement.privacyGatewayNames.forEach(function(value){
                    var $element = $(".blukryptIPAdress").find('option[value="'+value+'"]');
                    $element.detach();
                    $(".blukryptIPAdress").append($element);
                    $(".blukryptIPAdress").trigger("change");
                });
            }
        $('.exitt').find('option[value="false"]').prop("selected",true);
                $('.decouple').find('option[value="false"]').prop("selected",true);
                $('.support').find('option[value="false"]').prop("selected",true);
        $('.initiatesync').find('option[value="false"]').prop("selected",true);
                $('.syncsettings').find('option[value="false"]').prop("selected",true);
                $('.syncfiles').find('option[value="false"]').prop("selected",true);
                $('.refreshsyncpolicy').find('option[value="false"]').prop("selected",true);
                $('.search').find('option[value="false"]').prop("selected",true);
                $('.opensyncfolder').find('option[value="false"]').prop("selected",true);
                
                jData.policy.endpointUiPreferences.forEach(function(value){
        if(value === "EXIT"){
                    $('.exitt').find('option[value="true"]').prop("selected",true);
                }
                if(value === "DECOUPLE"){
                    $('.decouple').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SUPPORT"){
                    $('.support').find('option[value="true"]').prop("selected",true);
                }
                if(value === "INITIATE_SYNC"){
                    $('.initiatesync').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SYNC_SETTINGS"){
                    $('.syncsettings').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SYNC_FILES"){
                    $('.syncfiles').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SEARCH"){
                    $('.search').find('option[value="true"]').prop("selected",true);
                }
                if(value === "REFRESH_SYNC_POLICY"){
                    $('.refreshsyncpolicy').find('option[value="true"]').prop("selected",true);
                }
                if(value === "OPEN_SYNC_FOLDER"){
                    $('.opensyncfolder').find('option[value="true"]').prop("selected",true);
                }
                
                });
                $(".blukryptIPAdress").val("");
                $(".blukryptIPAdress").trigger('change');
                $(".blukryptIPAdress").val(jData.policy.privacyGatewayMappingElement.privacyGatewayNames);
                $(".blukryptIPAdress").trigger('change');
                $('#policyRefresh').val(jData.policy.policyRefresh);
                $("#filters").val(jData.policy.filterInclusionName);
                $('#partialFileSize').val(jData.policy.pftSize);
                    $('#fileChunkableSize').val(jData.policy.fileChunkableSize);
                    $('#dedup').val(jData.policy.dedup);
                    $('#searchAlgoForPg').val(jData.policy.searchAlgoForPg);
                    $('#Blukryptipaddress').val(jData.policy.privacyGatewayMappingElement.privacyGatewayNames);
                if((jData.policy.osType.toLowerCase()).indexOf('windows') > -1){
                    $('.selectOsTypePicker').find('option[value="windows"]').prop("selected",true);
                    if(jData.policy.vssEnabled == '1'){
                        $('.vssEnabled').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('.vssEnabled').find('option[value="false"]').prop("selected",true);
                    }
                }else{
                    $('.vssContainer').hide();
                    $('.selectOsTypePicker').find('option[value="mac"]').prop("selected",true);
                }
                if(jData.policy.pftEnabled == '1'){
                    $('.incrementalFileTransfer').find('option[value="true"]').prop("selected",true);
                    $('#incrementalFileTransfer').attr('disabled', 'disabled');
                    $('.partialfileattributerow').removeClass('hide');
                    $('#partialFileSize').removeAttr('disabled', 'disabled');
                    $('#fileChunkableSize').removeAttr('disabled', 'disabled');
                }else{
                    $('.incrementalFileTransfer').find('option[value="false"]').prop("selected",true);
                    $('#incrementalFileTransfer').attr('disabled', 'disabled');
                    $('.partialfileattributerow').addClass('hide');
                    $('#partialFileSize').attr('disabled', 'disabled');
                    $('#fileChunkableSize').attr('disabled', 'disabled');
                }
                if(jData.policy.syncEnableAutomatic == '1'){
                    $('.syncEnableAutomatic').find('option[value="true"]').prop("selected",true);
                    $('#syncEnableAutomatic').attr('disabled', 'disabled');
                }else{
                    $('.syncEnableAutomatic').find('option[value="false"]').prop("selected",true);
                    $('#syncEnableAutomatic').attr('disabled', 'disabled');
                }
                if(jData.policy.cacheUsedData == '1'){
                    $('.cacheUsedData').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.cacheUsedData').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.expiredDate == '1'){
                    $('.expiredDate').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.expiredDate').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.contentIndexEnabled == '1'){
                    $('.contentIndexEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.contentIndexEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.deDuplicationEnabled == '1'){
                    $('.deDuplicationEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.deDuplicationEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.shareEnabled == '1'){
                    $('.shareEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.shareEnabled').find('option[value="false"]').prop("selected",true);
                    $('.highSecureShareEnabled').hide();
                    $('.highSecuredShareOptions').hide();
                }
		if(jData.policy.twoWayShareEnabled == '1'){
                    $('.twoWayShareEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.twoWayShareEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.complexPasswordRequired == '1'){
                    $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.complexPasswordRequired').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.highSecureShareEnabled == '1'){
                    $('.highSecureShareEnabled').find('option[value="true"]').prop("selected",true);
                
                    $('.expiredDate').find('option[value="true"]').prop("selected",true);
                    $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
                    $('.preventDownloadEnabled').find('option[value="false"]').prop("selected",true);

                    $('.complexPasswordRequired').attr("disabled", true);
                    $('.preventDownloadEnabled').attr("disabled", true);
                    $('.expiredDate').attr("disabled", true);
                }else{
                    $('.highSecureShareEnabled').find('option[value="false"]').prop("selected",true);
                    
                    $('.expiredDate').find('option[value="false"]').prop("selected",true);
                    $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
                    $('.preventDownloadEnabled').find('option[value="true"]').prop("selected",true);

                    $('.complexPasswordRequired').attr("disabled", true);
                    $('.preventDownloadEnabled').attr("disabled", true);
                    $('.expiredDate').attr("disabled", true);
                }

                if(jData.policy.preventDownloadEnabled == '1'){
                    $('.preventDownloadEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.preventDownloadEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.networkThrottlingNames.length > 0){
                    $('.networkThrottling').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.networkThrottling').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.dcmEnabled == '1'){
                    $('.dcmEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.dcmEnabled').find('option[value="false"]').prop("selected",true);
                    
                }
                if(jData.policy.compressionEnabled == '1'){
                    $('.compEnabled').find('option[value="true"]').prop("selected",true);
                    $('#compEnabled').attr('disabled', 'disabled');
                }else{
                    $('.compEnabled').find('option[value="false"]').prop("selected",true);
                    $('#compEnabled').attr('disabled', 'disabled');
                }
        $('.dedup').find('option[value="Disabled"]').prop("selected",true);
                if(jData.policy.dedup == 'User'){
                    $('.dedup').find('option[value="User"]').prop("selected",true);
                }else if(jData.policy.dedup == 'Global'){
                    $('.dedup').find('option[value="Global"]').prop("selected",true);
                }
                $('#sortAlgoForPg').find('option[value="NEAREST"]').prop("selected",true);
                if(jData.policy.searchAlgoForPg == 'PRIORITY'){
                    $('#sortAlgoForPg').find('option[value="PRIORITY"]').prop("selected",true);
                }

                //$scope.maxVersions = jData.policy.maxVersions;
                $('#maxVersions').val(jData.policy.maxVersions);
        document.getElementById('switchver').checked=true;
        $('#switchver').attr('disabled', 'disabled');
                if(jData.policy.maxVersions == "-1"){
            document.getElementById('switchver').checked = false;
                    $('#maxVersions').val('UNLIMITED');
            $('#maxVersions').attr('disabled', 'disabled');
                }
                //$scope.maxPermissibleFileSize = jData.policy.maxFileSize;
                $('#maxFileSize').val(jData.policy.maxFileSize);
        document.getElementById('switchsize').checked=true;
                $('#switchsize').attr('disabled', 'disabled');
                if(jData.policy.maxFileSize == "1048576"){
            document.getElementById('switchsize').checked = false;
                    $('#maxFileSize').val('UNLIMITED');
            $('#maxFileSize').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                //$scope.perUserBackupStorageLimit = jData.policy.userSizeAllowed;
                $('#userSizeAllowed').val(jData.policy.userSizeAllowed);
        document.getElementById('switchlimit').checked=true;
                $('#switchlimit').attr('disabled', 'disabled');
                if(jData.policy.userSizeAllowed == "102400"){
            document.getElementById('switchlimit').checked = false;
                    $('#userSizeAllowed').val('UNLIMITED');
            $('#userSizeAllowed').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                $('#nwFromClientToPG').val(jData.policy.nwFromClientToPG);
                document.getElementById('switch').checked=true;
                $('#nwFromClientToPG').attr('disabled', 'disabled');
                $('#switch').attr('disabled', 'disabled');
                if(jData.policy.nwFromClientToPG == "10000"){
                    document.getElementById('switch').checked = false;
                    $('#nwFromClientToPG').val('UNLIMITED');
                    $('#nwFromClientToPG').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }

		$('#nwFromClientToPGMB').val(jData.policy.nwFromClientToPGMB);
                $('#networkThrottlingUnit').find('option[value="mbps"]').prop("selected",true);
                 document.getElementById('switch').checked=true;
                $('#nwFromClientToPGMB').removeAttr('disabled');
                $('#networkThrottlingUnit').removeAttr("disabled","disabled");
                if(jData.policy.unit == "kbps"){
                    $('#networkThrottlingUnit').find('option[value="kbps"]').prop("selected",true);
                }
                else if(jData.policy.unit == "gbps"){
                    $('#networkThrottlingUnit').find('option[value="gbps"]').prop("selected",true);
                }
                
                if(jData.policy.nwFromClientToPGMB == "UNLIMITED"){
                    document.getElementById('switch').checked = false;
                    $('#nwFromClientToPGMB').val('UNLIMITED');
                    $('#nwFromClientToPGMB').attr('disabled', 'disabled');
                    $('#networkThrottlingUnit').attr("disabled","disabled");
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }

                $scope.cpuUtilization = jData.policy.cpuUtilization;
                $scope.memoryUtilization = jData.policy.memoryUtilization;
                $('#shareEnabled').attr('disabled', 'disabled');
                $('#twoWayShareEnabled').attr('disabled', 'disabled');
                $('#highSecureShareEnabled').attr('disabled', 'disabled');
                $('#complexPasswordRequired').attr('disabled', 'disabled');
                $('#preventDownloadEnabled').attr('disabled', 'disabled');
                $('#expiredDate').attr('disabled', 'disabled');
                
                $('#exitt').attr('disabled', 'disabled');
                $('#syncfiles').attr('disabled', 'disabled');
                $('#decouple').attr('disabled', 'disabled');
                $('#refreshsyncpolicy').attr('disabled', 'disabled');
                $('#support').attr('disabled', 'disabled');
                $('#search').attr('disabled', 'disabled');
                $('#initiatesync').attr('disabled', 'disabled');
                $('#opensyncfolder').attr('disabled', 'disabled');
                $('#syncsettings').attr('disabled', 'disabled');

                $scope.osType = jData.policy.osType;
                $('.selectFilterPicker option[value="'+jData.policy.filterInclusionName+'"]').prop('selected', true);
                if(jData.policy.cloudCredential != undefined){
                    $('.selectCcSPicker  option[value="'+jData.policy.cloudCredential+'"]').prop("selected",true);
                }
                
                $scope.updateSelectedFilters(jData.policy.filterInclusionName);
                $scope.selectedPolicy = jData.policy;
                $scope.$apply();
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getUserPolicy = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/user/policy',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function assignCallOutScripts(scripts){
        if(scripts){
            if(scripts.length >= 1){
                scripts.forEach(function(value, key){
                    var items = value.split("|");
                    var scriptName = items[0];
                    var scriptArgs;
                    var scriptType = items[1];
                    if(items[2]){
                        scriptArgs = items[2].split(",");
                    }
                    var data = {};
                    switch (scriptType){
                        case 'preBackupF':
                            data = {
                                scriptName: scriptName,
                                backupType: 'f',
                                scriptArgs: scriptArgs
                            };
                            if($scope.preBackup.length <= 2){
                                $scope.preBackup.push(data);
                            }
                            break;
                        case 'postBackupF':
                            data = {
                                scriptName: scriptName,
                                backupType: 'f',
                                scriptArgs: scriptArgs
                            };
                            if($scope.postBackup.length <= 2){
                                $scope.postBackup.push(data);
                            }
                            break;
                        case 'preRestoreF':
                            data = {
                                scriptName: scriptName,
                                backupType: 'f',
                                scriptArgs: scriptArgs
                            };
                            if($scope.preRestore.length <= 2){
                                $scope.preRestore.push(data);
                            }
                            break;
                        case 'postRestoreF':
                            data = {
                                scriptName: scriptName,
                                backupType: 'f',
                                scriptArgs: scriptArgs
                            };
                            if($scope.postRestore.length <= 2){
                                $scope.postRestore.push(data);
                            }
                            break;
                        case 'preBackupI':
                            data = {
                                scriptName: scriptName,
                                backupType: 'i',
                                scriptArgs: scriptArgs
                            };
                            if($scope.preBackup.length <= 2){
                                $scope.preBackup.push(data);
                            }
                            break;
                        case 'postBackupI':
                            data = {
                                scriptName: scriptName,
                                backupType: 'i',
                                scriptArgs: scriptArgs
                            };
                            if($scope.postBackup.length <= 2){
                                $scope.postBackup.push(data);
                            }
                            break;
                        case 'preRestoreI':
                            data = {
                                scriptName: scriptName,
                                backupType: 'i',
                                scriptArgs: scriptArgs
                            };
                            if($scope.preRestore.length <= 2){
                                $scope.preRestore.push(data);
                            }
                            break;
                        case 'postRestoreI':
                            data = {
                                scriptName: scriptName,
                                backupType: 'i',
                                scriptArgs: scriptArgs
                            };
                            if($scope.postRestore.length <= 2){
                                $scope.postRestore.push(data);
                            }
                            break;
                        default:
                            break;
                    }

                });
            }
        }
    }

    $scope.updatePolicyMappingList = function(skipValue, userName){
        $scope.searchForUserName = userName;
        var myBlockUI = blockUI.instances.get('myBlockUI');
        if(skipValue == 0){
            myBlockUI.start();
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policyMapping/single',
            data: {csrf_token: $('.csrf_token').html(), skipValue: skipValue, userName: userName},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(userName != 'all'){
                    $('.loadMore').hide();
                }
                if(skipValue != 0){
                    $scope.userPolicyMappingUsers = $scope.userPolicyMappingUsers.concat(jData.users);
                }else{
                    if(jData.users.length <= 0){
                        if(skipValue == 0){
                            toastr.info('There was no users found for the provided username', 'Information!!!', {allowHtml: true});
                        }
                    }else{
                        $scope.userPolicyMappingUsers = jData.users;
                    }
                }
                $scope.userPolicyMappingPolicies = jData.policies;
                $scope.skipValue = skipValue+1;
                $scope.$apply();
                if(jData.users.length > 0){
                    if(userName == 'all' || userName == ''){
                        if($scope.userPolicyMappingUsers.length < 200){
                            $scope.updatePolicyMappingList($scope.skipValue, userName);
                        }else{
                            $('.loadMore').show();
                        }
                    }
                }else{
                    if(skipValue != 0) {
                        //toastr.info('All users has been loaded successfully', 'Information!!!', {allowHtml: true});
                        $('.loadMore').hide();
                    }
                }
                $('.userPolicyMappingListTable').show();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateServerPolicyMappingList = function(skipValue, userName){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        if(skipValue == 0){
            myBlockUI.start();
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policyMapping/server/single',
            data: {csrf_token: $('.csrf_token').html(), skipValue: skipValue, userName: userName},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(skipValue != 0){
                    $scope.userPolicyMappingUsers = $scope.userPolicyMappingUsers.concat(jData.users);
                }else{
                    if(jData.users.length <= 0){
                        if(skipValue == 0){
                            toastr.info('There was no servers found for the provided server name', 'Information!!!', {allowHtml: true});
                        }
                    }else{
                        $scope.userPolicyMappingUsers = jData.users;
                    }
                }
                $scope.userPolicyMappingPolicies = jData.policies;
                $scope.skipValue = skipValue+1;
                $scope.$apply();
                if(jData.users.length > 0){
                    if(userName == 'all' || userName == ''){
                        if($scope.userPolicyMappingUsers.length < 200){
                            $scope.updatePolicyMappingList($scope.skipValue, userName);
                        }
                    }
                }else{
                    if(skipValue != 0) {
                        //toastr.info('All servers has been loaded successfully', 'Information!!!', {allowHtml: true});
                    }
                }
                $('.userPolicyMappingListTable').show();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.showMappingList = function(userName){
        $('.mappingRow'+userName+' .policyName span').hide();
        $('.mappingRow'+userName+' .policyName form').show();
        $('.mappingRow'+userName+' .action .edit').hide();
        $('.mappingRow'+userName+' .action .save').show();
        $('.mappingRow'+userName+' .action .cancel').show();
        var value = $('.mappingRow'+userName+' .policyName span').html();
        $('#userPolicyMappingPolicyName option[value="'+value+'"]').prop('selected', true);
    };

    $scope.cancelChangePolicy = function(userName){
        $('.mappingRow'+userName+' .policyName span').show();
        $('.mappingRow'+userName+' .policyName form').hide();
        $('.mappingRow'+userName+' .action .edit').show();
        $('.mappingRow'+userName+' .action .save').hide();
    };
    
    $scope.changePolicy = function(userName,oldPolicyName){
        var userName = userName;
        var oldPolicyName = oldPolicyName;
        var name = 'userPolicyMappingPolicyName'+userName;
        var newPolicyName = $('[name='+name+']').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/policyMapping/single/save',
            data: {csrf_token: $('.csrf_token').html(), userName: userName, oldPolicyName: oldPolicyName, newPolicyName: newPolicyName},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.updatePolicyMappingList(0, 'all');
                $scope.$apply();
                $('.mappingRow'+userName+' .policyName span').show();
                $('.mappingRow'+userName+' .policyName form').hide();
                $('.mappingRow'+userName+' .action .edit').show();
                $('.mappingRow'+userName+' .action .save').hide();
                toastr.success('User Policy has been successfully mapped', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    
    $scope.changeMultiplePolicy = function(){
        var multiplePolicyName = $('[name="multiplePolicyName"]').selectpicker('val');
        var html = $('.pmsSavePolicyBtn').html();
        $('.pmsSavePolicyBtn').attr('disabled','disabled');
        $('.pmsSavePolicyBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();

        if(multiplePolicyName && $('#userNames').val()){
            var userNames = $('#userNames').val();
            userNames = userNames.replace(/\s/g,'');
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/sync/policyMapping/multiple/save',
                data: {csrf_token: $('.csrf_token').html(), userNames: userNames, policyName: multiplePolicyName},
                type: 'POST'
            }).done(function(data){
                $('.pmsSavePolicyBtn').removeAttr('disabled');
                $('.pmsSavePolicyBtn').html(html);
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success('User Policy has been successfully mapped', 'Success!!!', {allowHtml: true});
                    $('#userNames').val("");
                    setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/pms/sync/policyMapping/single';
                }, 3000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(!$('#userNames').val()){
                toastr.info('Please select users', 'Information!!!', {allowHtml: true});
                $('.pmsSavePolicyBtn').removeAttr('disabled');
            }else{
                toastr.info('Please select a Policy', 'Information!!!', {allowHtml: true});
                $('.pmsSavePolicyBtn').removeAttr('disabled');
            }
        }
    };

    $scope.getBluvault = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/bluvault',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.bluvaults != null){
                    $scope.bluvaults = jData.bluvaults;
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.saveBluvault = function(bluvault){
        bluvault.replace("https://", '');
        bluvault.replace("http://", '');
        if(checkIfExistsInBluvault($scope.bluvaults, bluvault)){
            toastr.info('Bluvault has already been added', 'Information!!!', {allowHtml: true});
            return;
        }
        var html = $('.submit').html();
        $('.submit').attr('disabled','disabled');
        $('.submit').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/bluvault/save',
            data: {csrf_token: $('.csrf_token').html(), bluvault: bluvault},
            type: 'POST'
        }).done(function(data){
            $('.submit').html(html);
            $('.submit').removeAttr('disabled','disabled');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.getBluvault();
                toastr.success('Bluvault has been successfully Added', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeBluvault = function(bluvaultId, $key){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/bluvault/delete',
            data: {csrf_token: $('.csrf_token').html(), bluvaultId: bluvaultId},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.bluvaults.splice($key, 1);
                toastr.success('Bluvault has been successfully removed', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getBlukrypts = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/getAllBlukrypts',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.blukrypts != null){
                    $scope.blukrypts = jData.blukrypts;
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeBluKrypt = function(bluKrypt, $key){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/blukrypt/remove',
            data: {csrf_token: $('.csrf_token').html(), bluKrypt: bluKrypt},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.blukrypts.splice($key, 1);
                toastr.success('BluKrypt has been successfully removed', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.saveBlukrypt = function(blukrypt){
        var blukryptType = $('[name="blukryptType"]').val();
        blukrypt = blukrypt.replace("https://", '');
        blukrypt = blukrypt.replace("http://", '');
        if(checkIfExistsInBlukrypt($scope.blukrypts, blukrypt, blukryptType)){
            toastr.info('Blukrypt has already been added', 'Information!!!', {allowHtml: true});
            return;
        }
        var html = $('.submit').html();
        $('.submit').attr('disabled','disabled');
        $('.submit').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/blukrypt/save',
            data: {csrf_token: $('.csrf_token').html(), blukrypt: blukrypt, blukryptType: blukryptType},
            type: 'POST'
        }).done(function(data){
            $('.submit').html(html);
            $('.submit').removeAttr('disabled','disabled');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('[name="blukrypt"]').val('');
                $scope.getBlukrypts();
                toastr.success('Blukrypt has been successfully Added', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.setThrottlingLimit = function(blukrypt){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/throttling/save',
            data: $('.throttlingForm').serialize(),
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.reload();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeThrottlingLimit = function(id){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/throttling/remove',
            data: {csrf_token: $('.csrf_token').html(), id: id},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.reload();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.openScript = function(scriptType){
        $scope.scriptType = scriptType;
        $('.addScript').modal('show');
    };

    $scope.addAScript = function(){
        $scope.tempScriptName = $('[name="scriptName"]').val();
        $scope.tempScriptArgs = $('#scriptArgs').val();
        $scope.tempBackupType = $('#backupType').val();

        if($scope.tempScriptName.length >= 1){

            var data = {
                scriptName : $scope.tempScriptName,
                backupType : $scope.tempBackupType,
                scriptArgs : $scope.tempScriptArgs
            };
            switch($scope.scriptType) {
                case 'preBackup':
                    if($scope.preBackup.length <= 2){
                        $scope.preBackup.push(data);
                        toastr.success('Script has been added successfully', 'Successfully', {allowHtml: true});
                    }else{
                        toastr.error('Only 2 Scripts can be executed pre backup', 'Fail!!!', {allowHtml: true});
                    }
                    break;
                case 'postBackup':
                    if($scope.postBackup.length <= 2){
                        $scope.postBackup.push(data);
                        toastr.success('Script has been added successfully', 'Successfully', {allowHtml: true});
                    }else{
                        toastr.error('Only 2 Scripts can be executed post backup', 'Fail!!!', {allowHtml: true});
                    }
                    break;
                case 'preRestore':
                    if($scope.preRestore.length <= 2){
                        $scope.preRestore.push(data);
                        toastr.success('Script has been added successfully', 'Successfully', {allowHtml: true});
                    }else{
                        toastr.error('Only 2 Scripts can be executed pre restore', 'Fail!!!', {allowHtml: true});
                    }
                    break;
                case 'postRestore':
                    if($scope.postRestore.length <= 2){
                        $scope.postRestore.push(data);
                        toastr.success('Script has been added successfully', 'Successfully', {allowHtml: true});
                    }else{
                        toastr.error('Only 2 Scripts can be executed post restore', 'Fail!!!', {allowHtml: true});
                    }
                    break;
                default:
                    toastr.error('Did not match any of the script type, please try again after some time.', 'Fail!!!', {allowHtml: true});
                    break;
            }
            $('[name="scriptName"]').val('');
            $('#scriptArgs').val(null).trigger("change");
            $('.addScript').modal('hide');
        }else{
            toastr.error('Please enter a script Name', 'Fail!!!', {allowHtml: true});
        }
    };

    $scope.removeScript = function(scriptType, index){
        switch(scriptType) {
            case 'preBackup':
                if($scope.preBackup.length <= 2){
                    $scope.preBackup.splice(index, 1);
                    toastr.success('Script has been removed successfully', 'Successfully', {allowHtml: true});
                }else{
                    toastr.error('Selected script was not found', 'Fail!!!', {allowHtml: true});
                }
                break;
            case 'postBackup':
                if($scope.postBackup.length <= 2){
                    $scope.postBackup.splice(index, 1);
                    toastr.success('Script has been removed successfully', 'Successfully', {allowHtml: true});
                }else{
                    toastr.error('Selected script was not found', 'Fail!!!', {allowHtml: true});
                }
                break;
            case 'preRestore':
                if($scope.preRestore.length <= 2){
                    $scope.preRestore.splice(index, 1);
                    toastr.success('Script has been removed successfully', 'Successfully', {allowHtml: true});
                }else{
                    toastr.error('Selected script was not found', 'Fail!!!', {allowHtml: true});
                }
                break;
            case 'postRestore':
                if($scope.postRestore.length <= 2){
                    $scope.postRestore.splice(index, 1);
                    toastr.success('Script has been removed successfully', 'Successfully', {allowHtml: true});
                }else{
                    toastr.error('Selected script was not found', 'Fail!!!', {allowHtml: true});
                }
                break;
            default:
                toastr.error('Did not match any of the script type, please try again after some time.', 'Fail!!!', {allowHtml: true});
                break;
        }
    };

    $scope.getAllCloudCredentials = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/getCloudCredentials',
            data: $('form').serialize(),
            type: 'POST'
        }).done(function(data){
            $('.ccSPanel').show();
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                if(jData.ccS.length > 0){
                    $scope.ccS = jData.ccS;
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.saveCloudCredentials = function(type){
        if($('.cloudCredentials').parsley().isValid()){
            var html = $('.saveCcS').html();
            $('.saveCcS').attr('disabled','disabled');
            $('.saveCcS').html('Deleting... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/saveCloudCredentials',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.saveCcS').removeAttr('disabled');
                $('.saveCcS').html(html);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    if(type == true){
                        $('.createCcS').modal('hide');
                        $('#ccS').append($('<option>', {
                            value: $('[name="identity"]').val(),
                            text: $('[name="identity"]').val()
                        }));
                        $('.selectCcSPicker').selectpicker('val', $('[name="identity"]').val());
                        $('.selectCcSPicker').selectpicker('refresh');
                    }else{
                        $scope.getAllCloudCredentials();
                    }
                    $('.cloudCredentials input').val('');
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.removeCloudCredentials = function(key){
        var btn = $('.removeCredentialsBtn'+key);
        var html = btn.html();
        btn.attr('disabled','disabled');
        btn.html('Removing... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        if($scope.ccS[key]){
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/removeCloudCredentials',
                data: {identity: $scope.ccS[key].identity, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                btn.removeAttr('disabled');
                btn.html(html);
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    $scope.getAllCloudCredentials();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    function checkIfExistsInBluvault(bluvaults, bluvault){
        var result = false;
        if(bluvaults.length > 0){
            bluvaults.forEach(function(value, key){
                if(value.bluVaultName == bluvault){
                    result = true;
                }
            });
        }
        return result;
    }

    function checkIfExistsInBlukrypt(blukrypts, blukrypt, type){
        var result = false;
        if(blukrypts.length > 0) {
            blukrypts.forEach(function (value, key) {
                if (value.gatewayName == blukrypt && value.type == type) {
                    result = true;
                }
            });
        }
        return result;
    }

    function enableLegalHold(){
        $scope.maxVersions = $('#maxVersions').val();
        $scope.maxPermissibleFileSize = $('#maxPermissibleFileSize').val();
        $scope.perUserBackupStorageLimit = $('#perUserBackupStorageLimit').val();
        $scope.cpuUtilization = $('#cpuUtilization').val();
        $scope.memoryUtilization = $('#memoryUtilization').val();
        $scope.currentDefaultWinFolders = $scope.defaultWinFolders;
        $scope.currentDefaultMacFolders = $scope.defaultMacFolders;
        $scope.defaultWinFolders = ['ALL'];
        $scope.defaultMacFolders = ['ALL'];
        $scope.$apply();
        $('.allFilters').hide();
        $('#maxVersions').val('UNLIMITED');
        $('#maxVersions').attr('readonly', 'readonly');
        $('#maxVersions').removeAttr('data-parsley-type','integer');
        $('#maxVersions').removeAttr('data-parsley-min','1');

        $('#maxPermissibleFileSize').val('UNLIMITED');
        $('#maxPermissibleFileSize').attr('readonly', 'readonly');
        $('#maxPermissibleFileSize').removeAttr('data-parsley-type','integer');
        $('#maxPermissibleFileSize').removeAttr('data-parsley-min','1');

        $('#perUserBackupStorageLimit').val('UNLIMITED');
        $('#perUserBackupStorageLimit').attr('readonly', 'readonly');
        $('#perUserBackupStorageLimit').removeAttr('data-parsley-type','integer');
        $('#perUserBackupStorageLimit').removeAttr('data-parsley-min','1');

        $('#cpuUtilization').val(100);
        $('#cpuUtilization').attr('readonly', 'readonly');
        $('#cpuUtilization').removeAttr('data-parsley-min','20');
        $('#cpuUtilization').removeAttr('data-parsley-max','100');

        $('#memoryUtilization').val(1024);
        $('#memoryUtilization').attr('readonly', 'readonly');
        $('#memoryUtilization').removeAttr('data-parsley-min','20');
        $('#memoryUtilization').removeAttr('data-parsley-max','100');

        $('#defaultFoldersBackup').attr('disabled', 'disabled');
        $('.defaultFoldersBackupBtn').attr('disabled', 'disabled');

        $('.systemFolders').show();
    }

    function disableLegalHold(){
        if($scope.maxVersions <= 0){
            $scope.maxVersions = 1
        }
        if($scope.maxPermissibleFileSize <= 0){
            $scope.maxPermissibleFileSize = 1024
        }
        if($scope.perUserBackupStorageLimit <= 0){
            $scope.perUserBackupStorageLimit = 10
        }
        if($scope.cpuUtilization <= 0){
            $scope.cpuUtilization = 80
        }
        if($scope.memoryUtilization <= 0){
            $scope.memoryUtilization = 80
        }
        $('.allFilters').show();
        $('#maxVersions').val($scope.maxVersions);
        $('#maxVersions').removeAttr('readonly');
        $('#maxVersions').attr('data-parsley-type','integer');
        $('#maxVersions').attr('data-parsley-min','1');

        $('#maxPermissibleFileSize').val($scope.maxPermissibleFileSize);
        $('#maxPermissibleFileSize').removeAttr('readonly');
        $('#maxPermissibleFileSize').attr('data-parsley-type','integer');
        $('#maxPermissibleFileSize').attr('data-parsley-min','1');

        $('#perUserBackupStorageLimit').val($scope.perUserBackupStorageLimit);
        $('#perUserBackupStorageLimit').removeAttr('readonly');
        $('#perUserBackupStorageLimit').attr('data-parsley-type','integer');
        $('#perUserBackupStorageLimit').attr('data-parsley-min','1');

        $('#memoryUtilization').val($scope.memoryUtilization);
        $('#memoryUtilization').removeAttr('readonly');
        $('#memoryUtilization').attr('data-parsley-type','integer');
        $('#memoryUtilization').attr('data-parsley-min','20');
        $('#memoryUtilization').attr('data-parsley-max','100');

        $('#cpuUtilization').val($scope.cpuUtilization);
        $('#cpuUtilization').removeAttr('readonly');
        $('#cpuUtilization').attr('data-parsley-type','integer');
        $('#cpuUtilization').attr('data-parsley-min','20');
        $('#cpuUtilization').attr('data-parsley-max','100');

        $('#defaultFoldersBackup').removeAttr('disabled');
        $('.defaultFoldersBackupBtn').removeAttr('disabled');

        $('.systemFolders').hide();
        $('#systemFolders').removeAttr('checked');
        if($scope.currentDefaultWinFolders != 'ALL' && $scope.currentDefaultMacFolders != 'ALL'){
            $scope.defaultWinFolders = $scope.currentDefaultWinFolders;
            $scope.defaultMacFolders = $scope.currentDefaultMacFolders;
        }else{
            $scope.defaultWinFolders = ['c:\\', 'd:\\'];
            $scope.defaultMacFolders = ['/users/', '/home/'];
        }
        $scope.$apply();
    }

    $scope.redirectTo = function(url){
        window.location = url;
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');

        if($scope.currentPage == 'schedule'){
            $scope.getSchedules();
        }

        if($scope.currentPage == 'filter'){
            $scope.getFilters();
        }

        if($scope.currentPage == 'policy'){
            $scope.getPolices();
        }

        if($scope.currentPage == 'editPolicy'){
            $scope.getPolicy();
        }
        
        if($scope.currentPage == 'clonePolicy'){
            $scope.getPolicy();
        }

        if($scope.currentPage == 'singlePolicyMapping'){
            $scope.updatePolicyMappingList(0, 'all');
        }

        if($scope.currentPage == 'singleServerPolicyMapping'){
            $scope.updateServerPolicyMappingList(0, 'all');
        }

        if($scope.currentPage == 'bluvault'){
            $scope.getBluvault();
        }

        if($scope.currentPage == 'blukrypts'){
            $scope.getBlukrypts();
        }

        if($scope.currentPage == 'ccS'){
            $scope.getAllCloudCredentials();
        }

        $('#legalHold').on('change', function(){
            var checked = document.getElementById('legalHold').checked;
            if(checked){
                enableLegalHold();
            }else{
                disableLegalHold();
            }
        });

    });

}]);
