/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('SyncController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'Upload', '$timeout', 'md5', 'fileMd5Service', 'timeAgo', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER, Upload, $timeout, md5, fileMd5Service, timeAgo) {

    timeAgo.settings.fullDateAfterSeconds = 60*60*24;

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();

    $scope.sortReverse = true;
    $scope.sortType = 'type';
    $scope.listOFBlukrypts = [];
    $scope.bestBlukrypt = '';

    $scope.items = [];
    $scope.crumb = [];
    $scope.fileVersions = [];
    $scope.crumbString = '';
    $scope.currentCrumb = '';
    $scope.currentFileUploadList = [];

    $scope.selectedMiniClouds = [];
    $scope.selectedFolders = [];
    $scope.selectedFiles = [];
    $scope.copiedItems = [];
    $scope.cutItems = [];
    $scope.selected = [];
    $scope.userNameList = [];
    $scope.selectedMiniCloudName = '';

    $scope.selectedFilesForCopyCut = [];
    $scope.selectedFilesForCopyCutFromPath = '';

    $scope.selectedShareWithUserEmailIDs = [];

    $scope.allowedFileAttributes = [];
    $scope.notAllowedFileAttributes = [];

    $scope.userAssignedPolicy = {};

    $scope.stripAddr = function(address) {
      return address.replace("ParaBlu", "Parablu");;
    }

    $scope.check = function(file) {
        var fileUploadLimitSize = $('.file-limit-size').html();
        //var res = true;
        if(checkIfAllowed(file.name)){
                    if(!isNaN(fileUploadLimitSize) && fileUploadLimitSize.length > 0){
                        if(file.size <= (fileUploadLimitSize*1000*1000)){
        //                            $scope.currentFileUploadList.push(file);
                        }else{
                            toastr.error('File Size greater than '+fileUploadLimitSize+' MB are not allowed', 'Fail!!!', {allowHtml: true});
        //			    setTimeout(function(){ location.reload(); }, 5000);
        //res = false;
                        }
                    }else{
                        //$scope.currentFileUploadList.push(file);
                    }
                    $scope.$apply();
                }else{
                    if($scope.notAllowedFileAttributes.length > 0){
                        toastr.error('Extensions '+$scope.notAllowedFileAttributes.join(', ')+' not allowed', 'Fail!!!', {allowHtml: true});
        //			setTimeout(function(){ location.reload(); }, 5000);
        //res = false;
                    }else{
                        toastr.error('Only Extensions, '+$scope.allowedFileAttributes.join(', ')+' are allowed', 'Fail!!!', {allowHtml: true});
        //			setTimeout(function(){ location.reload(); }, 5000);
        //res = false;
                    }
                }
        //return res;
    }


    $scope.uploadTimeout = function(){
	toastr.error('Upload Timeout, Unfinished files are failed to upload', 'Fail!!!');
	}

    $scope.uploadSuccess = function(name){
	toastr.success(name+' has been uploaded successfully', 'Successful!!!', {allowHtml: true});
	}

    $scope.uploadFailed = function(name){
	toastr.error('Could not upload the file, '+name+', ', 'Fail!!!', {allowHtml: true});
	}

    $scope.alreadyExists = function(name){
    toastr.error('File, '+name+' already Exists', 'Fail!!!', {allowHtml: true});
	//setTimeout(function(){ location.reload(); }, 3000);
        }

    $scope.errorNetwork = function(){
    toastr.error('Network failure', 'Fail!!!', {allowHtml: true});
    }

    $scope.cancelFile = function(name){
	var filename = name;
                        if(filename.length > 25)
                        {
                            filename = filename.substring(0,25)+"...";
                        }
        toastr.error('Upload cancelled for, '+filename, 'Fail!!!', {allowHtml: true});
        }


    $scope.updateFileList = function(filePath, currentPath, update, refreshed){
        if(filePath == $scope.crumbString){
            return false;
        }
        if(refreshed != true){
            refreshed = false;
        }
        filePath = filePath.replace(/\/$/, '');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $scope.selected = [];
        if(filePath == 'root'){
            $scope.crumb = [];
            $scope.crumbString = '';
            $scope.currentCrumb = '';
        }
        $('.status').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files',
            type: 'POST',
            data: {csrf_token: $('.csrf_token').html(), filePath: filePath, refresh: refreshed}
        }).done(function(data){
            $('#selectable tr').removeClass('ui-selected');
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success') {
                disableButtons();
                checkBreadCrumb();
                $('.filePanel').show();
                if (filePath != 'root') {
                    $scope.currentCrumb = currentPath;
                    if (update == true) {
                        $scope.crumb.push(currentPath);
                    }
                    $scope.crumbString = filePath + '/';
                } else {
                    if (refreshed == true) {
                        if (jData.crumb && jData.crumbString) {
                            $scope.crumb = jData.crumb;
                            $scope.crumbString = jData.crumbString + '/';
                            $scope.$apply();
                        }
                    }
                }
		var a = '';
		for(i=0;i<$scope.crumb.length;i++){
		//console.log("element"+i+$scope.crumb[i]);
		a += $scope.crumb[i]+"/";

		}
		//console.log("elementAA"+a);
		//$('#cru').val(a);
		document.getElementById("cru").innerHTML = a;
		document.getElementById("cru").value = a;
                $scope.items = jData.items.sort(compare);
		//console.log("Scope--> "+$scope.items.length);
		var files = [];
		$scope.items.forEach(function (file, key) {
		//console.log("FileNames : "+file.fileName);
		files.push(file.fileName);
		});
		//console.log("FILES : "+files.length);
		document.getElementById("filesListing").innerHTML = files;
                $scope.$apply();
                if($scope.items.length <= 0){
                    $('.status').show();
                }
                if($scope.openFileRevisionFor.length > 0){
                    if($scope.openFileRevisionFor != 'none') {
                        jData.items.forEach(function (file, key) {
                            if ($scope.crumbString+file.fileName == htmlspecialchars_decode($scope.openFileRevisionFor)) {
                                $scope.selectedFiles.push(file);
                            }
                        });
                        $scope.openFileRevisionFor = 'none';
                        $('.openFileRevision').html('none');
                        if($scope.selectedFiles.length == 1){
                            if($scope.selectedFiles[0].storagePlace.length <= 0){
                                toastr.error('Selected file has not yet been moved to Cloud', 'Fail!!!', {allowHtml: true});
                            }else{
                                $scope.versions();
                            }
                        }else{
                            toastr.error('Selected file was not found or it might have not been synced yet', 'Fail!!!', {allowHtml: true});
                        }
                    }
                }
            }else{
                toastr.error('There are no <b>Files</b> nor <b>Folders</b> inside, Redirecting you back', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateFileListFromBreadCrumb = function(currentPath, key){
        var filePath = '';
        var crumb = [];
        for(var i = 0; i <= key; i++){
            filePath = filePath+$scope.crumb[i]+'/';
            crumb.push($scope.crumb[i]);
        }
        if(filePath != ''){
            $scope.crumb = crumb;
            $scope.updateFileList(filePath, currentPath, false);
        }else{
            $scope.updateFileList('root', 'root', true);
        }
    };

    function compare(a,b) {
        if (a.type > b.type)
            return -1;
        if (a.type < b.type)
            return 1;
        return 0;
    }

    function getKey(arr,val) {
        for (var i=0; i<arr.length; i++)
            if (arr[i] === val)
                return i;
        return 0;
    }

    function checkBreadCrumb(){
        var element = document.getElementById('breadCrumb');
        var lis = $("ul.nav-breadcrumb li");
        var i = 0;
        if (element.offsetWidth > 700) {
            for(i = 0; i < lis.length; i++){
                if(i > 1){
                    lis[i].childNodes[0].innerHTML = '...';
                }
            }
        }else{
            for(i = 0; i < lis.length; i++){
                if(i > 1){
                    if(lis[i].childNodes[0].innerHTML == '...'){
                        if($scope.crumb[i] != undefined){
                            lis[i].childNodes[0].innerHTML = $scope.crumb[i];
                        }else{
                            lis[i].remove();
                        }
                    }
                }
            }
        }
    }

    function checkIfAllowed(fileName){
        var result;
        if(fileName.length >= 1){
            var fileAttrs = fileName.split('.');
            if($scope.notAllowedFileAttributes.length > 0){
                result = true;
                $scope.notAllowedFileAttributes.forEach(function(value, key){
                    if(value == fileAttrs[(fileAttrs.length-1)]){
                        result = false;
                    }
                });
            }else if($scope.allowedFileAttributes.length > 0){
                result = false;
                $scope.allowedFileAttributes.forEach(function(value, key){
                    if(value == fileAttrs[(fileAttrs.length-1)]){
                        result = true;
                    }
                });
            }else{
                result = true;
            }
        }
        return result;
    }

    $scope.uploadFiles = function(files) {
        blockUI.stop();
        if(files != undefined){
            $('#UploadCancelBtn').show();
            angular.forEach(files, function(file, key) {
                var fileUploadLimitSize = $('.file-limit-size').html();
                if(checkIfAllowed(file.name)){
                    if(!isNaN(fileUploadLimitSize) && fileUploadLimitSize.length > 0){
                        if(file.size <= (fileUploadLimitSize*1000*1000)){
                            $scope.currentFileUploadList.push(file);
                        }else{
                            toastr.error('File Size greater than '+fileUploadLimitSize+' MB are not allowed', 'Fail!!!', {allowHtml: true});
                        }
                    }else{
                        $scope.currentFileUploadList.push(file);
                    }
                    $scope.$apply();
                }else{
                    if($scope.notAllowedFileAttributes.length > 0){
                        toastr.error('Extensions '+$scope.notAllowedFileAttributes.join(', ')+' not allowed', 'Fail!!!', {allowHtml: true});
                    }else{
                        toastr.error('Only Extensions, '+$scope.allowedFileAttributes.join(', ')+' are allowed', 'Fail!!!', {allowHtml: true});
                    }
                }
            });
        }
        if($scope.currentFileUploadList.length >= 1){
            angular.forEach(files, function(file, key) {
                $scope.currentFileUploadList[key].progress = 0;
                if (file && !file.$error) {

                    if(isSpecialChar(file.name)){

                        $scope.currentFileUploadList[key].status = ' - Reading the file....';

                        fileMd5Service.md5(file).progress(function(stats) {

                            $scope.currentFileUploadList[key].progress = parseInt((stats.loaded / stats.total) * 100);
                        }).success(function(md5){

                            if($scope.currentFileUploadList[key].status != ' - Upload Canceled'){
                                $scope.currentFileUploadList[key].status = ' - Uploading the File....';
                                var headers = {
                                    'token'                 : $('.uploadToken').html(),
                                    'userName'              : $('.uploadUserName').html(),
                                    'Content-disposition'   : 'inline;filename='+file.name,
                                    'is-exists'             : 'false',
                                    'file-path'             : $scope.crumbString.slice(0,-1),
                                    'file-name'             : file.name,
                                    'file-size'             : file.size,
                                    'is-folder'             : 'false',
                                    'is-base-folder'        : 'false',
                                    'fileMD5'               : md5,
                                    'gatewayName'           : $('.blukryptIP').html(),
                                    'modified'              : file.lastModified
                                };

                                //in Case Cors exception occurs please ask the backend guys to enable cros for this api request.

                                file.upload = Upload.upload({
                                    url: $('.protocol').html()+$scope.bestBlukrypt+$('.blukryptURL').html()+$('.cloudNameConstant').html()+'/sync/portal/upload/file/',
                                    headers: headers,
                                    method: 'POST',
                                    file: file
                                });

                                $scope.currentFileUploadList[key].upload = file.upload;
                                file.upload.then(function (response) {

                                    $timeout(function () {
                                        file.result = response;
                                        if(response.status == 200){
                                            $('.status').hide();
                                            toastr.success(response.data.bluKryptElement.fileName+' has been uploaded successfully', 'Successful!!!', {allowHtml: true});
                                            $scope.currentFileUploadList.forEach(function(value, key){
                                                if(value.name.toString() == response.data.bluKryptElement.fileName.toString()){
                                                    $scope.currentFileUploadList[key].status = ' - Upload Completed';
                                                }
                                            });
                                            if(checkFilesStatus() == true){
                                                $scope.currentFileUploadList = [];
                                                $('#uploadFiles').modal('hide');
                                                blockUI.start();
                                                checkForFilesCopiedOrCut();
                                                $scope.updateFileList('root', 'root', true, true);
                                            }
                                        }else{
                                            toastr.error('Could not upload the file, '+response.data.bluKryptElement.fileName+', '+response.status, 'Fail!!!', {allowHtml: true});
                                        }
                                    });
                                }, function (response) {
                                    if(response.status == 448){
                                        toastr.error('File, '+file.name+' already Exists', 'Fail!!!', {allowHtml: true});
                                    }else if(response.status != 0){
                                        toastr.error('Could not upload the file, '+file.name+', Error Code: '+response.status, 'Fail!!!', {allowHtml: true});
                                    }else{
                                        var headers = {
                                            'token'                 : $('.uploadToken').html(),
                                            'userName'              : $('.uploadUserName').html(),
                                            'is-exists'             : 'false',
                                            'file-path'             : $scope.crumbString.slice(0,-1),
                                            'file-name'             : file.name,
                                            'file-size'             : file.size,
                                            'is-folder'             : 'false',
                                            'is-base-folder'        : 'false',
                                            'fileMD5'               : md5,
                                            'modified'              : file.lastModified
                                        };

                                        //in Case Cors exception occurs please ask the backend guys to enable cros for this api request.

                                        $.ajax({
                                            url: $('.protocol').html()+$scope.bestBlukrypt+$('.blukryptURL').html()+$('.cloudNameConstant').html()+'/sync/portal/upload/cancel/',
                                            headers: headers,
                                            method: 'POST'
                                        }).done(function(data){

                                            toastr.error('File, '+file.name+', upload has been cancelled', 'Fail!!!', {allowHtml: true});

                                        }).error(function(data){
                                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                                            if(data.status == 424){
                                                setTimeout(function(){
                                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                                                }, 3000);
                                            }else if(data.status == 503){
                                                setTimeout(function(){
                                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                                                }, 3000);
                                            }
                                        });
                                    }

                                    $scope.currentFileUploadList.forEach(function(value, key){
                                        if(value.name.toString() == file.name.toString()){
                                            $scope.currentFileUploadList.splice(key, 1);
                                        }
                                    });

                                });

                                file.upload.progress(function (evt) {
                                    if($scope.currentFileUploadList[key] != undefined){
                                        file.progress = Math.min(100, parseInt(100.0 *
                                            evt.loaded / evt.total));
                                        $scope.currentFileUploadList[key].progress = file.progress;
                                    }
                                });
                            }else{
                                if(checkFilesStatusForSingleCancel() == true){
                                    $scope.currentFileUploadList = [];
                                    $('#uploadFiles').modal('hide');
                                    blockUI.start();
                                    checkForFilesCopiedOrCut();
                                    $scope.updateFileList('root', 'root', true, true);
                                }
                            }
                        });
                    }
                }
            });
        }
    };

    function checkFilesStatusForSingleCancel(){
        var result = true;
        $scope.currentFileUploadList.forEach(function(value, key){
            if(value.status != ' - Upload Completed' && value.status != ' - Upload Canceled'){
                result = false;
            }
        });
        return result;
    }

    function checkFilesStatus(){
        var result = true;
        $scope.currentFileUploadList.forEach(function(value, key){
            if(value.status != ' - Upload Completed'){
                result = false;
            }
        });
        return result;
    }

    $scope.cancelUploadAll = function(){
        angular.forEach($scope.currentFileUploadList, function(file, key) {
            if(file.status == ' - Reading the file....') {
                $scope.currentFileUploadList[key].status = ' - Upload Canceled';
            }else{
                file.upload.abort();
            }
        });
        $('#uploadFiles').modal('hide');
        blockUI.start();
        checkForFilesCopiedOrCut();
        $scope.updateFileList('root', 'root', true, true);
    };

    $scope.cancelSingleFileUpload = function(key){
        if($scope.currentFileUploadList[key].status == ' - Reading the file....'){
            $scope.currentFileUploadList[key].status = ' - Upload Canceled';
        }else{
            $scope.currentFileUploadList[key].upload.abort();
        }
        if(checkFilesStatusForSingleCancel() == true){
            $('#UploadCancelBtn').hide();
        }
    };

    $scope.selectionStart = function(selected){
        $('.contextMenu').hide();
    };

    $scope.selectionStop = function(selected){
        cleanSelection();
        disableButtons();
        $('.deleteBtn').show();
        $scope.selected = selected;
        selected.forEach(function(value){
            if(value.type == 'Mini Cloud'){
                $scope.selectedMiniClouds.push(value);
            }
            if(value.type == 'Folder'){
                $scope.selectedFolders.push(value);
            }
            if(value.type == 'File'){
                $scope.selectedFiles.push(value);
            }
        });
        if(selected.length > 0){
            enableButtons();
        }
    };

    function cleanSelection(){
        $scope.selectedMiniClouds = [];
        $scope.selectedFolders = [];
        $scope.selectedFiles = [];
    }

    function disableButtons(){
        $('.viewAction').hide();
        $('.deleteAction').hide();
        $('.shareAction').hide();
        $('.downloadAction').hide();
        $('.versionsAction').hide();
        $('.renameAction').hide();
        $('.cutAction').hide();
        $('.copyAction').hide();
    }

    function enableButtons(){

        if($scope.selectedFiles.length > 1 && $scope.selectedFolders.length <= 0  && $scope.selectedMiniClouds.length<= 0 ){
            if(checkIfMovedToCloud($scope.selected)){
                $('.versionsAction').hide();
                $('.renameAction').hide();
                $('.cutAction').show();
                $('.copyAction').show();
                if($('.disableCutCopy').html() == 'true'){
                    loadCutCopyPasteEnv();
                }
            }
            $('.viewAction').hide();
            $('.deleteAction').show();
            $('.shareAction').hide();
            $('.downloadAction').hide();
        }

        if($scope.selectedFiles.length == 1 && $scope.selectedFolders.length <= 0  && $scope.selectedMiniClouds.length<= 0 ){
            if(checkIfMovedToCloud($scope.selected)) {
                $('.versionsAction').show();
                $('.renameAction').show();
                $('.cutAction').show();
                $('.copyAction').show();
                if($('.disableCutCopy').html() == 'true'){
                    loadCutCopyPasteEnv();
                }else{
                    $('.cutAction').hide();
                    $('.copyAction').hide();
                }
            }
            $('.viewAction').show();
            $('.deleteAction').show();
            $('.shareAction').show();
            $('.downloadAction').show();
        }

        if($scope.selectedFolders.length == 1 && $scope.selectedFiles.length <= 0 && $scope.selectedMiniClouds.length <= 0){
            $('.deleteAction').show();
            $('.renameAction').show();
            if($('.disableCutCopy').html() == 'true'){
                loadCutCopyPasteEnv();
            }
            $('.viewAction').hide();
            $('.shareAction').hide();
            $('.downloadAction').hide();
            $('.versionsAction').hide();
        }

        if($scope.selectedFolders.length > 0 && $scope.selectedFiles.length > 0 && $scope.selectedMiniClouds.length <= 0){
            if(checkIfMovedToCloud($scope.selected)) {
                if($('.disableCutCopy').html() == 'true'){
                    loadCutCopyPasteEnv();
                }
                $('.renameAction').hide();
                $('.versionsAction').hide();
            }
            $('.deleteAction').show();
            $('.viewAction').hide();
            $('.shareAction').hide();
            $('.downloadAction').hide();
        }

        if($scope.selectedFolders.length > 1 && $scope.selectedFiles.length <= 0 && $scope.selectedMiniClouds.length <= 0){
            $('.deleteAction').show();
            if($('.disableCutCopy').html() == 'true'){
                loadCutCopyPasteEnv();
            }
            $('.renameAction').hide();
            $('.viewAction').hide();
            $('.shareAction').hide();
            $('.downloadAction').hide();
            $('.versionsAction').hide();
        }

        if($scope.selectedMiniClouds.length > 0){
            $('.deleteAction').show();
            $('.viewAction').hide();
            $('.shareAction').hide();
            $('.downloadAction').hide();
            $('.versionsAction').hide();
            $('.renameAction').hide();
            $('.cutAction').hide();
            $('.copyAction').hide();
        }
    }

    function loadCutCopyPasteEnv(){
        if($scope.selectedFilesForCopyCut.length > 0){
            $('.cutAction').hide();
            $('.copyAction').hide();
            $('.pasteAction').show();
        }else{
            $('.cutAction').show();
            $('.copyAction').show();
            $('.pasteAction').hide();
        }
    }

    function cleanUrl(str) {
        if(str.substr(-1) === '/') {
            return str.substr(0, str.length - 1);
        }
        return str;
    }

    $scope.menuOptions = [
        ['Open', function ($itemScope) {
            $scope.updateFileList($scope.crumbString+$scope.selected[0].fileName, $scope.selected[0].fileName, true);
        }, function(){
            if($scope.selected.length == 1){
                if($scope.selectedFolders.length == 1 || $scope.selectedMiniClouds.length == 1){
                    return true;
                }
            }
        }],
        ['View', function ($itemScope) {
            $scope.view();
        }, function(){
            if($scope.selected.length > 0){
                if($scope.selectedFiles.length == 1 && $scope.selectedFolders.length<= 0  && $scope.selectedMiniClouds.length<= 0 ){
                    return true;
                }
            }
        }],
        ['Versions', function ($itemScope) {
            $scope.versions();
        }, function(){
            if($scope.selected.length > 0){
                if($scope.selectedFiles.length == 1 && $scope.selectedFolders.length<= 0  && $scope.selectedMiniClouds.length<= 0 ){
                    if(checkIfMovedToCloud($scope.selectedFiles)){
                        return true;
                    }
                }
            }
        }],
        ['Share', function ($itemScope) {
            $scope.share();
        }, function(){
            if($('.shareType').html() == 'share') {
                if ($scope.selected.length > 0) {
                    if ($scope.selectedFiles.length == 1 && $scope.selectedFolders.length <= 0 && $scope.selectedMiniClouds.length <= 0) {
                        if($scope.userAssignedPolicy.shareEnabled == '1'){
                            return true;
                        }
                    }
                }
            }
        }],
        ['Share with', function ($itemScope) {
            $scope.shareWith();
        }, function(){
            if($('.shareType').html() == 'shareWith'){
                if($scope.selected.length > 0){
                    if($scope.selectedFiles.length == 1 && $scope.selectedFolders.length<= 0  && $scope.selectedMiniClouds.length<= 0 ){
                        if($scope.userAssignedPolicy.shareEnabled == '1'){
                            return true;
                        }
                    }
                }
            }
        }],
        ['Download', function ($itemScope) {
            $scope.download('');
        }, function(){
            if($scope.selected.length > 0){
                if($scope.selectedFiles.length == 1 && $scope.selectedFolders.length<= 0  && $scope.selectedMiniClouds.length<= 0 ){
                    return true;
                }
            }
        }],
        ['Delete', function ($itemScope) {
            $scope.delete();
        }, function(){
            if($scope.selected.length > 0){
                return true;
            }
        }],
        ['Rename', function ($itemScope) {
            $scope.rename();
        }, function(){
            if($scope.selected.length == 1){
                if(($scope.selectedFiles.length == 1 || $scope.selectedFolders.length == 1) && $scope.selectedMiniClouds.length <= 0 ){
                    if(checkIfMovedToCloud($scope.selectedFiles)){
                        return true;
                    }
                }
            }
        }],
        ['Cut', function ($itemScope) {
            $scope.cut();
        }, function(){
            if($scope.selected.length > 0){
                if(($scope.copiedItems.length <= 0 || $scope.cutItems.length <= 0) && $scope.selectedMiniClouds.length <= 0 ){
                    if(checkIfMovedToCloud($scope.selectedFiles)){
                        if($('.disableCutCopy').html() == 'true'){
                            return true;
                        }
                    }
                }
            }
        }],
        ['Copy', function ($itemScope) {
            $scope.copy();
        }, function(){
            if($scope.selected.length > 0){
                if(($scope.copiedItems.length <= 0 || $scope.cutItems.length <= 0) && $scope.selectedMiniClouds.length <= 0 ){
                    if(checkIfMovedToCloud($scope.selectedFiles)) {
                        if($('.disableCutCopy').html() == 'true'){
                            return true;
                        }
                    }
                }
            }
        }],
        ['Paste', function ($itemScope) {
            $scope.paste();
        }, function ($itemScope) {
            if($scope.selectedFilesForCopyCut.length > 0){
                if(checkIfMovedToCloud($scope.selectedFiles)) {
                    return true;
                }
            }
        }],
        ['Nothing Selected', function () {

        }, function(){
            if($scope.selected.length < 1){
                return ($scope.selectedFilesForCopyCut <= 0);
            }
        }]
    ];

    function checkIfMovedToCloud(files){
        var result = true;
        files.forEach(function(value, key){
            if(value.storagePlace.length <= 0){
                result = false;
            }
        });
        return result;
    }

    $scope.view = function(){
        $('#paraviewContainer .modal-title').html('Loading ...');
        $('.content').html('');
        $('.content').hide();
        $('.pageContainer').hide();
        $('.excelContainer').hide();
        $('.pdfContainer').hide();
        $('.imageViewer').hide();
        $('.paraviewLoading').show();

        $('#paraviewContainer').modal('show');
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/view',
            data: {fileName: $scope.selectedFiles[0].fileName, blukryptIp: $scope.selectedFiles[0].gatewayName, path: $scope.crumbString, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
            if(jData.result == 'fail'){
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                $('#paraviewContainer').modal('hide');
                return;
            }

            if(jData.type == 'image') {

                $('#paraviewContainer .modal-title').html($scope.selectedFiles[0].fileName);
                $('.imageViewer').html(jData.html);
                $('.imageViewer').show();
                $('.paraviewLoading').hide();

            }else if(jData.type == 'pdf') {

                $('#paraviewContainer .modal-title').html($scope.selectedFiles[0].fileName);
                $('.paraviewLoading').hide();
                $('.pdfContainer').html(jData.html);
                $('.pdfContainer').show();

            }else if(jData.type == 'odt') {

                $('#paraviewContainer .modal-title').html($scope.selectedFiles[0].fileName);
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                viewDoc(jData, 300, 100);

            }else if(jData.type == 'text') {

                $('#paraviewContainer .modal-title').html($scope.selectedFiles[0].fileName);
                $('.content').html(jData.html);
                $('.paraviewLoading').hide();
                $('.content').show();

            }else if(jData.type == 'excel') {

                $('#paraviewContainer .modal-title').html($scope.selectedFiles[0].fileName);
                $('.excelContainer').show();
                $('.paraviewLoading').hide();
                viewExcel(jData);

            }else{

                $('#paraviewContainer .modal-title').html($scope.selectedFiles[0].fileName);
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                viewDoc(jData, 400, 100);

            }

        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $('#paraviewContainer').on('hidden.bs.modal', function () {
        $('.page').remove();
        $('.pageContent').remove();
        $('.pageContainer').html('');
    });

    function addAPage(jsonData, pageNumber){
        pageNumber = pageNumber+1;
        $('.pageContainer').append('<div id="page'+pageNumber+'" class="page"></div>');
        $('.page').css(jsonData.pageStyle);
        $('#page'+pageNumber).append('<div class="pageContent"><div class="pageNumber"> Page '+pageNumber+'<br/></div></div>');
        $('.pageContent').css(jsonData.contentStyle);
        return pageNumber;
    }
    function checkHeight(contentHeight, pageNumber) {
        var div = '#page'+pageNumber+' .pageContent';
        var element = document.querySelector(div);
        var _hasScrollBar = false;
        if( (parseInt($(div).outerHeight(true) ) < parseInt(contentHeight))){
            _hasScrollBar = true;
        }
        return _hasScrollBar;
    }

    function viewDoc(jsonData, defaultHeight, minusDefaultSize){
        var pageNumber = 0;
        var pageHeight = parseInt(jsonData.pageStyle.height.replace("px", ""));
        var contentBottom = parseInt(jsonData.contentStyle.bottom.replace("px", ""));
        jsonData.html.forEach(function(row){
            var contentHeight = pageHeight - (contentBottom+defaultHeight);
            if ($('.page').length <= 0 ) {
                pageNumber = addAPage(jsonData, pageNumber);
            }
            if(checkHeight(contentHeight, pageNumber) == false) {
                pageNumber = addAPage(jsonData, pageNumber);
                defaultHeight = defaultHeight - minusDefaultSize;
            }
            $('#page'+pageNumber+' .pageContent').append(row);
        })

    }

    function viewExcel(jsonData){
        var html = '';
        var links = '';
        var htmlData = '';
        jsonData.html.forEach(function(row, key){
            var active = '';
            if(key == 0){
                active = 'active';
            }
            links += '<li role="presentation" class="'+active+'"><a href="#'+row.id+'" id="home-tab" role="tab" data-toggle="tab" aria-controls="home" aria-expanded="true">'+row.sheetName+'</a></li>';
            htmlData += '<div role="tabpanel" class="tab-pane fade '+active+' in" id="'+row.id+'" aria-labelledby="home-tab">'+row.html+'</div>';
        });
        html += '<div class="panel" style="background-color: #fff; padding: 20px 20px; overflow: auto; height: 550px">'+
            '<div class="bs-example bs-example-tabs" role="tabpanel" data-example-id="togglable-tabs">'+
            '<ul id="myTab" class="nav nav-tabs" role="tablist">'+links+'</ul>'+
            '<div id="myTabContent" class="tab-content">'
            +htmlData+
            '</div>'+
            '</div>'+
            '</div>';
        $('.excelContainer').html(html);
    }

    $scope.versions = function(){
        $('.syncFileVersions').modal('show');
        $('.fileVersionsTable').show();
        $('.loading').html('Loading ...');
        if($scope.selectedFiles.length == 1){
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/files/versions',
                data: {csrf_token: $('.csrf_token').html(), fileName: $scope.selectedFiles[0].fileName, filePath: $scope.crumbString},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(jData.fileVersions.length > 0){
                        $scope.fileVersions = jData.fileVersions;
                        $scope.$apply();
                        $('.loading').hide();
                    }else{
                        $scope.$apply();
                        toastr.error('There is <b>no versions</b> that has been saved for the selected file', 'Fail!!!', {allowHtml: true});
                    }
                }else{
                    $scope.$apply();
                    toastr.error('There is <b>no versions</b> that has been saved for the selected file', 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.revisionCommentBox = function(index){
        $('#commentsModal').modal('show');
        $('#fileRevisionComments').val($scope.fileVersions[index].comment);
        $scope.selectedRevisionIndex = index;
    };

    $scope.saveComment = function(){
        var fileRevisionComments = $('#fileRevisionComments').val();

        var html = $('.saveComments').html();
        $('.saveComments').attr('disabled','disabled');
        $('.saveComments').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();

        if(fileRevisionComments.length > 0){
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/files/versions/saveComments',
                data: {csrf_token: $('.csrf_token').html(), comments: fileRevisionComments, revisionId: $scope.fileVersions[$scope.selectedRevisionIndex].revisionId},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('#commentsModal').modal('hide');
                    $scope.fileVersions[$scope.selectedRevisionIndex].comment = fileRevisionComments;
                    $scope.$apply();
                    $('.saveComments').html('Saved <i class="fa fa-check"></i>').animate();
                    setTimeout(function(){
                        $('.saveComments').html(html);
                        $('.saveComments').removeAttr('disabled');
                    }, 1000);
                }else{
                    $('.saveComments').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        $('.saveComments').html(html);
                        $('.saveComments').removeAttr('disabled');
                    }, 1000);
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.download = function(index, revisionCheck){

        var revisionId = (revisionCheck == true) ? $scope.fileVersions[index].revisionId : $scope.selected[0].fileRevisionId;
        if($scope.selected[0].gatewayName > 0){
            window.open($('.protocol').html()+$scope.selected[0].gatewayName+$('.blukryptURL').html()+$('.cloudNameConstant').html()+'/sync/portal/download/file/?fileName='+encodeURIComponent($scope.selected[0].fileName)+'&filePath='+encodeURIComponent($scope.selected[0].filePath)+'&token='+$('.uploadToken').html()+'&userName='+$scope.selected[0].fileUser+'&syncRevisionId='+revisionId+'&path='+encodeURIComponent($scope.crumbString)+encodeURIComponent($scope.selected[0].fileName), '_self');
        }else{
            window.open($('.protocol').html()+$scope.bestBlukrypt+$('.blukryptURL').html()+$('.cloudNameConstant').html()+'/sync/portal/download/file/?fileName='+encodeURIComponent($scope.selected[0].fileName)+'&filePath='+encodeURIComponent($scope.selected[0].filePath)+'&token='+$('.uploadToken').html()+'&userName='+$scope.selected[0].fileUser+'&syncRevisionId='+revisionId+'&path='+encodeURIComponent($scope.crumbString)+encodeURIComponent($scope.selected[0].fileName), '_self');
        }

    };

    //$scope.download = function(index, revisionCheck){
    //    var revisionId = '';
    //    if(revisionCheck == true){
    //        revisionId = $scope.fileVersions[index].revisionId;
    //    }
    //    window.location.href = $scope.BASE_FOLDER+'/sync/file/download?path='+encodeURIComponent($scope.crumbString)+'&fileName='+encodeURIComponent($scope.selectedFiles[0].fileName)+'&syncRevisionId='+revisionId;
    //};

    $scope.selectFileForDelete = function(fileName){
        $scope.selectedFiles = [];
        $scope.items.forEach(function(value, key){
            if(value.fileName == fileName){
                $scope.selectedFiles.push($scope.items[key]);
            }
        });
        $scope.delete();
    };

    $scope.selectFileForDownload = function(fileName){
        $scope.selected = [];
        $scope.items.forEach(function(value, key){
            if(value.fileName == fileName){
                $scope.selected.push($scope.items[key]);
            }
        });
        console.log($scope.selectedFiles);
        $scope.download('', false);
    };

    $scope.selectFileForView = function(fileName){
        $scope.selectedFiles = [];
        $scope.items.forEach(function(value, key){
            if(value.fileName == fileName){
                $scope.selectedFiles.push($scope.items[key]);
            }
        });
        $scope.view();
    };

    $scope.delete = function(){
        var message = 'Are you sure you want to delete the selected Items?';
        if($scope.selectedFiles.length > 0 && $scope.selectedFiles.length == 1 && $scope.selectedFolders.length <= 0 && $scope.selectedMiniClouds.length <= 0) {
            message = 'Are you sure you want to delete the selected File?';
        } else  if($scope.selectedFiles.length > 0 && $scope.selectedFolders.length <= 0 && $scope.selectedMiniClouds.length <= 0){
                message = 'Are you sure you want to delete the selected Files?';
        }else if($scope.selectedFiles.length <= 0 && $scope.selectedFolders.length > 0 && $scope.selectedMiniClouds.length <= 0){
            message = 'Deleting folder will remove all your files inside the folder. It may take some time depending upon the size of your folder. Do you really want to delete this folder?';
        }else if($scope.selectedFiles.length <= 0 && $scope.selectedFolders.length <= 0 && $scope.selectedMiniClouds.length > 0){
            message = 'Deleting MiniCloud will remove all your files inside the folder. It may take some time depending upon the size of your MiniCloud. Do you really want to delete the selected MiniCloud?';
        }else if($scope.selectedFiles.length <= 0 && $scope.selectedFolders.length > 0 && $scope.selectedMiniClouds.length > 0){
            message = 'Deleting folder and MiniCloud will remove all your files inside them. It may take some time depending upon the size of your MiniCloud and folder. Do you really want to delete the selected MiniCloud and folder?';
        }else if($scope.selectedFiles.length > 0 && $scope.selectedFolders.length > 0 && $scope.selectedMiniClouds.length > 0){
            message = 'Deleting folder and MiniCloud will remove all your files inside them. It may take some time depending upon the size of your MiniCloud and folder. Do you really want to delete the selected files, folder and MiniCloud?';
        }else if($scope.selectedFiles.length > 0 && $scope.selectedFolders.length > 0 && $scope.selectedMiniClouds.length <= 0){
            message = 'Deleting folder will remove all your files inside them. It may take some time depending upon the size of your folder. Do you really want to delete the selected files and folder?';
        }
        $('.deleteConfirmMessage').html(message);
        $('#deleteConfirm').modal('show');
    };

    $scope.deletedConfirmed = function(){
        $('#deleteConfirm').modal('hide');
        if($scope.selectedFiles.length > 0){
            deleteFiles();
        }
        if($scope.selectedFolders.length > 0){
            deleteFolders();
        }
        if($scope.selectedMiniClouds.length > 0){
            $scope.selectedMiniClouds.forEach(function(value, key) {
                deleteMiniCloud(value.fileName);
            });
        }
    };

    function deleteFiles(){
        var pathsToDelete = [];
        $scope.selectedFiles.forEach(function(value, key){
            pathsToDelete.push(getPath(value));
        });
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/delete',
            type: 'POST',
            data: { pathsToDelete: pathsToDelete, csrf_token: $('.csrf_token').html(), type: 'files' }
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.updateFileList('root', 'root', true, true);
                if($scope.items.length <= 0){
                    $('.status').show();
                }
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    }

    function deleteFolders(){
        var pathsToDelete = [];
        $scope.selectedFolders.forEach(function(value, key){
            pathsToDelete.push(getPath(value));
        });
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/delete',
            type: 'POST',
            data: { pathsToDelete: pathsToDelete, csrf_token: $('.csrf_token').html(), type: 'folder' }
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.updateFileList('root', 'root', true, true);
                if($scope.items.length <= 0){
                    $('.status').show();
                }
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    }

    $scope.deleteMiniCloudByAdmin = function(miniCloudName, type){
        deleteMiniCloud(miniCloudName, type);
    };

    function deleteMiniCloud(miniCloudName, from){
        var currentDeleteBtn = $('.deleteMiniCloudBtn'+md5.createHash(miniCloudName));
        var html = currentDeleteBtn.html();
        currentDeleteBtn.attr('disabled','disabled');
        currentDeleteBtn.html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/minicloud/delete',
            type: 'POST',
            data: { miniCloudName: miniCloudName, csrf_token: $('.csrf_token').html() }
        }).done(function(data){
            currentDeleteBtn.removeAttr('disabled','disabled');
            currentDeleteBtn.html(html);
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.updateFileList('root', 'root', true, true);
                if($scope.items.length <= 0){
                    $('.status').show();
                }
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                if(from == 'admin'){
                    setTimeout(function(){
                        location.reload();
                    }, 1000);
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    }

    function getPath(value){
        return value.filePath+'/'+value.fileName;
    }

    $scope.rename = function(){
        $('#rename').modal('show');
        if($scope.selectedFiles.length == 1){
            $('#changedName').val($scope.selectedFiles[0].fileName);
        }else if($scope.selectedFolders.length == 1) {
            $('#changedName').val($scope.selectedFolders[0].fileName);
        }
    };

    $scope.saveRename = function(){
        var changedName = $('#changedName').val();
        var currentFileName = '';

        if(isSpecialChar(changedName) == false){
            $('.renameError').html('<br><span class="text-danger">Special characters like ( * \\ | : \" < > ? / ) are not allowed.</span>');
            $('.renameError').show();
            return;
        }

        if($scope.selectedFiles.length == 1){
            currentFileName = $scope.selectedFiles[0].fileName;
        }else if($scope.selectedFolders.length == 1) {
            currentFileName = $scope.selectedFolders[0].fileName;
        }else{
            toastr.error('No File or Folder is selected to change the name', 'Fail!!!', {allowHtml: true});
            return;
        }

        var html = $('.saveRename').html();
        $('.saveRename').attr('disabled','disabled');
        $('.saveRename').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();

        if(changedName.length > 0){
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/files/saveRename',
                data: {csrf_token: $('.csrf_token').html(), changedName: changedName, path: $scope.crumbString, fileName: currentFileName },
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('#rename').modal('hide');
                    $scope.items.forEach(function(value, key){
                        if(value.fileName == currentFileName){
                            $scope.items[key].fileName = changedName;
                        }
                    });
                    $scope.$apply();
                    $('.saveRename').html('Saved <i class="fa fa-check"></i>').animate();
                    setTimeout(function(){
                        $('.saveRename').html(html);
                        $('.saveRename').removeAttr('disabled');
                    }, 1000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                    $scope.$apply();
                    $('.saveRename').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        $('.saveRename').html(html);
                        $('.saveRename').removeAttr('disabled');
                    }, 1000);
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.selectFileForShare = function(fileName, shareType){
        $scope.selectedFiles = [];
        $scope.items.forEach(function(value, key){
            if(value.fileName == fileName){
                $scope.selectedFiles.push($scope.items[key]);
            }
        });
        switch (shareType){
            case('shareWith'):
                $scope.shareWith();
                break;
            case('share'):
                $scope.share();
                break;
        }
    };

    $scope.getUserPolicy = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/sync/user/policy',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.userAssignedPolicy = jData.policy;
		if(jData.policy.twoWayShareEnabled == '1'){
                    $('#twoWay').show();
                    $('#twoWayNormal').show();
                    $('#shareWithHome').hide();
                    $('#shareHome').hide();
                    $('#home').removeClass('active');
                    $('#home').removeClass('in');
                    $('#shareWithSimple').addClass('active');
                    $('#shareWithSimple').addClass('in');
                    $('#shareWithHome').removeClass('active');
                    $('#twoWay').addClass('active');
                    
                    $('#home1').removeClass('active');
                    $('#home1').removeClass('in');
                    $('#shareWithNormal').addClass('active');
                    $('#shareWithNormal').addClass('in');

                  }
                  else{
                    $('#twoWay').hide();
                    $('#twoWayNormal').hide();
                    $('#shareWithHome').show();
                    $('#shareHome').show();
                    $('#home').addClass('active');
                    $('#home').addClass('in');
                    $('#shareWithSimple').removeClass('active');
                    $('#shareWithSimple').removeClass('in');
                    $('#shareWithHome').addClass('active');
                    $('#twoWay').removeClass('active');
                    
                    $('#home1').addClass('active');
                    $('#home1').addClass('in');
                    $('#shareWithNormal').removeClass('active');
                    $('#shareWithNormal').removeClass('in');
                     
                  }
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.share = function(){
        $('#share').modal('show');
        $('.shareLoading').show();
        $('.shareBody').hide();
        $('.shareLinkBlock').hide();
        $('.shareBtn').hide();
        $('.unShareBtn').hide();
        $('.updateShareDetails').hide();
        var enableView = document.querySelector('.enableView');
        var enableDownload = document.querySelector('.enableDownload');
        var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');

        var data = {
            fileName : $scope.selectedFiles[0].fileName,
            filePath : $scope.selectedFiles[0].filePath
        };
        console.log(data);
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/isShareCheck',
            type: 'POST',
            data: data
        }).done(function(data){
            console.log(data);
            $('.shareLoading').hide();
            $('.shareBody').show();
            var jData = JSON.parse(data);
            console.log(jData);
            $scope.sharedFileDetails = jData.data;
            if(jData.result == true){
                if(jData.data.passwordProtected == true){
                    if(sharePasswordSwitch.checked == false){
                        $('.sharePasswordSwitch').click();
                    }
                }else{
                    if(sharePasswordSwitch.checked == true){
                        $('.sharePasswordSwitch').click();
                    }
                }

                if(jData.data.download == true){
                    if(enableDownload.checked == false){
                        $('.enableDownload').click()
                    }
                }else{
                    if(enableDownload.checked == true){
                        $('.enableDownload').click()
                    }
                }

                if(jData.data.view == true){
                    if(enableView.checked == false){
                        $('.enableView').click()
                    }
                }else{
                    if(enableView.checked == true){
                        $('.enableView').click()
                    }
                }

                if(jData.data.validUntil != null){
                    $('.removeValidUntil').show();
                    $('#till').val(jData.data.validUntil);
                }else{
                    $('.removeValidUntil').hide();
                }

                $('.shareLinkBlock').show();
                $('.shareLink').html(jData.link);
                $('.shareBtn').hide();
                $('.unShareBtn').show();
                $('.updateShareDetails').show();
            }else{
                if(sharePasswordSwitch.checked == true){
                    if($scope.userAssignedPolicy.highSecureShareEnabled != "1"){
                        $('.sharePasswordSwitch').click();
                    }
                }
                $('.shareLoading').hide();
                $('.shareBody').show();
                $('.shareLinkBlock').hide();
                $('.shareBtn').show();
                $('.unShareBtn').hide();
                $('.updateShareDetails').hide();
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.shareWith = function(){
        $('#shareWith').modal('show');
        $('.shareLoading').show();
        $('.shareWithBodyStatus').hide();
        $('.shareBody').hide();
        $('.shareLinkBlock').hide();
        $('.shareBtn').hide();
        $('.unShareBtn').hide();
        $('.updateShareDetails').hide();
        var enableDownload = document.querySelector('.shareWithEnableDownload');
        var enableView = document.querySelector('.shareWithEnableView');

        var data = {
            fileName : $scope.selectedFiles[0].fileName,
            filePath : $scope.selectedFiles[0].filePath
        };
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/isShareCheck',
            type: 'POST',
            data: data
        }).done(function(data){
            $('.shareLoading').hide();
            $('.shareBody').show();
            var jData = JSON.parse(data);
            $scope.sharedFileDetails = jData.data;
            if(jData.result == true){

                if(jData.data.download == true){
                    if(enableDownload.checked == false){
                        $('.enableDownload').click()
                    }
                }else{
                    if(enableDownload.checked == true){
                        $('.enableDownload').click()
                    }
                }

                if(jData.data.view == true){
                    if(enableView.checked == false){
                        $('.enableView').click()
                    }
                }else{
                    if(enableView.checked == true){
                        $('.enableView').click()
                    }
                }

                if(jData.data.validUntil != null){
                    $('.removeValidUntil').show();
                    $('#till').val(jData.data.validUntil);
                }else{
                    $('.removeValidUntil').hide();
                }

                if(jData.data.userShareList.length > 0){
                    $('.listOfUsers').val(jData.data.userShareList.join(', '));
                }

                $('.shareWithBody').show();
                $('.shareWithBodyStatus').hide();
                $('.updateShareWithDetails').hide();
                $('.shareLoading').hide();
                $('.shareBody').show();
                $('.shareBtn').show();
                $('.unShareBtn').show();
                $('.updateShareDetails').hide();
            }else{
                $('#till').val('');
                $('.listOfUsers').val('');
                $('.shareWithSubject').val('');
                $('.shareWithMessage').val('');
                $('.shareWithBody').show();
                $('.shareWithBodyStatus').hide();
                $('.updateShareWithDetails').hide();
                $('.shareLoading').hide();
                $('.shareBody').show();
                $('.shareBtn').show();
                $('.unShareBtn').hide();
                $('.updateShareDetails').hide();
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function addAssignUsers(selectedUsersList) {
        assignUsers.val(null).trigger("change");
        selectedUsersList.forEach(function(value, key){
            if(value.length > 0){
                $('#selectAssignUsers').append($('<option>', {
                    value: value,
                    text: value
                }));
            }
        });
        assignUsers.val(selectedUsersList).trigger("change");
    }
    
    function ValidateEmail(mail)   
    {  
     if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(mail))  
      {  
        return (true)  
      }  
        toastr.error('You have entered an invalid email address!', 'Fail!!!', {allowHtml: true});
        return (false)  
    } 

    $scope.saveShareWith = function(type){
      console.log("TYPE : "+type);
      console.log("subject"+$('.shareWithSubject').val());
        var enableView = document.querySelector('.enableView');
        var enableDownload = document.querySelector('.enableDownload');
        if(type == "two"){
          if($('#listOfUsersTwo').val().length <= 0){
              toastr.error('Please two enter an users email address to share a file', 'Fail!!!', {allowHtml: true});
              return false;
          }
          var userShareList = $('#listOfUsersTwo').val().split(',');
          userShareList.forEach(function(value){
                          ValidateEmail(value);
                        });
          var twoWayShareSwitchWith = document.querySelector('.twoWayShareWithSwitch');
          var twoWay = twoWayShareSwitchWith.checked;
          var subject = $('.shareWithSubjectTwo').val();
          var message = $('.shareWithMessageTwo').val();console.log("subject"+subject);
          var password = $('#sharePasswordWith').val();
          var allowAllUsers = 'true';
        }
        else if(type == "normal"){
          if($('#listOfUsersNormal').val().length <= 0){
            toastr.error('Please enter an users email address to share a file', 'Fail!!!', {allowHtml: true});
            return false;
          }
          var userShareList = $('#listOfUsersNormal').val().split(',');
          userShareList.forEach(function(value){
                          ValidateEmail(value);
                        });
          var twoWayShareSwitchWith = document.querySelector('.twoWayShareSwitch');
          var twoWay = twoWayShareSwitchWith.checked;
          var subject = $('.shareWithSubjectNormal').val();
          var message = $('.shareWithMessageNormal').val();console.log("subject"+subject);
          var password = $('#twoWayNormalSharePassword').val();
          var allowAllUsers = 'true';
        }
        else if(type == "simple"){
          if($('#listOfUsers').val().length <= 0){
            toastr.error('Please enter an users email address to share a file', 'Fail!!!', {allowHtml: true});
            return false;
          }
          var userShareList = $('#listOfUsers').val().split(',');
          userShareList.forEach(function(value){
                          ValidateEmail(value);
                        });
          var twoWay = false;
          var subject = $('.shareWithSubject').val();
          var message = $('.shareWithMessage').val();console.log("subject"+subject);
          var allowAllUsers = 'false';
        }
        if ( $('#fileShareForm').parsley().isValid() && (enableDownload.checked == true || enableView.checked == true)) {
            var download = enableDownload.checked;
            var view = enableView.checked;
            var validTill = $('#till').val();
            

            if($('.shareDefault7Days').html() == 'true'){
                var date = new Date();
                var newdate = new Date(date);
                newdate.setDate(newdate.getDate() + 7);
                var dd = newdate.getDate();
                var mm = newdate.getMonth() + 1;
                var y = newdate.getFullYear();
                validTill = mm + '/' + dd + '/' + y;
            }
            

            var shareData = {
                fileName : $scope.selectedFiles[0].fileName,
                filePath : $scope.selectedFiles[0].filePath,
                download : download,
                twoWayShareEnabled : twoWay,
                userShareList : userShareList,
                subject : subject,
                message : message,
                view : view,
                password : password,
                validTill : validTill,
                allowAllUsers : allowAllUsers
            };

            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/files/shareWith',
                type: 'POST',
                data: shareData
            }).done(function(data){
                var jData = JSON.parse(data);
                console.log(jData);
                $scope.sharedFileDetails = jData.data;
                if(jData.result == 'success'){
                    $('.shareWithBody').show();
                    $('.shareWithBodyStatus').hide();
                    if(jData.unAssignedUsers.container.unAssignedUsers.length > 0 && jData.unAssignedUsers.container.unAssignedUsers != null){
                        $('.shareWithBodyStatus').html("Users, "+jData.unAssignedUsers.container.unAssignedUsers+" not in the list of allowed users");
                        $('.shareWithBodyStatus').show();
                    }
                    $('.updateShareWithDetails').hide();
                    $('.shareLoading').hide();
                    $('.shareBody').show();
                    $('.shareBtn').show();
                    $('.unShareBtn').show();
                    $('.updateShareDetails').hide();
                    toastr.success('File has been shared', 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){   location.reload();    }, 2000);
                }else{
                    if(jData.unAssignedUsers.container.unAssignedUsers.length > 0 && jData.unAssignedUsers.container.unAssignedUsers != null){
                        $('.shareWithBodyStatus').html("Users, "+jData.unAssignedUsers.container.unAssignedUsers+" not in the list of allowed users");
                        $('.shareWithBodyStatus').show();
                    }
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });

        }else{
            if($('#fileShareForm').parsley().isValid()){
                toastr.error('Either Download or View should be enabled to share a file.', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
    if(sharePasswordSwitch){
        sharePasswordSwitch.onchange = function() {
            if(sharePasswordSwitch.checked == true){
                $('.sharePasswordBlock').show();
            }else{
                $('#sharePassword').val('');
                $('#reSharePassword').val('');
                $('.sharePasswordBlock').hide();
            }
        };
    }

    $scope.saveShare = function(){
        var enableView = document.querySelector('.enableView');
        var enableDownload = document.querySelector('.enableDownload');
        var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
        if(sharePasswordSwitch.checked == true){
            if($('#sharePassword').val().length <= 0){
                toastr.error('You need to specify a password to share a file', 'Fail!!!', {allowHtml: true});
                return;
            }
        }
        if ( $('#fileShareForm').parsley().isValid() && (enableDownload.checked == true || enableView.checked == true)) {
            var download = enableDownload.checked;
            var view = enableView.checked;
            var validTill = $('#till').val();
            var isPasswordProtected = sharePasswordSwitch.checked;
            var password = '';
            if(isPasswordProtected == true){
                password = $('#sharePassword').val();
            }
            var data = {
                fileName : $scope.selectedFiles[0].fileName,
                filePath : $scope.selectedFiles[0].filePath,
                download : download,
                view : view,
                validTill : validTill,
                isPasswordProtected : isPasswordProtected,
                password : password
            };
            console.log(data);
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/files/share',
                type: 'POST',
                data: data
            }).done(function(data){
                var jData = JSON.parse(data);
                $scope.sharedFileDetails = jData.data;
                if(jData.result = 'success'){
                    $('.shareLinkBlock').show();
                    $('.shareLink').html(jData.link);
                    $('.shareBtn').hide();
                    $('.unShareBtn').show();
                    $('.updateShareDetails').show();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });

        }else{
            if($('#fileShareForm').parsley().isValid()){
                toastr.error('Either Download or View should be enabled to share a file.', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.unShare = function(){
        var data = {
            fileName : $scope.selectedFiles[0].fileName,
            filePath : $scope.selectedFiles[0].filePath
        };
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/unShare',
            type: 'POST',
            data: data
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result = 'success'){
                $('.shareWithBody').show();
                $('.shareWithBodyStatus').hide();
                $('.updateShareWithDetails').hide();
                $('.shareLoading').hide();
                $('.shareBody').show();
                $('.till').val('');
                $('.shareWithValidTill').val('');
                $('.listOfUsers').val('');
                $('.shareWithSubject').val('');
                $('.shareWithMessage').val('');
                $('.removeValidUntil').hide();
                $('.shareWithRemoveValidUntil').hide();
                $('.shareLinkBlock').hide();
                $('.shareLink').html('');
                $('.shareBtn').show();
                $('.unShareBtn').hide();
                $('.updateShareDetails').hide();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateSharePolicy = function(){
        var enableView = document.querySelector('.enableView');
        var enableDownload = document.querySelector('.enableDownload');
        var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
        if(sharePasswordSwitch.checked == true){
            if($('#sharePassword').val().length <= 0){
                toastr.error('Once Password protected is selected you need to specify a password to share a file', 'Fail!!!', {allowHtml: true});
                return;
            }
        }
        if ( $('#fileShareForm').parsley().isValid() && (enableDownload.checked == true || enableView.checked == true)) {
            var html = $('.updateShareDetails').html();
            $('.updateShareDetails').attr('disabled','disabled');
            $('.updateShareDetails').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            var download = enableDownload.checked;
            var view = enableView.checked;
            var validTill = $('#till').val();
            var isPasswordProtected = sharePasswordSwitch.checked;
            var password = '';
            if(isPasswordProtected == true){
                password = $('#sharePassword').val();
            }
            var data = {
                fileName : $scope.selectedFiles[0].fileName,
                filePath : $scope.selectedFiles[0].filePath,
                download : download,
                view : view,
                validTill : validTill,
                isPasswordProtected : isPasswordProtected,
                key: $scope.sharedFileDetails.key12+'+'+$scope.sharedFileDetails.key14+'+'+$scope.sharedFileDetails.key18+'+'+$scope.sharedFileDetails.key20,
                password : password
            };
            console.log(data);
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/files/updateSharePolicy',
                type: 'POST',
                data: data
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result = 'success'){
                    $('.shareLinkBlock').show();
                    $('.shareLink').html(jData.link);
                    $('.shareBtn').hide();
                    $('.unShareBtn').show();
                    $('.updateShareDetails').show();
                    $('.updateShareDetails').html('Saved <i class="fa fa-check"></i>').animate();
                    setTimeout(function(){
                        $('.updateShareDetails').html(html);
                        $('.updateShareDetails').removeAttr('disabled');
                    }, 1000);
                }else{
                    $('.updateShareDetails').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        $('.updateShareDetails').html(html);
                        $('.updateShareDetails').removeAttr('disabled');
                    }, 1000);
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });

        }else{
            if($('#fileShareForm').parsley().isValid()){
                toastr.error('Download should be enabled to share a file.', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    function checkForFilesCopiedOrCut(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/checkForFilesCopiedOrCut',
            data: { csrf_token: $('.csrf_token').html() },
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.selectedFilesForCopyCut = jData.files;
                $scope.selectedFilesForCopyCutFromPath = jData.fromPath;
                $scope.$apply();
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    }

    $scope.cut = function(){

        var pathsToCut = [];
        $scope.selectedFiles.forEach(function(value, key){
            pathsToCut.push(getPath(value));
        });
        $scope.selectedFolders.forEach(function(value, key){
            pathsToCut.push(getPath(value));
        });
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/cut',
            data: { pathsToCut: pathsToCut, currentPath: $scope.crumbString, csrf_token: $('.csrf_token').html() },
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.selectedFilesForCopyCut = pathsToCut;
                $scope.selectedFilesForCopyCutFromPath = $scope.crumbString;
                $scope.$apply();
                toastr.success(jData.msg, 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.copy = function(){
        var pathsToCopy = [];
        $scope.selectedFiles.forEach(function(value, key){
            pathsToCopy.push(getPath(value));
        });
        $scope.selectedFolders.forEach(function(value, key){
            pathsToCopy.push(getPath(value));
        });

        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/copy',
            data: { pathsToCopy: pathsToCopy, currentPath: $scope.crumbString, csrf_token: $('.csrf_token').html() },
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.selectedFilesForCopyCut = pathsToCopy;
                $scope.selectedFilesForCopyCutFromPath = $scope.crumbString;
                $scope.$apply();
                toastr.success(jData.msg, 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.paste = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/paste',
            data: { destination: $scope.crumbString, csrf_token: $('.csrf_token').html() },
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.selectedFilesForCopyCut = [];
                $scope.selectedFilesForCopyCutFromPath = '';
                $scope.updateFileList('root', 'root', true, true);
                toastr.success(jData.msg, 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.createMiniCloud = function(miniCloudName){
        $('.createMiniCloudError').hide();
        if(isSpecialCharForMiniCloud(miniCloudName) == false){
            $('.createMiniCloudError').html('<br><span class="text-danger">Special characters like ( * \\ | : \" < > ? / &) are not allowed.</span>');
            $('.createMiniCloudError').show();
            return;
        }
        if(miniCloudName != undefined && miniCloudName.length > 0){
            $('.loading').show();
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/createMiniCloud',
                data: {miniCloudName: miniCloudName, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    $('#createMiniCloud').modal('hide');
                    $('#miniCloudName').val('');
                    if(jData.userUpdate != '200'){
                        toastr.error('Was not able to attach MiniCloud to your account, please attach the MiniCloud manually to your account', 'Fail!!!', {allowHtml: true});
                        return;
                    }
                    $scope.updateFileList('root', 'root', true, true);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('Please enter a <b>MiniCloud</b> Name', 'Fail!!!', {allowHtml: true});
        }
    };

    $scope.createFolder = function(folderName){
        $('.createFolderError').hide();
        if(isSpecialChar(folderName) == false){
            $('.createFolderError').html('<br><span class="text-danger">Special characters like ( * \\ | : \" < > ? / ) are not allowed.</span>');
            $('.createFolderError').show();
            return;
        }

        if(folderName != undefined && folderName.length > 0){
            $('.loading').show();
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/createFolder',
                data: {path: $scope.crumbString, folderName: folderName, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    $('#createFolder').modal('hide');
                    $('#folderName').val('');
                    $scope.folderName = '';
                    $scope.updateFileList('root', 'root', true, true);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('Please enter a <b>Folder</b> Name', 'Fail!!!', {allowHtml: true});
        }
    };

    function isSpecialChar(val) {
        var tr = $.trim(val).length;
        if(val && tr) {
            var regex = /[*|\\":<>/?]/;
            if(regex.test(val)){
                return false;
            }
        }
        else{
            return false;
        }
        return true;
    }

    function isSpecialCharForMiniCloud(val) {
        var tr = $.trim(val).length;
        if(val && tr) {
            var regex = /[$-/:-?{-~!"^_`\[\]]/;
            if(regex.test(val)){
                return false;
            }
        }
        else{
            return false;
        }
        return true;
    }

    $scope.sendEmailShareLink = function(){
        $('.sendEmailShareForm').toggleClass('hide');
    };
    
    $scope.copyToClipboard = function(){
        toastr.success('Copied to Clipboard');
    };

    $scope.sendShareEmail = function(emails){
        if(emails != undefined && emails.length > 0){
            $('.loading').show();
            var html = $('.shareEmailLinkSendBtn').html();
            $('.shareEmailLinkSendBtn').attr('disabled','disabled');
            $('.shareEmailLinkSendBtn').html('Sending... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/sendShareEmail',
                data: {emails: emails, url: $('.shareLink').html(), fileName: $scope.selectedFiles[0].fileName, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                console.log(data);
                $('.shareEmailLinkSendBtn').removeAttr('disabled');
                $('.shareEmailLinkSendBtn').html(html);
                if(jData.result == 'success'){
                    $('.sendEmailShareForm').addClass('hide');
                    $('[name="emails"]').val = '';
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('Please enter a <b>email address</b>', 'Fail!!!', {allowHtml: true});
        }
    };

    $scope.loadChangeOwnerShipModal = function(selectedMiniCloudName){
        $('[name="miniCloudName"]').val(selectedMiniCloudName);
        $('#ownerShipChange').modal('show');
    };

    $scope.loadAssignUsersModal = function(selectedMiniCloudName){
        $('[name="miniCloudName"]').val(selectedMiniCloudName);
        $('#assignUsers').modal('show');
    };

    $scope.loadUserNamesList = function(){

        $.ajax({
            url: $scope.BASE_FOLDER+'/user/allNames',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            $scope.userNameList = jData.users;
            $scope.$apply();
        });
    };

    $scope.changeOwnerForMiniCloud = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/miniClouds/changeOwner',
            data: $('.ownerShipForm').serialize(),
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            $('#ownerShipChange').modal('hide');
            if(jData.result == 'success'){
                setTimeout(function(){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    window.location.reload(true);
                }, 1);
            }else{
                setTimeout(function(){
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }, 1);
            }
        });
    };

    $scope.assignUsersForMiniCloud = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/miniClouds/assignUsers',
            data: $('.assignUsersForMiniCloud').serialize(),
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if($(".assignUsers").val() == null){
                    toastr.success("MiniCloud users has been removed successfully", 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }
                setTimeout(function(){
                    window.location.reload(true);
                }, 2000);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        });
    };

    $scope.getBlukrypts = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/getAllBlukrypts',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.blukrypts != null){
                    $scope.listOFBlukrypts = jData.blukrypts;
                    $scope.$apply();
                    $scope.listOFBlukrypts.forEach(function(value, key){
                        $.ajax({
                            url: $scope.BASE_FOLDER+'/getBestBlukrypt',
                            data: {blukrypts: jData.blukrypts, csrf_token: $('.csrf_token').html()},
                            type: 'POST'
                        }).done(function(data){
                            console.log(data);
                            var jData = JSON.parse(data);
                            if(jData.result = 'fail'){
                                $scope.bestBlukrypt = jData.bestBlukrypt;
                                $scope.$apply()
                            }else{
                                toastr.error('Due to some technical issues not able to open the file location please, manually navigate to the file', 'Fail!!!', {allowHtml: true});
                            }
                        }).error(function(data){
                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                            if(data.status == 424){
                                setTimeout(function(){
                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                                }, 3000);
                            }else if(data.status == 503){
                                setTimeout(function(){
                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                                }, 3000);
                            }
                        });
                    });
                }else{
                    $scope.bestBlukrypt = $('.blukryptIP').html();
                    $scope.$apply();
                }
            }else{
                $scope.bestBlukrypt = $('.blukryptIP').html();
                $scope.$apply();
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    angular.element(document).ready(function(){
        $scope.getBlukrypts();
        if($('.fileIncludeExtensions').html().length > 0){
            $scope.allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
        }

        if($('.fileExcludeExtensions').html().length > 0){
            $scope.notAllowedFileAttributes = $('.fileExcludeExtensions').html().replace(' ', '').split(',');
        }

        window.onbeforeunload = function() {
            if($scope.currentFileUploadList.length > 0){
                return 'Some Files are getting uploaded, do still you want to reload the page?';
            }
        };

        $('.loading').html('Loading ...');
        if($scope.currentPage == 'files'){
            blockUI.start();
            checkForFilesCopiedOrCut();
            $scope.updateFileList('root', 'root', true, true);
            $scope.getUserPolicy();
        }

        $scope.loadUserNamesList();

        $scope.openFileRevisionFor = $('.openFileRevision').html();

        $('body').click(function() {
            $('.contextMenu').hide();
        });

        $('.contextMenu').click(function() {
            $('.contextMenu').hide();
        });

        var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
        if(sharePasswordSwitch){ var init = new Switchery(sharePasswordSwitch, { color: '#4CAF50', size: 'large'}); }

	var twoWayShareSwitch = document.querySelector('.twoWayShareSwitch');
        if(twoWayShareSwitch){ var init = new Switchery(twoWayShareSwitch, { color: '#4CAF50', size: 'large'}); }
        
        var twoWayShareWithSwitch = document.querySelector('.twoWayShareWithSwitch');
        if(twoWayShareWithSwitch){ var init = new Switchery(twoWayShareWithSwitch, { color: '#4CAF50', size: 'large'}); }

        var enableDownload = document.querySelector('.enableDownload');
        if(enableDownload){ var init = new Switchery(enableDownload, { color: '#4CAF50'}); }

        var enableView = document.querySelector('.enableView');
        if(enableView){ var init = new Switchery(enableView, { color: '#4CAF50'}); }

        var shareWithEnableDownload = document.querySelector('.shareWithEnableDownload');
        if(shareWithEnableDownload){ var init = new Switchery(shareWithEnableDownload, { color: '#4CAF50'}); }

        var shareWithEnableView = document.querySelector('.shareWithEnableView');
        if(shareWithEnableView){ var init = new Switchery(shareWithEnableView, { color: '#4CAF50'}); }

    });

    function getPosition(e) {
        var posx = 0;
        var posy = 0;

        if (!e) var e = window.event;

        if (e.pageX || e.pageY) {
            posx = e.pageX;
            posy = e.pageY;
        } else if (e.clientX || e.clientY) {
            posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
            posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
        }

        return {
            x: posx,
            y: posy
        }
    }

    function htmlspecialchars_decode(string, quote_style) {
        var optTemp = 0,
            i = 0,
            noquotes = false;
        if (typeof quote_style === 'undefined') {
            quote_style = 2;
        }
        string = string.toString()
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>');
        var OPTS = {
            'ENT_NOQUOTES': 0,
            'ENT_HTML_QUOTE_SINGLE': 1,
            'ENT_HTML_QUOTE_DOUBLE': 2,
            'ENT_COMPAT': 2,
            'ENT_QUOTES': 3,
            'ENT_IGNORE': 4
        };
        if (quote_style === 0) {
            noquotes = true;
        }
        if (typeof quote_style !== 'number') { // Allow for a single string or an array of string flags
            quote_style = [].concat(quote_style);
            for (i = 0; i < quote_style.length; i++) {
                // Resolve string input to bitwise e.g. 'PATHINFO_EXTENSION' becomes 4
                if (OPTS[quote_style[i]] === 0) {
                    noquotes = true;
                } else if (OPTS[quote_style[i]]) {
                    optTemp = optTemp | OPTS[quote_style[i]];
                }
            }
            quote_style = optTemp;
        }
        if (quote_style & OPTS.ENT_HTML_QUOTE_SINGLE) {
            string = string.replace(/&#0*39;/g, "'"); // PHP doesn't currently escape if more than one 0, but it should
            // string = string.replace(/&apos;|&#x0*27;/g, "'"); // This would also be useful here, but not a part of PHP
        }
        if (!noquotes) {
            string = string.replace(/&quot;/g, '"');
        }
        // Put this in last place to avoid escape being double-decoded
        string = string.replace(/&amp;/g, '&');

        return string;
    }

}]);
