/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('PmsController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER) {

    $scope.sortReverse = false;
    $scope.sortType = 'policygroupName';
    $scope.sortTypeMapping = 'userName';
    $scope.sortTypeFilter = 'filterName';
    $scope.sortTypeSchedule = 'scheduleName';

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();
    $scope.selectedUser = $('.selectedUser').html();
    $scope.schedules = [];
    $scope.filters = [];
    $scope.policies = [];
    $scope.scheduleIndex = '';
    $scope.filterIndex = '';
    $scope.selectedPolicy = {};

    $scope.defaultWinFolders = ['c:\\', 'd:\\'];
    $scope.defaultMacFolders = ['/users/', '/home/'];
    $scope.defaultUniversalFolders = ['/users/', '/home/', 'c:\\', 'd:\\'];
    $scope.userExcludedFoldersWindows =[];
    $scope.userExcludedFoldersMac =[];
    $scope.userExcludedFoldersUniversal =[];

    $scope.currentDefaultWinFolders = ['c:\\', 'd:\\'];
    $scope.currentDefaultMacFolders = ['/users/', '/home/'];
    $scope.currentDefaultUniversalFolders = ['/users/', '/home/', 'c:\\', 'd:\\'];

    $scope.defaultSchedules = [];
    $scope.userPolicyMappingPolicies = [];
    $scope.userPolicyMappingUsers = [];

    $scope.bluvaults = [];
    $scope.blukrypts = [];

    $scope.preBackup = [];
    $scope.postBackup = [];
    $scope.preRestore = [];
    $scope.postRestore = [];

    $scope.ccS = [];

    $scope.toggleSelectPickerAll = function(){
        if($('.selectPicker').selectpicker('val') != null){
            if($('.selectPicker').selectpicker('val').length == 7){
                $('.scheduleDaily').html('Daily');
                $('.selectPicker').selectpicker('deselectAll');
            }else{
                $('.scheduleDaily').html('De-Select All');
                $('.selectPicker').selectpicker('selectAll');
            }
        }else{
            $('.scheduleDaily').html('De-Select All');
            $('.selectPicker').selectpicker('selectAll');
        }
    };

    $('.selectPicker').on('change', function(){
        toggleSelectPicker();
    });

    function toggleSelectPicker(){
        if($('.selectPicker').selectpicker('val') != null){
            if($('.selectPicker').selectpicker('val').length == 7){
                $('.scheduleDaily').html('De Select All');
            }else{
                $('.scheduleDaily').html('Daily');
            }
        }else{
            $('.scheduleDaily').html('Daily');
        }
    }

    $scope.scheduleCreate = function(remove){
        if($('.scheduleForm').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/schedule/save',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    if(remove == true){
                        $('.createSchedule').modal('hide');
                        $('#schedules').append($('<option>', {
                            value: $('[name="scheduleName"]').val(),
                            text: $('[name="scheduleName"]').val()
                        }));
                        $('.selectSchedulePicker').selectpicker('refresh');
                        var scheduleNames = $('.selectSchedulePicker').val();
                        if(scheduleNames != null){
                            scheduleNames.push($('[name="scheduleName"]').val());
                            $('.selectSchedulePicker').selectpicker('val', scheduleNames);
                        }else{
                            $('.selectSchedulePicker').selectpicker('val', $('[name="scheduleName"]').val());
                        }
                        $scope.updateSelectedScheduleNames($('.selectSchedulePicker').val());
                    }else{
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/pms/schedules';
                        }, 3000);
                    }
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.getSchedules = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/schedules',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.schedules = jData.schedules;
                $scope.$apply();
            }else{
                toastr.error('No Schedules has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.scheduleEdit = function(index){
        $scope.scheduleIndex = index;
        $('.scheduleEditTime').timepicker('setTime', $scope.schedules[$scope.scheduleIndex].time);
        $('.selectPicker').selectpicker('val', $scope.schedules[$scope.scheduleIndex].daysArray);
        $('.editSchedule').modal('show');
        if($scope.schedules[$scope.scheduleIndex].backupType == 'i'){
            $('.backupType').find('option[value="i"]').prop("selected",true);
        }else{
            $('.backupType').find('option[value="f"]').prop("selected",true);
        }
        $('.backupType').selectpicker('render');
        toggleSelectPicker();
    };

    $scope.scheduleSave = function(){
        if($('.scheduleForm').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/schedule/save',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    $scope.schedules[$scope.scheduleIndex].daysArray = $('.selectPicker').selectpicker('val');
                    $scope.schedules[$scope.scheduleIndex].time = $('[name="scheduleStartTime"]').val();
                    $scope.schedules[$scope.scheduleIndex].days = getDayNames($('.selectPicker').selectpicker('val').join(','));
                    $scope.schedules[$scope.scheduleIndex].backupType = $('.backupType').val();
                    $scope.$apply();
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
            $('.editSchedule').modal('hide');
        }
    };

    $scope.sendMeTo = function(url){
        window.location.href = $scope.BASE_FOLDER+url;
    };

    function getDayNames(numString){
        numString = numString.replace('1', 'Sunday');
        numString = numString.replace('2', 'Monday');
        numString = numString.replace('3', 'Tuesday');
        numString = numString.replace('4', 'Wednesday');
        numString = numString.replace('5', 'Thursday');
        numString = numString.replace('6', 'Friday');
        numString = numString.replace('7', 'Saturday');
        return numString;
    }

    $scope.getFilters = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/filters',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.filters = jData.filters;
                $scope.$apply();
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.filterCreate = function(remove){
        if($('.filterForm').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/filter/save',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    if(remove == true){
                        $('.createFilter').modal('hide');
                        $('#filters').append($('<option>', {
                            value: $('[name="filterName"]').val(),
                            text: $('[name="filterName"]').val()
                        }));
                        $('.selectFilterPicker').selectpicker('refresh');
                        $('.selectFilterPicker').selectpicker('val', $('[name="filterName"]').val());
                        $scope.updateSelectedFilters($('[name="filterName"]').val());
                    }else{
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/pms/filters';
                        },2000);
                    }
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
            $('.editSchedule').modal('hide');
        }
    };

    $scope.filterSave = function(){
        if($('.filterForm').parsley().isValid()){
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/filter/save',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                if(jData.result == 'success'){
                    $('.editFilter').modal('hide');
                    $scope.filters[$scope.filterIndex].filters = $('.editFilters').tagsinput('items').join(',');
                    $scope.filters[$scope.filterIndex].filterType = $('.filterType').val();
                    $scope.$apply();
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
            $('.editSchedule').modal('hide');
        }
    };

    $scope.filterEdit = function(index){
        $scope.filterIndex = index;
        $('.editFilters').tagsinput('removeAll');
        $('.editFilters').tagsinput('add', $scope.filters[$scope.filterIndex].filters);
        if($scope.filters[$scope.filterIndex].filterType == "exclusion"){
            $('.filterType').find('option[value="exclusion"]').prop("selected",true);
        }else{
            $('.filterType').find('option[value="inclusion"]').prop("selected",true);
        }
        $('.filterType').selectpicker('refresh');
        $('.editFilter').modal('show');
    };

    $scope.getPolices = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/policies',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success') {
                if (jData.policies.length > 0) {
                    $('.policyTable').show();
                    $('.policyTableEmpty').hide();
                    $scope.policies = jData.policies;
                    $scope.$apply();
                }else{
                    $('.policyTable').hide();
                    $('.policyTableEmpty').show();
                }
            }else{
                toastr.error('No Policy was found', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.addNewSchedule = function(){
        $('.createSchedule').modal('show');
    };

    $('.selectSchedulePicker').on('change', function(){
        $scope.updateSelectedScheduleNames($('.selectSchedulePicker').val());
    });

    $scope.updateSelectedScheduleNames = function(names){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/schedule',
            data: {csrf_token: $('.csrf_token').html(), scheduleNames: names},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.defaultSchedules = jData.schedules;
                $scope.$apply();
            }else{
                toastr.error('No Schedules were found', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.addNewFilter = function(){
        $('.createFilter').modal('show');
    };

    $scope.addNewCcS = function(){
        $('.createCcS').modal('show');
    };

    $('.selectFilterPicker').on('change', function(){
        $scope.updateSelectedFilters($('.selectFilterPicker').val());
    });

    $scope.updateSelectedFilters = function(filters){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/filter',
            data: {csrf_token: $('.csrf_token').html(), filterName: filters},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.defaultFilter = jData.filters;
                $scope.$apply();
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    if($('[name="defaultFoldersBackup"]')[0]){
        $('[name="defaultFoldersBackup"]')[0].addEventListener( 'keydown', function( ev ) {
            if(ev.keyCode == 13){
                ev.preventDefault();
            }
        });
    }

    $scope.addDefaultFolder = function($value){
        var osType = $('[name="osType"]').val();
        if((osType.toLowerCase()).indexOf('windows') > -1){
            osType = 'windows';
        }else if(osType == "universal"){
            osType = 'universal';
        }
        else{
            osType = 'mac';
        }
        if($value != '' && $value != null && $value != undefined){
            if(osType == 'windows'){
                $value = sanitizeValues(osType, $value, $scope.defaultWinFolders);
                if($value === false || $value == 'exist'){
                    $('[name="defaultFoldersBackup"]').popover('show');
                    return;
                }else{
                    $('[name="defaultFoldersBackup"]').popover('hide');
                    $('[name="defaultFoldersBackup"]').val('');
                    $scope.defaultWinFolders.push($value);
                    toastr.success('Selected Folder has been added successfully', 'Success!!!', {allowHtml: true});
                }
            }else if(osType == 'universal'){
                $value = sanitizeValues(osType, $value, $scope.defaultUniversalFolders);
                if($value === false || $value == 'exist'){
                    $('[name="defaultFoldersBackup"]').popover('show');
                    return;
                }else{
                    $('[name="defaultFoldersBackup"]').popover('hide');
                    $('[name="defaultFoldersBackup"]').val('');
                    $scope.defaultUniversalFolders.push($value);
                    toastr.success('Selected Folder has been added successfully', 'Success!!!', {allowHtml: true});
                }
             }else if(osType == 'mac'){
                $value = sanitizeValues(osType, $value, $scope.defaultMacFolders);
                if($value === false || $value == 'exist'){
                    $('[name="defaultFoldersBackup"]').popover('show');
                    return;
                }else{
                    $('[name="defaultFoldersBackup"]').val('');
                    $('[name="defaultFoldersBackup"]').popover('hide');
                    $scope.defaultMacFolders.push($value);
                    toastr.success('Selected Folder has been added successfully', 'Success!!!', {allowHtml: true});
                }
            }else{
                toastr.info('Please select a Operating System type before adding a Folder Path', 'Information!!!', {allowHtml: true});
            }
        }else{
            $('[name="defaultFoldersBackup"]').popover('show');
            return;
        }
    };

    $scope.removeDefaultFolder = function($key){
        var osType = $('[name="osType"]').val();
        if((osType.toLowerCase()).indexOf('windows') > -1){
            $scope.defaultWinFolders.splice($key, 1);
            toastr.success('Selected Folder has been deleted successfully', 'Success!!!', {allowHtml: true});
        }
        else if(osType == 'universal'){
            toastr.success('Selected Folder has been deleted successfully', 'Success!!!', {allowHtml: true});
            $scope.defaultUniversalFolders.splice($key, 1);
        }
        else if((osType.toLowerCase()).indexOf('mac') > -1){
            toastr.success('Selected Folder has been deleted successfully', 'Success!!!', {allowHtml: true});
            $scope.defaultMacFolders.splice($key, 1);
        }else{
            toastr.info('Please select a Operating System type before deleting', 'Success!!!', {allowHtml: true});
        }
    };

    function sanitizeValues(osType, folder, $folders){
        var pattern = new RegExp(':');
        var result = '';
        var home = '{user.home}';
        if(osType == 'windows') {
            if(folder == '' || folder == null){
                return false;
            }else{
                if(pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length == 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\\');
                        folder = folder.replace(/\//g, '\\');
                        folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            console.log("Folder : "+folder+ " Value : "+value);
                            if(folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                                console.log("Res : True");
                                result = 'exist';
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
                        return false;
                    }
                }else{
                    if(folder.includes(home) || folder == 'ALL'){
                    //if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                    }else{
                        return false;
                    }
                }
            }
        }else if(osType == 'universal'){
            if(pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length == 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\\');
                        folder = folder.replace(/\//g, '\\');
                        folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            console.log("Folder : "+folder+ " Value : "+value);
                            if(folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                                console.log("Res : True");
                                result = 'exist';
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
                        return false;
                    }
                }else if(!pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length != 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\/');
                        folder = folder.replace(/\\/g, "/");
                        folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist' 
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
                        return false;
                    }
                }
                else{
                    if(folder.includes(home) || folder == 'ALL'){
                        //if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                    }else{
                        return false;
                    }
                }

        }else{
            if(folder == '' || folder == null){
                return false;
            }else{
                if(!pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length != 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\/');
                        folder = folder.replace(/\\/g, "/");
                        folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
                        return false;
                    }
                }else{
                    if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                    }else{
                        return false;
                    }
                }
            }
        }
    }
    
    $scope.addExclusionFolder = function(folder){
        var osType = $('[name="osType"]').val();
        var pattern = new RegExp(':');
        var fin = '';
        var result1 = '';
        if(osType == 'windows'){
            var nW = folder.lastIndexOf('\\');
            fin = folder.substring(nW + 1);
            if(fin.includes(".")){
                folder = folder.substring(0, folder.lastIndexOf("\\") + 1);
            }
        }
        else if(osType == 'mac'){
            var nM = folder.lastIndexOf('\/');
            fin = folder.substring(nM + 1);
            if(fin.includes(".")){
                folder = folder.substring(0, folder.lastIndexOf("\/") + 1);
            }
        }
        /*else if(osType == 'universal'){
            folder = folder.replace(/\\/g, "/");
            var nU = folder.lastIndexOf('\/');
            fin = folder.substring(nU + 1);
            if(fin.includes(".")){
                folder = folder.substring(0, folder.lastIndexOf("\/") + 1);
            }
        }*/
        if(folder != '' && folder != null && folder != undefined){
        if(osType =="windows"){  
           folder = checkForValidPath(osType, folder, $scope.defaultWinFolders);
           if(folder === false || folder == 'exist'){
                    $('[name="exclusionFolderName"]').popover('show');
                    return;
                }else{
                    $('[name="exclusionFolderName"]').popover('hide');
                    $('[name="exclusionFolderName"]').val('');
                    if($scope.userExcludedFoldersWindows.includes(folder) == false){
                    $scope.userExcludedFoldersWindows.push(folder);
                    $('#noFolders').hide();
                    toastr.success('Selected Folder has been added successfully', 'Success!!!', {allowHtml: true});
                    }
                    else{
                         $('[name="exclusionFolderName"]').popover('show');
                    toastr.error('Selected Folder is already present', 'Fali!!!', {allowHtml: true});
                    }
                }
        }
        else if(osType =="mac"){
           folder = checkForValidPath(osType, folder, $scope.defaultMacFolders);
           console.log("folder "+folder);
           if(folder === false || folder == 'exist'){
                    $('[name="exclusionFolderName"]').popover('show');
                    return;
                }else{
                    $('[name="exclusionFolderName"]').popover('hide');
                    $('[name="exclusionFolderName"]').val('');
                    if($scope.userExcludedFoldersMac.includes(folder) == false){
                    $scope.userExcludedFoldersMac.push(folder);
                    $('#noFolders').hide();
                    toastr.success('Selected Folder has been added successfully', 'Success!!!', {allowHtml: true});
                    }
                    else{
                         $('[name="exclusionFolderName"]').popover('show');
                    toastr.error('Selected Folder is already present', 'Fali!!!', {allowHtml: true});
                    }
                }
        }else if(osType =="universal"){
            if(pattern.test(folder) && folder.slice(-1) != '\\'){
            folder = folder.concat('\\');
            }
            if(!pattern.test(folder) && folder.slice(-1) != '\/'){
                folder = folder.concat('\/');
            }
            if($scope.defaultUniversalFolders.includes(folder) == false && $scope.userExcludedFoldersUniversal.includes(folder) == false){
                $('[name="exclusionFolderName"]').val('');
                $scope.userExcludedFoldersUniversal.push(folder);
                $('#noFolders').hide();
                toastr.success('Selected Folder has been added successfully', 'Success!!!', {allowHtml: true});
                    }
                    else{
                         $('[name="exclusionFolderName"]').popover('show');
                    toastr.error('Selected Folder is already present', 'Fali!!!', {allowHtml: true});
                    }
        }
        else{
                toastr.info('Please select a Operating System type before adding a Folder Path', 'Information!!!', {allowHtml: true});
            }
        }
        else{
            $('[name="defaultFoldersBackup"]').popover('show');
            return;
        }
    };

    $scope.removeExclusionFolder = function($key){
            var osType = $('[name="osType"]').val();
            if(osType == 'windows'){
                $scope.userExcludedFoldersWindows.splice($key, 1);
                if($scope.userExcludedFoldersWindows.isNull()){
                  document.getElementById('noFolders').innerHTML = "There are no folders to be excluded";
                }
                toastr.success('Selected Folder has been deleted successfully', 'Success!!!', {allowHtml: true});
            }
            else if(osType == 'mac'){
                $scope.userExcludedFoldersMac.splice($key, 1);
                if($scope.userExcludedFoldersMac.isNull()){
                  document.getElementById('noFolders').innerHTML = "There are no folders to be excluded";
                }
                toastr.success('Selected Folder has been deleted successfully', 'Success!!!', {allowHtml: true});
            }
            else if(osType == 'universal'){
                $scope.userExcludedFoldersUniversal.splice($key, 1);
                if($scope.userExcludedFoldersUniversal.isNull()){
                  document.getElementById('noFolders').innerHTML = "There are no folders to be excluded";
                }
                toastr.success('Selected Folder has been deleted successfully', 'Success!!!', {allowHtml: true});
            }
            else{
                toastr.info('Please select a Operating System type before deleting', 'Success!!!', {allowHtml: true});
            }
    };
    
    Array.prototype.isNull = function (){
    return this.join().replace(/,/g,'').length === 0;
};
    
    function checkForValidPath(osType, folder, $folders){
        var pattern = new RegExp(':');
        var resultI = '';
        var resultO = '';
        var home = '{user.home}';
        if(osType == 'windows') {
            if(folder == '' || folder == null){
                return false;
            }else{
                if(pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length == 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\\');
                        folder = folder.replace(/\//g, '\\');
                        folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            resultO = "exist";
                            if(value.charAt(0) == folder.charAt(0)){
                                if(!folder.indexOf(value.toLowerCase()) > -1 ){
                                    console.log("Res : True");
                                    resultI = 'add';
                                }
                            }
                            if(folder.length == value.length){
                                resultI = '';
                            }
                        });
                        if(resultI == 'add'){ return folder; }else{ return resultO; }
                    }else{
                        return false;
                    }
                }else{
                    if(folder.includes(home)  || folder == 'ALL'){
                        $folders.forEach(function(value){
                            resultO = 'exist';
                            if(!folder.indexOf(value.toLowerCase()) > -1){
                                resultI = 'add'
                            }
                            if(folder.length < value.length){
                                resultI = '';
                            }
                        });
                        if(resultI == 'add'){ return folder; }else{ return resultO; }
                    }else{
                        return false;
                    }
                }
            }
        }else{
            if(folder == '' || folder == null){
                return false;
            }else{
                if(!pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length != 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\/');
                        folder = folder.replace(/\\/g, "/");
                        folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            resultO = "exist";
                            if(folder.split("/")[1] == value.split("/")[1]){
                            if(!folder.indexOf(value.toLowerCase()) > -1){
                                resultI = 'add';
                            }
                        }
                        });
                        if(resultI == 'add'){ return folder; }else{ return resultO; }
                    }else{
                        return false;
                    }
                }else{
                    if(folder.includes(home)  || folder == 'ALL'){
                        $folders.forEach(function(value){
                            resultO = 'exist';
                            if(!folder.indexOf(value.toLowerCase()) > -1){
                                resultI = 'add'
                            }
                            if(folder.length < value.length){
                                resultI = '';
                            }
                        });
                        if(resultI == 'add'){ return folder; }else{ return resultO; }
                    }else{
                        return false;
                    }
                }
            }
        }
    }

    $('ul.sortable').sortable({ items: "> li", disableSelection: true });

    $scope.viewPolicy = function(policyName){
        var policyName = policyName;
        $('.viewPolicy').modal('show');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/viewpolicy',
            data: {csrf_token: $('.csrf_token').html(), secret: '',policyName: policyName},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            console.log(jData);
            if(jData.result == 'success'){
                assignCallOutScripts(jData.policy.calloutScripts);
                jData.policy.scheduleNames.forEach(function(value){
                    $('.selectSchedulePicker option[value="'+value+'"]').prop('selected', true);
                });
                if(jData.policy.privacyGatewayMappingElement.privacyGatewayNames != null)
                        {
                jData.policy.privacyGatewayMappingElement.privacyGatewayNames.forEach(function(value){
                    var $element = $(".blukryptIPAdress").find('option[value="'+value+'"]');
                    $element.detach();
                    $(".blukryptIPAdress").append($element);
                    $(".blukryptIPAdress").trigger("change");
                });
            }
        $('.exitt').find('option[value="false"]').prop("selected",true);
                $('.decouple').find('option[value="false"]').prop("selected",true);
                $('.support').find('option[value="false"]').prop("selected",true);
                $('.initiatebackup').find('option[value="false"]').prop("selected",true);
                $('.restore').find('option[value="false"]').prop("selected",true);
                $('.stopbackup').find('option[value="false"]').prop("selected",true);
                $('.bkpsettings').find('option[value="false"]').prop("selected",true);
                $('.bkpfiles').find('option[value="false"]').prop("selected",true);
                $('.refbkppolicy').find('option[value="false"]').prop("selected",true);
                jData.policy.endpointUiPreferences.forEach(function(value){ 
                if(value === "EXIT"){
                    $('.exitt').find('option[value="true"]').prop("selected",true);
                }
                if(value === "DECOUPLE"){
                    $('.decouple').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SUPPORT"){
                    $('.support').find('option[value="true"]').prop("selected",true);
                }
                if(value === "INTIATE_BACKUP"){
                    $('.initiatebackup').find('option[value="true"]').prop("selected",true);
                }
                if(value === "RESTORE"){
                    $('.restore').find('option[value="true"]').prop("selected",true);
                }
                if(value === "STOP_BACKUP"){
                    $('.stopbackup').find('option[value="true"]').prop("selected",true);
                }
                if(value === "BACKUP_SETTINGS"){
                    $('.bkpsettings').find('option[value="true"]').prop("selected",true);
                }
                if(value === "BACKUP_FILES"){
                    $('.bkpfiles').find('option[value="true"]').prop("selected",true);
                }
                if(value === "REFRESH_BACKUP_POLICY"){
                    $('.refbkppolicy').find('option[value="true"]').prop("selected",true);
                }
                });
                $(".blukryptIPAdress").val("");
                $(".blukryptIPAdress").trigger('change');
                $(".blukryptIPAdress").val(jData.policy.privacyGatewayMappingElement.privacyGatewayNames);
                $(".blukryptIPAdress").trigger('change');
                jData.policy.policyRefresh = jData.policy.policyRefresh.substring(0, jData.policy.policyRefresh.indexOf(':'));
                $('#policyRefresh').val(jData.policy.policyRefresh);
                
                $('#sortAlgoForPg').find('option[value="NEAREST"]').prop("selected",true);
                if(jData.policy.searchAlgoForPg == 'PRIORITY'){
                    $('#sortAlgoForPg').find('option[value="PRIORITY"]').prop("selected",true);
                }
                if(jData.policy.fullBackupStartDate) {
                    $('.backupDate').show();
                    $('#fullBackupStartDate').datepicker('setDate', jData.policy.fullBackupStartDate);
                }
                else{
                    $('.backupDate').hide();
                }
                if(jData.policy.fullBackupSchedule){
                    var fullBackupSchedules = jData.policy.fullBackupSchedule.split('|');
                    if(fullBackupSchedules[0]){
                        $('#fullBackupPeriod').find('option[value="'+fullBackupSchedules[0]+'"]').prop("selected",true);
                    }
                    if(fullBackupSchedules[1]){
                        $('#fullBackupHours').timepicker('setTime', fullBackupSchedules[1]);
                    }
                    if(fullBackupSchedules[2]){
                        $('#fullBackupDay').find('option[value="'+fullBackupSchedules[2]+'"]').prop("selected",true);
                    }else{
                        $('.fullBackupDayOption').hide();
                    }
                }
                
                $('#policygroupName').val(jData.policy.policygroupName);
                    $('#schedules').val(jData.policy.scheduleNames);
                    $("#osType").val(jData.policy.osType);
                    
                if(jData.policy.osType == "windows" ){
                        $('.vssContainer').show();
                        $scope.osType = 'windows';
                        $scope.defaultWinFolders = jData.policy.backupFolderPaths;
                        $scope.userExcludedFoldersWindows = jData.policy.userExcludedFolderpaths;
                    }
		else if(jData.policy.osType == "universal" ){
                        $('.vssContainer').show();
                        $scope.osType = 'universal';
                        $scope.defaultUniversalFolders = jData.policy.backupFolderPaths;
                        $scope.userExcludedFoldersUniversal = jData.policy.userExcludedFolderpaths;
                    }
                    else{
                        $scope.osType = 'mac';
                        $scope.defaultMacFolders = jData.policy.backupFolderPaths;
                        $scope.userExcludedFoldersMac = jData.policy.userExcludedFolderpaths;
                    }
                    
                    $('#vssEnabled').attr('disabled', 'disabled');
                    $("#filters").val(jData.policy.filterInclusionName);
                    
                    $('#partialFileSize').val(jData.policy.pftSize);
                    $('#fileChunkableSize').val(jData.policy.fileChunkableSize);
                    $('#dedup').val(jData.policy.dedup);
                    $('#searchAlgoForPg').val(jData.policy.searchAlgoForPg);
                    $('#Blukryptipaddress').val(jData.policy.privacyGatewayMappingElement.privacyGatewayNames);
                
                $('.fullBackupEnabled').find('option[value="false"]').prop("selected",true);
                if(jData.policy.fullBackupEnabled == true){
                    $('.fullBackupEnabled').find('option[value="true"]').prop("selected",true);
                }
                $("#fullBackupStartDate").val(jData.policy.fullBackupStartDate);
                console.log("pft : "+jData.policy.pftEnabled);
                $('#incrementalFileTransfer').find('option[value="false"]').prop("selected",true);
                    $('#incrementalFileTransfer').attr('disabled', 'disabled');
                    $('.partialfileattributerow').addClass('hide');
                    $('#partialFileSize').attr('disabled', 'disabled');
                    $('#fileChunkableSize').attr('disabled', 'disabled');
                if(jData.policy.pftEnabled == '1'){
                    $('#incrementalFileTransfer').find('option[value="true"]').prop("selected",true);
                    $('#incrementalFileTransfer').attr('disabled', 'disabled');
                    $('.partialfileattributerow').removeClass('hide');
                    $('#partialFileSize').removeAttr('disabled', 'disabled');
                    $('#fileChunkableSize').removeAttr('disabled', 'disabled');
                }
                if(jData.policy.networkThrottlingNames.length > 0){
                    $('.networkThrottling').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.networkThrottling').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.dcmEnabled == '1'){
                    $('.dcmEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.dcmEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.compressionEnabled == true){
                    $('.compEnabled').find('option[value="true"]').prop("selected",true);
                    $('#compEnabled').attr('disabled', 'disabled');
                }else{
                    $('.compEnabled').find('option[value="false"]').prop("selected",true);
                    $('#compEnabled').attr('disabled', 'disabled');
                }
                if(jData.policy.shareEnabled == true){
                    $('.shareEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.shareEnabled').find('option[value="false"]').prop("selected",true);
                    $('.highSecureShareEnabled').hide();
                    $('.highSecuredShareOptions').hide();
                    }
                if(jData.policy.highSecureShareEnabled == true){
                    $('.highSecureShareEnabled').find('option[value="true"]').prop("selected",true);
                    
                    $('.expiredDate').find('option[value="true"]').prop("selected",true);
                    $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
                    $('.preventDownloadEnabled').find('option[value="false"]').prop("selected",true);

                    $('.complexPasswordRequired').attr("disabled", true);
                    $('.preventDownloadEnabled').attr("disabled", true);
                    $('.expiredDate').attr("disabled", true);
                }else{
                    $('.highSecureShareEnabled').find('option[value="false"]').prop("selected",true);
                    
                    $('.expiredDate').find('option[value="false"]').prop("selected",true);
                    $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
                    $('.preventDownloadEnabled').find('option[value="true"]').prop("selected",true);

                    $('.complexPasswordRequired').attr("disabled", true);
                    $('.preventDownloadEnabled').attr("disabled", true);
                    $('.expiredDate').attr("disabled", true);
                }

                if(jData.policy.complexPassword == true){
                    $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.complexPasswordRequired').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.allowDownload == true){
                    $('.preventDownloadEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.preventDownloadEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.shareExpireDateEnable == true){
                    $('.expiredDate').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.expiredDate').find('option[value="false"]').prop("selected",true);
                }

               $scope.maxVersions = jData.policy.maxVersions;
                $('#maxVersions').val(jData.policy.maxVersions);
                document.getElementById('switchver').checked=true;
                 $('#switchver').attr('disabled', 'disabled');
                //$('#maxVersions').removeAttr('disabled');
                if(jData.policy.maxVersions == "-1"){
                    document.getElementById('switchver').checked = false;
                    $('#maxVersions').val('UNLIMITED');
                    $('#maxVersions').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                $scope.maxPermissibleFileSize = jData.policy.maxFileSize;
                $('#maxPermissibleFileSize').val(jData.policy.maxFileSize);
                document.getElementById('switchsize').checked=true;
                $('#switchsize').attr('disabled', 'disabled');
                //$('#maxPermissibleFileSize').removeAttr('disabled');
                if(jData.policy.maxFileSize == "1048576"){
                    document.getElementById('switchsize').checked = false;
                    $('#maxPermissibleFileSize').val('UNLIMITED');
                    $('#maxPermissibleFileSize').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                $scope.perUserBackupStorageLimit = jData.policy.userSizeAllowed;
                $('#perUserBackupStorageLimit').val(jData.policy.userSizeAllowed);
                document.getElementById('switchlimit').checked=true;
                $('#switchlimit').attr('disabled', 'disabled');
                //$('#perUserBackupStorageLimit').removeAttr('disabled');
                if(jData.policy.userSizeAllowed == "102400"){
                    document.getElementById('switchlimit').checked = false;
                    $('#perUserBackupStorageLimit').val('UNLIMITED');
                    $('#perUserBackupStorageLimit').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                $('#nwFromClientToPG').val(jData.policy.nwFromClientToPG);
                 document.getElementById('switch').checked=true;
                $('#nwFromClientToPG').attr('disabled', 'disabled');
                $('#switch').attr('disabled', 'disabled');
                if(jData.policy.nwFromClientToPG == "10000"){
                    document.getElementById('switch').checked = false;
                    $('#nwFromClientToPG').val('UNLIMITED');
                    $('#nwFromClientToPG').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }

		$('#nwFromClientToPGMB').val(jData.policy.nwFromClientToPGMB);
                $('#networkThrottlingUnit').find('option[value="mbps"]').prop("selected",true);
                 document.getElementById('switch').checked=true;
                $('#nwFromClientToPGMB').attr('disabled', 'disabled');
                 $('#networkThrottlingUnit').attr("disabled","disabled");
                if(jData.policy.unit == "kbps"){
                    $('#networkThrottlingUnit').find('option[value="kbps"]').prop("selected",true);
                }
                else if(jData.policy.unit == "gbps"){
                    $('#networkThrottlingUnit').find('option[value="gbps"]').prop("selected",true);
                }
                
                if(jData.policy.nwFromClientToPGMB == "UNLIMITED"){
                    document.getElementById('switch').checked = false;
                    $('#nwFromClientToPGMB').val('UNLIMITED');
                    $('#nwFromClientToPGMB').attr('disabled', 'disabled');
                    $('#networkThrottlingUnit').attr("disabled","disabled");
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }

                $scope.cpuUtilization = jData.policy.cpuUtilization;
                $scope.memoryUtilization = jData.policy.memoryUtilization;

                $('#shareEnabled').attr('disabled', 'disabled');
                $('#highSecureShareEnabled').attr('disabled', 'disabled');
                $('#complexPasswordRequired').attr('disabled', 'disabled');
                $('#preventDownloadEnabled').attr('disabled', 'disabled');
                $('#expiredDate').attr('disabled', 'disabled');
                
               $('#exitt').attr('disabled', 'disabled');
                $('#stopbackup').attr('disabled', 'disabled');
                $('#decouple').attr('disabled', 'disabled');
                $('#bkpsettings').attr('disabled', 'disabled');
                $('#support').attr('disabled', 'disabled');
                $('#bkpfiles').attr('disabled', 'disabled');
                $('#initiatebackup').attr('disabled', 'disabled');
                $('#refbkppolicy').attr('disabled', 'disabled');
                $('#restore').attr('disabled', 'disabled');
                
                $scope.osType = jData.policy.osType;
                $('.selectFilterPicker option[value="'+jData.policy.filterInclusionName+'"]').prop('selected', true);
                if(jData.policy.cloudCredential != undefined){
                    $('.selectCcSPicker  option[value="'+jData.policy.cloudCredential+'"]').prop("selected",true);
                }
                
                $scope.updateSelectedFilters(jData.policy.filterInclusionName);
                $scope.updateSelectedScheduleNames(jData.policy.scheduleNames);
                $scope.selectedPolicy = jData.policy;
                $scope.$apply();
                $('#fullBackupStartDate').attr("readonly", true);
                var option = $('#fullBackupEnabled').val();
                if(option == 'true'){
                    $('.backupDate').show();
                    $('#fullBackupStartDate').attr("readonly", true);
                }else{
                    $('.backupDate').hide();
                }
                if(jData.policy.legalHoldEnabled == true){
                    $('#legalHold').attr('checked', 'checked');
                    $('#legalHold').attr('disabled', 'disabled');
                    enableLegalHold();
                    if(jData.policy.backupSystemFilesEnabled == true){
                        $('#systemFolders').attr('checked', 'checked');
                        $('#systemFolders').attr('disabled', 'disabled');
                    }
                }else{
                    $('#legalHold').removeAttr('checked');
                    $('#legalHold').attr('disabled', 'disabled');
                }
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.policyCreate = function(){
        console.log("inside createpolicy");
        var preBackupScripts = getAStringOfElements($scope.preBackup);
        var postBackupScripts = getAStringOfElements($scope.postBackup);
        var preRestoreScripts = getAStringOfElements($scope.preRestore);
        var postRestoreScripts = getAStringOfElements($scope.postRestore);
        var pgList = $('ul.sortable').sortable('toArray');
        var defaultFolders = '';
        var defaultExclusionFolders = '';
        var sameExclusionFolders = '';
        var osType = $('[name="osType"]').val();
        var fullBackupPeriod = getFullBackupPeriod();
    if($('span#sizeerror').text() != "")
        {
            toastr.error('Please check the value for Maximum Permissible File Size  ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if($('span#limiterror').text() != "")
        {
            toastr.error('Please check the value for Per User Backup Storage Limit ', 'Fail!!!', {allowHtml: true});
            return;
        }
    if($('span#switcherror').text() != "")
        {
            toastr.error('Please check the value for Network Throttle Setting from Client to BluKrypt ', 'Fail!!!', {allowHtml: true});
            return;
        }
        if((osType.toLowerCase()).indexOf('windows') > -1){
            if($scope.defaultWinFolders.length >= 1){
                defaultFolders = $scope.defaultWinFolders.join(',^,')+'&pgList=';
                osType = 'windows';
                $scope.defaultWinFolders.forEach(function(value){
                        if($scope.userExcludedFoldersWindows.indexOf(value) > -1){
                            toastr.error('Please check default folders to backup up and excluded folders', 'Fail!!!', {allowHtml: true});
                            sameExclusionFolders = 'false';
                        }
                });
                if(sameExclusionFolders == 'false'){
                    return;
                }
                defaultExclusionFolders = $scope.userExcludedFoldersWindows.join(',^,')+'&pgList=';
            }else{
                toastr.error('Please add at-least one default folders to backup up', 'Fail!!!', {allowHtml: true});
                return;
            }
        }else if(osType == 'universal' ){
            if($scope.defaultUniversalFolders.length >= 1){
                defaultFolders = $scope.defaultUniversalFolders.join(',^,')+'&pgList=';
                osType = 'universal';
                $scope.defaultUniversalFolders.forEach(function(value){
                        if($scope.userExcludedFoldersUniversal.indexOf(value) > -1){
                            toastr.error('Please check default folders to backup up and excluded folders', 'Fail!!!', {allowHtml: true});
                            sameExclusionFolders = 'false';
                        }
                });
                if(sameExclusionFolders == 'false'){
                    return;
                }
                defaultExclusionFolders = $scope.userExcludedFoldersUniversal.join(',^,')+'&pgList=';
            }else{
                toastr.error('Please add at-least one default folders to backup up', 'Fail!!!', {allowHtml: true});
                return;
            }
        }
        else{
            if($scope.defaultMacFolders.length >= 1){
                defaultFolders = $scope.defaultMacFolders.join(',^,')+'&pgList=';
                osType = 'mac';
                $scope.defaultMacFolders.forEach(function(value){
                        if($scope.userExcludedFoldersMac.indexOf(value) > -1){
                            toastr.error('Please check default folders to backup up and excluded folders', 'Fail!!!', {allowHtml: true});
                            sameExclusionFolders = 'false';
                        }
                });
                if(sameExclusionFolders == 'false'){
                    return;
                }
                defaultExclusionFolders = $scope.userExcludedFoldersMac.join(',^,')+'&pgList=';
            }else{
                toastr.error('Please add at-least one default folders to backup up', 'Fail!!!', {allowHtml: true});
                return;
            }
        }
        if(parseInt($('[name="fileChunkableSize"]').val()) > parseInt($('[name="partialFileSize"]').val())){
            toastr.error('Partial File Size should be greater than File Chunkable Size', 'Fail!!!', {allowHtml: true});
            return;
        }
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        console.log($('.policyForm').serialize()+'&defaultFolders='+defaultFolders+'&osTyped='+osType+'&preBackupScripts='+preBackupScripts+'&postBackupScripts='+postBackupScripts+'&preRestoreScripts='+preRestoreScripts+'&postRestoreScripts='+postRestoreScripts+'&fullBackupPeriod='+fullBackupPeriod);
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/policy/save',
            data: $('.policyForm').serialize()+'&defaultFolders='+defaultFolders+'&defaultExclusionFolders='+defaultExclusionFolders+'&osTyped='+osType+'&preBackupScripts='+preBackupScripts+'&postBackupScripts='+postBackupScripts+'&preRestoreScripts='+preRestoreScripts+'&postRestoreScripts='+postRestoreScripts+'&fullBackupPeriod='+fullBackupPeriod,
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.defaultFilter = jData.filters;
                $scope.$apply();
                toastr.success(jData.msg, 'Success!!!', {allowHtml: true});
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/pms/policies';
                }, 3000);
            }else{
                myBlockUI.stop();
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            myBlockUI.stop();
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function getFullBackupPeriod(){
        var period = '';
        var fullBackupPeriod = $('.fullBackupPeriod').val();
        if(fullBackupPeriod){
            if(fullBackupPeriod != 'dd'){
                period = fullBackupPeriod+'|'+$('#fullBackupHours').val()+'|'+$('#fullBackupDay').val()
            }else{
                period = fullBackupPeriod+'|'+$('#fullBackupHours').val()
            }
        }
        return period;
    }

    function getAStringOfElements(obj){
        var data = [];

        if(obj.length < 1){
            return obj;
        }

        obj.forEach(function(value, key){
            var string;
            if(value.scriptArgs != null){
                string = value.scriptName +'|'+ value.scriptArgs.join(',')+'|'+value.backupType;
            }else{
                string = value.scriptName +'||'+value.backupType;
            }
            data.push(string.toString());
        });
        return data.join('^');

    }

    $scope.getPolicy = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/policy',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            console.log(jData);
            if(jData.result == 'success'){
                assignCallOutScripts(jData.policy.calloutScripts);
                jData.policy.scheduleNames.forEach(function(value){
                    $('.selectSchedulePicker option[value="'+value+'"]').prop('selected', true);
                });
                if(jData.policy.privacyGatewayMappingElement.privacyGatewayNames != null)
                        {
                jData.policy.privacyGatewayMappingElement.privacyGatewayNames.forEach(function(value){
                    var $element = $(".blukryptIPAdress").find('option[value="'+value+'"]');
                    $element.detach();
                    $(".blukryptIPAdress").append($element);
                    $(".blukryptIPAdress").trigger("change");
                });
            }
        $('.exitt').find('option[value="false"]').prop("selected",true);
                $('.decouple').find('option[value="false"]').prop("selected",true);
                $('.support').find('option[value="false"]').prop("selected",true);
                $('.initiatebackup').find('option[value="false"]').prop("selected",true);
                $('.restore').find('option[value="false"]').prop("selected",true);
                $('.stopbackup').find('option[value="false"]').prop("selected",true);
                $('.bkpsettings').find('option[value="false"]').prop("selected",true);
                $('.bkpfiles').find('option[value="false"]').prop("selected",true);
                $('.refbkppolicy').find('option[value="false"]').prop("selected",true);
                jData.policy.endpointUiPreferences.forEach(function(value){ 
                if(value === "EXIT"){
                    $('.exitt').find('option[value="true"]').prop("selected",true);
                }
                if(value === "DECOUPLE"){
                    $('.decouple').find('option[value="true"]').prop("selected",true);
                }
                if(value === "SUPPORT"){
                    $('.support').find('option[value="true"]').prop("selected",true);
                }
                if(value === "INTIATE_BACKUP"){
                    $('.initiatebackup').find('option[value="true"]').prop("selected",true);
                }
                if(value === "RESTORE"){
                    $('.restore').find('option[value="true"]').prop("selected",true);
                }
                if(value === "STOP_BACKUP"){
                    $('.stopbackup').find('option[value="true"]').prop("selected",true);
                }
                if(value === "BACKUP_SETTINGS"){
                    $('.bkpsettings').find('option[value="true"]').prop("selected",true);
                }
                if(value === "BACKUP_FILES"){
                    $('.bkpfiles').find('option[value="true"]').prop("selected",true);
                }
                if(value === "REFRESH_BACKUP_POLICY"){
                    $('.refbkppolicy').find('option[value="true"]').prop("selected",true);
                }
                });
                $(".blukryptIPAdress").val("");
                $(".blukryptIPAdress").trigger('change');
                $(".blukryptIPAdress").val(jData.policy.privacyGatewayMappingElement.privacyGatewayNames);
                $(".blukryptIPAdress").trigger('change');
                jData.policy.policyRefresh = jData.policy.policyRefresh.substring(0, jData.policy.policyRefresh.indexOf(':'));
                $('#policyRefresh').val(jData.policy.policyRefresh);
                
                $('#sortAlgoForPg').find('option[value="NEAREST"]').prop("selected",true);
                if(jData.policy.searchAlgoForPg == 'PRIORITY'){
                    $('#sortAlgoForPg').find('option[value="PRIORITY"]').prop("selected",true);
		    $('#Blukryptipaddress').attr('required', 'required');
                }
                if(jData.policy.fullBackupStartDate) {
                    $('.backupDate').show();
                    $('#fullBackupStartDate').datepicker('setDate', jData.policy.fullBackupStartDate);
                }
                else{
                    $('.backupDate').hide();
                }
                if(jData.policy.fullBackupSchedule){
                    var fullBackupSchedules = jData.policy.fullBackupSchedule.split('|');
                    if(fullBackupSchedules[0]){
                        $('#fullBackupPeriod').find('option[value="'+fullBackupSchedules[0]+'"]').prop("selected",true);
                    }
                    if(fullBackupSchedules[1]){
                        $('#fullBackupHours').timepicker('setTime', fullBackupSchedules[1]);
                    }
                    if(fullBackupSchedules[2]){
                        $('#fullBackupDay').find('option[value="'+fullBackupSchedules[2]+'"]').prop("selected",true);
                    }else{
                        $('.fullBackupDayOption').hide();
                    }
                }

                if((jData.policy.osType.toLowerCase()).indexOf('windows') > -1){
                    $('.selectOsTypePicker').find('option[value="windows"]').prop("selected",true);
                    $scope.defaultWinFolders = jData.policy.backupFolderPaths;
                    $scope.userExcludedFoldersWindows = jData.policy.userExcludedFolderpaths;
                    $('.vssContainer').show();
                    if(jData.policy.vssEnabled == '1'){
                        $('.vssEnabled').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('.vssEnabled').find('option[value="false"]').prop("selected",true);
                    }
                }else if(jData.policy.osType == 'universal'){   
                    $('.vssContainer').show();
                    if(jData.policy.vssEnabled == '1'){
                        $('.vssEnabled').find('option[value="true"]').prop("selected",true);
                    }else{
                        $('.vssEnabled').find('option[value="false"]').prop("selected",true);
                    }
                    $('.selectOsTypePicker').find('option[value="universal"]').prop("selected",true);
                    $scope.defaultUniversalFolders = jData.policy.backupFolderPaths;
                    $scope.userExcludedFoldersUniversal = jData.policy.userExcludedFolderpaths;
                }
                else{
                    $('.vssContainer').hide();
                    $('.selectOsTypePicker').find('option[value="mac"]').prop("selected",true);
                    $scope.defaultMacFolders = jData.policy.backupFolderPaths;
                    $scope.userExcludedFoldersMac = jData.policy.userExcludedFolderpaths;
                }
                
                $('.dedup').find('option[value="Disabled"]').prop("selected",true);
                if(jData.policy.dedup == 'User'){
                    $('.dedup').find('option[value="User"]').prop("selected",true);
                }else if(jData.policy.dedup == 'Global'){
                    $('.dedup').find('option[value="Global"]').prop("selected",true);
                }
                $('.fullBackupEnabled').find('option[value="false"]').prop("selected",true);
                if(jData.policy.fullBackupEnabled == true){
                    $('.fullBackupEnabled').find('option[value="true"]').prop("selected",true);
                }
                $("#fullBackupStartDate").val(jData.policy.fullBackupStartDate);
                if(jData.policy.pftEnabled == '1'){
                    $('.incrementalFileTransfer').find('option[value="true"]').prop("selected",true);
                    $('.partialfileattributerow').removeClass('hide');
                    $('#partialFileSize').removeAttr('disabled', 'disabled');
                    $('#fileChunkableSize').removeAttr('disabled', 'disabled');
                }else{
                    $('.incrementalFileTransfer').find('option[value="false"]').prop("selected",true);
                    $('.partialfileattributerow').addClass('hide');
                    $('#partialFileSize').attr('disabled', 'disabled');
                    $('#fileChunkableSize').attr('disabled', 'disabled');
                }
                if(jData.policy.networkThrottlingNames.length > 0){
                    $('.networkThrottling').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.networkThrottling').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.dcmEnabled == '1'){
                    $('.dcmEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.dcmEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.compressionEnabled == true){
                    $('.compEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.compEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.shareEnabled == true){
                    $('.shareEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.shareEnabled').find('option[value="false"]').prop("selected",true);
                    $('.highSecureShareEnabled').hide();
                    $('.highSecuredShareOptions').hide();
                    }
                if(jData.policy.highSecureShareEnabled == true){
                    $('.highSecureShareEnabled').find('option[value="true"]').prop("selected",true);
                    $('.complexPasswordRequired').attr("disabled", true);
                    $('.preventDownloadEnabled').attr("disabled", true);
                    $('.expiredDate').attr("disabled", true);
                    
                    $('.expiredDate').find('option[value="true"]').prop("selected",true);
                    $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
                    $('.preventDownloadEnabled').find('option[value="false"]').prop("selected",true);

                    $('.complexPasswordRequired').selectpicker('refresh');
                    $('.preventDownloadEnabled').selectpicker('refresh');
                    $('.expiredDate').selectpicker('refresh');
                }else{
                    $('.highSecureShareEnabled').find('option[value="false"]').prop("selected",true);
                    $('.complexPasswordRequired').attr("disabled", false);
                    $('.preventDownloadEnabled').attr("disabled", false);
                    $('.expiredDate').attr("disabled", false);
                    
                    $('.expiredDate').find('option[value="false"]').prop("selected",true);
                    $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
                    $('.preventDownloadEnabled').find('option[value="true"]').prop("selected",true);

                    $('.complexPasswordRequired').selectpicker('refresh');
                    $('.preventDownloadEnabled').selectpicker('refresh');
                    $('.expiredDate').selectpicker('refresh');
                }

                if(jData.policy.complexPassword == true){
                    $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.complexPasswordRequired').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.allowDownload == true){
                    $('.preventDownloadEnabled').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.preventDownloadEnabled').find('option[value="false"]').prop("selected",true);
                }
                if(jData.policy.shareExpireDateEnable == true){
                    $('.expiredDate').find('option[value="true"]').prop("selected",true);
                }else{
                    $('.expiredDate').find('option[value="false"]').prop("selected",true);
                }

               // $scope.maxVersions = jData.policy.maxVersions;
               $('#maxVersions').val(jData.policy.maxVersions);
        document.getElementById('switchver').checked=true;
        $('#maxVersions').removeAttr('disabled');
                if(jData.policy.maxVersions == "-1"){
            document.getElementById('switchver').checked = false;
                    $('#maxVersions').val('UNLIMITED');
            $('#maxVersions').attr('disabled', 'disabled');
                }
                //$scope.maxPermissibleFileSize = jData.policy.maxFileSize;
                $('#maxPermissibleFileSize').val(jData.policy.maxFileSize);
        document.getElementById('switchsize').checked=true;
        $('#maxPermissibleFileSize').removeAttr('disabled');
                if(jData.policy.maxFileSize == "1048576"){
            document.getElementById('switchsize').checked = false;
                    $('#maxPermissibleFileSize').val('UNLIMITED');
            $('#maxPermissibleFileSize').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                //$scope.perUserBackupStorageLimit = jData.policy.userSizeAllowed;
                $('#perUserBackupStorageLimit').val(jData.policy.userSizeAllowed);
        document.getElementById('switchlimit').checked=true;
        $('#perUserBackupStorageLimit').removeAttr('disabled');
                if(jData.policy.userSizeAllowed == "102400"){
            document.getElementById('switchlimit').checked = false;
                    $('#perUserBackupStorageLimit').val('UNLIMITED');
            $('#perUserBackupStorageLimit').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }
                $('#nwFromClientToPG').val(jData.policy.nwFromClientToPG);
                 document.getElementById('switch').checked=true;
                $('#nwFromClientToPG').removeAttr('disabled');
                if(jData.policy.nwFromClientToPG == "10000"){
                    document.getElementById('switch').checked = false;
                    $('#nwFromClientToPG').val('UNLIMITED');
                    $('#nwFromClientToPG').attr('disabled', 'disabled');
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }

		$('#nwFromClientToPGMB').val(jData.policy.nwFromClientToPGMB);
                $('#networkThrottlingUnit').find('option[value="mbps"]').prop("selected",true);
                 document.getElementById('switch').checked=true;
                $('#nwFromClientToPGMB').removeAttr('disabled');
                $('#networkThrottlingUnit').removeAttr("disabled","disabled");
                if(jData.policy.unit == "kbps"){
                    $('#networkThrottlingUnit').find('option[value="kbps"]').prop("selected",true);
                }
                else if(jData.policy.unit == "gbps"){
                    $('#networkThrottlingUnit').find('option[value="gbps"]').prop("selected",true);
                }
                
                if(jData.policy.nwFromClientToPGMB == "UNLIMITED"){
                    document.getElementById('switch').checked = false;
                    $('#nwFromClientToPGMB').val('UNLIMITED');
                    $('#nwFromClientToPGMB').attr('disabled', 'disabled');
                    $('#networkThrottlingUnit').attr("disabled","disabled");
                    //$scope.maxPermissibleFileSize = 'UNLIMITED';
                }

                $scope.cpuUtilization = jData.policy.cpuUtilization;
                $scope.memoryUtilization = jData.policy.memoryUtilization;

                $scope.osType = jData.policy.osType;
                $('.selectFilterPicker option[value="'+jData.policy.filterInclusionName+'"]').prop('selected', true);
                if(jData.policy.cloudCredential != undefined){
                    $('.selectCcSPicker  option[value="'+jData.policy.cloudCredential+'"]').prop("selected",true);
                }
                $('.compEnabled').selectpicker('render');
                $('.selectSchedulePicker').selectpicker('render');
                $('.selectOsTypePicker').selectpicker('render');
                $('.incrementalFileTransfer').selectpicker('render');
                $('.dedup').selectpicker('render');
                $('.fullBackupEnabled').selectpicker('render');
                $('.networkThrottling').selectpicker('render');
                $('.dcmEnabled').selectpicker('render');
                $('.vssEnabled').selectpicker('render');
                $('.selectFilterPicker').selectpicker('render');
                $('#fullBackupPeriod').selectpicker('render');
                $('#fullBackupDay').selectpicker('render');
                $('.selectCcSPicker').selectpicker('render');
                $('.shareEnabled').selectpicker('render');
                $('.highSecureShareEnabled').selectpicker('render');
                $('.complexPasswordRequired').selectpicker('render');
                $('.preventDownloadEnabled').selectpicker('render');
                $('.expiredDate').selectpicker('render');
                $scope.updateSelectedFilters(jData.policy.filterInclusionName);
                $scope.updateSelectedScheduleNames(jData.policy.scheduleNames);
                $scope.selectedPolicy = jData.policy;
                $scope.$apply();
                $('#fullBackupStartDate').attr("readonly", true);
                var option = $('#fullBackupEnabled').val();
                if(option == 'true'){
                    $('.backupDate').show();
                    $('#fullBackupStartDate').attr("readonly", true);
                }else{
                    $('.backupDate').hide();
                }
                if(jData.policy.legalHoldEnabled == true){
                    $('#legalHold').attr('checked', 'checked');
                    enableLegalHold();
                    if(jData.policy.backupSystemFilesEnabled == true){
                        $('#systemFolders').attr('checked', 'checked');
                    }
                }else{
                    $('#legalHold').removeAttr('checked');
                }
            }else{
                toastr.error('No Filters has yet been created', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function assignCallOutScripts(scripts){
        if(scripts){
            if(scripts.length >= 1){
                scripts.forEach(function(value, key){
                    var items = value.split("|");
                    var scriptName = items[0];
                    var scriptArgs;
                    var scriptType = items[1];
                    if(items[2]){
                        scriptArgs = items[2].split(",");
                    }
                    var data = {};
                    switch (scriptType){
                        case 'preBackupF':
                            data = {
                                scriptName: scriptName,
                                backupType: 'f',
                                scriptArgs: scriptArgs
                            };
                            if($scope.preBackup.length <= 2){
                                $scope.preBackup.push(data);
                            }
                            break;
                        case 'postBackupF':
                            data = {
                                scriptName: scriptName,
                                backupType: 'f',
                                scriptArgs: scriptArgs
                            };
                            if($scope.postBackup.length <= 2){
                                $scope.postBackup.push(data);
                            }
                            break;
                        case 'preRestoreF':
                            data = {
                                scriptName: scriptName,
                                backupType: 'f',
                                scriptArgs: scriptArgs
                            };
                            if($scope.preRestore.length <= 2){
                                $scope.preRestore.push(data);
                            }
                            break;
                        case 'postRestoreF':
                            data = {
                                scriptName: scriptName,
                                backupType: 'f',
                                scriptArgs: scriptArgs
                            };
                            if($scope.postRestore.length <= 2){
                                $scope.postRestore.push(data);
                            }
                            break;
                        case 'preBackupI':
                            data = {
                                scriptName: scriptName,
                                backupType: 'i',
                                scriptArgs: scriptArgs
                            };
                            if($scope.preBackup.length <= 2){
                                $scope.preBackup.push(data);
                            }
                            break;
                        case 'postBackupI':
                            data = {
                                scriptName: scriptName,
                                backupType: 'i',
                                scriptArgs: scriptArgs
                            };
                            if($scope.postBackup.length <= 2){
                                $scope.postBackup.push(data);
                            }
                            break;
                        case 'preRestoreI':
                            data = {
                                scriptName: scriptName,
                                backupType: 'i',
                                scriptArgs: scriptArgs
                            };
                            if($scope.preRestore.length <= 2){
                                $scope.preRestore.push(data);
                            }
                            break;
                        case 'postRestoreI':
                            data = {
                                scriptName: scriptName,
                                backupType: 'i',
                                scriptArgs: scriptArgs
                            };
                            if($scope.postRestore.length <= 2){
                                $scope.postRestore.push(data);
                            }
                            break;
                        default:
                            break;
                    }

                });
            }
        }
    }

    $scope.updatePolicyMappingList = function(skipValue, userName){
        $scope.searchForUserName = userName;
        var myBlockUI = blockUI.instances.get('myBlockUI');
        if(skipValue == 0){
            myBlockUI.start();
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/policyMapping/single',
            data: {csrf_token: $('.csrf_token').html(), skipValue: skipValue, userName: userName},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(userName != 'all'){
                    $('.loadMore').hide();
                }
                if(skipValue != 0){
                    $scope.userPolicyMappingUsers = $scope.userPolicyMappingUsers.concat(jData.users);
                }else{
                    if(jData.users.length <= 0){
                        if(skipValue == 0){
                            toastr.info('There was no users found for the provided username', 'Information!!!', {allowHtml: true});
                        }
                    }else{
                        $scope.userPolicyMappingUsers = jData.users;
                    }
                }
                $scope.userPolicyMappingPolicies = jData.policies;
                $scope.skipValue = skipValue+1;
                $scope.$apply();
                if(jData.users.length > 0){
                    if(userName == 'all' || userName == ''){
                        if($scope.userPolicyMappingUsers.length < 200){
                            $scope.updatePolicyMappingList($scope.skipValue, userName);
                        }else{
                            $('.loadMore').show();
                        }
                    }
                }else{
                    if(skipValue != 0) {
                        //toastr.info('All users has been loaded successfully', 'Information!!!', {allowHtml: true});
                        $('.loadMore').hide();
                    }
                }
                $('.userPolicyMappingListTable').show();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateServerPolicyMappingList = function(skipValue, userName){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        if(skipValue == 0){
            myBlockUI.start();
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/policyMapping/server/single',
            data: {csrf_token: $('.csrf_token').html(), skipValue: skipValue, userName: userName},
            type: 'POST'
        }).done(function(data){
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(skipValue != 0){
                    $scope.userPolicyMappingUsers = $scope.userPolicyMappingUsers.concat(jData.users);
                }else{
                    if(jData.users.length <= 0){
                        if(skipValue == 0){
                            toastr.info('There was no servers found for the provided server name', 'Information!!!', {allowHtml: true});
                        }
                    }else{
                        $scope.userPolicyMappingUsers = jData.users;
                    }
                }
                $scope.userPolicyMappingPolicies = jData.policies;
                $scope.skipValue = skipValue+1;
                $scope.$apply();
                if(jData.users.length > 0){
                    if(userName == 'all' || userName == ''){
                        if($scope.userPolicyMappingUsers.length < 200){
                            $scope.updatePolicyMappingList($scope.skipValue, userName);
                        }
                    }
                }else{
                    if(skipValue != 0) {
                        //toastr.info('All servers has been loaded successfully', 'Information!!!', {allowHtml: true});
                    }
                }
                $('.userPolicyMappingListTable').show();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.showMappingList = function(userName){
        $('.mappingRow'+userName+' .policyName span').hide();
        $('.mappingRow'+userName+' .policyName form').show();
        $('.mappingRow'+userName+' .action .edit').hide();
        $('.mappingRow'+userName+' .action .save').show();
        $('.mappingRow'+userName+' .action .cancel').show();
        var value = $('.mappingRow'+userName+' .policyName span').html();
        $('#userPolicyMappingPolicyName option[value="'+value+'"]').prop('selected', true);
    };

    $scope.cancelChangePolicy = function(userName){
        $('.mappingRow'+userName+' .policyName span').show();
        $('.mappingRow'+userName+' .policyName form').hide();
        $('.mappingRow'+userName+' .action .edit').show();
        $('.mappingRow'+userName+' .action .save').hide();
    };

    $scope.changePolicy = function(userName,oldPolicyName){
        var userName = userName;
        var oldPolicyName = oldPolicyName;
        var name = 'userPolicyMappingPolicyName'+userName;
        var newPolicyName = $('[name='+name+']').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/policyMapping/single/save',
            data: {csrf_token: $('.csrf_token').html(), userName: userName, oldPolicyName: oldPolicyName, newPolicyName: newPolicyName},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.updatePolicyMappingList(0, 'all');
                $scope.$apply();
                $('.mappingRow'+userName+' .policyName span').show();
                $('.mappingRow'+userName+' .policyName form').hide();
                $('.mappingRow'+userName+' .action .edit').show();
                $('.mappingRow'+userName+' .action .save').hide();
                toastr.success('User Policy has been successfully mapped', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.changeServerPolicy = function($index){
        var deviceUUID = $('.mappingRow'+$index+' .deviceUUID').html();
        var oldPolicyName = $scope.userPolicyMappingUsers[$index].policyName;
        var newPolicyName = $('[name="userPolicyMappingPolicyName'+$index+'"]').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/policyMapping/server/save',
            data: {csrf_token: $('.csrf_token').html(), deviceUUID: deviceUUID, oldPolicyName: oldPolicyName, newPolicyName: newPolicyName},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.userPolicyMappingUsers[$index].policyName = newPolicyName;
                $scope.$apply();
                $('.mappingRow'+$index+' .policyName span').show();
                $('.mappingRow'+$index+' .policyName form').hide();
                $('.mappingRow'+$index+' .action .edit').show();
                $('.mappingRow'+$index+' .action .save').hide();
                toastr.success('Device Policy has been successfully mapped', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.changeMultiplePolicy = function(){
        var multiplePolicyName = $('[name="multiplePolicyName"]').selectpicker('val');
        var html = $('.pmsSavePolicyBtn').html();
        $('.pmsSavePolicyBtn').attr('disabled','disabled');
        $('.pmsicyBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        if(multiplePolicyName && $('#userNames').val()){
            var userNames = $('#userNames').val();
            userNames = userNames.replace(/\s/g,'');
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/policyMapping/multiple/save',
                data: {csrf_token: $('.csrf_token').html(), userNames: userNames, policyName: multiplePolicyName},
                type: 'POST'
            }).done(function(data){
                $('.pmsSavePolicyBtn').removeAttr('disabled');
                $('.pmsSavePolicyBtn').html(html);
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success('User Policy has been successfully mapped', 'Success!!!', {allowHtml: true});
                    $('#userNames').val("");
                    setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/pms/policyMapping/single';
                }, 3000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(!$('#userNames').val()){
                toastr.info('Please select users', 'Information!!!', {allowHtml: true});
                $('.pmsSavePolicyBtn').removeAttr('disabled');
            }else{
                toastr.info('Please select a Policy', 'Information!!!', {allowHtml: true});
                $('.pmsSavePolicyBtn').removeAttr('disabled');
            }
        }
    };

    $scope.changeMultipleServerPolicy = function(){
        var multiplePolicyName = $('[name="multiplePolicyName"]').selectpicker('val');

        if(multiplePolicyName && $('#deviceNames').val()){
            var deviceNames = $('#deviceNames').val().join(',');
            $.ajax({
                url: $scope.BASE_FOLDER+'/pms/policyMapping/server/save',
                data: {csrf_token: $('.csrf_token').html(), deviceUUID: deviceNames, newPolicyName: multiplePolicyName},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success('Policy has been successfully mapped', 'Success!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(!$('#userNames').val()){
                toastr.info('Please select a Server Name', 'Information!!!', {allowHtml: true});
            }else{
                toastr.info('Please select a Policy', 'Information!!!', {allowHtml: true});
            }
        }
    };

    $scope.getBluvault = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/bluvault',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.bluvaults != null){
                    $scope.bluvaults = jData.bluvaults;
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.saveBluvault = function(bluvault){
        bluvault.replace("https://", '');
        bluvault.replace("http://", '');
        if(checkIfExistsInBluvault($scope.bluvaults, bluvault)){
            toastr.info('Bluvault has already been added', 'Information!!!', {allowHtml: true});
            return;
        }
        var html = $('.submitBluvault').html();
        $('.submitBluvault').attr('disabled','disabled');
        $('.submitBluvault').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/bluvault/save',
            data: {csrf_token: $('.csrf_token').html(), bluvault: bluvault},
            type: 'POST'
        }).done(function(data){
            $('.submitBluvault').html(html);
            $('.submitBluvault').removeAttr('disabled','disabled');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.getBluvault();
                $('#addParacloud').modal('hide');
                toastr.success('Bluvault has been successfully Added', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                ConfirmAddBluvault(bluvault);
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    function ConfirmAddBluvault(bluvault){
        $('#addParacloudConfirm').modal('show');
        $('#confbluvault').val(bluvault);
    }
    
    $scope.ConfirmAdd = function(bluvault){
        bluvault.replace("https://", '');
        bluvault.replace("http://", '');
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/bluvault/confirmSave',
            data: {csrf_token: $('.csrf_token').html(), bluvault: bluvault},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.getBluvault();
                $('#addParacloudConfirm').modal('hide');
                $('#addParacloud').modal('hide');
                toastr.success('Bluvault has been successfully Added', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeBluvault = function(bluvaultId, bluVaultName, key){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/bluvault/delete',
            data: {csrf_token: $('.csrf_token').html(), bluvaultId: bluvaultId, bluVaultName:bluVaultName},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.bluvaults.splice(key, 1);
                toastr.success('Bluvault has been successfully removed', 'Success!!!', {allowHtml: true});
                setTimeout(function(){
                window.location.reload();
                }, 3000);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getBlukrypts = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/getAllBlukrypts',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.blukrypts != null){
                    $scope.blukrypts = jData.blukrypts;
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.editBlukrypts = function(number){
        var index = number;
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/getAllBlukrypts',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.blukrypts != null){
                    $('#addBlukrypt').modal('show');
                    $('#add_title').addClass("hide");
                    $('#edit_title').addClass("show");
                    var type = jData.blukrypts[index]['type'];
                    var productType11 = jData.blukrypts[index]['productType'];
                    $('#blukryptIP').val(jData.blukrypts[index]['gatewayName']);
                    $('#blukryptEdit').find('option[value="'+type+'"]').prop("selected",true);
                    $('#productEdit').find('option[value="'+productType11+'"]').prop("selected",true);
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeBluKrypt = function(bluKrypt, key){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/blukrypt/remove',
            data: {csrf_token: $('.csrf_token').html(), bluKrypt: bluKrypt},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.blukrypts.splice(key, 1);
                toastr.success('BluKrypt has been successfully removed', 'Success!!!', {allowHtml: true});
                setTimeout(function(){
                window.location.reload();
                }, 3000);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.saveBlukrypt = function(){
        var blukryptType = $('[name="blukryptEdit"]').val();
        var productType = $('[name="productEdit"]').val();
        blukrypt = $('#blukryptIP').val();
        blukrypt = blukrypt.replace("https://", '');
        blukrypt = blukrypt.replace("http://", '');
        if(checkIfExistsInBlukrypt($scope.blukrypts, blukrypt, blukryptType, productType)){
            toastr.info('Blukrypt has already been added', 'Information!!!', {allowHtml: true});
            return;
        }
        var html = $('.submitBlukrypt').html();
        $('.submitBlukrypt').attr('disabled','disabled');
        $('.submitBlukrypt').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/blukrypt/save',
            data: {csrf_token: $('.csrf_token').html(), blukrypt: blukrypt, blukryptType: blukryptType,productType: productType},
            type: 'POST'
        }).done(function(data){
            $('.submitBlukrypt').html(html);
            $('.submitBlukrypt').removeAttr('disabled','disabled');
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('#edit_title').removeClass("show");
                $('#add_title').removeClass("hide");
                $('#addBlukrypt').modal('hide');
                $('[name="blukrypt"]').val('');
                $scope.getBlukrypts();
                toastr.success('Blukrypt has been successfully Added', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                ConfirmAddBlukryptModal(blukrypt,blukryptType,productType);
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    function ConfirmAddBlukryptModal(blukrypt,blukryptType,productType){
        $('#addBlukryptConfirm').modal('show');
        $('#confblukrypt').val(blukrypt);
        $('#confblukryptEdit').val(blukryptType);
        $('#confproductEdit').val(productType);
    }
    
    $scope.ConfirmAddBlukrypt = function(){
        var blukryptType = $('[name="confblukryptEdit"]').val();
        var productType = $('[name="confproductEdit"]').val();
        blukrypt = $('#confblukrypt').val();
        blukrypt = blukrypt.replace("https://", '');
        blukrypt = blukrypt.replace("http://", '');
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/blukrypt/confirmSave',
            data: {csrf_token: $('.csrf_token').html(), blukrypt: blukrypt, blukryptType: blukryptType,productType: productType},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('#addBlukryptConfirm').modal('hide');
                $('#addBlukrypt').modal('hide');
                $('[name="blukryptIP"]').val('');
                $scope.getBlukrypts();
                toastr.success('Blukrypt has been successfully Added', 'Success!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.setThrottlingLimit = function(blukrypt){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/throttling/save',
            data: $('.throttlingForm').serialize(),
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.reload();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeThrottlingLimit = function(id){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/throttling/remove',
            data: {csrf_token: $('.csrf_token').html(), id: id},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.reload();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.openScript = function(scriptType){
        $scope.scriptType = scriptType;
        $('.addScript').modal('show');
    };

    $scope.addAScript = function(){
        $scope.tempScriptName = $('[name="scriptName"]').val();
        $scope.tempScriptArgs = $('#scriptArgs').val();
        $scope.tempBackupType = $('#backupType').val();

        if($scope.tempScriptName.length >= 1){

            var data = {
                scriptName : $scope.tempScriptName,
                backupType : $scope.tempBackupType,
                scriptArgs : $scope.tempScriptArgs
            };
            switch($scope.scriptType) {
                case 'preBackup':
                    if($scope.preBackup.length <= 2){
                        $scope.preBackup.push(data);
                        toastr.success('Script has been added successfully', 'Successfully', {allowHtml: true});
                    }else{
                        toastr.error('Only 2 Scripts can be executed pre backup', 'Fail!!!', {allowHtml: true});
                    }
                    break;
                case 'postBackup':
                    if($scope.postBackup.length <= 2){
                        $scope.postBackup.push(data);
                        toastr.success('Script has been added successfully', 'Successfully', {allowHtml: true});
                    }else{
                        toastr.error('Only 2 Scripts can be executed post backup', 'Fail!!!', {allowHtml: true});
                    }
                    break;
                case 'preRestore':
                    if($scope.preRestore.length <= 2){
                        $scope.preRestore.push(data);
                        toastr.success('Script has been added successfully', 'Successfully', {allowHtml: true});
                    }else{
                        toastr.error('Only 2 Scripts can be executed pre restore', 'Fail!!!', {allowHtml: true});
                    }
                    break;
                case 'postRestore':
                    if($scope.postRestore.length <= 2){
                        $scope.postRestore.push(data);
                        toastr.success('Script has been added successfully', 'Successfully', {allowHtml: true});
                    }else{
                        toastr.error('Only 2 Scripts can be executed post restore', 'Fail!!!', {allowHtml: true});
                    }
                    break;
                default:
                    toastr.error('Did not match any of the script type, please try again after some time.', 'Fail!!!', {allowHtml: true});
                    break;
            }
            $('[name="scriptName"]').val('');
            $('#scriptArgs').val(null).trigger("change");
            $('.addScript').modal('hide');
        }else{
            toastr.error('Please enter a script Name', 'Fail!!!', {allowHtml: true});
        }
    };

    $scope.removeScript = function(scriptType, index){
        switch(scriptType) {
            case 'preBackup':
                if($scope.preBackup.length <= 2){
                    $scope.preBackup.splice(index, 1);
                    toastr.success('Script has been removed successfully', 'Successfully', {allowHtml: true});
                }else{
                    toastr.error('Selected script was not found', 'Fail!!!', {allowHtml: true});
                }
                break;
            case 'postBackup':
                if($scope.postBackup.length <= 2){
                    $scope.postBackup.splice(index, 1);
                    toastr.success('Script has been removed successfully', 'Successfully', {allowHtml: true});
                }else{
                    toastr.error('Selected script was not found', 'Fail!!!', {allowHtml: true});
                }
                break;
            case 'preRestore':
                if($scope.preRestore.length <= 2){
                    $scope.preRestore.splice(index, 1);
                    toastr.success('Script has been removed successfully', 'Successfully', {allowHtml: true});
                }else{
                    toastr.error('Selected script was not found', 'Fail!!!', {allowHtml: true});
                }
                break;
            case 'postRestore':
                if($scope.postRestore.length <= 2){
                    $scope.postRestore.splice(index, 1);
                    toastr.success('Script has been removed successfully', 'Successfully', {allowHtml: true});
                }else{
                    toastr.error('Selected script was not found', 'Fail!!!', {allowHtml: true});
                }
                break;
            default:
                toastr.error('Did not match any of the script type, please try again after some time.', 'Fail!!!', {allowHtml: true});
                break;
        }
    };

    function checkIfExistsInBluvault(bluvaults, bluvault){
        var result = false;
        if(bluvaults.length > 0){
            bluvaults.forEach(function(value, key){
                if(value.bluVaultName == bluvault){
                    result = true;
                }
            });
        }
        return result;
    }

    function checkIfExistsInBlukrypt(blukrypts, blukrypt, type){
        var result = false;
        if(blukrypts.length > 0) {
            blukrypts.forEach(function (value, key) {
                if (value.gatewayName == blukrypt && value.type == type) {
                    result = true;
                }
            });
        }
        return result;
    }

    function enableLegalHold(){
        $scope.maxVersions = $('#maxVersions').val();
        $scope.maxPermissibleFileSize = $('#maxPermissibleFileSize').val();
        $scope.perUserBackupStorageLimit = $('#perUserBackupStorageLimit').val();
        $scope.cpuUtilization = $('#cpuUtilization').val();
        $scope.memoryUtilization = $('#memoryUtilization').val();
        $scope.currentDefaultWinFolders = $scope.defaultWinFolders;
        $scope.currentDefaultMacFolders = $scope.defaultMacFolders;
        $scope.currentDefaultUniversalFolders = $scope.defaultUniversalFolders;
        $scope.defaultWinFolders = ['ALL'];
        $scope.defaultMacFolders = ['ALL'];
        $scope.defaultUniversalFolders = ['ALL'];
        $scope.$apply();
        $('.allFilters').hide();
        document.getElementById('switchver').checked = false;
        $('#switchver').attr('disabled', 'disabled');
        $('#maxVersions').val('UNLIMITED');
        $('#maxVersions').attr('readonly', 'readonly');
        $('#maxVersions').removeAttr('data-parsley-type','integer');
        $('#maxVersions').removeAttr('data-parsley-min','1');

        document.getElementById('switchsize').checked= false;
        $('#switchsize').attr('disabled', 'disabled');
        $('#maxPermissibleFileSize').val('UNLIMITED');
        $('#maxPermissibleFileSize').attr('readonly', 'readonly');
        $('#maxPermissibleFileSize').removeAttr('data-parsley-type','integer');
        $('#maxPermissibleFileSize').removeAttr('data-parsley-min','1');

        document.getElementById('switchlimit').checked= false;
        $('#switchlimit').attr('disabled', 'disabled');
        $('#perUserBackupStorageLimit').val('UNLIMITED');
        $('#perUserBackupStorageLimit').attr('readonly', 'readonly');
        $('#perUserBackupStorageLimit').removeAttr('data-parsley-type','integer');
        $('#perUserBackupStorageLimit').removeAttr('data-parsley-min','1');

        $('#cpuUtilization').val(100);
        $('#cpuUtilization').attr('readonly', 'readonly');
        $('#cpuUtilization').removeAttr('data-parsley-min','20');
        $('#cpuUtilization').removeAttr('data-parsley-max','100');

        $('#memoryUtilization').val(1024);
        $('#memoryUtilization').attr('readonly', 'readonly');
        $('#memoryUtilization').removeAttr('data-parsley-min','20');
        $('#memoryUtilization').removeAttr('data-parsley-max','100');

        $('#defaultFoldersBackup').attr('disabled', 'disabled');
        $('.defaultFoldersBackupBtn').attr('disabled', 'disabled');
        
        $('#exclusionFolderName').attr('disabled', 'disabled');
        $('.exclusionFoldersBtn').attr('disabled', 'disabled');

        $('.systemFolders').show();
    }

    function disableLegalHold(){
        if($scope.maxVersions <= 0){
            $scope.maxVersions = 1
        }
        if($scope.maxPermissibleFileSize <= 0){
            $scope.maxPermissibleFileSize = 1024
        }
        if($scope.perUserBackupStorageLimit <= 0){
            $scope.perUserBackupStorageLimit = 10
        }
        if($scope.machineMaxThreshold <= 0){
            $scope.machineMaxThreshold = 80
        }
        $('.allFilters').show();
        document.getElementById('switchver').checked = false;
        $('#switchver').removeAttr('disabled', 'disabled');
        $('#maxVersions').val('UNLIMITED');
        $('#maxVersions').removeAttr('readonly');
        $('#maxVersions').attr('data-parsley-type','integer');
        $('#maxVersions').attr('data-parsley-min','1');

        document.getElementById('switchsize').checked= false;
        $('#switchsize').removeAttr('disabled', 'disabled');
        $('#maxPermissibleFileSize').val('UNLIMITED');
        $('#maxPermissibleFileSize').removeAttr('readonly');
        $('#maxPermissibleFileSize').attr('data-parsley-type','integer');
        $('#maxPermissibleFileSize').attr('data-parsley-min','1');

        document.getElementById('switchlimit').checked= false;
        $('#switchlimit').removeAttr('disabled', 'disabled');
        $('#perUserBackupStorageLimit').val('UNLIMITED');
        $('#perUserBackupStorageLimit').removeAttr('readonly');
        $('#perUserBackupStorageLimit').attr('data-parsley-type','integer');
        $('#perUserBackupStorageLimit').attr('data-parsley-min','1');

        $('#machineMaxThreshold').val($scope.machineMaxThreshold);
        $('#machineMaxThreshold').removeAttr('readonly');
        $('#machineMaxThreshold').attr('data-parsley-type','integer');
        $('#machineMaxThreshold').attr('data-parsley-min','20');
        $('#machineMaxThreshold').attr('data-parsley-max','100');

        $('#defaultFoldersBackup').removeAttr('disabled');
        $('.defaultFoldersBackupBtn').removeAttr('disabled');
        
        $('#exclusionFolderName').removeAttr('disabled');
        $('.exclusionFoldersBtn').removeAttr('disabled');

        $('.systemFolders').hide();
        $('#systemFolders').removeAttr('checked');
        if($scope.currentDefaultWinFolders != 'ALL' && $scope.currentDefaultMacFolders != 'ALL' && $scope.currentDefaultUniversalFolders != 'ALL'){
            $scope.defaultWinFolders = $scope.currentDefaultWinFolders;
            $scope.defaultMacFolders = $scope.currentDefaultMacFolders;
            $scope.defaultUniversalFolders = $scope.currentDefaultUniversalFolders;
        }else{
            $scope.defaultWinFolders = ['c:\\', 'd:\\'];
            $scope.defaultMacFolders = ['/users/', '/home/'];
            $scope.defaultUniversalFolders = ['/users/', '/home/', 'c:\\', 'd:\\'];
        }
        $scope.$apply();
    }

    $scope.redirectTo = function(url){
        window.location = url;
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');

        if($scope.currentPage == 'schedule'){
            $scope.getSchedules();
        }

        if($scope.currentPage == 'filter'){
            $scope.getFilters();
        }

        if($scope.currentPage == 'policy'){
            $scope.getPolices();
        }

        if($scope.currentPage == 'editPolicy'){
            $scope.getPolicy();
            if($scope.userExcludedFoldersWindows.isNull()){
              document.getElementById('noFolders').innerHTML = "There are no folders to be excluded";
            }
            if($scope.userExcludedFoldersMac.isNull()){
              document.getElementById('noFolders').innerHTML = "There are no folders to be excluded";
            }
            if($scope.userExcludedFoldersUniversal.isNull()){
              document.getElementById('noFolders').innerHTML = "There are no folders to be excluded";
            }
        }
        
        if($scope.currentPage == 'clonePolicy'){
            $scope.getPolicy();
        }

        if($scope.currentPage == 'singlePolicyMapping'){
            $scope.updatePolicyMappingList(0, 'all');
        }

        if($scope.currentPage == 'singleServerPolicyMapping'){
            $scope.updateServerPolicyMappingList(0, 'all');
        }

        if($scope.currentPage == 'paracloudblukrypt'){
            $scope.getBluvault();
            $scope.getBlukrypts();
        }

        if($scope.currentPage == 'blukrypts'){
            $scope.getBlukrypts();
        }

        $('#legalHold').on('change', function(){
            var checked = document.getElementById('legalHold').checked;
            if(checked){
                enableLegalHold();
            }else{
                disableLegalHold();
            }
        });

    });

}]);
