/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('HistoryController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', function($scope, toastr, $http, $ngBootbox, blockUI,BASE_FOLDER) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();
    $scope.sortReverse = true;
    $scope.sortType = 'endTimeLong';
    $scope.summary = {};
    $scope.history = '';
    $scope.historyDetails = '';
    $scope.pageNumber = 0;
    $scope.limitNumber = 500;
    $scope.audits = [];
    $scope.historyDetailsType = '';
    $scope.skipValue = 0;

    $scope.updateDeviceBackupHistory = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/backupHistory',
            data: {secret: '',csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            $('.deviceHistoryTable').show();
            var jData = JSON.parse(data);
            $scope.summary.completedPercentage      = jData.summary.completedPercentage;
            $scope.summary.totalNoOfFiles           = jData.summary.totalNoOfFiles;
            $scope.summary.noOfFilesToBeUploaded    = jData.summary.noOfFilesToBeUploaded;
            if(jData.history.length > 0){
                $scope.history = jData.history;
            }else{
                $('.deviceHistoryTable').hide();
                $('.loading').show();
                $('.loading').html('There is no history of backup...!');
            }
            $scope.$apply();
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.showHistoryDetails = function(batchId, type, count){
        if(count != '0' && count != '0 (0 %)' ){
            blockUI.start();
            $scope.historyDetailsType = type;
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/backupHistoryDetails',
                data: {batchId: batchId, csrf_token: $('.token').html()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                $('.loading').hide();
                $('.deviceHistoryDetailsTable').show();
                if(jData.historyDetails != null){
                    $scope.historyDetails = jData.historyDetails;
                }else{
                    $('.deviceHistoryDetailsTable').hide();
                    $('.loading').show();
                    $('.loading').html('There is no details for the selected backup history...');
                }
                $scope.$apply();
                $('.backupHistoryDetailsModal').modal('show');
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.info('There are no files to show details about', 'Information!!!', {allowHtml: true});
        }
    };

    $scope.updateBackupActivityDetails = function(rows, pbAuditUserName, pbAuditDeviceName, pageNumber){
        $.ajax({
            url: $scope.BASE_FOLDER+'/activityHistory',
            data: {
                rows: rows,
                pbAuditUserName: pbAuditUserName,
                pbAuditDeviceName: pbAuditDeviceName,
                pageNumber: pageNumber,
                csrf_token: $('.csrf_token').html()
            },
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.audits.length > 0){
                    if(pageNumber == 0){
                        $scope.audits = jData.audits;
                    }else{
                        $scope.audits = $scope.audits.concat(jData.audits);
                    }
                    if($scope.audits.length < $scope.limitNumber && rows != 5){
                        $scope.pageNumber = pageNumber+1;
                        $scope.updateBackupActivityDetails(rows, pbAuditUserName, pbAuditDeviceName, $scope.pageNumber);
                    }
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateShareActivityHistory = function(skipValue){
        var html = $('.loadMoreBtn').html();
        $('.loadMoreBtn').attr('disabled','disabled');
        $('.loadMoreBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            url: $scope.BASE_FOLDER+'/share/activityHistory',
            data: {csrf_token: $('.csrf_token').html(), skipValue: skipValue},
            type: 'POST'
        }).done(function(data){
            $('.loadMoreBtn').removeAttr('disabled');
            $('.loadMoreBtn').html(html);
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                console.log(jData.audits.length);
                if(jData.audits.length > 0){
                    if(skipValue == 0){
                        $scope.audits = jData.audits;
                    }else{
                        $scope.audits = $scope.audits.concat(jData.audits);
                    }
                    $scope.skipValue = ($scope.skipValue+1);
                    $scope.$apply();
                    $('.loadMore').show();
                }else{
                    $('.status').show();
                    $('.loadMore').hide();
                }

            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'shareActivityHistory'){
            blockUI.start();
            $scope.updateShareActivityHistory();
        }
        if($scope.currentPage == 'deviceBackupHistory'){
            blockUI.start();
            $scope.updateDeviceBackupHistory();
        }
        if($scope.currentPage == 'backupActivityHistory'){
            blockUI.start();
            $scope.updateBackupActivityDetails(100, '', '', 0);
        }
        if($scope.currentPage == 'dashboard'){
            blockUI.start();
            $scope.updateBackupActivityDetails(5, '', '', 0);
        }
    });

}]);

app.filter('filterStatusType', function(){
    return function(data, type){
        var filtered = [];
        if(type){
            for (var i = 0; i < data.length; i++){
                var value = data[i];
                if(value.status == type){
                    filtered.push(value);
                }
            }
            return filtered;
        }else{
            return data;
        }
    }
});
