<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/**
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Class User
 * @package Models
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Pms extends Model{

    /**
     * Constructing the parent
     */
    public function __construct(){
        parent::__construct();
        $this->log('Policy Management Model Model was called', 'info');
    }

    /**
     * Below Method gets a schedule
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSchedule($headers){
        $url = $this->api->getUrl('getSchedule');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all schedules
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSchedules($headers){
        $url = $this->api->getUrl('getSchedules');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveCloudCredentials($headers, $data){
        $url = $this->api->getUrl('saveCloudCredentials');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function removeCloudCredentials($headers){
        $url = $this->api->getUrl('removeCloudCredentials');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getCloudCredentials($headers){
        $url = $this->api->getUrl('getCloudCredentials');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFilters($headers){
        $url = $this->api->getUrl('getFilters');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @param $filterName
     * @return array
     */
    public function getFilter($headers, $filterName){
        $url = $this->api->getUrl('getFilter', array('filterName' => $filterName));
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all schedules
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveSchedule($headers, $data){
        $url = $this->api->getUrl('saveSchedule');
        KLogger::req($url,$headers,$data);
        $this->log('url: '. $url, 'info');
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all Filters
     *
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveFilter($headers, $data){
        $url = $this->api->getUrl('saveFilter');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllPolicies($headers){
        $url = $this->api->getUrl('getAllPolices');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getPgs($headers){
        $url = $this->api->getUrl('getPgs');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all Policies
     *
     * @param $headers
     * @param $data
     * @return array
     */
    public function savePolicy($headers, $data){
        $url = $this->api->getUrl('savePolicy');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);

        $this->log('Url: '.$url, 'info');
        $this->log('Headers: '.json_encode($headers), 'info');
        $this->log('Data: '.$data, 'info');

        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @param $policyName
     * @return array
     */
    public function getPolicy($headers, $policyName){
        $url = $this->api->getUrl('getPolicy', array('policyName' => $policyName));
        KLogger::req($url,$headers,$policyName);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getPolicyMappingDetails($headers){
        $this->log('Post Data: '. json_encode($headers),'info');
        KLogger::req($url,$headers,$data);
        $url = $this->api->getUrl('policyMappingDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function searchPolicyMapping($headers){
        $url = $this->api->getUrl('searchPolicyMapping');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getServerPolicyMappingList($headers){
        $url = $this->api->getUrl('getServerPolicyMapping');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveSinglePolicyMapping($headers, $data){
        $url = $this->api->getUrl('saveSinglePolicyMapping');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @return array
     */
    public function saveMultiplePolicyMapping($headers){
        $url = $this->api->getUrl('saveMultiplePolicyMapping');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @return array
     */
    public function saveServerPolicyMapping($headers){
        $url = $this->api->getUrl('saveServerPolicyMapping');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @return array
     */
    public function getBluvaults($headers){
        $url = $this->api->getUrl('getBluvaults');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveBluvault($headers, $data){
        $url = $this->api->getUrl('saveBluvault');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @return array
     */
    public function saveBlukrypt($headers){
        $url = $this->api->getUrl('saveBlukrypt');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @return array
     */
    public function deleteBluvault($headers){
        $url = $this->api->getUrl('deleteBluvault');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @return array
     */
    public function deleteBluKrypt($headers){
        $url = $this->api->getUrl('deleteBlukrypts');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @return array
     */
    public function getPgLists($headers){
        $url = $this->api->getUrl('getPgLists');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @param $pgName
     * @return array
     */
    public function getNTList($headers, $pgName){
        $url = $this->api->getUrl('getNTList');
        KLogger::req($url,$headers,$pgName);
        $this->curl->setHeaders($headers);
        $this->curl->get($url.$pgName.DS.'networkThrottlings');
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveThrottlingLimit($headers, $data){
        $url = $this->api->getUrl('saveThrottlingLimit');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @return array
     */
    public function removeThrottlingLimit($headers){
        $url = $this->api->getUrl('removeThrottlingLimit');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $bluvault
     * @return array
     */
    public function checkForBluVaultInstallation($bluvault){
        $this->curl->setTimeout(10);
        $this->curl->get(PROTOCOL.$bluvault.DS.'paracloud'.DS.'ping'.DS);
        KLogger::req($this->curl->get(PROTOCOL.$bluvault.DS.'paracloud'.DS.'ping'.DS),$headers,$bluvault);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log(json_encode($bluvault), 'info');
        $this->log(json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Get All Blukrypts
     *
     * @param $headers
     * @return array
     */
    public function getAllBlukrypts($headers){
        $url = $this->api->getUrl('getAllBlukrypts');
        KLogger::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $bluKrypt
     * @return array
     */
    public function checkForBluKryptInstallation($bluKrypt){
        $this->curl->setTimeout(10);
        $this->curl->get(PROTOCOL.$bluKrypt.DS.'BluKryptBuilder'.DS.'ping'.DS);
        KLogger::req($this->curl->get(PROTOCOL.$bluKrypt.DS.'BluKryptBuilder'.DS.'ping'.DS),$headers,$bluKrypt);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log(json_encode($bluKrypt), 'info');
        $this->log(json_encode($result), 'info');
        KLogger::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

}
