<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Url;
use Models\Storage;
use Helpers\Auth;
use Helpers\JWT;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class StorageController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    public $accessToken;
    public $authToken;
    public $refreshToken;
    public $userName;
    public $ODFBCode;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->language->load('storage');
        $this->_model = new Storage();
    }

    /**
     * Define Index page title and load template files
     */
    public function googleOAuth(){
        if(!empty($_GET['code'])){
            $this->userName = !empty($_GET['state']) ? $_GET['state'] : $this->session->get('userName');
            $headers = array(
                'Content-Type' => 'application/x-www-form-urlencoded'
            );
            $data = "code=".$_GET['code']."&client_id=".GOOGLE_CLIENT_ID."&client_secret=".GOOGLE_SECRET_KEY."&redirect_uri=".Url::basePath(GOOGLE_RESOURCE_URI.'/')."&grant_type=authorization_code";
            $result = $this->_model->getGoogleRefreshToken(GOOGLE_TOKEN_URL, $headers, $data);
            if($result['status'] !== 200){
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', !empty($result['body']->error_description) ? $result['body']->error_description : 'There was no token passed from google drive please restart the cloud authentication process');
                Url::redirect('user/settings/'.$this->session->get('userName'));
                exit;
            }
            $this->accessToken = $result['body']->access_token;
            $this->authToken = $result['body']->id_token;
            $this->refreshToken = $result['body']->refresh_token;
            $userInfoResult = $this->_model->getUserInfoFromGoogle(GOOGLE_USER_INFO_URL.$result['body']->access_token);
            if($userInfoResult['status'] !== 200){
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', !empty($result['body']->error_description) ? $result['body']->error_description : 'Could not get the user email address details please restart the cloud authentication process');
                Url::redirect('user/settings/'.$this->session->get('userName'));
                exit;
            }
            $gdData = array(
                'accessToken' => $this->accessToken,
                'authenticationToken' => $this->authToken,
                'refreshToken' => $this->refreshToken,
                'cloudStorageType' => 'Google Drive',
                'clientId' => GOOGLE_CLIENT_ID,
                'clientSecret' => GOOGLE_SECRET_KEY,
                'redirectUri' => Url::basePath(GOOGLE_RESOURCE_URI.'/'),
                'emailId' => $userInfoResult['body']->emails[0]->value
            );

            $paraHeaders = array(
                'Content-Type' => 'application/json',
                'userName' => $this->userName
            );
            $result = $this->_model->saveAuthCredentials($paraHeaders, json_encode($gdData));

            if($result['status'] == 200){
                $this->session->put('storageResult', 'success');
                $this->session->put('storageMessage', 'Google drive has been successfully selected as the storage place');
                Url::redirect('user/settings/'.$this->session->get('userName'));
                exit;
            }else{
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', 'Due to some technical issues could not complete the cloud selection process, Error Code - '.$result['status']);
                Url::redirect('user/settings/'.$this->session->get('userName'));
                exit;
            }

        }else{
            $this->session->put('storageResult', 'error');
            $this->session->put('storageMessage', 'Could not get the authentication code from google please restart the cloud authentication process');
            Url::redirect('user/settings/'.$this->session->get('userName'));
            exit;
        }
    }

    public function odb(){
        if(!empty($_GET['code'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token')
            );
            $odbResult = $this->_model->getOdbDetails($headers);

            $this->ODFBCode = $_GET['code'];
            $this->userName = !empty($_GET['state']) ? $_GET['state'] : $this->session->get('userName');
            $redirectUri = !empty(LOCAL_ODB_REDIRECT_URI) ? LOCAL_ODB_REDIRECT_URI : 'https://api-app.parablu.com/';

            $result = $this->_model->getOneDriveAuthToken($odbResult["body"]->{"clientTokenURL"}, $odbResult["body"]->{"clientId"}, $redirectUri, urlencode($odbResult["body"]->{"clientSecretKey"}), $this->ODFBCode);
            $resultData = json_decode($result['body']);
            $this->log('ODB Result'. json_encode($result), 'info');
            if($result['status'] !== 200){
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', !empty($result['body']->error_description) ? $result['body']->error_description : 'There was no token passed from the selected cloud Storage please restart the cloud authentication process');
                Url::redirect('user/settings/'.$this->session->get('userName'));
                exit;
            }

            $this->accessToken 	= $resultData->access_token;
            $this->authToken    = $resultData->id_token;
            $this->refreshToken = $resultData->refresh_token;

            $jwtMsg = JWT::decode($this->accessToken, $odbResult["body"]->{"clientSecretKey"}, false);

            $odData = array(
                'accessToken' => $this->accessToken,
                'authenticationToken' => $this->authToken,
                'refreshToken' => $this->refreshToken,
                'cloudStorageType' => 'Office365',
                'clientId' => $odbResult["body"]->{"clientId"},
                'sharePointUrl' => $odbResult["body"]->{"clientResourceURL"},
                'clientSecret' => urldecode(urlencode($odbResult["body"]->{"clientSecretKey"})),
                'redirectUri' => urldecode(urlencode($redirectUri)),
                'emailId' => $this->session->get('emailId'),
                'accountId' =>$jwtMsg->unique_name,
		'serviceAccount' => true
            );

            $paraHeaders = array(
                'Content-Type' => 'application/json',
                'userName' => $this->userName
            );

            $result = $this->_model->saveAuthCredentials($paraHeaders, json_encode($odData));

            if($result['status'] == 200){
                $this->session->put('storageResult', 'success');
                $this->session->put('storageMessage', 'One Drive for Business has been successfully selected as the storage place');
                Url::redirect('user/settings/'.$this->session->get('userName'));
                exit;
            }else{
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', 'Due to some technical issues could not complete the cloud selection process, Error Code - '.$result['status']);
                Url::redirect('user/settings/'.$this->session->get('userName'));
                exit;
            }

        }else{
            $this->session->put('storageResult', 'error');
            $this->session->put('storageMessage', 'Could not get the authentication code from OneDrive for Business please restart the cloud authentication process');
            Url::redirect('user/settings/'.$this->session->get('userName'));
            exit;
        }
    }

    public function odbrelogin(){
        $userName       = $_GET['uName'];
        $email          = $_GET['uEmail'];
        if(!empty($userName) && !empty($email)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->getOdbDetails($headers);
            $this->session->put('emailId', $email);
            $params = "?resource=".$result["body"]->{"clientResourceURL"}."&client_id=".$result["body"]->{"clientId"}."&response_type=code&redirect_uri=".$result["body"]->{"clientRedirectURI"}."&state=".$userName;
            $MODBUrl = API_APP_URL.$params."&user=".$userName."&sourceURI=".\Helpers\Url::basePath();
            Url::redirect($MODBUrl, true);
        }else{
            Url::redirect('404');
        }
    }

}
