<?php

namespace Controllers;

use Core\Language;
use Core\View;
use Core\Controller;
use Helpers\Url;
use Models\History;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class HistoryController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('history');
        $this->_model = new History();
        $this->verifyAndCleanItUp();
    }

    public function backupHistory($userName, $deviceUUID){
        $this->auth->checkLoggedInUser($userName);
        $this->session->put('currentDeviceUUID', $deviceUUID);
        $this->session->put('currentUser', $userName);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('device'),
            'crumb2' => $this->language->get('device_backup_history'),
            'currentUser' => $userName,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('history/deviceBackupHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getBackupHistory(){
        if(empty($_POST) && !empty($this->session->get('currentDeviceUUID'))){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $headers = array(
            'token'         => $this->session->get('token'),
            'userName'      => $this->session->get('currentUser'),
            'deviceUUID'    => $this->session->get('currentDeviceUUID')
        );

        $result = $this->_model->userDeviceBackupHistory($headers);
        switch ($result['status']) {
            case (200):
                if(!empty($result['header']['totalNoOfFiles'])){
                    $totalNoOfFiles = $result['header']['totalNoOfFiles'];
                    $filesBackedUp = $totalNoOfFiles - $result['header']['noOfFilesToBeUploaded'];
                    $completedPercentage = round(($filesBackedUp / $totalNoOfFiles) * 100).'%';
                }elseif(($result['header']['totalNoOfFiles'] < $result['header']['noOfFilesToBeUploaded'])) {
                    $totalNoOfFiles = 'Problem with Data';
                    $completedPercentage = 'Problem with Data';
                }elseif($result['header']['totalNoOfFiles'] == 0){
                    $totalNoOfFiles = '0';
                    $completedPercentage = 'N/A';
                }else{
                    $totalNoOfFiles = 'No Backup is initiated';
                    $completedPercentage = 'No Backup is initiated';
                }
                if(($result['header']['totalNoOfFiles'] < $result['header']['noOfFilesToBeUploaded'])) {
                    $noOfFilesToBeUploaded = 'Problem with Data';
                }elseif(!empty($result['header']['noOfFilesToBeUploaded'])){
                    $noOfFilesToBeUploaded = $result['header']['noOfFilesToBeUploaded'];
                }elseif($result['header']['noOfFilesToBeUploaded'] == 0){
                    $noOfFilesToBeUploaded = '0';
                }else{
                    $noOfFilesToBeUploaded = 'No Backup is initiated';
                }

                $summary = array(
                    'completedPercentage' => $completedPercentage,
                    'totalNoOfFiles' => $totalNoOfFiles,
                    'noOfFilesToBeUploaded' => $noOfFilesToBeUploaded
                );

                $history = [];
                if(!empty($result['body']->backupActivityHistoryElementList)){
                    foreach($result['body']->backupActivityHistoryElementList as $value){
                        $totalFiles = $value->noOfFilesBackedup + $value->noOfFilesFailed;
                        if($value->noOfFilesFailed > 0){
                            $percentage = ' ('.round(($value->noOfFilesBackedup / $totalFiles) * 100).' %)';
                        }else{
                            $percentage = ' (100 %)';
                        }
                        $his = array(
                            'startTime' => $value->startTime,
                            'endTime' => $value->endTime,
			    'startTimeLong' => $value->startTimeLong,
			    'endTimeLong' => $value->endTimeLong,
                            'totalFile' => $totalFiles,
                            'percentage' => $value->noOfFilesBackedup.$percentage,
                            'failed' => $value->noOfFilesFailed,
                            'batchId' => $value->batchId,
                            'comments' => $value->comments
                        );

                        $history = array_merge(array($his), $history);

                    }
                }

                $response = array(
                    'result' => 'success',
                    'summary' => $summary,
                    'history' => array_reverse($history)
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function getBackupHistoryDetails(){
        if(!empty($_POST) && !empty($_POST['batchId'])){
            $headers = array(
                'token'         => $this->session->get('token'),
                'userName'      => $this->session->get('userName'),
                'batchId'      => $_POST['batchId']
            );
            $result = $this->_model->userDeviceBackupHistoryDetails($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'historyDetails' => $result['body']->backupHistoryFileElementList
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function activityHistory(){
        $data = array(
            'title' => $this->language->get('history'),
            'crumb1' => $this->language->get('activityHistory'),
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('history/backupActivityHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getActivityHistory(){
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $headers = array(
            'token'         => $this->session->get('token'),
            'pbAuditUserName'      => $_POST['pbAuditUserName'],
            'pbAuditDeviceName'      => $_POST['pbAuditDeviceName'],
            'pageNumber'      => $_POST['pageNumber'],
            'rows'      => $_POST['rows']
        );

        if($this->session->get('admin') != true){
            $headers['userName'] = $this->session->get('userName');
            $headers['pbAuditUserName'] = $this->session->get('userName');
        }

        $result = $this->_model->getBackupActivityHistory($headers);

        switch ($result['status']) {
            case (200):

                $audits = [];

                if(!empty($result['body']->{'audit'})){
                    foreach($result['body']->{'audit'} as $value){

                        if(strpos(strtolower((string)$value->{'action'}), 'deleted') !== false || strpos(strtolower((string)$value->{'action'}), 'decoupled') !== false){
                            $color = 'info';
                        }elseif(strpos(strtolower((string)$value->{'action'}), 'migration') !== false){
                            $color = 'indigo';
                        }elseif(strpos(strtolower((string)$value->{'action'}), 'logged') !== false){
                            $color = 'deeporange';
                        }else{
                            $color = 'lime';
                        }

                        $audit = array(
                            'action' => (string)$value->{'action'},
                            'actionByUser' => (string)$value->{'action-by-user'},
                            'actionOnObject' => (string)$value->{'action-on-object'},
                            'actionUsingObject' => (string)$value->{'action-using-object'},
                            'additionalInfo' => (string)$value->{'additionalInfo'},
                            'auditId' => (string)$value->{'audit-id'},
                            'folder' => (string)$value->{'folder'},
                            'timestampInLong' => (int)$value->{'timestampInLong'},
                            'time' => date('d-M-y H:i:s', (((int)$value->{'timestampInLong'}) / 1000)),
                            'color' => $color
                        );

                        $audits = array_merge(array($audit), $audits);
                    }
                }

                $response = array(
                    'result' => 'success',
                    'audits' => array_reverse($audits)
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function shareActivityHistory(){
        $data = array(
            'title' => $this->language->get('history'),
            'crumb1' => $this->language->get('activityHistory'),
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('history/shareActivityHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getShareActivityHistory(){
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }

        $headers = array(
            'token'             => $this->session->get('token'),
            'shareWithInOrg'    => "false",
            'skipValue'         => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
            'encrypted'         => 'false'
        );

        if(SHARE_WITHIN_ORG){
            $headers['shareWithInOrg'] = "true";
        }

        $result = $this->_model->getShareActivityHistory($headers);
        $this->log('ShareActivity History '. json_encode($headers), 'info');
        switch ($result['status']) {
            case (200):

                $audits = [];
                $color = 'lime';
                if(!empty($result['body']->{'sharedFileImageHistoryElementList'})){
                    foreach($result['body']->{'sharedFileImageHistoryElementList'} as $value){

                        if($color == 'lime'){
                            $color = 'deeporange';
                        }elseif($color == 'deeporange'){
                            $color = 'indigo';
                        }elseif($color == 'indigo'){
                            $color = 'info';
                        }elseif($color == 'info'){
                            $color = 'lime';
                        }

                        $audit = array(
                            'color' => $color,
                            'ip' => (string)$value->{'ip'},
                            'osType' => (string)$value->{'osType'},
                            'accessType' => (string)$value->{'accessType'},
                            'browser' => (string)$value->{'browser'},
                            'accessTimeStamp' => date('d-M-y H:i:s', (((int)$value->{'accessTimeStamp'}) / 1000)),
                            'devicePath' => (string)$value->{'devicePath'},
                            'fileName' => (string)$value->{'fileName'},
                            'cloudName' => (int)$value->{'cloudName'}
                        );

                        $audits = array_merge(array($audit), $audits);
                    }
                }

                $response = array(
                    'result' => 'success',
                    'audits' => array_reverse($audits)
                );
                echo json_encode($response);
                exit;
            case (204):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('noContent')
                );
                echo json_encode($result);
                exit();
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function exportActivityHistoryToExcel(){
        if(!empty($_POST)){

            if(empty($_POST['allAdmins']) && empty($_POST['userNames'])){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Please select a user to generate an excel file'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }

            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
            $numberDays = intval($timeDiff/86400) + 1;

            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }

            if($numberDays > 16){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Activity History can only be generated for 15 days at once'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }

            $headers = array(
                'token'          => $this->session->get('token'),
                'adminName'      => $this->session->get('userName'),
                'isAdmin'        => !empty($_POST['allAdmins']) ? 'true' : 'false',
                'startDate'      => $fromDate,
                'endDate'        => $toDate,
                'userName'       => !empty($_POST['userNames']) ? $_POST['userNames'] : ''
            );
            $result = $this->_model->exportActivityHistoryToExcel($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('exportActivityHistoryToExcel'),
                        'fileName' => !empty($_POST['userNames']) ? $_POST['userNames'] : 'admin'
                    );
                    echo json_encode($response);
                    exit;
                case (432):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('432')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function downloadExportActivityHistoryToExcel($fileName){
        $filePath = OVERVIEW_REPORT_PATH.'Audit_Overview_'.$this->session->get('userName').'.xls';
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=Audit_Overview_'.$this->session->get('userName').'.xls');
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
            unlink($filePath);
        }else{
            header('Location: '.Url::basePath('/report/'.$_GET['from'].'?result=404'));
        }
    }

    public function exportShareActivityHistoryToExcel(){
        if(!empty($_POST)){

            if(empty($_POST['allAdmins']) && empty($_POST['userNames'])){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Please select a user to generate an excel file'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }

            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
            $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
            $numberDays = intval($timeDiff/86400) + 1;

            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }

            if($numberDays > 16){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Activity History can only be generated for 15 days at once'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }

            $headers = array(
                'token'          => $this->session->get('token'),
                'adminName'      => $this->session->get('userName'),
                'isAdmin'        => !empty($_POST['allAdmins']) ? 'true' : 'false',
                'startDate'      => $fromDate,
                'endDate'        => $toDate,
                'shareWithInOrg' => "false",
                'timeZone' => $_POST['timeZone'],
                'userName'       => !empty($_POST['userNames']) ? $_POST['userNames'] : ''
            );

            if(SHARE_WITHIN_ORG){
                $headers['shareWithInOrg'] = "true";
            }
            $this->log(json_encode($headers), 'info');
            $result = $this->_model->exportShareActivityHistoryToExcel($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('exportActivityHistoryToExcel'),
                        'fileName' => !empty($_POST['userNames']) ? $_POST['userNames'] : 'admin'
                    );
                    echo json_encode($response);
                    exit;
                case (432):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('432')
                    );
                    echo json_encode($result);
                    exit();
                case (204):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('noContent')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function downloadExportShareActivityHistoryToExcel($fileName){
        $this->log("I am here", "info");
        $filePath = OVERVIEW_REPORT_PATH.'Share_Audit_Overview_'.$this->session->get('userName').'.xls';
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=Share_Audit_Overview_'.$this->session->get('userName').'.xls');
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
            unlink($filePath);
        }else{
            header('Location: '.Url::basePath('/report/'.$_GET['from'].'?result=404'));
        }
    }

}
